/*
 * Decompiled with CFR 0.152.
 */
package airport;

import airport.AirportInfo;
import airport.AirportInfoCheckBox;
import airport.AirportInfoComboBox;
import airport.AirportInfoLabelledTextField;
import airport.AirportInfoPanel;
import airport.AirportLoginInfoDialog;
import airport.AirportPhoneNumberPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;

public class AirportModemConfigPanel
extends AirportInfoPanel
implements ActionListener {
    private AirportPhoneNumberPanel phoneNumberPanel;
    private AirportLoginInfoDialog loginDialog;
    private AirportInfoLabelledTextField modemTimeoutField;
    private AirportInfoComboBox tonePulseDialingBox;
    private AirportInfoCheckBox automaticDialingCheckbox;
    private JButton loginButton;
    private AirportInfo theInfo;

    public AirportModemConfigPanel(AirportInfo theInfo) {
        this.theInfo = theInfo;
        this.phoneNumberPanel = new AirportPhoneNumberPanel(theInfo);
        this.loginButton = new JButton("Username/Password");
        this.loginButton.setActionCommand("show login panel");
        this.loginButton.addActionListener(this);
        this.modemTimeoutField = new AirportInfoLabelledTextField("Modem timeout (seconds)", theInfo.get("moID"));
        this.tonePulseDialingBox = new AirportInfoComboBox("Tone or pulse (rotary) dialing", theInfo.get("moPD"));
        this.tonePulseDialingBox.addItemAndValue("Tone", "00");
        this.tonePulseDialingBox.addItemAndValue("Pulse", "01");
        this.automaticDialingCheckbox = new AirportInfoCheckBox("Automatic dialing", theInfo.get("moAD"), "01", "00");
        this.setUpDisplay();
    }

    public void setUpDisplay() {
        GridBagLayout theLayout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 0;
        c.ipadx = 0;
        c.ipady = 0;
        c.insets = new Insets(2, 10, 2, 10);
        c.anchor = 10;
        c.weightx = 0.5;
        c.weighty = 0.5;
        this.setLayout(theLayout);
        c.gridwidth = 2;
        c.anchor = 10;
        c.gridx = 1;
        c.gridy = 1;
        theLayout.setConstraints(this.phoneNumberPanel, c);
        this.add(this.phoneNumberPanel);
        c.gridwidth = 1;
        c.anchor = 17;
        c.gridx = 2;
        c.gridy = 2;
        theLayout.setConstraints(this.loginButton, c);
        this.add(this.loginButton);
        c.gridwidth = 1;
        c.gridx = 2;
        c.gridy = 3;
        theLayout.setConstraints(this.automaticDialingCheckbox, c);
        this.add(this.automaticDialingCheckbox);
        c.gridheight = 1;
        c.gridx = 1;
        c.gridy = 2;
        theLayout.setConstraints(this.modemTimeoutField, c);
        this.add(this.modemTimeoutField);
        c.gridx = 1;
        c.gridy = 3;
        theLayout.setConstraints(this.tonePulseDialingBox, c);
        this.add(this.tonePulseDialingBox);
    }

    public void actionPerformed(ActionEvent theEvent) {
        String command = theEvent.getActionCommand();
        if (command.equals("show login panel")) {
            Container owner = this;
            while (owner != null && !(owner instanceof Frame)) {
                owner = owner.getParent();
            }
            Frame owningFrame = (Frame)owner;
            this.loginDialog = new AirportLoginInfoDialog(owningFrame, "Login Information", true, this.theInfo);
            this.loginDialog.pack();
            Dimension dim = this.loginDialog.getSize();
            dim.height += 20;
            dim.width += 20;
            ((Component)this.loginDialog).setSize(dim);
            this.loginDialog.show();
        }
    }
}

