/*
 * Decompiled with CFR 0.152.
 */
package airport;

import airport.AirportInfo;
import airport.AirportInfoPanel;
import airport.AirportInfoRecord;
import airport.ValueFormatException;
import java.awt.Dimension;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;

public class AirportLoginStringTable
extends AirportInfoPanel {
    private AirportInfo airportInfo;
    private Vector tableContentsVector;
    private JTable table;
    private JScrollPane tableScrollPane;
    private AbstractTableModel tableModel;
    private JComboBox elementTypeComboBox;
    private final int MAX_NUM_LOGIN_STRING_ENTRIES = 20;

    public AirportLoginStringTable(AirportInfo airportInfo) {
        this.airportInfo = airportInfo;
        this.tableContentsVector = new Vector();
        this.elementTypeComboBox = new JComboBox();
        this.elementTypeComboBox.addItem("");
        this.elementTypeComboBox.addItem("Expect string");
        this.elementTypeComboBox.addItem("Send string");
        this.elementTypeComboBox.addItem("Delay (seconds)");
        this.setUpDisplay();
    }

    private void setUpDisplay() {
        this.refreshDisplay();
    }

    public void writeValue() throws ValueFormatException {
        TableCellEditor editor = this.table.getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        int i = 0;
        while (i < this.tableContentsVector.size()) {
            block13: {
                String elementTypeString = (String)((Object[])this.tableContentsVector.elementAt(i))[0];
                String elementValueString = (String)((Object[])this.tableContentsVector.elementAt(i))[1];
                boolean carriageReturnFlag = (Boolean)((Object[])this.tableContentsVector.elementAt(i))[2];
                if (!elementTypeString.equals("")) {
                    try {
                        if (elementTypeString.equals("Expect string") || elementTypeString.equals("Send string")) {
                            int startByte = elementTypeString.equals("Expect string") ? -128 : (elementTypeString.equals("Send string") ? 64 : 0);
                            startByte = (byte)(startByte + elementValueString.length());
                            if (carriageReturnFlag) {
                                startByte = (byte)(startByte + 1);
                            }
                            outStream.write(startByte);
                            byte[] valueBytes = elementValueString.getBytes();
                            try {
                                outStream.write(valueBytes);
                            }
                            catch (IOException iOException) {}
                            if (carriageReturnFlag) {
                                outStream.write(13);
                            }
                            break block13;
                        }
                        if (elementTypeString.equals("Delay (seconds)")) {
                            int delayValue = Integer.parseInt(elementValueString);
                            outStream.write((byte)(192 + delayValue));
                            if (delayValue < 0 || delayValue > 63) {
                                this.table.editCellAt(i, 1);
                                throw new ValueFormatException("Delay must be between 0 and 63 seconds");
                            }
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.table.editCellAt(i, 1);
                        throw new ValueFormatException("Bad delay value");
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        throw new ValueFormatException("Login string too long (maximum size 127 characters)");
                    }
                }
            }
            ++i;
        }
        byte[] bytes = outStream.toByteArray();
        AirportInfoRecord modemUsernameRecord = this.airportInfo.get("moUN");
        modemUsernameRecord.setValue(bytes);
        AirportInfoRecord modemPasswordRecord = this.airportInfo.get("moPW");
        modemPasswordRecord.setValue(new byte[0]);
        AirportInfoRecord pppoeUsernameRecord = this.airportInfo.get("peUN");
        pppoeUsernameRecord.setValue(bytes);
        AirportInfoRecord pppoePasswordRecord = this.airportInfo.get("pePW");
        pppoePasswordRecord.setValue(new byte[0]);
    }

    public void refreshDisplay() {
        AirportInfoRecord modemUsernameRecord = this.airportInfo.get("moUN");
        byte[] loginBytes = modemUsernameRecord.getValue();
        int currentPosition = 0;
        block4: while (currentPosition < loginBytes.length) {
            int typeAndLength = loginBytes[currentPosition];
            ++currentPosition;
            if (typeAndLength < 0) {
                typeAndLength += 256;
            }
            int length = typeAndLength % 64;
            int type = typeAndLength - length;
            switch (type) {
                case 192: {
                    Object[] addressEntry = new Object[]{"Delay (seconds)", Integer.toString(length), new Boolean(false)};
                    this.tableContentsVector.insertElementAt(addressEntry, this.tableContentsVector.size());
                    continue block4;
                }
                case 64: 
                case 128: {
                    boolean crFlag;
                    String valueString = new String(loginBytes);
                    valueString = valueString.substring(currentPosition, currentPosition + length);
                    if (loginBytes[(currentPosition += length) - 1] == 13) {
                        valueString = valueString.substring(0, length - 1);
                        crFlag = true;
                    } else {
                        crFlag = false;
                    }
                    Object[] addressEntry = new Object[3];
                    addressEntry[1] = valueString;
                    addressEntry[2] = new Boolean(crFlag);
                    addressEntry[0] = type == 64 ? "Send string" : "Expect string";
                    this.tableContentsVector.insertElementAt(addressEntry, this.tableContentsVector.size());
                    continue block4;
                }
            }
        }
        this.removeAll();
        this.tableModel = new LoginStringTableModel();
        this.table = new JTable(this.tableModel);
        this.table.setCellSelectionEnabled(true);
        this.table.getColumn("Element type").setCellEditor(new DefaultCellEditor(this.elementTypeComboBox));
        this.table.setPreferredScrollableViewportSize(new Dimension(300, 150));
        this.tableScrollPane = new JScrollPane(this.table);
        this.add(this.tableScrollPane);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.table.setEnabled(enabled);
    }

    private class LoginStringTableModel
    extends AbstractTableModel {
        public int getColumnCount() {
            return 3;
        }

        public int getRowCount() {
            return 20;
        }

        public boolean isCellEditable(int row, int col) {
            if (row <= AirportLoginStringTable.this.tableContentsVector.size()) {
                if (col < 2) {
                    return true;
                }
                if (row == AirportLoginStringTable.this.tableContentsVector.size()) {
                    return false;
                }
                Object[] currentRow = (Object[])AirportLoginStringTable.this.tableContentsVector.elementAt(row);
                return ((String)currentRow[0]).equals("Send string") || ((String)currentRow[0]).equals("Expect string");
            }
            return false;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "Element type";
                }
                case 1: {
                    return "Value";
                }
            }
            return "Carriage return";
        }

        public Class getColumnClass(int column) {
            String stringDummy = "";
            Boolean booleanDummy = new Boolean(true);
            switch (column) {
                case 0: {
                    return stringDummy.getClass();
                }
                case 1: {
                    return stringDummy.getClass();
                }
            }
            return booleanDummy.getClass();
        }

        public Object getValueAt(int row, int col) {
            if (row < AirportLoginStringTable.this.tableContentsVector.size()) {
                return ((Object[])AirportLoginStringTable.this.tableContentsVector.elementAt(row))[col];
            }
            if (col < 2) {
                return "";
            }
            return new Boolean(false);
        }

        public void setValueAt(Object newValue, int row, int col) {
            if (row < AirportLoginStringTable.this.tableContentsVector.size()) {
                Object[] addressEntry = (Object[])AirportLoginStringTable.this.tableContentsVector.elementAt(row);
                addressEntry[col] = newValue;
                if (col == 0 && ((String)newValue).equals("Delay (seconds)")) {
                    addressEntry[2] = new Boolean(false);
                    this.fireTableCellUpdated(row, 2);
                }
            } else {
                Object[] addressEntry = new Object[]{"", "", new Boolean(false)};
                addressEntry[col] = newValue;
                AirportLoginStringTable.this.tableContentsVector.insertElementAt(addressEntry, AirportLoginStringTable.this.tableContentsVector.size());
            }
            this.fireTableCellUpdated(row, col);
        }

        LoginStringTableModel() {
        }
    }
}

