/*
 * Decompiled with CFR 0.152.
 */
package airport;

import airport.AirportInfoComponent;
import airport.AirportInfoRecord;
import airport.ValueFormatException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JRadioButton;

public class AirportInfoRadioButton
extends JRadioButton
implements AirportInfoComponent {
    private Vector theRecords = new Vector();

    public AirportInfoRadioButton(String label) {
        super(label);
    }

    public AirportInfoRadioButton(String label, AirportInfoRecord theRecord, String selectedValue) {
        super(label);
        this.addInfoRecord(theRecord, selectedValue);
    }

    public void addInfoRecord(AirportInfoRecord theRecord, String selectedValue) {
        RecordSettings recordSettings = new RecordSettings();
        recordSettings.theRecord = theRecord;
        recordSettings.selectedValue = selectedValue;
        this.theRecords.insertElementAt(recordSettings, this.theRecords.size());
        this.refreshDisplay();
    }

    public void refreshDisplay() {
        boolean selected = true;
        Enumeration elements = this.theRecords.elements();
        while (elements.hasMoreElements()) {
            RecordSettings nextSettings = (RecordSettings)elements.nextElement();
            String currentValue = nextSettings.theRecord.toString();
            String selectedValue = nextSettings.selectedValue;
            try {
                int selectedInt = Integer.parseInt(selectedValue, 16);
                int currentInt = nextSettings.theRecord.dataType == 4 ? Integer.parseInt(currentValue, 10) : Integer.parseInt(currentValue, 16);
                if (currentInt == selectedInt) continue;
                selected = false;
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Radio button " + this.getLabel() + ", number format exception");
                selected = false;
            }
        }
        this.setSelected(selected);
    }

    public void writeValue() throws ValueFormatException {
        boolean selected = this.isSelected();
        if (selected) {
            Enumeration elements = this.theRecords.elements();
            while (elements.hasMoreElements()) {
                RecordSettings nextSettings = (RecordSettings)elements.nextElement();
                nextSettings.writeValue();
            }
        }
    }

    private class RecordSettings {
        public AirportInfoRecord theRecord;
        public String selectedValue;

        public void writeValue() throws ValueFormatException {
            this.theRecord.setBytesFromString(this.selectedValue);
        }

        RecordSettings() {
        }
    }
}

