/*
 * Decompiled with CFR 0.152.
 */
package airport;

import airport.AirportInfoComponent;
import airport.AirportInfoRecord;
import airport.ValueFormatException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JCheckBox;

public class AirportInfoCheckBox
extends JCheckBox
implements AirportInfoComponent {
    private Vector theRecords = new Vector();

    public AirportInfoCheckBox(String label) {
        super(label);
    }

    public AirportInfoCheckBox(String label, AirportInfoRecord theRecord, String selectedValue, String unselectedValue) {
        super(label);
        this.addInfoRecord(theRecord, selectedValue, unselectedValue);
    }

    public void addInfoRecord(AirportInfoRecord theRecord, String selectedValue, String unselectedValue) {
        RecordSettings recordSettings = new RecordSettings();
        recordSettings.theRecord = theRecord;
        recordSettings.selectedValue = selectedValue;
        recordSettings.unselectedValue = unselectedValue;
        this.theRecords.insertElementAt(recordSettings, this.theRecords.size());
        this.refreshDisplay();
    }

    public void refreshDisplay() {
        boolean selected = true;
        Enumeration elements = this.theRecords.elements();
        while (elements.hasMoreElements()) {
            RecordSettings nextSettings = (RecordSettings)elements.nextElement();
            String currentValue = nextSettings.theRecord.toString();
            String selectedValue = nextSettings.selectedValue;
            try {
                int selectedInt = Integer.parseInt(selectedValue, 16);
                int currentInt = nextSettings.theRecord.dataType == 4 ? Integer.parseInt(currentValue, 10) : Integer.parseInt(currentValue, 16);
                if (currentInt == selectedInt) continue;
                selected = false;
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Checkbox " + this.getLabel() + ", number format exception");
                selected = false;
            }
        }
        this.setSelected(selected);
    }

    public void writeValue() throws ValueFormatException {
        boolean selected = this.isSelected();
        Enumeration elements = this.theRecords.elements();
        while (elements.hasMoreElements()) {
            ((RecordSettings)elements.nextElement()).writeValue(selected);
        }
    }

    private class RecordSettings {
        public AirportInfoRecord theRecord;
        public String selectedValue;
        public String unselectedValue;

        public void writeValue(boolean selected) throws ValueFormatException {
            if (selected) {
                this.theRecord.setBytesFromString(this.selectedValue);
            } else {
                this.theRecord.setBytesFromString(this.unselectedValue);
            }
        }

        RecordSettings() {
        }
    }
}

