/*
 * Decompiled with CFR 0.152.
 */
package airport;

import airport.AirportInfo;
import airport.AirportInfoCheckBox;
import airport.AirportInfoLabelledTextField;
import airport.AirportInfoPanel;
import airport.AirportInfoRadioButton;
import airport.ValueFormatException;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;

public class AirportBridgingPanel
extends AirportInfoPanel {
    private AirportInfoRadioButton transparentBridgeButton;
    private AirportInfoRadioButton natButton;
    private ButtonGroup radioButtonGroup;
    private AirportInfoPanel natInfoPanel;
    private AirportInfoCheckBox natOnEthernetCheckbox;
    private AirportInfoCheckBox disableBridgingCheckbox;
    private AirportInfoLabelledTextField natInboundPrivateAddressBase;
    private AirportInfoLabelledTextField natInboundPrivateAddressMask;
    private AirportInfo theInfo;

    public AirportBridgingPanel(AirportInfo theInfo) {
        this.theInfo = theInfo;
        this.transparentBridgeButton = new AirportInfoRadioButton("Act as transparent bridge (no NAT)");
        this.transparentBridgeButton.addInfoRecord(theInfo.get("raNA"), "00");
        this.transparentBridgeButton.addInfoRecord(theInfo.get("raWB"), "01");
        this.natButton = new AirportInfoRadioButton("Provide network address translation (NAT)");
        this.natButton.addInfoRecord(theInfo.get("raNA"), "01");
        this.radioButtonGroup = new ButtonGroup();
        this.radioButtonGroup.add(this.transparentBridgeButton);
        this.radioButtonGroup.add(this.natButton);
        this.natInboundPrivateAddressBase = new AirportInfoLabelledTextField("Private LAN base station address", theInfo.get("laIP"));
        this.natInboundPrivateAddressMask = new AirportInfoLabelledTextField("Private LAN subnet mask", theInfo.get("laSM"));
        this.disableBridgingCheckbox = new AirportInfoCheckBox("Disable bridging between Ethernet port and wireless LAN", theInfo.get("raWB"), "00", "01");
        this.natInfoPanel = new AirportInfoPanel();
        this.setUpDisplay();
    }

    private void setUpDisplay() {
        Insets theMargin;
        GridBagLayout theLayout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 0;
        c.ipadx = 0;
        c.ipady = 0;
        c.insets = theMargin = new Insets(2, 2, 2, 2);
        c.anchor = 10;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.natInfoPanel.setLayout(theLayout);
        c.anchor = 13;
        c.gridx = 1;
        c.gridy = 1;
        theLayout.setConstraints(this.natInboundPrivateAddressBase, c);
        this.natInfoPanel.add(this.natInboundPrivateAddressBase);
        c.gridx = 1;
        c.gridy = 2;
        theLayout.setConstraints(this.natInboundPrivateAddressMask, c);
        this.natInfoPanel.add(this.natInboundPrivateAddressMask);
        c.anchor = 17;
        c.gridx = 1;
        c.gridy = 3;
        theLayout.setConstraints(this.disableBridgingCheckbox, c);
        this.natInfoPanel.add(this.disableBridgingCheckbox);
        this.setLayout(theLayout);
        c.anchor = 17;
        c.gridx = 1;
        c.gridy = 1;
        theLayout.setConstraints(this.transparentBridgeButton, c);
        this.add(this.transparentBridgeButton);
        c.gridx = 1;
        c.gridy = 2;
        theLayout.setConstraints(this.natButton, c);
        this.add(this.natButton);
        c.gridx = 1;
        c.gridy = 3;
        theLayout.setConstraints(this.natInfoPanel, c);
        this.add(this.natInfoPanel);
        this.natButton.addItemListener(this.natInfoPanel);
        this.natInfoPanel.setEnabled(this.natButton.isSelected());
    }

    public void writeValue() throws ValueFormatException {
        super.writeValue();
        if (this.natInfoPanel.isEnabled()) {
            this.natInboundPrivateAddressBase.writeValue();
            String privateIP = this.theInfo.get("laIP").toString();
            if (privateIP.equals("0.0.0.0")) {
                this.natInboundPrivateAddressBase.theField.selectAll();
                this.natInboundPrivateAddressBase.theField.requestFocus();
                throw new ValueFormatException("Private LAN IP address in Bridging panel can't be 0.0.0.0");
            }
        }
    }
}

