/*
 * Decompiled with CFR 0.152.
 */
import airport.Airport2ProtocolMessage;
import airport.AirportDiscoverer;
import airport.AirportInfo;
import airport.AirportInfoRecord;
import airport.AirportInfoTabbedPane;
import airport.ValueFormatException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.plaf.FontUIResource;

public class AirportBaseStationConfigurator
extends JFrame
implements ActionListener {
    public static final String aboutString = "Airport Base Station Configurator ";
    JButton discoverDevicesButton;
    JButton retrieveItemButton;
    JButton updateBaseStationButton;
    JButton rebootBaseStationButton;
    JTextField hostIDField;
    JTextField communityField;
    GridBagLayout mainLayout = new GridBagLayout();
    MenuBar theMenubar;
    Menu fileMenu;
    MenuItem quitItem;
    MenuItem openItem;
    MenuItem saveItem;
    MenuItem aboutItem;
    MenuItem uploadFirmwareItem;
    AirportInfo airportInfo = new AirportInfo();
    AirportInfoTabbedPane infoPane = null;
    JTextArea messagesArea;

    public AirportBaseStationConfigurator() {
        this.setUpDisplay();
    }

    private void setUpDisplay() {
        Insets theMargin;
        UIManager manager = new UIManager();
        FontUIResource appFont = new FontUIResource("SansSerif", 0, 10);
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        Enumeration keys = defaults.keys();
        while (keys.hasMoreElements()) {
            String nextKey = (String)keys.nextElement();
            if (nextKey.indexOf("font") <= -1 && nextKey.indexOf("Font") <= -1) continue;
            UIManager.put(nextKey, appFont);
        }
        this.addWindowListener(new WindowCloseAdapter());
        this.setTitle("AirPort Base Station Configurator");
        this.getRootPane().setBorder(new BevelBorder(0));
        this.theMenubar = new MenuBar();
        this.setMenuBar(this.theMenubar);
        this.fileMenu = new Menu("File");
        this.openItem = new MenuItem("Open saved settings...");
        this.openItem.setShortcut(new MenuShortcut(111));
        this.openItem.setActionCommand("open settings");
        this.openItem.addActionListener(this);
        this.fileMenu.add(this.openItem);
        this.saveItem = new MenuItem("Save settings...");
        this.saveItem.setShortcut(new MenuShortcut(115));
        this.saveItem.setActionCommand("save settings");
        this.saveItem.addActionListener(this);
        this.fileMenu.add(this.saveItem);
        this.fileMenu.addSeparator();
        this.uploadFirmwareItem = new MenuItem("Upload new base station firmware...");
        this.uploadFirmwareItem.setActionCommand("upload firmware");
        this.uploadFirmwareItem.addActionListener(this);
        this.uploadFirmwareItem.setEnabled(false);
        this.fileMenu.add(this.uploadFirmwareItem);
        this.fileMenu.addSeparator();
        this.aboutItem = new MenuItem("About...");
        this.aboutItem.setActionCommand("about");
        this.aboutItem.addActionListener(this);
        this.fileMenu.add(this.aboutItem);
        this.quitItem = new MenuItem("Quit");
        this.quitItem.setShortcut(new MenuShortcut(113));
        this.quitItem.setActionCommand("quit");
        this.quitItem.addActionListener(this);
        this.fileMenu.add(this.quitItem);
        this.theMenubar.add(this.fileMenu);
        JLabel hostIDLabel = new JLabel("Device address:");
        this.hostIDField = new JTextField(10);
        this.hostIDField.setText("10.0.1.1");
        JLabel communityLabel = new JLabel("Password:");
        this.communityField = new JPasswordField(10);
        this.discoverDevicesButton = new JButton("Discover Devices");
        this.discoverDevicesButton.setActionCommand("discover devices");
        this.discoverDevicesButton.addActionListener(this);
        this.retrieveItemButton = new JButton("Retrieve Settings");
        this.retrieveItemButton.setActionCommand("retrieve data");
        this.retrieveItemButton.addActionListener(this);
        this.updateBaseStationButton = new JButton("Update Base Station");
        this.updateBaseStationButton.setActionCommand("update base station");
        this.updateBaseStationButton.addActionListener(this);
        this.updateBaseStationButton.setEnabled(false);
        this.rebootBaseStationButton = new JButton("Reboot Base Station");
        this.rebootBaseStationButton.setActionCommand("reboot base station");
        this.rebootBaseStationButton.addActionListener(this);
        GridBagLayout theLayout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 0;
        c.ipadx = 0;
        c.ipady = 0;
        c.insets = theMargin = new Insets(2, 2, 2, 2);
        c.anchor = 10;
        c.weightx = 0.5;
        c.weighty = 0.5;
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(theLayout);
        c.gridx = 1;
        c.gridy = 1;
        theLayout.setConstraints(this.discoverDevicesButton, c);
        buttonPanel.add(this.discoverDevicesButton);
        c.gridx = 2;
        c.gridy = 1;
        theLayout.setConstraints(this.retrieveItemButton, c);
        buttonPanel.add(this.retrieveItemButton);
        c.gridx = 3;
        c.gridy = 1;
        theLayout.setConstraints(this.updateBaseStationButton, c);
        buttonPanel.add(this.updateBaseStationButton);
        JPanel hostPanel = new JPanel();
        hostPanel.setLayout(theLayout);
        c.gridx = 1;
        c.gridy = 1;
        theLayout.setConstraints(hostIDLabel, c);
        hostPanel.add(hostIDLabel);
        c.gridx = 2;
        c.gridy = 1;
        theLayout.setConstraints(this.hostIDField, c);
        hostPanel.add(this.hostIDField);
        c.gridx = 3;
        c.gridy = 1;
        theLayout.setConstraints(communityLabel, c);
        hostPanel.add(communityLabel);
        c.gridx = 4;
        c.gridy = 1;
        theLayout.setConstraints(this.communityField, c);
        hostPanel.add(this.communityField);
        this.infoPane = new AirportInfoTabbedPane(this.airportInfo);
        JPanel messagesPanel = new JPanel();
        messagesPanel.setLayout(theLayout);
        this.messagesArea = new JTextArea(4, 60);
        JScrollPane messagesScroll = new JScrollPane(this.messagesArea);
        c.gridx = 1;
        c.gridy = 1;
        JLabel messagesLabel = new JLabel("Messages:");
        theLayout.setConstraints(messagesLabel, c);
        messagesPanel.add(messagesLabel);
        c.gridx = 1;
        c.gridy = 2;
        theLayout.setConstraints(messagesScroll, c);
        messagesPanel.add(messagesScroll);
        this.getContentPane().setLayout(this.mainLayout);
        c.gridx = 1;
        c.gridy = 1;
        this.mainLayout.setConstraints(hostPanel, c);
        this.getContentPane().add(hostPanel);
        c.gridx = 1;
        c.gridy = 2;
        this.mainLayout.setConstraints(buttonPanel, c);
        this.getContentPane().add(buttonPanel);
        c.gridx = 1;
        c.gridy = 3;
        this.mainLayout.setConstraints(this.infoPane, c);
        this.getContentPane().add(this.infoPane);
        c.gridx = 1;
        c.gridy = 4;
        this.mainLayout.setConstraints(messagesPanel, c);
        this.getContentPane().add(messagesPanel);
        c.gridx = 1;
        c.gridy = 5;
        JLabel authorLabel = new JLabel(" Version 2.0.1        J. Sevy, July 2002 ");
        authorLabel.setFont(new Font("SansSerif", 2, 8));
        this.mainLayout.setConstraints(authorLabel, c);
        this.getContentPane().add(authorLabel);
    }

    public void actionPerformed(ActionEvent theEvent) {
        block54: {
            InputStream fStream;
            byte[] responseHeader;
            OutputStream outputStream;
            InputStream inputStream;
            Airport2ProtocolMessage requestMessage;
            byte[] requestPayload;
            InetAddress hostAddress;
            Window window;
            String command = theEvent.getActionCommand();
            if (command.equals("quit")) {
                System.exit(0);
            }
            if (command == "about") {
                window = new AboutDialog(this);
            }
            if (command.equals("discover devices")) {
                window = new AirportDiscoverer();
            }
            if (command.equals("retrieve data")) {
                try {
                    boolean shiftKeyDown;
                    String password = this.communityField.getText();
                    hostAddress = InetAddress.getByName(this.hostIDField.getText());
                    this.messagesArea.append("Retrieving settings from base station " + hostAddress + "......\n");
                    requestPayload = this.airportInfo.getRequestBytes();
                    requestMessage = new Airport2ProtocolMessage(20, password, requestPayload, requestPayload.length);
                    int port = 5009;
                    Socket configSocket = new Socket(hostAddress, port);
                    configSocket.setSoTimeout(15000);
                    inputStream = new DataInputStream(configSocket.getInputStream());
                    outputStream = configSocket.getOutputStream();
                    outputStream.write(requestMessage.getBytes());
                    outputStream.write(requestPayload);
                    responseHeader = new byte[128];
                    ((DataInputStream)inputStream).readFully(responseHeader);
                    byte[] responsePayload = new byte[4096];
                    try {
                        ((DataInputStream)inputStream).readFully(responsePayload);
                    }
                    catch (EOFException eOFException) {}
                    ((FilterInputStream)inputStream).close();
                    outputStream.close();
                    configSocket.close();
                    boolean bl = shiftKeyDown = (theEvent.getModifiers() & 1) > 0;
                    if (shiftKeyDown) {
                        FileDialog fd = new FileDialog((Frame)this, "Save downloaded settings (without change) as...", 1);
                        fd.show();
                        byte[] fileBytes = this.airportInfo.getUpdateBytes();
                        if (fd.getFile() != null) {
                            File newFile = new File(fd.getDirectory(), fd.getFile());
                            DataOutputStream fStream2 = new DataOutputStream(new FileOutputStream(newFile));
                            int checksum = this.computeChecksum(responsePayload);
                            fStream2.writeInt(checksum);
                            fStream2.write(responsePayload);
                            fStream2.flush();
                            fStream2.close();
                        }
                    }
                    try {
                        this.airportInfo = new AirportInfo(responsePayload);
                        this.messagesArea.append("Settings retrieved.\n");
                        this.refreshInfoPane();
                        this.updateBaseStationButton.setEnabled(true);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.messagesArea.append("Error retrieving settings (check password)\n");
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    this.messagesArea.append("Error retrieving settings: unknown host.\n");
                }
                catch (SocketException e) {
                    this.messagesArea.append("Error retrieving settings: " + e + "\n");
                }
                catch (IOException iOException) {
                    this.messagesArea.append("Error retrieving settings: timed out waiting for response.\n");
                }
                catch (Exception e) {
                    this.messagesArea.append("Error retrieving settings: " + e.getMessage() + "\n");
                }
            }
            if (command.equals("save settings")) {
                try {
                    FileDialog fd;
                    boolean shiftKeyDown;
                    boolean bl = shiftKeyDown = (theEvent.getModifiers() & 1) > 0;
                    if (!shiftKeyDown) {
                        this.infoPane.writeData();
                        this.setDependentData();
                        this.setStaticData();
                        this.performConsistencyChecks();
                        fd = new FileDialog((Frame)this, "Save current settings as...", 1);
                    } else {
                        fd = new FileDialog((Frame)this, "Save downloaded settings (without change) as...", 1);
                    }
                    fd.show();
                    byte[] fileBytes = this.airportInfo.getUpdateBytes();
                    if (fd.getFile() != null) {
                        File newFile = new File(fd.getDirectory(), fd.getFile());
                        DataOutputStream fStream3 = new DataOutputStream(new FileOutputStream(newFile));
                        int checksum = this.computeChecksum(fileBytes);
                        fStream3.writeInt(checksum);
                        fStream3.write(fileBytes);
                        fStream3.flush();
                        fStream3.close();
                    }
                }
                catch (ValueFormatException ve) {
                    this.messagesArea.append("Problem with supplied value: " + ve.getMessage() + "\n");
                }
                catch (Exception e) {
                    this.messagesArea.append("Error saving settings: " + e.getMessage() + "\n");
                }
            }
            if (command.equals("update base station")) {
                try {
                    this.infoPane.writeData();
                    this.setDependentData();
                    this.setStaticData();
                    this.performConsistencyChecks();
                    String password = this.communityField.getText();
                    hostAddress = InetAddress.getByName(this.hostIDField.getText());
                    this.messagesArea.append("Updating settings to base station " + hostAddress + "......\n");
                    requestPayload = this.airportInfo.getUpdateBytes();
                    requestMessage = new Airport2ProtocolMessage(21, password, requestPayload, requestPayload.length);
                    int port = 5009;
                    Socket configSocket = new Socket(hostAddress, port);
                    configSocket.setSoTimeout(15000);
                    inputStream = configSocket.getInputStream();
                    outputStream = configSocket.getOutputStream();
                    outputStream.write(requestMessage.getBytes());
                    outputStream.write(requestPayload);
                    responseHeader = new byte[128];
                    int numBytes = inputStream.read(responseHeader);
                    byte[] responsePayload = new byte[4096];
                    numBytes = inputStream.read(responsePayload);
                    inputStream.close();
                    outputStream.close();
                    configSocket.close();
                    if (numBytes > 0) {
                        this.messagesArea.append("Settings updated.\n");
                    } else {
                        this.messagesArea.append("\nError updating settings (check password)\n");
                    }
                }
                catch (ValueFormatException ve) {
                    this.messagesArea.append("Problem with supplied value: " + ve.getMessage() + "\n");
                }
                catch (UnknownHostException unknownHostException) {
                    this.messagesArea.append("Error updating settings: unknown host.\n");
                }
                catch (SocketException e) {
                    this.messagesArea.append("Error updating settings: " + e + "\n");
                }
                catch (IOException iOException) {
                    this.messagesArea.append("Error updating settings: timed out waiting for response.\n");
                }
                catch (Exception e) {
                    this.messagesArea.append("Error updating settings: " + e.getMessage() + "\n");
                }
            }
            if (command.equals("reboot base station")) {
                try {
                    String password = this.communityField.getText();
                    hostAddress = InetAddress.getByName(this.hostIDField.getText());
                    this.messagesArea.append("Rebooting base station " + hostAddress + "......\n");
                    requestPayload = this.airportInfo.get("acRB").getUpdateBytes();
                    requestMessage = new Airport2ProtocolMessage(21, password, requestPayload, requestPayload.length);
                    int port = 5009;
                    Socket configSocket = new Socket(hostAddress, port);
                    configSocket.setSoTimeout(15000);
                    inputStream = configSocket.getInputStream();
                    outputStream = configSocket.getOutputStream();
                    outputStream.write(requestMessage.getBytes());
                    outputStream.write(requestPayload);
                    responseHeader = new byte[128];
                    int numBytes = inputStream.read(responseHeader);
                    byte[] responsePayload = new byte[4096];
                    numBytes = inputStream.read(responsePayload);
                    inputStream.close();
                    outputStream.close();
                    configSocket.close();
                    if (numBytes > 0) {
                        this.messagesArea.append("Base station rebooting.\n");
                    } else {
                        this.messagesArea.append("\nError rebooting base station (check password)\n");
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    this.messagesArea.append("Error rebooting base station: unknown host.\n");
                }
                catch (SocketException e) {
                    this.messagesArea.append("Error rebooting base station: " + e + "\n");
                }
                catch (IOException iOException) {
                    this.messagesArea.append("Error rebooting base station: timed out waiting for response.\n");
                }
                catch (Exception e) {
                    this.messagesArea.append("Error rebooting base station: " + e.getMessage() + "\n");
                }
            }
            if (command.equals("open settings")) {
                try {
                    FileDialog fd = new FileDialog((Frame)this, "Open settings file...", 0);
                    fd.show();
                    if (fd.getFile() != null) {
                        File newFile = new File(fd.getDirectory(), fd.getFile());
                        fStream = new DataInputStream(new FileInputStream(newFile));
                        int existingChecksum = ((DataInputStream)fStream).readInt();
                        byte[] newBytes = new byte[(int)newFile.length() - 4];
                        ((DataInputStream)fStream).read(newBytes);
                        ((FilterInputStream)fStream).close();
                        int computedChecksum = this.computeChecksum(newBytes);
                        if (computedChecksum == existingChecksum) {
                            this.airportInfo = new AirportInfo(newBytes);
                            this.messagesArea.append("Settings opened.\n");
                            this.refreshInfoPane();
                            this.updateBaseStationButton.setEnabled(true);
                        } else {
                            this.messagesArea.append("Invalid configuration file.\n");
                        }
                    }
                }
                catch (Exception e) {
                    this.messagesArea.append("Error opening settings: " + e.getMessage() + "\n");
                }
            }
            if (!command.equals("upload firmware")) break block54;
            try {
                Object[] possibleValues;
                boolean shiftKeyDown;
                FileDialog fd = new FileDialog((Frame)this, "Select firmware file...", 0);
                fd.show();
                if (fd.getFile() == null) break block54;
                File firmwareFile = new File(fd.getDirectory(), fd.getFile());
                fStream = new FileInputStream(firmwareFile);
                int fileLength = (int)firmwareFile.length();
                byte[] firmwareBytes = new byte[fileLength];
                ((FileInputStream)fStream).read(firmwareBytes);
                ((FileInputStream)fStream).close();
                boolean bl = shiftKeyDown = (theEvent.getModifiers() & 1) > 0;
                if (!shiftKeyDown) {
                    throw new Exception("invalid firmware file.");
                }
                String messageString = "Upload firmware to base station " + this.hostIDField.getText() + "?";
                Object response = new String("Cancel");
                if (this.updateBaseStationButton.isEnabled()) {
                    possibleValues = new String[]{"Upload firmware with current settings", "Upload firmware with default settings", "Cancel"};
                    int selectedValue = JOptionPane.showOptionDialog(null, messageString, "Firmware Upload", 0, 1, null, possibleValues, possibleValues[0]);
                    if (selectedValue != -1) {
                        response = possibleValues[selectedValue];
                    }
                } else {
                    possibleValues = new String[]{"Upload firmware with default settings", "Cancel"};
                    int selectedValue = JOptionPane.showOptionDialog(null, messageString, "Firmware Upload", 0, 1, null, possibleValues, possibleValues[0]);
                    if (selectedValue != -1) {
                        response = possibleValues[selectedValue];
                    }
                }
                if (((String)response).equals("Upload firmware with current settings")) {
                    this.infoPane.writeData();
                    this.setDependentData();
                    this.setStaticData();
                    break block54;
                }
                ((String)response).equals("Upload firmware with default settings");
            }
            catch (ValueFormatException ve) {
                this.messagesArea.append("Problem with supplied value: " + ve.getMessage() + "\n");
            }
            catch (Exception e) {
                this.messagesArea.append("Error updating firmware: " + e.getMessage() + "\n");
            }
        }
    }

    private String hexByte(byte b) {
        int pos = b;
        if (pos < 0) {
            pos += 256;
        }
        String returnString = new String();
        returnString = String.valueOf(returnString) + Integer.toHexString(pos / 16);
        returnString = String.valueOf(returnString) + Integer.toHexString(pos % 16);
        return returnString;
    }

    private void refreshInfoPane() {
        Insets theMargin;
        this.remove(this.infoPane);
        this.infoPane = new AirportInfoTabbedPane(this.airportInfo);
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 0;
        c.ipadx = 0;
        c.ipady = 0;
        c.insets = theMargin = new Insets(2, 2, 2, 2);
        c.anchor = 10;
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 1;
        c.gridy = 3;
        this.mainLayout.setConstraints(this.infoPane, c);
        this.getContentPane().add(this.infoPane);
        this.validate();
    }

    private void setDependentData() throws ValueFormatException {
        AirportInfoRecord configInterfaceRecord = this.airportInfo.get("waIn");
        AirportInfoRecord dhcpLANRecord = this.airportInfo.get("laDS");
        AirportInfoRecord dhcpWANRecord = this.airportInfo.get("waDS");
        if (configInterfaceRecord.toString().equals("00000004")) {
            if (dhcpLANRecord.toString().equals("01")) {
                dhcpWANRecord.setBytesFromString("01");
            } else {
                dhcpWANRecord.setBytesFromString("00");
            }
        }
    }

    private void performConsistencyChecks() throws ValueFormatException {
        AirportInfoRecord wanConfigRecord = this.airportInfo.get("waCV");
        AirportInfoRecord natRecord = this.airportInfo.get("raNA");
        AirportInfoRecord dhcpWirelessRecord = this.airportInfo.get("raDS");
        AirportInfoRecord dhcpLANRecord = this.airportInfo.get("laDS");
        AirportInfoRecord dhcpWANRecord = this.airportInfo.get("waDS");
        if (natRecord.toString().equals("00") && (dhcpWirelessRecord.toString().equals("01") || dhcpLANRecord.toString().equals("01") || dhcpWANRecord.toString().equals("01")) && !wanConfigRecord.toString().equals("00000400")) {
            throw new ValueFormatException("Must use manual Ethernet configuration (Network Panel) when providing DHCP service (DHCP Panel)\nin transparent bridge mode (Bridging Panel)");
        }
        if (wanConfigRecord.toString().equals("00000400")) {
            byte[] wanIPBytes = this.airportInfo.get("waIP").getValue();
            byte[] wanRouterIPBytes = this.airportInfo.get("waRA").getValue();
            byte[] wanMaskBytes = this.airportInfo.get("waSM").getValue();
            if (!AirportBaseStationConfigurator.arraysEqual(wanRouterIPBytes = AirportBaseStationConfigurator.maskBytes(wanRouterIPBytes, wanMaskBytes), wanIPBytes = AirportBaseStationConfigurator.maskBytes(wanIPBytes, wanMaskBytes))) {
                throw new ValueFormatException("Router IP address inconsistent with base station IP address and subnet mask (Network Panel)");
            }
        }
        if (dhcpWirelessRecord.toString().equals("01") || dhcpLANRecord.toString().equals("01") || dhcpWANRecord.toString().equals("01")) {
            byte[] dhcpBeginBytes = this.airportInfo.get("dhBg").getValue();
            byte[] dhcpEndBytes = this.airportInfo.get("dhEn").getValue();
            if (natRecord.toString().equals("00")) {
                byte[] wanRouterIPBytes = this.airportInfo.get("waRA").getValue();
                byte[] wanMaskBytes = this.airportInfo.get("waSM").getValue();
                wanRouterIPBytes = AirportBaseStationConfigurator.maskBytes(wanRouterIPBytes, wanMaskBytes);
                dhcpBeginBytes = AirportBaseStationConfigurator.maskBytes(dhcpBeginBytes, wanMaskBytes);
                dhcpEndBytes = AirportBaseStationConfigurator.maskBytes(dhcpEndBytes, wanMaskBytes);
                if (!AirportBaseStationConfigurator.arraysEqual(wanRouterIPBytes, dhcpBeginBytes) || !AirportBaseStationConfigurator.arraysEqual(wanRouterIPBytes, dhcpEndBytes)) {
                    throw new ValueFormatException("DHCP range (DHCP Panel) inconssistent with router IP address and subnet mask (Network Panel)");
                }
            } else {
                byte[] lanIPBytes = this.airportInfo.get("laIP").getValue();
                byte[] lanMaskBytes = this.airportInfo.get("laSM").getValue();
                lanIPBytes = AirportBaseStationConfigurator.maskBytes(lanIPBytes, lanMaskBytes);
                dhcpBeginBytes = AirportBaseStationConfigurator.maskBytes(dhcpBeginBytes, lanMaskBytes);
                dhcpEndBytes = AirportBaseStationConfigurator.maskBytes(dhcpEndBytes, lanMaskBytes);
                if (!AirportBaseStationConfigurator.arraysEqual(lanIPBytes, dhcpBeginBytes) || !AirportBaseStationConfigurator.arraysEqual(lanIPBytes, dhcpEndBytes)) {
                    throw new ValueFormatException("DHCP range (DHCP Panel) inconsistent with base station private LAN IP address and subnet mask (Bridging Panel)");
                }
            }
        }
    }

    private void setStaticData() throws ValueFormatException {
        AirportInfoRecord readCommunityRecord = this.airportInfo.get("syPR");
        readCommunityRecord.setBytesFromString("public");
        AirportInfoRecord communityNameRecord = this.airportInfo.get("syPW");
        String communityName = communityNameRecord.toString();
        if (communityName.equals("")) {
            communityName = this.communityField.getText();
        }
        communityNameRecord.setBytesFromString(communityName);
    }

    private int computeChecksum(byte[] fileBytes) {
        int checksum = 0;
        int i = 0;
        while (i < fileBytes.length) {
            checksum += fileBytes[i];
            ++i;
        }
        return checksum;
    }

    private String printHexBytes(byte[] bytes) {
        String returnString = new String();
        int i = 0;
        while (i < bytes.length) {
            returnString = String.valueOf(returnString) + this.hexByte(bytes[i]) + " ";
            if ((i + 1) % 16 == 0) {
                returnString = String.valueOf(returnString) + "\n";
            }
            ++i;
        }
        return returnString;
    }

    private static boolean arraysEqual(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static byte[] maskBytes(byte[] inBytes, byte[] mask) {
        byte[] maskedBytes = new byte[inBytes.length];
        int i = 0;
        while (i < inBytes.length) {
            maskedBytes[i] = (byte)(inBytes[i] & mask[i % inBytes.length]);
            ++i;
        }
        return maskedBytes;
    }

    public static void main(String[] args) {
        try {
            AirportBaseStationConfigurator theApp = new AirportBaseStationConfigurator();
            theApp.pack();
            Dimension dim = theApp.getSize();
            dim.height += 20;
            dim.width += 20;
            ((Component)theApp).setSize(dim);
            theApp.show();
        }
        catch (Exception exception) {}
    }

    private class WindowCloseAdapter
    extends WindowAdapter {
        public void windowClosing(WindowEvent e) {
            System.exit(0);
        }

        WindowCloseAdapter() {
        }
    }
}

