/*
 * Decompiled with CFR 0.152.
 */
package snmp;

import java.io.ByteArrayOutputStream;
import java.util.Enumeration;
import java.util.Vector;
import snmp.SNMPBERCodec;
import snmp.SNMPBadValueException;
import snmp.SNMPObject;
import snmp.SNMPTLV;

public class SNMPSequence
extends SNMPObject {
    protected Vector sequence;
    protected int type = 48;

    public SNMPSequence() {
        this.sequence = new Vector();
    }

    public SNMPSequence(Vector vector) throws SNMPBadValueException {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            if (enumeration.nextElement() instanceof SNMPObject) continue;
            throw new SNMPBadValueException("Non-SNMPObject supplied to SNMPSequence.");
        }
        this.sequence = vector;
    }

    public SNMPSequence(byte[] byArray) throws SNMPBadValueException {
        this.extractFromBEREncoding(byArray);
    }

    public Object getValue() {
        return this.sequence;
    }

    public void setValue(Object object) throws SNMPBadValueException {
        if (object instanceof Vector) {
            Enumeration enumeration = ((Vector)object).elements();
            while (enumeration.hasMoreElements()) {
                if (enumeration.nextElement() instanceof SNMPObject) continue;
                throw new SNMPBadValueException("Non-SNMPObject supplied to SNMPSequence.");
            }
        } else {
            throw new SNMPBadValueException(" Sequence: bad object supplied to set value ");
        }
        this.sequence = (Vector)object;
    }

    public int size() {
        return this.sequence.size();
    }

    public void addSNMPObject(SNMPObject sNMPObject) throws SNMPBadValueException {
        this.sequence.insertElementAt(sNMPObject, this.sequence.size());
    }

    public SNMPObject getSNMPObjectAt(int n) {
        return (SNMPObject)this.sequence.elementAt(n);
    }

    public byte[] getBEREncoding() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = this.encodeVector();
        byte[] byArray2 = SNMPBERCodec.encodeLength(byArray.length);
        byteArrayOutputStream.write(this.type);
        byteArrayOutputStream.write(byArray2, 0, byArray2.length);
        byteArrayOutputStream.write(byArray, 0, byArray.length);
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] encodeVector() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = this.sequence.size();
        int n2 = 0;
        while (n2 < n) {
            byte[] byArray = ((SNMPObject)this.sequence.elementAt(n2)).getBEREncoding();
            byteArrayOutputStream.write(byArray, 0, byArray.length);
            ++n2;
        }
        return byteArrayOutputStream.toByteArray();
    }

    protected void extractFromBEREncoding(byte[] byArray) throws SNMPBadValueException {
        Vector<SNMPObject> vector = new Vector<SNMPObject>();
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            SNMPTLV sNMPTLV = SNMPBERCodec.extractNextTLV(byArray, n2);
            vector.insertElementAt(SNMPBERCodec.extractEncoding(sNMPTLV), vector.size());
            n2 += sNMPTLV.totalLength;
        }
        this.sequence = vector;
    }

    public String toString() {
        String string = new String("(");
        int n = 0;
        while (n < this.sequence.size()) {
            string = String.valueOf(string) + " " + ((SNMPObject)this.sequence.elementAt(n)).toString() + " ";
            ++n;
        }
        string = String.valueOf(string) + ")";
        return string;
    }
}

