/*
 * Decompiled with CFR 0.152.
 */
package airport;

import airport.AirportInfoComponent;
import airport.AirportInfoRecord;
import airport.ValueFormatException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JCheckBox;

public class AirportInfoCheckBox
extends JCheckBox
implements AirportInfoComponent {
    private Vector theRecords = new Vector();

    public AirportInfoCheckBox(String string) {
        super(string);
    }

    public AirportInfoCheckBox(String string, AirportInfoRecord airportInfoRecord, String string2, String string3) {
        super(string);
        this.addInfoRecord(airportInfoRecord, string2, string3);
    }

    public void addInfoRecord(AirportInfoRecord airportInfoRecord, String string, String string2) {
        RecordSettings recordSettings = new RecordSettings();
        recordSettings.theRecord = airportInfoRecord;
        recordSettings.selectedValue = string;
        recordSettings.unselectedValue = string2;
        this.theRecords.insertElementAt(recordSettings, this.theRecords.size());
        this.refreshDisplay();
    }

    public void refreshDisplay() {
        boolean bl = true;
        Enumeration enumeration = this.theRecords.elements();
        while (enumeration.hasMoreElements()) {
            RecordSettings recordSettings = (RecordSettings)enumeration.nextElement();
            String string = recordSettings.theRecord.toString();
            String string2 = recordSettings.selectedValue;
            try {
                if (Integer.parseInt(string, 16) == Integer.parseInt(string2, 16)) continue;
                bl = false;
                break;
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        }
        this.setSelected(bl);
    }

    public void writeValue() throws ValueFormatException {
        boolean bl = this.isSelected();
        Enumeration enumeration = this.theRecords.elements();
        while (enumeration.hasMoreElements()) {
            ((RecordSettings)enumeration.nextElement()).writeValue(bl);
        }
    }

    private class RecordSettings {
        public AirportInfoRecord theRecord;
        public String selectedValue;
        public String unselectedValue;

        public void writeValue(boolean bl) throws ValueFormatException {
            if (bl) {
                this.theRecord.setBytesFromString(this.selectedValue);
            } else {
                this.theRecord.setBytesFromString(this.unselectedValue);
            }
        }

        RecordSettings() {
        }
    }
}

