(*
 * Copyright 2012, INRIA
 * Julia Lawall, Gilles Muller
 * Copyright 2010-2011, INRIA, University of Copenhagen
 * Julia Lawall, Rene Rydhof Hansen, Gilles Muller, Nicolas Palix
 * Copyright 2005-2009, Ecole des Mines de Nantes, University of Copenhagen
 * Yoann Padioleau, Julia Lawall, Rene Rydhof Hansen, Henrik Stuart, Gilles Muller, Nicolas Palix
 * This file is part of Coccinelle.
 *
 * Coccinelle is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, according to version 2 of the License.
 *
 * Coccinelle is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Coccinelle.  If not, see <http://www.gnu.org/licenses/>.
 *
 * The authors reserve the right to distribute this or future versions of
 * Coccinelle under other licenses.
 *)


# 0 "./parser_cocci_menhir.ml"
exception Error

type token = 
  | Tvolatile of (
# 96 "parser_cocci_menhir.mly"
      (Data.clt)
# 8 "parser_cocci_menhir.ml"
)
  | Tvoid of (
# 92 "parser_cocci_menhir.mly"
      (Data.clt)
# 13 "parser_cocci_menhir.ml"
)
  | Tunsigned of (
# 93 "parser_cocci_menhir.mly"
      (Data.clt)
# 18 "parser_cocci_menhir.ml"
)
  | Tunion of (
# 92 "parser_cocci_menhir.mly"
      (Data.clt)
# 23 "parser_cocci_menhir.ml"
)
  | Ttypedef of (
# 95 "parser_cocci_menhir.mly"
      (Data.clt)
# 28 "parser_cocci_menhir.ml"
)
  | Tstruct of (
# 92 "parser_cocci_menhir.mly"
      (Data.clt)
# 33 "parser_cocci_menhir.ml"
)
  | Tstatic of (
# 95 "parser_cocci_menhir.mly"
      (Data.clt)
# 38 "parser_cocci_menhir.ml"
)
  | Tssize_t of (
# 91 "parser_cocci_menhir.mly"
      (Data.clt)
# 43 "parser_cocci_menhir.ml"
)
  | Tsize_t of (
# 91 "parser_cocci_menhir.mly"
      (Data.clt)
# 48 "parser_cocci_menhir.ml"
)
  | Tsigned of (
# 93 "parser_cocci_menhir.mly"
      (Data.clt)
# 53 "parser_cocci_menhir.ml"
)
  | Tshort of (
# 90 "parser_cocci_menhir.mly"
      (Data.clt)
# 58 "parser_cocci_menhir.ml"
)
  | Tregister of (
# 95 "parser_cocci_menhir.mly"
      (Data.clt)
# 63 "parser_cocci_menhir.ml"
)
  | Tptrdiff_t of (
# 91 "parser_cocci_menhir.mly"
      (Data.clt)
# 68 "parser_cocci_menhir.ml"
)
  | Tlong of (
# 90 "parser_cocci_menhir.mly"
      (Data.clt)
# 73 "parser_cocci_menhir.ml"
)
  | Tlist
  | Tint of (
# 90 "parser_cocci_menhir.mly"
      (Data.clt)
# 79 "parser_cocci_menhir.ml"
)
  | Tinline of (
# 95 "parser_cocci_menhir.mly"
      (Data.clt)
# 84 "parser_cocci_menhir.ml"
)
  | Tfloat of (
# 90 "parser_cocci_menhir.mly"
      (Data.clt)
# 89 "parser_cocci_menhir.ml"
)
  | Textern of (
# 95 "parser_cocci_menhir.mly"
      (Data.clt)
# 94 "parser_cocci_menhir.ml"
)
  | Tenum of (
# 92 "parser_cocci_menhir.mly"
      (Data.clt)
# 99 "parser_cocci_menhir.ml"
)
  | Tdouble of (
# 90 "parser_cocci_menhir.mly"
      (Data.clt)
# 104 "parser_cocci_menhir.ml"
)
  | Tconst of (
# 96 "parser_cocci_menhir.mly"
      (Data.clt)
# 109 "parser_cocci_menhir.ml"
)
  | Tchar of (
# 90 "parser_cocci_menhir.mly"
      (Data.clt)
# 114 "parser_cocci_menhir.ml"
)
  | Tauto of (
# 95 "parser_cocci_menhir.mly"
      (Data.clt)
# 119 "parser_cocci_menhir.ml"
)
  | Tattr of (
# 97 "parser_cocci_menhir.mly"
      (string * Data.clt)
# 124 "parser_cocci_menhir.ml"
)
  | TXor of (
# 138 "parser_cocci_menhir.mly"
       (Data.clt)
# 129 "parser_cocci_menhir.ml"
)
  | TWords
  | TWhy0
  | TWhy of (
# 122 "parser_cocci_menhir.mly"
       (Data.clt)
# 136 "parser_cocci_menhir.ml"
)
  | TWhile of (
# 99 "parser_cocci_menhir.mly"
       (Data.clt)
# 141 "parser_cocci_menhir.ml"
)
  | TWhenTrue of (
# 120 "parser_cocci_menhir.mly"
       (Data.clt)
# 146 "parser_cocci_menhir.ml"
)
  | TWhenFalse of (
# 120 "parser_cocci_menhir.mly"
       (Data.clt)
# 151 "parser_cocci_menhir.ml"
)
  | TWhen of (
# 120 "parser_cocci_menhir.mly"
       (Data.clt)
# 156 "parser_cocci_menhir.ml"
)
  | TVirtual
  | TUsing
  | TUnderscore
  | TUndef of (
# 127 "parser_cocci_menhir.mly"
       (Data.clt * token)
# 164 "parser_cocci_menhir.ml"
)
  | TTypedef
  | TTypeId of (
# 101 "parser_cocci_menhir.mly"
       (string * Data.clt)
# 170 "parser_cocci_menhir.ml"
)
  | TType
  | TTildeExclEq of (
# 140 "parser_cocci_menhir.mly"
       (Data.clt)
# 176 "parser_cocci_menhir.ml"
)
  | TTildeEq of (
# 140 "parser_cocci_menhir.mly"
       (Data.clt)
# 181 "parser_cocci_menhir.ml"
)
  | TTilde of (
# 145 "parser_cocci_menhir.mly"
       (Data.clt)
# 186 "parser_cocci_menhir.ml"
)
  | TSymbol
  | TSymId of (
# 101 "parser_cocci_menhir.mly"
       (string * Data.clt)
# 192 "parser_cocci_menhir.ml"
)
  | TSwitch of (
# 99 "parser_cocci_menhir.mly"
       (Data.clt)
# 197 "parser_cocci_menhir.ml"
)
  | TSub of (
# 140 "parser_cocci_menhir.mly"
       (Data.clt)
# 202 "parser_cocci_menhir.ml"
)
  | TString of (
# 133 "parser_cocci_menhir.mly"
       (string * Data.clt)
# 207 "parser_cocci_menhir.ml"
)
  | TStrict of (
# 120 "parser_cocci_menhir.mly"
       (Data.clt)
# 212 "parser_cocci_menhir.ml"
)
  | TStatement
  | TSizeof of (
# 100 "parser_cocci_menhir.mly"
       (Data.clt)
# 218 "parser_cocci_menhir.ml"
)
  | TShROp of (
# 142 "parser_cocci_menhir.mly"
       (Ast_cocci.arithOp * Data.clt)
# 223 "parser_cocci_menhir.ml"
)
  | TShLOp of (
# 142 "parser_cocci_menhir.mly"
       (Ast_cocci.arithOp * Data.clt)
# 228 "parser_cocci_menhir.ml"
)
  | TScriptData of (
# 117 "parser_cocci_menhir.mly"
       (string)
# 233 "parser_cocci_menhir.ml"
)
  | TScript
  | TRuleName of (
# 88 "parser_cocci_menhir.mly"
      (string)
# 239 "parser_cocci_menhir.ml"
)
  | TRightIso
  | TReturn of (
# 99 "parser_cocci_menhir.mly"
       (Data.clt)
# 245 "parser_cocci_menhir.ml"
)
  | TPure
  | TPtrOp of (
# 150 "parser_cocci_menhir.mly"
       (Data.clt)
# 251 "parser_cocci_menhir.ml"
)
  | TPtVirg of (
# 153 "parser_cocci_menhir.mly"
       (Data.clt)
# 256 "parser_cocci_menhir.ml"
)
  | TPragma of (
# 102 "parser_cocci_menhir.mly"
       (Ast_cocci.added_string * Data.clt)
# 261 "parser_cocci_menhir.ml"
)
  | TPosition
  | TPosAny
  | TPlusFile of (
# 129 "parser_cocci_menhir.mly"
       (string * Data.clt)
# 268 "parser_cocci_menhir.ml"
)
  | TPlus0
  | TPlus of (
# 144 "parser_cocci_menhir.mly"
       (Data.clt)
# 274 "parser_cocci_menhir.ml"
)
  | TPathIsoFile of (
# 125 "parser_cocci_menhir.mly"
       (string)
# 279 "parser_cocci_menhir.ml"
)
  | TParameter
  | TPOEllipsis of (
# 119 "parser_cocci_menhir.mly"
       (Data.clt)
# 285 "parser_cocci_menhir.ml"
)
  | TPCEllipsis of (
# 119 "parser_cocci_menhir.mly"
       (Data.clt)
# 290 "parser_cocci_menhir.ml"
)
  | TPArob of (
# 116 "parser_cocci_menhir.mly"
       (Data.clt)
# 295 "parser_cocci_menhir.ml"
)
  | TOrLog of (
# 135 "parser_cocci_menhir.mly"
       (Data.clt)
# 300 "parser_cocci_menhir.ml"
)
  | TOr of (
# 137 "parser_cocci_menhir.mly"
       (Data.clt)
# 305 "parser_cocci_menhir.ml"
)
  | TOn
  | TOPar0 of (
# 122 "parser_cocci_menhir.mly"
       (Data.clt)
# 311 "parser_cocci_menhir.ml"
)
  | TOPar of (
# 122 "parser_cocci_menhir.mly"
       (Data.clt)
# 316 "parser_cocci_menhir.ml"
)
  | TOInit of (
# 147 "parser_cocci_menhir.mly"
       (Data.clt)
# 321 "parser_cocci_menhir.ml"
)
  | TOEllipsis of (
# 119 "parser_cocci_menhir.mly"
       (Data.clt)
# 326 "parser_cocci_menhir.ml"
)
  | TOCro of (
# 148 "parser_cocci_menhir.mly"
       (Data.clt)
# 331 "parser_cocci_menhir.ml"
)
  | TOBrace of (
# 147 "parser_cocci_menhir.mly"
       (Data.clt)
# 336 "parser_cocci_menhir.ml"
)
  | TNothing
  | TNotEq of (
# 140 "parser_cocci_menhir.mly"
       (Data.clt)
# 342 "parser_cocci_menhir.ml"
)
  | TNever
  | TName
  | TMul of (
# 145 "parser_cocci_menhir.mly"
       (Data.clt)
# 349 "parser_cocci_menhir.ml"
)
  | TMinusFile of (
# 129 "parser_cocci_menhir.mly"
       (string * Data.clt)
# 354 "parser_cocci_menhir.ml"
)
  | TMinus of (
# 144 "parser_cocci_menhir.mly"
       (Data.clt)
# 359 "parser_cocci_menhir.ml"
)
  | TMid0 of (
# 123 "parser_cocci_menhir.mly"
       (Data.clt)
# 364 "parser_cocci_menhir.ml"
)
  | TMetavariable
  | TMetaType of (
# 108 "parser_cocci_menhir.mly"
       (Parse_aux.info)
# 370 "parser_cocci_menhir.ml"
)
  | TMetaStmList of (
# 108 "parser_cocci_menhir.mly"
       (Parse_aux.info)
# 375 "parser_cocci_menhir.ml"
)
  | TMetaStm of (
# 108 "parser_cocci_menhir.mly"
       (Parse_aux.info)
# 380 "parser_cocci_menhir.ml"
)
  | TMetaPos of (
# 113 "parser_cocci_menhir.mly"
       (Parse_aux.pos_info)
# 385 "parser_cocci_menhir.ml"
)
  | TMetaParamList of (
# 110 "parser_cocci_menhir.mly"
       (Parse_aux.list_info)
# 390 "parser_cocci_menhir.ml"
)
  | TMetaParam of (
# 108 "parser_cocci_menhir.mly"
       (Parse_aux.info)
# 395 "parser_cocci_menhir.ml"
)
  | TMetaLocalIdExp of (
# 112 "parser_cocci_menhir.mly"
       (Parse_aux.typed_expinfo)
# 400 "parser_cocci_menhir.ml"
)
  | TMetaLocalFunc of (
# 105 "parser_cocci_menhir.mly"
       (Parse_aux.idinfo)
# 405 "parser_cocci_menhir.ml"
)
  | TMetaIterator of (
# 106 "parser_cocci_menhir.mly"
       (Parse_aux.idinfo)
# 410 "parser_cocci_menhir.ml"
)
  | TMetaInitList of (
# 110 "parser_cocci_menhir.mly"
       (Parse_aux.list_info)
# 415 "parser_cocci_menhir.ml"
)
  | TMetaInit of (
# 109 "parser_cocci_menhir.mly"
       (Parse_aux.info)
# 420 "parser_cocci_menhir.ml"
)
  | TMetaIdExp of (
# 112 "parser_cocci_menhir.mly"
       (Parse_aux.typed_expinfo)
# 425 "parser_cocci_menhir.ml"
)
  | TMetaId of (
# 104 "parser_cocci_menhir.mly"
       (Parse_aux.midinfo)
# 430 "parser_cocci_menhir.ml"
)
  | TMetaFunc of (
# 105 "parser_cocci_menhir.mly"
       (Parse_aux.idinfo)
# 435 "parser_cocci_menhir.ml"
)
  | TMetaFieldList of (
# 111 "parser_cocci_menhir.mly"
       (Parse_aux.list_info)
# 440 "parser_cocci_menhir.ml"
)
  | TMetaField of (
# 109 "parser_cocci_menhir.mly"
       (Parse_aux.info)
# 445 "parser_cocci_menhir.ml"
)
  | TMetaExpList of (
# 110 "parser_cocci_menhir.mly"
       (Parse_aux.list_info)
# 450 "parser_cocci_menhir.ml"
)
  | TMetaExp of (
# 112 "parser_cocci_menhir.mly"
       (Parse_aux.typed_expinfo)
# 455 "parser_cocci_menhir.ml"
)
  | TMetaErr of (
# 107 "parser_cocci_menhir.mly"
       (Parse_aux.expinfo)
# 460 "parser_cocci_menhir.ml"
)
  | TMetaDeclarer of (
# 106 "parser_cocci_menhir.mly"
       (Parse_aux.idinfo)
# 465 "parser_cocci_menhir.ml"
)
  | TMetaDecl of (
# 109 "parser_cocci_menhir.mly"
       (Parse_aux.info)
# 470 "parser_cocci_menhir.ml"
)
  | TMetaConst of (
# 112 "parser_cocci_menhir.mly"
       (Parse_aux.typed_expinfo)
# 475 "parser_cocci_menhir.ml"
)
  | TMeta of (
# 109 "parser_cocci_menhir.mly"
       (Parse_aux.info)
# 480 "parser_cocci_menhir.ml"
)
  | TMPtVirg
  | TLogOp of (
# 141 "parser_cocci_menhir.mly"
       (Ast_cocci.logicalOp * Data.clt)
# 486 "parser_cocci_menhir.ml"
)
  | TLocal
  | TLineEnd of (
# 120 "parser_cocci_menhir.mly"
       (Data.clt)
# 492 "parser_cocci_menhir.ml"
)
  | TIteratorId of (
# 101 "parser_cocci_menhir.mly"
       (string * Data.clt)
# 497 "parser_cocci_menhir.ml"
)
  | TIterator
  | TIsoType
  | TIsoTopLevel
  | TIsoToTestExpression
  | TIsoTestExpression
  | TIsoStatement
  | TIsoExpression
  | TIsoDeclaration
  | TIsoArgExpression
  | TIso
  | TInvalid
  | TInt of (
# 133 "parser_cocci_menhir.mly"
       (string * Data.clt)
# 513 "parser_cocci_menhir.ml"
)
  | TInitialize
  | TInitialiser
  | TIncludeNL of (
# 126 "parser_cocci_menhir.mly"
       (string * Data.clt)
# 520 "parser_cocci_menhir.ml"
)
  | TIncludeL of (
# 126 "parser_cocci_menhir.mly"
       (string * Data.clt)
# 525 "parser_cocci_menhir.ml"
)
  | TInc of (
# 131 "parser_cocci_menhir.mly"
       (Data.clt)
# 530 "parser_cocci_menhir.ml"
)
  | TIf of (
# 99 "parser_cocci_menhir.mly"
       (Data.clt)
# 535 "parser_cocci_menhir.ml"
)
  | TIdentifier
  | TIdent of (
# 101 "parser_cocci_menhir.mly"
       (string * Data.clt)
# 541 "parser_cocci_menhir.ml"
)
  | TIdExpression
  | TGoto of (
# 100 "parser_cocci_menhir.mly"
       (Data.clt)
# 547 "parser_cocci_menhir.ml"
)
  | TGenerated
  | TFunction
  | TFunDecl of (
# 100 "parser_cocci_menhir.mly"
       (Data.clt)
# 554 "parser_cocci_menhir.ml"
)
  | TFresh
  | TForall
  | TFor of (
# 99 "parser_cocci_menhir.mly"
       (Data.clt)
# 561 "parser_cocci_menhir.ml"
)
  | TFloat of (
# 133 "parser_cocci_menhir.mly"
       (string * Data.clt)
# 566 "parser_cocci_menhir.ml"
)
  | TFinalize
  | TField
  | TExtends
  | TExpression
  | TExists
  | TEver
  | TError
  | TEqEq of (
# 140 "parser_cocci_menhir.mly"
       (Data.clt)
# 578 "parser_cocci_menhir.ml"
)
  | TEq of (
# 153 "parser_cocci_menhir.mly"
       (Data.clt)
# 583 "parser_cocci_menhir.ml"
)
  | TElse of (
# 99 "parser_cocci_menhir.mly"
       (Data.clt)
# 588 "parser_cocci_menhir.ml"
)
  | TEllipsis of (
# 119 "parser_cocci_menhir.mly"
       (Data.clt)
# 593 "parser_cocci_menhir.ml"
)
  | TDotDot of (
# 122 "parser_cocci_menhir.mly"
       (Data.clt)
# 598 "parser_cocci_menhir.ml"
)
  | TDot of (
# 153 "parser_cocci_menhir.mly"
       (Data.clt)
# 603 "parser_cocci_menhir.ml"
)
  | TDo of (
# 99 "parser_cocci_menhir.mly"
       (Data.clt)
# 608 "parser_cocci_menhir.ml"
)
  | TDmOp of (
# 143 "parser_cocci_menhir.mly"
       (Ast_cocci.arithOp * Data.clt)
# 613 "parser_cocci_menhir.ml"
)
  | TDisable
  | TDepends
  | TDefineParam of (
# 128 "parser_cocci_menhir.mly"
       (Data.clt * token * int * int)
# 620 "parser_cocci_menhir.ml"
)
  | TDefine of (
# 127 "parser_cocci_menhir.mly"
       (Data.clt * token)
# 625 "parser_cocci_menhir.ml"
)
  | TDefault of (
# 99 "parser_cocci_menhir.mly"
       (Data.clt)
# 630 "parser_cocci_menhir.ml"
)
  | TDeclarerId of (
# 101 "parser_cocci_menhir.mly"
       (string * Data.clt)
# 635 "parser_cocci_menhir.ml"
)
  | TDeclarer
  | TDeclaration
  | TDec of (
# 131 "parser_cocci_menhir.mly"
       (Data.clt)
# 642 "parser_cocci_menhir.ml"
)
  | TCppConcatOp
  | TContinue of (
# 100 "parser_cocci_menhir.mly"
       (Data.clt)
# 648 "parser_cocci_menhir.ml"
)
  | TContext
  | TConstant
  | TComma of (
# 153 "parser_cocci_menhir.mly"
       (Data.clt)
# 655 "parser_cocci_menhir.ml"
)
  | TChar of (
# 133 "parser_cocci_menhir.mly"
       (string * Data.clt)
# 660 "parser_cocci_menhir.ml"
)
  | TCase of (
# 99 "parser_cocci_menhir.mly"
       (Data.clt)
# 665 "parser_cocci_menhir.ml"
)
  | TCPar0 of (
# 123 "parser_cocci_menhir.mly"
       (Data.clt)
# 670 "parser_cocci_menhir.ml"
)
  | TCPar of (
# 123 "parser_cocci_menhir.mly"
       (Data.clt)
# 675 "parser_cocci_menhir.ml"
)
  | TCEllipsis of (
# 119 "parser_cocci_menhir.mly"
       (Data.clt)
# 680 "parser_cocci_menhir.ml"
)
  | TCCro of (
# 148 "parser_cocci_menhir.mly"
       (Data.clt)
# 685 "parser_cocci_menhir.ml"
)
  | TCBrace of (
# 147 "parser_cocci_menhir.mly"
       (Data.clt)
# 690 "parser_cocci_menhir.ml"
)
  | TBreak of (
# 100 "parser_cocci_menhir.mly"
       (Data.clt)
# 695 "parser_cocci_menhir.ml"
)
  | TBang0
  | TBang of (
# 122 "parser_cocci_menhir.mly"
       (Data.clt)
# 701 "parser_cocci_menhir.ml"
)
  | TAssign of (
# 154 "parser_cocci_menhir.mly"
       (Ast_cocci.assignOp * Data.clt)
# 706 "parser_cocci_menhir.ml"
)
  | TArobArob
  | TArob
  | TAny of (
# 120 "parser_cocci_menhir.mly"
       (Data.clt)
# 713 "parser_cocci_menhir.ml"
)
  | TAndLog of (
# 136 "parser_cocci_menhir.mly"
       (Data.clt)
# 718 "parser_cocci_menhir.ml"
)
  | TAnd of (
# 139 "parser_cocci_menhir.mly"
       (Data.clt)
# 723 "parser_cocci_menhir.ml"
)
  | TAnalysis
  | EOF

and _menhir_jeton = token


# 1 "parser_cocci_menhir.mly"
  

(* Not clear how to allow function declarations to specify a return type
and how to allow both to be specified as static, because they are in
different rules.  The rules seem to have to be combined, which would allow
functions to be declared as local variables *)

(* Not clear how to let a function have a parameter of type void.  At the
moment, void is allowed to be the type of a variable, which is wrong, and a
parameter needs both a type and an identifier *)
module Ast0 = Ast0_cocci
module Ast = Ast_cocci
module P = Parse_aux

(* ---------------------------------------------------------------------- *)
(* support for TMeta *)

let print_meta (r,n) = r^"."^n

let meta_metatable = Hashtbl.create(101)

let coerce_tmeta newty name builder matcher =
  try
    let x = Hashtbl.find meta_metatable name in
    if not (matcher x)
    then
      failwith
	(Printf.sprintf "Metavariable %s is used as %s"
	   (print_meta name) newty)
  with Not_found ->
    (if !Flag_parsing_cocci.show_SP
    then
      Common.pr2
	(Printf.sprintf
	   "Metavariable %s is assumed to be %s metavariable"
	   (print_meta name) newty));
    Hashtbl.add meta_metatable name builder

let tmeta_to_type (name,pure,clt) =
  (coerce_tmeta "a type" name (TMetaType(name,pure,clt))
     (function TMetaType(_,_,_) -> true | _ -> false));
  Ast0.wrap(Ast0.MetaType(P.clt2mcode name clt,pure))

let tmeta_to_field (name,pure,clt) =
  (coerce_tmeta "a field" name (TMetaField(name,pure,clt))
     (function TMetaField(_,_,_) -> true | _ -> false));
  P.meta_field (name,pure,clt)

let tmeta_to_exp (name,pure,clt) =
  (coerce_tmeta "an expression" name
     (TMetaExp(name,Ast0.NoConstraint,pure,None,clt))
     (function TMetaExp(_,_,_,_,_) -> true | _ -> false));
  Ast0.wrap
    (Ast0.MetaExpr(P.clt2mcode name clt,Ast0.NoConstraint,None,Ast.ANY,pure))

let tmeta_to_param (name,pure,clt) =
  (coerce_tmeta "a parameter" name (TMetaParam(name,pure,clt))
     (function TMetaParam(_,_,_) -> true | _ -> false));
  Ast0.wrap(Ast0.MetaParam(P.clt2mcode name clt,pure))

let tmeta_to_statement (name,pure,clt) =
  (coerce_tmeta "a statement" name (TMetaType(name,pure,clt))
     (function TMetaType(_,_,_) -> true | _ -> false));
  P.meta_stm (name,pure,clt)

let tmeta_to_seed_id (name,pure,clt) =
  (coerce_tmeta "an identifier" name
     (TMetaId(name,Ast.IdNoConstraint,Ast.NoVal,pure,clt))
     (function TMetaId(_,_,_,_,_) -> true | _ -> false));
  Ast.SeedId name

let tmeta_to_ident (name,pure,clt) =
  (coerce_tmeta "an identifier" name
     (TMetaId(name,Ast.IdNoConstraint,Ast.NoVal,pure,clt))
     (function TMetaId(_,_,_,_,_) -> true | _ -> false));
  Ast0.wrap(Ast0.MetaId(P.clt2mcode name clt,Ast.IdNoConstraint,Ast.NoVal,pure))

# 809 "parser_cocci_menhir.ml"
let _eRR =
  Error

module MenhirInterpreter = MenhirLib.TableInterpreter.Make (struct
  
  exception Error = Error
  
  type token = _menhir_jeton
  
  let token2terminal : token -> int =
    fun _tok ->
      match _tok with
      | EOF ->
          194
      | TAnalysis ->
          193
      | TAnd _ ->
          192
      | TAndLog _ ->
          191
      | TAny _ ->
          190
      | TArob ->
          189
      | TArobArob ->
          188
      | TAssign _ ->
          187
      | TBang _ ->
          186
      | TBang0 ->
          185
      | TBreak _ ->
          184
      | TCBrace _ ->
          183
      | TCCro _ ->
          182
      | TCEllipsis _ ->
          181
      | TCPar _ ->
          180
      | TCPar0 _ ->
          179
      | TCase _ ->
          178
      | TChar _ ->
          177
      | TComma _ ->
          176
      | TConstant ->
          175
      | TContext ->
          174
      | TContinue _ ->
          173
      | TCppConcatOp ->
          172
      | TDec _ ->
          171
      | TDeclaration ->
          170
      | TDeclarer ->
          169
      | TDeclarerId _ ->
          168
      | TDefault _ ->
          167
      | TDefine _ ->
          166
      | TDefineParam _ ->
          165
      | TDepends ->
          164
      | TDisable ->
          163
      | TDmOp _ ->
          162
      | TDo _ ->
          161
      | TDot _ ->
          160
      | TDotDot _ ->
          159
      | TEllipsis _ ->
          158
      | TElse _ ->
          157
      | TEq _ ->
          156
      | TEqEq _ ->
          155
      | TError ->
          154
      | TEver ->
          153
      | TExists ->
          152
      | TExpression ->
          151
      | TExtends ->
          150
      | TField ->
          149
      | TFinalize ->
          148
      | TFloat _ ->
          147
      | TFor _ ->
          146
      | TForall ->
          145
      | TFresh ->
          144
      | TFunDecl _ ->
          143
      | TFunction ->
          142
      | TGenerated ->
          141
      | TGoto _ ->
          140
      | TIdExpression ->
          139
      | TIdent _ ->
          138
      | TIdentifier ->
          137
      | TIf _ ->
          136
      | TInc _ ->
          135
      | TIncludeL _ ->
          134
      | TIncludeNL _ ->
          133
      | TInitialiser ->
          132
      | TInitialize ->
          131
      | TInt _ ->
          130
      | TInvalid ->
          129
      | TIso ->
          128
      | TIsoArgExpression ->
          127
      | TIsoDeclaration ->
          126
      | TIsoExpression ->
          125
      | TIsoStatement ->
          124
      | TIsoTestExpression ->
          123
      | TIsoToTestExpression ->
          122
      | TIsoTopLevel ->
          121
      | TIsoType ->
          120
      | TIterator ->
          119
      | TIteratorId _ ->
          118
      | TLineEnd _ ->
          117
      | TLocal ->
          116
      | TLogOp _ ->
          115
      | TMPtVirg ->
          114
      | TMeta _ ->
          113
      | TMetaConst _ ->
          112
      | TMetaDecl _ ->
          111
      | TMetaDeclarer _ ->
          110
      | TMetaErr _ ->
          109
      | TMetaExp _ ->
          108
      | TMetaExpList _ ->
          107
      | TMetaField _ ->
          106
      | TMetaFieldList _ ->
          105
      | TMetaFunc _ ->
          104
      | TMetaId _ ->
          103
      | TMetaIdExp _ ->
          102
      | TMetaInit _ ->
          101
      | TMetaInitList _ ->
          100
      | TMetaIterator _ ->
          99
      | TMetaLocalFunc _ ->
          98
      | TMetaLocalIdExp _ ->
          97
      | TMetaParam _ ->
          96
      | TMetaParamList _ ->
          95
      | TMetaPos _ ->
          94
      | TMetaStm _ ->
          93
      | TMetaStmList _ ->
          92
      | TMetaType _ ->
          91
      | TMetavariable ->
          90
      | TMid0 _ ->
          89
      | TMinus _ ->
          88
      | TMinusFile _ ->
          87
      | TMul _ ->
          86
      | TName ->
          85
      | TNever ->
          84
      | TNotEq _ ->
          83
      | TNothing ->
          82
      | TOBrace _ ->
          81
      | TOCro _ ->
          80
      | TOEllipsis _ ->
          79
      | TOInit _ ->
          78
      | TOPar _ ->
          77
      | TOPar0 _ ->
          76
      | TOn ->
          75
      | TOr _ ->
          74
      | TOrLog _ ->
          73
      | TPArob _ ->
          72
      | TPCEllipsis _ ->
          71
      | TPOEllipsis _ ->
          70
      | TParameter ->
          69
      | TPathIsoFile _ ->
          68
      | TPlus _ ->
          67
      | TPlus0 ->
          66
      | TPlusFile _ ->
          65
      | TPosAny ->
          64
      | TPosition ->
          63
      | TPragma _ ->
          62
      | TPtVirg _ ->
          61
      | TPtrOp _ ->
          60
      | TPure ->
          59
      | TReturn _ ->
          58
      | TRightIso ->
          57
      | TRuleName _ ->
          56
      | TScript ->
          55
      | TScriptData _ ->
          54
      | TShLOp _ ->
          53
      | TShROp _ ->
          52
      | TSizeof _ ->
          51
      | TStatement ->
          50
      | TStrict _ ->
          49
      | TString _ ->
          48
      | TSub _ ->
          47
      | TSwitch _ ->
          46
      | TSymId _ ->
          45
      | TSymbol ->
          44
      | TTilde _ ->
          43
      | TTildeEq _ ->
          42
      | TTildeExclEq _ ->
          41
      | TType ->
          40
      | TTypeId _ ->
          39
      | TTypedef ->
          38
      | TUndef _ ->
          37
      | TUnderscore ->
          36
      | TUsing ->
          35
      | TVirtual ->
          34
      | TWhen _ ->
          33
      | TWhenFalse _ ->
          32
      | TWhenTrue _ ->
          31
      | TWhile _ ->
          30
      | TWhy _ ->
          29
      | TWhy0 ->
          28
      | TWords ->
          27
      | TXor _ ->
          26
      | Tattr _ ->
          25
      | Tauto _ ->
          24
      | Tchar _ ->
          23
      | Tconst _ ->
          22
      | Tdouble _ ->
          21
      | Tenum _ ->
          20
      | Textern _ ->
          19
      | Tfloat _ ->
          18
      | Tinline _ ->
          17
      | Tint _ ->
          16
      | Tlist ->
          15
      | Tlong _ ->
          14
      | Tptrdiff_t _ ->
          13
      | Tregister _ ->
          12
      | Tshort _ ->
          11
      | Tsigned _ ->
          10
      | Tsize_t _ ->
          9
      | Tssize_t _ ->
          8
      | Tstatic _ ->
          7
      | Tstruct _ ->
          6
      | Ttypedef _ ->
          5
      | Tunion _ ->
          4
      | Tunsigned _ ->
          3
      | Tvoid _ ->
          2
      | Tvolatile _ ->
          1
  
  let error_terminal =
    0
  
  let token2value : token -> Obj.t =
    fun _tok ->
      match _tok with
      | EOF ->
          Obj.repr ()
      | TAnalysis ->
          Obj.repr ()
      | TAnd _v ->
          Obj.repr _v
      | TAndLog _v ->
          Obj.repr _v
      | TAny _v ->
          Obj.repr _v
      | TArob ->
          Obj.repr ()
      | TArobArob ->
          Obj.repr ()
      | TAssign _v ->
          Obj.repr _v
      | TBang _v ->
          Obj.repr _v
      | TBang0 ->
          Obj.repr ()
      | TBreak _v ->
          Obj.repr _v
      | TCBrace _v ->
          Obj.repr _v
      | TCCro _v ->
          Obj.repr _v
      | TCEllipsis _v ->
          Obj.repr _v
      | TCPar _v ->
          Obj.repr _v
      | TCPar0 _v ->
          Obj.repr _v
      | TCase _v ->
          Obj.repr _v
      | TChar _v ->
          Obj.repr _v
      | TComma _v ->
          Obj.repr _v
      | TConstant ->
          Obj.repr ()
      | TContext ->
          Obj.repr ()
      | TContinue _v ->
          Obj.repr _v
      | TCppConcatOp ->
          Obj.repr ()
      | TDec _v ->
          Obj.repr _v
      | TDeclaration ->
          Obj.repr ()
      | TDeclarer ->
          Obj.repr ()
      | TDeclarerId _v ->
          Obj.repr _v
      | TDefault _v ->
          Obj.repr _v
      | TDefine _v ->
          Obj.repr _v
      | TDefineParam _v ->
          Obj.repr _v
      | TDepends ->
          Obj.repr ()
      | TDisable ->
          Obj.repr ()
      | TDmOp _v ->
          Obj.repr _v
      | TDo _v ->
          Obj.repr _v
      | TDot _v ->
          Obj.repr _v
      | TDotDot _v ->
          Obj.repr _v
      | TEllipsis _v ->
          Obj.repr _v
      | TElse _v ->
          Obj.repr _v
      | TEq _v ->
          Obj.repr _v
      | TEqEq _v ->
          Obj.repr _v
      | TError ->
          Obj.repr ()
      | TEver ->
          Obj.repr ()
      | TExists ->
          Obj.repr ()
      | TExpression ->
          Obj.repr ()
      | TExtends ->
          Obj.repr ()
      | TField ->
          Obj.repr ()
      | TFinalize ->
          Obj.repr ()
      | TFloat _v ->
          Obj.repr _v
      | TFor _v ->
          Obj.repr _v
      | TForall ->
          Obj.repr ()
      | TFresh ->
          Obj.repr ()
      | TFunDecl _v ->
          Obj.repr _v
      | TFunction ->
          Obj.repr ()
      | TGenerated ->
          Obj.repr ()
      | TGoto _v ->
          Obj.repr _v
      | TIdExpression ->
          Obj.repr ()
      | TIdent _v ->
          Obj.repr _v
      | TIdentifier ->
          Obj.repr ()
      | TIf _v ->
          Obj.repr _v
      | TInc _v ->
          Obj.repr _v
      | TIncludeL _v ->
          Obj.repr _v
      | TIncludeNL _v ->
          Obj.repr _v
      | TInitialiser ->
          Obj.repr ()
      | TInitialize ->
          Obj.repr ()
      | TInt _v ->
          Obj.repr _v
      | TInvalid ->
          Obj.repr ()
      | TIso ->
          Obj.repr ()
      | TIsoArgExpression ->
          Obj.repr ()
      | TIsoDeclaration ->
          Obj.repr ()
      | TIsoExpression ->
          Obj.repr ()
      | TIsoStatement ->
          Obj.repr ()
      | TIsoTestExpression ->
          Obj.repr ()
      | TIsoToTestExpression ->
          Obj.repr ()
      | TIsoTopLevel ->
          Obj.repr ()
      | TIsoType ->
          Obj.repr ()
      | TIterator ->
          Obj.repr ()
      | TIteratorId _v ->
          Obj.repr _v
      | TLineEnd _v ->
          Obj.repr _v
      | TLocal ->
          Obj.repr ()
      | TLogOp _v ->
          Obj.repr _v
      | TMPtVirg ->
          Obj.repr ()
      | TMeta _v ->
          Obj.repr _v
      | TMetaConst _v ->
          Obj.repr _v
      | TMetaDecl _v ->
          Obj.repr _v
      | TMetaDeclarer _v ->
          Obj.repr _v
      | TMetaErr _v ->
          Obj.repr _v
      | TMetaExp _v ->
          Obj.repr _v
      | TMetaExpList _v ->
          Obj.repr _v
      | TMetaField _v ->
          Obj.repr _v
      | TMetaFieldList _v ->
          Obj.repr _v
      | TMetaFunc _v ->
          Obj.repr _v
      | TMetaId _v ->
          Obj.repr _v
      | TMetaIdExp _v ->
          Obj.repr _v
      | TMetaInit _v ->
          Obj.repr _v
      | TMetaInitList _v ->
          Obj.repr _v
      | TMetaIterator _v ->
          Obj.repr _v
      | TMetaLocalFunc _v ->
          Obj.repr _v
      | TMetaLocalIdExp _v ->
          Obj.repr _v
      | TMetaParam _v ->
          Obj.repr _v
      | TMetaParamList _v ->
          Obj.repr _v
      | TMetaPos _v ->
          Obj.repr _v
      | TMetaStm _v ->
          Obj.repr _v
      | TMetaStmList _v ->
          Obj.repr _v
      | TMetaType _v ->
          Obj.repr _v
      | TMetavariable ->
          Obj.repr ()
      | TMid0 _v ->
          Obj.repr _v
      | TMinus _v ->
          Obj.repr _v
      | TMinusFile _v ->
          Obj.repr _v
      | TMul _v ->
          Obj.repr _v
      | TName ->
          Obj.repr ()
      | TNever ->
          Obj.repr ()
      | TNotEq _v ->
          Obj.repr _v
      | TNothing ->
          Obj.repr ()
      | TOBrace _v ->
          Obj.repr _v
      | TOCro _v ->
          Obj.repr _v
      | TOEllipsis _v ->
          Obj.repr _v
      | TOInit _v ->
          Obj.repr _v
      | TOPar _v ->
          Obj.repr _v
      | TOPar0 _v ->
          Obj.repr _v
      | TOn ->
          Obj.repr ()
      | TOr _v ->
          Obj.repr _v
      | TOrLog _v ->
          Obj.repr _v
      | TPArob _v ->
          Obj.repr _v
      | TPCEllipsis _v ->
          Obj.repr _v
      | TPOEllipsis _v ->
          Obj.repr _v
      | TParameter ->
          Obj.repr ()
      | TPathIsoFile _v ->
          Obj.repr _v
      | TPlus _v ->
          Obj.repr _v
      | TPlus0 ->
          Obj.repr ()
      | TPlusFile _v ->
          Obj.repr _v
      | TPosAny ->
          Obj.repr ()
      | TPosition ->
          Obj.repr ()
      | TPragma _v ->
          Obj.repr _v
      | TPtVirg _v ->
          Obj.repr _v
      | TPtrOp _v ->
          Obj.repr _v
      | TPure ->
          Obj.repr ()
      | TReturn _v ->
          Obj.repr _v
      | TRightIso ->
          Obj.repr ()
      | TRuleName _v ->
          Obj.repr _v
      | TScript ->
          Obj.repr ()
      | TScriptData _v ->
          Obj.repr _v
      | TShLOp _v ->
          Obj.repr _v
      | TShROp _v ->
          Obj.repr _v
      | TSizeof _v ->
          Obj.repr _v
      | TStatement ->
          Obj.repr ()
      | TStrict _v ->
          Obj.repr _v
      | TString _v ->
          Obj.repr _v
      | TSub _v ->
          Obj.repr _v
      | TSwitch _v ->
          Obj.repr _v
      | TSymId _v ->
          Obj.repr _v
      | TSymbol ->
          Obj.repr ()
      | TTilde _v ->
          Obj.repr _v
      | TTildeEq _v ->
          Obj.repr _v
      | TTildeExclEq _v ->
          Obj.repr _v
      | TType ->
          Obj.repr ()
      | TTypeId _v ->
          Obj.repr _v
      | TTypedef ->
          Obj.repr ()
      | TUndef _v ->
          Obj.repr _v
      | TUnderscore ->
          Obj.repr ()
      | TUsing ->
          Obj.repr ()
      | TVirtual ->
          Obj.repr ()
      | TWhen _v ->
          Obj.repr _v
      | TWhenFalse _v ->
          Obj.repr _v
      | TWhenTrue _v ->
          Obj.repr _v
      | TWhile _v ->
          Obj.repr _v
      | TWhy _v ->
          Obj.repr _v
      | TWhy0 ->
          Obj.repr ()
      | TWords ->
          Obj.repr ()
      | TXor _v ->
          Obj.repr _v
      | Tattr _v ->
          Obj.repr _v
      | Tauto _v ->
          Obj.repr _v
      | Tchar _v ->
          Obj.repr _v
      | Tconst _v ->
          Obj.repr _v
      | Tdouble _v ->
          Obj.repr _v
      | Tenum _v ->
          Obj.repr _v
      | Textern _v ->
          Obj.repr _v
      | Tfloat _v ->
          Obj.repr _v
      | Tinline _v ->
          Obj.repr _v
      | Tint _v ->
          Obj.repr _v
      | Tlist ->
          Obj.repr ()
      | Tlong _v ->
          Obj.repr _v
      | Tptrdiff_t _v ->
          Obj.repr _v
      | Tregister _v ->
          Obj.repr _v
      | Tshort _v ->
          Obj.repr _v
      | Tsigned _v ->
          Obj.repr _v
      | Tsize_t _v ->
          Obj.repr _v
      | Tssize_t _v ->
          Obj.repr _v
      | Tstatic _v ->
          Obj.repr _v
      | Tstruct _v ->
          Obj.repr _v
      | Ttypedef _v ->
          Obj.repr _v
      | Tunion _v ->
          Obj.repr _v
      | Tunsigned _v ->
          Obj.repr _v
      | Tvoid _v ->
          Obj.repr _v
      | Tvolatile _v ->
          Obj.repr _v
  
  let default_reduction =
    (16, "\000\000\000\000\003\004\000\135\000\000\000\000\003X\001L\000\000\001J\001K\001I\000\000\001N\001M\000\001\000\000\001\134\000\000\000\000\000\151\002\030\000\000\000\000\003m\000\000\000\000\003t\003r\003n\003k\000\000\000\000\003p\003o\000\018\003\160\003\159\002#\002\"\000\000\000\017\002$\000\000\002\031\002!\000\000\003\244\000\000\000\000\001\231\001\230\001\229\001\228\000\000\000\244\000\243\000\000\000\000\002\001\000\000\001\150\001\233\000\000\000\000\000\000\000\000\000\000\000\252\000\000\000\000\001\021\001E\001\020\001\019\001\018\001\017\001D\001C\001\016\001\015\002@\000\000\000\000\002?\000\000\000\000\000\000\000\163\000\000\000\000\000\162\002C\001\r\000\000\002&\000\000\000\000\000\000\002'\002 \000\150\002,\000\000\000\000\000\000\003(\000\000\003\152\003\151\003\153\000\000\003\188\000\000\003\145\000\000\000\000\000\000\000\000\001\000\000\019\000\000\000\000\000\000\003\235\002\203\000\000\000\000\003\233\000\000\002\231\000\000\000\000\000\000\000\000\000\000\000\000\003\232\003\234\002\209\001?\002\208\001>\002\207\002\206\002\205\002\021\002\201\000\000\000\000\002\202\000\245\000\000\000\000\000\000\002\204\000\000\000\000\002\200\003\231\000\000\000\000\003\200\002\163\000\000\000\000\002\166\000\000\000\000\000\000\000y\000\000\000\000\000\000\000\000\000\000\000\000\000\246\001=\002\199\002\212\000q\000\025\000s\000\000\000\000\000U\000\000\000\000\000\000\000\000\000\000\000\000\000V\000\000\000W\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000h\002\196\000t\000\000\000\000\000\145\000\248\002\129\002\195\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\026\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\027\000\000\000\000\000\000\000\000\000\000\000r\000j\000\000\000i\000\000\002\164\002\167\000\000\002\165\002\168\003\199\000\020\000\000\002\239\000\000\000\183\000\000\000\000\002\002\000\000\001\152\001\234\000\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\001\255\000\000\001\146\000\180\000\000\000\179\000\000\001\148\001\232\000\000\000\000\002\238\000\000\000\000\000\000\002\217\000\000\000\000\000\000\002\210\000\000\000\000\000\000\000\000\002\237\002\236\002\235\002\234\002\233\002\229\000\000\003\211\002\230\000\000\003\212\002\232\000\000\003\214\000\000\002\228\000\000\000}\002\179\000\000\000\000\002\182\000\000\000\000\000\015\000\000\000\000\000\000\000\000\000\000\000m\000\000\000l\000\155\002\240\002\227\000\014\000\016\000k\0007\000\185\000u\000\000\000\000\000\000\000\000\000\000\000\000\000\147\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\0008\000\000\000\000\000\000\000\000\000\000\000\000\000\000\0009\000\000\000\000\000\000\000\000\000\000\000\000\0021\0025\000\000\000\000\000\154\0022\001\004\001\002\000\000\002\185\000\000\000\000\002\180\002\183\000\000\002\181\002\184\003\213\000\000\000\000\002\198\001\026\000\000\002\023\000\000\000\000\000\000\000\000\000\000\000\250\002\029\000\000\000\000\001\166\002\197\000\000\000\000\002\225\000\000\000\000\002\224\000\000\000\000\000\000\000\000\000\000\002\022\000\000\000\000\000\000\000\000\000\240\000\239\000\000\000\000\002\223\001^\001]\002\222\000\000\002\221\002\220\002\219\001`\002\215\000\000\003\204\002\216\000\000\000\000\000\000\000\000\000\000\000\238\000\000\003\205\002\218\000\000\003\207\000\000\002\214\000\000\000\000\000{\002\171\000\000\000\000\002\174\000\000\000\000\002\177\000\000\000\000\002\172\002\175\000\000\002\173\002\176\002\226\002\213\003\206\000\000\001\b\001Y\000\000\000\000\000\000\000\000\001[\000\000\001\132\000(\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000)\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000*\000\000\000\000\000\000\000\000\001\\\000\000\001V\000\000\000\000\002F\000\000\000\000\000\000\000\167\000\000\000\000\000\166\002J\001_\001W\000\000\000\254\001U\002G\000\000\001Z\000\000\002\178\000|\000\000\002\170\003\208\000\000\002\186\000~\000\000\002\169\003\227\003\228\003\226\003\225\003\198\000\000\000\000\003\197\000\000\002\019\000\000\002\211\000\000\000\000\000z\000\000\000\000\000\000\003\215\000\000\002\020\000\000\000\000\000\000\003\229\000\000\000\000\000\000\003\201\000\000\000g\000\184\000\000\001~\000\000\003\157\003'\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002f\000\189\000\190\000\000\000\000\000\000\000\000\000\000\002T\002e\002\t\000\000\000\000\000\000\000\000\000\000\001\012\000\194\000\000\002\n\000\000\000\000\000\000\000\000\000\188\000\000\000\186\000\175\000\000\000\000\000\174\002X\002U\000\000\000\000\003\156\000\000\003\155\000\000\000\000\000\000\003\158\003\146\003\147\000\000\002)\000\000\003\149\000\000\000\000\000\177\003\150\000\000\000\000\000\000\002*\003\187\000\000\000\000\002\b\000\000\001\164\001\241\000\000\003\154\000\000\000\000\002+\000\000\000\000\001d\000\000\001c\000\000\001r\000\000\001\136\000\000\000\000\000\000\001\184\000\000\003\191\000\000\000\000\002\005\001\185\000\000\001\158\001\238\003\192\000\000\003\195\003\194\000\000\000\000\003h\003\193\000\143\000\000\000\224\000\000\000\000\000\000\001|\003\190\000\000\003\189\003\141\003\143\003\144\003\142\000\000\000\000\000\000\000\000\000\000\001Q\000\000\000\000\000\000\000\000\000\000\000\192\000\204\000\191\000\000\000\000\000\132\000\000\000\000\000\000\000\216\000\000\003R\000\000\000\000\000\212\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\219\000\000\000\000\000\223\001$\001#\000\000\000\000\000\000\000\000\001B\000\000\000\000\000\000\000\000\000\209\000\000\000\206\000\000\000\000\000\000\000\000\000\000\000\217\000\000\000\213\000\000\000\000\000\000\000\000\000\214\000\000\000\210\000\000\000\000\000\000\000\000\002\245\000\000\000\000\000\000\000\000\003\222\000\000\003\132\000\000\003\131\000\000\000\000\000\000\000\000\003\242\000\000\000\000\000\000\003\243\000\000\000\022\000\000\000\000\000\000\000\000\002\252\000\000\000\000\000\000\002\251\002\250\002\249\002\248\002\247\002\243\000\000\003\218\002\244\000\000\003\219\002\246\000\000\003\221\000\000\002\242\000\000\000\127\002\187\000\000\000\000\002\190\000\000\000\000\002\193\000\000\000\000\002\188\002\191\000\000\002\189\002\192\002\254\002\241\003\220\000\000\000\000\000p\000\000\000o\000\000\002\253\000\000\001\235\000n\000F\001\025\000v\000\000\000\000\000\000\000\000\000\000\000\000\000\149\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000G\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000H\000\000\000\000\000\000\000\000\000\000\000\000\002\194\000\128\000\000\003\238\000\000\001\168\000\000\000\000\000\000\000\195\003y\001z\000\000\001y\001P\001O\000\000\000\000\000\000\000\000\000\000\000\000\000\000\003\136\000\000\000\000\002h\000\000\000\000\000\000\002p\000\000\000\000\002t\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002w\000\000\000\000\002{\000\000\002j\000\000\000\000\002m\000\000\000\000\000\000\002q\000\000\000\000\002u\000\000\000\000\002n\000\000\000\000\002r\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\159\000\247\000\000\000\000\0028\000\000\000\000\000\158\002<\0029\001\006\000\225\000\000\000\227\000\226\000\000\003\134\000\000\003\133\003u\000\000\000\000\000\000\000\000\000\000\003\128\000\000\003z\000\000\003\135\000\000\000\000\000\000\000\000\003\129\003w\002\131\000\000\000\199\001R\000\000\003\138\000\000\001T\000\000\000\000\003\166\000\000\003\173\000\201\000\000\000\207\000\000\003\167\000\200\000\000\003\168\000\000\003\175\000\000\000\000\000\000\000\000\000\220\000\000\000\000\000\221\000\000\000\203\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\218\000\000\000\000\000\222\000\000\000\000\000\000\000\000\001A\000\000\000\000\000\000\000\208\000\000\000\205\000\000\000\000\000\000\000\000\000\000\000\215\000\000\000\211\000\197\000\196\000\000\003\176\003\177\000\000\003\178\000\000\003\179\000\000\001S\003}\000\000\000\000\000\000\000\000\000\000\003~\002k\000\000\000\000\000\000\000\000\002x\000\000\000\000\002y\000\000\002g\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002v\000\000\000\000\002z\000\000\002i\000\000\000\000\002l\000\000\000\000\000\000\002o\000\000\000\000\002s\000\000\000\000\002\007\000\000\001\162\001\240\000\000\003v\000\000\000\000\000\000\003|\000\000\000\000\000\000\0016\000\000\0010\000\000\0011\000\000\001;\001/\001:\000\000\003\137\001<\000\000\000\202\000\000\000\000\000\000\000\000\0018\0013\002\003\000\000\0014\000\000\0015\000\000\001\154\001\236\000\000\000\000\000\000\002\015\000\000\002\r\000\000\000\000\002\017\002\011\000\000\002\018\002\012\000\000\003\139\002\024\000\000\000\198\000\000\000\000\002\004\000\000\001\156\001\237\000\000\003\239\000\000\003\236\000\000\003\237\000\023\000\024\000\000\000\000\0034\000\000\0033\000\000\000\000\0036\000\000\0035\000\000\000\000\002\006\000\000\0032\0031\000\000\001\160\001\239\000\000\0037\000\000\000\000\003\240\000\021\000\130\000\000\003\241\000\000\000\000\003N\000\000\000\000\003\140\000w\000\000\000\000\000\000\000x\000\000\003\130\000\000\001\128\000\000\001\130\003\127\000\000\000\000\001l\000\000\001k\000\000\001s\000\000\001\144\000\000\000\000\000\000\001h\000\000\001g\000\000\001p\000\000\001\140\000\000\000\000\000\000\001o\000\000\000\000\001w\000\000\000\000\001j\001x\000\000\001i\000\000\001q\000\000\001\142\000\000\000\000\000\000\001m\000\000\000\000\000\000\001f\000\000\001e\000\000\001t\000\000\001\138\000\000\000\000\000\000\001n\000\002\000\000\000d\000\000\000\000\001\227\000e\000\000\000\000\003\014\003\018\003\022\003\n\003\027\003\007\000\000\000\000\003\019\003\026\003\011\003\025\003\t\003\024\003\r\003\005\003\012\003\021\003\b\003\015\003\006\003\017\003\023\003\020\003\016\001\190\001\189\000\141\000\000\000\000\003d\000\000\000\000\000\000\000\000\003I\003F\000\000\000\000\003J\003G\003H\003%\000\000\000\000\003j\003\029\003\028\003\030\000\000\001\207\000c\001u\000\003\000\000\000\000\003\001\000\000\002\127\000\000\000\142\000\000\000\000\003f\000\000\000\000\000\000\000\134\000\000\000\000\003V\000\000\002b\002a\001\181\003&\000\000\001\222\000\000\003\002\000\000\000\000\000\136\000\000\000\000\003Z\000\000\001\204\000\000\000\000\001\196\000\000\000\000\000\000\001\203\000\000\001\199\000\000\000\000\000\000\000\000\000\000\001\171\001\170\001\169\000\000\000\000\000\000\001\223\000\000\001\194\000\000\001\193\000\000\000\131\000\000\000\000\003P\000\000\000\000\001\188\000\000\000\000\001\192\000\000\000\000\000\139\000\000\000\000\003`\000\000\000\000\003/\000\000\003.\000\000\000\000\000\000\002`\002_\003,\002\137\003!\003-\000\000\001\210\000\000\000\000\000\000\001\206\000\000\001\212\000\000\000\000\000\000\000\000\000\000\000\000\001\226\000\000\001\198\000\000\001\197\000\000\000\000\000\000\003#\000\140\000\000\000\000\003b\000\000\003\"\000\000\001\208\000\000\000\000\001\209\000\000\000\000\000\000\000\000\000\000\000\000\001\225\000\000\001\202\000\000\001\201\000\000\000\000\001\030\000\000\001\029\000\000\000\000\000\000\000\000\000\000\001\224\000\000\001\195\000\000\001\028\000\000\002.\000\137\000\000\000\000\003\\\000\000\000\000\000\000\000\000\003\162\003\161\000\000\000\000\001H\001G\000\133\001F\000\000\000\000\003T\000\000\002Z\002Y\002\\\003\031\002\133\002[\001\027\000\000\000\138\000\000\000\000\003^\000\000\000\000\000\000\000\000\002^\002]\003+\003)\002\135\003 \003*\000\000\001\217\000\000\001\220\000\000\000\000\001\213\000\000\000\000\000\000\001\205\000\000\001\211\000\000\000\000\001\200\000\000\000\000\000\000\000\000\000\000\000\000\001\187\000\000\000\000\001\219\000\000\001\218\000\000\000\000\000\000\000\000\001\216\000\000\000\000\001\215\000\000\001\214\000\000\000\000\001\221\000\000\000\000\001v\000\004\000\000\001\191\000\005\000\000\000\000\001!\000\006\000\000\001\245\001\246\001\244\000\000\001\243\003\163\001\177\000\000\000\007\000\000\001\248\001\249\001\247\000\000\000\000\000\000\000\000\001&\000\000\000\000\000\000\000\000\001+\001-\001,\001'\001)\001(\000\000\000\000\000\000\000\000\000\000\003\169\003\182\000\000\003\170\000\000\003\171\000\000\000\000\003\164\000\000\000\000\000\000\000\000\003\181\000\000\000\000\003\180\001\253\001\252\000\000\000\000\001\179\001\242\001\250\000\000\000\000\000\000\000\000\000\000\002d\000\000\000\000\000\000\000\000\000\000\002M\002c\000\000\000\000\000\000\000\171\000\000\000\000\000\170\002Q\002N\001\n\000\193\000\000\000\000\000\000\000\000\001@\001\"\000\000\003\185\000\000\003\186\000\000\000\000\002\027\002\025\000\000\002\026\002\028\000\b\000\000\000\t\000\000\002\152\002\153\002\151\000\000\002\150\000\000\000\n\000\000\002\155\002\156\002\154\000\000\002\158\000\000\000\000\000\000\002\144\000\000\000\000\002\146\000\000\002\140\000\000\002\142\000\000\002\147\000\000\002\148\000\000\002\141\002\139\002\159\001\183\002\149\000\000\002\161\000\000\002\160\000\000\002\162\000\000\0030\000\011\000\000\000\000\000\000\000\000\000\000\000\000\000\228\000\000\000\000\000\232\000\000\000\231\000\000\000\229\000\000\000\000\000\000\000\000\000\000\000\233\000\230\000\000\000\235\000\000\000\000\000\000\003<\000\000\003;\000\000\000\000\000\000\000\000\003=\000\000\000\000\001 \000\000\000\000\000\000\000\000\000\000\003L\000\129\000\000\000\000\000\242\000\000\001\023\001\022\000\000\001b\000\000\003:\001\175\001\173\000\000\000\000\000\000\000\000\003>\000\012\000\000\000\000\000\000\000\000\000\000\000\000\000\000\0039\000\000\000\000\000\000\000\000\000\000\000\000\0038\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\003E\000\000\000\000\003D\000\000\003A\000\000\000\000\000\000\000\000\000\000\003B\000\000\000\000\000\000\003C\000\r\000\000\003?\000\000\003@")
  
  let error =
    (195, "\000\000\000\0000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\012\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\003\000\000\000\000\000\000\000\000\000\002\000\000 \004\024\000\000\b\016\192\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\192\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\0000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\012\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\003\252\000\000\000\000\000\000\000\000={W\128\000\128\000@\000\004\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000F\180p\000\001\0001\000\003\000\020\b`\017\000 \b@\000\000\000&C\b\bN\134\128\020a\006\168 d2\129\012\002h\004C\188\t\000\002\028\200a\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000!z\026\000Q\132\026\160\129\144\202\0040\t\160\017\014\240$\000\bs!\132\004'C@\n0\131T\0162\025@\134\0014\002!\222\004\128\001\014d0\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\026\209\192\000\004\000\196\000\012\000P!\128D\000\128!\000\000\000\000\153\012 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\133\234h\001F\016j\130\006C(\016\192&\128D;\192\144\000!\204\134\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\000\000\000\016\000\000@\000\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\000\000\b \000\001\000@\000\000 \000\002\000\000\000\000\000\000\000\000\000\000\128\000\000\001\000\000\000 \b\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\016\000\000\000 \000\000\004\001\000\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000A\000\000\b\002\000\000\001\000\000\016\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\129\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\000\000\000 \000\000\004\001\000\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\000\016\000\001\002\000\000\000\000\000\000\001\000\000\000\000\000\000\000\1940\000\b\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\004\000\000\000\000\000\000\002\000\000\000\004\016\000\000\128 \000\000\016\000\001\000\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\002\000\000\000\000\000\000\001\000\000\000\002\b\000\000@\016\000\000\b\000\000\000\000\000@\000\000\000\000\000\000 \000\000\000A\000\000\b\002\000\000\001\000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016 \000\000\000\000\000\000\016\000\000\000 \128\000\004\001\000\000\000\128\000\b\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\tP\208\002\140 \213\004\012\198P!\128M\000\136w\129 \000C\153\012 \000\000\000\000\000\128\000\000\001\004\000\000 \b\000\000\004\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\003\215\181x\000\b\000\004\000\000@\000\128\000\000\000\000\000\000\000\000\000\000\000\000\001\tP\208\002\140 \213\004\012\198P!\128M\000\136w\129 \000C\153\012/^\213\224\000 \128\016\000\001\004\002\000\012\b\000\000\004\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000={W\128\000\130\000@\000\004\000\b\0000 \000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b \000\000\000B\000\000\b\002\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\015^\213\224\000 \128\016\000\001\004\002\000\012\b\000\000\004\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000={W\128 \130\000@\000\004\016\b\0000 \000\000\016\000\000\000\000\000\128\000\000\000\000\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\245\237^\000\002\b\001\000\000\016\000 \000\192\128\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\000\000\001\000\000\000 \b\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\000\002\000\000\000\000\000\000\000\000\000 \000\002 \000\000\000\000\000\000\nH\000\t\006\129@1\198`\000\016\144\b\001\000\b!\016\192\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\005$\000\004\131@\160\024\2270\000\bH\004\000\128\004\016\b`\000\000\000\000\000\164\128\000\144h\020\003\028f\000\001\t\000\128\016\000\130\001\012\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\146\000\002A\160P\012q\152\000\004$\002\000\000\002\b\0040\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\nH\000\t\006\129@1\198`\000\016\144\b\001\000\b \016\192\000\000\000\000\001I\000\001 \208(\0068\204\000\002\018\001\000 \001\004\002\024\245\237^\000\002)!\000$\026\005 \199\025\128\000B@ \004\000 \128C\030\189\171\192\000E$ \004\131@\164\024\2270\000\bH\004\000\128\004\016\b`\000\000\000\000\000\164\128\000\144h\020\003\028f\000\001\t\000\128\000\000\130\001\012\000\000\000\000\000\020\144\000\018\r\002\128c\140\192\000! \016\002\000\016@!\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001I\000\001 \208(\0068\204\000\002\018\001\000 \001\004\002\024\245\237^\000\002)!\000$\026\005 \199\025\128\000B@ \004\000 \128C\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\020\144\000\018\r\002\128c\140\192\000! \016\002\000\016@!\128\000\000\000\000\002\146\000\002A\160P\012q\152\000\004$\002\000@\002\b\0040\000\000\000\000\000R@\000H4\n\001\1423\000\000\132\128@\b\000A\000\134\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001I\000\001 \208(\0068\204\000\002\018\001\000 \001\004\002\024\000\000\000\000\000\b\000\000\000\000\000\000\002\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\020\144\000\018\r\002\128c\140\192\000! \016\002\000\016@!\128\000\000\000\000\002\146\000\002A\160P\012q\152\000\004$\002\000@\002\b\0040\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002@\000\000\196\1936Y,\000\000\001@\b\016\000\001\186\001\t\241\218\000\000\000\000\000\b\000\000\000\016\000\000\002\000\128\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\003\215\181x\000\b\164\132\000\144i\020\131\028\230\000\001\t\000\128\016\000\130A\012z\246\175\000\001\020\144\128\018\r\002\144c\140\192\000! \016\002\000\016@!\128\000\000\000\000\002\146\000\002A\160P\012q\152\000\004$\002\000@\002\b\0040\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\018\000\000\006&\t\178\201`\000\000\n\000@\128\000\r\208\bO\142\208\000\000\000\000\001I\000\001 \208(\0068\204\000\002\018\001\000 \001\004\002\024\000\000\000H\000\000\024\136&\194%\128\000\000(\001\000\000\0006@\001<;@\000\000\000\000\005$\000\004\131@\160\024\2270\000\bH\004\000\128\004\016\b`\000\000\001 \000\000b \155\b\150\000\000\000\160\004\000\000\000\217\000\004\240\237\000\000\000\000\000\020\144\000\018\r\002\128c\140\192\000! \016\002\000\016@!\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000$\000\000\012D\019a\018\192\000\000\020\000\128\000\000\019 \000\158\r\160\000\000\000\000\002\146\000\002A\160P\012q\152\000\004$\002\000@\002\b\0040\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\018\000\000\006\"\t\176\137`\000\000\n\000@\000\000\t\144\000O\006\208\000\000\000\000\001I\000\001 \208(\0068\204\000\002\018\001\000 \001\004\002\024\000\000\000H\000\000\024\136&\194%\128\000\000(\001\000\000\000&@\001>\027@\000\000\000\000\005$\000\004\131@\160\024\2270\000\bH\004\000\128\004\016\b`\000\000\001 \000\000b \155\b\150\000\000\000\160\004\000\000\000\153\000\004\248m\000\000\000\000\000\020\144\000\018\r\002\128c\140\192\000! \016\002\000\016@!\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000R@\000H4\n\001\1423\000\000\132\128@\b\000A\000\134\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001I\000\001 \208(\0068\204\000\002\018\001\000 \001\004\002\024\000\000\000H\000\000\024\136&\194%\128\000\000(\001\000\000\000&@\001>\027@\000\000\000\000\005$\000\004\131@\160\024\2270\000\bH\004\000\128\004\016\b`\000\000\001 \000\000b \155\b\150\000\000\000\160\004\000\000\000\153\000\004\248m\000\000\000\000\000\020\144\000\018\r\002\128c\140\192\000! \016\002\000\016@!\128\000\000\004\128\000\001\136\130l\"X\000\000\002\128\016\000\000\002d\000\019\225\180\000\000\000\000\000R@\000H4\n\001\1423\000\000\132\128@\b\000A\000\134\000\000\000\018\000\000\006\"\t\176\137`\000\000\n\000@\000\000\t\144\000O\134\208\000\000\000\000\001I\000\001 \208(\0068\204\000\002\018\001\000 \001\004\002\024\000\000\000H\000\000\024\136&\194%\128\000\000(\001\000\000\000&@\001>\027@\000\000\000\000\005$\000\004\131@\160\024\2270\000\bH\004\000\128\004\016\b`\000\000\001 \000\000b \155\b\150\000\000\000\160\004\000\000\000\153\000\004\248m\000\000\000\000\000\020\144\000\018\r\002\128c\140\192\000! \016\003\000\016@!\128\000\000\000\000\000\000\b\128\000\000\b\000\000\000\128\016\000\000\000`\000\019A\132\000\000\000\000\000R@\000H4\n\001\1423\000\000\132\128@\b\000A\000\134\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\164\128\000\144h\020\003\028f\000\001\t\000\128\016\000\130\001\012\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001I\000\001 \208(\0068\204\000\002\018\001\000 \001\004\002\024\000\000\000H\000\000\024\136&\194%\128\000\000(\001\000\000\000&@\001<\027@\000\000\000\000\005$\000\004\131@\160\024\2270\000\bH\004\000\128\004\016\b`\000\000\001 \000\000b \155\b\150\000\000\000\160\004\000\000\000\153\000\004\240m\000\000\000\000\000\020\144\000\018\r\002\128c\140\192\000! \016\002\000\016@!\128\000\000\004\128\000\001\136\130l\"X\000\000\002\128\016\000\000\002d\000\019\193\180\000\000\000\000\000R@\000H4\n\001\1423\000\000\132\128@\b\000A\000\134\000\000\000\018\000\000\006\"\t\176\137`\000\000\n\000@\000\000\t\144\000O\006\208\000\000\000\000\001I\000\001 \208(\0068\204\000\002\018\001\000 \001\004\002\024\000\000\000H\000\000\024\136&\194%\128\000\000(\001\000\000\000&@\001>\027@\000\000\000\000\005$\000\004\131@\160\024\2270\000\bH\004\000\128\004\016\b`\000\000\001 \000\000b \155\b\150\000\000\000\160\004\000\000\000\153\000\004\248m\000\000\000\000\000\020\144\000\018\r\002\128c\140\192\000! \016\002\000\016@!\128\000\000\004\128\000\001\136\130l\"X\000\000\002\128\016\000\000\002d\000\019\225\180\000\000\000\000\000R@\000H4\n\001\1423\000\000\132\128@\b\000A\000\134\000\000\000\018\000\000\006\"\t\176\137`\000\000\n\000@\000\000\t\144\000O\006\208\000\000\000\000\001I\000\001 \208(\0068\204\000\002\018\001\000 \001\004\002\024\000\000\000H\000\000\024\136&\194%\128\000\000(\001\000\000\000&@\001<\027@\000\000\000\000\005$\000\004\131@\160\024\2270\000\bH\004\000\128\004\016\b`\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\020\144\000\018\r\002\128c\140\192\000! \016\002\000\016@!\128\000\000\004\128\000\001\136\130l\"X\000\000\002\128\016\000\000\002d\000\019\193\180\000\000\000\000\000R@\000H4\n\001\1423\000\000\132\128@\b\000A\000\134\000\000\000\018\000\000\006\"\t\176\137`\000\000\n\000@\000\000\t\144\000O\006\208\000\000\000\000\001I\000\001 \208(\0068\204\000\002\018\001\000 \001\004\002\024\000\000\000H\000\000\024\136&\194%\128\000\000(\001\000\000\000&@\001<\027@\000\000\000\000\005$\000\004\131@\160\024\2270\000\bH\004\000\128\004\016\b`\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\020\144\000\018\r\002\128c\140\192\000! \016\002\000\016@!\128\000\000\004\128\000\001\136\130l\"X\000\000\002\128\016\000\000\002d\000\019\193\180\000\000\000\000\000R@\000H4\n\001\1423\000\000\132\128@\b\000A\000\134\000\000\000\018\000\000\006\"\t\176\137`\000\000\n\000@\000\000\t\144\000O\006\208\000\000\000\000\001I\000\001 \208(\0068\204\000\002\018\001\000 \001\004\002\024\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\164\128\000\144h\020\003\028f\000\001\t\000\128\016\000\130\001\012\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\128\000\000\016\004\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\005$\000\004\131@\160\024\2270\000\bH\004\000\128\004\016\b`\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\b\000\007\175j\240\000\016\000\b\000\000\128\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\014\189\171@\000@\000 \000\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\148\b\000\000\000\004\000\000\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\018\129\000\000\000\000\128\000\000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000!\n\024\000\000\128\b\128\001\128H\0040\b\128\016\004 \000\000\000\019!\133\004!K\000\000\016\001\016\0000\t\000\134\001\016\002\000\132\000\000\000\002d0\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\133\012\000\000@\004@\000\192$\002\024\004@\b\002\016\000\000\000\t\144\194\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\bB\134\000\000 \002 \000`\018\001\012\002 \004\001\b\000\000\000\004\200a\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\007\175j\240\000\017I\b\001 \208)\0068\204\000\002\018\001\000 \001\004\002\024\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\020\144\000\018\rB\128c\140\192\000! \016\000\000\016@!\128\000\000\000\000\002\146\000\002A\188P\r\241\152\000\012$\002\001P\002\b$0\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\nH\000\t\006\129@1\198`\000\016\144\b\001\000\b \016\199\175j\240\000\017I\b\001 \208)\0068\204\000\002\018\001\000 \001\004\002\024\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000 \000\000\012\000\016`R\128\000\000\016\000\000\000\000\016 \000\129\001\128\000\000\000\000\002\146\000\002A\188P\r\241\152\000\012$\002\001P\002\b$0\000\000\000\000\000R@\000H4\n\001\1423\000\000\132\128@\000\000A\000\134\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\146\000\002A\160P\012q\152\000\004$\002\000@\002\b\0040\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001I\000\001 \208(\0068\204\000\002\018\001\000 \001\004\002\024\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\164\128\000\144h\020\003\028f\000\001\t\000\128\016\000\130\001\012\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\000\000\000\000\000\000 \000\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\nH\000\t\006\129@1\198`\000\016\144\b\000\000\b \016\192\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\t\000\000\003\002\004Y$\160\000\000\004\000\000@\000\006\168\004#\004`\000\000\000\000\000 \000\000\000@\000\000\b\002\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\015^\213\224\000\"\146\016\002A\164R\012s\152\000\004$\002\000@\002\t\0041\235\218\188\000\004RB\000H4\138A\142s\000\000\132\128@\b\000A\000\134\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\128\000\245\237^\000\002)!\000$\026E \1999\128\000B@ \000\000 \144C\030\189\171\192\000E$ \004\131H\164\024\2310\000\bH\004\000\128\004\016\b`\000\000\001 \000\000`\000\139\000\148\000\000\000\128\000\000\000\000\209\000\004`\140\000\000\000\000\000\020\144\000\018\r\002\128c\140\192\000! \016\002\000\016@!\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000R@\000H4\n\001\1423\000\000\132\128@\b\000A\000\134\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000H\000\000\024\000\"\192%\000\000\000 \000\000\000\000$@\001\024\003\000\000\000\000\000\005$\000\004\131@\160\024\2270\000\bH\004\000\128\004\016\b`\000\000\001 \000\000`\000\139\000\148\000\000\000\128\000\000\000\000\145\000\004`\012\000\000\000\000\000\020\144\000\018\r\002\128c\140\192\000! \016\003\000\016@!\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\000R@\000H4\n\001\1423\000\000\132\128@\b\000A\000\134\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001I\000\001 \208(\0068\204\000\002\018\001\000 \001\004\002\024\000\000\000H\000\000\024\000\"\192%\000\000\000 \000\000\000\000$@\001\024\003\000\000\000\000\000\005$\000\004\131@\160\024\2270\000\bH\004\000\128\004\016\b`\000\000\001 \000\000`\000\139\000\148\000\000\000\128\000\000\000\000\145\000\004`\012\000\000\000\000\000\020\144\000\018\r\002\128c\140\192\000! \016\002\000\016@!\128\000\000\004\128\000\001\128\002,\002P\000\000\002\000\000\000\000\002D\000\017\1280\000\000\000\000\000R@\000H4\n\001\1423\000\000\132\128@\b\000A\000\134\000\000\000\018\000\000\006\000\b\176\t@\000\000\b\000\000\000\000\t\016\000F\000\192\000\000\000\000\001I\000\001 \208(\0068\204\000\002\018\001\000 \001\004\002\024\000\000\000H\000\000\024\000\"\192%\000\000\000 \000\000\000\000$@\001\024\003\000\000\000\000\000\005$\000\004\131@\160\024\2270\000\bH\004\000\128\004\016\b`\000\000\001 \000\000`\000\139\000\148\000\000\000\128\000\000\000\000\145\000\004`\012\000\000\000\000\000\020\144\000\018\r\002\128c\140\192\000! \016\002\000\016@!\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000R@\000H4\n\001\1423\000\000\132\128@\b\000A\000\134\000\000\000\018\000\000\006\000\b\176\t@\000\000\b\000\000\000\000\t\016\000F\000\192\000\000\000\000\001I\000\001 \208(\0068\204\000\002\018\001\000 \001\004\002\024\000\000\000H\000\000\024\000\"\192%\000\000\000 \000\000\000\000$@\001\024\003\000\000\000\000\000\005$\000\004\131@\160\024\2270\000\bH\004\000\128\004\016\b`\000\000\001 \000\000`\000\139\000\148\000\000\000\128\000\000\000\000\145\000\004`\012\000\000\000\000\000\020\144\000\018\r\002\128c\140\192\000! \016\002\000\016@!\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000R@\000H4\n\001\1423\000\000\132\128@\b\000A\000\134\000\000\000\018\000\000\006\000\b\176\t@\000\000\b\000\000\000\000\t\016\000F\000\192\000\000\000\000\001I\000\001 \208(\0068\204\000\002\018\001\000 \001\004\002\024\000\000\000H\000\000\024\000\"\192%\000\000\000 \000\000\000\000$@\001\024\003\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\"\000\003\215\181x\000\b\164\132\000\144i\020\131\028\230\000\001\t\000\128\016\000\130A\012\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002 \000={W\128\000\138H@\t\006\145H1\206`\000\016\144\b\001\000\b$\016\192\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000R@\000H4\n\001\1423\000\000\132\128@\b\000A\000\134\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\000\000\002\000\000\000@\016\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000\000\b\000\002\016\000\000\000\000\000\000\nH\000\t\006\129@1\198`\000\016\144\b\000\000\b \016\192\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000\000\002\000\000\004\000\000\000\000\000\b\002\146\000\002A\160P\012q\152\000\004$\002\000\000\002\b\0040\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\nH\000\t\006\129@1\198`\000\016\144\b\001\000\b \016\192\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\164\128\000\144h\020\003\028f\000\001\t\000\128\000\000\130\001\012\000\000\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000\000\002\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\nH\000\t\006\129@1\198`\000\016\144\b\001\000\b \016\192\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\030\189\171\192\000E$ \004\131@\164\024\2270\000\bH\004\000\128\004\016\b`\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\000\000\000\000\000\000R@\000@1\n\001\1422\000\001\132\128@\000\000A\000\134\000\000\000\000\000\nH\000\t\006\241@7\198`\0000\144\b\005@\b \144\192\000\000\000\000\001I\000\001 \208(\0068\204\000\002\018\001\000\000\001\004\002\024\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\164\128\000\144h\020\003\028f\000\001\t\000\128\016\000\130\001\012\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\002\000\000\000\000\000\000\002\146\000\002A\160P\012q\152\000\004$\002\000@\002\b\0040\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000) \000$\027\197\000\223\025\128\000\194@ \021\000 \130C\000\000\000\000\000\005$\000\004\131x\160\027\2270\000\024H\004\002\160\004\016\b`\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\018\000\000\006&\t\178\201`\000\000\n\000@\128\000\r\208\bJ\142\208\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\146\000\002A\160P\012q\152\000\004$\002\000@\002\b\0040\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\016\000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\005$\000\004\131P\160\025\2270\000\bH\004\000\128\004\016\b`\000\000\000\000\000\164\128\000\144o\020\003|f\000\003\t\000\128T\000\130\t\012\000\000\000\000\000\004\000\000\000\b\000\000\001\000@\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000R@\000H4\n\001\1423\000\000\132\128@\b\000A\000\134\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000) \000$\026\005\000\199\025\128\000B@ \004\000 \128C\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\b\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\128\000\001\137\130l\178X\000\000\002\128\016 \000\003t\002\018\163\180\000\000\000\000\000R@\000@0\n\001\1422\000\001\132\128@\000\000A\000\134\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\024\016 \201%\000\000\000 \000\002\000\000!@!\002\003\000\000\000\000\000\001\000\000\000\002\000\000\000@\016\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000z\246\175\000\001\020\144\128\018\r\"\144c\156\192\000! \016\002\000\016H!\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\nH\000\t\006\129@1\198`\000\016\144\b\001\000\b \016\192\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000@\000\000\b\002\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000H\000\000\024\024 \201%\128\000\000 \000\002\000\0003@!\"#\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000\002\146\000\002A\184P\r\241\152\000\012$\002\001\016\002\b\0040\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\nH\000\t\006\225@7\198`\0000\144\b\004@\b \016\192\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000\017\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\012\000\016`\018\128\000\000\016\000\000\000\000\016 \000\129\001\128\000\000\000\000\002\146\000\002A\160P\012q\152\000\004$\002\000@\002\b\0040\000\000\000\128\000\0000\000A\128J\000\000\000@\000\000\000\000@\128\002\004\006\000\000\000\000\000\nH\000\t\006\129@1\198`\000\016\144\b\001\000\b \016\192\000\000\002\000\000\000\192\001\006\001(\000\000\001\000\000\000\000\001\002\000\b\016\024\000\000\000\000\000) \000$\026\005\000\199\025\128\000B@ \004\000 \128C\000\000\000\b\000\000\003\000\004\024\004\160\000\000\004\000\000\000\000\004\b\000 @`\000\000\000\000\000\164\128\000\144h\020\003\028f\000\001\t\000\128\016\000\130\001\012\000\000\000 \000\000\012\000\016`\018\128\000\000\016\000\000\000\000\016 \000\129\001\128\000\000\000\000\002\146\000\002A\160P\012q\152\000\004$\002\000@\002\b\0040\000\000\000\128\000\0000\000A\128J\000\000\000@\000\000\000\000@\128\002\004\006\000\000\000\000\000\nH\000\t\006\129@1\198`\000\016\144\b\001\000\b \016\192\000\000\002\000\000\000\192\001\006\001(\000\000\001\000\000\000\000\001\002\000\b\016\024\000\000\000\000\000) \000$\026\005\000\199\025\128\000B@ \004\000 \128C\000\000\000\b\000\000\003\000\004\024\004\160\000\000\004\000\000\000\000\004\b\000 @`\000\000\000\000\000\164\128\000\144h\020\003\028f\000\001\t\000\128\016\000\130\001\012\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\146\000\002A\160P\012q\152\000\004$\002\000@\002\b\0040\000\000\000\128\000\0000\000A\128J\000\000\000@\000\000\000\000@\128\002\004\006\000\000\000\000\000\nH\000\t\006\129@1\198`\000\016\144\b\001\000\b \016\192\000\000\002\000\000\000\192\001\006\001(\000\000\001\000\000\000\000\001\002\000\b\016\024\000\000\000\000\000) \000$\026\005\000\199\025\128\000B@ \004\000 \128C\000\000\000\b\000\000\003\000\004\024\004\160\000\000\004\000\000\000\000\004\b\000 @`\000\000\000\000\000\164\128\000\144h\020\003\028f\000\001\t\000\128\016\000\130\001\012\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\146\000\002A\160P\012q\152\000\004$\002\000@\002\b\0040\000\000\000\128\000\0000\000A\128J\000\000\000@\000\000\000\000@\128\002\004\006\000\000\000\000\000\nH\000\t\006\129@1\198`\000\016\144\b\001\000\b \016\192\000\000\002\000\000\000\192\001\006\001(\000\000\001\000\000\000\000\001\002\000\b\016\024\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\129\000\000\000\000\000\000\002\146\000\002A\188P\r\241\152\000\012$\002\001P\002\b$0\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\128\000\000\000\000\000\001I\000\001 \222(\006\248\204\000\006\018\001\000\136\001\004\018\024\000\000\000\000\000) \000$\027\197\000\223\025\128\000\194@ \021\000 \128C\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\b\000\000\000\000\000\000\020\144\000\018\r\226\128o\140\192\000a \016\n\128\016A!\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\nH\000\t\006\161@1\198`\000\016\144\b\001\000\b \016\192\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\245\237^\000\002)!\000$\026\005 \199\025\128\000B@ \004\000 \128C\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\001 \000\000`\000\139\002\148\000\000\000\128\000\000\000\000\209\000\004`\140\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000={W\128\000\138H@\t\006\129H1\198`\000\016\144\b\001\000\b \016\192\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\000\000\000\000H\000\000\024\136&\194\165\128\000\000(\001\000\000\0006@\001>;@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\003\215\181x\000\b\164\132\000\144h\020\131\028f\000\001\t\000\128\016\000\130\001\012\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\000\004\128\000\001\136\130l*X\000\000\002\128\016\000\000\003d\000\019\227\180\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\000 \000\000\000\000\000\000\000\000\002\000\000\"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\006\000\000\000\128 \000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\016\000\000\002\000\128\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000z\246\175\000\001\000\000\128\000\b \017\128\000@\000\000\000\000\002\000\000\b\000\015^\213\224\000 \000\016\000\001\004\0020\000\b\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\016\000\030\189\171\192\000@\000 \000\002\b\004`\000\016\000\000\000\000\000\000\000\002\000\003\215\181x\000\b\000\004\000\000A\000\140\000\002\000\000\000\000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\136\000\015^\213\224\000 \000\016\000\001\004\0020\000\b\000\000\000\000\000@\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\024\000\000\002\000\128\000\000@\000\000\000\001\016\000\000\000\000\000\000\000\000\000\000\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000@\000\000\b\002\000\000\001\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\015^\213\224\000 \000\016\000\001\004\0020\000\b\000\000\000\000\000@\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000z\246\175\000\001\000\000\128\000\b \017\128\000@\000\000\000\000\002\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\000D\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\"\000\003\215\181x\000\b\000\004\000\000A\000\140\000\002\000\000\000\000\000\016\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000:\246\173\000\001\004\000\128\000\000\000\016\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\128\000\000\001\000\000\000 \b\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000z\246\175\000\001\004\000\128\000\b \016\000`@\000\000 \000\002\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\235\218\188\000\004\016\002\000\000 \128@\001\129\000\000\000\128\000\000\000\000\004\000={W\128\000\130\000@\000\004\016\b\0000 \000\000\016\000\001\000\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000BT4\000\163\b5A\0031\148\b`\019@\"\029\224H\000\016\230C\011\215\181x\000\b \004\000\000A\000\128\003\002\000\000\001\000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\b\000\007\175j\240\000\016@\b\000\000\128\001\000\006\004\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\006\000 \000\128 \000\000\016\000\000\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\011\215\181x\000\b\000\004\000\000@\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\015^\213\224\000 \000\016\000\001\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\000\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\003\255\245\252\016(\180\133 \128c\020\227\156~\016\003=A\128\0024\162\005\012z\246\175\000\001\000\000\128\000\b\000\016\000\000@\000\000\000\000\000\000\000\000\000\015^\213\224\000 \000\016\000\001\000\002\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\000\000\000\000\000\000\000\000\000\000 \000\030\189\171\192\000@\000 \000\002\000\004\000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\000\000 \000\000\128\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\000\000\000\000\000\000\000\128\000\000\000\000\002\000\000\b\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\215\181h\000\b\000\004\000\000\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\016\002\140 \145\004\000\134\016\000\000I\000\bv\129 \000C\000\000\000\000 \002\000Q\132\018 \128\016\194\000\000\t \001\014\208$\000\b`\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\001\000(\194\t\016@\ba\000\000\004\144\000\135h\018\000\0040\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\nH\000\t\006\129@1\198`\000\016\144\b\001\000\b \016\192\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\000\000\000\000\004\b- H \024\133\b\231\025\132\000\207P`\000\140(\129C\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\146\000\002A\160P\012q\152\000\004$\002\000@\002\b\0040\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\007\255\235\248\000\016@\b\000\000\128\001\000\0000\000\000\002\000\000\000\024\002\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000z\246\175\000\001\004\000\128\000\b\000\016\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\128\000\000\001\000\000\000 \b\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\004\000\000@\000\000\000\000\000\000\001I\000\001 \212(\006x\204\000\002\018\001\000 \001\004\002\024\000\000\000\000\000\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000@\000\000\b\002\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\192\000\002\024\004\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\000\000\002\000\000\000@\016\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\015^\213\224\000 \000\016\000\001\004\0020\000\b\000\000\000\000\000@\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000) \000$\026\133\000\207\025\128\000B@ \004\000 \128C\000\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000={W\128\000\128\000@\000\004\016\b\192\000 \000\000\000\000\001\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\000\000\000\000\000\000\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000$\000\000\000\000\000\000\000\000\000@\000\004\000\000\000\000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000\000\000\b\000\000\128\000\000\000\000\000\000\002\146\000\002A\168P\012\241\152\000\004$\002\000@\002\b\0040\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\014\189\171@\000A\000 \000\000\000\004\000\000\000\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000@\000\000\b\002\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000\000\000\b\000\000\128\000\000\000\000\000\000\002\146\000\002A\168P\012\241\152\000\004$\002\000@\002\b\0040\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\000\000\002\000\000\000@\016\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\000@\000\004\000\000\000\000\000\000\000\020\144\000\018\rB\128g\140\192\000! \016\002\000\016@!\128\000\000\000\000\000\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000B\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\003\255\245\252\016(\180\133 \144j\020\227\156~\016\003=A\128\018<\163\r\012\000\000\000$\000\004\012L\019m\146\192\001\000T\000\129 \000\027\160\016\148\029\160\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000R@\000H4\n\001\1423\000\000\132\128@\b\000A\000\134={W\128\000\138H@\t\006\129H1\198`\000\016\144\b\001\000\b \016\192\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\000\000\000\000H\000\000\024\136&\194\165\128\000\000(\001\000\000\0004@\000(;@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\164\128 \144h\020\003\028f\000\001\t\000\128\016\000\130\001\012\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000?\255_\193\226\139HR\b\0061N9\199\225\0003\212\024\000#J P\192\000\000\000\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000) \000$\026\005\000\199\025\128\000B@ \004\000 \128C\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\146\000\002A\160P\012q\152\000\004$\002\000@\002\b\0040\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\000\000\001\000\000\000\000\000\000\000\004\b\128\000\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\031\255\175\224\129E\164)\004\003\016\167\028\227\240\128\025\234\012\000\017\165\016(c\255\245\252\016(\180\133 \144j\022\227\156~\016\003=A\128\0184\162\133\012z\246\175\000\001\020\144\128\018\r\002\144c\140\192\000! \016\002\000\016@!\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\000\000\000\000\000\001I\000\001\000\196(\0068\200\000\006\018\001\000\000\001\004\002\024\000\000\000\000\000) \000 \024\005\000\199\025\000\000\194@ \000\000 \128C\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001I\000\001 \208(\0068\204\000\002\018\001\000 \001\004\002\024\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\164\128\000\144h\020\003\028f\000\001\t\000\128\016\000\130\001\012\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000R@\000H4\n\001\1423\000\000\132\128@\b\000A\000\134\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\016\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\005$\000\004\003\000\160\024\227 \000\024H\004\000\000\004\016\b`\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\128\000\001\137\130l\178X\000\000\002\128\016 \000\003T\002\002\131\180\000\000\000\000\000\016\000\000\000 \000\000\004\001\000\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\007\175j\240\000\017I\b\001 \210)\0069\204\000\002\018\001\000 \001\004\130\024\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\164\128\000\144h\020\003\028f\000\001\t\000\128\016\000\130\001\012\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\004\000\000\000\128 \000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\128\000\001\136\130l\"X\000\000\002\128\016\000\000\003D\000\002\131\180\000\000\000\000\000R@\000H4\n\001\1423\000\000\132\128@\b\000A\000\134\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001I\000\001 \208(\0068\204\000\002\018\001\000 \001\004\002\024\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\t\000\000\003\017\004\216D\176\000\000\005\000 \000\000\004\136\000\005\003h\000\000\000\000\000\164\128\000\144h\020\003\028f\000\001\t\000\128\016\000\130\001\012\000\000\000$\000\000\012D\019a\018\192\000\000\020\000\128\000\000\018 \000\020\r\160\000\000\000\000\002\146\000\002A\160P\012q\152\000\004$\002\000`\002\b\0040\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000\nH\000\t\006\129@1\198`\000\016\144\b\001\000\b \016\192\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000) \000$\026\005\000\199\025\128\000B@ \004\000 \128C\000\000\000\t\000\000\003\017\004\216D\176\000\000\005\000 \000\000\004\136\000\005\003h\000\000\000\000\000\164\128\000\144h\020\003\028f\000\001\t\000\128\016\000\130\001\012\000\000\000$\000\000\012D\019a\018\192\000\000\020\000\128\000\000\018 \000\020\r\160\000\000\000\000\002\146\000\002A\160P\012q\152\000\004$\002\000@\002\b\0040\000\000\000\144\000\0001\016M\132K\000\000\000P\002\000\000\000H\128\000P6\128\000\000\000\000\nH\000\t\006\129@1\198`\000\016\144\b\001\000\b \016\192\000\000\002@\000\000\196A6\017,\000\000\001@\b\000\000\001\"\000\001@\218\000\000\000\000\000) \000$\026\005\000\199\025\128\000B@ \004\000 \128C\000\000\000\t\000\000\003\017\004\216D\176\000\000\005\000 \000\000\004\136\000\005\003h\000\000\000\000\000\164\128\000\144h\020\003\028f\000\001\t\000\128\016\000\130\001\012\000\000\000$\000\000\012D\019a\018\192\000\000\020\000\128\000\000\018 \000\020\r\160\000\000\000\000\002\146\000\002A\160P\012q\152\000\004$\002\000@\002\b\0040\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\nH\000\t\006\129@1\198`\000\016\144\b\001\000\b \016\192\000\000\002@\000\000\196A6\017,\000\000\001@\b\000\000\001\"\000\001@\218\000\000\000\000\000) \000$\026\005\000\199\025\128\000B@ \004\000 \128C\000\000\000\t\000\000\003\017\004\216D\176\000\000\005\000 \000\000\004\136\000\005\003h\000\000\000\000\000\164\128\000\144h\020\003\028f\000\001\t\000\128\016\000\130\001\012\000\000\000$\000\000\012D\019a\018\192\000\000\020\000\128\000\000\018 \000\020\r\160\000\000\000\000\002\146\000\002A\160P\012q\152\000\004$\002\000@\002\b\0040\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\nH\000\t\006\129@1\198`\000\016\144\b\001\000\b \016\192\000\000\002@\000\000\196A6\017,\000\000\001@\b\000\000\001\"\000\001@\218\000\000\000\000\000) \000$\026\005\000\199\025\128\000B@ \004\000 \128C\000\000\000\t\000\000\003\017\004\216D\176\000\000\005\000 \000\000\004\136\000\005\003h\000\000\000\000\000\164\128\000\144o\020\003|f\000\003\t\000\128T\000\130\t\012\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000?\255_\193\226\139HR\b\0061N9\199\225\0003\212\024\000#J P\192\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\255\253\255\135\138-!H \024\197\184\231\031\140\000\207R`\000\143(\227[@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\003\255\245\252\016(\180\133 \128c\020\227\156~\016\003=A\128\0024\162\005\012\127\254\191\130\005\022\144\164\018\rB\220s\143\194\000g\1680\002F\148P\161\143\255\215\240@\162\210\020\130A\168S\142q\248@\012\245\006\000H\210\13640\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\255\253\255\132\n-!\200&\026\133\184\231\031\140\001\207R`\014\143(\235[@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000R@\000H4\n\001\1423\000\000\132\128@\b\000A\000\134\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\000\000\000\000 Ai\002A\000\196(G8\204 \006z\131\000\004aD\n\024\000\000\000\004\b- H \024\133\b\231\025\132\000\207P`\000\140(\129C\000\000\000\000\000\001\000\000\000\002\000\000\000@\016\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\001\239\250\254\000\004RB\016H4\nA\142?\000\000\132\128@\b\002A\000\134\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\007\175j\240\000\016@\b\000\000\128\001\000\000\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\016\000\000\002\000\128\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\020\144\000\018\rB\128g\140\192\000! \016\002\000\016@!\128\000\000\000\000\000\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\006\000\000\016\192 \000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\016\000\000\002\000\128\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000z\246\175\000\001\000\000\128\000\b \017\128\000@\000\000\000\000\002\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001I\000\001 \212(\006x\204\000\002\018\001\000 \001\004\002\024\000\000\000\000\000\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\146\000\002A\168P\012\241\152\000\004$\002\000@\002\b\0040\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\003\175j\208\000\016@\b\000\000\000\001\000\000\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\016\000\000\002\000\128\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\020\144\000\018\rB\128g\140\192\000! \016\002\000\016@!\128\000\000\000\000\000\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\004\000\000\000\128 \000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\005$\000\004\131P\160\025\2270\000\bH\004\000\128\004\016\b`\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\128\000\129\129\130\r\146X\000 \n\000\000$\000\003\020\002\018\0020\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\nH\002\t\006\129@1\198`\000\016\144\b\001\000\b \016\192\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000) \000$\026\005\000\199\025\128\000B@ \004\000 \144C\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\016 \180\129 \128b\020#\156f\016\003=A\128\0020\162\005\012\000\000\000\002\004\022\144$\016\012B\132s\140\194\000g\1680\000F\020@\161\128\000\000\000\000\000\128\000\000\000\004\000\000 \b\000\000\004\000\000@\000\001\000\000\000\000\000\000\000\016\000\000\000\000\128\000\004\001\000\000\000\128\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000D\000\000\000\000\000\000\000@\000\000\000\002\000\000\016\004\000\000\002\000\000\000\000\000\128\000\000\000\000\000\000\b\000\000\000\000@\000\002\000\128\000\000@\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\136\000\000\000\000\000\000\000\128\000\000\000\004\000\000 \b\000\000\004\000\000@\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000D\000\000\000\000\000\000\000@\000\000\000\002\000\000\016\004\000\000\002\000\000 \000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001I\000\001 \208(\0068\204\000\002\018\001\000 \001\004\002\024\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\245\237^\000\002)!\000$\026E \1999\128\000B@ \004\000 \144C\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\016 \180\129 \128b\020#\156f\016\003=A\128\0020\162\005\012\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000?\255_\193\002\139HR\t\006\161N9\199\227\0003\212\024\001#J P\192\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\031\255\191\240\241E\164)\004\003\024\183\028\227\241\128\025\234L\000\017\229\028kh\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\255\250\254\b\020ZB\144@1\138q\206?\024\001\158\160\192\001\026Q\002\134\000\000\000\000\000\000\000\000\001\000\128\000\000\000\002\000\000\000\000\001\000\000\000\006\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\255\253\127\004\n-!H \024\1978\231\031\140\000\207P`\000\141(\129[@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000$\000\004\012L\019m\146\192\001\000T\000\129 \000\027\160\016\020\029\160\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\b\004\000\000\000\000\016\000\000\000\000\b\000\000\0000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\255\253\127\004\n-!H$\026\1338\231\031\140\000\207P`\004\141(\129[@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\003\255\245\252\016(\180\133 \128c\020\227\156~0\003=A\128\0024\162\005m\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\001\235\218\188\000\004RB\000H4\138A\142s\000\000\132\128@\b\000A \134\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\005$\000\004\131P\160\025\2270\000\bH\004\000\128\004\016\b`\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\000\128\001\128\000\0040\b\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\128\000\000\016\004\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\003\215\181x\000\b\000\004\000\000A\000\140\000\002\000\000\000\000\000\016\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\000\000\000\000\000\000\128\000\000\000\000\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\nH\000\t\006\161@3\198`\000\016\144\b\001\000\b \016\192\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\003\215\181x\000\b\000\004\000\000A\000\140\000\002\000\000\000\000\000\016\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\000\000\000\000\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\004\000\000@\000\000\000\000\000\000\001I\000\001 \212(\006x\204\000\002\018\001\000 \001\004\002\024\000\000\000\000\000\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\007^\213\160\000 \128\016\000\000\000\002\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\016\000\000\000 \000\000\004\001\000\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\004\000\000@\000\000\000\000\000\000\001I\000\001 \212(\006x\204\000\002\018\001\000 \001\004\002\024\000\000\000\000\000\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000?\255_\193\002\139HR\t\006\161N9\199\227\0003\212\024\001#J V\208\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\128@\000\000\000\001\000\000\000\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\127\254\191\130\005\022\144\164\018\rB\156s\143\198\000g\1680\002F\148@\161\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\000\016\0000\000\000\134\001\016\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000) \b$\026\005\000\199\025\128\000B@ \004\000 \128C\000\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\164\128\000\144h\020\003\028f\000\001\t\000\128\016\000\130A\012\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\000\000@\130\210\004\130\001\136P\142q\152@\012\245\006\000\b\194\136\0200\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\245\237^\000\002)!\000$\026E \1999\128\000B@ \004\000 \144C\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\146\000\002A\168P\012\241\152\000\004$\002\000@\002\b\0040\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000@\000\192\000\002\024\004\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000@\000\000\b\002\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\000\000\000\000\000\000\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\001\235\218\188\000\004\000\002\000\000 \128F\000\001\000\000\000\000\000\b\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\005$\000\004\131P\160\025\2270\000\bH\004\000\128\004\016\b`\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\000\000\000\000\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\nH\000\t\006\161@3\198`\000\016\144\b\001\000\b \016\192\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\014\189\171@\000A\000 \000\000\000\004\000\000\000\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000@\000\000\b\002\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000R@\000H5\n\001\1583\000\000\132\128@\b\000A\000\134\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\129\005\164\t\004\003\016\161\028\2270\128\025\234\012\000\017\133\016(`\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\128\000\000\000\000\000\000\000\000\000\000 \000\031\255\191\240\129E\1649\004\195P\183\028\227\241\1289\234L\001\145\229\029kh\000\000\000\016 \180\129 \128b\020#\156f\016\003=A\128\0020\162\005\012\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\015\255\215\240@\162\210\020\130\001\140[\142q\248@\012\245\006\000\b\242\14240\000\000\000\000\000\000\000\000\b\004\000\000\000\000\000\000\000\000\000\b\000\000\000\000?\255_\193\002\139HR\b\0061n9\199\225\0003\212\024\000#\2028\208\192\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\004\002\000\000\000\000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\003\255\245\252\016(\180\133 \144j\022\227\156~\016\003=A\128\018<\163\141\012\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\015\255\215\240@\162\210\020\130A\168[\142q\248@\012\245\006\000H\242\14240\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000@\000?\255_\193\002\139HR\b\0061n9\199\225\0003\212\024\000#J(P\192\000\000\000\000\000\000\000\000 \016\004\000\000\000\000\000\000\000\000 \000\001\000\000\255\253\127\004\n-!H \024\197\184\231\031\132\000\207P`\000\141(\161C\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128@ \b\000\000\000\000\000\000\000\000@\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000?\255_\193\002\139HR\t\006\161n9\199\225\0003\212\024\001#J(P\192\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\004\000\012\000@!\128@\000\000 \000\000\000\000\016\000\000\000\000\000\000\000\000\b\000` \000\000\000\000\000\016\000\000\000@\000\000\128\005\255\250\254\b\020ZB\144@1\138q\206?\b\001\158\160\192\001\026Q\002\134\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004@0\016\000\000\000\000\000\b\000\000\000 \000\000@\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\031\255\175\224\129E\1649\004\195P\167\028\227\240\1289\234\012\000\145\165\017(k\255\245\252\016(\180\133 \128c\020\227\156~\016\003=A\128\0024\162\005\012\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\255\250\254\b\020ZC\144L5\nq\206?\b\003\158\160\192\t\026Q\018\134\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000@\000?\255_\193\002\139HR\t\006\161n9\199\225\0003\212\024\001#J(P\192\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\b\004\000\000\000\000\016\000\000\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\007\255\235\248 Qi\nA \212)\1998\252`\006z\131\000$iD\n\024\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000{\254\191\128\001\020\144\164\016\012\002\144c\143\128\000a \016\000\000\148@\161\128\000\000\000\000\002\146\000\130A\160P\012q\152\000\004$\002\000@\002\b\0040\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\247\253\127\000\002)!H \024\005 \199\031\000\000\194@ \000\001(\129C\000\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000@\000=\255_\192\000\138HR\b\006\001H1\199\192\0000\144\b\000\000J P\192\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\b\000\024\000\128C\000\128\000\000@\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\b\000\000\000\000\000\000\000\000\128\000\000\000\000\000\000\000\000\000\000\000\129\000\000\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\003\255\245\252\016(\180\133 \128c\020\227\156~\016\003=A\128\0024\162\005\012\000\000\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\nH\000\t\006\129@1\198`\000\016\144\b\001\000\b \016\192\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\000\000\000\000\255\253\127\004\n-!H$\026\1338\231\031\132\000\207P`\004\143(\195C\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \004 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000?\255_\192\000\130\000@\000\004\000\b\000\001\128\000\000\016\000\000\000\192\016\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\011\255\245\252\016(\180\133 \128c\020\227\156~\016\003=A\128\0024\162\005\012\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\015\255\215\240@\162\210\020\130\001\140S\142q\248@\012\245\006\000\b\210\136\0200\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\000\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\164\128\000\144h\020\003\028f\000\001\t\000\128\016\000\130\001\012\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\128\000\000\000\000\000\000\000 \000\000\000\000\002\146\000\002A\160P\012q\152\000\004$\002\000@\002\b\0040\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\nH\000\t\006\129@1\198`\000\016\144\b\001\000\b \016\192\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000\004\000\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\146\000\002A\160P\012q\152\000\004$\002\000@\002\b\0040\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\255\253\127\004\n-!H \024\133(\231\031\132\000\207P`\000\141(\129C\030\189\171\192\000E$ \004\003\000\164\024\227 \000\024H\004\000\000\004\016\b`\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\128\000\000\000\000\000\000\000/\255\215\240@\162\210\020\130\001\136R\142q\248@\012\245\006\000\b\210\136\0200\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\007\255\235\248 Qi\nA\000\196)G8\252 \006z\131\000\004iD\n\024\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\128\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000R@\000H4\n\001\1423\000\000\132\128@\b\000A\000\134\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\031\255\175\224\000A\000 \000\002\000\004\000\000\192\000\000\b\000\000\000 \000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000\004\000\000\000\000\000\000\000\001\127\254\191\128\001\004\000\128\000\b\000\016\000\003\000\000\000 \000\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\255\250\254\000\004\016\002\000\000 \000@\000\012\000\000\000\128\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\020\144\000\018\r\002\128c\140\192\000! \016\002\000\016@!\128\000\000\000\000\000\000\b\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\245\237^\016\007\016A\"H\016\128`\000\000\146\000\016\165\n@\000\198\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\016\001\000(\130\t\016@\000@\000\000\000\144\000\135h\018\000\0040\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\016\001\000(\130\001\016@\000@\000\000\000\144\000\135h\018\000\0040\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\000\000\000\000\000\000\016\000\000\000\004\000@\n \130D\016\000\016\000\000\000$\000!\218\004\128\001\012\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\128\000\b\000\000\000\000\000\000@\001\001\000\000\000\000\000\002\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\b\128\000\000\000\000\000\004\000\016\016\000\000\000\000\000 \b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000={W\128\001\192\016H\130\004 \024\000\000$\128\004)\002\144\0001\128\000\007\175j\240\0008\002\b\000@\132\003\000\000\004\144\000\133 R\000\0060\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\004\000\162\b$a\000\001\000\000\000\002@\002\029\160H\000\016\192\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\016\002\136 \145\004\000\004\000\000\000\t\000\bv\129 \000C\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\000\000\000\000\000\000\002\000\000\000\000\128\b\001D\016H\130\000\002\000\000\000\004\128\004;@\144\000!\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000@\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000 \000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016 \000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000={W\128\001\192\016H\002\004 \024\000\000$\128\004)\002\144\0000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\245\237^\000\007\000A\000\b\016\128`\000\000\146\000\016\164\n@\000\194\000\000\000\000@\004\000\162\b$A\000\001\000\000\000\002@\002\029\160H\000\016\192\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\129\000\000\000 \002\000Q\004\018 \128\000\128\000\000\001 \001\014\208$\000\b`\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000 \005\016A\"\b\000\b\000\000\000\018\000\016\237\002@\000\134\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\016\002\136 \145\004\000\004\000\000\000\t\000\bv\129 \000C\000\000\000\000 \002\000Q\004\018 \128\000\128\000\000\005 \001\014\208$\000\bp\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\004\000\162\b$A\000\001\000\000\000\002@\002\029\160H\000\016\192\000\000\000\b\000\128\020A\004\136 \004 \000\000\001H\000C\180\t\000\002\028\000\000\000\001\000\016\"\136 \145\004\000\004\000\000\000\t\000(v\129 \000C\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\000\000\b\000\128\020A\004\136 \000 \000\000\000H\000C\180\t\000\002\024\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\030\189\171\192\000@\000 \000\002\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\129\000\015^\213\224\000 \000\016\000\001\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\000\000\016\001\000(\130\t\016@\000`\000\000\000\144\000\135h\018\000\0040\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\004\000\162\b$A\000\001\000\000\000\002@\002\029\160H\000\016\192\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002@\000\000\000\000\000\000\000\004\000@\n \130D\016\000\016\000\000\000$\000!\218\004\128\001\012\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\b\000\000\000\002\000 \005\016A\"\b\000\b\000\000\000\018\000\016\237\002@\000\134\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\003\000\000\000\000\000\128\000\000\001\000\000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\001\000(\130\t\016@\004@\000\000\000\144\000\135h\018\000\0040\000\000\000\002\000 \005\016A\"\b\000\b\000\000\000\018\000\016\237\002@\000\134\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\128\020A\004\136 \000 \000\000\000H\000C\180\t\000\002\024\000\000\000\001\000\016\002\232 \145\004\000\020\000\000\000)\000\bv\129 \000C\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000 \005\016A\"\b\000\b\000\000\000\018\000\016\237\002@\000\134\000\000\000\000@\004\000\162\b$A\000!\000\000\000\n@\002\029\160H\000\016\224\000\000\000\b\000\129\020A\004\136 \000 \000\000\000H\001C\180\t\000\002\024\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000 \002\000Q\004\018 \128\000\128\000\000\001 \001\014\208$\000\b`\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\016\"\136 \145\004\000\004\000\000\000\t\000\bv\129 \000C\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\001\000\000\000\000@\004\b\162\b$A\000\001\000\000\000\002@\002\029\160H\000\016\192\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000`\000\000\000\000\016\000\000\000 \000\000\000\000\000\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\001\000(\130\t\016@\000@\000\000\000\144\000\135h\018\000\0040\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\128\020A\004\136 \000 \000\000\000H\000C\180\t\000\002\024\000\000\000\001\000\016\002\136 \145\004\000\132\000\000\000)\000\bv\129 \000C\128\000\000\000 \002\004Q\004\018 \128\000\128\000\000\001 \005\014\208$\000\b`\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\128\b\001D\016H\130\000\002\000\000\000\004\128\004;@\144\000!\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000(\004 @\n \130D\016\000\024\000\000\000$\000!\218\004\128\001\012\000\000\000\000\128\b\001D\016H\130\000\003\000\000\000\004\128\004;@\144\000!\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000 \005\016A\"\b\000\012\000\000\000\018\000\016\237\002@\000\134\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\128\020I\004\136 \004\160\000\000\001H\000C\180\t\000\002\028\000\000\000\001\000\016\"\136 \145\004\000\004\000\000\000\t\000(v\129 \000C\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\004\000@\n \130D\016\000\016\000\000\000$\000!\218\004\128\001\012\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\128\020A\004\136 \0000\000\000\000H\000C\180\t\000\002\024\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \002\000Q\004\018 \128\000\192\000\000\001 \001\014\208$\000\b`\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\b\000\000\000\002\000 \005\016A\"\b\000\b\000\000\000\018\000\016\237\002@\000\134\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\000\128\000\000\001\000\000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000\128\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\000\128\000\000\000\000\000@@\000\000\000\000\000\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000\000\b\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\128\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\002\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\004\000\162\b$A\000\001\000\000\000\002@\002\029\160H\000\016\192\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\128\000\000\000 \002\000Q\004\018 \128\000\128\000\000\001 \001\014\208$\000\b`\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\0000\128\000\000\000\b\000\000\000\016\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\004\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000@\n \130D\016\000\016\000\000\000$\000!\218\004\128\001\012\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000 \005\016A\"\b\000\b\000\000\000\018\000\016\237\002@\000\134\000\000\000\000@\004\000\186\b$A\000\005\000\000\000\n@\002\029\160H\000\016\224\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\b\001D\016H\130\000\002\000\000\000\004\128\004;@\144\000!\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\030\189\235\196\000\226\b$A\002\017\004\000\000\018@\002\029\160H\000\016\192\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\000\000\000\000\001\000\016\002\136 \017\004\000\004\000\000\000\t\000\bv\129 \000C\000\000\000\000 \002\000]$\018 \128\018\192\000\000\005 \001\014\208$\000\bp\000\000\000\004\000@\n \130D\016\002\016\000\000\000$\000!\218\004\128\001\012\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000 \005\016A\"\b\000\b\000\000\000\018\000\016\237\002@\000\134\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000={\215\136\001\196\016H\130\004#\b\000\000$\128\004;@\144\000!\128\000\000\000\016\001\000(\130\t\016@\000@\000\000\000\144\000\135h\018\000\0040\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\128\020A\004\136 \000 \000\000\000H\000C\180\t\000\002\024\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\001\000(\130\t\016@\000@\000\000\000\144\000\135h\018\000\0040\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000={W\132\001\196\016H\146\004 \024\000\000$\128\004)B\144\0001\128 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\005$\000\004\131@\224\024\2270\000\bH\004\000\128\004\016\b`\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\0000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\005$\000\004\131@\160\024\2270\000\bH\004\000\128\004\016\b`\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\255\251\255\b\020ZB\144H=\014q\206?\b\001\158\164\192\t\026Q\002\182\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\194\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\127\254\255\194\005\022\144\164\018\015B\156s\143\194\000g\1690\002F\148@\173\175\127\223\248\000 \000\016\000\001\000\002\000\000\000\000\000\000 \000\000\000\000\000\001\239\251\255\000\004\000\002\000\000 \000@\000\000\000\000\000\004\000\000\000\000\000\000=\255\127\224\000\128\000@\000\004\000\b\000\000\000\000\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\016\161\128\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000B\0200\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\bB\134\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\000\000\000\001\bP\192\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\003\255\245\252\030(\180\133 \128c\020\227\156~\016\003=A\128\0024\162\005\012\127\254\191\130\005\022\144\164\016\012b\156s\143\194\000g\1680\000F\148@\161\128\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\255\250\254\b\020ZB\144@1\138q\206?\b\001\158\160\192\001\026Q\002\182\128\000\000\000\000\000\000\000\001\000\128\000\000\000\000\000\000\000\000\001\000\000\000\006\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\128@\000\000\000\000\000\000\000\000\000\128\000\000\003\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\127\254\191\130\005\022\144\164\018\rB\156s\143\194\000g\1680\002F\148@\173\160\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000R@\000H7\138\001\1903\000\001\132\128@*\000A\004\134\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\255\253\127\007\138-!H \024\1978\231\031\132\000\207P`\000\141(\129C\031\255\175\224\129E\164)\004\003\024\167\028\227\240\128\025\234\012\000\017\165\016(`\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\127\254\191\130\005\022\144\164\016\012b\156s\143\194\000g\1680\000F\148@\173\160\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\255\250\254\015\020ZB\144@1\138q\206?\b\001\158\160\192\001\026Q\002\134?\255_\193\002\139HR\b\0061N9\199\225\0003\212\024\000#J P\192\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\003\223\247\254\000\b \004\000\000@\000\128\000\000\000\000\001\b\000\000\000\000\000\000\001\bP\192\000\004\000\000\000\012\000\000!\128@\000\000!\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\016\000\000C\000\128\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\003\215\181x\000\b\000\004\000\000A\000\140\000\002\000\000\000\000\000\016\000\000@\000z\246\175\000\001\000\000\128\000\b \017\128\000@\000\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002 \000={W\128\000\128\000@\000\004\016\b\192\000 \000\000\000\000\000\000\000\004\000\007\175j\240\000\016\000\b\000\000\130\001\024\000\004\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\016\000\030\189\171\192\000@\000 \000\002\b\004`\000\016\000\000\000\000\000\128\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\000\000\001\128\000\000 \b\000\000\004\000\000\000\000\017\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\004\000\000\000\128 \000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\016\000\030\189\171\192\000@\000 \000\002\b\004`\000\016\000\000\000\000\000\128\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\000\000\000\000\000\000\000\000\000\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\031\255\175\224\129E\164)\004\131P\167\028\227\240\128\025\234\012\000\145\165\016h`\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\b\004\000\000\000\000\000\000\000\000\000\b\000\000\0000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\007\255\235\248 Qi\nA \212)\1998\252 \006z\131\000$iD\n\218\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000B\0200\000\001\000\001\000\003\000\000\b`\016\000\000\b@\000\000\000\000\003\b\000\000\000\000\000\000\016\016\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\005$\000\004\131@\224\024\2270\000\bH\004\000\128\004\016\b`\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\012 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001I\000\001 \208(\0068\204\000\002\018\001\000 \001\004\002\024\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\031\255\191\240\129E\164)\004\131\208\231\028\227\240\128\025\234L\000\145\165\016+h\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\012 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\007\255\239\252 Qi\nA \244)\1998\252 \006z\147\000$iD\n\218\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\031\255\191\240\129E\164)\004\003\024\167\028\227\240\128\025\234L\000\017\165\016+h\000\000\000\000\000\000\000\000\016\b\000\000\000\000\000\000\000\000\000\016\000\000\000a\127\254\255\194\005\022\144\164\016\012b\156s\143\194\000g\1690\000F\148@\173\160\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\255\251\255\b\020ZB\144H5\nq\206?\b\001\158\164\192\t\026Q\002\182\191\255\127\225\002\139HR\b\0061N9\199\225\0003\212\152\000#J V\208\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\004\002\000\000\000\000\000\000\000\000\000\004\000\000\000\024@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\003\255\247\254\016(\180\133 \144j\020\227\156~\016\003=I\128\0184\162\005m\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\015\255\223\248@\162\210\020\130A\168S\142q\248@\012\245&\000H\210\136\021\180\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000?\255\127\225\002\139HR\t\006\161N9\199\225\0003\212\152\001#J V\208\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\016\161\128\000\b\000\b\000\024\000\000C\000\128\000\000B\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000?\255\127\225\002\139HR\t\006\161N9\199\225\0003\212\152\001#J V\208\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\004\002\000\000\000\000\000\000\000\000\000\004\000\000\000\024@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\003\255\247\254\016(\180\133 \144j\020\227\156~\016\003=I\128\0184\162\005m\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000!\n\024\000\000\128\000\128\001\128\000\0040\b\000\000\004 \000\000\000\000\001\132\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\000\016\000\000\000\000\000\000\000\000\001\002D\184\001\128\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\000\000@\000\000 \000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\000\000\129\000\000\000\000\000\000\000\000\b\000\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\002\004\000\000\000\000\000\000\000\000 \000\000\000\016\000\000\000\000\000\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\016 \000\000\000\000\000\000\000\001\000\000\000\000\128\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\004\000\128\000\000\000\000\000\000\b\000\000@\128\000\000\000\000\000\000\000\004\000\000\000\002\000\000\000\000\000 \000\000\000\000\128\000\000\000\000\000\000\000\000\131\000 \000\016\n\000\000\000\000\000\000\000 \000\001\002\000\000\000\000\000\000\000\000\016\000\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\001\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\000 \000\000\000\000\000\000\000\000 \192\b\000\000\002\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\016\224\006\000\000\001\000\000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\b0\003\000\000\000\128\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\001\006\000@\000\000\016\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\024\001\000\b\000@\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000A\128\016\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \192\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\001\014\000`\000\000\016\000\000\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000 \192\012\000\000\002\000\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\004\024\001\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\131\000 \000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016`\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\001\006\000`\000\000\016\000\000\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000 \192\b\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\024\001\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\131\000\000\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")
  
  let action =
    ((16, "\002r\000\249\000\000\000\000\022\160\000\249\000\000\000\000\000\019\000\000\000\000\000\000\000>\000\000\000\000\000\000\002r\000\000\001\128:6\000\000\000\000G\012\026j\000\000\025F\027\142\000\000\000\000\000\000\000\000\000\191\000o\000\000\000\000\000\000\000\000\000\000\000\000\000\000G\202\000\000\000\000\025F\000\000\000\000\000\017\000\000\001t\001t\000\000\000\000\000\000\000\000\000A\000\000\000\000\000q\001t\000\000\000q\000\000\000\000\001t\000\164\000\184\001t\000\134\000\000\000G\000\017\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001)\001t\000\000\000\138\006p\001t\000\000\001T\002\224\000\000\000\000\000\000\000\012\000\000\028\178\001t\000R\000\000\000\000\000\000\000\000:6\029\214?J\000\000?J\000\000\000\000\000\000\001t\000\000?J\000\000]b\0010?J\001~\000\000\000\000\001t\001`Rd\000\000\000\000UHU\224\000\000X\172\000\000VxQ,&\016&\016X\172Q,\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000W\016&\016\000\000\000\000W\016W\016W\016\000\000W\016\000\017\000\000\000\000Q,W\016\000\000\000\000/,\001t\000\000 t&\016Q,\000\0000tQ,<\016Q,<\142Q,\000\000\000\000\000\000\000\000\000\000\000\000\000\000H4Q,\000\000IRQ,=\172Q,>HQ,\000\000Q,\000\000Q,?fQ,@\002Q,A Q,A\188Q,B\218Q,CvQ,\021\174Q,\000\000\000\000\000\000\001,Q,\000\000\000\000\000\000\000\000Q,I\218Q,JvQ,J\254Q,K\154Q,D\148Q,E0Q,FNQ,L\"Q,L\190Q,\000\000Q,MFQ,M\226Q,NjQ,\000\000Q,O\006Q,O\142Q,\000\000\000\000Q,\000\000\001\020\000\000\000\000\001t\000\000\000\000\000\000\000\000\001D\000\000\001x\000\000\000\128Q,\000\000\000\128\000\000\000\000\000\238:6\000\000&\242\000~\000~e\178W\250\000\000e\178\000\000\000\000e\178\000\000\000\238\000\000\000\000&\016\001\156\000\000\001\252X\1725z\000\000Y<&\016\002\002\000\000\002\b+\b5zX\172\000\000\000\000\000\000\000\000\000\000\000\000W\016\000\000\000\000W\016\000\000\000\000W\016\000\000\000\017\000\000X\172\000\000\000\000f\020\001t\000\000 t t\000\000\002.$\244 t \248Q,\000\000Q,\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\0236Q,\024\158Q,\002LQ,\000\000Q,$4Q,r\212Q,s:Q,s\156Q,t.Q,t|Q,\000\000Q,u\014Q,upQ,u\212Q,\000\000Q,v0Q,v\148\002\198!\244\000\000\000\000\002\222#t\000\000\000\000\000\000\000\000\002\202\000\000Q,\002\204\000\000\000\000\001t\000\000\000\000\000\000\000\015X\172\000\000\000\000\003\228\000\000\0028Z\020\004\024Q,\0042\000\000\000\000X\172\0028\000\000\000\000Q,\003\214\000\000&\016\004\012\000\000\004\024f\1525zX\172\004\028\000\000Q,\000YQ,\004\134\000\000\000\0005z5z\000\000\000\000\000\000\000\0002\210\000\000\000\000\000\000\000\000\000\000W\016\000\000\000\000\001\224\005`Q,5z\001t\000\000W\016\000\000\000\000W\016\000\000\000\017\000\0003\250f\152\000\000\000\000\"\190\001t\000\000 t\004\250\000\000Q,\0052\000\000\000\000\001t\000\000\000\000\000\000\000\000\000\000-\158\000\000\000\000\005\1425z\005\1505z\000\000\000\202\000\000\000\000\025\194Q,\026\230Q,\028\nQ,\029.Q,\030RQ,4FQ,8\178Q,:\238Q,\000\000Q,P\190Q,[\196Q,v\240Q,\000\000Q,v\248Q,wT\000\000\005t\000\000\001\2366f\000\000\002L8>5z\000\000\002\1427R\000\000\000\000\000\000\000\000\006\"\000\000\000\000\000\000\005\204\000\000\005\210\000\000\000\000\005\224\000\000\000\000\005\244\000\000\000\000\006\016\000\000\000\000\000\000\000\000\000\000\000\000\006\024\006\232\000\000\006&\000\000\006d\000\000\006dRd\000\000&\016\006lrr\000\000\007H\000\000&\016\006r94\000\000&\016\006z:R\000\000\006x\000\000\000\000\001`\000\000\007l\000\000\000\000\007\222\007>\001t\006\142\007`F2Dx\000\000\000\000\000\000\003zl\134Dx\003\166i\230\000\000\000\000\000\000\006p\007P\n8\007dF2\000\000\000\000\006\152\000\000\006\156\007nF2\006\162\000\000\001`\000\000\000\000\004\018j\166\000\000\000\000\000\000\006\166\007\152\000\000\007\154\000\0002*\001t\007\156\000\000\000\000\000\000\006\172\000\000?J\000\000B\190A\004\000\000\000\000\030\250?J\006\178\000\000\000\000\001\142?J\000\000\001\142\000\000\000\000\006\188\000\000\019\254\006\182\000\000\0006:6\000\000:6\000\000\006\162\000\000\0006\000\000\019\1784\250:6\000\000\006\194\000\000\004\022:6\000\000\000\000\004\022\000\000\000\000\000\000\002B\000\000\000\000\004\\\002B\000\000\000\000\000\000\007\184\000\000&\242'\128'\128\000\000\000\000'\128\000\000\000\000\000\000\000\000\000\000\007\160Q,\006\212)j\007V\000\000\007\184Q,\006\244\007\194F2\000\000\000\000\000\000:6\001t\000\000\000\140Q,\007\236\000\000\001t\000\000\000\140\007\238\000\000\007\182\007\212\001t\007\026\007\238F2\007\"\003\232\000\000Q,\b\020\000\000\000\000\000\000\007\246F2\007*\b \000\000\002\248\001\006Q,\b*\000\000\b.\000\0002*\001t\003\148Q,\b4\000\000\b8\000\000\001t\003\210Q,\b@\000\000\bB\000\000\001\019\007\128\t\022,\128\000\000Z\164&\016\007ZQ\230\000\000Rd\000\000\bJ\000\000\003\006\b Q,\007\222\000\000\b&Q,\007\230\000\000\001\130\000\000\t\022\t\022&\016\007j\000\000\007ngZgZ\000\000\000\000\000\000\000\000\000\000\000\000W\016\000\000\000\000W\016\000\000\000\000W\016\000\000\000\017\000\000gZ\000\000\000\000;p\001t\000\000 t\007p\000\000Q,\007n\000\000\000\000\001t\000\000\000\000\000\000\000\000\000\000SZQ,\000\000Q,\000\000\007~\000\000\000\128\000\000\000\000\000\000\000\000\000\000]bQ,]\254Q,\007\168Q,\000\000Q,^\134Q,_\"Q,_\170Q,`FQ,`\206Q,ajQ,\000\000Q,a\242Q,b\142Q,c\022Q,\000\000Q,c\178Q,d:5z\007|\000\000\000\000\003\006\000\000\003\006\000\000\019\178\t\022\t\022\000\000\000\000\000\000\000\003\000\000\000\000\000\000\bTQ,\007\136)j*|\001t\b|\000\000\b`\022\178\000\000:6\001t\004\146\000\000Q,\b\130\000\000\t:\bR\001t\007\152\bjF2\007\160\004\152\000\000Q,\b\148\000\000\004\196\000\000Q,\b\154\000\0002*\001t\005\022\000\000Q,\b\186\000\000\001t\0058\000\000Q,\b\210\000\000-\168\b\212S\216\b\214Q,\007\236)j)j\007x\002\248\004`\003Z\002\248\000\000\000\000\004\130\n\128\000\000\004\136\r\136\000\000\000\000\000\000\000\000\000\000\007\238\000\000\000\000\b\222\000\000\b\224\000\000\000\000\t\"\b\200Q,\007\254\b\250\000\000\b\254\000\000\b<\000\000\b\228 t\b\024)j\000\000\000\000\000\000\007\146\000\000\000\000\003\006\000\000\b\152\000\000\015&\000[\000\000\015&\000\000\000\000-\168\000\000\b\208\000\000\000\000\012\030\000\000\015&\000\000\b\234 t\b \005^\000\000Q,\t\018\000\000\0036\000\000\b\226\001t\b*\b\252F2\b2\005~\000\000Q,\t$\000\000\t\006F2\b<\t,\000\000\004JQ,\t.\000\000\t0\000\0002*\001t\004\134Q,\t2\000\000\t8\000\000\000\000\000\000\012\030\000\000\000\000\004\208\000\000\t\022\000\000\0036\000\000\000\000S\216\t<Q,\bV)j\000\000\000\000\t& t\b\\\005\214\000\000Q,\tP\000\000\004\186\000\000\t*\001t\bv\tFF2\b\128\005\254\000\000Q,\tp\000\000\006\012\000\000Q,\tr\000\0002*\001t\006\016\000\000Q,\t\130\000\000\004F*|\000\000\004F\000\000\000\000\b\158\000\000\002\208\001\130)j\000\000\006\014\000[\006\014\000\000\000%\000\000\t\022\000\000\t\022\000\000\000\000\000\000\b\152\000\000\000\000\b\168\000\000\005\160\007\146\000\017\006\014\000\000\000\000\000\000\000\017\000\000\t\022\000\000\005\160\000\000\000\000\023Z\000\017\019\178\000\000\000\017\000\000\n\154\019\178\000\000\000\000\n\154\000\000\000\000\b\166\000\000\000\000\b\172\000\000\005\238\t\022\000\000\005\238\000\000\000\000\t*\000\000\004\208\000\000\t\022\000\000\000\000\000\000\0242T\176\000\000\t\156\000\000\0242\t\164\000\000\t\174\000\000\005\240\0242\000\000\t\178\000\000\000\000\005\240\000\000\000\000\b\202\000\000 \192\tH\000\000\000\000\000\000\tL\000\000\000e\000\206\000\000\019\178\t\170\000\000\000\000Q,\t\000\t\022\000\000\b\210\000\000\001\019\000\000F2\000\000\000\000\001\218\019\178\000\000\019\178\000\000\b\190\000\000\001\218\000\000Q,\002XQ,\000\000Q,\000\000\b\192\000\000\002X\000\000Q,\002X\b\200\000\000\0212+\252\000\000\002|\0212\000\000\000\000\0212\000\000\b\210\000\000\002|\000\000Q,\002X\b\216\000\000:6\003\236:6\000\000:6\000\000\b\234\000\000\003\236\000\000Q,\002X\b\238\000\000\000\000'\144\000\000\000\249\t\154\000\000\000\000\tv[\128\000\000\000\000\000\000\000\000\000\000\000\000\tL\006\014\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004|[\128\000\000\003\230\005~\tx\000\249\000\000\000\000\t|\000\249\000\000\000\000\000\000\000\000\000\167\005~\000\000\000\000\000\000\000\000\t\234\000\000\000\000\000\000\000\000/,1t\000\000l\252\000\000[\128\000\000\005b[\128\000\000\002\194\001\182\001\182\000\000\004d\001\182\000\000\tf\000\000\000\000\000\000\000\000\t\244\000\0002\210\000\0004\250[\128\000\000\004F[\128\000\000\t\248\000\000[\128\t\252\000\000o\022\\\002\t\254\000\000\n\002\000\000orh\026[\128\t\170\000\249\000\000\000\000\000\000\t\128[\128\n\n\000\000\n\014\000\000\n\020\000\000:6\000\000\005 :6\000\000\t\144'\128\000\000[\128\n\030\000\000\000\177[\128\000\000\005\146[\128\000\000\t\022\n\164\000\000\n\176\000\000\\\002[\128\t\164\000\000\000\000\000\000\000\000\000\000\000\000\n2\000\000o\238[\128\n4\000\000\n8\000\000p|h*[\128\t\178[\128\n>\000\000\nH\000\000\nJ\000\000\\\002\t\240\000\249\000\000\000\000\005\208\\\002\000\000\t\022\000\000\nR\000\000[\128\nV\000\000p\222i4[\128\t\210[\128\n\\\000\000\n^\000\000\n`\000\000d\232'\128\000\000'\128\000\000\\\002[\128\t\220[\128\nt\000\000\nv\000\000'\128\000\000mL\000\000\000\000\005\216[\128\000\000\002\224\0064\001\182\t\246\000\000\000\000\0036\002\144\000\000\000\000\000\000\000\000\005\148\002\144\000\000\t\254\000\000\000\000\000\000\000\000\000\000\000\000\000\000[\128\000\000\006\026[\128\000\000\000\031\0002\000\249\n\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\n\140\000\000\n\154\000\000[\128\n\156\000\000ql[\128\n\158\000\000\n\160\000\000[\128\n\164\000\000(\244\nJq\206P\140n&\n \000\000[\128\n\170\000\000\n\172\000\000\n|(\244[\128\n\178\000\000[\128\n\180\000\000\n\190\000\000[\128\n\200\000\000\000\249\n6\000\000\000\000'\144\000\000\000\000\004\"\0112\000\000\000\000\001\\\000\000\000\000\000\000Q,\000\000\000\000\000\000\004\138\000\000\002~\000\000\000\000\000\000\006\014:6:6:6\000\000\002|\002|\002|\002|\000\000\000\000\000\000\000\000\000\000\000\000\003\006\019\178\011(\016\170\000[\000\000\000\000\004|\000\000\012\030\000\0005z\nJ\000\000\003\006\019\178\nX\018.\000\000\003\006\016\170\000\000\000\000\000\000:6\n8\000\000\000\000\000\000\n\166\0036\0110j\214j\214\000\000\005xn\216j\214\005\152k\150\000\000\000\000\012\004\011 \001t\000\000\006\006lV\000\000\000\000\000\000\000\000\000\000\nf\011.\t\022\nd\000\000\000\000\004|\000\000\012\030\000\000\020\012\000\029\000\000\000\000\011\024\000\000\000\000\000\000\004\"\000\000\002\236\000\000\000\000\000\000Q,\000\000\004\138\000\000\003d\000\000\000\000\000\000\007\146\000\000\r\162\000\178\r\162\000\000\t\022\r\162\000\000\005\024\000\000\t\022\000\000\t\022\000\000\t\022\000\000\020\012\000\000\000\000\000\000\000\000\000\000\t\022\000\000\005\024\000\000\t\022\000\000\021\140\000\000\000\000\031\144\n\154\000\249\0054\011D\005\210\000\000\005\210\011p\000\000\011r\000\000\001\150\000\000\005\210\002\220\005\210\n\152\005\210\000\000\000\000\003\176\000\000\012\014\0054\nr\000\000\nt\000\000\n\180\000\249\0054\n|\000\000\012\198\011\136\000\000\014J\tR\011\154\000\154\011\154\000\000\000\000\0007\000\249\000\000\000\164\000\000\000\000\002\014\000\000\n\132\000\000\000\000\000\000\n\196\000\249\0054\n\140\000\000\000\000\012\198\014J\tR\0007\000\164\002\014\n\142\000\000\014J\tR\0007\000\164\002\014\n\146\000\000\006\178\006\014\n\176\000\249\n\172\007\012\007\132\n\220\000\249\000\000\n\252\000\249\000\000\011\\\000\000\n\240\006\156\n\234\007\012\011r\000\000\n\240\007\012\011x\000\000\000\000\007\012\000\000\011|\000\000"), (16, "\r\221\r\221\r\221\r\221\r\221\r\221\r\221\r\221\r\221\r\221\r\221\r\221\r\221\r\221\000\n\r\221\r\221\r\221\r\221\r\221\r\221\r\221\r\221\r\221\r\221\012n\022\130\022\138\001N\r\221\012:\r\161\023\194\000\234\014\014\b\241\r\221\000\190\r\221\000&\026\163\019N\r\221\n\t\r\221\r\221\005\249\r\221\026\167\b5\r\221\t\241\012n\n\t\022j\r\221\r\221\r\221\026\170\000*\r\221\014\014\012n\b5\003\193\000\130\r\221\r1\0242\r\221\r\221\014\014\014\173\000\194\000^\r\221\r\221\000f\r\221\000v\r\221\004\217\0045\000\134\n~\r\221\000z\r\221\r\221\021&\r\221\r\221\r\221\r\161\001\030\001\"\r\221\r\221\r\221\n\021\001&\r\221\r\221\r\221\001*\001.\0246\r\221\r\221\r\221\r\221\r\221\r\221\015\218\006\198\001\006\r\221\r\221\006\181\000~\b5\001\026\0012\006Q\006\181\006\181\0196\r\221\r\221\r\221\000\n\rA\r\221\r\221\r\221\r\221\028&\r\221\006\210\r\221\015\218\0045\r\221\014\173\014\173\r\221\r\221\000\222\0045\014\173\015\218\003\193\012\150\004:\000\138\n\134\r\221\r\221\007\149\012n\r\221\n\021\006\181\000\n\r\221\r\221\r\221\r\221\014\014\006N\r\221\004\217\r\221\b5\003\193\001\n\r\221\r\221\r\221\026\179\r\221\006\190\r\221\r\221\001\018\r\221\b5\r\221\r\221\001~\r\221\r\221\rA\r\221\r\233\r\233\r\233\r\233\r\233\r\233\r\233\r\233\r\233\r\233\r\233\r\233\r\233\r\233\004R\r\233\r\233\r\233\r\233\r\233\r\233\r\233\r\233\r\233\r\233\0007\000;\006\025\r)\r\233\001\142\001\194\011r\0282\r)\r)\r\233\000\190\r\233\004]\0286\001\214\r\233\005\241\r\233\r\233\r)\r\233\012\150\006Y\r\233\001Z\011~\015\218\018\186\r\233\r\233\r\233\t\001\028\022\r\233\018\190\001\238\006\t\003\233\027\166\r\233\007\"\000\198\r\233\r\233\003\233\r)\001\198\000\254\r\233\r\233\004]\r\233\007\022\r\233\020\142\012\154\n9\n9\r\233\027\170\r\233\r\233\n9\r\233\r\233\r\233\011\230\nR\000\202\r\233\r\233\r\233\019\"\019~\r\233\r\233\r\233\006I\000\206\021~\r\233\r\233\r\233\r\233\r\233\r\233\011~\001\222\003^\r\233\r\233\000N\n\158\019\158\019\198\019\214\020\n\020\026\020B\004\n\r\233\r\233\r\233\000\n\011\026\r\233\r\233\r\233\r\233\011\030\r\233\005\241\r\233\001\170\025z\r\233\011\"\018\186\r\233\r\233\004*\011&\025~\001\002\018\190\001j\000\006\000\"\018\194\017\190\r\233\005\241\002}\r\233\006\145\005\241\019\166\r\233\r\233\r\233\r\233\025/\0253\r\233\019\134\r\233\0042\0257\b\245\r\233\r\233\r\233\000\190\r\233\019\230\r\233\r\233\006\137\r\233\n\218\r\233\r\233\019\"\r\233\r\233\004\154\r\233\006\153\006\153\006\153\006\153\006\153\006\153\006\153\006\153\006\153\006\153\006\153\006\153\006\153\006\153\n\222\006\153\006\153\006\153\006\153\006\153\006\153\006\153\006\153\006\153\006\153\000\190\028>\023\194\003\241\006\153\012r\012\130\012\146\n\t\bF\003\241\006\153\000\190\006\153\000\n\019\174\t\r\006\153\0069\006\153\006\153\004\162\006\153\021z\004\186\006\153\027\178\004\194\005\241\006f\006\153\000\198\006\153\019\242\000.\006\153\004:\000\254\023\214\005\129\005\138\006\153\0056\000\190\004\133\023\222\b\201\001\238\004\165\015*\006\153\006\153\006\145\000\n\006\205\006\153\006\153\bR\000\202\016J\006\153\000\190\006\153\006\153\t\029\006\153\006\153\006\153\000\206\n\r\000\202\006\153\006\153\006\153\000\198\016N\006\153\006\153\006\153\023\218\000\206\006)\006\153\006\153\006\153\006\153\006\153\006\153\006\017\006\017\bb\006\153\006\153\000\n\025W\025[\011\194\002\141\0156\0061\025_\000\202\011\198\006\153\006\153\000\n\rA\006\153\006\153\006\153\006\153\000\206\006\153\001\002\006\153\016\238\006\205\006\153\005\254\000\202\006\153\006\153\b\185\005\241\006&\015.\006Y\0062\023\222\000\206\006\014\n\r\027\178\027\194\002]\006\153\000\n\rA\002\129\006\153\006\153\006\153\006\153\005\241\027\186\006\153\020\"\006\153\011\178\026\199\026\203\006\153\006\153\006\153\000\n\026\207\006^\006\153\006\153\006\189\006\153\006\189\006\153\006\153\006\189\006\153\006\153\006\189\006\153\006\189\006\189\006\189\006\189\006\189\006\189\006\189\006\189\006\189\006\189\006\189\006\189\006\189\006\189\006\189\006\189\006\189\006\189\006\189\006\189\006\189\006\189\006\189\006\189\006\189\006n\006\189\b\233\rA\006\189\n\186\012\141\012\006\006\189\025\030\006\189\006\189\r\153\006\189\tz\026\231\026\235\006\189\tU\006\189\006\189\026\239\006\189\020*\006\189\006\189\006\189\011~\n\t\017\154\006\189\006\189\006\189\rA\006\189\006\189\t\134\012n\012\"\014~\tE\006\189\014\174\000\190\006\189\027\202\014\014\006v\020\246\011\182\006\189\006\189\006\189\006\189\ra\006\189\027\186\006\189\011~\0176\006\189\025\030\006\189\006\150\014\194\006\189\006\189\006\189\012\141\006\189\n\t\006\189\006\189\006\189\000\198\017:\006\189\006\189\006\189\012n\006\189\r\137\006\189\006\189\006\189\006\189\006\189\006\189\014\014\006!\t\222\006\162\006\189\006\189\002\173\006q\011\194\006\170\016\146\006\189\006\186\000\202\011\198\006\189\006\189\014\222\n\t\006\189\006\189\006\189\006\189\000\206\006\189\006\189\006\189\012n\021\198\006\189\011~\006\129\006\189\006\189\014\246\ra\014\014\015\218\014\173\n\230\016\178\0152\020\250\021\138\006\189\b\229\014\130\006\189\000\n\014\178\rQ\006\189\006\189\0166\006\189\020\234\021\006\006\189\015F\006\189\011~\015R\b\213\006\189\021\n\002m\006\206\014\173\014\173\016j\006\189\014\198\006\189\014\173\006\189\006\189\007\026\006\189\006\189\015\218\006\189\000R\000V\000Z\000\146\n\162\000\150\011\026\000\154\000\158\000\162\000^\011\030\000\170\000\174\020v\000v\025f\000\182\011\"\000\186\001\146\001\150\000z\011&\025j\027\138\020z\r\145\000\n\011*\021\022\014\226\017\"\018\014\015\218\028\174\011:\020~\001\154\020\130\021\026\007j\001\242\020\134\012B\011B\027\142\012F\014\250\020\138\012J\ry\017V\027\146\027\130\000~\022F\012^\020\150\017j\n\005\017\134\020\154\r9\n9\n9\002\002\016:\020\158\025\158\n9\007v\018\142\018\238\020\142\014\"\012\162\025\202\025\214\003\173\014&\017\202\r\129\016n\020\162\002&\ri\002*\004\181\021n\001\162\015\210\014.\000\190\007\166\007\174\012\186\0022\0142\023\198\026.\012\190\006\238\002:\t9\b>\028\234\012\194\012\198\011V\011Z\012\202\0146\022v\023\242\020\166\026:\014:\020\170\rq\t)\rI\027\154\006a\000\198\t\154\bz\017&\006\254\012\206\001^\020\174\014>\014B\012\210\014F\020\178\000\n\020\182\014Z\020\186\020\190\004\145\020\194\023\026\014f\012\218\017Z\023\182\b\138\020\198\000\202\b\146\020\202\017n\027\162\017\138\025\234\028\170\b\158\015\"\000\206\006i\006y\015&\015r\004\181\011^\020\206\b\170\012\222\026Z\015v\020\210\020\214\002\157\012\230\004\181\004\181\028\190\b\182\024&\004\181\015~\b\210\012\234\000\n\006\197\006\197\004\198\012\242\002~\b\222\006\197\000R\000V\000Z\000\146\n\162\000\150\011\026\000\154\000\158\000\162\000^\011\030\000\170\000\174\000\n\000v\025f\000\182\011\"\000\186\001\146\001\150\000z\011&\025j\000\n\028\194\b\230\b\238\011*\002\233\000\190\b\254\t\n\002\233\t\022\011:\t\005\001\154\t&\t2\tF\001\242\tV\012B\011B\029\019\012F\028\206\t^\012J\tb\t\158\t\166\t\182\000~\t\190\012^\t\194\t\202\n\005\t\242\000\190\t\246\t\254\n\014\002\002\n\030\015*\012n\nF\nj\nv\n\147\n\178\014\"\012\162\025\202\014\014\n\250\014&\018\018\000\190\011.\0116\002&\011>\002*\004\197\000\202\001\162\015\210\014.\000\198\011\150\011F\012\186\0022\0142\000\206\011N\012\190\006\238\002:\011R\011z\011\142\012\194\012\198\011V\011Z\012\202\0146\000\198\tR\011\194\015\214\014:\011\154\011\162\000\202\011\198\011\166\011\174\000\n\011\190\011\206\011\214\006\254\012\206\000\206\011\218\014>\014B\012\210\014F\011\238\000\n\011\246\014Z\000\202\012\014\004\145\012\022\015.\014f\012\218\012*\0122\012>\000\206\012V\012j\012v\012~\000\n\012\134\015\218\012\142\012\170\015\"\012\178\r\026\r&\015&\015r\004\017\011^\r^\r\142\012\222\014\006\015v\014J\014R\000\n\012\230\014b\004\197\014j\014\138\014\150\014\158\015~\014\162\012\234\014\170\006\213\006\213\014\186\012\242\002~\014\206\006\213\000R\000V\000Z\000\146\n\162\000\150\011\026\000\154\000\158\000\162\000^\011\030\000\170\000\174\014\234\000v\025f\000\182\011\"\000\186\001\146\001\150\000z\011&\025j\n\t\015\002\015\014\015\022\011*\015\030\015n\015z\015\130\012n\015\142\011:\015\146\001\154\015\154\022\130\022\138\001\242\014\014\012B\011B\015\158\012F\015\166\015\174\012J\015\182\015\190\015\230\016*\000~\0162\012^\016B\016R\n\005\016Z\000\190\016^\028\014\016f\002\002\016v\016~\012n\016\134\016\138\016\154\016\162\016\186\012\158\012\162\016\194\014\014\016\254\014&\014\173\022\146\017\006\017\022\002&\017\030\002*\004\225\017.\001\162\014*\014.\000\198\014\146\017>\012\186\0022\0142\017F\017J\012\190\006\238\002:\017R\017b\017v\012\194\012\198\011V\011Z\012\202\0146\n\029\017\146\011\194\014\181\014:\017\178\017\250\000\202\011\198\015\218\018\006\018z\018\134\018\166\018\210\006\254\012\206\000\206\018\222\014>\014B\012\210\014F\018\230\000\n\018\250\014Z\019\018\019\030\004\145\019.\019F\014f\012\218\019V\019b\019\147\019\187\011\026\014\173\014\173\019\211\000\n\011\030\015\218\014\173\019\255\015\"\025z\020\023\011\"\015&\015r\004\225\011^\011&\025~\012\222\0207\015v\020O\006\173\n\029\012\230\004\225\004\225\020g\006\173\006\173\004\225\015~\020r\012\234\020\146\nA\nA\000\190\012\242\002~\006\173\nA\000R\000V\000Z\000\146\n\162\000\150\011\026\000\154\000\158\000\162\000^\011\030\000\170\000\174\020\254\000v\021\014\000\182\011\"\000\186\001\146\001\150\000z\011&\006\173\021?\000\198\011\150\021\150\011*\021\171\000\190\021\211\003\165\021\223\021\239\011:\021\247\001\154\022\n\022\030\022'\001\242\022/\012B\011B\0227\012F\011\194\022R\012J\022c\022\134\000\202\011\198\000~\b=\012^\022\142\022\158\n\005\022\187\022\203\000\206\022\211\022\230\002\002\022\239\015*\012n\b=\003\165\022\247\022\255\023\n\012\158\012\162\023/\014\014\023;\014&\023N\023W\023_\023g\002&\023\138\002*\000\n\000\202\001\162\014*\014.\004\165\023\147\023\155\012\186\0022\0142\000\206\023\206\012\190\006\238\002:\023\254\024>\024_\012\194\012\198\011V\011Z\012\202\0146\024g\024s\024\131\024\139\014:\024\151\024\162\024\178\024\191\024\199\024\206\000\n\024\219\024\231\b=\006\254\012\206\t\162\024\239\014>\014B\012\210\014F\024\251\000\n\025\007\014Z\025\"\025\170\025\210\003\165\015.\014f\012\218\025\226\026\022\003\165\003\165\026\030\026N\026v\026z\026\130\026\175\015\218\027z\027\134\015\"\003\165\027\150\027\158\015&\015r\b\217\011^\027\219\027\227\012\222\027\234\015v\027\247\028\002\028\018\012\230\028G\003\165\028V\b=\028c\028\135\015~\028\163\012\234\028\178\003\165\028\186\027\186\012\242\002~\028\198\b=\000R\000V\000Z\000\146\n\162\000\150\011\026\000\154\000\158\000\162\000^\011\030\000\170\000\174\028\210\000v\028\223\000\182\011\"\000\186\001\146\001\150\000z\011&\028\230\028\238\003\177\028\247\028\254\011*\029\007\000\190\029\027\000\000\000\000\000\000\011:\000\000\001\154\000\000\000\000\000\000\001\242\000\000\012B\011B\000\000\012F\000\000\000\000\012J\000\000\000\000\000\000\000\000\000~\000\000\012^\000\000\000\000\n\005\000\000\000\198\026J\027\178\000\000\002\002\000\000\000\000\012n\000\000\000\000\000\000\000\000\000\000\012\158\012\162\000\000\014\014\000\000\014&\000\000\000\000\000\000\000\000\002&\000\000\002*\000\000\000\202\001\162\014*\014.\000\000\000\000\000\000\012\186\0022\0142\000\206\000\000\012\190\006\238\002:\000\000\000\000\000\000\012\194\012\198\011V\011Z\012\202\0146\000\000\000\000\000\000\014\181\014:\004y\000\000\000\000\000\000\000\000\000\000\000\n\000\000\000\000\000\000\006\254\012\206\000\000\000\000\014>\014B\012\210\014F\003\177\000\n\000\000\014Z\000\000\000\000\003\177\003\177\000\000\014f\012\218\000\000\000\000\000\000\000\000\000\000\000\000\000\000\003\177\000\000\000\000\015\218\000\000\000\000\015\"\000\000\002\233\000\000\015&\015r\002\233\011^\000\000\000\000\012\222\000\000\015v\000\000\000\000\000\000\012\230\000\000\000\000\000\000\003\177\000\000\027\186\015~\000\000\012\234\000\000\014\181\014\181\000\000\012\242\002~\000\000\014\181\000R\000V\000Z\000\146\n\162\000\150\011\026\000\154\000\158\000\162\000^\011\030\000\170\000\174\000\000\000v\025f\000\182\011\"\000\186\001\146\001\150\000z\011&\025j\000\000\000\000\000\000\000\000\011*\000\000\000\190\000\000\000\000\004y\000\000\011:\000\000\001\154\027\254\004y\004y\001\242\000\000\012B\011B\000\000\012F\000\000\000\000\012J\000\000\004y\004y\000\000\000~\000\000\012^\000\000\000\000\n\005\000\000\000\000\000\000\000\000\000\000\002\002\000\000\015*\000\000\000\000\000\000\000\000\000\000\000\000\014\"\012\162\000\000\004y\000\000\014&\026\254\000\000\000\000\000\000\002&\000\000\002*\000\000\000\202\001\162\015\210\014.\000\000\000\000\000\000\012\186\0022\0142\000\206\000\000\012\190\006\238\002:\000\000\000\000\000\000\012\194\012\198\011V\011Z\012\202\0146\000\000\000\000\000\000\000\000\014:\003\173\000\000\000\000\000\000\000\000\000\000\000\n\000\000\000\000\000\000\006\254\012\206\000\000\000\000\014>\014B\012\210\014F\000\000\000\n\000\000\014Z\000\000\000\000\004\145\000\000\015.\014f\012\218\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\015\"\000\000\000\000\000\000\015&\015r\002q\011^\000\000\000\000\012\222\000\000\015v\000\000\000\000\000\000\012\230\000\000\000\000\000\000\000\000\000\000\000\000\015~\000\000\012\234\000\000\n%\n%\000\000\012\242\002~\000\000\n%\000R\000V\000Z\000\146\n\162\000\150\011\026\000\154\000\158\000\162\000^\011\030\000\170\000\174\000\000\000v\000\000\000\182\011\"\000\186\001\146\001\150\000z\011&\000\000\000\000\000\000\000\000\000\000\011*\000\000\000\000\000\000\000\000\003\173\000\000\011:\000\000\001\154\000\000\003\173\003\173\001\242\000\000\012B\011B\000\000\012F\000\000\000\000\012J\000\000\003\173\027\130\000\000\000~\000\000\012^\000\000\000\000\n\005\000\000\000\000\000\000\000\000\000\000\002\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\014\"\012\162\000\000\003\173\000\000\014&\015\238\000\000\000\000\000\000\002&\000\000\002*\000\000\000\000\001\162\015\210\014.\000\000\000\000\000\000\012\186\0022\0142\000\000\000\000\012\190\006\238\002:\000\000\000\000\000\000\012\194\012\198\011V\011Z\012\202\0146\000\000\000\000\000\000\014\145\014:\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\006\254\012\206\000\000\000\000\014>\014B\012\210\014F\000\000\000\n\000\000\014Z\000\000\000\000\000\000\000\000\000\000\014f\012\218\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\015\"\000\000\000\000\000\000\015&\015r\000\000\011^\000\000\000\000\012\222\000\000\015v\000\000\000\000\000\000\012\230\000\000\000\000\000\000\000\000\000\000\000\000\015~\000\000\012\234\000\000\014\145\014\145\000\000\012\242\002~\000\000\014\145\000R\000V\000Z\000\146\n\162\000\150\011\026\000\154\000\158\000\162\000^\011\030\000\170\000\174\000\000\000v\000\000\000\182\011\"\000\186\001\146\001\150\000z\011&\000\000\000\000\000\000\000\000\000\000\011*\000\000\000\000\000\000\000\000\000\000\000\000\011:\000\000\001\154\000\000\000\000\000\000\001\242\000\000\012B\011B\000\000\012F\000\000\000\000\012J\000\000\000\000\000\000\000\000\000~\000\000\012^\000\000\000\000\n\005\000\000\000\000\000\000\000\000\000\000\002\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\014\"\012\162\000\000\000\000\000\000\014&\025\174\000\000\000\000\000\000\002&\000\000\002*\000\000\000\000\001\162\015\210\014.\000\000\000\000\000\000\012\186\0022\0142\000\000\000\000\012\190\006\238\002:\000\000\000\000\000\000\012\194\012\198\011V\011Z\012\202\0146\000\000\000\000\000\000\000\000\014:\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\006\254\012\206\000\000\000\000\014>\014B\012\210\014F\000\000\000\n\000\000\014Z\000\000\000\000\000\000\000\000\000\000\014f\012\218\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\015\"\000\000\000\000\000\000\015&\015r\000\000\011^\000\000\000\000\012\222\000\000\015v\000\000\000\000\000\000\012\230\000\000\000\000\000\000\000\000\000\000\000\000\015~\000\000\012\234\000\000\014\221\014\221\000\000\012\242\002~\000\000\014\221\000R\000V\000Z\000\146\n\162\000\150\011\026\000\154\000\158\000\162\000^\011\030\000\170\000\174\000\000\000v\000\000\000\182\011\"\000\186\001\146\001\150\000z\011&\000\000\000\000\000\000\000\000\000\000\011*\000\000\000\000\000\000\000\000\000\000\000\000\011:\000\000\001\154\000\000\000\000\000\000\001\242\000\000\012B\011B\000\000\012F\000\000\000\000\012J\000\000\000\000\000\000\000\000\000~\000\000\012^\000\000\000\000\n\005\000\000\000\000\000\000\000\000\000\000\002\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\014\"\012\162\000\000\000\000\000\000\014&\025\174\000\000\000\000\000\000\002&\000\000\002*\000\000\000\000\001\162\015\210\014.\000\000\000\000\000\000\012\186\0022\0142\000\000\000\000\012\190\006\238\002:\000\000\000\000\000\000\012\194\012\198\011V\011Z\012\202\0146\000\000\000\000\000\000\000\000\014:\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\006\254\012\206\000\000\000\000\014>\014B\012\210\014F\000\000\000\n\000\000\014Z\000\000\000\000\000\000\000\000\000\000\014f\012\218\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\015\"\000\000\000\000\000\000\015&\015r\000\000\011^\000\000\000\000\012\222\000\000\015v\000\000\000\000\000\000\012\230\000\000\000\000\000\000\000\000\000\000\000\000\015~\000\000\012\234\000\000\014\217\014\217\000\000\012\242\002~\000\000\014\217\000R\000V\000Z\000\146\n\162\000\150\011\026\000\154\000\158\000\162\000^\011\030\000\170\000\174\000\000\000v\000\000\000\182\011\"\000\186\001\146\001\150\000z\011&\000\000\000\000\000\000\000\000\000\000\011*\000\000\000\000\000\000\000\000\000\000\000\000\011:\000\000\001\154\000\000\000\000\000\000\001\242\000\000\012B\011B\000\000\012F\000\000\000\000\012J\011\026\000\000\000\000\000\000\000~\011\030\012^\000\000\000\000\n\005\025z\000\000\011\"\000\000\000\000\002\002\000\000\011&\025~\000\000\000\000\000\000\000\000\000\000\014\"\012\162\000\000\000\000\000\000\014&\018F\000\190\000\000\000\000\002&\000\000\002*\000\000\000\190\001\162\015\210\014.\000\000\000\000\000\000\012\186\0022\0142\000\000\000\000\012\190\006\238\002:\000\000\016J\000\000\012\194\012\198\011V\011Z\012\202\0146\000\198\tR\000\000\000\000\014:\000\000\000\000\000\198\016N\000\000\000\000\000\000\000\000\004R\000\000\006\254\012\206\000\000\000\000\014>\014B\012\210\014F\000\000\000\n\000\000\014Z\000\202\000\000\011\194\000\000\000\000\014f\012\218\000\202\011\198\000\000\000\206\000\000\000\000\000\000\000\000\000\000\000\000\000\206\000\000\000\000\015\"\000\000\000\000\000\000\015&\015r\000\000\011^\000\000\000\000\012\222\000\000\015v\000\000\000\000\000\n\012\230\000\000\000\000\000\000\000\000\000\000\000\n\015~\000\000\012\234\000\000\004\165\000\000\000\000\012\242\002~\000R\000V\000Z\000\146\n\162\000\150\011\026\000\154\000\158\000\162\000^\011\030\000\170\000\174\000\000\000v\000\000\000\182\011\"\000\186\001\146\001\150\000z\011&\006I\000\000\000\000\000\000\000\000\011*\000\000\000\000\000\000\000\000\000\000\000\000\011:\000\000\001\154\000\000\007\233\007\233\001\242\000\000\012B\011B\007\233\012F\000\000\000\000\012J\011\026\000\000\000\000\000\000\000~\011\030\012^\000\000\000\000\n\005\025z\000\000\011\"\000\000\000\000\002\002\000\000\011&\025~\000\000\000\000\000\000\000\000\000\000\019\218\012\162\000\000\000\000\000\000\014&\000\000\000\000\000\000\000\000\002&\000\000\002*\000\000\000\190\001\162\000\000\014.\000\000\000\000\000\000\012\186\0022\0142\000\000\000\000\012\190\006\238\002:\000\000\016J\000\000\012\194\012\198\011V\011Z\012\202\0146\000\000\000\000\000\000\000\000\014:\004\001\000\000\000\198\016N\004\001\000\000\000\000\000\000\000\000\000\000\006\254\012\206\000\000\000\000\014>\014B\012\210\014F\000\000\000\n\000\000\014Z\000\000\000\000\011\194\000\000\000\000\014f\012\218\000\202\011\198\000\000\004\001\000\000\000\000\000\000\000\000\000\000\000\000\000\206\000\000\000\000\015\"\000\000\000\000\000\000\015&\015r\000\000\011^\000\000\000\000\012\222\000\000\015v\000\000\000\000\000\000\012\230\000\000\004\001\000\000\000\000\000\000\000\n\015~\000\000\012\234\000\000\004\165\000\000\004\001\012\242\002~\000R\000V\000Z\000\146\000\000\000\150\011\026\000\154\000\158\000\162\000^\011\030\000\170\000\174\000\000\000v\000\000\000\182\011\"\000\186\001\146\001\150\000z\011&\rY\rY\000\000\004\001\004\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\154\000\000\nq\nq\001\242\000\000\012B\003J\nq\001\246\004\001\004\001\001\250\004\001\000\000\000\000\000\000\000~\000\000\004\001\004\001\000\000\t\253\000\000\000\000\004\001\000\000\000\000\002\002\000\000\000\000\002\006\000\000\000\000\000\000\000\000\000\000\002\026\002\022\000\000\002\030\000\000\000\000\000\000\000\000\000\000\000\000\002&\000\000\002*\000\000\000\000\001\162\005z\000\000\000\000\005\130\000\000\002.\0022\000\000\000\000\000\000\0026\001\"\002:\rY\000\000\000\000\002>\002B\011V\014n\002F\002J\000\000\000\000\000\000\000\000\005\146\005\154\000\000\000\000\000\000\000\000\000\000\rY\000\000\000\000\000\000\000\190\002N\000\000\000\000\005\162\000\000\002R\rY\002E\000\n\005\170\005\178\000\000\rY\rY\000\000\016J\000\000\002Z\000\000\005\186\000\000\000\000\005\194\000\000\005\202\000\000\000\000\000\000\002^\000\000\000\198\016N\000\000\000\000\000\000\000\000\000\000\000\022\011^\000\000\000\000\002b\000\000\004R\rY\000\000\000\000\002n\000\000\rY\rY\005\210\011\194\000\000\000\000\000\000\002\134\000\202\011\198\000\000\000\000\002v\002~\000R\000V\000Z\000\146\000\206\000\150\011\026\000\154\000\158\000\162\000^\011\030\000\170\000\174\000\000\000v\000\000\000\182\011\"\000\186\001\146\001\150\000z\011&\000\000\000\000\000\000\000\000\005\218\000\n\000\000\002E\000\000\000\000\000\000\005\226\000\000\000\000\001\154\000\000\000\000\000\000\001\242\000\000\012B\000\000\000\000\012F\000\000\002E\012J\000\000\000\000\002E\002E\000~\000\000\018\198\000\000\000\000\n\005\000\000\000\000\000\000\005\234\005\242\002\002\000\000\000\000\000\000\006I\000\000\000\000\000\000\000\000\018\214\012\162\000\000\000\000\001\t\000\000\000\000\001\t\000\000\000\000\002&\000\000\002*\000\000\000\000\001\162\000\000\000\000\000\000\000\000\000\000\012\186\0022\000\000\000\000\000\000\012\190\001\"\002:\000\000\002\242\003\026\012\194\012\198\011V\014n\012\202\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\250\000\000\000\000\000\000\001\t\000\000\001\t\001\t\006\254\012\206\000\000\000\000\000\000\000\000\012\210\000\000\003\"\000\n\000\000\003\002\000\000\003\018\000\000\000\000\r\193\000\000\012\218\000\000\000\000\r\193\000\000\000j\r\193\000r\r\193\000\000\r\193\000\000\000\178\000\000\000\000\r\193\r\193\000\000\r\193\000\000\000\000\011^\003*\000\000\012\222\000\000\018\218\000\000\000\000\r\193\012\230\r\193\000\000\000\000\000\000\r\193\r\193\018\226\000\000\012\234\000\000\r\193\000\000\000\000\012\242\002~\000\000\r\193\r\193\000\000\r\193\000\000\r\193\000\000\r\193\000\000\000\000\000\000\000\000\000\000\r\193\000\000\0032\000\000\000\000\001\t\000\000\r\193\r\193\003\n\000\000\r\193\000\000\000\000\000\000\000\000\r\193\r\193\000\000\007\198\r\193\000\000\r\193\001\t\000\000\000\000\000\000\001\t\001\t\r\193\000\000\000\000\000\000\000\000\r\193\r\193\000\000\000\000\001\t\003:\000\000\000\000\000\000\000\000\r\193\007\206\007\214\r\193\r\193\000\000\r\193\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\r\193\007\222\000\000\000\000\r\193\000\000\000\000\007\230\007\238\r\193\r\193\r\193\000\000\r\193\r\193\r\193\r\193\007\246\000\000\000\000\007\254\000\000\b\006\r\193\000\000\r\173\r\193\000\000\000\000\000\000\r\173\000\000\000\000\r\173\000b\r\173\000\000\r\173\000\000\000\000\000\000\r\193\r\173\r\173\000\000\r\173\r\193\r\193\r\193\b\014\000\000\r\193\r\193\000\000\000\000\r\193\r\173\000\000\r\173\000\000\r\193\r\193\r\173\r\173\000\000\000\000\r\193\000\000\r\173\000\000\000\000\000\000\000\000\000\000\r\173\r\173\000\000\r\173\000\000\r\173\000\000\r\173\000\000\000\000\000\000\000\000\000\000\r\173\000\000\b\022\000\000\000\000\000\000\000\000\r\173\r\173\b\030\000\000\r\173\000\000\000\000\000\000\000\000\r\173\r\173\000\000\000\205\r\173\000\000\r\173\005]\000\000\000\000\000\000\000\000\000\000\r\173\005]\000\000\000\000\000\000\r\173\r\173\000\000\000\000\b&\b.\000\000\000\000\000\000\000\000\r\173\002\242\003\026\r\173\r\173\000\000\r\173\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\r\173\002\250\000\000\000\000\r\173\000\000\000\000\000\205\000\205\r\173\r\173\r\173\000\000\r\173\r\173\r\173\r\173\003\"\000\000\000\000\003\002\000\000\003\018\r\173\000\000\r\201\r\173\000\000\000\000\000\000\r\201\000\000\000\000\r\201\000n\r\201\000\000\r\201\000\000\000\000\000\000\r\173\r\201\r\201\000\000\r\201\r\173\r\173\r\173\003*\000\000\r\173\r\173\000\000\000\000\r\173\r\201\000\000\r\201\000\000\r\173\r\173\r\201\r\201\000\000\000\000\r\173\000\000\r\201\000\000\000\000\000\000\000\000\000\000\r\201\r\201\000\000\r\201\000\000\r\201\000\000\r\201\000\000\000\000\000\000\000\000\000\000\r\201\000\000\0032\000\000\000\000\000\000\000\000\r\201\r\201\003\n\000\000\r\201\000\000\000\000\000\000\000\000\r\201\r\201\000\000\000\181\r\201\000\000\r\201\000\205\000\000\000\000\000\000\000\000\000\000\r\201\000\205\000\000\000\000\000\000\r\201\r\201\000\000\000\000\000\205\003:\000\000\000\000\000\000\000\000\r\201\000\181\000\181\r\201\r\201\000\000\r\201\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\r\201\002\250\000\000\000\000\r\201\000\000\000\000\000\181\000\181\r\201\r\201\r\201\000\000\r\201\r\201\r\201\r\201\000\181\000\000\000\000\003\002\000\000\003\018\r\201\000\000\b\145\r\201\000\000\000\000\000\000\b\145\000\000\000\000\b\145\000\000\b\145\000\000\b\145\000\000\000\000\000\000\r\201\b\145\b\145\000\000\b\145\r\201\r\201\r\201\000\181\000\000\r\201\r\201\000\000\000\000\r\201\b\145\000\000\b\145\000\000\r\201\r\201\b\145\b\145\000\000\000\000\r\201\000\000\b\145\000\000\000\000\000\000\000\000\000\000\b\145\b\145\000\000\b\145\000\000\b\145\000\000\b\145\000\000\000\000\000\000\000\000\000\000\b\145\000\000\000\181\000\000\000\000\000\000\000\000\b\145\b\145\003\n\000\000\b\145\001\134\000\000\000\000\000\000\b\145\b\145\000\000\000\177\b\145\000\000\b\145\000\181\000\000\000\000\000\000\000\000\000\000\b\145\000\181\000\000\000\000\000\000\b\145\b\145\000\000\000\000\000\181\000\181\000\000\000\000\000\000\000\000\b\145\000\177\000\177\b\145\b\145\000\000\b\145\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\145\002\250\000\000\000\000\b\145\000\000\000\000\000\177\000\177\b\145\b\145\b\145\000\000\b\145\b\145\b\145\b\145\000\177\000\000\000\000\003\002\000\000\003\018\b\145\000\000\r\185\b\145\000\000\000\000\000\000\r\185\000\000\000\000\r\185\000\000\r\185\000\000\r\185\000\000\000\000\000\000\b\145\r\185\r\185\000\000\r\185\b\145\b\145\b\145\000\177\000\000\b\145\b\145\000\000\000\000\b\145\r\185\000\000\r\185\000\000\b\145\b\145\r\185\r\185\000\000\000\000\b\145\000\000\r\185\000\000\000\000\000\000\000\000\000\000\r\185\r\185\000\000\r\185\000\000\r\185\000\000\r\185\000\000\000\000\000\000\000\000\000\000\r\185\000\000\000\177\000\000\000\000\000\000\000\000\r\185\r\185\003\n\000\000\r\185\001\166\000\000\000\000\000\000\r\185\r\185\000\000\000\169\r\185\000\000\r\185\000\177\000\000\000\000\000\000\000\000\000\000\r\185\000\177\000\000\000\000\000\000\r\185\r\185\000\000\000\000\000\177\000\177\000\000\000\000\000\000\000\000\r\185\000\169\000\169\r\185\r\185\000\000\r\185\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\r\185\000\169\000\000\000\000\r\185\000\000\000\000\000\169\000\169\r\185\r\185\r\185\000\000\r\185\r\185\r\185\r\185\000\169\000\000\000\000\003\002\000\000\000\169\r\185\000\000\b\157\r\185\000\000\000\000\000\000\b\157\000\000\000\000\b\157\000\000\b\157\000\000\b\157\000\000\000\000\000\000\r\185\b\157\b\157\000\000\b\157\r\185\r\185\r\185\000\169\000\000\r\185\r\185\000\000\000\000\r\185\b\157\000\000\b\157\000\000\r\185\r\185\b\157\b\157\000\000\000\000\r\185\000\000\b\157\000\000\000\000\000\000\000\000\000\000\b\157\b\157\000\000\b\157\000\000\b\157\000\000\b\157\000\000\000\000\000\000\000\000\000\000\b\157\000\000\000\169\000\000\000\000\000\000\000\000\b\157\b\157\003\n\000\000\b\157\n>\000\000\000\000\000\000\b\157\b\157\000\000\000\000\b\157\000\000\b\157\000\169\000\000\000\000\000\000\000\000\000\000\b\157\000\169\000\000\000\000\000\000\b\157\b\157\000\000\000\000\000\169\000\169\000\000\004y\000\000\000\000\b\157\000\000\000\000\b\157\b\157\000\000\b\157\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\157\000\000\027v\000\000\b\157\000\000\000\000\000\000\000\000\b\157\b\157\b\157\000\000\b\157\b\157\b\157\b\157\000\000\000\000\000\000\000\000\000\000\000\000\b\157\000\000\000\000\b\157\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\157\000\000\000\000\000\000\000\000\b\157\b\157\b\157\000\000\000\000\b\157\b\157\000\000\000\000\b\157\000\000\000\000\000\000\000\000\b\157\b\157\000R\000V\000Z\000\146\b\157\000\150\000\000\000\154\000\158\000\162\000^\000\000\000\170\000\174\000\000\000v\027\230\000\182\000\000\000\186\001\146\001\150\000z\000\n\000\000\000\000\027\250\000\000\000\000\000\000\004y\000\000\000\000\028R\000\000\027\254\004y\004y\001\154\000\000\000\000\000\000\001\242\000\000\000\190\000\000\000\000\002\n\004y\004y\002\014\000\000\000\000\000\000\000\000\000~\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\002\000\000\000\000\002\006\000\000\000\000\000\000\000\000\004y\002\162\004\146\000\000\002\030\000\000\000\000\005*\000\190\000\000\000\000\002&\000\000\002*\000\000\000\000\001\162\001\241\000\000\000\000\001\241\000\000\004\206\0022\0176\000\000\000\000\004\210\001\"\002:\000\000\000\000\005.\004\214\004\218\000\000\000\000\004\222\002J\000\198\017:\000\000\000\000\001\241\001\241\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004R\000\000\000\000\004\226\000\000\000\000\001\241\000\000\004\230\011\194\001\241\000\n\001\241\001\241\000\202\011\198\000\000\000\000\000\000\000\000\004\238\000\000\001\241\000\000\000\206\001\241\000\000\001\241\000\000\000\000\000\000\0052\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\242\000\000\000\000\000\000\000\000\000\n\004\250\000\000\000\000\004\t\001\241\000\000\000\000\000\000\000\000\004\254\000\000\000\000\000\000\000\000\005\006\002~\000R\000V\000Z\000\146\000\000\000\150\000\000\000\154\000\158\000\162\000^\000\000\000\170\000\174\000\000\000v\000\000\000\182\000\000\000\186\001\146\001\150\000z\000\000\006I\000\000\000\000\000\000\001\241\005B\000\000\001\241\000\000\000\000\000\000\001\241\000\000\000\000\001\154\000\000\000\000\000\000\001\242\000\000\000\190\000\000\000\000\002\n\000\000\001\241\002\014\000\000\000\000\001\241\001\241\000~\000\000\000\000\000\000\000\000\005J\000\000\000\000\000\000\001\241\001\241\002\002\000\000\000\000\002\006\000\000\000\000\000\000\000\000\000\000\002\162\004\146\000\000\002\030\000\000\000\000\005*\000\000\000\000\000\000\002&\000\000\002*\000\000\000\000\001\162\000\000\000\000\000\000\000\000\000\000\004\206\0022\000\000\000\000\000\000\004\210\001\"\002:\000\000\000\000\005.\004\214\004\218\000\000\000\000\004\222\002J\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\015)\000\000\000\000\004\226\000\000\000\000\000\000\000\000\004\230\000\000\000\000\000\n\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\238\000\000\000\000\000\000\000\000\000\000\015)\015)\000\000\000\000\000\000\0052\000\000\000\000\007Z\000\000\000\000\000\000\000\000\000\000\000\000\015)\000\000\000\000\004\242\000\000\000\000\015)\015)\000\000\004\250\007b\000\000\b\189\007n\000\000\000\000\015)\000\000\004\254\015)\000\000\015)\000\000\005\006\002~\000R\000V\000Z\000\146\000\000\000\150\000\000\000\154\000\158\000\162\000^\000\000\000\170\000\174\000\000\000v\000\000\000\182\000\000\000\186\001\146\001\150\000z\015)\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\154\000\000\000\000\000\000\001\242\007z\000\190\000\000\000\000\002\n\000\000\000\000\002\014\000\000\000\000\000\000\000\000\000~\000\000\000\000\000\000\000\000\000\000\000\000\000\000\015)\000\000\000\000\002\002\000\000\007~\002\006\015)\000\000\000\000\000\000\000\000\002\162\004\146\000\000\002\030\007\134\000\000\005*\000\000\000\000\015)\002&\000\000\002*\000\000\000\000\001\162\015)\000\000\000\000\000\000\000\000\004\206\0022\000\000\015)\015)\004\210\001\"\002:\000\000\000\000\005.\004\214\004\218\000\000\000\000\004\222\002J\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\241\000\000\000\000\000\241\000\000\000\000\000\000\000\000\004\226\000\000\000\000\000\000\000\000\004\230\000\000\000\000\000\n\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\238\000\241\000\241\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\0052\000\000\000\000\000\000\000\000\002\250\000\000\000\000\000\000\000\241\000\000\000\241\000\241\004\242\000\000\000\000\000\000\000\000\000\000\004\250\000\000\000\241\002a\000\000\003\002\000\000\003\018\000\000\004\254\000\000\000\000\000\000\000\000\005\006\002~\000R\000V\000Z\000\146\000\000\000\150\000\000\000\154\000\158\000\162\000^\000\000\000\170\000\174\000\000\000v\000\000\000\182\000\241\000\186\001\146\001\150\000z\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\154\000\000\000\000\000\000\001\242\000\000\000\190\000\000\000\000\002\n\000\000\000\000\002\014\000\000\000\000\000\000\000\000\000~\000\000\000\000\000\241\000\000\000\000\000\241\000\000\000\000\000\000\003\n\002\002\000\000\000\000\002\006\000\000\000\000\000\000\000\000\000\000\002\162\004\146\000\000\002\030\000\241\000\000\005:\000\000\000\241\000\241\002&\000\000\002*\000\000\000\000\001\162\000\000\000\000\000\000\000\241\000\241\004\206\0022\000\000\000\000\000\000\004\210\001\"\002:\000\000\000\000\005.\004\214\004\218\000\000\000\000\004\222\002J\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\226\000\000\000\000\000\000\000\000\004\230\000\000\000\000\000\n\000\000\000\000\000\000\000\000\000R\000V\000Z\000\146\004\238\000\150\000\000\000\154\000\158\000\162\000^\000\000\000\170\000\174\000\000\000v\000\000\000\182\000\000\000\186\001\146\001\150\000z\000\000\000\000\000\000\000\000\000\000\004\242\000\000\000\000\000\000\000\000\000\000\004\250\000\000\000\000\b\205\001\154\000\000\000\000\000\000\001\242\004\254\000\190\000\000\000\000\001\246\005\006\002~\001\250\000\000\000\000\000\000\000\000\000~\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\002\000\000\000\000\002\006\000\000\000\000\000\000\000\000\000\000\002\026\002\022\000\000\002\030\000\000\000\000\000\000\000\000\000\000\000\000\002&\000\000\002*\000\000\000\000\001\162\000\000\000\000\000\000\000\000\000\000\002.\0022\000\000\000\000\000\000\0026\001\"\002:\000\000\000\000\000\000\002>\002B\000\000\000\000\002F\002J\000\000\000V\004^\000\146\000\000\000\150\000\000\000\154\000\158\004b\000^\000\000\000\170\000\174\000\000\000v\002N\000\182\000\000\000\186\001\146\002R\000z\000\000\000\n\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002Z\000\000\000\000\000\000\000\000\001\154\000\000\000\000\000\000\000\000\000\000\002^\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000~\000\000\002b\000\000\000\000\000\000\000\000\000\000\002n\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\134\000\000\000\000\000\000\000\000\002v\002~\001\149\001\149\001\149\001\149\000\000\001\149\005\233\001\149\001\149\001\149\001\149\001\162\001\149\001\149\000\000\001\149\000\000\001\149\005\233\001\149\001\149\001\149\001\149\000\000\000\000\000\000\000\000\020Z\000\000\005\233\000\000\005\233\000\000\000\000\000\000\005\233\005\233\001\149\001\149\001\149\000\000\005\233\000\000\020^\000\000\000\000\000\000\005\233\000\000\001\149\005\233\000\000\000\000\000\000\005\233\001\149\000\000\000\000\001\149\000\000\005\233\000\000\001\149\000\000\000\000\020j\000\000\000\000\001\149\000\000\000\000\005\233\000\000\000\000\000\000\001\149\005\233\011\006\000\000\000\000\001\149\000\000\005\233\000\000\000\000\000\000\000\000\000\000\000\000\001\149\001\149\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\005\233\000\000\000\000\005\233\000\000\000\000\005\233\000\000\001\149\000\000\000\000\001\149\000\000\000\000\001\149\000\000\000\000\000\000\000\000\005\233\000\000\000\000\000\000\000\000\005\233\005\233\005\233\001\149\005\233\005\233\000\000\005\233\001\149\000\000\001\149\000\000\000\000\001\149\005\233\020n\000\000\005\233\000\000\000\000\001\149\000\000\001\149\000\000\000\000\001\149\000\000\000\000\000\000\000\000\000\000\000\000\005\233\000\000\000\000\000\000\000\000\005\233\005\233\000\000\001\149\001\149\000\000\000\000\000\000\001\149\001\149\000\000\000\000\000\000\000R\000V\004^\000\146\000\000\000\150\021B\000\154\000\158\004b\000^\000\000\000\170\000\174\020v\000v\000\000\000\182\000\000\000\186\001\146\001\150\000z\000\000\000\000\000\000\020z\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\020~\001\154\020\130\000\000\000\000\000\000\020\134\000\000\000\000\000\000\000\000\000\000\020\138\000\000\000\000\000\000\000\000\000\000\024\158\000\000\000\000\020\150\000\000\000\000\000\000\020\154\000\000\000\000\000\000\000\000\000\000\020\158\000\000\000\000\000\000\000\000\000\000\000\000\n\166\000\000\000\000\000\000\000\000\022:\000\000\000\000\000\000\020\162\023\166\000\000\000\000\011*\000\000\001\162\000\000\000\000\000\000\000\000\011:\000\000\000\000\000\000\000\000\000\000\001\242\000\000\000\190\011B\000\000\012F\000\000\000\000\012J\000\000\000\000\n\210\000\000\000\000\020\166\012^\000\000\020\170\n\005\000\000\000\000\000\000\000\000\000\000\002\002\000\000\000\000\000\000\000\000\000\000\020\174\000\000\000\000\014V\012\162\020\178\000\n\020\182\014&\020\186\020\190\000\000\020\194\002&\000\000\002*\000\000\000\000\000\000\020\198\014.\000\000\020\202\000\000\012\186\0022\0142\000\000\000\000\012\190\006\238\002:\000\000\000\000\000\000\012\194\012\198\020\206\000\000\012\202\0146\000\000\020\210\020\214\000\000\014:\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\006\254\012\206\000\000\000\000\014>\014B\012\210\014F\000\000\000\n\000\000\014Z\000\000\000\000\000\000\000\000\000\000\014f\012\218\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\015\"\000\000\000\000\000\000\015&\015r\011*\000\000\000\000\000\000\012\222\000\000\015v\011:\000\000\000\000\012\230\000\000\000\000\001\242\000\000\000\190\011B\015~\012F\012\234\000\000\012J\000\000\000\000\012\242\002~\000\000\000\000\012^\000\000\000\000\n\005\000\000\000\000\000\000\000\000\000\000\002\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\012\182\012\162\000\000\000\000\000\000\014&\000\000\000\000\000\000\000\000\002&\000\000\002*\000\000\000\000\000\000\000\000\014.\000\000\000\000\015A\012\186\0022\0142\000\000\000\000\012\190\006\238\002:\000\000\000\000\000\000\012\194\012\198\000\000\000\000\012\202\0146\000\000\000\000\000\000\000\000\014:\000\000\000\000\000\000\015A\015A\000\000\000\000\000\000\000\000\000\000\006\254\012\206\000\000\000\000\014>\014B\012\210\014F\015A\000\n\000\000\014Z\000\000\000\000\015A\015A\000\000\014f\012\218\000\000\000\000\000\000\004\198\000\000\015A\000\000\000\000\015A\000\000\015A\000\000\000\000\015\"\000\000\000\000\000\000\015&\015r\000\000\000\000\000\000\000\000\012\222\000\000\015v\000\000\000\000\000\000\012\230\000\000\000\000\000\000\000\000\000\000\000\000\015~\015A\012\234\000\000\000\000\000\000\000\000\012\242\002~\000R\000V\000Z\000\146\000\000\000\150\000\000\000\154\000\158\000\162\000^\000\000\000\170\000\174\000\000\000v\000\000\000\182\000\000\000\186\001\146\001\150\000z\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\015A\000\000\000\000\000\000\000\000\000\000\001\154\015A\000\000\000\000\001\242\000\000\000\190\000\000\000\000\012F\000\000\000\000\012J\000\000\000\000\015A\000\000\000~\000\000\000\000\000\000\000\000\015A\000\000\000\000\000\000\000\000\000\000\002\002\000\000\015A\015A\000\000\000\000\000\000\000\000\000\000\019\218\012\162\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002&\000\000\002*\000\000\000\000\001\162\015\205\000\000\000\000\015\205\000\000\012\186\0022\000\000\000\000\000\000\012\190\001\"\002:\000\000\000\000\000\000\012\194\012\198\000\000\012\157\012\202\000\000\000\000\000\000\000\000\000\000\015\205\015\205\000\000\000\000\000\000\015\205\000\000\000\000\015\205\015\205\000\000\006\254\012\206\000\000\000\000\015\205\000\000\012\210\015\205\015\205\000\n\015\205\015\205\000\000\012\157\015\205\000\000\015\205\015\205\012\218\000\000\015\205\000\000\000\000\015\205\000\000\015\205\015\205\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\012\157\000\000\012\222\000\000\000\000\000\000\000\000\000\000\012\230\000\000\012\157\000\000\015\205\000\000\015\205\000\000\000\000\012\234\000\000\000\000\000\000\000\000\012\242\002~\000\000\015\205\000\000\000\000\000\000\000\000\000\000\000\000\015\205\000\000\000\000\012\157\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\015\205\015\205\000\000\015\205\015\205\015\205\000\000\015\205\000\000\000\000\000\000\000\000\000\000\000\000\005\t\000\000\015\205\005\t\000\000\005\t\000\000\015\205\005\t\000\000\015\205\000\000\015\205\000\000\000\000\000\000\000\000\000\000\015\205\015\205\015\205\000\000\015\205\015\205\012\153\015\205\005\t\005\t\000\000\000\000\000\000\005\t\005\t\000\000\005\t\005\t\005\t\000\000\000\000\005\t\005\t\005\t\000\000\000\000\000\000\000\000\005\t\005\t\005\t\005\t\005\t\005\t\005\t\005\t\005\t\012\153\005\t\005\t\005\t\005\t\005\t\000\000\005\t\005\t\000\000\005\t\000\000\005\t\005\t\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\012\153\000\000\000\000\000\000\000\000\000\000\000\000\005\t\000\000\000\000\012\153\000\000\005\t\000\000\005\t\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\005\t\000\000\005\t\000\000\000\000\000\000\000\000\005\t\000\000\000\000\012\153\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\005\t\005\t\000\000\000\000\007\141\005\t\005\t\005\t\005\t\007\141\005\t\000\000\005\t\000\000\000\000\000\000\005\t\000\000\000\000\000\000\000\000\005\t\000\000\000\000\005\t\000\000\005\t\000\000\005\t\005\t\000\000\005\t\005\t\000\000\000\000\000\000\005\t\005\t\005\t\005\t\000\000\005\t\005\t\000\000\005\t\012\t\012\t\012\t\012\t\000\000\012\t\000\000\012\t\012\t\012\t\012\t\000\000\012\t\012\t\000\000\012\t\000\000\012\t\000\000\012\t\012\t\012\t\012\t\000\000\000\000\015}\000\000\000\000\015}\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\012\t\012\t\012\t\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\012\t\000\000\015}\015}\000\000\000\000\012\t\015}\000\000\021R\002\150\015}\000\000\021Z\000\000\000\000\000\000\015}\000\000\012\t\015}\015}\000\000\015}\015}\000\000\012\t\002\158\000\000\015}\002\178\012\t\000\000\015}\000\000\000\000\015}\000\000\015}\015}\012\t\012\t\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\012\t\000\000\015}\012\t\015}\000\000\012\t\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\015}\000\000\000\000\000\000\012\t\000\000\000\000\004\014\000\000\012\t\000\000\012\t\000\000\000\000\012\t\000\000\000\000\000\000\000\000\000\000\000\000\012\t\000\000\012\t\000\000\000\000\012\t\015}\015}\000\000\015}\015}\004\018\000\000\015}\000\000\000\000\000\000\000\000\000\000\000\000\012\t\012\t\004\026\000\000\000\000\021\174\012\t\015}\000\000\000\000\015}\015}\015}\015}\015}\000\000\000\000\000\000\015}\015}\015}\015\r\015}\015}\015\r\015}\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\015\r\015\r\000\000\000\000\000\000\015\r\000\000\000\000\002\150\015\r\000\000\000\000\000\000\000\000\000\000\015\r\000\000\000\000\015\r\015\r\000\000\015\r\015\r\000\000\000\000\002\158\000\000\015\r\002\178\000\000\000\000\015\r\000\000\000\000\015\r\000\000\015\r\015\r\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\015\r\000\000\015\r\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\015\r\011\249\011\249\011\249\011\249\000\000\011\249\004\014\011\249\011\249\011\249\011\249\000\000\011\249\011\249\000\000\011\249\000\000\011\249\000\000\011\249\011\249\011\249\011\249\000\000\000\000\000\000\015\r\015\r\000\000\015\r\015\r\004\018\000\000\015\r\000\000\000\000\000\000\011\249\011\249\011\249\000\000\000\000\004\026\000\000\000\000\000\000\000\000\015\r\000\000\011\249\015\r\015\r\015\r\015\r\015\r\011\249\000\000\000\000\015\r\015\r\015\r\000\000\015\r\015\r\000\000\015\r\000\000\000\000\011\249\000\000\000\000\000\000\000\000\000\000\000\000\011\249\000\000\000\000\000\000\000\000\011\249\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\011\249\011\249\000\000\000V\004^\000\146\000\000\000\150\000\000\000\154\000\158\004b\000^\000\000\000\170\000\174\000\000\000v\000\000\000\182\000\000\000\186\001\146\011\249\000z\000\000\011\249\000\000\000\000\011\249\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\154\000\000\011\249\000\000\000\000\000\000\001\170\011\249\000\000\011\249\000\000\000\000\011\249\000\000\000\000\000\000\000\000\000~\000\000\011\249\000\000\011\249\000\000\000\000\011\249\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\011\249\011\249\000\000\000\000\000\000\021V\011\249\011\253\011\253\011\253\011\253\000\000\011\253\001\162\011\253\011\253\011\253\011\253\000\000\011\253\011\253\000\000\011\253\000\000\011\253\000\000\011\253\011\253\011\253\011\253\000\000\000\000\005\017\000\000\000\000\005\017\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\011\253\011\253\011\253\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\011\253\000\000\005\017\005\017\000\n\000\000\011\253\005\017\000\000\021\178\005\017\005\017\000\000\000\000\000\000\000\000\000\000\005\017\000\000\011\253\005\017\005\017\000\000\005\017\005\017\000\000\011\253\005\017\000\000\005\017\005\017\011\253\000\000\005\017\000\000\000\000\005\017\000\000\005\017\005\017\011\253\011\253\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\011\253\000\000\005\017\011\253\005\017\000\000\011\253\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\005\017\000\000\000\000\000\000\011\253\000\000\000\000\005\017\000\000\011\253\000\000\011\253\000\000\000\000\011\253\000\000\000\000\000\000\000\000\000\000\000\000\011\253\000\000\011\253\000\000\000\000\011\253\005\017\005\017\000\000\005\017\007\153\005\017\000\000\005\017\000\000\000\000\000\000\000\000\000\000\000\000\011\253\011\253\005\017\000\000\000\000\005\r\011\253\005\017\005\r\000\000\005\017\000\000\005\017\000\000\005\017\000\000\000\000\000\000\005\017\005\017\005\017\000\000\005\017\005\017\000\000\005\017\000\000\000\000\000\000\000\000\000\000\005\r\005\r\000\000\000\000\000\000\005\r\000\000\000\000\005\r\005\r\000\000\000\000\003\146\000\000\000\000\005\r\000\000\000\000\005\r\005\r\000\000\005\r\005\r\000\000\000\000\005\r\000\000\005\r\005\r\000\000\000\000\005\r\000\000\000\000\005\r\000\000\005\r\005\r\002\242\003\026\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\250\000\000\000\000\000\000\000\000\000\000\000\213\003\154\000\000\000\000\005\r\000\000\005\r\000\000\000\000\000\000\003\"\000\000\000\000\003\002\000\000\003\018\000\000\005\r\000R\000V\004^\000\146\000\000\000\150\005\r\000\154\000\158\004b\000^\000\000\000\170\000\174\000\000\000v\000\000\000\182\000\000\000\186\001\146\001\150\000z\000\000\003*\000\000\005\r\005\r\000\000\005\r\007\145\005\r\000\000\005\r\000\000\000\000\000\000\021\186\001\154\021\214\000\000\000\000\005\r\000\000\000\000\000\000\000\000\005\r\000\000\021\226\005\r\000\000\005\r\000\000\005\r\000~\000\000\000\000\005\r\005\r\005\r\000\000\005\r\005\r\0032\005\r\000\000\000\000\021\250\000\000\000\000\003\n\000\000\000\000\000\000\n\166\000\000\000\000\000\000\000\000\022:\000\000\000\000\000\000\000\000\000\213\000\000\000\000\000\000\022Z\001\162\000\000\000\213\000\000\000\000\000\000\000\000\000\000\000\000\000\000\003\162\003:\000\000\000\000\000\000\000\000\001\242\000\000\000\190\000\000\000\000\004\170\n\210\000\000\004\174\022f\000\000\000\000\022\190\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\002\022\214\000\000\004\202\000\000\000\000\023\002\000\000\t\237\006\142\006\154\0232\006\178\006\190\006\214\006\218\000\000\000\000\023>\002&\023j\002*\000\000\024j\000\000\000\000\000\000\000\000\000\000\000\000\006\222\0022\000\000\006\226\006\230\006\234\006\238\002:\024v\024\142\000\000\006\242\006\246\000\000\024\154\006\250\000\206\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\006\254\007\002\000\000\000\000\000\000\000\000\007\006\000\000\000\000\000\n\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\007\014\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\006\t\000\000\007\018\000\000\007\"\001\242\000\000\000\190\000\000\000\000\004\170\000\000\000\000\004\174\000\000\007*\000\000\000\000\000\000\000\000\000\000\0072\000\000\000\000\000\000\000\000\000\000\004\025\000\000\002\002\0076\000\000\004\202\000\000\000\000\007>\002~\000\000\006\142\006\154\000\000\006\178\006\190\006\214\006\218\000\000\000\000\000\000\002&\000\000\002*\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\006\222\0022\000\000\006\226\006\230\006\234\006\238\002:\000\000\000\000\000\000\006\242\006\246\000\000\000\000\006\250\000\206\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\006\254\007\002\000\000\000\000\000\000\000\000\007\006\000\000\000\000\000\n\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\007\014\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\006\t\000\000\007\018\000\000\007\"\001\242\000\000\000\190\000\000\000\000\004\170\000\000\000\000\004\174\000\000\007*\000\000\000\000\000\000\000\000\000\000\0072\000\000\000\000\000\000\000\000\000\000\t\017\000\000\002\002\0076\000\000\004\202\000\000\000\000\007>\002~\000\000\006\142\006\154\000\000\006\178\006\190\006\214\006\218\000\000\000\000\000\000\002&\000\000\002*\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\006\222\0022\000\000\006\226\006\230\006\234\006\238\002:\000\000\000\000\000\000\006\242\006\246\000\000\000\000\006\250\000\206\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\006\254\007\002\000\000\000\000\000\000\000\000\007\006\000\000\000\000\000\n\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\007\014\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\006\t\000\000\007\018\000\000\007\"\001\242\000\000\000\190\000\000\000\000\004\170\000\000\000\000\004\174\000\000\007*\000\000\000\000\000\000\000\000\000\000\0072\000\000\000\000\000\000\000\000\000\000\002\145\000\000\002\002\0076\000\000\004\202\000\000\000\000\007>\002~\000\000\006\142\006\154\000\000\006\178\006\190\006\214\bV\000\000\003\146\000\000\002&\000\000\002*\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\006\222\0022\000\000\006\226\006\230\006\234\006\238\002:\000\000\000\000\000\000\006\242\006\246\002\242\003\026\006\250\000\206\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\250\000\000\000\000\000\000\006\254\007\002\000\201\000\201\000\000\000\000\007\006\000\000\000\000\000\n\000\000\000\000\003\"\000\000\000\000\003\002\000\000\003\018\007\014\000\000\015\149\000\000\000\000\015\149\000\000\000\000\000\000\006\t\000\000\000\000\000\000\007\"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\007*\000\000\003*\000\000\015\149\015\149\0072\000\000\000\000\015\149\000\000\000\000\t!\015\149\000\000\0076\000\000\000\000\000\000\015\149\007>\002~\015\149\015\149\000\000\015\149\015\149\000\000\000\000\000\000\000\000\015\149\000\000\004\198\000\000\015\149\000\000\000\000\015\149\000\000\015\149\015\149\0032\000\000\000\000\000\000\000\000\000\000\000\000\003\n\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\201\000\000\000\000\000\000\015\149\000\000\015\149\000\201\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\201\003:\015\149\000\000\000R\000V\000Z\000\146\n\162\000\150\011\026\000\154\000\158\000\162\000^\011\030\000\170\000\174\000\000\000v\025f\000\182\011\"\000\186\001\146\001\150\000z\011&\025j\015\149\015\149\000\000\015\149\015\149\000\000\000\000\015\149\000\000\000\000\000\000\000\000\000\000\001\154\015%\000\000\000\000\015%\000\000\001\170\000\000\015\149\000\000\000\000\015\149\015\149\015\149\015\149\015\149\000\000\000~\000\000\015\149\015\149\015\149\000\000\015\149\015\149\000\000\015\149\015%\015%\000\000\000\000\000\000\015%\000\000\000\000\000\000\015%\001\158\000\000\000\000\000\000\000\000\015%\000\000\000\000\015%\015%\000\000\015%\015%\000\000\000\000\001\162\000\000\015%\000\000\004\198\000\000\015%\000\000\000\000\015%\000\000\015%\015%\000\000\000\000\000\000\000\000\000\000\000\000\011V\011Z\000\000\n\170\000\000\000\000\000\000\000\000\000\193\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\015%\000\000\015%\000\000\000\000\000\000\000\000\000\000\000\000\000\n\000\000\000\000\000\000\015%\004\145\002\242\003\026\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\250\000\000\000\000\000\000\000\000\000\000\000\193\000\193\000\000\011^\015%\015%\000\000\015%\015%\000\000\000\193\015%\000\000\003\002\000\000\003\018\000\000\000\000\015a\000\000\000\000\015a\000\000\000\000\000\000\015%\000\000\000\000\015%\015%\015%\015%\015%\000\000\000\000\000\000\015%\015%\015%\000\000\015%\015%\003*\015%\015a\015a\000\000\000\000\000\000\015a\000\000\000\000\r\n\015a\000\000\000\000\000\000\000\000\000\000\015a\000\000\000\000\015a\015a\000\000\015a\015a\000\000\000\000\r\018\000\000\015a\r\030\000\000\000\000\015a\000\000\000\000\015a\000\000\015a\015a\000\193\000\000\000\000\000\000\000\000\000\000\000\000\003\n\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\225\000\000\000\000\001\225\000\000\000\193\000\000\000\000\000\000\015a\000\000\015a\000\193\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\193\000\193\015a\000\000\000\000\000\000\001\225\001\225\000\000\r*\000\000\001\225\000\000\000\000\000\000\001\225\000\000\000\000\000\000\000\000\000\000\001\225\000\000\000\000\001\225\001\225\000\000\001\225\001\225\015a\015a\000\000\015a\001\225\r.\000\000\015a\001\225\000\000\000\000\001\225\000\000\001\225\001\225\000\000\r6\001\225\000\000\000\000\000\000\000\000\000\000\000\000\015a\000\000\015a\000\000\000\000\000\000\000\000\000\000\015a\015a\015a\000\000\015a\015a\000\000\015a\001\225\001\225\001\225\000\000\000\000\001\225\000\000\000\000\000\000\001\225\000\000\000\000\000\000\001\225\000\000\001\225\000\000\000\000\001\225\001\225\000\000\001\225\001\225\000\000\000\000\000\000\000\000\001\225\000\000\000\000\000\000\001\225\000\000\000\000\001\225\000\000\001\225\001\225\000\000\000\000\001\225\002\186\000\000\001\225\001\225\000\000\000\000\001\225\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\225\000\000\001\225\001\225\001\225\001\225\001\225\000\000\000\000\000\000\000\000\003\254\001\225\001\225\000\000\001\225\001\225\000\000\001\225\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\225\002\194\000\000\001\225\001\225\000\000\000\000\001\225\000\000\000\000\000\000\000\000\000\000\000\000\001i\000\000\000\000\001i\000\000\000\000\000\000\001\225\000\000\000\000\001\225\001\225\001\225\001\225\000\000\000\000\000\000\000\000\003\242\001\225\001\225\000\000\001\225\001\225\000\000\001\225\001i\001i\000\000\000\000\000\000\001i\000\000\000\000\000\000\001i\000\000\000\000\000\000\000\000\000\000\002\250\000\000\000\000\001i\001i\000\000\001i\001i\000\000\000\000\000\000\000\000\001i\000\000\000\000\000\000\001i\000\000\000\000\003\002\000\000\003\018\001i\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001]\000\000\000\000\001]\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001i\000\000\001i\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001i\000\000\001]\001]\000\000\000\000\000\000\001]\000\000\000\000\000\000\001]\000\000\000\000\000\000\000\000\000\000\001]\000\000\000\000\001]\001]\000\000\001]\001]\000\000\000\000\001i\000\000\001]\001i\001i\000\000\001]\003\n\000\000\003\002\000\000\001]\001]\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001i\000\000\000\000\001i\001i\001i\001i\001i\000\000\000\000\000\000\000\000\001i\001i\000\000\001i\001i\001]\001i\001]\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001]\000\000\000R\000V\000Z\000\146\000\000\000\150\000\000\000\154\000\158\000\162\000^\000\000\000\170\000\174\000\000\000v\000\000\000\182\000\000\000\186\001\146\001\150\000z\000\000\000\000\001]\000\000\000\000\001]\001]\000\000\000\000\003\n\000\000\000\000\000\000\000\000\000\000\001\154\001a\000\000\000\000\001a\000\000\001\170\000\000\001]\000\000\000\000\001]\001]\001]\001]\001]\000\000\000~\000\000\000\000\001]\001]\000\000\001]\001]\000\000\001]\001a\001a\000\000\000\000\000\000\001a\000\000\000\000\000\000\001a\001\174\000\000\000\000\000\000\000\000\001a\001\202\000\000\001a\001a\000\000\001a\001a\000\000\000\000\001\162\000\000\001a\000\000\000\000\000\000\001a\000\000\000\000\003\002\000\000\001a\001a\000\000\001\178\001\182\000\000\000\000\000\000\000\000\000\000\000\000\001\186\000\000\000\000\000\000\000\000\001e\000\000\000\000\001e\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001a\000\000\001a\000\000\000\000\000\000\000\000\000\000\000\000\000\n\000\000\000\000\000\000\001a\000\000\001e\001e\000\000\000\000\000\000\001e\000\000\000\000\000\000\001e\000\000\000\000\000\000\000\000\001\206\002\250\000\000\000\000\001e\001e\000\000\001e\001e\000\000\000\000\001a\000\000\001e\001a\001a\000\000\001e\003\n\000\000\003\002\000\000\003\018\001e\000\000\014M\000\000\000\000\000\000\000\000\000\000\000\000\001a\000\000\000\000\001a\001a\001a\001a\001a\000\000\000\000\000\000\000\000\001a\001a\000\000\001a\001a\001e\001a\001e\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001e\000\000\000R\000V\000Z\000\146\000\000\000\150\000\000\000\154\000\158\000\162\000^\000\000\000\170\000\174\000\000\000v\000\000\000\182\000\000\000\186\001\146\001\150\000z\000\000\000\000\001e\000\000\000\000\001e\001e\000\000\000\000\003\n\000\000\000\000\000\000\000\000\000\000\001\154\001u\000\000\000\000\001u\000\000\001\170\000\000\001e\000\000\000\000\001e\001e\001e\001e\001e\000\000\000~\000\000\000\000\001e\001e\000\000\001e\001e\000\000\001e\002\242\003\026\000\000\000\000\000\000\001u\000\000\000\000\000\000\001u\001\174\000\000\000\000\000\000\000\000\002\250\001\202\000\000\001u\001u\000\000\001u\001u\000\000\000\000\001\162\000\000\001u\000\000\000\000\000\000\001u\000\000\000\000\003\002\000\000\003\018\001u\000\000\001\178\001\182\000\000\000\000\000\000\000\000\000\000\000\000\001\186\000\000\000\000\000\000\000\000\001m\000\000\000\000\001m\000\000\000\000\000\000\000\000\000\000\000\000\000\000\003*\000\000\001u\000\000\000\000\000\000\000\000\000\000\000\000\000\n\000\000\000\000\000\000\001u\000\000\002\242\003\026\000\000\000\000\000\000\001m\000\000\000\000\000\000\001m\000\000\000\000\000\000\000\000\001\206\002\250\000\000\000\000\001m\001m\000\000\001m\001m\000\000\000\000\001u\000\000\001m\001u\001u\000\000\001m\003\n\000\000\003\002\000\000\003\018\001m\000\000\002\197\000\000\000\000\000\000\000\000\000\000\000\000\001u\000\000\000\000\001u\001u\001u\001u\001u\000\000\000\000\000\000\000\000\001u\001u\000\000\001u\001u\001m\001u\001m\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001m\000\000\000R\000V\000Z\000\146\000\000\000\150\000\000\000\154\000\158\000\162\000^\000\000\000\170\000\174\000\000\000v\000\000\000\182\000\000\000\186\001\146\001\150\000z\000\000\000\000\001m\000\000\000\000\001m\001m\000\000\000\000\003\n\000\000\000\000\000\000\000\000\000\000\001\154\001q\000\000\000\000\001q\000\000\001\170\000\000\001m\000\000\000\000\001m\001m\001m\001m\001m\000\000\000~\000\000\000\000\001m\001m\000\000\001m\001m\000\000\001m\002\242\003\026\000\000\000\000\000\000\001q\000\000\000\000\000\000\001q\001\174\000\000\000\000\000\000\000\000\002\250\001\202\000\000\001q\001q\000\000\001q\001q\000\000\000\000\001\162\000\000\001q\000\000\000\000\000\000\001q\000\000\000\000\003\002\000\000\003\018\001q\000\000\001\178\001\182\000\000\000\000\000\000\000\000\000\000\000\000\001\186\000\000\000\000\000\000\000\000\001y\000\000\000\000\001y\000\000\000\000\000\000\000\000\000\000\000\000\000\000\003*\000\000\001q\000\000\000\000\000\000\000\000\000\000\000\000\000\n\000\000\000\000\000\000\001q\000\000\002\242\003\026\000\000\000\000\000\000\001y\000\000\000\000\000\000\001y\000\000\000\000\000\000\000\000\000\000\002\250\000\000\000\000\001y\001y\000\000\001y\001y\000\000\000\000\001q\000\000\001y\001q\001q\000\000\003\"\003\n\000\000\003\002\000\000\003\018\001y\000\000\002\189\000\000\000\000\000\000\000\000\000\000\000\000\001q\000\000\000\000\001q\001q\001q\001q\001q\000\000\000\000\000\000\000\000\001q\001q\000\000\001q\001q\003*\001q\001y\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001y\000\000\000R\000V\000Z\000\146\000\000\000\150\000\000\000\154\000\158\000\162\000^\000\000\000\170\000\174\000\000\000v\000\000\000\182\000\000\000\186\001\146\001\150\000z\000\000\000\000\0032\000\000\000\000\001y\001y\000\000\000\000\003\n\000\000\000\000\000\000\000\000\000\000\001\154\001\129\000\000\000\000\001\129\000\000\000\000\000\000\001y\000\000\000\000\001y\001y\001y\001y\001y\000\000\000~\000\000\000\000\001y\001y\000\000\001y\001y\000\000\001y\002\242\003\026\000\000\000\000\000\000\001\129\000\000\000\000\000\000\001\129\001\158\000\000\000\000\000\000\000\000\002\250\tf\000\000\001\129\001\129\000\000\001\129\001\129\000\000\000\000\001\162\000\000\001\129\000\000\tj\tn\003\"\000\000\000\000\003\002\000\000\003\018\001\129\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\tr\000\000\000\000\000\000\000\000\003\146\000\000\000\000\001}\000\000\000\000\000\000\000\000\000\000\000\000\000\000\003*\000\000\001\129\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\129\000\000\002\242\003\026\000\000\000\000\000\000\001}\000\000\000\000\000\000\001}\000\000\000\000\000\000\000\000\tv\002\250\000\000\000\000\001}\001}\000\000\001}\001}\000\000\000\000\0032\000\000\001}\001\129\001\129\000\000\003\"\003\n\000\000\003\002\000\000\003\018\001}\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\129\000\000\000\000\001\129\001\129\001\129\001\129\001\129\000\000\000\000\000\000\000\000\001\129\001\129\000\000\001\129\003:\003*\001\129\001}\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001}\000\000\000R\000V\000Z\000\146\n\162\000\150\011\026\000\154\000\158\000\162\000^\011\030\000\170\000\174\000\000\000v\000\000\000\182\011\"\000\186\001\146\001\150\000z\011&\000\000\0032\000\000\000\000\001}\001}\000\000\000\000\003\n\000\000\000\000\000\000\000\000\000\000\001\154\003\146\000\000\000\000\001\133\000\000\001\170\000\000\001}\000\000\000\000\001}\001}\001}\001}\001}\000\000\000~\000\000\000\000\001}\001}\000\000\001}\003:\000\000\001}\002\242\003\026\000\000\000\000\000\000\001\133\000\000\000\000\000\000\001\133\001\158\000\000\000\000\000\000\000\000\002\250\tf\000\000\001\133\001\133\000\000\001\133\003\154\000\000\000\000\001\162\000\000\001\133\000\000\tj\tn\003\"\000\000\000\000\003\002\000\000\003\018\001\133\000\000\000\000\000\000\000\000\000\000\000\000\011V\011Z\000\000\tr\000\000\000\000\002\213\000\000\000\000\000\000\000^\002\213\000\000\000f\000\000\000v\002\213\000\000\002\213\003*\000\000\001\133\000z\002\213\002\213\000\000\000\000\000\000\000\n\000\000\000\000\000\000\001\133\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\213\000\000\000\000\000\000\tv\000\000\000\000\000\000\000\000\000\000\000\000\000~\002\213\006\001\011^\0032\002\213\000\000\001\133\001\133\000\000\000\000\003\n\000\000\006\001\000\000\004)\000\000\000\000\006\001\000\000\002\213\002\213\000\000\000\000\000\000\001\133\000\000\000\000\001\133\001\133\001\133\001\133\001\133\002\213\000\000\000\138\000\000\001\133\001\133\000\000\001\133\003:\002\213\001\133\000\000\000\000\002\209\002\213\002\213\000\000\000^\002\209\000\000\000f\000\000\000v\002\209\002\213\002\209\000\000\000\000\002\213\000z\002\209\002\209\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\213\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\213\000\000\002\209\000\000\000\000\002\213\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000~\002\209\000\000\000\000\000\000\002\209\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\209\002\209\000\000\002\230\000\000\002\213\003B\000\000\002\213\002\213\000\000\000\000\002\213\002\209\000\000\000\138\000\000\002\213\002\213\000\000\000\000\000\000\002\209\002\213\000\000\000\000\000\000\002\209\002\209\003r\003z\000\000\000\000\000\000\002=\000\000\000\000\002\209\002=\000\000\000\000\002\209\000\000\000\000\003\130\000\000\000\000\002=\002=\000\000\003\138\003\170\002\209\000\000\000\000\000\000\002=\000\000\000\000\000\000\003\178\000\000\002\209\003\186\000\000\003\194\002=\002\209\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\003\202\000\000\002=\000\000\000\000\000\000\000\000\000\000\002\209\000\000\000\000\002\209\002\209\002=\000\000\002\209\000\000\000\000\000\000\000\000\002\209\002\209\000\000\000\000\000\000\000\000\002\209\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\003\210\000\000\000\000\002=\002=\000\000\000\000\003\218\000\000\000\000\000\000\000\000\000\000\000\000\000\145\000\000\000\000\000\145\000\000\000\000\000\000\002=\000\000\000\000\002=\002=\002=\002=\000\000\000\000\000\000\000\000\000\000\002=\002=\000\000\003\226\003\234\000\000\002=\002\242\003\026\000\000\000\000\000\000\000\145\000\000\000\000\000\000\000\145\000\000\000\000\000\000\000\000\000\000\002\250\000\000\000\000\000\145\000\145\000\000\000\145\000\145\000\000\000\000\000\000\000\000\000\145\000\000\000\000\000\000\003\"\000\000\000\000\003\002\000\000\003\018\000\145\000\000\000\000\000\000\000\000\000y\000\000\000\000\000y\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\003*\000\000\000\145\000\000\000\000\000y\000y\000\000\000\000\000\000\000y\000\000\000\000\000\145\000y\000\000\000\000\000\000\000\000\000\000\002\250\000\000\000\000\000y\000y\000\000\000y\000y\000\000\000\000\000\000\000\000\000y\000\000\000\000\000\000\000y\000\000\000\000\003\002\0032\003\018\000y\000\145\000\145\000\000\000\000\003\n\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000u\000\000\000\000\000u\000\145\000\000\000\000\000\145\000\145\000\145\000\145\000y\000\000\000y\000\000\000\000\000\145\000\145\000\000\000\145\003:\000\000\000\145\000\000\000y\000\000\000u\000u\000\000\000\000\000\000\000u\000\000\000\000\000\000\000u\000\000\000\000\000\000\000\000\000\000\002\250\000\000\000\000\000u\000u\000\000\000u\000u\000\000\000\000\000y\000\000\000u\000y\000y\000\000\000u\003\n\000\000\003\002\000\000\003\018\000u\000\000\000\000\000\000\000\000\000m\000\000\000\000\000m\000y\000\000\000\000\000y\000y\000y\000y\000\000\000\000\000\000\000\000\000\000\000y\000y\000\000\000y\000y\000u\000y\000u\000\000\000\000\000m\000m\000\000\000\000\000\000\000m\000\000\000\000\000u\000m\000\000\000\000\000\000\000\000\000\000\000m\000\000\000\000\000m\000m\000\000\000m\000m\000\000\000\000\000\000\000\000\000m\000\000\000\000\000\000\000m\000\000\000\000\003\002\000u\000m\000m\000u\000u\000\000\000\000\003\n\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\003\146\000\000\000\000\000\153\000u\000\000\000\000\000u\000u\000u\000u\000m\000\000\000m\000\000\000\000\000u\000u\000\000\000u\000u\000\000\000u\000\000\000m\000\000\002\242\003\026\000\000\000\000\000\000\000\153\000\000\000\000\000\000\000\153\000\000\000\000\000\000\000\000\000\000\002\250\000\000\000\000\000\153\000\153\000\000\000\153\003\154\000\000\000\000\000m\000\000\000\153\000m\000m\000\000\003\"\003\n\000\000\003\002\000\000\003\018\000\153\000\000\000\000\000\000\000\000\003\146\000\000\000\000\000\141\000m\000\000\000\000\000m\000m\000m\000m\000\000\000\000\000\000\000\000\000\000\000m\000m\000\000\000m\000m\003*\000m\000\153\000\000\000\000\002\242\003\026\000\000\000\000\000\000\000\141\000\000\000\000\000\153\000\141\000\000\000\000\000\000\000\000\000\000\002\250\000\000\000\000\000\141\000\141\000\000\000\141\000\141\000\000\000\000\000\000\000\000\000\141\000\000\000\000\000\000\003\"\000\000\000\000\003\002\0032\003\018\000\141\000\153\000\153\000\000\000\000\003\n\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\133\000\000\000\000\000\133\000\153\000\000\000\000\000\153\000\153\000\153\000\153\003*\000\000\000\141\000\000\000\000\000\153\000\153\000\000\003\162\003:\000\000\000\153\000\000\000\141\000\000\002\242\003\026\000\000\000\000\000\000\000\133\000\000\000\000\000\000\000\133\000\000\000\000\000\000\000\000\000\000\002\250\000\000\000\000\000\133\000\133\000\000\000\133\000\133\000\000\000\000\0032\000\000\000\133\000\141\000\141\000\000\000\133\003\n\000\000\003\002\000\000\003\018\000\133\000\000\000\000\000\000\000\000\000q\000\000\000\000\000q\000\141\000\000\000\000\000\141\000\141\000\141\000\141\000\000\000\000\000\000\000\000\000\000\000\141\000\141\000\000\000\141\003:\003*\000\141\000\133\000\000\000\000\000q\000q\000\000\000\000\000\000\000q\000\000\000\000\000\133\000q\000\000\000\000\000\000\000\000\000\000\000q\000\000\000\000\000q\000q\000\000\000q\000q\000\000\000\000\000\000\000\000\000q\000\000\000\000\000\000\000q\000\000\000\000\003\002\000\133\000q\000q\000\133\000\133\000\000\000\000\003\n\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000}\000\000\000\000\000}\000\133\000\000\000\000\000\133\000\133\000\133\000\133\000q\000\000\000q\000\000\000\000\000\133\000\133\000\000\000\133\000\133\000\000\000\133\000\000\000q\000\000\002\242\003\026\000\000\000\000\000\000\000}\000\000\000\000\000\000\000}\000\000\000\000\000\000\000\000\000\000\002\250\000\000\000\000\000}\000}\000\000\000}\000}\000\000\000\000\000q\000\000\000}\000q\000q\000\000\000}\003\n\000\000\003\002\000\000\003\018\000}\000\000\000\000\000\000\000\000\000\129\000\000\000\000\000\129\000q\000\000\000\000\000q\000q\000q\000q\000\000\000\000\000\000\000\000\000\000\000q\000q\000\000\000q\000q\000}\000q\000}\000\000\000\000\002\242\003\026\000\000\000\000\000\000\000\129\000\000\000\000\000}\000\129\000\000\000\000\000\000\000\000\000\000\002\250\000\000\000\000\000\129\000\129\000\000\000\129\000\129\000\000\000\000\000\000\000\000\000\129\000\000\000\000\000\000\000\129\000\000\000\000\003\002\000}\003\018\000\129\000}\000}\000\000\000\000\003\n\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\003\146\000\000\000\000\000\149\000}\000\000\000\000\000}\000}\000}\000}\003*\000\000\000\129\000\000\000\000\000}\000}\000\000\000}\000}\000\000\000}\000\000\000\129\000\000\002\242\003\026\000\000\000\000\000\000\000\149\000\000\000\000\000\000\000\149\000\000\000\000\000\000\000\000\000\000\002\250\000\000\000\000\000\149\000\149\000\000\000\149\003\154\000\000\000\000\000\129\000\000\000\149\000\129\000\129\000\000\003\"\003\n\000\000\003\002\000\000\003\018\000\149\000\000\000\000\000\000\000\000\000\137\000\000\000\000\000\137\000\129\000\000\000\000\000\129\000\129\000\129\000\129\000\000\000\000\000\000\000\000\000\000\000\129\000\129\000\000\000\129\000\129\003*\000\129\000\149\000\000\000\000\002\242\003\026\000\000\000\000\000\000\000\137\000\000\000\000\000\149\000\137\000\000\000\000\000\000\000\000\000\000\002\250\000\000\000\000\000\137\000\137\000\000\000\137\000\137\000\000\000\000\000\000\000\000\000\137\000\000\000\000\000\000\003\"\000\000\000\000\003\002\0032\003\018\000\137\000\149\000\149\000\000\000\000\003\n\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\149\000\000\000\000\000\149\000\149\000\149\000\149\003*\000\000\000\137\000\000\000\000\000\149\000\149\000\000\000\149\003:\000\000\000\149\000\000\000\137\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\r\189\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\r\189\0032\000\000\000\000\000\137\000\137\000\000\000\000\003\n\000\000\000\000\r\189\000\000\r\189\012\r\012\r\000\000\r\189\000\000\000\000\012\r\000\000\000\137\r\189\000\173\000\137\000\137\000\137\000\137\r\189\000\000\000\000\r\189\000\000\000\137\000\137\r\189\000\137\000\137\000\000\000\137\000\000\r\189\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\173\000\173\000\000\r\189\000\000\000\000\012\r\000\000\r\189\r\189\000\000\000\000\000\000\000\000\000\000\000\173\000\000\000\000\000\000\000\000\000\000\000\173\000\173\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\173\000\000\000\000\003\002\000\000\000\173\012\r\000\000\r\189\000\000\000\000\r\189\000\000\000\000\000\000\001\242\000\000\000\190\000\000\000\000\001\246\000\000\000\000\001\250\r\189\000\000\000\000\000\000\000\000\r\189\r\189\r\189\000\173\r\189\r\189\000\000\r\189\000\000\000\000\002\002\000\000\000\000\002\006\r\189\000\000\000\000\r\189\000\000\002\018\002\022\000\000\002\030\000\000\007\030\000\000\000\000\000\000\000\000\002&\000\000\002*\r\189\000\000\000\000\000\000\000\000\r\189\r\189\012\r\002.\0022\000\000\000\173\br\0026\001\"\002:\000\000\000\000\003\n\002>\002B\000\000\000\000\002F\002J\000\000\000\000\000\000\000\000\000\000\015y\000\000\000\173\015y\000\000\000\000\000\000\000\000\000\000\000\173\000\000\002N\000\000\000\000\000\000\000\000\002R\000\173\000\173\000\n\000\000\000\000\000\000\000\000\000\000\000\000\015y\015y\002Z\000\000\000\000\015y\000\000\000\000\000\000\015y\000\000\000\000\000\000\002^\t\253\015y\000\000\000\000\015y\015y\000\000\015y\015y\000\000\000\000\000\000\002b\015y\000\000\004\198\000\000\015y\002n\000\000\015y\t\253\015y\015y\000\000\000\000\000\000\002\134\000\000\000\000\000\000\000\000\002v\002~\000\000\000\000\000\000\000\000\000\000\000\000\001\242\000\000\000\190\000\000\000\000\001\246\000\000\000\000\001\250\015y\000\000\015y\000\000\000\000\000\000\000\000\000\000\000\000\012b\000\000\000\000\000\000\015y\000\000\002\002\000\000\000\000\002\006\000\000\000\000\000\000\000\000\000\000\002\018\002\022\000\000\002\030\000\000\004\198\000\000\000\000\000\000\000\000\002&\000\000\002*\000\000\000\000\000\000\015y\015y\000\000\015y\000\000\002.\0022\015y\000\000\000\000\0026\001\"\002:\000\000\000\000\000\000\002>\002B\000\000\000\000\002F\002J\000\000\000\000\015y\000\000\015y\000\000\000\000\000\000\000\000\000\000\015y\015y\015y\000\000\015y\015y\002N\015y\000\000\000\000\000\000\002R\000\000\000\000\000\n\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002Z\000\000\001\249\000\000\000\000\001\249\000\000\000\000\000\000\000\000\000\000\002^\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002b\000\000\000\000\000\000\001\249\001\249\002n\000\000\000\000\001\249\000\000\t\253\000\000\001\249\000\000\002\134\000\000\000\000\000\000\001\249\002v\002~\001\249\001\249\000\000\001\249\001\249\000\000\000\000\000\000\000\000\001\249\000\000\000\000\000\000\001\249\000\000\000\000\001\249\000\000\001\249\001\249\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\242\000\000\000\190\000\000\000\000\001\246\000\000\000\000\001\250\001\249\000\000\001\249\000\000\000\000\000\000\000\000\000\000\000\000\t\253\000\000\000\000\000\000\001\249\000\000\002\002\000\000\000\000\002\006\000\000\000\000\000\000\000\000\000\000\002\018\002\022\000\000\002\030\000\000\000\000\000\000\000\000\000\000\000\000\002&\000\000\002*\000\000\000\000\000\000\001\249\rJ\000\000\001\249\000\000\002.\0022\001\249\000\000\000\000\0026\001\"\002:\000\000\000\000\000\000\002>\002B\000\000\000\000\002F\002J\000\000\000\000\001\249\000\000\001\249\000\000\000\000\000\000\000\000\000\000\rR\001\249\001\249\000\000\001\249\001\249\002N\001\249\000\000\000\000\000\000\002R\000\000\000\000\000\n\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002Z\000\000\000\000\000\000\001\242\000\000\000\190\000\000\000\000\001\246\000\000\002^\001\250\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\018\202\000\000\002b\000\000\000\000\000\000\002\002\000\000\002n\002\006\000\000\000\000\000\000\000\000\000\000\002\018\002\022\002\134\002\030\000\000\000\000\000\000\002v\002~\000\000\002&\000\000\002*\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002.\0022\000\000\000\000\000\000\0026\001\"\002:\000\000\000\000\000\000\002>\002B\000\000\000\000\002F\002J\000\000\000\000\000\000\000\000\000\000\001\242\000\000\000\190\000\000\000\000\001\246\000\000\000\000\001\254\000\000\000\000\002N\000\000\000\000\000\000\000\000\002R\000\000\000\000\000\n\000\000\000\000\000\000\000\000\002\002\000\000\000\000\002\006\002Z\000\000\000\000\000\000\000\000\002\018\t\030\000\000\002\030\000\000\000\000\002^\000\000\000\000\000\000\002&\000\000\002*\000\000\000\000\000\000\000\000\000\000\000\000\002b\000\000\002.\0022\000\000\000\000\002n\0026\001\"\002:\000\000\000\000\000\000\002>\002B\002\134\000\000\002F\002J\000\000\002v\002~\000\000\000\000\001\242\000\000\000\190\000\000\000\000\001\246\000\000\000\000\001\254\000\000\000\000\002N\000\000\000\000\000\000\000\000\002f\000\000\000\000\000\n\000\000\000\000\000\000\000\000\002\002\000\000\000\000\002\006\002Z\000\000\000\000\000\000\000\000\002\018\t\014\000\000\002\030\000\000\000\000\002^\000\000\000\000\000\000\002&\000\000\002*\000\000\000\000\000\000\000\000\000\000\000\000\002j\000\000\002.\0022\000\000\000\000\002n\0026\001\"\002:\000\000\000\000\000\000\002>\002B\002r\000\000\002F\002J\000\000\002v\002~\000\000\000\000\001\242\000\000\000\190\000\000\000\000\001\246\000\000\000\000\001\254\000\000\000\000\002N\000\000\000\000\000\000\000\000\002f\000\000\000\000\000\n\000\000\000\000\000\000\000\000\002\002\000\000\000\000\002\006\002Z\000\000\000\000\000\000\000\000\002\018\b\246\000\000\002\030\000\000\000\000\002^\000\000\000\000\000\000\002&\000\000\002*\000\000\000\000\000\000\000\000\000\000\000\000\002j\000\000\002.\0022\000\000\000\000\002n\0026\001\"\002:\000\000\000\000\000\000\002>\002B\002r\000\000\002F\002J\000\000\002v\002~\000\000\000\000\001\242\000\000\000\190\000\000\000\000\001\246\000\000\000\000\001\254\000\000\000\000\002N\000\000\000\000\000\000\000\000\002f\000\000\000\000\000\n\000\000\000\000\000\000\000\000\002\002\000\000\000\000\002\006\002Z\000\000\000\000\000\000\000\000\002\018\002V\000\000\002\030\000\000\000\000\002^\000\000\000\000\000\000\002&\000\000\002*\000\000\000\000\000\000\000\000\000\000\000\000\002j\000\000\002.\0022\000\000\000\000\002n\0026\001\"\002:\000\000\000\000\000\000\002>\002B\002r\000\000\002F\002J\000\000\002v\002~\000\000\000R\000\000\000\000\000\000\000\000\000\000\007\245\000\000\000\000\000\000\000\000\007\245\002N\000\000\000\000\000\000\007\245\002f\007\245\000\000\000\n\001\150\000\000\007\245\007\245\000\000\000\000\000\000\000\000\002Z\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002^\000\000\000\000\000\000\007\245\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002j\000\000\000\000\007\245\000\000\000\000\002n\007\245\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002r\000\000\000\000\000\000\000\000\002v\002~\007\245\007\245\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\007\245\000\000\000\000\007\245\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\007\245\000\000\000\000\000\000\000\000\007\245\007\245\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\007\245\000\000\000\000\000\000\007\245\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\007\245\000\000\000\000\000\000\001\242\000\000\000\190\000\000\000\000\002\n\007\245\000\000\002\014\000\000\000\000\007\245\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\002\000\000\000\000\002\006\000\000\000\000\000\000\000\000\000\000\002\"\004\146\000\000\002\030\000\000\004\166\000\000\000\000\000\000\000\000\002&\007\245\002*\000\000\007\245\007\245\000\000\000\000\007\245\000\000\000\000\004\206\0022\007\245\007\245\000\000\004\210\001\"\002:\007\245\000\000\000\000\004\214\004\218\000\000\000\000\004\222\002J\000\000\001\242\000\000\000\190\000\000\000\000\001\246\000\000\000\000\001\254\000\000\000\000\000\000\000\000\000\000\000\000\004\226\000\000\000\000\000\000\000\000\004\230\000\000\000\000\000\n\002\002\000\000\000\000\002\006\000\000\000\000\000\000\000\000\004\238\002\018\004\178\000\000\002\030\000\000\000\000\000\000\000\000\000\000\000\000\002&\000\000\002*\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002.\0022\004\242\000\000\000\000\0026\001\"\002:\004\250\000\000\000\000\002>\002B\000\000\000\000\002F\002J\004\254\000\000\000\000\000\000\000\000\005\006\002~\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002N\000\000\000\000\000\000\000\000\002f\000\000\000\000\000\n\000\000\000\000\006j\000\000\000\000\000\000\000\000\000\000\002Z\000\000\000\000\000\000\003\225\000\000\003\225\000\000\000\000\003\225\000\000\002^\003\225\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002j\000\000\000\000\000\000\003\225\000\000\002n\003\225\000\000\000\000\000\000\000\000\000\000\003\225\003\225\002r\003\225\000\000\000\000\000\000\002v\002~\000\000\003\225\000\000\003\225\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\003\225\003\225\000\000\000\000\000\000\003\225\003\225\003\225\000\000\000\000\000\000\003\225\003\225\000\000\000\000\003\225\003\225\000\000\001\242\000\000\000\190\000\000\000\000\001\246\000\000\000\000\001\254\000\000\000\000\000\000\000\000\000\000\000\000\003\225\000\000\000\000\000\000\000\000\003\225\000\000\000\000\003\225\002\002\000\000\000\000\002\006\000\000\000\000\000\000\000\000\003\225\002\018\012N\000\000\002\030\000\000\000\000\000\000\000\000\000\000\000\000\002&\000\000\002*\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002.\0022\003\225\000\000\000\000\0026\001\"\002:\003\225\000\000\000\000\002>\002B\000\000\000\000\002F\002J\003\225\000\000\000\000\000\000\000\000\003\225\003\225\000\000\000\000\000\000\000\000\020v\000\000\000\000\000\000\000\000\002N\000\000\000\000\000\000\000\000\002f\000\000\020z\000\n\000\000\000\000\000\000\000\000\000\000\022\006\000\000\000\000\002Z\020~\000\000\020\130\012a\012a\000\000\020\134\000\000\000\000\000\000\002^\000\000\020\138\000\000\000\000\000\000\000\000\000\000\020\142\000\000\000\000\020\150\000\185\002j\000\000\020\154\000\000\000\000\000\000\002n\000\000\020\158\000\000\000\000\000\000\000\000\000\000\000\000\002r\000\000\000\000\000\000\020v\002v\002~\012a\000\000\020\162\002\242\003\026\000\000\000\000\000\000\000\000\020z\000\000\000\000\000\000\000\000\000\000\000\000\023\006\000\000\002\250\000\000\020~\000\000\020\130\000\000\000\185\000\185\020\134\000\000\000\000\0125\000\000\012a\020\138\020\166\000\185\000\000\020\170\003\002\020\142\003\018\000\000\020\150\000\000\000\000\000\000\020\154\000\000\022\018\000\000\020\174\000\000\020\158\000\000\000\000\020\178\000\n\020\182\000\000\020\186\020\190\000\000\020\194\023\130\022\150\000\000\0125\000\185\020\162\020\198\000\000\000\000\020\202\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\020\206\000\000\000\000\000\000\000\000\020\210\020\214\012a\000\000\000\000\0125\000\000\020\166\000\000\000\000\020\170\000\000\000\000\000\000\000\000\000\185\000\000\000\000\000\000\000\000\000\000\000\000\003\n\020\174\000\000\000\000\000\000\000\000\020\178\000\n\020\182\000\000\020\186\020\190\000\000\020\194\000\185\000\000\000\000\000\000\000\000\000\000\020\198\000\185\000\000\020\202\000\000\000\000\000\000\000\000\000\000\000\185\000\185\000\000\000\000\000\000\000\000\000\000\000\000\000\000\020\206\000\000\000\000\000\000\000\000\020\210\020\214\0125\003\249\003\249\003\249\003\249\000\000\003\249\000\000\003\249\003\249\003\249\003\249\000\000\003\249\003\249\000\000\003\249\000\000\003\249\000\000\003\249\003\249\003\249\003\249\000\000\000\000\r~\000\000\000\000\r\134\000\000\000\000\000\000\001\210\000\000\000\000\000\000\000\000\000\000\003\249\000\000\000\000\000\000\000\000\000\000\003\249\000\000\000\000\000\000\000\000\000\000\000\000\r\150\r\158\000\000\000\000\003\249\002M\000\000\000\000\000\000\002M\000\000\000\000\000\000\000\000\000\000\r\166\000\000\000\000\002M\002M\000\000\r\174\r\182\000\000\003\249\000\000\000\000\002M\000\000\000\000\003\249\r\190\000\000\000\000\r\198\000\000\r\206\002M\000\000\003\249\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001E\003\249\003\249\001E\000\000\000\000\000\000\000\000\000\000\003\249\000\000\r\214\000\000\002M\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002M\000\000\002\242\003\026\000\000\000\000\000\000\001E\000\000\000\000\003\249\001E\000\000\000\000\000\000\000\000\000\000\002\250\000\000\000\000\001E\001E\000\000\001E\001E\000\000\000\000\r\222\000\000\001E\002M\000\000\000\000\003\"\r\230\000\000\003\002\000\000\003\018\001E\000\000\000\000\000\000\000\000\001-\000\000\000\000\001-\000\000\000\000\000\000\002M\000\000\002M\000\000\003\249\000\000\000\000\000\000\000\000\002M\002M\000\000\r\238\r\246\003*\002M\001E\000\000\000\000\001-\001-\000\000\000\000\000\000\001-\000\000\000\000\001E\001-\000\000\000\000\000\000\000\000\000\000\002\250\000\000\000\000\001-\001-\000\000\001-\001-\000\000\000\000\000\000\000\000\001-\000\000\000\000\000\000\001-\000\000\000\000\003\002\0032\003\018\001-\001E\000\000\000\000\000\000\003\n\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001)\000\000\000\000\001)\000\000\000\000\000\000\001E\000\000\001E\000\000\001-\000\000\001-\000\000\000\000\001E\001E\000\000\001E\003:\000\000\001E\000\000\001-\000\000\001)\001)\000\000\000\000\000\000\001)\000\000\000\000\000\000\001)\000\000\000\000\000\000\000\000\000\000\002\250\000\000\000\000\001)\001)\000\000\001)\001)\000\000\000\000\001-\000\000\001)\001-\000\000\000\000\001)\003\n\000\000\003\002\000\000\003\018\001)\000\000\000\000\000\000\000\000\001!\000\000\000\000\001!\000\000\000\000\000\000\001-\000\000\001-\000\000\000\000\000\000\000\000\000\000\000\000\001-\001-\000\000\001-\001-\001)\001-\001)\000\000\000\000\001!\001!\000\000\000\000\000\000\001!\000\000\000\000\001)\001!\000\000\000\000\000\000\000\000\000\000\001!\000\000\000\000\001!\001!\000\000\001!\001!\000\000\000\000\000\000\000\000\001!\000\000\000\000\000\000\001!\000\000\000\000\003\002\001)\001!\001!\001)\000\000\000\000\000\000\003\n\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\003\146\000\000\000\000\001M\000\000\000\000\000\000\001)\000\000\001)\000\000\001!\000\000\001!\000\000\000\000\001)\001)\000\000\001)\001)\000\000\001)\000\000\001!\000\000\002\242\003\026\000\000\000\000\000\000\001M\000\000\000\000\000\000\001M\000\000\000\000\000\000\000\000\000\000\002\250\000\000\000\000\001M\001M\000\000\001M\003\154\000\000\000\000\001!\000\000\001M\001!\000\000\000\000\003\"\003\n\000\000\003\002\000\000\003\018\001M\000\000\000\000\000\000\000\000\003\146\000\000\000\000\001A\000\000\000\000\000\000\001!\000\000\001!\000\000\000\000\000\000\000\000\000\000\000\000\001!\001!\000\000\001!\001!\003*\001!\001M\000\000\000\000\002\242\003\026\000\000\000\000\000\000\001A\000\000\000\000\001M\001A\000\000\000\000\000\000\000\000\000\000\002\250\000\000\000\000\001A\001A\000\000\001A\001A\000\000\000\000\000\000\000\000\001A\000\000\000\000\000\000\003\"\000\000\000\000\003\002\0032\003\018\001A\001M\000\000\000\000\000\000\003\n\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\0019\000\000\000\000\0019\000\000\000\000\000\000\001M\000\000\001M\000\000\003*\000\000\001A\000\000\000\000\001M\001M\000\000\003\162\003:\000\000\001M\000\000\001A\000\000\002\242\003\026\000\000\000\000\000\000\0019\000\000\000\000\000\000\0019\000\000\000\000\000\000\000\000\000\000\002\250\000\000\000\000\0019\0019\000\000\0019\0019\000\000\000\000\0032\000\000\0019\001A\000\000\000\000\0019\003\n\000\000\003\002\000\000\003\018\0019\000\000\000\000\000\000\000\000\001%\000\000\000\000\001%\000\000\000\000\000\000\001A\000\000\001A\000\000\000\000\000\000\000\000\000\000\000\000\001A\001A\000\000\001A\003:\003*\001A\0019\000\000\000\000\001%\001%\000\000\000\000\000\000\001%\000\000\000\000\0019\001%\000\000\000\000\000\000\000\000\000\000\001%\000\000\000\000\001%\001%\000\000\001%\001%\000\000\000\000\000\000\000\000\001%\000\000\000\000\000\000\001%\000\000\000\000\003\002\0019\001%\001%\0019\000\000\000\000\000\000\003\n\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\0011\000\000\000\000\0011\000\000\000\000\000\000\0019\000\000\0019\000\000\001%\000\000\001%\000\000\000\000\0019\0019\000\000\0019\0019\000\000\0019\000\000\001%\000\000\002\242\003\026\000\000\000\000\000\000\0011\000\000\000\000\000\000\0011\000\000\000\000\000\000\000\000\000\000\002\250\000\000\000\000\0011\0011\000\000\0011\0011\000\000\000\000\001%\000\000\0011\001%\000\000\000\000\0011\003\n\000\000\003\002\000\000\003\018\0011\000\000\000\000\000\000\000\000\0015\000\000\000\000\0015\000\000\000\000\000\000\001%\000\000\001%\000\000\000\000\000\000\000\000\000\000\000\000\001%\001%\000\000\001%\001%\0011\001%\0011\000\000\000\000\002\242\003\026\000\000\000\000\000\000\0015\000\000\000\000\0011\0015\000\000\000\000\000\000\000\000\000\000\002\250\000\000\000\000\0015\0015\000\000\0015\0015\000\000\000\000\000\000\000\000\0015\000\000\000\000\000\000\0015\000\000\000\000\003\002\0011\003\018\0015\0011\000\000\000\000\000\000\003\n\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\003\146\000\000\000\000\001I\000\000\000\000\000\000\0011\000\000\0011\000\000\003*\000\000\0015\000\000\000\000\0011\0011\000\000\0011\0011\000\000\0011\000\000\0015\000\000\002\242\003\026\000\000\000\000\000\000\001I\000\000\000\000\000\000\001I\000\000\000\000\000\000\000\000\000\000\002\250\000\000\000\000\001I\001I\000\000\001I\003\154\000\000\000\000\0015\000\000\001I\0015\000\000\000\000\003\"\003\n\000\000\003\002\000\000\003\018\001I\000\000\000\000\000\000\000\000\001=\000\000\000\000\001=\000\000\000\000\000\000\0015\000\000\0015\000\000\000\000\000\000\000\000\000\000\000\000\0015\0015\000\000\0015\0015\003*\0015\001I\000\000\000\000\002\242\003\026\000\000\000\000\000\000\001=\000\000\000\000\001I\001=\000\000\000\000\000\000\000\000\000\000\002\250\000\000\000\000\001=\001=\000\000\001=\001=\000\000\000\000\000\000\000\000\001=\000\000\000\000\000\000\003\"\000\000\000\000\003\002\0032\003\018\001=\001I\023n\000\000\023v\003\n\000\000\000\000\000\000\000\000\000\000\000\000\000\000\023~\000\000\000\000\000\000\000\000\023\158\000\000\000\000\000\000\001I\000\000\001I\020z\003*\000\000\001=\000\000\000\000\001I\001I\000\000\001I\003:\020~\001I\020\130\001=\000\000\000\000\020\134\000\000\000\000\000\000\000\000\000\000\020\138\000\000\000\000\000\000\000\000\000\000\020\142\000\000\000\000\020\150\000\000\000\000\000\000\020\154\000\000\000\000\000\000\000\000\0032\020\158\000\000\001=\000\000\000\000\000\000\003\n\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\020\162\023\166\000\000\000\000\000\000\000\000\000\000\001=\000\000\001=\000\000\000\000\000\000\000\000\000\000\000\000\001=\001=\000\000\001=\001=\000\000\001=\006A\000\000\000\000\000\000\000\000\006A\000\000\000\000\020\166\000\000\006A\020\170\006A\000\000\000\000\000\000\000\000\006A\006A\000\000\000\000\000\000\000\000\000\000\020\174\000\000\000\000\000\000\000\000\020\178\000\n\020\182\000\000\020\186\020\190\000\000\020\194\000\000\006A\000\000\000\000\000\000\000\000\020\198\000\000\000\000\020\202\000\000\000\000\000\000\006A\000\000\000\000\000\000\006A\000\000\000\000\000\000\000\000\000\000\000\000\020\206\000\000\000\000\000\000\000\000\020\210\020\214\015E\006A\006A\015E\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004j\000\000\000\000\006A\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\006A\000\000\000\000\015E\015E\006A\006A\000\000\000\000\000\000\000\000\005\030\000\000\000\000\000\000\006A\000\000\000\000\015E\006A\000\000\000\000\015E\000\000\015E\015E\000\000\000\000\005&\000\000\006A\006*\000\000\000\000\015E\000\000\000\000\015E\000\000\015E\006A\000\000\000\000\000\000\000\000\006A\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\242\000\000\000\190\000\000\000\000\004\170\015E\000\000\004\174\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\006A\000\000\000\000\006A\006A\000\000\002\002\006A\0066\000\000\000\000\000\000\006A\006A\000\000\006\142\006\154\000\000\006A\000\000\006\174\000\000\000\000\000\000\000\000\002&\000\000\002*\015E\015E\000\000\015E\000\000\006:\000\000\015E\006\222\0022\000\000\000\000\000\000\006\234\001\"\002:\006B\000\000\000\000\006\242\006\246\015E\000\000\006\250\000\000\015E\015E\000\000\000\000\000\000\000\000\000\000\015E\000\000\000\000\000\000\015E\015E\000\000\000\000\006\254\007\002\000\000\000\000\000\000\000\000\007\006\000\000\000\000\000\n\000\000\001\242\000\000\000\190\000\000\000\000\012F\000\000\007\014\012J\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\002\000\000\000\000\000\000\000\000\000\000\000\000\007*\000\000\012\182\012\162\000\000\000\000\0072\r\254\000\000\000\000\000\000\000\000\002&\000\000\002*\0076\000\000\000\000\000\000\000\000\007>\002~\000\000\012\186\0022\000\000\000\000\000\000\012\190\001\"\002:\000\000\000\000\000\000\012\194\012\198\000\000\020v\012\202\000\000\000\000\000\000\000\000\000\000\000\000\020v\000\000\000\000\000\000\020z\000\000\000\000\000\000\000\000\000\000\006\254\012\206\020z\000\000\000\000\020~\012\210\020\130\000\000\000\n\000\000\020\134\000\000\020~\000\000\020\130\000\000\020\138\012\218\020\134\000\000\000\000\000\000\020\142\000\000\020\138\020\150\000\000\000\000\000\000\020\154\020\142\000\000\000\000\020\150\000\000\020\158\000\000\020\154\000\000\000\000\000\000\012\222\000\000\020\158\000\000\000\000\022\002\012\230\000\000\000\000\000\000\020\162\000\000\000\000\022\222\000\000\012\234\000\000\000\000\020\162\000\000\012\242\002~\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\0125\000\000\020\166\000\000\000\000\020\170\000\000\000\000\0125\000\000\020\166\000\000\000\000\020\170\000\000\000\000\000\000\000\000\020\174\000\000\000\000\000\000\000\000\020\178\000\n\020\182\020\174\020\186\020\190\000\000\020\194\020\178\000\n\020\182\000\000\020\186\020\190\020\198\020\194\000\000\020\202\000\000\020v\000\000\000\000\020\198\000\000\000\000\020\202\000\000\000\000\000\000\000\000\000\000\020z\020\206\000\000\000\000\000\000\000\000\020\210\020\214\0125\020\206\000\000\020~\000\000\020\130\020\210\020\214\0125\020\134\000\000\000\000\000\000\000\000\000\000\020\138\000\000\000\000\000\000\000\000\000\000\020\142\000\000\000\000\020\150\000\000\000\000\000\000\020\154\000\000\000\000\000\000\000\000\000\000\020\158\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\023F\000\000\000\000\000\000\000\000\020\162\000\000\000\000\000\000\000\000\000R\000V\000Z\000\146\000\000\000\150\000\000\000\154\000\158\000\162\000^\000\000\000\170\000\174\000\000\000v\000\000\000\182\000\000\000\186\001\146\001\150\000z\000\000\0125\000\000\020\166\000\000\000\000\020\170\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\154\000\000\000\000\000\000\020\174\000\000\000\000\000\000\000\000\020\178\000\n\020\182\000\000\020\186\020\190\000\000\020\194\000~\000\000\000\000\000\000\000\000\000\000\020\198\000\000\000\000\020\202\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\158\000\000\000\000\000\000\020\206\000\000\tf\000\000\000\000\020\210\020\214\0125\000\000\000\000\000\000\001\162\000\000\000\000\000\000\tj\tn\000R\000V\000Z\000\146\000\000\000\150\000\000\000\154\000\158\000\162\000^\000\000\000\170\000\174\000\000\000v\tr\000\182\000\000\000\186\001\146\001\150\000z\000\000\000R\000V\000Z\000\146\000\000\000\150\000\000\000\154\000\158\000\162\000^\000\000\000\170\000\174\001\154\000v\000\000\000\182\000\000\000\186\001\146\001\150\000z\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000~\000\000\000\000\000\000\000\000\000\000\tv\001\154\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\158\000\000\000\000\000\000\000~\000\000\tf\000\000\tI\000\000\000\000\000\000\000\000\000\000\000\000\001\162\000\000\000\000\000\000\tj\tn\000\000\000\000\000\000\001\158\000\000\000\000\000\000\000\000\000\000\026\"\000\000\000\000\000\000\000\000\000\000\000\000\tr\000\000\001\162\000\000\000\000\000\000\026&\tn\000R\000V\000Z\000\146\000\000\000\150\000\000\000\154\000\158\000\162\000^\000\000\000\170\000\174\000\000\000v\tr\000\182\000\000\000\186\001\146\001\150\000z\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\tv\001\154\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000~\000\000\000\000\000\000\002\177\000\000\026*\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\158\000\000\000\000\000\000\000\000\000\000\026\"\000\000\004!\000\000\000\000\000\000\000\000\000\000\000\000\001\162\000\000\000\000\000\000\026&\tn\000R\000V\000Z\000\146\000\000\000\150\000\000\000\154\000\158\000\162\000^\000\000\000\170\000\174\000\000\000v\tr\000\182\000\000\000\186\001\146\001\150\000z\000\000\000R\000V\000Z\000\146\000\000\000\150\000\000\000\154\000\158\000\162\000^\000\000\000\170\000\174\001\154\000v\000\000\000\182\000\000\000\186\001\146\001\150\000z\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000~\000\000\000\000\000\000\000\000\000\000\026*\001\154\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\158\000\000\000\000\000\000\000~\000\000\026\"\000\000\t-\000\000\000\000\000\000\000\000\000\000\000\000\001\162\000\000\000\000\000\000\026&\tn\000\000\t\245\000\000\001\158\000\000\000\000\000\000\000\000\000\000\t~\000\000\000\000\000\000\t\245\000\000\000\000\tr\000\000\001\162\000\000\000\000\000\000\tj\tn\t\245\000\000\t\245\000\000\000\000\000\000\t\245\000\000\000\000\000\000\000\000\000\000\t\245\000\000\000\000\000\000\tr\b\177\t\245\000\000\000\000\t\245\000\000\000\000\000\000\t\245\021^\000\000\000\000\b\177\000\000\t\245\000\000\000\000\000\000\000\000\000\000\026*\000\000\000\000\b\177\000\000\b\177\000\000\000\000\000\000\b\177\t\245\000\000\000\000\000\000\000\000\b\177\000\000\000\000\000\000\000\000\000\000\b\177\002\161\000\000\b\177\000\000\000\000\000\000\b\177\000\000\000\000\000\000\000\000\000\000\b\177\000\000\000\000\000\000\000\000\000\000\000\000\t\245\000\000\000\000\t\245\000\000\tY\000\000\000\000\000\000\b\177\023\166\000\000\000\000\000\000\000\000\000\000\t\245\000\000\000\000\000\000\000\000\t\245\t\245\t\245\000\000\t\245\t\245\000\000\t\245\000\000\000\000\000\000\000\000\000\000\000\000\t\245\000\000\000\000\t\245\000\000\b\177\000\000\000\000\b\177\000\000\000\000\000\000\000\000\006\229\000\000\000\000\000\000\000\000\t\245\000\000\000\000\b\177\000\000\t\245\t\245\006\229\b\177\b\177\b\177\000\000\b\177\b\177\000\000\b\177\000\000\000\000\006\229\000\000\006\229\000\000\b\177\000\000\006\229\b\177\000\000\000\000\000\000\000\000\006\229\000\000\000\000\000\000\000\000\000\000\006\229\000\000\000\000\006\229\b\177\000\000\000\000\006\229\000\000\b\177\b\177\000\000\000\000\006\229\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\024\174\000\000\000\000\000\000\000\000\006\229\000\000\000\000\000\000\000\000\000R\000V\000Z\000\146\000\000\000\150\000\000\000\154\000\158\000\162\000^\000\000\000\170\000\174\000\000\000v\000\000\000\182\000\000\000\186\001\146\001\150\000z\000\000\000\000\000\000\006\229\000\000\000\000\006\229\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\154\000\000\000\000\000\000\006\229\000\000\000\000\021\230\000\000\006\229\006\229\006\229\000\000\006\229\006\229\000\000\006\229\000~\000\000\020z\000\000\000\000\000\000\006\229\000\000\000\000\006\229\000\000\000\000\000\000\020~\000\000\020\130\000\000\000\000\000\000\020\134\001\158\000\000\000\000\000\000\006\229\020\138\0262\000\000\000\000\006\229\006\229\020\142\000\000\000\000\020\150\001\162\021\254\000\000\020\154\026&\tn\000\000\000\000\000\000\020\158\000\000\000\000\000\000\020z\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\tr\000\000\020~\020\162\020\130\000\000\000\000\000\000\020\134\000\000\000\000\000\000\000\000\000\000\020\138\000\000\000\000\000\000\000\000\000\000\020\142\000\000\000\000\020\150\000\000\000\000\000\000\020\154\000\000\000\000\000\000\000\000\000\000\020\158\020\166\000\000\000\000\020\170\000\000\000\000\000\000\020v\000\000\000\000\000\000\000\000\000\000\000\000\000\000\020\162\020\174\000\000\000\000\020z\000\000\020\178\000\n\020\182\000\000\020\186\020\190\000\000\020\194\000\000\020~\000\000\020\130\t=\000\000\020\198\020\134\000\000\020\202\000\000\000\000\000\000\020\138\000\000\000\000\000\000\020\166\000\000\020\142\020\170\000\000\020\150\000\000\020\206\000\000\020\154\000\000\000\000\020\210\020\214\000\000\020\158\020\174\000\000\000\000\000\000\000\000\020\178\000\n\020\182\000\000\020\186\020\190\000\000\020\194\000\000\000\000\022\194\022\218\000\000\000\000\020\198\000\000\000\000\020\202\000\000\000\000\000\000\000\000\000\000\020z\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\020\206\000\000\020~\000\000\020\130\020\210\020\214\000\000\020\134\020\166\000\000\000\000\020\170\000\000\020\138\000\000\000\000\000\000\000\000\000\000\020\142\000\000\000\000\020\150\000\000\020\174\000\000\020\154\023B\000\000\020\178\000\n\020\182\020\158\020\186\020\190\000\000\020\194\000\000\000\000\020z\000\000\000\000\000\000\020\198\000\000\000\000\020\202\000\000\020\162\000\000\020~\000\000\020\130\000\000\000\000\000\000\020\134\000\000\000\000\000\000\000\000\020\206\020\138\000\000\000\000\000\000\020\210\020\214\020\142\000\000\000\000\020\150\000\000\000\000\000\000\020\154\000\000\000\000\000\000\020\166\000\000\020\158\020\170\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\020\174\000\000\020\162\020v\000\000\020\178\000\n\020\182\000\000\020\186\020\190\000\000\020\194\000\000\000\000\020z\000\000\000\000\000\000\020\198\000\000\000\000\020\202\000\000\000\000\000\000\020~\000\000\020\130\000\000\000\000\000\000\020\134\020\166\000\000\000\000\020\170\020\206\020\138\000\000\000\000\000\000\020\210\020\214\020\142\000\000\000\000\020\150\000\000\020\174\000\000\020\154\020v\000\000\020\178\000\n\020\182\020\158\020\186\020\190\000\000\020\194\000\000\000\000\020z\000\000\000\000\000\000\020\198\000\000\000\000\020\202\000\000\024z\000\000\020~\000\000\020\130\000\000\000\000\000\000\020\134\000\000\000\000\000\000\000\000\020\206\020\138\000\000\000\000\000\000\020\210\020\214\000\000\000\000\000\000\020\150\000\000\000\000\000\000\020\154\000\000\000\000\000\000\020\166\000\000\020\158\020\170\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\020\174\000\000\020\162\000\000\000\000\020\178\000\n\020\182\000\000\020\186\020\190\000\000\020\194\000\000\000\000\000\000\000\000\000\000\000\000\020\198\000\000\000\000\020\202\000\000\000\000\015]\000\000\000\000\015]\000\000\000\000\000\000\000\000\020\166\000\000\000\000\020\170\020\206\000\000\000\000\000\000\000\000\020\210\020\214\000\000\000\000\000\000\000\000\000\000\020\174\000\000\015]\015]\000\000\020\178\024\166\020\182\000\000\020\186\020\190\000\000\020\194\000\000\000\000\000\000\000\000\015]\000\000\020\198\000\000\015]\020\202\015]\015]\000\237\000\000\000\000\000\237\000\000\000\000\004\198\000\000\015]\000\000\000\000\015]\020\206\015]\000\000\000\000\000\000\020\210\020\214\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\237\000\237\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\015]\002\250\000\000\000\000\000\000\000\237\000\000\000\237\000\237\000\000\000\000\000\229\000\000\000\000\000\229\000\000\000\000\000\237\000\000\000\000\003\002\000\000\003\018\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\229\000\229\000\000\015]\015]\000\000\015]\000\000\000\000\000\000\015]\000\000\000\237\000\000\000\000\000\229\000\000\000\000\000\000\000\229\000\000\000\229\000\229\003\146\015]\000\000\001\017\000\000\015]\015]\000\000\000\229\000\000\000\000\003\002\015]\000\229\000\000\000\000\015]\015]\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\242\003\026\000\000\000\237\000\000\000\000\000\237\000\000\000\000\000\000\003\n\000\000\000\000\000\000\000\229\002\250\000\000\000\000\000\000\001\017\000\000\001\017\003\154\000\000\000\237\000\000\000\000\000\000\000\237\000\237\000\000\003\"\000\000\000\000\003\002\000\000\003\018\000\000\000\000\000\237\000\237\000\000\000\000\000\000\000\000\000\000\000\000\003\146\000\000\000\000\001\005\000\000\000\000\000\000\000\229\000\000\000\000\000\229\000\000\000\000\000\000\003\n\000\000\003*\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\242\003\026\000\229\000\000\000\000\000\000\000\229\000\229\000\000\000\000\000\000\000\000\000\000\000\253\000\000\002\250\000\253\000\229\000\229\001\005\000\000\001\005\001\005\000\000\000\000\000\000\000\000\000\000\000\000\000\000\0032\003\"\000\000\001\017\003\002\000\000\003\018\003\n\000\000\002\242\003\026\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\017\000\000\000\000\002\250\001\017\001\017\000\000\000\253\000\000\000\253\000\253\000\000\003*\000\000\000\000\003\162\003:\000\000\000\000\000\253\000\000\000\000\003\002\000\000\003\018\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\233\000\000\000\000\000\233\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\003*\0032\000\000\000\000\001\005\000\000\000\000\000\000\003\n\000\000\000\233\000\233\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\005\000\000\000\000\000\233\001\005\001\005\000\000\000\233\000\000\000\233\000\233\000\245\000\000\000\000\000\245\001\005\003:\000\000\000\253\000\233\000\000\000\253\003\002\000\000\000\233\003\n\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\242\003\026\000\253\000\000\000\000\000\000\000\253\000\253\000\000\000\000\000\000\000\000\000\000\000\000\000\233\002\250\000\000\000\253\000\253\000\245\000\000\000\245\000\245\000\000\000\249\000\000\000\000\000\249\000\000\000\000\000\000\000\245\000\000\000\000\003\002\000\000\003\018\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\242\003\026\000\000\000\000\000\233\000\000\000\000\000\233\000\000\000\000\000\000\003\n\000\000\000\245\000\000\002\250\000\000\000\000\000\000\000\249\003\146\000\249\000\249\001\r\000\000\000\233\000\000\000\000\000\000\000\233\000\233\000\249\000\000\000\000\003\002\000\000\003\018\000\000\000\000\000\000\000\233\000\233\000\000\000\000\000\000\000\000\002\242\003\026\000\000\000\000\000\000\000\000\000\000\000\245\000\000\000\000\000\245\000\000\000\000\000\000\003\n\002\250\000\000\003*\000\000\001\r\000\000\001\r\003\154\000\000\001\001\000\000\000\000\001\001\000\245\000\000\000\000\003\"\000\245\000\245\003\002\000\000\003\018\000\000\000\000\000\000\000\000\000\000\000\000\000\245\000\245\000\000\000\000\000\000\000\000\000\000\002\242\003\026\000\000\000\000\000\000\000\000\000\000\000\249\000\000\000\000\000\249\000\000\000\000\003*\003\n\002\250\000\000\000\000\000\000\001\001\000\189\001\001\001\001\000\000\003\146\000\000\000\000\000\000\000\249\000\000\000\000\003\"\000\249\000\249\003\002\000\000\003\018\000\000\000\000\000\000\000\000\000\000\000\000\000\249\000\249\000\000\002\242\003\026\000\000\000\000\002\242\003\026\000\000\0032\000\000\000\000\001\r\000\000\000\000\000\000\003\n\002\250\000\000\003*\000\000\002\250\000\000\000\189\000\189\000\000\000\197\000\209\003\154\000\000\001\r\000\000\000\000\000\189\001\r\001\r\003\002\003\"\003\018\000\000\003\002\000\000\003\018\000\000\000\000\001\r\003:\000\000\000\000\000\000\000\000\000\000\002\242\003\026\000\000\000\000\000\000\000\000\000\000\0032\000\000\000\000\001\001\000\000\000\000\003*\003\n\002\250\000\000\003*\000\000\000\000\000\000\000\197\000\197\000\000\000\000\000\000\000\000\000\000\001\001\000\000\000\000\003\"\001\001\001\001\003\002\000\000\003\018\000\000\000\000\000\000\000\000\000\000\000\000\001\001\001\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\189\000\000\000\000\000\000\0032\000\000\000\000\003\n\000\000\000\000\003*\003\n\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\189\000\000\000\000\000\000\000\209\000\000\000\000\000\189\000\000\000\000\000\000\000\209\000\000\000\000\000\000\000\189\000\189\000\000\000\000\000\209\003:\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\0032\000\000\000\000\000\000\000\000\000\000\000\000\003\n\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\197\000\000\000\000\000\000\000\000\000\000\000\000\000\197\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\197\000\197"))
  
  let lhs =
    (16, "\000\012\000\011\000\n\000\t\000\b\000\007\000\006\000\005\000\004\000\003\000\002\000\001\000\000\0018\0018\0018\0017\0017\0017\0017\0016\0016\0016\0016\0015\0015\0015\0015\0015\0015\0015\0015\0015\0015\0015\0015\0015\0015\0015\0014\0014\0014\0014\0014\0014\0014\0014\0014\0014\0014\0014\0014\0014\0014\0013\0013\0013\0013\0013\0013\0013\0013\0013\0013\0013\0013\0013\0013\0013\0012\0012\0012\0012\0012\0012\0012\0012\0012\0012\0012\0012\0012\0012\0012\0011\0011\0011\0011\0011\0011\0011\0011\0011\0011\0011\0011\0011\0011\0010\0010\0010\0010\001/\001.\001.\001.\001-\001-\001-\001,\001,\001,\001+\001+\001+\001*\001)\001(\001'\001'\001&\001&\001%\001%\001$\001$\001#\001#\001\"\001!\001 \001\031\001\030\001\029\001\028\001\027\001\026\001\025\001\024\001\023\001\022\001\021\001\020\001\019\001\019\001\018\001\018\001\017\001\017\001\016\001\016\001\015\001\015\001\015\001\015\001\014\001\014\001\014\001\014\001\r\001\r\001\r\001\r\001\012\001\012\001\012\001\012\001\011\001\011\001\011\001\011\001\n\001\n\001\n\001\n\001\t\001\t\001\t\001\b\001\b\001\b\001\b\001\b\001\007\001\006\001\005\001\005\001\005\001\005\001\005\001\004\001\004\001\003\001\002\001\001\001\001\001\001\001\001\001\000\001\000\001\000\001\000\000\255\000\255\000\255\000\255\000\255\000\255\000\255\000\255\000\255\000\255\000\255\000\255\000\255\000\255\000\255\000\255\000\255\000\255\000\255\000\255\000\255\000\255\000\254\000\253\000\253\000\252\000\252\000\252\000\252\000\252\000\252\000\252\000\252\000\251\000\251\000\250\000\250\000\250\000\249\000\248\000\247\000\247\000\246\000\246\000\245\000\244\000\243\000\243\000\242\000\242\000\241\000\241\000\240\000\240\000\239\000\238\000\237\000\237\000\236\000\236\000\235\000\235\000\234\000\234\000\233\000\233\000\232\000\231\000\231\000\230\000\230\000\230\000\230\000\230\000\230\000\229\000\229\000\229\000\228\000\227\000\226\000\226\000\226\000\226\000\225\000\225\000\224\000\223\000\223\000\223\000\222\000\222\000\222\000\222\000\222\000\221\000\221\000\221\000\221\000\220\000\220\000\220\000\220\000\219\000\219\000\219\000\219\000\218\000\217\000\217\000\216\000\216\000\216\000\215\000\214\000\214\000\214\000\213\000\212\000\212\000\211\000\211\000\211\000\210\000\210\000\210\000\209\000\209\000\209\000\209\000\208\000\208\000\207\000\207\000\207\000\207\000\207\000\207\000\206\000\206\000\206\000\205\000\205\000\205\000\205\000\205\000\205\000\205\000\204\000\203\000\202\000\202\000\201\000\201\000\200\000\200\000\199\000\199\000\198\000\198\000\197\000\197\000\196\000\196\000\196\000\196\000\196\000\196\000\196\000\196\000\195\000\194\000\193\000\193\000\192\000\192\000\191\000\191\000\190\000\190\000\189\000\189\000\188\000\188\000\187\000\187\000\186\000\186\000\185\000\185\000\184\000\184\000\183\000\183\000\182\000\182\000\181\000\181\000\180\000\180\000\179\000\179\000\178\000\178\000\177\000\177\000\176\000\176\000\175\000\175\000\174\000\174\000\173\000\173\000\172\000\172\000\171\000\171\000\170\000\170\000\169\000\169\000\168\000\168\000\168\000\167\000\167\000\166\000\166\000\165\000\165\000\164\000\164\000\163\000\163\000\162\000\162\000\161\000\161\000\160\000\160\000\160\000\159\000\159\000\158\000\157\000\157\000\157\000\157\000\157\000\157\000\157\000\157\000\157\000\157\000\157\000\157\000\157\000\157\000\157\000\157\000\157\000\157\000\157\000\157\000\157\000\157\000\157\000\157\000\157\000\157\000\157\000\157\000\157\000\157\000\157\000\157\000\157\000\157\000\157\000\157\000\156\000\156\000\156\000\156\000\155\000\154\000\153\000\152\000\151\000\150\000\149\000\148\000\147\000\146\000\145\000\144\000\143\000\143\000\143\000\142\000\142\000\142\000\141\000\141\000\141\000\141\000\140\000\140\000\139\000\138\000\137\000\136\000\135\000\134\000\133\000\132\000\131\000\130\000\130\000\129\000\129\000\129\000\128\000\128\000\127\000\127\000\127\000~\000~\000~\000}\000}\000|\000{\000{\000{\000{\000z\000y\000y\000y\000y\000y\000y\000y\000y\000y\000y\000y\000y\000y\000y\000y\000x\000x\000w\000w\000w\000w\000w\000w\000w\000v\000v\000v\000v\000v\000v\000v\000u\000u\000u\000u\000u\000u\000u\000t\000t\000t\000t\000t\000t\000t\000s\000s\000s\000s\000s\000s\000s\000r\000r\000r\000r\000r\000r\000r\000q\000q\000p\000p\000o\000o\000n\000n\000m\000m\000l\000l\000k\000k\000j\000j\000j\000j\000j\000j\000j\000j\000j\000j\000j\000j\000j\000j\000j\000j\000j\000j\000j\000j\000j\000i\000i\000h\000h\000g\000g\000f\000f\000e\000e\000d\000d\000c\000c\000b\000b\000b\000b\000b\000a\000a\000`\000`\000`\000`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r")
  
  let goto =
    ((16, "\002\128\0020\000\000\000\000\000\000\000M\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001q\000\000\001G\006H\000\000\000\000\000\r\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\003v\000\000\005\172\003\254\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\015\000l\000\000\000\255\000\000\000\000\003\\\000\000\000\000\005*\000\000\000\000\000\000\000R\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\003x\000\000\000\000\001\246\019X\000\000\000\000\020\178\000\000\000\000\000\000\000\000\000\000\000\000\014\212\000\000\000\000\000\000\000\000\000\000\005\202\000\000\000\018\000\000\000\142\000\000\000\000\000\000\005\206\000\000\b\228\000\000\000\000\000\000\b\172\000\000\000\000\000\000\016\212\001O,\152\000\000\000\000\027\246\028\"\000\000\000N\000\000\030t1H6J1H\016\"1\160\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\030\1607 \000\000\000\000!\030)\0180\134\000\0002R\003~\000\000\000\000*\0185\228\000\000\000\000\000\000\001\022\000\000\000\1302\004+\b\000\000\000\000Ml\000\000\004>\000\000\006:\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\005\170\000\000\000\000\006\160\000\000\018*\000\000\023\160\000\000\024\172\000\000!\028\000\000\"\164\000\000#\154\000\000%\"\000\000&\012\000\000&\170\000\0004z\000\000\017\196\000\000\000\000\000\000\000\000\t\130\000\000\000\000\000\000\000\000'\160\000\000(\138\000\000.\186\000\0004\168\000\0007x\000\0008:\000\000;F\000\000DJ\000\000H\224\000\000J\152\000\000L\234\000\000S\022\000\000U\168\000\000V&\000\000VV\000\000V\144\000\000\0070\000\000\000\000\b&\000\000\000\000\000\000\000\000\002\146\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000gM\210\000\000\000+\000\000\000\000\000d\t\176\000\000\000b\000\r\000 \000\166\001{\000\000\001$\000\000\000\000\001\146\000\000\001\156\000\000\000\00074\000\000\000\000\000\000\000,\nz\000\000;&7\236\000\000\000\000\000\000\000\000\011p\018\014\000\000\000\000\000\000\000\000\000\000\000\000;\128\000\000\000\000<\n\000\000\000\000=\178\000\000\004\026\000\000\b(\000\000\000\000\000\000\003@\000\0002\2428&\000\000\000\0008j9\018\000\000\t\028\000\000\n\018\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000V\168\000\0004\188\000\000Uz\000\000V\188\000\000V\234\000\000W\156\000\000W\198\000\000W\254\000\000X\002\000\000X\030\000\000X\146\000\000X\192\000\000X\226\000\000Y\018\000\000Y0\000\000Y>\000\000\000\000:\006\000\000\000\000\000\000:J\000\000\000\000\000\000\000\000\000\000\000\000N$\000\000\000\000\000\000\b\236\000\000\000\000\000\000\000\000#\232\000\000\000\000\000\000\000\000\001G\000\000\000\000N>\000\000\000\000\000\000\020,\000\197\000\000\000\000A\238\000\000\000\000:\234\000\000\000\000\000\000\000\026\012f+\022\000\000\000\000On\000\000O\152\000\000\000\000\000\000\r\\B<\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000=\216\000\000\000\000\000\000\000\000BZ\014R\016\182\000\000?\244\000\000\000\000I\018\000\000\006V\000\000\000\000\024|\000\000\000\000\000\000\018\248\000\0003x\000\000\000\000O\154\000\000\000\000\000\000\021\028\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\028 \000\000\030\158\000\000\000}\000\000\000\000\000\000Yz\000\000Y\174\000\000Y\242\000\000ZZ\000\000Z|\000\000Z\148\000\000Z\198\000\000[ \000\000[0\000\000[j\000\000[\136\000\000[\210\000\000[\234\000\000\\v\000\000\000\000\000\000\000\000\000\000C2\000\000\000\000\003\146D\012\000\000\000\000D4\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\0001\\\000\000;\156\000\000\000\000\000\000\000\000\000\000<2\000\000\000\000\000\000<\200\000\000\000\000\000\000\000\000\000\000\000\000\001\015\000\000\000\000\000\000\000\000\014H\000\000\021@\000\000\000\000\0022\005\238\000\000\000\000\000\000\000\000\020N\014\252\000\000\016\232\000\000\000\000\000\000\021\174\000\000\023\"\000\000&B\000\000\000\000\000\000\000\000\000\000\000\000(\192\000\000\000\000\000\183\000\000\000\000\000\000\0226\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000b\022&\000\000\000\000\000\000\000\000\000\000\000\000\000\254\000\000\016\018\r\140\000\000\000\000\000\000\017:\000\000\000\000\000\000\002v\rT\000\000\002\184\000\000\000\000\000\000\000\000\014H\000\000\000\000\000D\nr\000\000\n\166\000\000\000\000\000\000\000\246\000\000\017\228\000\158\0007\000\000\000\000\000\000\002\208\000\222\000\000\000\000\003`\000\000\000\000\000\000\005H\000\000\000\000\000\000\000\252\000\000\000\000\000\000\000\000\000\000\003 \000\203\000w\000\000\000\000\000k\000\000\000\000\000\000\000\000\000\000\000\000O\186\000\000>\158\000\000\000\000\000\000P.\000\000\000\000\003b\000\000\000\000\000\000\003j\020*\000\000\000\000Db\000\000\000\000\004L\000\000\000\000\000\000\000\000\016p\000\000\023\204\000\000\000\000->\000\000\000\000\000\000D\180\000\000\000\000\000\000\000\000\000\0009\248\000\000\000\000\000\000\001O\000\000E\014\000\000\000\000\000\000\000\000\002\178\020\218\000\000E(\000\000\000\000\000\000\000\000\022\214\000\000E\218\000\000\000\000\000\000\000\000\003\168\000\000\n4\000\000\000\000J\190<\242\000\000\000\000\000\000PR\000\000\000\000\000\000\000\012\000\000P\226\000\000\000\000\000\000Q\004\000\000\000\000\000\230\000\000!\206\000\027=\136\000\000\000\000\000\000\021(\021~\000\000\000\000\000\000\000\000\000\000\000\000Kv\000\000\000\000O$\000\000\000\000O\220\000\000\006\130\000\000\0224\000\000\000\000\000\000\024\164\000\0003\146\000\000\000\000Q\154\000\000\000\000\000\000\025D\000\000\000\000\000\000\000\000\000\000\000\000\011\b\000\000\025\162\000\000\000\000\000\000\004\128\000\000\000\000\000\000\000\000\000\000\000\000\\\146\000\000E\242\000\000U\142\000\000]\000\000\000]\030\000\000]>\000\000]\192\000\000]\230\000\000]\234\000\000^(\000\000^T\000\000^~\000\000^\212\000\000^\246\000\000_\018\000\000_\022\000\000,\196\000\000\000\000\000\000\001F\000\000\004\252\000\000\018\218\003N\011*\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000R*\000\000>\228\0044\027N\000\000\000\000\000\00000\000\000\003\128\024\134\000\000\000\000F\198\000\000\000\000\000h\000\000\025T\000\000\000\000EF\000\000\000\000\000\000G\002\000\000\000\000\000\000\000\000Gh\000\000\000\000\012\b\026\174\000\000\000\000G\204\000\000\000\000\027@\000\000\000\000G\224\000\000\000\000\000\000\000\000H.\000\000IB\000\000?f?\214\001N\0062\000\000\006\158\007\210\000\000\000\000\000\000\014\202\000\000\000\000\0200\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000R>\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\0004\024\000\000@\020\000\000\000\000\000\000\019l\000\000\000\000\007\020\000\000\000\000\000\000\"`\002\152\000\000#V\000\000\000\000\000\000\000\000\004h\000\000\000\000\020b\000\000$L\000\000\000\0004\158\000\000\000\000\000\000Iv\000\000\000\000\0180\000\000\000\000\029\230\000\000\000\000Z\238\000\000\000\000\000\000I\196\000\000\000\000\000\000]N\000\000\000\000\000\000\000\000J*\000\000\000\000\000\000\000\000\r\178\022\222\000\000JT\000\000\000\000\000\000\000\000\000\000\000\000\021X\000\000\000\000\004\150\000\000\021\234\000\000\0180\000\000\000\000J|\000\000K\016\000\000@\250\000\000\000\000\000\0005\146\000\000\000\000\000\000KZ\000\000\000\000\012\222\000\000\000\000\030\030\000\000\000\000]\228\000\000\000\000\000\000K\240\000\000\000\000\000\000\000\000LV\000\000\000\000\015\234\030@\000\000\000\000M\018\000\000\000\000\004\166A\208\000\000\004\186\000\000\000\000\000\000\000\000\004\128\000\000A8\000\000$\222\000I%\212\000\000\001L\000\000\022\224\000\000\023\214\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\005\020&\202\002\006'\\\000\000\000\000\000\000\003.\000\000\024h\000\000\005&\000\000\000\000\018\208\001$(R\000\000\002\226\000\000\025^)H\000\000\000\000\026T\000\000\000\000\000\000\000\000\000\000\000\000\000\000\005\140\012 \000\000\005\164\000\000\000\000\000\000\000\000\005\238\000\000\026\230\000\000\000\000\000\000/\166RZ\000\000\000\000\000\000/:\000\000\000\000\000\000\000\000\005\1881\014\000\000\000\000\000\000\000\000\005\192\000\000\000\000\000\000\000\000\016R\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\"\000\000\027\220\000\000\000\000\000\000R\240\000\000\r\022\000\000\000\000\000\000\0050\000\000\005\178\000\000\000\000\002\212\028\210\000\000\029d\000\000\000\000\000\000\003\156\000\000Sr\004\250S\134\000\000S\162\000\000\000\000\000\000\005h\000\000T2\005\190\000\000\000\000,X=z\000\000\005\204-\232\000\000\000\000.z\000\000\000\000\000\000\006\006\000\000TF\006\018\000\000\000\000\b\208\006\030\014p\000\000\0272\000\000\000\000\000\000\0068\000\000T\200\006\156\000\000\000\000\000\000\002H\000\000\002\192\000\000\000\000\000\000\000\000\000\017\000\000\000\000\000\000\000\000\000\000\000\000\000\000\005\130\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\t\022\000\000\000\000\007\186\000\000\000\160\000\000\000\000\000\000\000\180\000\000\000\000\000\000\000\000\000\000\007\188\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\026\000\000\000\000\001\150\000\000\t\196\000\000\000\000\000D\000\000\002\188\001R\002x\000\000\000\000\000\160\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\0034\004\254\000\000\000\000\b\166\000\000\000\000\000\000\012\002\000\000\000\000\012\248\rR\000\000\000\000\000\000\000\000\r\238\015>\002\186\000\000\002\162\000\000\000\000\000\000\000\000\018\156\000\000\000\000\000\000\000\000\000\000\000\000\000E\000\000\000\000\007\202\000\000\000\000\001\208\000\000\019\002\000\000\000\000\000\000\b\020\000\000\000\000\019\200\000\000\000c\000\000\000\000\000\000\000\000\000\129\019`\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\022\200\021V\000\000\000\000\000\000\000\000\024\162\024\250\b\206\000\000\026\022\000\000\000\000\000\000\000\000\000\000\000\000\018\178\000\000\003B\000\000\000\000\000\000\n\012\000\000\000<\000\000\000\000\000\000\023\212\000\000\000\000\0266\027\002\n\186\000\000\027x\000\000\000\000\000\000\000\000\000\000\000\000\002\170\002\128\000\000\002\202\000\000\028r\011\002\000\000\028\202\000\000\000\000\000\000\000\000\003\028\000\000\003\174\000\000\000\000\000\000\001f\000\000\001f\003\154\003\246\000\000\000\000\000\000\001l\014\176\000\000\000\000\000\000\000\000\000\000\002\236\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\016\000\000\000\000\000\005\000\000\014\248\004\180\004\164\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\011\142\000\000\000\000\024\244\029$\000\000\000\000\000\000\000\000\029\128\000\000\000\0006\132\000\000\005\130\000\000\000\000\000\000\000\000\014\250\000\000\000\000\000\000\000\000\000\000\001|\024\204\000\000\000\000\026~\000\000\000\000\000\000\000\000\r\012\000\000\000\000\003\144\000\000\000\000\000\000\000\191\000\000\000\000\000\215\000\000\000\000\000\000\000\000\000\000\000\000\000\000M.\000\000\000\000\000\000\001\011\000\000\000\000\000\000\000\000\000\000\001\026\012\152\017\b\017\132\000\000\006\184\007\014\007\022\007d\000\000\000\000\000\000\000\000\000\000\000\000\007$\030Z\000\000)\218\007~\000\000\000\000\007\224\000\000\031P\000\000B\022\000\000\000\000\007(\031\226\000\000*\208\000\000\007f+\198\000\000\000\000\000\000\002\148\025\130\000\000\000\000\000\000\000\000\016\222\000\000\021\206!$\000\000\000\000\027\200\"\026\000\000\"L\000\000\000\000\021\174\000\000\023\"\000\000\000\000$\202\000\000\000\000\000\000\000\000\000\000\000\000\000\000\014\012\000\000\000\000\000\000\b\002\000\000 \216\000\000\026t\004\160\000\000\000\000\000\000\000\000\000\000\000\000\0044\000\000\000\000\000\000\000\000\000\000M\134\000\000\004\014\000\000\000\000\000\000\000\000\000\000\002*\000\000\015\002\0022\015\248\000\000\004p\016\238\000\000\004\178\000\000\005f\000\000\006\\\000\000\007R\000\000\026t\000\000\000\000\000\000\000\000\000\000\bH\000\000\004\186\000\000\t>\000\000\026t\005,\000\000\001\194\000\000\005@\006\236\000\000\004\020\000\000\004L\000\000\000\000\000\000\000\000\000\000\000\000\004h\000\000\004\132\000\000\004\226\000\000\000\000\000\000\000\000\000\000\005\030\000\000\000\000\000\000\000\000\000\000\006\134\0050\000\000\000\000\005\160\000\000\000\000\005\188\005\128\007H\000\000\007N\000\000\000\000\003\136\006R\000\000\006\002\000\000\000\000\006T\000\000\000\000\000\000\000\000\000\000\000\000\007\156\006~\000\000\000\000\000\000\006\190\006\140\005\158\006@\006\186\007\002\000\000\000\000\006\168\006P\006\162\006\220\007\022\000\000\000\000\007\176\b$\000\000\b@\000\000\bd\000\000\000\000\bF\000\000\000\000\bP\000\000\000\000\000\000\000\000\bb\000\000\b\144\000\000\000\000\000\000\b\150\000\000\000\000\000\000\b\156\000\000\000\000\000\000"), (16, "\001\210\000p\000\018\000=\003?\004t\003R\001\159\000p\006T\000y\000=\006U\005\169\005L\005M\000\007\000y\005\170\005\171\003\133\003\134\000p\002N\005\144\000\017\000N\002\217\004r\0042\001\211\000y\006Y\005\021\001\212\000N\006J\006K\000$\001D\0059\000\005\001E\000?\000p\002\133\002\134\002\157\002\137\006\011\005\172\000>\000N\000y\000N\002P\001D\003\007\006O\001P\000*\005\173\006E\006F\005:\0005\004\001\0005\003A\005=\005L\005M\001\162\006\t\003B\006\012\005L\005M\000N\000z\001\160\005]\001D\001\028\000p\001P\001\017\001\t\002S\003\233\002\196\006R\000O\000y\001\t\005N\001\213\005\170\005\171\002u\000p\000O\001\214\002\182\001F\005[\000p\002\148\001\t\000y\001G\005^\005L\005M\000p\000y\001\017\006R\000O\002\130\000O\001F\002\172\000y\001\147\001\239\001\019\001G\002S\005\202\001\t\0006\002\195\0006\002\174\005d\002O\004\161\002\198\003W\005\173\000z\001\012\003\235\000O\001\160\000p\001F\001V\002\185\002S\005N\0005\001G\001\210\000y\001\018\005N\003?\005A\003R\001\150\000p\002\133\002\138\001V\002\137\006~\002O\005E\001\t\000y\002\187\006\127\004\202\004\208\000p\003\133\003\134\003\237\0005\006\128\004|\004\000\001\135\000y\001\t\004\147\001\238\001\"\003O\001V\001\t\005N\003\242\005\249\002\188\000z\000\179\004\002\001\t\003P\004\163\004\128\004\207\002S\002S\004t\0009\005T\0009\003\007\002O\006\002\006+\004n\001\227\002\154\0006\002\164\004\001\005n\003A\001\029\000\179\000p\001\012\001\228\003B\001$\005\145\005\239\001\t\000\179\000y\002\166\001W\002\177\001\023\005b\003\244\006\b\0043\003\233\004z\001\023\0006\004\n\001\t\002\139\000\179\004\145\000P\001W\005\148\005\237\005\240\005L\005M\004*\003[\005\251\001\t\001\031\0005\006\t\002B\006\012\005L\005M\005O\000Q\002\176\002T\004\157\002\243\000\179\001 \003\\\001W\006\003\002\129\006\130\003]\001 \003\217\001\029\003^\001\153\007\026\001\210\006\004\006\005\003_\003?\0009\003R\003\235\001 \002\248\004\134\000<\001\136\002-\007\027\006\131\002&\005Y\002\167\006\190\0065\001\t\000p\001Z\002,\003\176\000p\006\128\006\191\004\000\001 \000y\006\193\003\208\002\166\000y\001\030\001X\005g\001Y\0006\001[\003\136\003\237\000\004\002\156\001\163\001\023\005N\001Z\001]\001\029\0005\002\129\003O\001\"\001^\003\007\003\242\005N\0068\002\192\000\179\004\002\006\132\003P\004\001\001[\003A\000\005\001\026\003\253\001\\\006\133\003B\000p\001]\002\139\006\210\006\163\006\\\005a\001^\003\254\000y\002\177\001 \001\127\006\208\003\233\000p\001!\001 \001\023\004w\001#\000\167\005\249\002a\000y\002\197\002T\006\001\005\236\003\244\002k\004\005\006\165\001\t\002\129\002\218\004\n\001\t\003\218\004\203\006\167\000\004\0009\0006\002S\004\147\002d\003\209\004*\003[\003\000\005\132\005\237\005\240\005L\005M\003\219\001 \005\150\002S\004\205\005\134\005L\005M\0005\005\254\000\005\003\\\003\235\006+\000p\001\210\003]\001 \006\211\003?\003^\003R\0005\000y\000p\002\151\003_\004\134\005R\007#\001\t\001 \005\251\000y\004\205\000N\0005\000p\005h\000N\006\006\002\192\002\217\004r\0042\001\t\000y\000p\003\237\001\210\006;\000p\002\217\001\211\005b\004\136\000y\001\212\002\151\003O\000y\000Z\000p\003\242\0009\002\153\005S\000\179\004\002\006\212\003P\000y\003\007\002\178\0006\005\196\004\150\000F\006\133\005N\002\197\004\001\003\007\003A\006\214\000\r\002\218\005N\0006\003B\005\221\002S\005i\002l\0063\002S\005\135\003\158\002\152\000]\001\t\000O\0006\0005\003\233\000O\002S\000\016\000\017\003\244\001\t\004\005\006\216\002\180\006A\001\230\004\n\000N\002|\001\213\006\218\002e\004\228\001\t\002f\001\214\000R\005\223\004*\003[\001\210\006]\001\023\001\t\003?\000N\003R\001\t\004\230\000\170\000U\005a\0005\000\b\000\176\002\178\006\007\003\\\001\t\006=\006\b\0009\003]\004\129\003W\001\006\003^\001\012\003\235\004f\001\210\001\232\003_\005\252\003?\0009\003R\001 \005\233\0006\005\235\001 \004\004\006\129\006\t\005T\006\012\005L\005M\0009\005e\002\255\000p\000O\003\254\002\179\002\225\006\128\006\196\0042\006\184\000y\001\233\006\185\003\237\0048\001\230\007\012\003A\005\245\003\014\000O\006\025\004\139\003B\003O\000\164\003\254\0006\003\242\006\176\006\177\000\172\000\179\004\002\005\025\003P\003\007\004\131\003\233\001 \006\193\004\231\001\235\004\002\006\193\004\001\000\004\003A\006C\004n\003\133\003\134\000a\003B\001\026\004\216\000\159\004\230\001\227\000S\002\024\001I\006\207\0007\005b\0009\000\179\000\178\003\233\001\228\000V\000\005\0005\000S\003\244\000F\0043\005N\004z\006\017\002\192\004\n\006\189\004l\000V\004\145\004\220\001\t\003W\000F\005p\004\n\003\235\004*\003[\004\018\006\199\002\185\007\019\002\229\006\215\006\181\001\210\004*\0009\001\238\003?\002\255\003R\002\193\003\164\001\017\003\\\006\174\005q\005L\005M\003]\003\181\002\197\002\189\003^\003\235\002\027\000p\004i\006\220\003_\003\237\006\128\006\196\0042\001 \000y\001C\004i\000N\0005\0006\003O\000\170\006R\001 \003\242\002\188\000\171\001 \000\179\001\240\006\224\003P\003Z\000\179\002S\0005\000\180\000:\001 \003\237\003\007\006R\004\218\000p\001\241\004n\004k\002\143\002\217\004\001\003O\003A\000y\006\244\003\242\000p\004j\003B\000\179\004\002\006\202\003P\0057\0058\000y\004\142\006\201\004\172\000\181\006\133\003\244\005\243\003\233\000p\004\142\003\243\000{\005N\003\007\003\254\006\023\006\242\000y\000O\0006\0005\003\135\002S\000\164\000N\003[\001\t\002\226\000\170\000\172\006\236\0009\000\182\000\176\004\238\003\244\0006\0043\000N\006\204\004\144\001\210\004\n\003\\\006\238\003?\006\206\003R\003]\004\143\004\240\000\183\003^\000p\004*\003[\000\255\000^\003_\004\166\000N\003\235\000y\000p\001\t\000\178\000\185\004\219\006\128\006\196\0042\004\166\000y\003\\\0005\000N\001\t\007\011\003]\000\170\002a\004\193\003^\004\193\000\171\007\t\0006\002{\003_\004\241\000O\006\240\006\015\001 \001\t\000\164\0009\003\237\003\007\004\168\007\030\000\172\000\005\002d\000O\004\240\000D\004\001\003O\003A\001\012\004\167\003\242\0009\006a\003B\000\179\004\002\006\202\003P\006\246\004\195\000F\004\194\006\203\003\216\000O\006\133\006\252\006\253\003\233\004\221\004\244\003\243\003\133\003\134\005t\000\178\004\255\001\t\0006\000O\003\133\003\134\003\133\003\134\000\164\000N\004\240\001\t\000\179\000\170\000\172\000\180\005\001\004\002\000\176\006a\003\244\007\002\0043\006a\006\204\003\208\001\210\004\n\002\190\005\002\003?\006\206\003R\000S\000_\004\218\005\005\003\133\003\134\004*\003[\006\245\007\031\005\r\000V\005\001\003\235\000\181\000p\000F\000\178\007%\004\240\006\128\006\196\0042\005\016\000y\003\\\005\015\004\220\007\003\006a\003]\006m\004\n\002\147\003^\007\b\004\018\007\020\007\007\005\015\003_\007\015\000O\003\254\004*\001 \003\208\000\164\001\020\003\237\003\007\000\179\007\020\000\172\000\180\007\017\001\023\0005\007&\004\001\003O\003A\000\187\002e\003\242\001\209\002f\003B\000\179\004\002\006\202\003P\005\019\000\188\001\023\000p\006\205\005H\005K\006\133\006p\003\209\003\233\001 \000y\003\243\000\181\003>\004\240\000\178\007C\007\019\003\254\005I\005I\001 \007\023\006\164\005\147\000N\000N\001\t\000\179\000\170\001D\000\180\007D\001E\000\176\003\254\003\244\002\159\0043\001 \006\204\000\182\001\210\004\n\003\248\001\023\003?\006\206\003R\0006\006e\007\024\006i\005\156\006w\004*\003[\007\028\007\029\007 \000\183\003\212\003\235\000\181\000p\000\184\007\019\007\020\007!\006\128\006\196\0042\007$\000y\003\\\000\185\007'\005\157\007(\003]\005\160\005L\005M\003^\001 \006|\003\215\001\t\003\207\003_\0079\000O\000O\006d\001 \001F\000\164\006c\003\237\003\007\000\179\001G\000\172\000\180\007.\0077\006\248\0073\004\001\003O\003A\000\187\0076\003\242\000p\000w\003B\000\179\004\002\006\202\003P\007?\000\190\000y\0005\006\213\003\208\007=\006\133\005s\007A\003\233\000p\007F\003\243\000\181\006b\002\217\000\178\001V\000\000\000y\000p\002\133\002\134\002\135\002\137\000\000\000N\000z\001\t\000y\000\170\005q\005L\005M\000\000\000\176\002S\003\244\000\000\0043\005N\006\204\000\182\001\210\004\n\003\007\000\000\003?\006\206\003R\000\000\005\134\005L\005M\002S\000z\004*\003[\005<\000\000\000\000\000\183\000\000\003\235\002S\000p\000\254\000\000\0006\000\000\006\128\006\196\0042\000\000\000y\003\\\000\185\000N\001\t\000\000\003]\000\170\005:\000\000\003^\000\000\000\174\005=\005L\005M\003_\000\000\000O\003\209\000\000\001 \001\t\000\164\000\000\003\237\003\007\000\179\000\179\000\172\000\180\001W\001\t\000\000\005\145\004\001\003O\003A\000\000\005N\003\242\000\000\001\023\003B\000\179\004\002\006\202\003P\000p\000\000\000\000\000\000\006\217\000\000\000\000\006\133\000\000\000y\003\233\005N\000\000\003\243\000\181\000\000\000\000\000\178\000\000\000\000\005\185\000O\005Z\0009\000\000\000\000\000\164\000N\000\000\001\t\000\000\000\170\000\172\001 \000\000\000\000\000\176\000\000\003\244\005\174\0043\000\000\006\204\000\182\001\210\004\n\005[\005N\003?\006\206\003R\000\000\005^\005L\005M\000\000\000\000\004*\003[\000\000\005\200\001\146\000\183\000\000\003\235\004\002\000p\001\001\000\178\000\000\000\000\002\217\004r\0042\000\000\000y\003\\\000\185\000\000\001\210\000\000\003]\000\000\001\211\005\198\003^\001\t\001\212\005\201\005L\005M\003_\000\000\000O\000\000\000\000\001 \000p\000\164\002T\003\237\003\007\000\179\002\139\000\172\000\180\000y\002\129\005\b\000\000\004\001\003O\003A\004\n\001\144\003\242\000\000\004\018\003B\000\179\004\002\006\202\003P\000p\000\000\004*\000\000\002T\000\000\000\000\006\133\000\000\000y\003\233\005N\002\129\003\243\000\181\000\000\000\000\000\178\000\000\000\000\000\000\000\000\001\230\001 \000\000\000\000\001\213\000N\000\000\001\t\000\179\000\170\001\214\000\180\000\000\000\000\000\176\000\000\003\244\000\000\0043\001 \006\204\000\182\001\210\004\n\000\000\005N\003?\006\206\003R\001 \005\134\005L\005M\000\000\000\000\004*\003[\001\231\001\t\000\000\000\183\000\217\003\235\000\181\000p\001R\001\232\000\000\000\000\002\217\004r\0042\000\000\000y\003\\\000\185\000\000\001\210\000\000\003]\000\000\001\211\000\000\003^\001\t\001\212\005\134\005L\005M\003_\000\000\000O\000\212\000\000\001 \000\000\000\164\001\233\003\237\003\007\000\179\000\000\000\172\000\180\001\022\000\000\000\000\000\000\004\001\003O\003A\000\183\001\023\003\242\000\000\000\218\003B\000\179\004\002\000\214\003P\004\211\004\128\000\000\000\000\000\000\000\185\005j\001\235\000\000\006\b\003\233\005N\000\000\003\243\000\181\000\000\000\000\000\178\000\000\000\000\005\211\000\000\001\230\001\227\002*\002\017\001\213\000\000\000\000\001\t\001 \000\179\001\214\006\t\001\228\006\012\005L\005M\003\244\000\000\0043\000\000\004z\000\182\001\210\004\n\000\000\005N\003?\004\018\003R\000\000\000\000\000\000\000p\002\028\005\226\004*\003[\001\231\000\000\002\020\000\183\000y\003\235\000\000\000p\001T\001\232\005p\001\238\002\217\004r\0042\000\000\000y\003\\\000\185\000\000\001\210\002\161\003]\000\000\001\211\000\000\003^\000\000\001\212\001\023\003\182\000\000\003_\000\000\005q\005L\005M\001 \000\000\002S\001\233\003\237\003\007\000\179\000\000\000\000\000\180\002\163\000\000\000\000\000\000\004\001\003O\003A\001\240\001\023\003\242\000\000\005N\003B\000\179\004\002\000\000\003P\004~\004\128\000\000\000p\001 \001\241\000\000\001\235\006\\\000\000\003\233\000\000\000y\003\243\000\181\000\000\0005\001\t\000\000\000\000\000\000\000\000\001\230\001\227\002'\002\017\001\213\000\000\000\000\001\t\001 \000\179\001\214\000\000\001\228\000\000\000\000\000\000\003\244\000\000\0043\000\000\004z\000\182\001\210\004\n\000\000\000\000\003?\004\018\003R\000\000\005N\000\000\000\000\002\028\000\000\004*\003[\001\231\000\000\002\020\000\183\000\000\003\235\000\000\000p\003T\001\232\005p\001\238\002\217\004r\0042\000\000\000y\003\\\000\185\005\236\001\210\000\000\003]\0006\001\211\000\000\003^\000\000\001\212\000\000\001\t\000\000\003_\000\000\005q\005L\005M\001 \000p\002\150\001\233\003\237\003\007\005\237\005\240\005L\005M\000y\000\000\000\000\000\000\004\001\003O\003A\001\240\005p\003\242\006\028\000\000\003B\000\179\004\002\000\000\003P\004\165\004\128\000p\002\133\002\141\001\241\002\137\001\235\000\000\000z\003\233\000y\000\000\003\243\000\000\005q\005L\005M\002S\000\000\000\000\000p\001\230\001\227\002$\002\017\001\213\000\000\000\000\001\t\000y\000\179\001\214\000\000\001\228\000\000\0009\000z\003\244\000\000\0043\000\000\004z\000\000\001\210\004\n\002S\000\000\003?\004\018\003R\000\000\005N\005w\000\000\002\028\004+\004*\003[\001\231\001\t\002\020\005N\000\000\003\235\002S\000p\006g\001\232\005p\001\238\002\217\004r\0042\0005\000y\003\\\000\000\000\000\001\210\000\000\003]\000\000\001\211\001\026\003^\000\000\001\212\001\t\000\000\000\000\003_\000\000\005q\005L\005M\001 \005N\000\000\001\233\003\237\003\007\000\000\004\031\000\000\000\000\000\000\001\t\000\000\006^\004\001\003O\003A\001\240\000\000\003\242\000p\001\023\003B\000\179\004\002\002\217\003P\004\215\004\128\000y\005\249\002\248\001\241\000\000\001\235\000\000\000\000\003\233\000\000\000\000\003\243\000\000\000\000\0005\0006\000\000\000\000\004Z\0005\001\230\001\227\002\"\002\017\001\213\000\000\003\007\001\t\000\000\000\179\001\214\001 \001\228\000\000\000\000\002S\003\244\000\000\0043\000\000\004z\000\000\001\210\004\n\005\250\000\000\003?\004\018\003R\000\000\005N\005}\000\000\002\028\000\000\004*\003[\001\231\006\018\002\020\006>\000p\003\235\000\000\000p\000\000\001\232\005\251\001\238\006\128\000y\004\000\000\000\000y\003\\\001\"\006\b\001\t\002T\003]\0006\000\000\002\139\003^\000\000\0006\002\129\000\000\000\000\003_\000\000\006\019\0009\006\020\001 \000\000\005{\001\233\003\237\003\007\006\t\000\000\006\012\005L\005M\000\000\002T\000\000\004\001\003O\003A\001\240\005p\003\242\002\129\001$\003B\000\179\004\002\003\211\003P\006\160\004\128\000^\006\021\001 \001\241\006\209\001\235\000\000\000\000\003\233\000\000\002a\003\243\006\022\005q\005L\005M\000\000\002v\000\000\000\000\000\000\001\227\002\015\002\017\001\t\000\000\000\000\001\t\000\000\000\179\001 \000\000\001\228\002d\003\208\000\000\003\244\000\000\0043\0009\004z\000\000\001\210\004\n\000\000\004\002\003?\004\018\003R\001\026\000\000\005\141\000\000\002\028\000\000\004*\003[\000p\000\000\002\020\000{\005N\003\235\000N\000p\000\000\000y\001D\001\238\006\128\001P\004\000\000\000\000y\003\\\005\252\002\127\000p\002\133\003]\000\000\002\140\000\000\003^\000\000\000\000\000y\0005\005\n\003_\000\000\000\000\004`\004\n\001 \005N\000\000\004\018\003\237\003\007\000\000\002S\0005\000\000\000\000\004*\000\000\000\000\004\001\003O\003A\001\240\000z\003\242\000S\000c\003B\000\179\004\002\006\195\003P\002S\000\000\003\209\000\000\000V\001\241\006\194\006\133\000O\000F\003\233\001F\000\000\006\198\001\147\000\000\0005\001G\000\000\000\000\000\000\000\000\001\t\001 \000\000\002\219\000\000\000\000\000\000\001\t\005\255\0005\0006\000\000\000\000\000\000\0005\000\000\003\244\000\000\004\005\006\200\001\t\002e\001\210\004\n\002f\0006\003?\006\206\003R\001\150\000\000\000\000\001\023\001V\000\000\004*\003[\000\000\000\000\000\000\006/\000p\003\235\000\000\000p\000\000\000\000\000\000\000\000\006\128\000y\004\000\000\000\000y\003\\\000\000\000\000\000p\000\000\003]\0006\000\000\006\\\003^\000\000\000\000\000y\000\000\000\000\003_\001\"\001 \000\000\000\000\001 \0006\005\139\000\000\003\237\003\007\0006\000\000\000p\002\133\002\134\002\145\002\137\0009\004\001\003O\003A\000y\000\000\003\242\000\000\000\000\003B\000\179\004\002\006\195\003P\000\000\0009\000\000\000\000\000\000\000\000\006\197\006\133\000\000\001$\003\233\000\000\002a\006\198\000\000\000\000\000z\000\179\000p\002c\001W\000\000\000\000\006\\\000\000\002S\001\t\000y\000N\001\t\000\000\000\000\000\170\0027\000\000\002d\0009\000\174\003\244\000\000\004\005\006\200\001\t\000\000\001\210\004\n\000\000\000\000\003?\006\206\003R\0009\000\000\004\031\000\000\001\153\0009\004*\003[\000\000\000\000\000\000\002T\002\142\003\235\000N\000p\001\t\002\243\001D\002\129\002\217\001P\004\000\000\000\000y\003\\\002\248\000\000\000N\001Z\003]\0005\000\170\000\000\003^\000\000\000\000\000\171\001\026\000\000\003_\002\248\004Z\000O\000\000\001 \000\000\001[\000\164\003\237\003\007\000\000\001\163\001\t\000\172\000\000\001]\002\249\001 \004\001\003O\003A\001^\000\000\003\242\000\000\000\000\003B\000\179\004\002\006\195\003P\006\135\000\000\000\000\002\219\001\202\000\000\000\000\006\133\000O\002\253\003\233\001F\000\000\006\198\001\147\000\000\000\000\001G\000\178\000{\006f\000\000\000O\000\000\006\162\0006\000\000\000\164\000\000\001\t\000\000\000\000\004\223\000\172\000\000\002Q\000\000\004\160\003\244\0005\004\005\006\200\000\000\002e\001\210\004\n\002f\000\000\003?\006\206\003R\001\150\000\000\005p\001\023\001V\000\000\004*\003[\0005\005\197\000\000\006^\002\139\003\235\000\000\000p\000\000\000\000\000\178\001\023\002\217\000\000\004\000\000\000\000y\003\\\005q\005L\005M\000\000\003]\006]\002\219\005\198\003^\000\000\002T\005\201\005L\005M\003_\000\000\001 \000\000\002\129\001 \000\000\000\000\000\000\003\237\003\007\0009\000\179\005p\0006\000\180\0005\000\000\001 \004\001\003O\003A\000\000\000\000\003\242\000\000\001\210\003B\000\179\004\002\003?\003P\003R\006^\0006\000\000\000\000\005q\005L\005M\003\249\001\023\003\233\001 \000\000\004\149\000\000\000\181\000p\000\179\000\000\000\000\001W\002\217\003\251\004\000\000\000\000y\000\000\000\000\005p\001\t\000\000\000\179\004\158\001\151\000\180\000\000\005N\004\160\003\244\000\000\004\005\004\151\001\"\000\000\000\212\004\n\004\031\005N\001 \004\018\0006\003\007\005q\005L\005M\001\153\000\000\004*\003[\0009\004\001\000\000\003A\000\183\003\235\000\000\000\181\000\213\003B\000\000\002\248\000\214\000\000\000\000\000\000\000\000\003\\\005\159\000\185\0009\001Z\003]\001$\003\233\000\000\003^\004$\005N\000Y\0005\000N\003_\0005\000\000\001D\000\000\001 \001P\001[\000\000\003\237\005\157\001\t\001\163\005\160\005L\005M\001]\000\000\000\000\004(\003O\000\000\001^\000\187\003\242\000\000\001\210\000\000\000\179\004\002\003?\003P\003R\000\000\000\192\004\031\0009\000\000\000p\000\000\000\000\004\007\002\219\005N\000\000\004\149\003\235\000y\000p\000\000\000\000\000\000\000\000\002\217\004\b\0042\000\000\000y\000\000\002\248\000\000\000\000\000\000\000\000\0006\000O\0005\0006\001F\005\137\003\244\001\147\004\005\004\151\001G\004$\005\203\004\n\000\000\001\216\000\000\004\018\003\237\003\007\000\000\000\000\0005\000\000\000\000\004*\003[\000\000\004\001\003O\003A\005N\000\000\003\242\000\000\004(\003B\000\179\004\002\000\000\003P\000\000\003\214\000\000\003\\\000\000\002w\000S\001V\003]\000\000\003\233\000\000\003^\0047\0005\005\152\000\000\000V\003_\001\t\000N\000\000\000F\001 \003?\002\219\003@\0006\002d\001\t\000\000\000\000\0005\000\000\000\000\000\000\0009\000\000\003\244\003\208\004\005\0049\000\000\000\000\001\210\004\n\000\000\0006\003?\004;\003R\000\000\000\000\000\000\000\000\000\000\000\000\004*\003[\0045\000\000\000\000\005\167\000N\003\235\000\\\000p\003?\000\000\003R\000\000\002\217\004\b\0042\000\000\000y\003\\\000\000\000\000\000\000\0006\003]\000\000\005p\000\000\003^\000O\0005\003A\000\000\000\000\003_\000\179\000\000\003B\001W\001 \000\000\0006\000\000\003\237\003\007\000\000\000\000\0009\000\000\000\000\005q\005L\005M\004\001\003O\003A\000\000\000\000\003\242\000\000\001\210\003B\000\179\004\002\003?\003P\003R\0009\000p\000\000\000{\003\209\000O\001\161\003A\004:\003\233\000y\000\000\003\243\003B\000\000\000p\000\000\000\000\000\000\002\220\002\217\004\b\0042\0005\000y\000\000\000\000\000\000\001\t\0006\000N\001Z\000\000\0009\003?\002e\003@\003\244\002f\0043\002z\0044\000\000\002\227\004\n\000\000\001\023\000\000\004\018\001[\003\007\0009\000\000\000p\001\163\000S\004*\003[\001]\004\001\000\000\003A\000y\003\235\001^\005N\000V\003B\000\000\000\000\000\000\000F\000\000\000\000\006\142\003\\\000\000\000\000\003W\000\000\003]\006\155\003\233\000\000\003^\001 \003O\001\t\000\000\0006\003_\000{\000\000\000\000\000\179\001 \000O\003P\003A\003\237\000\000\001\t\000\000\000\000\003B\000\000\0009\003\001\000\000\000\000\003O\0005\000\000\000\000\003\242\0005\001\210\000\000\000\179\004\002\003?\003P\003R\000\000\001\225\002a\000\000\000\000\000\000\003O\000\000\003\005\002y\000\000\000\000\003\243\003\235\000\179\000p\001\t\003P\005\156\000{\002\217\004r\0042\000\000\000y\002d\0005\000\000\000\000\000\000\000\000\003Y\002\219\000\000\000\000\002W\002\219\003\244\000\000\0043\000\000\0044\005\157\0009\004\n\005\160\005L\005M\004\018\003\237\003\007\003\131\000\000\000\000\0006\000\000\004*\003[\0006\004\001\003O\003A\000\000\000\000\003\242\000\000\005\178\003B\000\179\004\002\000\000\003P\000\000\000\000\002t\003\\\003[\006\156\000\000\000\000\003]\000\000\003\233\000\000\003^\003\243\000\000\000\000\000\000\000N\003_\000\000\0006\000\170\003\\\001 \000\000\003O\000\171\003]\000\000\001\t\006\157\003^\006\145\000\179\000\000\006\146\003P\003_\003\244\0005\0043\000\000\0044\001\023\001\210\004\n\000\000\000\000\003?\004\018\003R\000\000\000\000\000\000\000\000\005N\000\000\004*\003[\0009\000\000\000\000\000{\0009\003\235\000\000\000p\000\000\000\000\000\000\000\000\002\217\004r\0042\000\000\000y\003\\\000\000\002\131\000\000\005\156\003]\001 \000O\002e\003^\000\000\002f\000\164\000\000\000\000\003_\000\000\000\000\000\172\001\023\001 \0009\000\000\000\000\003\237\003\007\000\000\000\000\005\157\0006\000\000\005\160\005L\005M\004\001\003O\003A\003Q\000\000\003\242\000\000\001\210\003B\000\179\004\002\003?\003P\003R\004y\000\000\000\000\000N\000\000\000\000\000\178\001\211\0005\003\233\001 \001\212\003\243\000\000\000\000\000p\000\000\000\000\000\000\000\000\002\217\004r\0042\0005\000y\000\000\000{\000N\001\t\000\000\000{\000\170\000\000\000\000\000\000\000\000\000\171\003\244\000\000\0043\000\000\004z\003\b\000\000\004\n\000\000\004,\000\000\004\018\000\000\003\007\000\000\005\180\000\000\000\000\000\000\004*\003[\0009\004\001\000\000\003A\005p\003\235\002o\005N\003\012\003B\000\000\000O\0040\000\000\000\000\001\213\0006\003\\\000\000\000\000\000\000\001\214\003]\006\b\003\233\000\000\003^\000\000\005q\005L\005M\0006\003_\000\179\000\000\000O\000\180\001 \000\000\000\000\000\164\003\237\005\156\001\t\000\000\0005\000\172\006\t\005p\006\012\005L\005M\003O\0005\000\000\000\000\003\242\000\000\001\210\000\000\000\179\004\002\003?\003P\003R\004{\005\157\000\000\000\181\005\160\005L\005M\005q\005L\005M\000\000\0005\003\243\003\235\000\000\000p\000\000\000\178\000\000\000\000\002\217\004\152\0042\000\000\000y\000\000\000{\000N\0009\000\000\000\000\000\170\000\000\000\000\000\000\000\000\000\176\003\244\006a\0043\000\000\004z\002\232\0009\004\n\005N\0006\000\000\004\018\003\237\003\007\000\187\000\000\000\000\0006\002\219\004*\003[\000\000\004\001\003O\003A\000\194\005\206\003\242\000\000\005N\003B\000\179\004\002\001\227\003P\000\000\004\141\000\000\003\\\000\000\0006\000\179\000\000\003]\001\228\003\233\000\000\003^\003\243\005N\000\000\000\000\005N\003_\000\000\000\000\000O\000\000\001 \000\000\000\000\000\164\000\000\000\000\001\t\000\179\000\000\000\172\000\180\000\000\004\154\000\000\000\000\003\244\000\000\0043\000\000\004z\000\000\001\210\004\n\000\000\000{\003?\004\018\003R\0009\000\000\005p\000\000\000\000\000\000\004*\003[\0009\0005\000\000\003D\003\159\003\235\000\181\000p\000\000\000\178\005p\000\000\002\217\004\152\0042\000\000\000y\003\\\005q\005L\005M\000\000\003]\0009\000\000\000\000\003^\000\000\006a\001\229\0005\000\000\003_\000\000\005q\005L\005M\001 \005\191\000\000\000\000\003\237\003\007\000\000\006\b\002\219\000\000\000\000\000\000\000\000\000\000\004\001\003O\003A\000\187\000\000\003\242\0066\001\210\003B\000\179\004\002\003?\003P\003R\000\196\000\000\0006\006\t\000\000\006\012\005L\005M\004\174\003\233\000\000\006\"\003\243\000\000\000\000\000p\000\000\005\189\003M\000\000\002\217\004\b\0042\006e\000y\002\243\000{\000\000\001\t\000\179\000\000\0006\000\180\000\000\004\156\005N\000\000\003\244\0005\0043\000\000\004\155\003\167\000\000\004\n\0005\000\000\005p\004\018\002\248\003\007\005N\000\000\000p\000\000\000\000\004*\003[\002\217\004\001\000\000\003A\000y\003\235\000\181\002\249\000\000\003B\000\000\000\000\000\000\005q\005L\005M\000\000\003\\\000\000\000\000\000\000\0009\003]\000\000\003\233\000\000\003^\000\000\000\000\005N\003\007\002\253\003_\000\000\000\000\000\182\000\000\001 \000\000\002S\000\000\003\237\000\000\001\t\000\000\000\000\0006\000\000\005p\000\000\0009\000\000\003O\0006\000\183\000\000\003\242\000\000\001\210\003V\000\179\004\002\003?\003P\003R\000\000\000\000\000\000\000\000\000\185\000p\000N\005q\005L\005M\000\161\002K\003\243\003\235\000y\000p\001\t\000\000\000\000\000\000\002\217\006e\004\000\004\031\000y\000\000\000\000\001\210\000N\000\000\005N\001\211\000\161\002G\000\000\001\212\005\187\003\244\000\000\0043\000\000\004\155\000\000\000\000\004\n\000\000\000\000\002\248\004\018\003\237\003\007\000\000\005\217\000\000\000\000\000\000\004*\003[\0009\004\001\003O\003A\000\000\004$\003\242\0009\000\000\003B\000\179\004\002\000\000\003P\000O\000\000\000\000\003\\\000{\000\164\006\150\000\000\003]\000\000\003\233\000\165\003^\003\243\0069\004(\000\000\005N\003_\001\t\003\183\001\230\000O\001 \000\000\001\213\000\000\000\164\000\000\001\t\000\000\001\214\004\209\000\165\000\000\004\002\005p\004\160\003\244\000\000\0043\000\000\0044\000\000\001\210\004\n\000\000\000\178\003?\004\018\003R\000\000\000\000\000\000\000\000\000\000\000\000\004*\003[\000\000\005q\005L\005M\000\000\003\235\000\000\000p\001\232\000\000\000\178\000\000\002\217\000\000\004\000\000\000\000y\003\\\000{\005\012\000\000\005p\003]\005\215\004\n\003\152\003^\000\000\004\018\000\000\000\000\000\000\003_\000\000\003\189\000\000\004*\001 \000\000\001\233\000\000\003\237\003\007\000\000\000\000\005q\005L\005M\000\000\000\000\000\000\004\001\003O\003A\000\000\000\000\003\242\000\000\001\210\003B\000\179\004\002\003?\003P\003R\000\000\005p\000\000\000\000\000\000\001\235\000\000\000\000\000\179\003\233\001 \000\180\004\149\000\000\000\000\000p\000\000\005\213\005N\000\000\002\217\001\227\004\000\002\014\000y\005q\005L\005M\001\t\000\179\000\179\004\225\001\228\000\180\000\000\006\145\004\160\003\244\006\146\004\005\004\151\006\153\000\000\000\181\004\n\000\000\001\023\005p\004\018\000\000\003\007\000\000\000\000\000\000\000\000\000\000\004*\003[\0005\004\001\000\000\003A\005N\003\235\000\000\000\181\000\000\003B\001\238\000\000\000\000\005q\005L\005M\000\000\003\\\000\000\000\000\000\000\000\000\003]\000\000\003\233\000\000\003^\001 \0005\000\000\000\000\000\000\003_\000\000\000\000\000\000\000\000\001 \000\000\000\000\000\000\003\237\000\000\001\t\000\000\0005\004\227\000\000\000\000\005N\000\000\004\160\003O\001\240\000\000\000\000\003\242\000\000\001\210\000\000\000\179\004\002\003?\003P\003R\000\000\0006\000\000\001\241\000\000\000\000\000N\000\000\000\000\000\000\000\161\002A\004\149\003\235\000\000\000p\000\000\000\000\000\000\005\230\002\217\000\000\004\000\000\000\000y\000\000\000\000\001\210\000N\0006\005N\001\211\000\161\0026\000\000\001\212\000\000\003\244\000\000\004\005\004\151\000\000\000\000\000\000\004\n\000\000\0006\000\000\004\018\003\237\003\007\000\000\000\000\000\000\000\000\000\000\004*\003[\000\000\004\001\003O\003A\000\000\005\228\003\242\000\000\000\000\003B\000\179\004\002\000\000\003P\000O\000\000\000\000\003\\\000\000\000\164\0009\000\000\003]\000\000\003\233\000\165\003^\004\149\000\000\000\000\000\000\000\000\003_\000\000\000\000\001\230\000O\001 \000\000\001\213\000\000\000\164\000\000\001\t\000\000\001\214\006j\000\165\0009\000\000\006 \004\160\003\244\000\000\004\005\004\151\000\000\000\000\001\210\004\n\000\000\000\178\003?\004\018\003R\0009\000\000\000\000\000\000\000\000\000\000\004*\003[\006r\000\000\000\000\000\000\000\000\003\235\000\000\000p\001\232\000\000\000\178\000\000\002\217\004\b\0042\000\000\000y\003\\\000\000\000\000\000\000\000\000\003]\006%\000\000\000\000\003^\000\000\000\000\000\000\000\000\000\000\003_\000\000\000\000\000\000\000\000\001 \000{\001\233\000\000\003\237\003\007\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\001\003O\003A\004\022\000\000\003\242\000\000\001\210\003B\000\179\004\002\003?\003P\003R\000\000\000{\000\000\000\000\000\000\001\235\000\000\000\000\000\179\003\233\000\000\000\180\004\149\000\000\000\000\000p\000\000\004Q\000{\000\000\002\217\001\227\004\000\001\237\000y\000\000\000\000\000\000\001\t\000\179\000\179\000\000\001\228\000\180\004a\000\000\000\000\003\244\000\000\004\005\004\151\000\000\000\000\000\181\004\n\000\000\000\000\000\000\004\018\000\000\003\007\000\000\000\000\000\000\000\000\000\000\004*\003[\000\000\004\001\000\000\003A\000\000\003\235\000\000\000\181\000\000\003B\001\238\000\000\000\000\000\000\000\000\000\000\000\000\003\\\000\000\000\000\000\000\000\000\003]\000\000\003\233\000\000\003^\000\000\000\000\000\000\000\000\000\000\003_\000\000\000\000\000\000\000\000\001 \000\000\000\000\000\000\003\237\000\000\001\t\000\000\000\000\006x\000\000\000\000\000\000\000\000\004\160\003O\001\240\000\000\000\000\003\242\000\000\001\210\000\000\000\179\004\002\003?\003P\003R\000\000\000\000\000\000\001\241\000\000\000\000\000\000\000\000\006\166\000\000\000\000\000\000\003\243\003\235\000\000\000p\000\000\000\000\000\000\000\000\002\217\004\b\0042\000\000\000y\000\000\000\000\000N\000N\000\000\000\000\000\170\000\161\0023\000\000\000\000\000\171\003\244\000\000\0043\000\000\0044\000\000\000\000\004\n\000\000\000\000\000\000\004\018\003\237\003\007\000\000\000\000\000p\000\000\000\000\004*\003[\000\000\004\001\003O\003A\000y\000\000\003\242\000\000\000\000\003B\000\179\004\002\000\000\003P\000\000\000\000\000\000\003\\\000\000\000\000\000\000\000\000\003]\000\000\003\233\000\000\003^\004\149\000\000\000\000\000\000\000\000\003_\000\000\000\000\000O\000O\001 \000\000\000\000\000\164\000\164\000\000\001\t\000\000\000\000\000\172\000\165\000\000\000\000\000\000\000\000\003\244\000\000\004\005\004\151\000\000\000\000\001\210\004\n\000\000\004\169\003?\004\018\003R\000\000\000\000\000\000\006\142\000\000\000\000\004*\003[\000\000\000\000\006\154\000\000\000\000\003\235\000\000\000p\001\t\000\178\000\178\000\000\002\217\000\000\0042\000\000\000y\003\\\000\000\000\000\000\000\000\000\003]\000\000\000\000\000\000\003^\000\000\000\000\000\000\000\000\000\000\003_\000\000\000\000\000\000\000\000\001 \000\000\000\000\000\000\003\237\003\007\000\000\000\000\000p\000\000\000\000\000\000\000\000\000\000\004\001\003O\003A\000y\000\000\003\242\000\000\001\210\003B\000\179\004\002\003?\003P\003R\000\000\000\000\000\000\000\000\000\000\000p\000\000\000\000\000\000\003\233\000\000\0046\003\243\000\000\000y\000p\000\000\000\000\000\000\000\000\002\217\000\000\004\000\000\000\000y\000\000\000\000\000N\001\t\000\179\000\179\000\170\000\180\000\180\000\000\000\000\000\171\003\244\000\000\0043\000\000\0044\000\000\000\000\004\n\000\000\000\000\000\000\004\018\000\000\003\007\000\000\000\000\006\142\000\000\000\000\004*\003[\000\000\004\001\006\149\003A\000\000\003\235\000\181\000\181\001\t\003B\000\000\000\000\000\000\000\000\000\000\000\000\000\000\003\\\000\000\000\000\006\142\000\000\003]\000\000\003\233\006\145\003^\006\144\006\146\000\000\000\000\000\000\003_\001\t\000\000\000O\001\023\001 \000\000\000\000\000\164\003\237\000\000\001\t\000\000\000\000\000\172\000\000\000\000\000\000\000\000\000\000\003O\000\000\000\187\000\000\003\242\000\000\001\210\000\000\000\179\004\002\003?\003P\003R\000\198\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001 \003\255\004\171\003\235\000\000\000p\000\000\000\178\000\000\000\000\002\217\000\000\004\000\000\000\000y\000\000\000\000\000N\000\000\000\000\000\000\000\170\000\000\000\000\000\000\000\000\000\171\003\244\000\000\0043\000\000\004\173\000\000\000\000\004\n\000\000\000\000\000\000\004\018\003\237\003\007\000\000\000\000\000\000\000\000\000\000\004*\003[\000\000\004\001\003O\003A\000\000\000\000\003\242\000\000\000N\003B\000\179\004\002\001D\003P\000\000\001P\000\000\003\\\000\000\000\000\000\000\000\000\003]\000\000\003\233\006\145\003^\004\003\006\146\000\000\000\000\000\000\003_\000\000\000\000\000O\001\023\001 \000\000\000\000\000\164\000\000\000\000\001\t\000\179\000\000\000\172\000\180\000\000\000\000\006\145\000\000\003\244\006\146\004\005\004\006\000\000\000\000\001\210\004\n\000\000\001\023\003?\004\018\003R\000\000\000\000\000\000\000\000\000\000\000\000\004*\003[\000\000\000O\001 \004\t\001F\003\235\000\181\000p\000\000\000\178\001G\000\000\002\217\000\000\004\000\000\000\000y\003\\\000\000\000\000\000\000\000\000\003]\000\000\000\000\000\000\003^\001 \000\000\000\000\000\000\000\000\003_\000\000\000\000\000\000\000\000\001 \000\000\000\000\000\000\003\237\003\007\000\000\000\000\000\000\000\000\000\000\001V\000\000\000\000\004\001\003O\003A\000\187\000\000\003\242\000\000\001\210\003B\000\179\004\002\003?\003P\003R\000\200\000\000\000\000\000\000\000\000\000p\000\000\000\000\000\000\003\233\000\000\000\000\004\003\000\000\000y\000p\000\000\000\000\000\000\000\000\002\217\000\000\004\000\000\000\000y\000\000\000\000\000N\001\t\000\179\000\000\000\170\000\180\000\000\000\000\000\000\000\171\003\244\000\000\004\005\004\006\000\000\000\000\000\000\004\n\000\000\000\000\000\000\004\018\000\000\003\007\000\000\000\000\000\000\000\000\000\000\004*\003[\000\000\004\001\000\000\003A\000\000\003\235\000\181\000\000\000\000\003B\000\179\000\000\000\000\001W\000\000\000\000\000\000\003\\\000\000\000\000\006\142\000\000\003]\000\000\003\233\000\000\003^\006\152\000\000\000\000\000\000\000\000\003_\001\t\000\000\000O\000\000\001 \000\000\000\000\000\164\003\237\000\000\001\t\000\000\000\000\000\172\000\000\000\000\000\000\000\000\000\000\003O\000\000\000\187\000\000\003\242\000\000\001\210\000\000\000\179\004\002\003?\003P\003R\000\202\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001Z\000\000\000\000\000\000\004\003\003\235\000\000\000p\000\000\000\178\000\000\000\000\002\217\000N\004\000\000\000\000y\000\170\001[\000\000\000\000\000\000\000\171\001\149\000\000\000\000\000\000\001]\000\000\003\244\000\000\004\005\004\006\001^\000\000\000\000\004\n\000\000\000\000\000\000\004\018\003\237\003\007\000\000\000\000\000\000\000\000\000\000\004*\003[\000\000\004\001\003O\003A\000\000\000\000\003\242\000\000\000\000\003B\000\179\004\002\000p\003P\000\000\000\000\000\000\003\\\000\000\004}\000\000\000y\003]\000\000\003\233\000\000\003^\004v\000\000\000O\000\000\000\000\003_\000\000\000\164\000\000\000\000\001 \000\000\000\000\000\172\000\000\000N\001\t\000\179\000\000\000\170\000\180\000\000\000\000\006\145\000\171\003\244\006\146\004\005\004x\000\000\000\000\001\210\004\n\000\000\001\023\003?\004\018\003R\000\000\000\000\000\000\000\000\000\000\000\000\004*\003[\000\000\000\000\000\000\000\178\000\000\003\235\000\181\000p\000\000\000\000\000\000\002a\002\217\000\000\004\000\000\000\000y\003\\\002k\000\000\000\000\000\000\003]\000\000\000\000\001\t\003^\001 \000\000\000\000\000\000\000\000\003_\000\000\002d\000O\000\000\001 \000\000\000\000\000\164\003\237\003\007\000\000\000\000\000\000\000\172\000\000\000\000\000\000\000\000\004\001\003O\003A\000\187\000\000\003\242\000\000\001\210\003B\000\179\004\002\003?\003P\003R\000\204\000\000\000\000\000\000\004u\000\000\000\000\000\000\000\000\003\233\000\000\000\000\004v\000\000\000\000\000p\000\000\000\178\000\000\000\000\002\217\000\000\004\000\000\179\000y\000\000\000\180\000N\001\t\000\000\000\000\000\170\000\000\000\000\000\000\000\000\000\171\003\244\000\000\004\005\004x\000\000\000\000\000\000\004\n\000\000\000\000\000\000\004\018\000\000\003\007\000\000\000\000\000\000\000\000\000\000\004*\003[\000\181\004\001\000\000\003A\000\000\003\235\000\000\000\000\000\000\003B\000\000\000\000\000\000\000\000\002l\000\000\000\000\003\\\000\000\000\000\000\000\000\000\003]\000\000\003\233\000\000\003^\000\000\000\000\000\000\000\000\000\000\003_\000\000\000\000\000O\000\000\001 \000\000\002m\000\164\003\237\002e\001\t\000\179\002f\000\172\000\180\000\187\000\000\000\000\000\000\003O\001\023\000\000\000\000\003\242\000\000\001\210\000\206\000\179\004\002\003?\003P\003R\000\000\000\000\000\000\004\137\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\138\003\235\000\181\000p\000\000\000\178\000\000\000\000\002\217\000N\004\000\000\000\000y\000\170\000\000\001 \000\000\000\000\000\171\000\000\000\000\000\000\000\000\000\000\000\000\003\244\000\000\004\005\004\140\000\000\000\000\000\000\004\n\000\000\000\000\000\000\004\018\003\237\003\007\000\000\000\000\000\000\000\000\000\000\004*\003[\000\000\004\001\003O\003A\000\187\000\000\003\242\000\000\000\000\003B\000\179\004\002\000p\003P\000\000\000\208\000\000\003\\\000\000\004\135\000\000\000y\003]\000\000\003\233\000\000\003^\004v\000\000\000O\000\000\000N\003_\000\000\000\164\000\161\0022\001 \000\000\000\000\000\172\000\000\000\000\001\t\000\179\000\000\000\000\000\180\000\000\000\000\000\000\004\148\003\244\000\000\004\005\004x\000\000\000\000\001\210\004\n\000\000\000\000\003?\004\018\003R\000\000\000\000\000\000\000\000\000\000\000\000\004*\003[\000\000\000\000\000\000\000\178\000\000\003\235\000\181\000p\000\000\000\000\000\000\002a\002\217\000\000\004\000\000\000\000y\003\\\002k\000\000\000\000\000\000\003]\000\000\000O\001\t\003^\000\000\000\000\000\164\000\000\000\000\003_\000\000\002d\000\165\000\000\001 \000\000\000\000\000\000\003\237\003\007\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\001\003O\003A\000\187\000\000\003\242\000\000\001\210\003B\000\179\004\002\003?\003P\003R\000\222\000\000\000\000\000\000\000\000\000\000\000\178\000\000\000\000\003\233\006n\000\000\004\149\000\000\000\000\000p\000\000\000\000\000\000\000\000\002\217\000N\004\000\000\179\000y\000\170\000\180\000\000\001\t\000\000\000\171\000\000\000\000\000\000\000\000\000\000\004\153\003\244\000\000\004\005\004\151\000\000\000\000\000\000\004\n\000\000\000\000\000\000\004\018\000\000\003\007\000\000\000\000\000\000\000\000\000\000\004*\003[\000\181\004\001\000\000\003A\000\000\003\235\000\000\000\000\000\000\003B\000\000\000\000\000\000\000\000\002l\000\000\000\000\003\\\000\000\000\000\000\000\000\000\003]\000\000\003\233\000\000\003^\000\000\000\000\000O\000\000\000\000\003_\000\179\000\164\000\000\000\180\001 \000\000\002r\000\172\003\237\002e\001\t\000\000\002f\000\000\000\000\000\187\000\000\000\000\000\000\003O\001\023\000\000\000\000\003\242\000\000\001\210\000\224\000\179\004\002\003?\003P\003R\000\000\000\000\000\000\000\181\000\000\000\000\000\000\000\000\000\000\000\000\006z\000\178\004\149\003\235\000\000\000p\000\000\000\000\000\000\000\000\002\217\000N\004\000\000\000\000y\000\170\000\000\001 \000N\000\000\000\171\000\000\001D\000\000\000\000\001P\000\000\003\244\000\000\004\005\004\151\000\000\000\000\000\000\004\n\000\000\000\000\000\000\004\018\003\237\003\007\000\000\000\000\000\000\000\000\000\000\004*\003[\000\000\004\001\003O\003A\000\000\000\000\003\242\000\000\000\000\003B\000\179\004\002\000\000\003P\000\000\000\000\000\000\003\\\000\000\000\000\000\000\000\000\003]\000\000\003\233\000\000\003^\006o\000\000\000O\000\000\000\000\003_\000\000\000\164\000\000\000O\001 \000\179\001F\000\172\000\180\001\147\001\t\000\000\001G\000\000\000\000\000\000\000\000\000\000\000\000\003\244\000\000\004\005\006q\000\000\000\000\001\210\004\n\000\000\000\000\003?\004\018\003R\000\000\000\000\000\000\000\000\000\000\000\000\004*\003[\000\181\000\000\006}\000\178\000\000\003\235\001\150\000p\000\000\000\000\001V\000\000\002\217\000\000\004\000\000\000\000y\003\\\000\000\000\000\000\000\000\000\003]\000\000\000\000\000\000\003^\000\000\000\000\000\000\000\000\000\000\003_\000\000\000\000\000\000\000\000\001 \000\000\000\000\000\000\003\237\003\007\000\000\000\000\000\000\000\000\000\000\002/\000\000\000\000\004\001\003O\003A\000\000\000\000\003\242\000\000\001\210\003B\000\179\004\002\003?\003P\003R\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\003\233\000\000\000\000\006o\000\000\000\000\000p\000\000\000\000\000\000\000\000\002\217\000\000\004\248\000\179\000y\000N\000\180\000\000\001\t\000\170\000\179\000\000\000\000\001W\000\174\000\000\000\000\003\244\000\000\004\005\006q\000\000\000\000\000\000\004\n\000\000\001\174\001\210\004\018\000\000\003\007\001\211\000\000\000\000\000\000\001\212\004*\003[\000\181\004\001\000\000\003A\000\000\003\235\000\000\000\000\000\000\003B\001\153\000\000\000\000\000\000\000\000\000\000\000\000\003\\\000\000\000\000\000\000\000\000\003]\000\000\003\233\000\000\003^\000\000\000\000\000\000\000\000\000\000\003_\000O\000\000\001Z\000\000\001 \000\164\000\000\000\210\003\237\000\000\001\t\000\172\000\000\000\000\000\000\001\b\000\000\000\000\000\000\003O\001[\000\000\001\230\003\242\002L\001\163\001\213\000\179\004\002\001]\003P\000\000\001\214\000\000\000\000\001^\000\000\000\000\000\000\000p\000\000\000\000\000\000\000\000\006o\003\235\000\000\000\178\000y\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\231\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\232\003\244\000\000\004\005\006q\000\000\000\000\000\000\004\n\000\000\000\000\000\000\004\018\003\237\004\249\000\000\000\000\000\000\000\000\000\000\004*\003[\000\000\000\000\003O\000\000\000\000\000\000\003\242\000\000\000\000\001\233\000\179\004\002\001\210\003P\000\000\000\000\003?\003\\\003R\000\000\000\000\002a\003]\000\000\000\000\000\000\003^\003\243\002k\000\000\000\000\000\000\003_\000\000\000p\001\t\000\000\001 \000\000\002\217\001\235\004\248\000\179\000y\002d\000\180\000\000\000\000\000\000\000\000\000\000\000\000\003\244\000\000\004\252\000\000\001\227\003\129\002\017\004\n\000\000\000\000\000\000\004\018\000\179\000\000\000\000\001\228\000\000\003\007\000\219\004*\003[\000\000\000\000\000\000\000\000\000\181\004\001\000\000\003A\000\000\000\000\000\000\000\000\001\210\003B\000\000\002\028\003?\003\\\003R\000\000\000\000\002\020\003]\000\000\000\000\000\000\003^\000\000\003\233\000\000\001\238\000\000\003_\000\212\000p\000\000\000\000\001 \000\000\002\217\000\000\004\248\000\000\000y\000N\000\000\000\000\001\t\000\170\000\000\000\000\000\000\000\183\000\171\000\000\000\000\000\220\000\000\000\000\000\000\000\214\000\000\000\000\000\000\000\000\000\000\000\000\000\185\000\000\003\007\000\000\000\000\000\000\001\240\002l\000\000\000\000\000\000\004\001\000\000\003A\000\000\003\235\000\000\000\000\000\000\003B\000\000\001\241\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\235\000\000\003\233\002e\000\000\000\000\002f\000\000\000\000\000N\000\000\000O\000\000\003?\001\023\003R\000\164\000\000\000\000\003\237\004\251\001\t\000\172\000\000\000\000\000\000\000\000\000\000\000\000\000\000\003O\000p\000\000\000\000\003\242\000\000\003\157\000\000\000\179\004\002\000y\003P\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001 \000\000\003\243\003\235\000\000\000\178\000\000\000\000\004\187\000\000\000N\000\000\000\000\003\188\003?\000\000\003R\000\000\000\000\000\000\000\000\000\000\003\194\000\000\003A\000\000\000\000\003\244\000\000\004\252\003B\000\000\000p\000\000\004\n\000\000\000\000\003\157\004\018\003\237\004\254\000y\000\000\000\000\000\000\004\190\004*\003[\000\000\004\192\003O\000\000\000\000\000\000\003\242\000\000\000\000\000\000\000\179\004\002\000\000\003P\004\199\000\000\001\t\003\\\000\000\003\188\000\000\000\000\003]\000\000\000\000\000\000\003^\003\243\003\194\000\000\003A\000N\003_\000\000\000\000\000\170\003B\001 \000\000\000\000\000\174\000\000\000\179\004\196\000\000\000\180\000\000\003W\000\000\000\000\001\012\004\190\003\244\000p\004\252\004\192\000\000\000\000\003\157\004\n\000\000\000\000\000y\004\018\000\000\000\000\000\000\000\000\000\000\000\000\001\t\004*\003[\000\000\000N\000\000\000\000\000\181\000\161\0021\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\003\188\000\000\003\\\000\000\000\000\000\000\000\000\003]\000\000\003\194\003O\003^\000\000\000\000\000\164\000\000\000\210\003_\000\179\004D\000\172\003P\001 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\003\195\000\000\004n\004>\000\187\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\226\000\000\000\000\001\t\000O\000\000\000N\000\000\000\178\000\164\003?\000\000\003R\000\000\000\000\000\165\003O\000\000\000\000\004E\000\000\000\000\000\000\004\198\000\179\004D\000\000\003P\000p\000\000\000\000\004_\003[\003\157\000\000\000N\000\000\000y\000\000\000\170\000\000\003\243\000\000\000\000\000\174\000N\000\000\000\000\000\000\000\170\003\\\000\178\000\000\000\000\000\171\003]\000\000\000p\004\189\003^\000\000\000\000\000\000\003\188\000\000\003_\000y\000\000\000\000\000\000\001 \000\000\003\194\004E\003A\000\000\000\000\004M\000\000\000N\003B\000\000\000\000\000\170\000\000\004_\003[\000\000\000\174\000\000\000\000\000\000\000\000\000\179\004D\004\190\000\180\000\000\000\000\004\192\000\000\000O\000\000\000\000\003\\\000\000\000\164\000\000\000\210\003]\000\000\000O\000\172\003^\001\t\000\000\000\164\000\000\000\000\003_\000\000\000\219\000\172\000\000\001 \000\000\000\000\000\000\000\181\000N\000\000\000\000\000\000\000\170\000\000\000\000\000\179\000\000\000\174\000\180\000\000\000\000\004E\001\t\000\000\000O\004M\000\000\000\178\000\000\000\164\000p\000\210\000\000\004_\000\000\000\172\000\212\000\178\000\000\000y\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000N\000\000\000\000\000\181\000\161\0020\000\000\0029\000\183\001\012\000\000\000\000\000\220\000\000\000\000\000\000\000\214\000\000\000\000\000\000\000\000\000\000\000\000\000\185\000\178\001 \000\000\000O\003O\000\000\000\000\000\000\000\164\000\000\000\210\000\000\000\179\004D\000\172\003P\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\n\000\000\003\243\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\179\000O\000\000\000\180\001\t\000\000\000\164\000\000\000\000\000\178\000\179\000\000\000\165\000\180\000\000\000N\000\000\000\000\000\000\001D\004E\000\000\001P\000\000\004M\000\000\000\000\000\000\001\014\000\000\000\000\000\000\004_\003[\000\000\000\181\001\n\000p\001\012\000\000\000\000\000\000\000\000\000\000\000\179\000\181\000y\000\180\000\178\000\000\000\000\003\\\000\000\001\020\000\000\000\000\003]\000\000\000\000\000\000\003^\001\023\000\000\000\000\000\212\000\000\003_\000\000\000\000\000\000\000\000\001 \001\014\000\000\000\000\000\000\000\000\000\000\000\000\000\181\000\000\000O\000N\000\183\001F\000\000\001D\000\220\000\000\001P\001G\000\214\000\000\002=\000\179\000N\000\000\000\180\000\185\001D\001 \000\000\001P\000\000\000p\000\000\000\000\000\000\000\212\000\000\000\000\000\000\000\000\000y\000\000\000\000\000\000\000p\000\000\000\000\000\000\001\135\001\014\001\t\000\000\000\000\000y\000\183\001V\000\181\000\000\000\220\000\000\000\179\000\000\000\214\000\180\000\000\000\000\000\000\000\000\000\000\000\185\000\000\000\000\000\000\000\000\001\020\000O\000\000\000\000\001F\000\000\000\000\000\000\001\023\000\000\001G\000\212\000\000\000\000\000O\000N\000\000\001F\000\000\001D\000\000\000\181\001P\001G\000\000\000\000\000\000\000\000\000\000\000\000\000\183\000\000\000\000\000\000\000\220\000\000\000\000\000p\000\214\000\000\000\000\001\135\000\000\001\t\000\000\000\185\000y\001 \001V\000\000\000\000\000\000\000\000\000\000\001\135\000\000\001\t\000\000\000\000\000\000\000\000\001V\000\000\000\000\000N\000\000\000\179\000\000\000\170\001W\000\000\000\000\000\000\000\174\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000O\000N\000\000\001F\000\000\001D\000N\000\000\001P\001G\000\170\001\136\001\137\000\000\000\000\000\171\000N\000\000\000\000\000\000\000\170\000\000\000\000\000p\000\000\000\174\000\000\000\000\000\000\000\000\000\000\000\000\000y\000\000\000\000\000\000\001X\000\000\001Y\000\000\001\135\000\000\001\t\000\000\000\000\000\000\001\023\001V\001Z\000O\000\000\000\000\000\179\000\000\000\164\001W\000\210\000\000\000\000\000\000\000\172\000\000\000\000\000\000\000\000\000\179\001[\000O\001W\000\000\001F\001\\\000O\000\215\000\000\001]\001G\000\164\001\136\001\218\000\000\001^\000O\000\172\000\000\001 \001\127\000\164\000\000\000\210\000\000\001\136\003F\000\172\000\000\000\000\000\178\000\000\000\000\000\000\000\000\000\000\000\000\001X\000\000\001Y\001b\001\135\000\000\001\t\000\000\000\000\000\000\001\023\001V\001Z\001X\000\000\001Y\000\178\000\000\000\000\000\000\000N\000\000\000\000\001\023\001D\001Z\000\178\001P\000\000\000\179\001[\000\000\001W\000\000\000\000\001\\\000\000\000\000\000\000\001]\000\000\000\000\000p\001[\000\000\001^\000\000\000\000\001\\\001 \001\127\000y\001]\000\000\000\000\001\136\003\239\000\000\001^\000\000\000\000\000N\001 \001\127\000\000\000\161\000\163\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\179\000\000\001X\000\180\001Y\000\000\000\000\000\000\000O\000\000\000\000\001F\001\023\000\000\001Z\000\000\000\000\001G\000\179\000\000\000\000\001W\000\000\000\179\000\000\000\000\000\180\000\000\000\219\000\000\000\000\000\000\001[\000\179\000N\000\181\000\180\001\\\000\170\000\000\000\000\001]\000\000\000\174\001\136\004\012\000\000\001^\001\135\000O\001\t\001 \001\127\000\000\000\164\001V\000p\000\000\000\181\000\000\000\165\000\219\000\000\000\000\000\212\000y\000\000\000\000\000\181\001X\000\000\001Y\000\000\000\000\006+\000\000\000\000\000\000\000\000\001\023\000\000\001Z\000\000\000\183\000\000\000p\000\000\000\220\000\000\000\000\000\000\000\214\000\000\000\000\000y\000\000\000\178\000\212\000\185\001[\000O\006\b\000\000\000\000\001\\\000\164\000\187\000\210\001]\000\000\000\000\000\172\000\000\000\000\001^\000\000\000\183\000\228\001 \001\127\000\220\000\000\000\000\000\000\000\214\006\t\000\000\006\012\005L\005M\000\000\000\185\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\179\000N\001\t\001W\000\000\000\170\000\000\000\178\000\000\000\000\000\174\000N\000\000\000\000\000\000\000\170\000\000\000\000\000\000\000\000\000\174\000\000\000\000\000p\000\000\000\000\001\136\004G\000\000\000\000\000\000\001\t\000y\000p\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\179\000y\000\000\000\180\000N\000\000\000\000\000\000\000\170\000\000\001X\000\000\001Y\000\171\000\000\000\000\000\000\000\000\000\000\000\000\001\023\000\000\001Z\000\000\000\000\000\000\000O\000\000\005N\006.\000\000\000\164\000\000\000\210\000\000\000\181\000O\000\172\000\000\000\000\001[\000\164\000\000\000\210\000\000\001\\\000\000\000\172\000\000\001]\000\000\000\179\000\000\000\000\000\180\001^\000\000\000\000\000\000\001 \001\127\000\000\000N\000\000\000\000\000\000\000\170\000\000\001\t\000\000\000O\000\174\000\000\000\178\000\000\000\164\000\000\000\000\001\t\001.\000\000\000\172\000\000\000\178\000p\000\000\000\181\000\000\000\000\000\000\000\000\000N\000\000\000y\000\000\001D\000\000\000\000\001P\000\000\000\000\000N\000\000\000\000\002;\000\170\000\000\000\000\000\000\000\000\000\171\000\000\001\023\000p\000\000\000\212\000\000\000\178\000\000\000\000\000\000\000\000\000y\000\000\000\000\000N\000\000\000\000\000O\001D\000\000\000\000\001P\000\164\000\183\000\210\000\000\000\000\000\220\000\172\000\000\002\192\000\214\000\000\000\000\000\000\000\000\000p\000\000\000\185\0061\001 \000\000\000\000\000\000\000\000\000y\000O\000\179\000\000\001F\000\180\000\000\000\000\000\000\000\000\001G\000O\000\179\000\000\001\t\000\180\000\164\000\000\000\000\000\178\000\000\000\000\000\172\000\000\002\197\000\000\000\000\000\000\000\000\000\000\001.\000\000\000\000\000\000\000\000\000O\000\000\000\181\001F\000\000\001&\001\134\000\000\001\t\001G\000\000\000\179\000\181\001V\000\180\000\000\000\000\000\000\000N\000\000\0024\000\000\001D\000\178\000\000\001P\000\000\000\000\001\023\000\000\001(\000\212\000\000\000\000\000\000\000\000\000\000\000\000\001\023\000\000\000p\000\212\001\t\000\000\000\000\000\000\000\181\001V\000\000\000y\000\183\000\000\000\000\000\000\000\220\000\000\000\000\000\000\000\214\000\000\000\183\000\000\000\000\000\000\000\220\000\185\000\000\001 \000\214\000\179\000\000\000\000\000\180\000\000\000\000\000\185\000\000\001 \000\000\000\000\000\000\000\000\000\000\000\000\000O\000\000\000\000\001F\000\000\000\000\000\000\000\000\000\000\001G\000\187\000\000\000\000\001.\000\179\000\000\000\000\001W\000\000\000\000\000\181\000\230\000\000\000\000\000\179\000\000\000\000\000\180\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\0010\000\000\001U\000\000\001\t\000\000\000\000\000\000\001\023\001V\000\179\000\212\000\000\001W\000\000\000\000\000\000\000\000\000N\000\000\000\000\000\181\001D\000\000\000\000\001P\000\000\001X\000\000\001Y\000\183\000\000\000\000\000p\000\220\000\000\000\000\001\023\000\214\001Z\000p\000\000\000y\000\000\000\000\000\185\000\000\001 \000\000\000y\000\000\000\000\000N\000\000\000\000\000\000\001D\001[\000\000\001P\000\000\001X\001\\\001Y\000\000\000\000\001]\000\000\000\000\000\187\001\130\001\023\001^\001Z\000p\000\000\001 \001\127\000\000\000\000\000\232\000\000\000\000\000y\000O\000\000\000\000\001F\000\000\000\000\000\000\001[\000\000\001G\000\179\000\000\001\\\001W\000\000\000\000\001]\000\000\000\000\000\000\000\000\002a\001^\000\000\000\000\000\000\001 \001\131\002k\000\000\000\000\000\000\000\000\000\000\000O\001\t\000\000\001F\000\000\000\000\001\129\000\000\001\t\001G\002d\000\000\000\000\001V\000N\000\000\000\000\000\000\000\170\000\000\000\000\000\000\000\000\000\174\000\000\000\000\000\000\001X\000\000\001Y\000\000\000\000\000\000\000\000\000\000\000\000\000p\001\023\000\000\001Z\001\133\000\000\001\t\000\000\000N\000y\000\000\001V\000\161\002)\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001[\000\000\000\000\000N\000\000\001\\\000\000\000\170\000\000\001]\000\000\000\000\000\171\000\000\000\000\001^\000\000\000\000\000\000\001 \001\127\000\000\000\000\000O\000\000\000\000\000\000\000\000\000\164\000\000\000\210\000\000\000N\000\000\000\172\000\000\000\161\001;\000\000\000\000\000\000\000\179\000\000\000\000\001W\000\000\000N\000\000\000\000\000\000\000\170\000\000\000\000\000O\000\000\000\174\002l\000\000\000\164\000\000\000\000\000\000\000\000\000\000\000\165\001\t\000\000\000\000\000p\000O\000\178\000\000\000\000\000\000\000\164\000\179\000\000\000y\001W\000\000\000\172\002\245\000\000\000\000\002e\000\000\000\000\002f\000\000\000\000\000\000\000\000\001X\000\000\001Y\001\023\000\000\000\000\000O\000\000\000\178\000N\001\023\000\164\001Z\000\161\001>\000\000\000\000\000\165\000\000\000\000\000O\000\000\000\000\000\000\000\178\000\164\000\000\000\210\000\000\000N\001[\000\172\000\000\000\170\001X\001\\\001Y\000\000\000\174\001]\000\000\000\000\001 \000\000\001\023\001^\001Z\000\000\000\000\001 \001\127\000p\000\000\000\178\000\000\000\000\000\000\000\000\000\000\000\000\000y\000\000\001\t\000\179\001[\000\000\000\180\000\178\000\000\001\\\000\000\000\000\000\000\001]\000\000\000O\000\000\000\000\000\000\001^\000\164\000\000\000\000\001 \001\127\000\000\000\165\000\000\000\000\000\000\000\000\001\168\000\000\000\179\000\000\000O\000\180\000\000\000\181\000\000\000\164\000\000\000\210\000\000\000N\000\000\000\172\000\000\000\170\000\179\000\000\000\000\000\180\000\174\000\000\000\000\001\170\000\000\000\000\000\000\000\000\000\000\000\178\000\000\001\023\000N\000p\000\212\000\181\000\170\000\000\000\000\000\000\000\000\000\174\000y\000\000\001\t\000\179\000\000\000\000\000\180\000\178\000\000\000\181\000\000\000\183\000p\000\000\000\000\000\220\000\000\000\179\000\000\000\214\000\180\000y\000\000\000\000\000\000\000\000\000\185\000\000\001 \000\000\000\000\000\000\000\000\000\000\000\000\000O\000\000\000\000\000\181\000\000\000\164\000\000\000\210\000\000\000\000\001.\000\172\000\000\000\000\000\000\000\000\000\000\000\181\000\000\000\000\000\000\000O\000\187\000N\000\000\000\000\000\164\003?\000\210\003R\000N\000\000\000\172\000\234\000\170\002?\000\000\000\179\000\000\000\174\000\180\000\000\001\t\001\023\000\000\000p\000\212\000\178\000\000\000\000\000\000\000N\000p\000\000\000y\000\161\001A\000\179\000\000\000\000\000\180\000y\000\000\001\t\000\000\000\183\000\000\000\000\000\178\000\220\000N\000\000\000\181\000\214\000\161\001\195\000\000\000\000\000\000\000\000\000\185\000\000\001 \000\000\000\000\001.\000\000\000\000\000\000\000O\000\000\003A\000\181\000\000\000\000\000\000\000O\003B\000\000\000\000\000\000\000\164\000\000\000\210\000\000\000\000\000\000\000\172\000\000\000\000\002E\000\000\000\000\000\000\000\000\000\000\000\000\000O\001\023\000\000\000\000\000\212\000\164\000\000\000\000\000\000\000\000\000\000\000\165\000\000\000\000\001\t\000\179\000\000\000\000\000\180\000O\000\000\001\t\000\000\000\183\000\164\000\000\000\178\000\220\000\000\000\000\000\165\000\214\000\000\000\000\000\000\000\000\000\179\000\000\000\185\000\180\001 \000\000\000\000\001.\000\000\003W\000\000\000\178\001\012\000\000\000\181\000\000\001\210\000\000\000\000\000\000\003?\000\000\003R\000\000\000\000\000\000\000\000\000\000\001.\000\000\000\178\000\000\002I\000\000\000\000\000\181\000\000\000\000\000\000\000\000\001\023\000\000\000\000\000\212\000\000\003\226\004\222\000\000\000\000\000\000\000\000\001\210\000\000\003\021\000\000\003?\000\000\003R\000\000\000\000\003O\001\023\000\183\000\000\000\212\000\000\000\220\000\000\000\179\000\000\000\214\003P\000\000\000\000\000\000\000\179\000\000\000\185\000\180\001 \003\226\004o\001\230\000\183\003A\003Y\000\000\000\220\000\000\000\000\003B\000\214\000\000\000\000\000\000\000\000\000\179\000\000\000\185\000\180\001 \000\000\000\000\003*\000\000\003\233\000\000\000\000\000\000\000\000\000\181\000\000\000\000\000\000\000\000\000\179\001\210\001\230\000\180\003A\003?\001\020\003R\000\000\000\000\003B\000\000\000\000\003,\001\023\003[\000\181\000\000\000\000\000\000\000\000\001\023\000\000\000\000\000\212\003\233\000\000\000\000\000\000\000\000\003\226\004=\000\000\003\\\000\000\000\181\000\000\000\000\003]\000\000\000\000\000\000\003^\000\183\003\235\000\000\000\000\000\220\003_\000\000\000\000\000\214\000\000\001 \000\000\000\000\000\000\001\210\000\185\000\000\001 \003?\000\000\003R\000\000\000\000\000\000\001\230\000\000\003A\000\000\000\000\000N\000\000\000\000\003B\000\161\001\204\000\000\003\235\003\237\000\000\000\000\000\000\000\000\000\000\003\226\003\227\001\210\000\000\003\233\003O\003?\000\000\003R\003\242\000\000\000\000\000\000\000\179\000\000\000\000\003P\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\003\237\003\243\003\226\003\241\000\000\000\000\000\000\000\000\001\230\000\000\003A\003O\000\000\000\000\000\000\003\242\003B\000\000\000\000\000\179\000\000\000\000\003P\000O\000\000\000\000\003\244\000\000\000\164\003\235\000\000\003\233\000\000\000\000\000\165\000\000\003\243\000\000\000\000\001\230\000\000\003A\000\000\000\000\000\000\000\000\003[\003B\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\003\244\003\233\000\000\003\\\003\237\000\000\000\000\000\000\003]\000\178\000\000\000\000\003^\000\000\000\000\003O\000\000\000\000\003_\003\242\003[\000\000\000\000\000\179\003\235\000\000\003P\001\210\000\000\000\000\000\000\003?\000\000\003R\000\000\000\000\000\000\000\000\003\\\000\000\003\243\000\000\000\000\003]\000\000\000\000\000\000\003^\000\000\000\000\000\000\000\000\000\000\003_\000\000\003\235\003\226\004C\001\210\000\000\003\237\000\000\003?\000\000\003R\003\244\000\000\000\000\000\000\000\000\000\000\003O\000\000\000\000\000\000\003\242\000\000\000\000\000\000\000\179\000\000\000\000\003P\000\000\000\000\003[\000\000\003\226\004q\000\000\000\000\003\237\000\000\001\230\000\179\003A\003\243\000\180\000\000\000\000\000\000\003B\003O\003\\\000\000\000\000\003\242\000\000\003]\000\000\000\179\000\000\003^\003P\000\000\000\000\003\233\000\000\003_\000\000\000\000\003\244\000\000\000\000\001\230\000\000\003A\003\243\000\000\000\181\000\000\000\000\003B\000\000\001\210\000\000\000\000\000\000\003?\000\000\003R\003[\000\000\000\000\000\000\000\000\000\000\003\233\000\000\000N\000\000\000\000\003\244\000\170\000\000\000\000\000\000\000\000\000\174\003\\\000\000\000\000\000\000\004h\003]\000\000\000\000\000\000\003^\001\210\003\235\000\000\003[\001\211\003_\000\000\000\000\001\212\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\210\000\000\003\\\000\000\001\211\000\000\000\000\003]\001\212\000\000\000\000\003^\001\230\003\235\003A\000N\000\000\003_\003\237\000\170\003B\000\000\000\000\000\000\000\174\000\000\000\000\000O\000\000\003O\000\000\000\000\000\164\003\242\000\210\003\233\000\000\000\179\000\172\000\000\003P\000\000\000\000\000\000\000\000\000\000\000\000\001\230\000\000\003\237\000\000\001\213\000\000\000\000\003\243\000\000\000\000\001\214\000\000\000\000\003O\000\000\000\000\000\000\003\242\000\000\001\230\000\000\000\179\000\000\001\213\003P\000\000\000\000\000\178\000\000\001\214\000\000\000\000\003\244\000\000\000O\000\000\000\000\001\231\003\243\000\164\000\000\000\210\003\235\000\000\000\000\000\172\001\232\000\000\000\000\000\000\000\000\000\000\003[\000\000\001\165\000\000\002!\000\000\000\000\000\000\000\000\000\000\000\000\003\244\000\000\001\232\000\000\000\000\000\000\000\000\003\\\000\000\000\000\000\000\000\000\003]\001\210\001\233\003\237\003^\001\211\000\178\000\000\003[\001\212\003_\000\000\000\000\000\000\003O\000\000\000\000\000\000\003\242\000\000\000\000\001\233\000\179\000\000\000\000\003P\003\\\000\000\000\000\000\000\000\000\003]\000\000\001\235\000\000\003^\000\000\000\179\000\000\003\243\000\180\003_\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\227\006t\002\017\001\235\000\000\000\000\000\000\000\000\000\179\000\000\000\000\001\228\000\000\000\000\000\000\003\244\001\014\000\000\001\230\001\227\000\000\002\017\001\213\000\181\000\000\000\000\000\000\000\179\001\214\000\000\001\228\000\000\002\028\000\000\000\000\003[\000\000\002\030\002\020\000\000\000\000\000\000\000\179\000\000\000\000\000\180\000\000\001\238\000\000\000\000\000\000\000\000\000\212\003\\\000\000\002\019\000\000\002\020\003]\000\000\000\000\001\210\003^\000\000\001\232\001\211\001\238\000\000\003_\001\212\002 \000\183\000\000\000\000\000\000\000\220\000\000\000\181\000\000\000\214\000\000\001\210\000\000\000\000\000\000\001\211\000\185\000\000\000\000\001\212\001\240\000\000\000N\000\000\000\000\001\233\000\170\000\000\000\000\000\000\000\000\000\171\000\000\000\000\000N\001\241\000\212\000\000\000\170\001\240\000\000\000\000\000\000\000\174\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\241\000\183\001\235\001\230\000\000\000\220\000\000\001\213\000\000\000\214\000\000\000\000\000\000\001\214\000\000\000\000\000\185\000\000\001\227\000\000\002\017\000N\000\000\001\230\000\000\000\170\000\179\001\213\000\000\001\228\000\174\000\000\000\000\001\214\000O\000\000\000\000\000\000\000\000\000\164\002\023\000\000\000\000\000\000\000\000\000\172\000O\000\000\000\000\001\232\000\000\000\164\000\000\000\210\000\000\000\000\002\020\000\172\000\000\000\000\002\026\000\000\000\000\000\000\000\000\001\238\000N\000\000\000\000\001\232\000\170\000\000\000\000\000\000\000\000\000\174\000\000\000\000\000\000\000N\001\233\000\178\000\000\000\170\000\000\000\000\000\000\000O\000\174\000\000\000\000\000\000\000\164\000\178\000\210\000\000\000\000\000\000\000\172\000\000\001\233\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\240\000\000\000\000\001\235\000\000\000\000\000\000\000\000\000p\000\000\000\000\000\000\000\000\000\000\000\000\001\241\000\000\000y\000\000\001\227\000\000\002\017\000\000\001\235\000O\000\000\000\178\000\179\000\000\000\164\001\228\000\210\000\000\000\000\000\000\000\172\000\000\000O\000\000\001\227\000\000\002\017\000\164\000\000\000\210\000\000\000\000\000\179\000\172\000\000\001\228\000\000\000\000\000\000\000\000\000\000\000\000\002\020\000\179\000\000\000N\000\180\000\000\000\000\000\170\002\222\001\238\000\000\000\000\000\174\000\179\000\178\000N\000\180\000\000\000\000\000\170\002\020\000\000\000\000\002a\000\174\000\000\000\000\000\178\000\000\001\238\002k\000\000\000\000\000\000\000\000\000\000\000\181\001\t\000\000\000\000\000\000\002 \000\000\000\000\000\000\000\000\002d\000\000\000\181\002\239\000\000\000\000\001\240\000\000\000\179\000\000\000\000\000\180\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\241\000\000\000O\000\000\000\000\001\240\000\000\000\164\000\000\000\210\000\212\000\000\000\000\000\172\000O\002 \000\000\000\187\000\000\000\164\001\241\000\210\000\181\000\000\000\000\000\172\000\000\002\251\000\236\000\183\000\000\000\000\000\179\000\220\000\000\000\180\000\000\000\214\003c\000\000\003\003\000\000\000\000\000\000\000\185\000\179\000\000\000\000\000\180\000\178\000\000\000\212\000\000\000\000\000N\000\000\000\000\000\000\000\170\000\000\002 \000\178\000\000\000\174\000\000\000\000\000\000\000\181\000\000\000\000\000\183\000\000\000\000\002 \000\220\000\000\000\000\000\000\000\214\000\000\000\181\000\000\002l\000\000\000N\000\185\000\000\000\000\000\170\000\000\000\000\000\000\000\000\000\174\000\000\000\000\000\212\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\003\170\000\000\000\212\002e\000\000\000\000\002f\000\000\000\183\000\000\000\000\000\000\000\220\000O\001\023\000\000\000\214\000\000\000\164\000\000\000\210\000\183\003\n\000\185\000\172\000\220\000\000\000\179\000N\000\214\000\180\000\000\000\170\000\000\000\000\000\000\000\185\000\174\000\000\000\179\000\000\000\000\000\180\000O\000\000\000\000\000\000\000\000\000\164\000\000\000\210\000\000\000\000\001 \000\172\002 \000\000\000\000\000\000\000\000\000\178\000\000\000\181\000\000\000\000\000\000\000\000\000\219\000\000\000\000\000\000\000\000\000\000\000\000\000\181\000\000\000\000\000\000\000N\000\000\000\000\000\000\000\170\000\000\000\000\000\000\000\000\000\174\000N\000\000\000\178\000\212\000\170\000\000\000O\000\000\000\000\000\174\000\000\000\164\000\000\000\210\000\000\000\212\000\000\000\172\000\000\000\000\000\000\000\000\000\183\000\000\000\000\000\000\000\220\000\000\000\000\000\000\000\214\000\000\000\000\000\000\000\183\000\000\000\000\000\185\000\220\000N\000\000\000\000\000\214\000\170\000\000\000\000\000\000\000\000\000\174\000\185\000\000\000\000\003\162\000\178\000\000\000\000\000O\000\179\000\000\000\000\000\180\000\164\000\000\000\210\000\000\000\000\000O\000\172\000\000\000\000\000\000\000\164\000\000\000\210\000\000\000\000\000\000\000\172\000\000\000\000\000\000\000\000\003\174\000\000\000\000\002 \000\000\000\179\000\000\000\000\000\180\000\000\000\181\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\178\000\000\000O\000\000\000\000\000\000\000\000\000\164\000\000\000\210\000\178\000\000\002 \000\172\000\000\000\000\000\000\000\000\000\212\000\181\000\000\000\000\000\000\000\000\000\000\000N\003\197\000\000\000\000\000\170\003\179\000\000\000\000\000\000\000\171\000\179\000\000\000\183\000\180\000\000\000\000\000\220\000\000\000\000\000\000\000\214\000\000\000\000\000\212\000\178\000N\000\000\000\185\000\000\000\161\001\207\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002 \000\000\000\000\000\000\000\183\000\000\000\000\000\181\000\220\000\000\000\000\000N\000\214\000\000\000\000\000\170\000\000\003\186\000\000\000\185\000\174\000\000\000\179\000\000\000\000\000\180\000\000\003\192\000O\000\000\000\000\000\000\000\179\000\164\000\000\000\180\000\212\000N\000\000\000\172\000\000\000\170\000\000\000\000\000\000\000\000\000\174\000\000\000\000\000\000\002 \000\000\000\000\000O\000\000\000\183\000\000\000\181\000\164\000\220\002 \000\000\000\000\000\214\000\165\000\000\000\000\000\181\000\000\000\000\000\185\000\179\000\000\000\000\000\180\000\178\000N\000O\000\000\000\000\000\170\000\000\000\164\000\000\000\210\000\174\000\212\000\000\000\172\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\212\000\000\000\000\000\219\000\178\003\199\000\000\000O\000\000\000\183\000\181\000\000\000\164\000\220\000\210\000\000\000\000\000\214\000\172\000\183\000\000\000\000\000\000\000\220\000\185\000\000\000\000\000\214\000\178\000\000\000\000\000N\000\000\000\000\000\185\000\170\000\000\000\000\000\000\000\212\000\174\000\000\000\000\000\000\000\000\000\000\000O\000\000\000\000\000\000\000\000\000\164\000N\000\210\000\178\000\000\000\170\000\172\000\183\000\000\000\000\000\174\000\220\000\000\000\179\000\000\000\214\000\180\000\000\000\000\000\000\000\000\000N\000\185\000\000\000\000\000\170\000\000\000\000\000\000\000\000\000\174\000\000\000\000\000\000\000\000\000N\000\000\000\000\000\179\000\170\000\000\000\180\000\178\000\000\000\171\000\000\000O\000\000\000\181\000\000\000\000\000\164\000\000\000\210\000N\000\000\000\000\000\172\000\161\003\023\000\000\000\000\000\179\000\000\000\000\000\180\000\000\000O\000\000\000\000\000\000\000\000\000\164\000\181\000\210\000\000\000\000\000\000\000\172\000\000\000\000\000\000\000\000\004\016\000\000\000\000\000\000\000O\000\179\000\000\000\219\000\180\000\164\000\178\000\210\000N\000\187\000\181\000\172\000\170\000\000\000O\000\000\000\000\000\174\000\000\000\164\000\238\000\000\000\000\000\000\004?\000\172\000\000\000\178\000\000\002 \000\000\000\000\000\000\000O\000\000\004\029\000\181\000\000\000\164\000\212\000\179\000\000\000\000\000\180\000\165\000N\000\000\000\178\000\000\000\170\000\000\000\000\000\000\000\000\000\174\000\000\000\000\000\000\000\183\000N\000\000\000\178\000\220\000\161\0036\000\212\000\214\000\000\002 \000\000\000\000\000\000\000\000\000\185\000O\000\181\000\000\000\000\000\000\000\164\000\178\000\210\000\000\000\000\000\183\000\172\004&\000\000\000\220\000\000\000\000\000\179\000\214\000\000\000\180\000\000\000\000\000\000\004A\000\185\000\000\000\000\000\000\000\000\000\212\000\000\000\000\004.\000\000\000\000\000\000\000O\000\179\000\000\000\000\000\180\000\164\000\000\000\210\002 \000N\000\178\000\172\000\183\000\170\000O\000\181\000\220\000\000\000\174\000\164\000\214\000\179\000\000\000\000\000\180\000\165\000\000\000\185\000\000\002 \000\000\000\000\000\000\000\000\000\000\000\179\000\181\000\000\000\180\000\000\000\000\000\000\000\000\000\000\000\212\000\000\000\000\000\178\000\000\000\219\000\000\000\000\000\000\000\000\000\179\000\000\000\181\000\180\000\000\000\000\000N\000\178\000\000\000\183\000\170\000\212\000\000\000\220\000\000\000\174\000\181\000\214\000\000\000\000\000\000\000O\000\000\000\000\000\185\000\000\000\164\000\000\000\210\000\000\000\183\000\212\000\172\000\000\000\220\000\181\000\000\000\000\000\214\000\000\000\000\000\179\000\000\000\000\000\180\000\185\000\000\000\000\000\000\000\000\000\183\000\000\000\000\000\000\000\220\000\000\000\000\000\000\000\214\000\000\000\000\000\000\000\000\000\000\000\187\000\185\000\000\000\000\000\178\000\219\000\000\000\000\000O\004K\000\000\000\240\000\181\000\164\000\179\000\210\000N\000\180\000\000\000\172\000\170\000\000\000\000\000\000\000\000\000\171\000\000\000\000\000\179\000\000\000\000\000\180\000\000\000\000\000\000\000\000\000N\000\000\000\000\000\000\000\170\000\212\002 \000\000\000\000\000\174\000\000\000\000\000\000\000\181\000N\000\000\000\000\000\000\000\170\000\178\000\000\000\000\000\000\000\174\000\183\000\000\000\000\000\181\000\220\000\000\000\000\000\000\000\214\000\000\006P\000\000\000\000\000\000\000\000\000\185\000\000\000\000\000\212\000\000\000\000\000N\000O\000\000\004X\000\170\000\000\000\164\000\000\000\179\000\174\000\000\000\180\000\172\000N\000\000\000\000\000\183\000\170\000\000\000\000\000\220\000O\000\174\000\000\000\214\000\000\000\164\000\000\000\210\000\000\000\000\000\185\000\172\006\182\000\000\000O\002 \000\000\000\000\000\000\000\164\000\000\000\210\000\181\000\000\000\000\000\172\000\000\000\178\000\000\000\000\000N\000\000\000\000\004]\000\170\000\000\000\000\000\000\000\179\000\174\000\000\000\180\000\000\000\000\000\000\000O\000\000\000\178\000\000\000\000\000\164\000\212\000\210\000\000\000\000\000\000\000\172\000\000\000O\000\000\000\000\000\178\000\000\000\164\000\000\000\210\002 \000\000\000\000\000\172\000\183\000N\000\000\000\181\000\220\000\170\000\000\000\000\000\214\000\000\000\174\000\000\000\000\000\000\000N\000\185\000\000\000\000\000\170\000\000\000\000\000\000\000\178\000\174\000\000\000\000\000O\000\000\000\000\000\000\000\000\000\164\000\212\000\210\000\000\000\178\000\000\000\172\000\000\000\000\000\000\000\000\000\179\000\000\000\000\000\180\000\000\000\000\000\000\000\000\000\000\000\183\000\000\000\000\000\000\000\220\000\000\004d\000\000\000\214\000\000\000\000\000\179\000\000\000\000\000\180\000\185\000O\000\000\000\000\000\000\000\000\000\164\000\178\000\210\000\000\000\179\000\181\000\172\000\180\000O\000\000\000\000\000\000\000\000\000\164\000\000\000\210\000\000\000\000\002 \000\172\000\000\000\000\000\000\000\000\000\000\000\181\000\000\000\000\000\000\000\000\000\000\000\000\006Q\000\000\000\000\000\179\000\000\000\000\000\180\000\181\000\000\000\000\000\178\000\000\000\000\000\000\000\000\000\000\000\179\000\000\000\000\000\180\000\000\000\187\000\212\000\178\000\000\000N\000\000\000\000\000\000\000\161\0039\001\002\000\242\000\000\000\000\000\000\000\212\000\000\000\181\000\000\000\000\000\183\000\000\000\000\006Q\000\220\000\000\000\000\000\000\000\214\000\000\000\181\000\000\000\000\000\179\000\183\000\185\000\180\000\000\000\220\000\000\000\000\000N\000\214\000\000\000\000\000\170\000\212\000\000\000\000\000\185\000\174\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\212\000\000\001\016\000N\000N\000\000\000\183\000\170\000\170\000\181\000\220\000O\000\174\000\174\000\214\000\179\000\164\000\000\000\180\000\183\000N\000\185\000\165\000\220\000\170\000\000\000\000\000\214\000\179\000\174\000\000\000\180\000\000\000\000\000\185\000\000\000\000\000N\000\212\000\000\000\000\000\161\003<\001\140\000\000\000\000\000\000\000\000\000O\000\000\000\181\000\000\000\000\000\164\000\000\000\210\001\157\000\183\000\178\000\172\000\000\000\220\000\000\000\181\000\000\000\214\000\000\000\000\000\000\000O\000O\000\000\000\185\000\000\000\164\000\164\000\210\000\210\000N\000\212\000\172\000\172\000\170\000\000\000\000\000\000\000O\000\174\000\000\000\000\000\000\000\164\000\212\000\210\000\000\000\178\000N\000\172\000\183\000\000\000\170\000\000\000\220\000O\000\000\000\174\000\214\000\000\000\164\000\000\000\000\000\183\000\000\000\185\000\165\000\220\000\178\000\178\000\000\000\214\000\000\000\000\000\000\000\000\000\000\000\000\000\185\000\000\000\000\000\000\000\000\000\000\000\000\000\178\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\179\000O\000\000\000\180\000\000\000\000\000\164\000\178\000\210\000\000\000\000\000\000\000\172\000\000\000\000\000\000\000\000\000\000\000\000\000O\000\000\000\000\000\000\000\000\000\164\000N\000\210\000\000\000\000\000\170\000\172\000\000\000\000\000\000\000\174\000\181\000\000\000\179\000\000\000\000\000\180\000\000\000N\000\000\000\000\000\000\000\170\000\000\000\178\000\000\000\000\000\174\000\000\000\000\000\000\000\000\000\000\000\000\000\179\000\179\000\000\000\180\000\180\000\000\000\000\001\177\000\178\000\000\000\000\000\000\000\000\000\000\000\181\000\000\000\000\000\179\000\000\000\000\000\180\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\179\001\221\000\000\000\000\000\000\000O\000\179\000\181\000\181\000\180\000\164\000\000\000\210\000\000\000\000\000\212\000\172\002\205\000\000\000\000\000\000\000\000\000O\000\000\000\181\000\000\000\000\000\164\000\000\000\210\000\000\000N\000\000\000\172\000\183\000\170\000\212\000\212\000\220\000\000\000\174\000\181\000\214\000\000\000\000\000\000\000\000\000\179\000\000\000\185\000\180\000\000\000\178\000\212\000\000\000\183\000\183\000\000\000\000\000\220\000\220\000\000\000\000\000\214\000\214\000\179\000\000\000\000\000\180\000\178\000\185\000\185\000\183\000\000\000\000\002\211\000\220\000\000\000\000\000\000\000\214\000\000\000\181\000\000\000\000\000\000\000\000\000\185\000\000\000\000\000\000\000\000\000\000\003\026\000\000\000\000\000\000\000O\000\000\000\000\000\181\000\000\000\164\000N\000\210\000\000\000\000\000\170\000\172\000\000\000\000\000\212\000\174\000N\000\000\000\000\000\000\000\170\000\000\000\000\000\000\000\000\000\174\000\000\000\000\000\000\000\000\000N\000\000\000\212\000\183\000\170\000\000\000\000\000\220\000\000\000\174\000\179\000\214\000\000\000\180\000\000\000\000\000\000\000\178\000\185\000\000\000\000\000\183\000\000\000\000\000\000\000\220\000\000\000\179\000\000\000\214\000\180\000\000\000\000\000\000\000\000\000\000\000\185\000\000\003\031\000\000\000\000\000\000\000O\000\000\000\000\000\181\000\000\000\164\000\000\000\210\000\000\000\000\000O\000\172\000\000\003#\000\000\000\164\000\000\000\210\000\000\000\000\000\181\000\172\000\000\000\000\000O\000\000\000\000\000\000\000\000\000\164\000\000\000\210\000\212\000N\000\000\000\172\000\000\000\170\000\000\000\000\000\000\000\000\000\174\000\000\000\000\000\000\000\000\000\178\000\000\000\212\000\000\000\183\000N\000\000\000\000\000\220\000\170\000\178\000\000\000\214\000\179\000\171\000\000\000\180\000\000\000\000\000\185\000\000\000\183\000\000\000\000\000\178\000\220\000\000\000\000\000\000\000\214\000\000\000\000\000\000\000\000\000\000\000\000\000\185\000\000\000\000\000\000\000\000\003I\000\000\000\000\000\000\000\000\000\000\000\000\000\181\000\000\000\000\000N\000O\000\000\000\000\000\170\000\000\000\164\000\000\000\210\000\174\000N\000\000\000\172\000\000\000\170\000\000\000\000\000\000\000\000\000\174\000O\000\000\000\000\000\000\000N\000\164\000\212\000\000\000\170\000\000\000\000\000\172\000\000\000\174\000\179\000\000\000\000\000\180\000\000\000\000\000\000\000\000\000\000\000\000\000\179\000\183\000\000\000\180\000\178\000\220\000\000\000\000\000\000\000\214\000\000\000\000\000\000\000\000\000\179\000\000\000\185\000\180\003\148\000\000\000\000\000\000\000O\000\178\000\000\000\181\000\000\000\164\003\230\000\210\000\000\000\000\000O\000\172\000\000\000\181\000\000\000\164\000\000\000\210\000\000\000\000\004\180\000\172\000\000\000\000\000O\000\000\000\000\000\181\000\000\000\164\000N\000\210\000\212\000\000\000\170\000\172\000\000\000\000\000\000\000\174\000N\000\000\000\212\000\000\000\170\000\000\000\000\000\178\000\000\000\174\000\000\000\183\000\000\000\000\000\000\000\220\000\212\000\178\000\000\000\214\000\000\000\183\000\000\000\000\000\000\000\220\000\185\000\179\000\000\000\214\000\180\000\178\000\000\000\000\000\000\000\183\000\185\000\000\000\000\000\220\000\000\000\000\000\000\000\214\000\000\000\000\000\179\000\000\000\000\000\180\000\185\000\000\000\000\000\000\000\000\004\213\000O\000\000\000\000\000\000\000\000\000\164\000\181\000\210\000\000\000N\000O\000\172\000\000\000\170\000\000\000\164\000\000\000\210\000\174\000\000\000\000\000\172\000\000\000\000\000\000\000\181\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\212\000\179\000\000\000\000\000\180\000\000\000\000\000\000\000\000\000\000\000\000\000\179\000\178\000\000\000\180\000\000\000\000\000\000\000\000\000\183\000\000\000\000\000\178\000\220\000\000\000\179\000\000\000\214\000\180\004\233\000\000\000\000\000\000\000\000\000\185\000\000\000\181\000\000\000\187\004\235\000O\000\000\000\000\000\000\000\000\000\164\000\181\000\210\000\000\000\244\000\000\000\172\000\000\004\237\000\000\000\000\000\000\000\000\000\000\000\000\000\181\000\000\000\000\000N\000\000\000\212\000\000\000\170\000\000\000\000\000\000\000\000\000\174\000N\000\000\000\212\000\000\000\170\000\000\000\000\000\000\000\000\000\174\000\000\000\183\000\000\000N\000\178\000\220\000\212\000\170\000\000\000\214\000\000\000\183\000\171\000\000\000\179\000\220\000\185\000\180\000\000\000\214\000\000\000\000\000\000\000\000\000\179\000\183\000\185\000\180\000\000\000\220\000\000\000\000\000\000\000\214\000\000\000\000\000\000\000\000\000\000\000\000\000\185\000\000\004\243\000\000\000\000\000\000\000O\000\000\000\000\000\181\000\000\000\164\005\004\000\000\000\000\000\000\000O\000\172\000\000\000\181\000\000\000\164\000\000\000\000\000\000\000\000\000N\000\172\000\000\000O\000\170\000\000\000\000\000\000\000\164\000\171\000\000\000\000\000\212\000\000\000\172\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\212\000\179\000N\000\000\000\180\000\178\000\170\000\000\000\000\000\183\000\000\000\171\000\000\000\220\000\000\000\178\000\000\000\214\000\000\000\183\000\000\000\000\000\000\000\220\000\185\000\000\000\000\000\214\000\178\005\018\000\000\000N\000\000\000\000\000\185\000\170\000\181\000\000\000\000\000\000\000\171\000\000\000\000\000N\000O\000\000\000\000\000\170\000\000\000\164\000\000\000\000\000\171\000N\000\000\000\172\000\000\000\170\000\000\000\000\000\000\000\000\000\171\000\000\000\000\000\212\000\000\000\000\000O\000\000\000\000\000\000\000\000\000\164\000\000\000\000\000N\000\000\000\000\000\172\000\170\000\000\000\000\000\000\000\183\000\171\000\000\000\000\000\220\000\000\000\179\000\178\000\214\000\180\000\000\000\000\000\000\000O\000\000\000\185\000\179\000\000\000\164\000\180\000\000\000\000\000\000\000\000\000\172\000O\000\000\000\000\000\000\000\179\000\164\000\178\000\180\000\000\000\000\000O\000\172\000\000\000\000\001d\000\164\000\181\000\000\000\000\000\000\000\000\000\172\000\000\000\000\003e\000\000\000\181\000\000\000\000\000\000\000\000\000\000\000\000\000O\000\000\000\178\000\000\000\000\000\164\000\181\000\000\000\000\000\000\000\000\000\172\000\212\000\000\000\178\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\212\000N\000\178\000\000\000\000\000\170\000\000\000\000\000\000\000\183\000\171\000\000\000\179\000\218\000\000\000\180\000\000\000\214\000\000\000\183\000\000\000\000\000N\000\218\000\185\000\178\000\170\000\214\000\000\000\000\000\000\000\171\000\187\000\000\000\185\000\000\000\179\000\000\000\000\000\180\000\000\000\000\000\000\000\246\000\000\000\000\000\000\000\181\000\000\000\000\000N\000\000\000N\000\000\000\170\000\000\000\170\000\000\000\000\000\171\000\000\000\171\000\000\000\000\000\000\000\179\000N\000O\000\180\000\000\000\170\000\181\000\164\000\000\000\000\000\171\000\000\000\179\000\172\000\000\000\180\000\000\000\000\000\000\000\000\000\000\000\000\000\179\000O\000\000\000\180\000\000\000\000\000\164\000\000\000\187\000\000\000\000\000\000\000\172\000\181\000\000\000\000\000\000\000\000\000\000\000\248\000\000\000\000\000\000\000\179\000\000\000\181\000\180\000\178\000\000\000O\000\000\000O\000\187\000\000\000\164\000\181\000\164\000N\000\000\000\000\000\172\000\170\000\172\000\250\000\000\000O\000\171\000\000\000\178\000\000\000\164\000\000\000\000\000\000\000\000\000\000\000\172\000\000\000\181\000\000\000N\000\187\000\000\000\000\000\170\000\000\000\000\000\000\000\000\000\171\000\000\000\000\000\252\000\187\000\000\000\000\000\178\000N\000\178\000\000\000\000\000\170\000\000\000\187\001`\000\000\000\171\000\000\000\000\000\000\000\000\000\000\000\178\000\000\001f\000\000\000\000\000\000\000\000\000\000\000\000\000N\000\000\000O\000\000\000\170\000\187\000\000\000\164\000\000\000\171\000\000\000\179\000\000\000\172\000\180\000N\001h\000\000\000\000\000\170\000\000\000\000\000N\000\000\000\171\000O\000\170\000\000\000\000\000\000\000\164\000\171\000\179\000\000\000\000\000\180\000\172\000\000\000\000\000\000\000\000\000\000\000O\000\000\000\000\000\000\000\181\000\164\000\000\000\178\000\000\000\000\000N\000\172\000\000\000\000\000\170\000\000\000\000\000\000\000\179\000\171\000\179\000\180\000\000\000\180\000O\000\181\000\000\000\000\000\000\000\164\000\178\000\000\000\000\000\000\000\179\000\172\000N\000\180\000\000\000O\000\170\000\000\000\000\000\000\000\164\000\171\000O\000\178\000\000\000\000\000\172\000\164\000\187\000\181\000\000\000\181\000\000\000\172\000\000\000\000\000\000\000\000\000\000\001j\000\000\000\000\000\000\000\000\000\000\000\181\000N\000\178\000\000\000\187\000\170\000\000\000O\000\000\000\000\000\171\000\000\000\164\000\000\000\000\001l\000\000\000\178\000\172\000\000\000\000\000\000\000\000\000\179\000\178\000\000\000\180\000\000\000\000\000\000\000\000\000\000\000\187\000O\000\187\000\000\000\000\000\000\000\164\000\000\000\000\000\000\000\000\001n\000\172\001p\000\179\000\000\000\187\000\180\000\000\000\000\000\000\000N\000\178\000\000\000\000\000\170\000\181\001r\000\000\000\000\000\171\000\179\000\000\000\000\000\180\000O\000\000\000\000\000N\000\000\000\164\000\000\000\170\000\000\000\000\000\000\000\172\000\171\000\178\000\181\000N\000\000\000\000\000\000\000\170\000\179\000\000\000\000\000\180\000\171\000\000\000\000\000\000\000\000\000\000\000\000\000\181\000\000\000\000\000\000\000\179\000\000\000\000\000\180\000\187\000N\000\000\000\179\000\000\000\170\000\180\000\000\000\178\000\000\000\171\001t\000\000\000O\000\000\000\000\000\181\000\000\000\164\000\000\000\000\000\000\000\000\000\187\000\172\000\000\000\000\000\000\000\000\000\000\000O\000\181\000\000\000\179\001v\000\164\000\180\000\000\000\181\000\000\000\187\000\172\000O\000p\000\000\000\000\000N\000\164\000\000\000\000\000\170\001x\000y\000\172\000N\000\171\000\000\000\000\000\170\000\179\000\178\000\000\000\180\000\171\000\187\000\000\000\000\000O\000\181\000\000\000\000\000\000\000\164\000\000\000\000\001z\000\000\000\178\000\172\000\187\000\000\000\000\000\000\000N\000\000\000\000\000\187\000\170\000\000\000\178\001|\000\000\000\171\000\179\000\181\000\000\000\180\001~\000N\000\000\000\000\000\000\000\170\000\000\000\000\000\000\000\000\000\171\000\000\000\000\000\000\000\000\000O\000\000\000\178\002a\000\187\000\164\000\000\000\000\000O\000\000\002k\000\172\000\000\000\164\000\000\001\243\000\181\001\t\000\000\000\172\000\000\000\000\000\000\000N\000\000\000\000\002d\000\170\000\000\000\000\000\187\000\000\000\171\000\179\000\000\000N\000\180\000O\000\000\000\170\000\000\001\245\000\164\000\000\000\171\000\000\000\000\000\178\000\172\000\000\000\179\000\000\000O\000\180\000\000\000\178\000\000\000\164\000\000\000\000\000\000\000\000\000\179\000\172\000\187\000\180\000\000\000\000\000\181\000\000\000\000\000\000\000\000\000\000\000\000\001\247\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\178\000\181\000\000\000\179\000\000\000O\000\180\000\000\000\000\000\000\000\164\000\000\000\000\000\181\000\000\000\178\000\172\000O\000\000\000\000\000\000\000N\000\164\000\000\000\000\000\170\000\000\000\000\000\172\000\000\000\171\000\000\000\187\000\000\000\000\000N\000\000\000\000\000\181\000\170\000\000\000\000\000\000\001\249\000\171\002l\000\000\000\000\000\179\000\187\000\000\000\180\000\178\000\000\000\000\000\000\000\179\000\000\000\000\000\180\001\251\000\187\000\000\000\000\000\178\000\000\000\000\000\000\000\000\000\000\004\025\000\000\001\253\002e\000\000\000\000\002f\000\000\000\000\000\000\000\000\000\000\000\000\000\181\001\023\000\179\000\187\000O\000\180\000\000\000N\000\181\000\164\000\000\000\170\000\000\000\000\001\255\000\172\000\171\000\179\000O\000\000\000\180\000\000\000N\000\164\000\000\000\000\000\170\000\000\000\000\000\172\000\000\000\171\000\000\000\000\000\000\000\000\000\000\000\181\000N\000\000\001 \000\000\000\170\000\000\000\000\000\000\000\000\000\171\000\187\000\000\000\000\000\178\000\181\000\000\000\179\000\000\000\187\000\180\000\000\002\001\000\000\000\000\000\000\000\000\000\000\000\178\000\179\002\003\000p\000\180\000\000\000\000\000\000\000O\000\000\000\000\000\000\000y\000\164\000\000\000\000\000\000\000\000\000\000\000\172\000\187\000\000\000\000\000O\000\181\000\000\000\000\000\000\000\164\000\000\000\000\002\005\000\000\000\000\000\172\000\187\000\181\000\000\000N\000O\000\000\000\000\000\170\000\000\000\164\000\000\002\007\000\171\000\000\000\000\000\172\000\000\000\000\000\000\000\000\000\178\000\000\000N\000\000\000N\000\000\000\170\000\000\000\170\000\000\000\000\000\171\000\000\000\171\000\000\000\178\000\179\000\187\000\000\000\180\002a\000\000\000\000\000p\000\000\000\000\000\000\002k\002\t\000\187\000\179\000\178\000y\000\180\001\t\000N\000\000\000\000\000\000\000\170\002\011\000\000\000\000\002d\000\171\000\000\000\000\000\000\000\000\000O\000\000\000\181\000\000\000\000\000\164\000\000\000\000\000N\000\000\000\000\000\172\000\170\000\000\000\000\000\000\000\181\000\171\000\000\000O\000\000\000O\000\000\000\000\000\164\000\000\000\164\000\000\000\000\000N\000\172\000\000\000\172\000\170\000\000\000\000\000\179\000\000\000\171\000\180\000\000\000\000\000\000\000\000\000\000\000\000\002a\000\178\000\000\000\000\000\187\000\179\000O\002k\000\180\000\000\000\000\000\164\000\000\000\000\001\t\002\r\000\000\000\172\000\187\000\000\000\178\000\179\000\178\002d\000\180\000\181\000N\000\000\000O\003a\000\170\000\000\000\000\000\164\000\000\000\171\000\000\000\000\000\000\000\172\000\181\000\000\000\000\000N\000\000\000\000\000\000\000\170\000\000\000O\000\000\002l\000\171\000\178\000\164\000\000\000\181\000N\000\000\000N\000\172\000\170\000\000\000\170\000\000\000\000\000\171\000\000\000\171\000\000\000\000\000\000\000\000\000\187\000\000\000\178\004!\000\000\000\000\002e\000\000\000\000\002f\000\000\003g\000\000\000\179\000\000\000\187\000\180\001\023\000\000\000O\000\000\000\000\000\000\000\178\000\164\000\000\003i\000\000\000\000\000\000\000\172\000\187\000\179\000\000\000\179\000\180\000O\000\180\000\000\000\000\000\000\000\164\003k\000\000\000\000\000\000\000\000\000\172\000\181\000\000\000O\000\000\000O\002l\000\000\000\164\001 \000\164\000\000\000\000\000\000\000\172\000\000\000\172\000\000\000\179\000\178\000\181\000\180\000\181\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004T\000\000\000\000\002e\000\000\000\178\002f\000\000\000\000\000\179\000\000\000\000\000\180\000\000\001\023\000\000\000\000\000\000\000\187\000\178\000\000\000\178\000\181\000\000\000\000\000\000\000\000\000\000\000\000\003m\000\179\000\000\000\000\000\180\000\000\000\000\000\000\000\187\000\000\000\187\000\000\000\000\000\000\000\000\000\181\000\000\000\000\000\000\003o\000\000\003q\000\000\000\000\001 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\181\000\000\000\000\000\000\000\000\000\187\000\000\000\000\000\179\000\000\000\000\000\180\000\000\000\000\000\000\000\000\003s\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\179\000\000\000\187\000\180\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\003u\000\179\000\000\000\179\000\180\000\181\000\180\000\000\000\000\000\000\000\187\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\003w\000\181\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\181\000\000\000\181\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\187\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\003y\000\000\000\000\000\000\000\000\000\000\000\187\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\003{\000\000\000\000\000\187\000\000\000\187\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\003}\000\000\003\127"))
  
  let semantic_action =
    [|
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        raise (MenhirLib.TableInterpreter.Accept _1));
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        raise (MenhirLib.TableInterpreter.Accept _1));
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        raise (MenhirLib.TableInterpreter.Accept _1));
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        raise (MenhirLib.TableInterpreter.Accept _1));
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        raise (MenhirLib.TableInterpreter.Accept _1));
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        raise (MenhirLib.TableInterpreter.Accept _1));
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        raise (MenhirLib.TableInterpreter.Accept _1));
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        raise (MenhirLib.TableInterpreter.Accept _1));
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        raise (MenhirLib.TableInterpreter.Accept _1));
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        raise (MenhirLib.TableInterpreter.Accept _1));
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        raise (MenhirLib.TableInterpreter.Accept _1));
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        raise (MenhirLib.TableInterpreter.Accept _1));
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        raise (MenhirLib.TableInterpreter.Accept _1));
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_dargexpr = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_aexpr = 
# 2326 "parser_cocci_menhir.mly"
             ( Ast0.set_arg_exp _1 )
# 1768 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : (
# 110 "parser_cocci_menhir.mly"
       (Parse_aux.list_info)
# 1789 "parser_cocci_menhir.ml"
        ) = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_aexpr = 
# 2328 "parser_cocci_menhir.mly"
      ( let (nm,lenname,pure,clt) = _1 in
      let nm = P.clt2mcode nm clt in
      let lenname =
	match lenname with
	  Ast.AnyLen -> Ast0.AnyListLen
	| Ast.MetaLen nm -> Ast0.MetaListLen(P.clt2mcode nm clt)
	| Ast.CstLen n -> Ast0.CstListLen n in
      Ast0.wrap(Ast0.MetaExprList(nm,lenname,pure)) )
# 1803 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_ctype = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_aexpr = 
# 2337 "parser_cocci_menhir.mly"
      ( Ast0.set_arg_exp(Ast0.wrap(Ast0.TypeExp(_1))) )
# 1827 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = ty;
          MenhirLib.EngineTypes.startp = _startpos_ty_;
          MenhirLib.EngineTypes.endp = _endpos_ty_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = r;
            MenhirLib.EngineTypes.startp = _startpos_r_;
            MenhirLib.EngineTypes.endp = _endpos_r_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let ty : 'tv_signable_types = Obj.magic ty in
        let r : (
# 93 "parser_cocci_menhir.mly"
      (Data.clt)
# 1854 "parser_cocci_menhir.ml"
        ) = Obj.magic r in
        let _startpos = _startpos_r_ in
        let _endpos = _endpos_ty_ in
        let _v : 'tv_all_basic_types = 
# 706 "parser_cocci_menhir.mly"
    ( Ast0.wrap(Ast0.Signed(P.clt2mcode Ast.Signed r,Some ty)) )
# 1861 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = ty;
          MenhirLib.EngineTypes.startp = _startpos_ty_;
          MenhirLib.EngineTypes.endp = _endpos_ty_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = r;
            MenhirLib.EngineTypes.startp = _startpos_r_;
            MenhirLib.EngineTypes.endp = _endpos_r_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let ty : 'tv_signable_types = Obj.magic ty in
        let r : (
# 93 "parser_cocci_menhir.mly"
      (Data.clt)
# 1888 "parser_cocci_menhir.ml"
        ) = Obj.magic r in
        let _startpos = _startpos_r_ in
        let _endpos = _endpos_ty_ in
        let _v : 'tv_all_basic_types = 
# 708 "parser_cocci_menhir.mly"
    ( Ast0.wrap(Ast0.Signed(P.clt2mcode Ast.Unsigned r,Some ty)) )
# 1895 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = ty;
          MenhirLib.EngineTypes.startp = _startpos_ty_;
          MenhirLib.EngineTypes.endp = _endpos_ty_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let ty : 'tv_signable_types = Obj.magic ty in
        let _startpos = _startpos_ty_ in
        let _endpos = _endpos_ty_ in
        let _v : 'tv_all_basic_types = 
# 709 "parser_cocci_menhir.mly"
                    ( ty )
# 1919 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = ty;
          MenhirLib.EngineTypes.startp = _startpos_ty_;
          MenhirLib.EngineTypes.endp = _endpos_ty_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let ty : 'tv_non_signable_types = Obj.magic ty in
        let _startpos = _startpos_ty_ in
        let _endpos = _endpos_ty_ in
        let _v : 'tv_all_basic_types = 
# 710 "parser_cocci_menhir.mly"
                        ( ty )
# 1943 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_any_strict = 
# 2373 "parser_cocci_menhir.mly"
            ( Ast.WhenAny )
# 1965 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_any_strict = 
# 2374 "parser_cocci_menhir.mly"
            ( Ast.WhenStrict )
# 1987 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_any_strict = 
# 2375 "parser_cocci_menhir.mly"
            ( Ast.WhenForall )
# 2009 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_any_strict = 
# 2376 "parser_cocci_menhir.mly"
            ( Ast.WhenExists )
# 2031 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_cast_expr_eexpr_dot_expressions_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_arith_expr_eexpr_dot_expressions_ = 
# 1547 "parser_cocci_menhir.mly"
                                            ( _1 )
# 2055 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 145 "parser_cocci_menhir.mly"
       (Data.clt)
# 2087 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_eexpr_dot_expressions_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_eexpr_dot_expressions_ = 
# 1549 "parser_cocci_menhir.mly"
      ( P.arith_op Ast.Mul _1 _2 _3 )
# 2095 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 143 "parser_cocci_menhir.mly"
       (Ast_cocci.arithOp * Data.clt)
# 2127 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_eexpr_dot_expressions_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_eexpr_dot_expressions_ = 
# 1551 "parser_cocci_menhir.mly"
      ( let (op,clt) = _2 in P.arith_op op _1 clt _3 )
# 2135 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 144 "parser_cocci_menhir.mly"
       (Data.clt)
# 2167 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_eexpr_dot_expressions_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_eexpr_dot_expressions_ = 
# 1553 "parser_cocci_menhir.mly"
      ( P.arith_op Ast.Plus _1 _2 _3 )
# 2175 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 144 "parser_cocci_menhir.mly"
       (Data.clt)
# 2207 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_eexpr_dot_expressions_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_eexpr_dot_expressions_ = 
# 1555 "parser_cocci_menhir.mly"
      ( P.arith_op Ast.Minus _1 _2 _3 )
# 2215 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 142 "parser_cocci_menhir.mly"
       (Ast_cocci.arithOp * Data.clt)
# 2247 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_eexpr_dot_expressions_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_eexpr_dot_expressions_ = 
# 1557 "parser_cocci_menhir.mly"
      ( let (op,clt) = _2 in P.arith_op op _1 clt _3 )
# 2255 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 142 "parser_cocci_menhir.mly"
       (Ast_cocci.arithOp * Data.clt)
# 2287 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_eexpr_dot_expressions_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_eexpr_dot_expressions_ = 
# 1559 "parser_cocci_menhir.mly"
      ( let (op,clt) = _2 in P.arith_op op _1 clt _3 )
# 2295 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 141 "parser_cocci_menhir.mly"
       (Ast_cocci.logicalOp * Data.clt)
# 2327 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_eexpr_dot_expressions_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_eexpr_dot_expressions_ = 
# 1561 "parser_cocci_menhir.mly"
      ( let (op,clt) = _2 in P.logic_op op _1 clt _3 )
# 2335 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 140 "parser_cocci_menhir.mly"
       (Data.clt)
# 2367 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_eexpr_dot_expressions_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_eexpr_dot_expressions_ = 
# 1563 "parser_cocci_menhir.mly"
      ( P.logic_op Ast.Eq _1 _2 _3 )
# 2375 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 140 "parser_cocci_menhir.mly"
       (Data.clt)
# 2407 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_eexpr_dot_expressions_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_eexpr_dot_expressions_ = 
# 1565 "parser_cocci_menhir.mly"
      ( P.logic_op Ast.NotEq _1 _2 _3 )
# 2415 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 139 "parser_cocci_menhir.mly"
       (Data.clt)
# 2447 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_eexpr_dot_expressions_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_eexpr_dot_expressions_ = 
# 1567 "parser_cocci_menhir.mly"
      ( P.arith_op Ast.And _1 _2 _3 )
# 2455 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 137 "parser_cocci_menhir.mly"
       (Data.clt)
# 2487 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_eexpr_dot_expressions_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_eexpr_dot_expressions_ = 
# 1569 "parser_cocci_menhir.mly"
      ( P.arith_op Ast.Or _1 _2 _3 )
# 2495 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 138 "parser_cocci_menhir.mly"
       (Data.clt)
# 2527 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_eexpr_dot_expressions_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_eexpr_dot_expressions_ = 
# 1571 "parser_cocci_menhir.mly"
      ( P.arith_op Ast.Xor _1 _2 _3 )
# 2535 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 136 "parser_cocci_menhir.mly"
       (Data.clt)
# 2567 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_eexpr_dot_expressions_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_eexpr_dot_expressions_ = 
# 1573 "parser_cocci_menhir.mly"
      ( P.logic_op Ast.AndLog _1 _2 _3 )
# 2575 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 135 "parser_cocci_menhir.mly"
       (Data.clt)
# 2607 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_eexpr_dot_expressions_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_eexpr_dot_expressions_ = 
# 1575 "parser_cocci_menhir.mly"
      ( P.logic_op Ast.OrLog _1 _2 _3 )
# 2615 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_cast_expr_eexpr_invalid_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_arith_expr_eexpr_invalid_ = 
# 1547 "parser_cocci_menhir.mly"
                                            ( _1 )
# 2639 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 145 "parser_cocci_menhir.mly"
       (Data.clt)
# 2671 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_eexpr_invalid_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_eexpr_invalid_ = 
# 1549 "parser_cocci_menhir.mly"
      ( P.arith_op Ast.Mul _1 _2 _3 )
# 2679 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 143 "parser_cocci_menhir.mly"
       (Ast_cocci.arithOp * Data.clt)
# 2711 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_eexpr_invalid_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_eexpr_invalid_ = 
# 1551 "parser_cocci_menhir.mly"
      ( let (op,clt) = _2 in P.arith_op op _1 clt _3 )
# 2719 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 144 "parser_cocci_menhir.mly"
       (Data.clt)
# 2751 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_eexpr_invalid_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_eexpr_invalid_ = 
# 1553 "parser_cocci_menhir.mly"
      ( P.arith_op Ast.Plus _1 _2 _3 )
# 2759 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 144 "parser_cocci_menhir.mly"
       (Data.clt)
# 2791 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_eexpr_invalid_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_eexpr_invalid_ = 
# 1555 "parser_cocci_menhir.mly"
      ( P.arith_op Ast.Minus _1 _2 _3 )
# 2799 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 142 "parser_cocci_menhir.mly"
       (Ast_cocci.arithOp * Data.clt)
# 2831 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_eexpr_invalid_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_eexpr_invalid_ = 
# 1557 "parser_cocci_menhir.mly"
      ( let (op,clt) = _2 in P.arith_op op _1 clt _3 )
# 2839 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 142 "parser_cocci_menhir.mly"
       (Ast_cocci.arithOp * Data.clt)
# 2871 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_eexpr_invalid_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_eexpr_invalid_ = 
# 1559 "parser_cocci_menhir.mly"
      ( let (op,clt) = _2 in P.arith_op op _1 clt _3 )
# 2879 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 141 "parser_cocci_menhir.mly"
       (Ast_cocci.logicalOp * Data.clt)
# 2911 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_eexpr_invalid_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_eexpr_invalid_ = 
# 1561 "parser_cocci_menhir.mly"
      ( let (op,clt) = _2 in P.logic_op op _1 clt _3 )
# 2919 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 140 "parser_cocci_menhir.mly"
       (Data.clt)
# 2951 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_eexpr_invalid_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_eexpr_invalid_ = 
# 1563 "parser_cocci_menhir.mly"
      ( P.logic_op Ast.Eq _1 _2 _3 )
# 2959 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 140 "parser_cocci_menhir.mly"
       (Data.clt)
# 2991 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_eexpr_invalid_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_eexpr_invalid_ = 
# 1565 "parser_cocci_menhir.mly"
      ( P.logic_op Ast.NotEq _1 _2 _3 )
# 2999 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 139 "parser_cocci_menhir.mly"
       (Data.clt)
# 3031 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_eexpr_invalid_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_eexpr_invalid_ = 
# 1567 "parser_cocci_menhir.mly"
      ( P.arith_op Ast.And _1 _2 _3 )
# 3039 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 137 "parser_cocci_menhir.mly"
       (Data.clt)
# 3071 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_eexpr_invalid_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_eexpr_invalid_ = 
# 1569 "parser_cocci_menhir.mly"
      ( P.arith_op Ast.Or _1 _2 _3 )
# 3079 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 138 "parser_cocci_menhir.mly"
       (Data.clt)
# 3111 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_eexpr_invalid_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_eexpr_invalid_ = 
# 1571 "parser_cocci_menhir.mly"
      ( P.arith_op Ast.Xor _1 _2 _3 )
# 3119 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 136 "parser_cocci_menhir.mly"
       (Data.clt)
# 3151 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_eexpr_invalid_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_eexpr_invalid_ = 
# 1573 "parser_cocci_menhir.mly"
      ( P.logic_op Ast.AndLog _1 _2 _3 )
# 3159 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 135 "parser_cocci_menhir.mly"
       (Data.clt)
# 3191 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_eexpr_invalid_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_eexpr_invalid_ = 
# 1575 "parser_cocci_menhir.mly"
      ( P.logic_op Ast.OrLog _1 _2 _3 )
# 3199 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_cast_expr_eexpr_nest_expressions_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_arith_expr_eexpr_nest_expressions_ = 
# 1547 "parser_cocci_menhir.mly"
                                            ( _1 )
# 3223 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 145 "parser_cocci_menhir.mly"
       (Data.clt)
# 3255 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_eexpr_nest_expressions_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_eexpr_nest_expressions_ = 
# 1549 "parser_cocci_menhir.mly"
      ( P.arith_op Ast.Mul _1 _2 _3 )
# 3263 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 143 "parser_cocci_menhir.mly"
       (Ast_cocci.arithOp * Data.clt)
# 3295 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_eexpr_nest_expressions_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_eexpr_nest_expressions_ = 
# 1551 "parser_cocci_menhir.mly"
      ( let (op,clt) = _2 in P.arith_op op _1 clt _3 )
# 3303 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 144 "parser_cocci_menhir.mly"
       (Data.clt)
# 3335 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_eexpr_nest_expressions_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_eexpr_nest_expressions_ = 
# 1553 "parser_cocci_menhir.mly"
      ( P.arith_op Ast.Plus _1 _2 _3 )
# 3343 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 144 "parser_cocci_menhir.mly"
       (Data.clt)
# 3375 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_eexpr_nest_expressions_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_eexpr_nest_expressions_ = 
# 1555 "parser_cocci_menhir.mly"
      ( P.arith_op Ast.Minus _1 _2 _3 )
# 3383 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 142 "parser_cocci_menhir.mly"
       (Ast_cocci.arithOp * Data.clt)
# 3415 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_eexpr_nest_expressions_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_eexpr_nest_expressions_ = 
# 1557 "parser_cocci_menhir.mly"
      ( let (op,clt) = _2 in P.arith_op op _1 clt _3 )
# 3423 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 142 "parser_cocci_menhir.mly"
       (Ast_cocci.arithOp * Data.clt)
# 3455 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_eexpr_nest_expressions_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_eexpr_nest_expressions_ = 
# 1559 "parser_cocci_menhir.mly"
      ( let (op,clt) = _2 in P.arith_op op _1 clt _3 )
# 3463 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 141 "parser_cocci_menhir.mly"
       (Ast_cocci.logicalOp * Data.clt)
# 3495 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_eexpr_nest_expressions_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_eexpr_nest_expressions_ = 
# 1561 "parser_cocci_menhir.mly"
      ( let (op,clt) = _2 in P.logic_op op _1 clt _3 )
# 3503 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 140 "parser_cocci_menhir.mly"
       (Data.clt)
# 3535 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_eexpr_nest_expressions_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_eexpr_nest_expressions_ = 
# 1563 "parser_cocci_menhir.mly"
      ( P.logic_op Ast.Eq _1 _2 _3 )
# 3543 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 140 "parser_cocci_menhir.mly"
       (Data.clt)
# 3575 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_eexpr_nest_expressions_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_eexpr_nest_expressions_ = 
# 1565 "parser_cocci_menhir.mly"
      ( P.logic_op Ast.NotEq _1 _2 _3 )
# 3583 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 139 "parser_cocci_menhir.mly"
       (Data.clt)
# 3615 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_eexpr_nest_expressions_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_eexpr_nest_expressions_ = 
# 1567 "parser_cocci_menhir.mly"
      ( P.arith_op Ast.And _1 _2 _3 )
# 3623 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 137 "parser_cocci_menhir.mly"
       (Data.clt)
# 3655 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_eexpr_nest_expressions_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_eexpr_nest_expressions_ = 
# 1569 "parser_cocci_menhir.mly"
      ( P.arith_op Ast.Or _1 _2 _3 )
# 3663 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 138 "parser_cocci_menhir.mly"
       (Data.clt)
# 3695 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_eexpr_nest_expressions_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_eexpr_nest_expressions_ = 
# 1571 "parser_cocci_menhir.mly"
      ( P.arith_op Ast.Xor _1 _2 _3 )
# 3703 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 136 "parser_cocci_menhir.mly"
       (Data.clt)
# 3735 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_eexpr_nest_expressions_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_eexpr_nest_expressions_ = 
# 1573 "parser_cocci_menhir.mly"
      ( P.logic_op Ast.AndLog _1 _2 _3 )
# 3743 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 135 "parser_cocci_menhir.mly"
       (Data.clt)
# 3775 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_eexpr_nest_expressions_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_eexpr_nest_expressions_ = 
# 1575 "parser_cocci_menhir.mly"
      ( P.logic_op Ast.OrLog _1 _2 _3 )
# 3783 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_cast_expr_expr_invalid_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_arith_expr_expr_invalid_ = 
# 1547 "parser_cocci_menhir.mly"
                                            ( _1 )
# 3807 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 145 "parser_cocci_menhir.mly"
       (Data.clt)
# 3839 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_expr_invalid_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_expr_invalid_ = 
# 1549 "parser_cocci_menhir.mly"
      ( P.arith_op Ast.Mul _1 _2 _3 )
# 3847 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 143 "parser_cocci_menhir.mly"
       (Ast_cocci.arithOp * Data.clt)
# 3879 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_expr_invalid_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_expr_invalid_ = 
# 1551 "parser_cocci_menhir.mly"
      ( let (op,clt) = _2 in P.arith_op op _1 clt _3 )
# 3887 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 144 "parser_cocci_menhir.mly"
       (Data.clt)
# 3919 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_expr_invalid_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_expr_invalid_ = 
# 1553 "parser_cocci_menhir.mly"
      ( P.arith_op Ast.Plus _1 _2 _3 )
# 3927 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 144 "parser_cocci_menhir.mly"
       (Data.clt)
# 3959 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_expr_invalid_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_expr_invalid_ = 
# 1555 "parser_cocci_menhir.mly"
      ( P.arith_op Ast.Minus _1 _2 _3 )
# 3967 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 142 "parser_cocci_menhir.mly"
       (Ast_cocci.arithOp * Data.clt)
# 3999 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_expr_invalid_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_expr_invalid_ = 
# 1557 "parser_cocci_menhir.mly"
      ( let (op,clt) = _2 in P.arith_op op _1 clt _3 )
# 4007 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 142 "parser_cocci_menhir.mly"
       (Ast_cocci.arithOp * Data.clt)
# 4039 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_expr_invalid_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_expr_invalid_ = 
# 1559 "parser_cocci_menhir.mly"
      ( let (op,clt) = _2 in P.arith_op op _1 clt _3 )
# 4047 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 141 "parser_cocci_menhir.mly"
       (Ast_cocci.logicalOp * Data.clt)
# 4079 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_expr_invalid_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_expr_invalid_ = 
# 1561 "parser_cocci_menhir.mly"
      ( let (op,clt) = _2 in P.logic_op op _1 clt _3 )
# 4087 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 140 "parser_cocci_menhir.mly"
       (Data.clt)
# 4119 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_expr_invalid_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_expr_invalid_ = 
# 1563 "parser_cocci_menhir.mly"
      ( P.logic_op Ast.Eq _1 _2 _3 )
# 4127 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 140 "parser_cocci_menhir.mly"
       (Data.clt)
# 4159 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_expr_invalid_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_expr_invalid_ = 
# 1565 "parser_cocci_menhir.mly"
      ( P.logic_op Ast.NotEq _1 _2 _3 )
# 4167 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 139 "parser_cocci_menhir.mly"
       (Data.clt)
# 4199 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_expr_invalid_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_expr_invalid_ = 
# 1567 "parser_cocci_menhir.mly"
      ( P.arith_op Ast.And _1 _2 _3 )
# 4207 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 137 "parser_cocci_menhir.mly"
       (Data.clt)
# 4239 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_expr_invalid_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_expr_invalid_ = 
# 1569 "parser_cocci_menhir.mly"
      ( P.arith_op Ast.Or _1 _2 _3 )
# 4247 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 138 "parser_cocci_menhir.mly"
       (Data.clt)
# 4279 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_expr_invalid_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_expr_invalid_ = 
# 1571 "parser_cocci_menhir.mly"
      ( P.arith_op Ast.Xor _1 _2 _3 )
# 4287 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 136 "parser_cocci_menhir.mly"
       (Data.clt)
# 4319 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_expr_invalid_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_expr_invalid_ = 
# 1573 "parser_cocci_menhir.mly"
      ( P.logic_op Ast.AndLog _1 _2 _3 )
# 4327 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 135 "parser_cocci_menhir.mly"
       (Data.clt)
# 4359 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_expr_invalid_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_expr_invalid_ = 
# 1575 "parser_cocci_menhir.mly"
      ( P.logic_op Ast.OrLog _1 _2 _3 )
# 4367 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_cast_expr_eexpr_dot_expressions_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_arith_expr_bis = 
# 1580 "parser_cocci_menhir.mly"
                                                             ( _1 )
# 4391 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 145 "parser_cocci_menhir.mly"
       (Data.clt)
# 4423 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_bis = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_bis = 
# 1582 "parser_cocci_menhir.mly"
      ( P.arith_op Ast.Mul _1 _2 _3 )
# 4431 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 143 "parser_cocci_menhir.mly"
       (Ast_cocci.arithOp * Data.clt)
# 4463 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_bis = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_bis = 
# 1584 "parser_cocci_menhir.mly"
      ( let (op,clt) = _2 in P.arith_op op _1 clt _3 )
# 4471 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 144 "parser_cocci_menhir.mly"
       (Data.clt)
# 4503 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_bis = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_bis = 
# 1586 "parser_cocci_menhir.mly"
      ( P.arith_op Ast.Plus _1 _2 _3 )
# 4511 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 144 "parser_cocci_menhir.mly"
       (Data.clt)
# 4543 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_bis = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_bis = 
# 1588 "parser_cocci_menhir.mly"
      ( P.arith_op Ast.Minus _1 _2 _3 )
# 4551 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 142 "parser_cocci_menhir.mly"
       (Ast_cocci.arithOp * Data.clt)
# 4583 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_bis = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_bis = 
# 1590 "parser_cocci_menhir.mly"
      ( let (op,clt) = _2 in P.arith_op op _1 clt _3 )
# 4591 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 142 "parser_cocci_menhir.mly"
       (Ast_cocci.arithOp * Data.clt)
# 4623 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_bis = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_bis = 
# 1592 "parser_cocci_menhir.mly"
      ( let (op,clt) = _2 in P.arith_op op _1 clt _3 )
# 4631 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 141 "parser_cocci_menhir.mly"
       (Ast_cocci.logicalOp * Data.clt)
# 4663 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_bis = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_bis = 
# 1594 "parser_cocci_menhir.mly"
      ( let (op,clt) = _2 in P.logic_op op _1 clt _3 )
# 4671 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 140 "parser_cocci_menhir.mly"
       (Data.clt)
# 4703 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_bis = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_bis = 
# 1596 "parser_cocci_menhir.mly"
      ( P.logic_op Ast.Eq _1 _2 _3 )
# 4711 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 140 "parser_cocci_menhir.mly"
       (Data.clt)
# 4743 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_bis = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_bis = 
# 1598 "parser_cocci_menhir.mly"
      ( P.logic_op Ast.NotEq _1 _2 _3 )
# 4751 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 139 "parser_cocci_menhir.mly"
       (Data.clt)
# 4783 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_bis = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_bis = 
# 1600 "parser_cocci_menhir.mly"
      ( P.arith_op Ast.And _1 _2 _3 )
# 4791 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 137 "parser_cocci_menhir.mly"
       (Data.clt)
# 4823 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_bis = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_bis = 
# 1602 "parser_cocci_menhir.mly"
      ( P.arith_op Ast.Or _1 _2 _3 )
# 4831 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 138 "parser_cocci_menhir.mly"
       (Data.clt)
# 4863 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_bis = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_bis = 
# 1604 "parser_cocci_menhir.mly"
      ( P.arith_op Ast.Xor _1 _2 _3 )
# 4871 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_arith_expr_bis = Obj.magic _3 in
        let _2 : (
# 136 "parser_cocci_menhir.mly"
       (Data.clt)
# 4903 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_arith_expr_bis = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_arith_expr_bis = 
# 1606 "parser_cocci_menhir.mly"
      ( P.logic_op Ast.AndLog _1 _2 _3 )
# 4911 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_arity = 
# 617 "parser_cocci_menhir.mly"
              ( Ast.UNIQUE )
# 4933 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_arity = 
# 618 "parser_cocci_menhir.mly"
              ( Ast.OPT )
# 4955 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_arity = 
# 619 "parser_cocci_menhir.mly"
              ( Ast.MULTI )
# 4977 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let _menhir_s = _menhir_env.MenhirLib.EngineTypes.current in
        let _startpos = _menhir_env.MenhirLib.EngineTypes.lexbuf.Lexing.lex_start_p in
        let _endpos = _startpos in
        let _v : 'tv_arity = 
# 620 "parser_cocci_menhir.mly"
                   ( Ast.NONE )
# 4994 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = r;
          MenhirLib.EngineTypes.startp = _startpos_r_;
          MenhirLib.EngineTypes.endp = _endpos_r_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = i;
            MenhirLib.EngineTypes.startp = _startpos_i_;
            MenhirLib.EngineTypes.endp = _endpos_i_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = l;
              MenhirLib.EngineTypes.startp = _startpos_l_;
              MenhirLib.EngineTypes.endp = _endpos_l_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let r : (
# 148 "parser_cocci_menhir.mly"
       (Data.clt)
# 5025 "parser_cocci_menhir.ml"
        ) = Obj.magic r in
        let i : 'tv_option_eexpr_ = Obj.magic i in
        let l : (
# 148 "parser_cocci_menhir.mly"
       (Data.clt)
# 5031 "parser_cocci_menhir.ml"
        ) = Obj.magic l in
        let _startpos = _startpos_l_ in
        let _endpos = _endpos_r_ in
        let _v : 'tv_array_dec = 
# 1336 "parser_cocci_menhir.mly"
                                           ( (l,i,r) )
# 5038 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_cond_expr_eexpr_dot_expressions_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_assign_expr_eexpr_dot_expressions_ = 
# 1518 "parser_cocci_menhir.mly"
                                           ( _1 )
# 5062 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_assign_expr_bis = Obj.magic _3 in
        let _2 : (
# 154 "parser_cocci_menhir.mly"
       (Ast_cocci.assignOp * Data.clt)
# 5094 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_unary_expr_eexpr_dot_expressions_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_assign_expr_eexpr_dot_expressions_ = 
# 1520 "parser_cocci_menhir.mly"
      ( let (op,clt) = _2 in
      Ast0.wrap(Ast0.Assignment(_1,P.clt2mcode op clt,
				Ast0.set_arg_exp _3,false)) )
# 5104 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_assign_expr_bis = Obj.magic _3 in
        let _2 : (
# 153 "parser_cocci_menhir.mly"
       (Data.clt)
# 5136 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_unary_expr_eexpr_dot_expressions_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_assign_expr_eexpr_dot_expressions_ = 
# 1524 "parser_cocci_menhir.mly"
      ( Ast0.wrap
	  (Ast0.Assignment
	     (_1,P.clt2mcode Ast.SimpleAssign _2,Ast0.set_arg_exp _3,false)) )
# 5146 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_cond_expr_eexpr_nest_expressions_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_assign_expr_eexpr_nest_expressions_ = 
# 1518 "parser_cocci_menhir.mly"
                                           ( _1 )
# 5170 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_assign_expr_bis = Obj.magic _3 in
        let _2 : (
# 154 "parser_cocci_menhir.mly"
       (Ast_cocci.assignOp * Data.clt)
# 5202 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_unary_expr_eexpr_nest_expressions_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_assign_expr_eexpr_nest_expressions_ = 
# 1520 "parser_cocci_menhir.mly"
      ( let (op,clt) = _2 in
      Ast0.wrap(Ast0.Assignment(_1,P.clt2mcode op clt,
				Ast0.set_arg_exp _3,false)) )
# 5212 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_assign_expr_bis = Obj.magic _3 in
        let _2 : (
# 153 "parser_cocci_menhir.mly"
       (Data.clt)
# 5244 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_unary_expr_eexpr_nest_expressions_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_assign_expr_eexpr_nest_expressions_ = 
# 1524 "parser_cocci_menhir.mly"
      ( Ast0.wrap
	  (Ast0.Assignment
	     (_1,P.clt2mcode Ast.SimpleAssign _2,Ast0.set_arg_exp _3,false)) )
# 5254 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_cond_expr_expr_invalid_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_assign_expr_expr_invalid_ = 
# 1518 "parser_cocci_menhir.mly"
                                           ( _1 )
# 5278 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_assign_expr_bis = Obj.magic _3 in
        let _2 : (
# 154 "parser_cocci_menhir.mly"
       (Ast_cocci.assignOp * Data.clt)
# 5310 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_unary_expr_expr_invalid_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_assign_expr_expr_invalid_ = 
# 1520 "parser_cocci_menhir.mly"
      ( let (op,clt) = _2 in
      Ast0.wrap(Ast0.Assignment(_1,P.clt2mcode op clt,
				Ast0.set_arg_exp _3,false)) )
# 5320 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_assign_expr_bis = Obj.magic _3 in
        let _2 : (
# 153 "parser_cocci_menhir.mly"
       (Data.clt)
# 5352 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_unary_expr_expr_invalid_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_assign_expr_expr_invalid_ = 
# 1524 "parser_cocci_menhir.mly"
      ( Ast0.wrap
	  (Ast0.Assignment
	     (_1,P.clt2mcode Ast.SimpleAssign _2,Ast0.set_arg_exp _3,false)) )
# 5362 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_cond_expr_eexpr_dot_expressions_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_assign_expr_bis = 
# 1529 "parser_cocci_menhir.mly"
                                                            ( _1 )
# 5386 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_assign_expr_bis = Obj.magic _3 in
        let _2 : (
# 154 "parser_cocci_menhir.mly"
       (Ast_cocci.assignOp * Data.clt)
# 5418 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_unary_expr_eexpr_dot_expressions_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_assign_expr_bis = 
# 1531 "parser_cocci_menhir.mly"
      ( let (op,clt) = _2 in
      Ast0.wrap(Ast0.Assignment(_1,P.clt2mcode op clt,
				Ast0.set_arg_exp _3,false)) )
# 5428 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_assign_expr_bis = Obj.magic _3 in
        let _2 : (
# 153 "parser_cocci_menhir.mly"
       (Data.clt)
# 5460 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_unary_expr_eexpr_dot_expressions_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_assign_expr_bis = 
# 1535 "parser_cocci_menhir.mly"
      ( Ast0.wrap
	  (Ast0.Assignment
	     (_1,P.clt2mcode Ast.SimpleAssign _2,Ast0.set_arg_exp _3,false)) )
# 5470 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_assign_expr_eexpr_dot_expressions_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_basic_expr_eexpr_dot_expressions_ = 
# 1515 "parser_cocci_menhir.mly"
                                                           ( _1 )
# 5494 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_assign_expr_eexpr_nest_expressions_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_basic_expr_eexpr_nest_expressions_ = 
# 1515 "parser_cocci_menhir.mly"
                                                           ( _1 )
# 5518 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_assign_expr_expr_invalid_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_basic_expr_expr_invalid_ = 
# 1515 "parser_cocci_menhir.mly"
                                                           ( _1 )
# 5542 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_fun_start = Obj.magic _3 in
        let _2 : (
# 122 "parser_cocci_menhir.mly"
       (Data.clt)
# 5574 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : (
# 99 "parser_cocci_menhir.mly"
       (Data.clt)
# 5579 "parser_cocci_menhir.ml"
        ) = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_case_line = 
# 1193 "parser_cocci_menhir.mly"
      ( Ast0.wrap
	  (Ast0.Default(P.clt2mcode "default" _1,P.clt2mcode ":" _2,_3)) )
# 5587 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _4;
          MenhirLib.EngineTypes.startp = _startpos__4_;
          MenhirLib.EngineTypes.endp = _endpos__4_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _3;
            MenhirLib.EngineTypes.startp = _startpos__3_;
            MenhirLib.EngineTypes.endp = _endpos__3_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.semv = _2;
              MenhirLib.EngineTypes.startp = _startpos__2_;
              MenhirLib.EngineTypes.endp = _endpos__2_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.semv = _1;
                MenhirLib.EngineTypes.startp = _startpos__1_;
                MenhirLib.EngineTypes.endp = _endpos__1_;
                MenhirLib.EngineTypes.next = _menhir_stack;
                };
              };
            };
          } = _menhir_stack in
        let _4 : 'tv_fun_start = Obj.magic _4 in
        let _3 : (
# 122 "parser_cocci_menhir.mly"
       (Data.clt)
# 5624 "parser_cocci_menhir.ml"
        ) = Obj.magic _3 in
        let _2 : 'tv_eexpr = Obj.magic _2 in
        let _1 : (
# 99 "parser_cocci_menhir.mly"
       (Data.clt)
# 5630 "parser_cocci_menhir.ml"
        ) = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__4_ in
        let _v : 'tv_case_line = 
# 1196 "parser_cocci_menhir.mly"
      ( Ast0.wrap(Ast0.Case(P.clt2mcode "case" _1,_2,P.clt2mcode ":" _3,_4)) )
# 5637 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_unary_expr_eexpr_dot_expressions_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_cast_expr_eexpr_dot_expressions_ = 
# 1611 "parser_cocci_menhir.mly"
                                          ( _1 )
# 5661 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = e;
          MenhirLib.EngineTypes.startp = _startpos_e_;
          MenhirLib.EngineTypes.endp = _endpos_e_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = rp;
            MenhirLib.EngineTypes.startp = _startpos_rp_;
            MenhirLib.EngineTypes.endp = _endpos_rp_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.semv = t;
              MenhirLib.EngineTypes.startp = _startpos_t_;
              MenhirLib.EngineTypes.endp = _endpos_t_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.semv = lp;
                MenhirLib.EngineTypes.startp = _startpos_lp_;
                MenhirLib.EngineTypes.endp = _endpos_lp_;
                MenhirLib.EngineTypes.next = _menhir_stack;
                };
              };
            };
          } = _menhir_stack in
        let e : 'tv_cast_expr_eexpr_dot_expressions_ = Obj.magic e in
        let rp : (
# 123 "parser_cocci_menhir.mly"
       (Data.clt)
# 5698 "parser_cocci_menhir.ml"
        ) = Obj.magic rp in
        let t : 'tv_ctype = Obj.magic t in
        let lp : (
# 122 "parser_cocci_menhir.mly"
       (Data.clt)
# 5704 "parser_cocci_menhir.ml"
        ) = Obj.magic lp in
        let _startpos = _startpos_lp_ in
        let _endpos = _endpos_e_ in
        let _v : 'tv_cast_expr_eexpr_dot_expressions_ = 
# 1613 "parser_cocci_menhir.mly"
      ( Ast0.wrap(Ast0.Cast (P.clt2mcode "(" lp, t,
			     P.clt2mcode ")" rp, e)) )
# 5712 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_unary_expr_eexpr_invalid_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_cast_expr_eexpr_invalid_ = 
# 1611 "parser_cocci_menhir.mly"
                                          ( _1 )
# 5736 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = e;
          MenhirLib.EngineTypes.startp = _startpos_e_;
          MenhirLib.EngineTypes.endp = _endpos_e_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = rp;
            MenhirLib.EngineTypes.startp = _startpos_rp_;
            MenhirLib.EngineTypes.endp = _endpos_rp_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.semv = t;
              MenhirLib.EngineTypes.startp = _startpos_t_;
              MenhirLib.EngineTypes.endp = _endpos_t_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.semv = lp;
                MenhirLib.EngineTypes.startp = _startpos_lp_;
                MenhirLib.EngineTypes.endp = _endpos_lp_;
                MenhirLib.EngineTypes.next = _menhir_stack;
                };
              };
            };
          } = _menhir_stack in
        let e : 'tv_cast_expr_eexpr_invalid_ = Obj.magic e in
        let rp : (
# 123 "parser_cocci_menhir.mly"
       (Data.clt)
# 5773 "parser_cocci_menhir.ml"
        ) = Obj.magic rp in
        let t : 'tv_ctype = Obj.magic t in
        let lp : (
# 122 "parser_cocci_menhir.mly"
       (Data.clt)
# 5779 "parser_cocci_menhir.ml"
        ) = Obj.magic lp in
        let _startpos = _startpos_lp_ in
        let _endpos = _endpos_e_ in
        let _v : 'tv_cast_expr_eexpr_invalid_ = 
# 1613 "parser_cocci_menhir.mly"
      ( Ast0.wrap(Ast0.Cast (P.clt2mcode "(" lp, t,
			     P.clt2mcode ")" rp, e)) )
# 5787 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_unary_expr_eexpr_nest_expressions_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_cast_expr_eexpr_nest_expressions_ = 
# 1611 "parser_cocci_menhir.mly"
                                          ( _1 )
# 5811 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = e;
          MenhirLib.EngineTypes.startp = _startpos_e_;
          MenhirLib.EngineTypes.endp = _endpos_e_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = rp;
            MenhirLib.EngineTypes.startp = _startpos_rp_;
            MenhirLib.EngineTypes.endp = _endpos_rp_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.semv = t;
              MenhirLib.EngineTypes.startp = _startpos_t_;
              MenhirLib.EngineTypes.endp = _endpos_t_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.semv = lp;
                MenhirLib.EngineTypes.startp = _startpos_lp_;
                MenhirLib.EngineTypes.endp = _endpos_lp_;
                MenhirLib.EngineTypes.next = _menhir_stack;
                };
              };
            };
          } = _menhir_stack in
        let e : 'tv_cast_expr_eexpr_nest_expressions_ = Obj.magic e in
        let rp : (
# 123 "parser_cocci_menhir.mly"
       (Data.clt)
# 5848 "parser_cocci_menhir.ml"
        ) = Obj.magic rp in
        let t : 'tv_ctype = Obj.magic t in
        let lp : (
# 122 "parser_cocci_menhir.mly"
       (Data.clt)
# 5854 "parser_cocci_menhir.ml"
        ) = Obj.magic lp in
        let _startpos = _startpos_lp_ in
        let _endpos = _endpos_e_ in
        let _v : 'tv_cast_expr_eexpr_nest_expressions_ = 
# 1613 "parser_cocci_menhir.mly"
      ( Ast0.wrap(Ast0.Cast (P.clt2mcode "(" lp, t,
			     P.clt2mcode ")" rp, e)) )
# 5862 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_unary_expr_expr_invalid_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_cast_expr_expr_invalid_ = 
# 1611 "parser_cocci_menhir.mly"
                                          ( _1 )
# 5886 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = e;
          MenhirLib.EngineTypes.startp = _startpos_e_;
          MenhirLib.EngineTypes.endp = _endpos_e_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = rp;
            MenhirLib.EngineTypes.startp = _startpos_rp_;
            MenhirLib.EngineTypes.endp = _endpos_rp_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.semv = t;
              MenhirLib.EngineTypes.startp = _startpos_t_;
              MenhirLib.EngineTypes.endp = _endpos_t_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.semv = lp;
                MenhirLib.EngineTypes.startp = _startpos_lp_;
                MenhirLib.EngineTypes.endp = _endpos_lp_;
                MenhirLib.EngineTypes.next = _menhir_stack;
                };
              };
            };
          } = _menhir_stack in
        let e : 'tv_cast_expr_expr_invalid_ = Obj.magic e in
        let rp : (
# 123 "parser_cocci_menhir.mly"
       (Data.clt)
# 5923 "parser_cocci_menhir.ml"
        ) = Obj.magic rp in
        let t : 'tv_ctype = Obj.magic t in
        let lp : (
# 122 "parser_cocci_menhir.mly"
       (Data.clt)
# 5929 "parser_cocci_menhir.ml"
        ) = Obj.magic lp in
        let _startpos = _startpos_lp_ in
        let _endpos = _endpos_e_ in
        let _v : 'tv_cast_expr_expr_invalid_ = 
# 1613 "parser_cocci_menhir.mly"
      ( Ast0.wrap(Ast0.Cast (P.clt2mcode "(" lp, t,
			     P.clt2mcode ")" rp, e)) )
# 5937 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _2;
          MenhirLib.EngineTypes.startp = _startpos__2_;
          MenhirLib.EngineTypes.endp = _endpos__2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let _2 : 'tv_separated_nonempty_list_TComma_TString_ = Obj.magic _2 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__2_ in
        let _v : 'tv_choose_iso = 
# 284 "parser_cocci_menhir.mly"
                                                 ( List.map P.id2name _2 )
# 5965 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_separated_nonempty_list_TComma_any_strict_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_comma_list_any_strict_ = 
# 2351 "parser_cocci_menhir.mly"
                                       ( _1 )
# 5989 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_separated_nonempty_list_TComma_ctype_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_comma_list_ctype_ = 
# 2351 "parser_cocci_menhir.mly"
                                       ( _1 )
# 6013 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_separated_nonempty_list_TComma_d_ident_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_comma_list_d_ident_ = 
# 2351 "parser_cocci_menhir.mly"
                                       ( _1 )
# 6037 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_separated_nonempty_list_TComma_ident_or_const_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_comma_list_ident_or_const_ = 
# 2351 "parser_cocci_menhir.mly"
                                       ( _1 )
# 6061 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_separated_nonempty_list_TComma_meta_ident_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_comma_list_meta_ident_ = 
# 2351 "parser_cocci_menhir.mly"
                                       ( _1 )
# 6085 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_separated_nonempty_list_TComma_pure_ident_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_comma_list_pure_ident_ = 
# 2351 "parser_cocci_menhir.mly"
                                       ( _1 )
# 6109 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_separated_nonempty_list_TComma_pure_ident_or_meta_ident_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_comma_list_pure_ident_or_meta_ident_ = 
# 2351 "parser_cocci_menhir.mly"
                                       ( _1 )
# 6133 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_separated_nonempty_list_TComma_pure_ident_or_meta_ident_with_econstraint_not_ceq_or_sub__ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_comma_list_pure_ident_or_meta_ident_with_econstraint_not_ceq_or_sub__ = 
# 2351 "parser_cocci_menhir.mly"
                                       ( _1 )
# 6157 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_separated_nonempty_list_TComma_pure_ident_or_meta_ident_with_econstraint_re_or_not_eqe_or_sub__ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_comma_list_pure_ident_or_meta_ident_with_econstraint_re_or_not_eqe_or_sub__ = 
# 2351 "parser_cocci_menhir.mly"
                                       ( _1 )
# 6181 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_separated_nonempty_list_TComma_pure_ident_or_meta_ident_with_idconstraint_re_or_not_eqid__ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_comma_list_pure_ident_or_meta_ident_with_idconstraint_re_or_not_eqid__ = 
# 2351 "parser_cocci_menhir.mly"
                                       ( _1 )
# 6205 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_separated_nonempty_list_TComma_pure_ident_or_meta_ident_with_idconstraint_virt_re_or_not_eqid__ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_comma_list_pure_ident_or_meta_ident_with_idconstraint_virt_re_or_not_eqid__ = 
# 2351 "parser_cocci_menhir.mly"
                                       ( _1 )
# 6229 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_separated_nonempty_list_TComma_pure_ident_or_meta_ident_with_seed_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_comma_list_pure_ident_or_meta_ident_with_seed_ = 
# 2351 "parser_cocci_menhir.mly"
                                       ( _1 )
# 6253 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_separated_nonempty_list_TComma_pure_ident_or_meta_ident_with_x_eq_not_pos__ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_comma_list_pure_ident_or_meta_ident_with_x_eq_not_pos__ = 
# 2351 "parser_cocci_menhir.mly"
                                       ( _1 )
# 6277 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_separated_nonempty_list_TComma_typedef_ident_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_comma_list_typedef_ident_ = 
# 2351 "parser_cocci_menhir.mly"
                                       ( _1 )
# 6301 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_arith_expr_eexpr_dot_expressions_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_cond_expr_eexpr_dot_expressions_ = 
# 1540 "parser_cocci_menhir.mly"
                                             ( _1 )
# 6325 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = r;
          MenhirLib.EngineTypes.startp = _startpos_r_;
          MenhirLib.EngineTypes.endp = _endpos_r_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = dd;
            MenhirLib.EngineTypes.startp = _startpos_dd_;
            MenhirLib.EngineTypes.endp = _endpos_dd_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.semv = t;
              MenhirLib.EngineTypes.startp = _startpos_t_;
              MenhirLib.EngineTypes.endp = _endpos_t_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.semv = w;
                MenhirLib.EngineTypes.startp = _startpos_w_;
                MenhirLib.EngineTypes.endp = _endpos_w_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.state = _menhir_s;
                  MenhirLib.EngineTypes.semv = l;
                  MenhirLib.EngineTypes.startp = _startpos_l_;
                  MenhirLib.EngineTypes.endp = _endpos_l_;
                  MenhirLib.EngineTypes.next = _menhir_stack;
                  };
                };
              };
            };
          } = _menhir_stack in
        let r : 'tv_eargexpr = Obj.magic r in
        let dd : (
# 122 "parser_cocci_menhir.mly"
       (Data.clt)
# 6367 "parser_cocci_menhir.ml"
        ) = Obj.magic dd in
        let t : 'tv_option_eexpr_ = Obj.magic t in
        let w : (
# 122 "parser_cocci_menhir.mly"
       (Data.clt)
# 6373 "parser_cocci_menhir.ml"
        ) = Obj.magic w in
        let l : 'tv_arith_expr_eexpr_dot_expressions_ = Obj.magic l in
        let _startpos = _startpos_l_ in
        let _endpos = _endpos_r_ in
        let _v : 'tv_cond_expr_eexpr_dot_expressions_ = 
# 1543 "parser_cocci_menhir.mly"
      ( Ast0.wrap(Ast0.CondExpr (l, P.clt2mcode "?" w, t,
				 P.clt2mcode ":" dd, r)) )
# 6382 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_arith_expr_eexpr_nest_expressions_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_cond_expr_eexpr_nest_expressions_ = 
# 1540 "parser_cocci_menhir.mly"
                                             ( _1 )
# 6406 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = r;
          MenhirLib.EngineTypes.startp = _startpos_r_;
          MenhirLib.EngineTypes.endp = _endpos_r_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = dd;
            MenhirLib.EngineTypes.startp = _startpos_dd_;
            MenhirLib.EngineTypes.endp = _endpos_dd_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.semv = t;
              MenhirLib.EngineTypes.startp = _startpos_t_;
              MenhirLib.EngineTypes.endp = _endpos_t_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.semv = w;
                MenhirLib.EngineTypes.startp = _startpos_w_;
                MenhirLib.EngineTypes.endp = _endpos_w_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.state = _menhir_s;
                  MenhirLib.EngineTypes.semv = l;
                  MenhirLib.EngineTypes.startp = _startpos_l_;
                  MenhirLib.EngineTypes.endp = _endpos_l_;
                  MenhirLib.EngineTypes.next = _menhir_stack;
                  };
                };
              };
            };
          } = _menhir_stack in
        let r : 'tv_eargexpr = Obj.magic r in
        let dd : (
# 122 "parser_cocci_menhir.mly"
       (Data.clt)
# 6448 "parser_cocci_menhir.ml"
        ) = Obj.magic dd in
        let t : 'tv_option_eexpr_ = Obj.magic t in
        let w : (
# 122 "parser_cocci_menhir.mly"
       (Data.clt)
# 6454 "parser_cocci_menhir.ml"
        ) = Obj.magic w in
        let l : 'tv_arith_expr_eexpr_nest_expressions_ = Obj.magic l in
        let _startpos = _startpos_l_ in
        let _endpos = _endpos_r_ in
        let _v : 'tv_cond_expr_eexpr_nest_expressions_ = 
# 1543 "parser_cocci_menhir.mly"
      ( Ast0.wrap(Ast0.CondExpr (l, P.clt2mcode "?" w, t,
				 P.clt2mcode ":" dd, r)) )
# 6463 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_arith_expr_expr_invalid_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_cond_expr_expr_invalid_ = 
# 1540 "parser_cocci_menhir.mly"
                                             ( _1 )
# 6487 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = r;
          MenhirLib.EngineTypes.startp = _startpos_r_;
          MenhirLib.EngineTypes.endp = _endpos_r_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = dd;
            MenhirLib.EngineTypes.startp = _startpos_dd_;
            MenhirLib.EngineTypes.endp = _endpos_dd_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.semv = t;
              MenhirLib.EngineTypes.startp = _startpos_t_;
              MenhirLib.EngineTypes.endp = _endpos_t_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.semv = w;
                MenhirLib.EngineTypes.startp = _startpos_w_;
                MenhirLib.EngineTypes.endp = _endpos_w_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.state = _menhir_s;
                  MenhirLib.EngineTypes.semv = l;
                  MenhirLib.EngineTypes.startp = _startpos_l_;
                  MenhirLib.EngineTypes.endp = _endpos_l_;
                  MenhirLib.EngineTypes.next = _menhir_stack;
                  };
                };
              };
            };
          } = _menhir_stack in
        let r : 'tv_eargexpr = Obj.magic r in
        let dd : (
# 122 "parser_cocci_menhir.mly"
       (Data.clt)
# 6529 "parser_cocci_menhir.ml"
        ) = Obj.magic dd in
        let t : 'tv_option_eexpr_ = Obj.magic t in
        let w : (
# 122 "parser_cocci_menhir.mly"
       (Data.clt)
# 6535 "parser_cocci_menhir.ml"
        ) = Obj.magic w in
        let l : 'tv_arith_expr_expr_invalid_ = Obj.magic l in
        let _startpos = _startpos_l_ in
        let _endpos = _endpos_r_ in
        let _v : 'tv_cond_expr_expr_invalid_ = 
# 1543 "parser_cocci_menhir.mly"
      ( Ast0.wrap(Ast0.CondExpr (l, P.clt2mcode "?" w, t,
				 P.clt2mcode ":" dd, r)) )
# 6544 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : (
# 96 "parser_cocci_menhir.mly"
      (Data.clt)
# 6565 "parser_cocci_menhir.ml"
        ) = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_const_vol = 
# 1089 "parser_cocci_menhir.mly"
                   ( P.clt2mcode Ast.Const _1 )
# 6572 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : (
# 96 "parser_cocci_menhir.mly"
      (Data.clt)
# 6593 "parser_cocci_menhir.ml"
        ) = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_const_vol = 
# 1090 "parser_cocci_menhir.mly"
                   ( P.clt2mcode Ast.Volatile _1 )
# 6600 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_aexpr = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_continue_list_aexpr_TEllipsis_ = 
# 2127 "parser_cocci_menhir.mly"
       ( fun build_dots build_comma -> [_1] )
# 6624 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _2;
          MenhirLib.EngineTypes.startp = _startpos__2_;
          MenhirLib.EngineTypes.endp = _endpos__2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let _2 : (
# 153 "parser_cocci_menhir.mly"
       (Data.clt)
# 6650 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_aexpr = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__2_ in
        let _v : 'tv_continue_list_aexpr_TEllipsis_ = 
# 2129 "parser_cocci_menhir.mly"
    ( fun build_dots build_comma ->
      _1::[Ast0.wrap(build_comma(P.clt2mcode "," _2))] )
# 6659 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_nonempty_list_start_aexpr_TEllipsis_ = Obj.magic _3 in
        let _2 : (
# 153 "parser_cocci_menhir.mly"
       (Data.clt)
# 6691 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_aexpr = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_continue_list_aexpr_TEllipsis_ = 
# 2132 "parser_cocci_menhir.mly"
    ( fun build_dots build_comma ->
      _1::(Ast0.wrap(build_comma(P.clt2mcode "," _2)))::
      (_3 build_dots build_comma) )
# 6701 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _2;
          MenhirLib.EngineTypes.startp = _startpos__2_;
          MenhirLib.EngineTypes.endp = _endpos__2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let _2 : 'tv_nonempty_list_start_aexpr_TEllipsis_ = Obj.magic _2 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__2_ in
        let _v : 'tv_continue_list_aexpr_TEllipsis_ = 
# 2135 "parser_cocci_menhir.mly"
                                            ( _2 )
# 6729 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_dparam = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_continue_list_dparam_TEllipsis_ = 
# 2127 "parser_cocci_menhir.mly"
       ( fun build_dots build_comma -> [_1] )
# 6753 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _2;
          MenhirLib.EngineTypes.startp = _startpos__2_;
          MenhirLib.EngineTypes.endp = _endpos__2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let _2 : (
# 153 "parser_cocci_menhir.mly"
       (Data.clt)
# 6779 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_dparam = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__2_ in
        let _v : 'tv_continue_list_dparam_TEllipsis_ = 
# 2129 "parser_cocci_menhir.mly"
    ( fun build_dots build_comma ->
      _1::[Ast0.wrap(build_comma(P.clt2mcode "," _2))] )
# 6788 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_nonempty_list_start_dparam_TEllipsis_ = Obj.magic _3 in
        let _2 : (
# 153 "parser_cocci_menhir.mly"
       (Data.clt)
# 6820 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_dparam = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_continue_list_dparam_TEllipsis_ = 
# 2132 "parser_cocci_menhir.mly"
    ( fun build_dots build_comma ->
      _1::(Ast0.wrap(build_comma(P.clt2mcode "," _2)))::
      (_3 build_dots build_comma) )
# 6830 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _2;
          MenhirLib.EngineTypes.startp = _startpos__2_;
          MenhirLib.EngineTypes.endp = _endpos__2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let _2 : 'tv_nonempty_list_start_dparam_TEllipsis_ = Obj.magic _2 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__2_ in
        let _v : 'tv_continue_list_dparam_TEllipsis_ = 
# 2135 "parser_cocci_menhir.mly"
                                            ( _2 )
# 6858 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_enum_decl_one = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_continue_list_enum_decl_one_edots_when_TEllipsis_enum_decl_one__ = 
# 2127 "parser_cocci_menhir.mly"
       ( fun build_dots build_comma -> [_1] )
# 6882 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _2;
          MenhirLib.EngineTypes.startp = _startpos__2_;
          MenhirLib.EngineTypes.endp = _endpos__2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let _2 : (
# 153 "parser_cocci_menhir.mly"
       (Data.clt)
# 6908 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_enum_decl_one = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__2_ in
        let _v : 'tv_continue_list_enum_decl_one_edots_when_TEllipsis_enum_decl_one__ = 
# 2129 "parser_cocci_menhir.mly"
    ( fun build_dots build_comma ->
      _1::[Ast0.wrap(build_comma(P.clt2mcode "," _2))] )
# 6917 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_nonempty_list_start_enum_decl_one_edots_when_TEllipsis_enum_decl_one__ = Obj.magic _3 in
        let _2 : (
# 153 "parser_cocci_menhir.mly"
       (Data.clt)
# 6949 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_enum_decl_one = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_continue_list_enum_decl_one_edots_when_TEllipsis_enum_decl_one__ = 
# 2132 "parser_cocci_menhir.mly"
    ( fun build_dots build_comma ->
      _1::(Ast0.wrap(build_comma(P.clt2mcode "," _2)))::
      (_3 build_dots build_comma) )
# 6959 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _2;
          MenhirLib.EngineTypes.startp = _startpos__2_;
          MenhirLib.EngineTypes.endp = _endpos__2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let _2 : 'tv_nonempty_list_start_enum_decl_one_edots_when_TEllipsis_enum_decl_one__ = Obj.magic _2 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__2_ in
        let _v : 'tv_continue_list_enum_decl_one_edots_when_TEllipsis_enum_decl_one__ = 
# 2135 "parser_cocci_menhir.mly"
                                            ( _2 )
# 6987 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_initialize2 = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_continue_list_initialize2_edots_when_TEllipsis_initialize__ = 
# 2127 "parser_cocci_menhir.mly"
       ( fun build_dots build_comma -> [_1] )
# 7011 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _2;
          MenhirLib.EngineTypes.startp = _startpos__2_;
          MenhirLib.EngineTypes.endp = _endpos__2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let _2 : (
# 153 "parser_cocci_menhir.mly"
       (Data.clt)
# 7037 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_initialize2 = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__2_ in
        let _v : 'tv_continue_list_initialize2_edots_when_TEllipsis_initialize__ = 
# 2129 "parser_cocci_menhir.mly"
    ( fun build_dots build_comma ->
      _1::[Ast0.wrap(build_comma(P.clt2mcode "," _2))] )
# 7046 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_nonempty_list_start_initialize2_edots_when_TEllipsis_initialize__ = Obj.magic _3 in
        let _2 : (
# 153 "parser_cocci_menhir.mly"
       (Data.clt)
# 7078 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_initialize2 = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_continue_list_initialize2_edots_when_TEllipsis_initialize__ = 
# 2132 "parser_cocci_menhir.mly"
    ( fun build_dots build_comma ->
      _1::(Ast0.wrap(build_comma(P.clt2mcode "," _2)))::
      (_3 build_dots build_comma) )
# 7088 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _2;
          MenhirLib.EngineTypes.startp = _startpos__2_;
          MenhirLib.EngineTypes.endp = _endpos__2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let _2 : 'tv_nonempty_list_start_initialize2_edots_when_TEllipsis_initialize__ = Obj.magic _2 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__2_ in
        let _v : 'tv_continue_list_initialize2_edots_when_TEllipsis_initialize__ = 
# 2135 "parser_cocci_menhir.mly"
                                            ( _2 )
# 7116 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_one_dec_decl_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_continue_list_one_dec_decl__TEllipsis_ = 
# 2127 "parser_cocci_menhir.mly"
       ( fun build_dots build_comma -> [_1] )
# 7140 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _2;
          MenhirLib.EngineTypes.startp = _startpos__2_;
          MenhirLib.EngineTypes.endp = _endpos__2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let _2 : (
# 153 "parser_cocci_menhir.mly"
       (Data.clt)
# 7166 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_one_dec_decl_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__2_ in
        let _v : 'tv_continue_list_one_dec_decl__TEllipsis_ = 
# 2129 "parser_cocci_menhir.mly"
    ( fun build_dots build_comma ->
      _1::[Ast0.wrap(build_comma(P.clt2mcode "," _2))] )
# 7175 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_nonempty_list_start_one_dec_decl__TEllipsis_ = Obj.magic _3 in
        let _2 : (
# 153 "parser_cocci_menhir.mly"
       (Data.clt)
# 7207 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_one_dec_decl_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_continue_list_one_dec_decl__TEllipsis_ = 
# 2132 "parser_cocci_menhir.mly"
    ( fun build_dots build_comma ->
      _1::(Ast0.wrap(build_comma(P.clt2mcode "," _2)))::
      (_3 build_dots build_comma) )
# 7217 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _2;
          MenhirLib.EngineTypes.startp = _startpos__2_;
          MenhirLib.EngineTypes.endp = _endpos__2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let _2 : 'tv_nonempty_list_start_one_dec_decl__TEllipsis_ = Obj.magic _2 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__2_ in
        let _v : 'tv_continue_list_one_dec_decl__TEllipsis_ = 
# 2135 "parser_cocci_menhir.mly"
                                            ( _2 )
# 7245 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_one_dec_name_opt_decl_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_continue_list_one_dec_name_opt_decl__TEllipsis_ = 
# 2127 "parser_cocci_menhir.mly"
       ( fun build_dots build_comma -> [_1] )
# 7269 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _2;
          MenhirLib.EngineTypes.startp = _startpos__2_;
          MenhirLib.EngineTypes.endp = _endpos__2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let _2 : (
# 153 "parser_cocci_menhir.mly"
       (Data.clt)
# 7295 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_one_dec_name_opt_decl_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__2_ in
        let _v : 'tv_continue_list_one_dec_name_opt_decl__TEllipsis_ = 
# 2129 "parser_cocci_menhir.mly"
    ( fun build_dots build_comma ->
      _1::[Ast0.wrap(build_comma(P.clt2mcode "," _2))] )
# 7304 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_nonempty_list_start_one_dec_name_opt_decl__TEllipsis_ = Obj.magic _3 in
        let _2 : (
# 153 "parser_cocci_menhir.mly"
       (Data.clt)
# 7336 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_one_dec_name_opt_decl_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_continue_list_one_dec_name_opt_decl__TEllipsis_ = 
# 2132 "parser_cocci_menhir.mly"
    ( fun build_dots build_comma ->
      _1::(Ast0.wrap(build_comma(P.clt2mcode "," _2)))::
      (_3 build_dots build_comma) )
# 7346 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _2;
          MenhirLib.EngineTypes.startp = _startpos__2_;
          MenhirLib.EngineTypes.endp = _endpos__2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let _2 : 'tv_nonempty_list_start_one_dec_name_opt_decl__TEllipsis_ = Obj.magic _2 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__2_ in
        let _v : 'tv_continue_list_one_dec_name_opt_decl__TEllipsis_ = 
# 2135 "parser_cocci_menhir.mly"
                                            ( _2 )
# 7374 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let _menhir_s = _menhir_env.MenhirLib.EngineTypes.current in
        let _startpos = _menhir_env.MenhirLib.EngineTypes.lexbuf.Lexing.lex_start_p in
        let _endpos = _startpos in
        let _v : 'tv_continue_struct_decl_list = 
# 789 "parser_cocci_menhir.mly"
                                     ( [] )
# 7391 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _2;
          MenhirLib.EngineTypes.startp = _startpos__2_;
          MenhirLib.EngineTypes.endp = _endpos__2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let _2 : 'tv_struct_decl_list_start = Obj.magic _2 in
        let _1 : 'tv_struct_decl = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__2_ in
        let _v : 'tv_continue_struct_decl_list = 
# 790 "parser_cocci_menhir.mly"
                                     ( _1@_2 )
# 7421 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_struct_decl = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_continue_struct_decl_list = 
# 791 "parser_cocci_menhir.mly"
                                     ( _1 )
# 7445 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = m;
          MenhirLib.EngineTypes.startp = _startpos_m_;
          MenhirLib.EngineTypes.endp = _endpos_m_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = ty;
            MenhirLib.EngineTypes.startp = _startpos_ty_;
            MenhirLib.EngineTypes.endp = _endpos_ty_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let m : 'tv_list_mul_ = Obj.magic m in
        let ty : 'tv_all_basic_types = Obj.magic ty in
        let _startpos = _startpos_ty_ in
        let _endpos = _endpos_m_ in
        let _v : 'tv_ctype = let cv =
          
# 39 "standard.mly"
    ( None )
# 7476 "parser_cocci_menhir.ml"
          
        in
        
# 714 "parser_cocci_menhir.mly"
    ( List.fold_left
	(function prev ->
	  function (star,cv) ->
	    P.make_cv cv (P.pointerify prev [star]))
	(P.make_cv cv ty) m )
# 7486 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = m;
          MenhirLib.EngineTypes.startp = _startpos_m_;
          MenhirLib.EngineTypes.endp = _endpos_m_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = ty;
            MenhirLib.EngineTypes.startp = _startpos_ty_;
            MenhirLib.EngineTypes.endp = _endpos_ty_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = x0;
              MenhirLib.EngineTypes.startp = _startpos_x0_;
              MenhirLib.EngineTypes.endp = _endpos_x0_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let m : 'tv_list_mul_ = Obj.magic m in
        let ty : 'tv_all_basic_types = Obj.magic ty in
        let x0 : 'tv_const_vol = Obj.magic x0 in
        let _startpos = _startpos_x0_ in
        let _endpos = _endpos_m_ in
        let _v : 'tv_ctype = let cv =
          let x = x0 in
          
# 41 "standard.mly"
    ( Some x )
# 7524 "parser_cocci_menhir.ml"
          
        in
        
# 714 "parser_cocci_menhir.mly"
    ( List.fold_left
	(function prev ->
	  function (star,cv) ->
	    P.make_cv cv (P.pointerify prev [star]))
	(P.make_cv cv ty) m )
# 7534 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = r;
          MenhirLib.EngineTypes.startp = _startpos_r_;
          MenhirLib.EngineTypes.endp = _endpos_r_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let r : (
# 93 "parser_cocci_menhir.mly"
      (Data.clt)
# 7555 "parser_cocci_menhir.ml"
        ) = Obj.magic r in
        let _startpos = _startpos_r_ in
        let _endpos = _endpos_r_ in
        let _v : 'tv_ctype = 
# 720 "parser_cocci_menhir.mly"
    ( Ast0.wrap(Ast0.Signed(P.clt2mcode Ast.Signed r,None)) )
# 7562 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = r;
          MenhirLib.EngineTypes.startp = _startpos_r_;
          MenhirLib.EngineTypes.endp = _endpos_r_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let r : (
# 93 "parser_cocci_menhir.mly"
      (Data.clt)
# 7583 "parser_cocci_menhir.ml"
        ) = Obj.magic r in
        let _startpos = _startpos_r_ in
        let _endpos = _endpos_r_ in
        let _v : 'tv_ctype = 
# 722 "parser_cocci_menhir.mly"
    ( Ast0.wrap(Ast0.Signed(P.clt2mcode Ast.Unsigned r,None)) )
# 7590 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = rp;
          MenhirLib.EngineTypes.startp = _startpos_rp_;
          MenhirLib.EngineTypes.endp = _endpos_rp_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = t;
            MenhirLib.EngineTypes.startp = _startpos_t_;
            MenhirLib.EngineTypes.endp = _endpos_t_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = lp;
              MenhirLib.EngineTypes.startp = _startpos_lp_;
              MenhirLib.EngineTypes.endp = _endpos_lp_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let rp : (
# 123 "parser_cocci_menhir.mly"
       (Data.clt)
# 7621 "parser_cocci_menhir.ml"
        ) = Obj.magic rp in
        let t : 'tv_midzero_list_ctype_ctype_ = Obj.magic t in
        let lp : (
# 122 "parser_cocci_menhir.mly"
       (Data.clt)
# 7627 "parser_cocci_menhir.ml"
        ) = Obj.magic lp in
        let _startpos = _startpos_lp_ in
        let _endpos = _endpos_rp_ in
        let _v : 'tv_ctype = 
# 724 "parser_cocci_menhir.mly"
    ( let (mids,code) = t in
      Ast0.wrap
	(Ast0.DisjType(P.clt2mcode "(" lp,code,mids, P.clt2mcode ")" rp)) )
# 7636 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _2;
          MenhirLib.EngineTypes.startp = _startpos__2_;
          MenhirLib.EngineTypes.endp = _endpos__2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let _2 : 'tv_list_array_dec_ = Obj.magic _2 in
        let _1 : 'tv_disj_ident = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__2_ in
        let _v : 'tv_d_ident = 
# 1334 "parser_cocci_menhir.mly"
      ( (_1, function t -> P.arrayify t _2) )
# 7666 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_basic_expr_eexpr_nest_expressions_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_dargexpr = 
# 1472 "parser_cocci_menhir.mly"
                                             ( _1 )
# 7690 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = a;
          MenhirLib.EngineTypes.startp = _startpos_a_;
          MenhirLib.EngineTypes.endp = _endpos_a_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = i;
            MenhirLib.EngineTypes.startp = _startpos_i_;
            MenhirLib.EngineTypes.endp = _endpos_i_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = t;
              MenhirLib.EngineTypes.startp = _startpos_t_;
              MenhirLib.EngineTypes.endp = _endpos_t_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let a : 'tv_list_array_dec_ = Obj.magic a in
        let i : 'tv_disj_ident = Obj.magic i in
        let t : 'tv_ctype = Obj.magic t in
        let _startpos = _startpos_t_ in
        let _endpos = _endpos_a_ in
        let _v : 'tv_decl = 
# 1062 "parser_cocci_menhir.mly"
 ( let t = P.arrayify t a in Ast0.wrap(Ast0.Param(t, Some i)) )
# 7726 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = t;
          MenhirLib.EngineTypes.startp = _startpos_t_;
          MenhirLib.EngineTypes.endp = _endpos_t_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let t : 'tv_ctype = Obj.magic t in
        let _startpos = _startpos_t_ in
        let _endpos = _endpos_t_ in
        let _v : 'tv_decl = 
# 1063 "parser_cocci_menhir.mly"
              ( (*verify in FunDecl*) Ast0.wrap(Ast0.Param(t, None)) )
# 7750 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = rp1;
          MenhirLib.EngineTypes.startp = _startpos_rp1_;
          MenhirLib.EngineTypes.endp = _endpos_rp1_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = d;
            MenhirLib.EngineTypes.startp = _startpos_d_;
            MenhirLib.EngineTypes.endp = _endpos_d_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.semv = lp1;
              MenhirLib.EngineTypes.startp = _startpos_lp1_;
              MenhirLib.EngineTypes.endp = _endpos_lp1_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.semv = rp;
                MenhirLib.EngineTypes.startp = _startpos_rp_;
                MenhirLib.EngineTypes.endp = _endpos_rp_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.semv = i;
                  MenhirLib.EngineTypes.startp = _startpos_i_;
                  MenhirLib.EngineTypes.endp = _endpos_i_;
                  MenhirLib.EngineTypes.next = {
                    MenhirLib.EngineTypes.semv = s;
                    MenhirLib.EngineTypes.startp = _startpos_s_;
                    MenhirLib.EngineTypes.endp = _endpos_s_;
                    MenhirLib.EngineTypes.next = {
                      MenhirLib.EngineTypes.semv = lp;
                      MenhirLib.EngineTypes.startp = _startpos_lp_;
                      MenhirLib.EngineTypes.endp = _endpos_lp_;
                      MenhirLib.EngineTypes.next = {
                        MenhirLib.EngineTypes.state = _menhir_s;
                        MenhirLib.EngineTypes.semv = t;
                        MenhirLib.EngineTypes.startp = _startpos_t_;
                        MenhirLib.EngineTypes.endp = _endpos_t_;
                        MenhirLib.EngineTypes.next = _menhir_stack;
                        };
                      };
                    };
                  };
                };
              };
            };
          } = _menhir_stack in
        let rp1 : (
# 123 "parser_cocci_menhir.mly"
       (Data.clt)
# 7806 "parser_cocci_menhir.ml"
        ) = Obj.magic rp1 in
        let d : 'tv_decl_list_name_opt_decl_ = Obj.magic d in
        let lp1 : (
# 122 "parser_cocci_menhir.mly"
       (Data.clt)
# 7812 "parser_cocci_menhir.ml"
        ) = Obj.magic lp1 in
        let rp : (
# 123 "parser_cocci_menhir.mly"
       (Data.clt)
# 7817 "parser_cocci_menhir.ml"
        ) = Obj.magic rp in
        let i : 'tv_disj_ident = Obj.magic i in
        let s : (
# 145 "parser_cocci_menhir.mly"
       (Data.clt)
# 7823 "parser_cocci_menhir.ml"
        ) = Obj.magic s in
        let lp : (
# 122 "parser_cocci_menhir.mly"
       (Data.clt)
# 7828 "parser_cocci_menhir.ml"
        ) = Obj.magic lp in
        let t : 'tv_ctype = Obj.magic t in
        let _startpos = _startpos_t_ in
        let _endpos = _endpos_rp1_ in
        let _v : 'tv_decl = 
# 1066 "parser_cocci_menhir.mly"
        ( let fnptr =
	  Ast0.wrap
	    (Ast0.FunctionPointer
	       (t,P.clt2mcode "(" lp,P.clt2mcode "*" s,P.clt2mcode ")" rp,
		P.clt2mcode "(" lp1,d,P.clt2mcode ")" rp1)) in
	Ast0.wrap(Ast0.Param(fnptr, Some i)) )
# 7841 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : (
# 108 "parser_cocci_menhir.mly"
       (Parse_aux.info)
# 7862 "parser_cocci_menhir.ml"
        ) = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_decl = 
# 1073 "parser_cocci_menhir.mly"
 ( let (nm,pure,clt) = _1 in
	Ast0.wrap(Ast0.MetaParam(P.clt2mcode nm clt,pure)) )
# 7870 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : (
# 109 "parser_cocci_menhir.mly"
       (Parse_aux.info)
# 7891 "parser_cocci_menhir.ml"
        ) = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_decl = 
# 1075 "parser_cocci_menhir.mly"
            ( tmeta_to_param _1 )
# 7898 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : (
# 101 "parser_cocci_menhir.mly"
       (string * Data.clt)
# 7919 "parser_cocci_menhir.ml"
        ) = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_decl_ident = 
# 2051 "parser_cocci_menhir.mly"
         ( Ast0.wrap(Ast0.Id(P.id2mcode _1)) )
# 7926 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : (
# 106 "parser_cocci_menhir.mly"
       (Parse_aux.idinfo)
# 7947 "parser_cocci_menhir.ml"
        ) = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_decl_ident = 
# 2053 "parser_cocci_menhir.mly"
         ( let (nm,constraints,pure,clt) = _1 in
         Ast0.wrap(Ast0.MetaId(P.clt2mcode nm clt,constraints,Ast.NoVal,pure)) )
# 7955 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_empty_list_start_one_dec_decl__TEllipsis_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_decl_list_decl_ = 
# 2075 "parser_cocci_menhir.mly"
     ( Ast0.wrap
	 (Ast0.DOTS
	    (_1
	       (fun _ d -> Ast0.wrap(Ast0.Pdots(P.clt2mcode "..." d)))
	       (fun c -> Ast0.PComma c))) )
# 7983 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_empty_list_start_one_dec_name_opt_decl__TEllipsis_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_decl_list_name_opt_decl_ = 
# 2075 "parser_cocci_menhir.mly"
     ( Ast0.wrap
	 (Ast0.DOTS
	    (_1
	       (fun _ d -> Ast0.wrap(Ast0.Pdots(P.clt2mcode "..." d)))
	       (fun c -> Ast0.PComma c))) )
# 8011 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : (
# 108 "parser_cocci_menhir.mly"
       (Parse_aux.info)
# 8032 "parser_cocci_menhir.ml"
        ) = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_decl_statement = 
# 1398 "parser_cocci_menhir.mly"
      ( let (nm,pure,clt) = _1 in
      [Ast0.wrap(Ast0.MetaStmt(P.clt2mcode nm clt,pure))] )
# 8040 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_decl_var = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_decl_statement = 
# 1401 "parser_cocci_menhir.mly"
      ( List.map
	  (function x ->
	    Ast0.wrap
	      (Ast0.Decl((Ast0.default_info(),Ast0.context_befaft()),x)))
	  _1 )
# 8068 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_statement = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_decl_statement = 
# 1406 "parser_cocci_menhir.mly"
              ( [_1] )
# 8092 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = t;
            MenhirLib.EngineTypes.startp = _startpos_t_;
            MenhirLib.EngineTypes.endp = _endpos_t_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : (
# 123 "parser_cocci_menhir.mly"
       (Data.clt)
# 8123 "parser_cocci_menhir.ml"
        ) = Obj.magic _3 in
        let t : 'tv_midzero_list_fun_start_fun_start_ = Obj.magic t in
        let _1 : (
# 122 "parser_cocci_menhir.mly"
       (Data.clt)
# 8129 "parser_cocci_menhir.ml"
        ) = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_decl_statement = 
# 1415 "parser_cocci_menhir.mly"
      ( let (mids,code) = t in
	if List.for_all
	    (function x ->
	      match Ast0.unwrap x with Ast0.DOTS([]) -> true | _ -> false)
	    code
      then []
      else
	  [Ast0.wrap(Ast0.Disj(P.clt2mcode "(" _1, code, mids,
			       P.clt2mcode ")" _3))] )
# 8144 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : (
# 108 "parser_cocci_menhir.mly"
       (Parse_aux.info)
# 8165 "parser_cocci_menhir.ml"
        ) = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_decl_statement_expr = 
# 1428 "parser_cocci_menhir.mly"
      ( let (nm,pure,clt) = _1 in
      [Ast0.wrap(Ast0.MetaStmt(P.clt2mcode nm clt,pure))] )
# 8173 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_decl_var = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_decl_statement_expr = 
# 1431 "parser_cocci_menhir.mly"
      ( List.map
	  (function x ->
	    Ast0.wrap
	      (Ast0.Decl((Ast0.default_info(),Ast0.context_befaft()),x)))
	  _1 )
# 8201 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_statement = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_decl_statement_expr = 
# 1436 "parser_cocci_menhir.mly"
              ( [_1] )
# 8225 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = t;
            MenhirLib.EngineTypes.startp = _startpos_t_;
            MenhirLib.EngineTypes.endp = _endpos_t_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : (
# 123 "parser_cocci_menhir.mly"
       (Data.clt)
# 8256 "parser_cocci_menhir.ml"
        ) = Obj.magic _3 in
        let t : 'tv_midzero_list_fun_after_stm_fun_after_dots_or_ = Obj.magic t in
        let _1 : (
# 122 "parser_cocci_menhir.mly"
       (Data.clt)
# 8262 "parser_cocci_menhir.ml"
        ) = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_decl_statement_expr = 
# 1445 "parser_cocci_menhir.mly"
      ( let (mids,code) = t in
	if List.for_all (function [] -> true | _ -> false) code
      then []
      else
	  let dot_code =
	    List.map (function x -> Ast0.wrap(Ast0.DOTS x)) code in
	  [Ast0.wrap(Ast0.Disj(P.clt2mcode "(" _1, dot_code, mids,
			       P.clt2mcode ")" _3))] )
# 8276 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = pv;
          MenhirLib.EngineTypes.startp = _startpos_pv_;
          MenhirLib.EngineTypes.endp = _endpos_pv_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = t;
            MenhirLib.EngineTypes.startp = _startpos_t_;
            MenhirLib.EngineTypes.endp = _endpos_t_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let pv : (
# 153 "parser_cocci_menhir.mly"
       (Data.clt)
# 8302 "parser_cocci_menhir.ml"
        ) = Obj.magic pv in
        let t : 'tv_ctype = Obj.magic t in
        let _startpos = _startpos_t_ in
        let _endpos = _endpos_pv_ in
        let _v : 'tv_decl_var = 
# 1208 "parser_cocci_menhir.mly"
      ( [Ast0.wrap(Ast0.TyDecl(t,P.clt2mcode ";" pv))] )
# 8310 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : (
# 109 "parser_cocci_menhir.mly"
       (Parse_aux.info)
# 8331 "parser_cocci_menhir.ml"
        ) = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_decl_var = 
# 1209 "parser_cocci_menhir.mly"
              ( [P.meta_decl _1] )
# 8338 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = pv;
          MenhirLib.EngineTypes.startp = _startpos_pv_;
          MenhirLib.EngineTypes.endp = _endpos_pv_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = d;
            MenhirLib.EngineTypes.startp = _startpos_d_;
            MenhirLib.EngineTypes.endp = _endpos_d_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = t;
              MenhirLib.EngineTypes.startp = _startpos_t_;
              MenhirLib.EngineTypes.endp = _endpos_t_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let pv : (
# 153 "parser_cocci_menhir.mly"
       (Data.clt)
# 8369 "parser_cocci_menhir.ml"
        ) = Obj.magic pv in
        let d : 'tv_comma_list_d_ident_ = Obj.magic d in
        let t : 'tv_ctype = Obj.magic t in
        let _startpos = _startpos_t_ in
        let _endpos = _endpos_pv_ in
        let _v : 'tv_decl_var = let s =
          
# 39 "standard.mly"
    ( None )
# 8379 "parser_cocci_menhir.ml"
          
        in
        
# 1211 "parser_cocci_menhir.mly"
      ( List.map
	  (function (id,fn) ->
	    Ast0.wrap(Ast0.UnInit(s,fn t,id,P.clt2mcode ";" pv)))
	  d )
# 8388 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = pv;
          MenhirLib.EngineTypes.startp = _startpos_pv_;
          MenhirLib.EngineTypes.endp = _endpos_pv_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = d;
            MenhirLib.EngineTypes.startp = _startpos_d_;
            MenhirLib.EngineTypes.endp = _endpos_d_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.semv = t;
              MenhirLib.EngineTypes.startp = _startpos_t_;
              MenhirLib.EngineTypes.endp = _endpos_t_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.semv = x0;
                MenhirLib.EngineTypes.startp = _startpos_x0_;
                MenhirLib.EngineTypes.endp = _endpos_x0_;
                MenhirLib.EngineTypes.next = _menhir_stack;
                };
              };
            };
          } = _menhir_stack in
        let pv : (
# 153 "parser_cocci_menhir.mly"
       (Data.clt)
# 8424 "parser_cocci_menhir.ml"
        ) = Obj.magic pv in
        let d : 'tv_comma_list_d_ident_ = Obj.magic d in
        let t : 'tv_ctype = Obj.magic t in
        let x0 : 'tv_storage = Obj.magic x0 in
        let _startpos = _startpos_x0_ in
        let _endpos = _endpos_pv_ in
        let _v : 'tv_decl_var = let s =
          let x = x0 in
          
# 41 "standard.mly"
    ( Some x )
# 8436 "parser_cocci_menhir.ml"
          
        in
        
# 1211 "parser_cocci_menhir.mly"
      ( List.map
	  (function (id,fn) ->
	    Ast0.wrap(Ast0.UnInit(s,fn t,id,P.clt2mcode ";" pv)))
	  d )
# 8445 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = f;
          MenhirLib.EngineTypes.startp = _startpos_f_;
          MenhirLib.EngineTypes.endp = _endpos_f_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let f : 'tv_funproto = Obj.magic f in
        let _startpos = _startpos_f_ in
        let _endpos = _endpos_f_ in
        let _v : 'tv_decl_var = 
# 1215 "parser_cocci_menhir.mly"
               ( [f] )
# 8469 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = pv;
          MenhirLib.EngineTypes.startp = _startpos_pv_;
          MenhirLib.EngineTypes.endp = _endpos_pv_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = e;
            MenhirLib.EngineTypes.startp = _startpos_e_;
            MenhirLib.EngineTypes.endp = _endpos_e_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.semv = q;
              MenhirLib.EngineTypes.startp = _startpos_q_;
              MenhirLib.EngineTypes.endp = _endpos_q_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.semv = d;
                MenhirLib.EngineTypes.startp = _startpos_d_;
                MenhirLib.EngineTypes.endp = _endpos_d_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.state = _menhir_s;
                  MenhirLib.EngineTypes.semv = t;
                  MenhirLib.EngineTypes.startp = _startpos_t_;
                  MenhirLib.EngineTypes.endp = _endpos_t_;
                  MenhirLib.EngineTypes.next = _menhir_stack;
                  };
                };
              };
            };
          } = _menhir_stack in
        let pv : (
# 153 "parser_cocci_menhir.mly"
       (Data.clt)
# 8510 "parser_cocci_menhir.ml"
        ) = Obj.magic pv in
        let e : 'tv_initialize = Obj.magic e in
        let q : (
# 153 "parser_cocci_menhir.mly"
       (Data.clt)
# 8516 "parser_cocci_menhir.ml"
        ) = Obj.magic q in
        let d : 'tv_d_ident = Obj.magic d in
        let t : 'tv_ctype = Obj.magic t in
        let _startpos = _startpos_t_ in
        let _endpos = _endpos_pv_ in
        let _v : 'tv_decl_var = let s =
          
# 39 "standard.mly"
    ( None )
# 8526 "parser_cocci_menhir.ml"
          
        in
        
# 1217 "parser_cocci_menhir.mly"
      (let (id,fn) = d in
      [Ast0.wrap(Ast0.Init(s,fn t,id,P.clt2mcode "=" q,e,P.clt2mcode ";" pv))])
# 8533 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = pv;
          MenhirLib.EngineTypes.startp = _startpos_pv_;
          MenhirLib.EngineTypes.endp = _endpos_pv_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = e;
            MenhirLib.EngineTypes.startp = _startpos_e_;
            MenhirLib.EngineTypes.endp = _endpos_e_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.semv = q;
              MenhirLib.EngineTypes.startp = _startpos_q_;
              MenhirLib.EngineTypes.endp = _endpos_q_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.semv = d;
                MenhirLib.EngineTypes.startp = _startpos_d_;
                MenhirLib.EngineTypes.endp = _endpos_d_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.semv = t;
                  MenhirLib.EngineTypes.startp = _startpos_t_;
                  MenhirLib.EngineTypes.endp = _endpos_t_;
                  MenhirLib.EngineTypes.next = {
                    MenhirLib.EngineTypes.state = _menhir_s;
                    MenhirLib.EngineTypes.semv = x0;
                    MenhirLib.EngineTypes.startp = _startpos_x0_;
                    MenhirLib.EngineTypes.endp = _endpos_x0_;
                    MenhirLib.EngineTypes.next = _menhir_stack;
                    };
                  };
                };
              };
            };
          } = _menhir_stack in
        let pv : (
# 153 "parser_cocci_menhir.mly"
       (Data.clt)
# 8579 "parser_cocci_menhir.ml"
        ) = Obj.magic pv in
        let e : 'tv_initialize = Obj.magic e in
        let q : (
# 153 "parser_cocci_menhir.mly"
       (Data.clt)
# 8585 "parser_cocci_menhir.ml"
        ) = Obj.magic q in
        let d : 'tv_d_ident = Obj.magic d in
        let t : 'tv_ctype = Obj.magic t in
        let x0 : 'tv_storage = Obj.magic x0 in
        let _startpos = _startpos_x0_ in
        let _endpos = _endpos_pv_ in
        let _v : 'tv_decl_var = let s =
          let x = x0 in
          
# 41 "standard.mly"
    ( Some x )
# 8597 "parser_cocci_menhir.ml"
          
        in
        
# 1217 "parser_cocci_menhir.mly"
      (let (id,fn) = d in
      [Ast0.wrap(Ast0.Init(s,fn t,id,P.clt2mcode "=" q,e,P.clt2mcode ";" pv))])
# 8604 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = pv;
          MenhirLib.EngineTypes.startp = _startpos_pv_;
          MenhirLib.EngineTypes.endp = _endpos_pv_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = d;
            MenhirLib.EngineTypes.startp = _startpos_d_;
            MenhirLib.EngineTypes.endp = _endpos_d_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = i;
              MenhirLib.EngineTypes.startp = _startpos_i_;
              MenhirLib.EngineTypes.endp = _endpos_i_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let pv : (
# 153 "parser_cocci_menhir.mly"
       (Data.clt)
# 8635 "parser_cocci_menhir.ml"
        ) = Obj.magic pv in
        let d : 'tv_comma_list_d_ident_ = Obj.magic d in
        let i : 'tv_pure_ident_or_symbol = Obj.magic i in
        let _startpos = _startpos_i_ in
        let _endpos = _endpos_pv_ in
        let _v : 'tv_decl_var = let cv =
          
# 39 "standard.mly"
    ( None )
# 8645 "parser_cocci_menhir.ml"
          
        in
        let s =
          
# 39 "standard.mly"
    ( None )
# 8652 "parser_cocci_menhir.ml"
          
        in
        
# 1222 "parser_cocci_menhir.mly"
      ( List.map
	  (function (id,fn) ->
	    let idtype =
	      P.make_cv cv (Ast0.wrap (Ast0.TypeName(P.id2mcode i))) in
	    Ast0.wrap(Ast0.UnInit(s,fn idtype,id,P.clt2mcode ";" pv)))
	  d )
# 8663 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = pv;
          MenhirLib.EngineTypes.startp = _startpos_pv_;
          MenhirLib.EngineTypes.endp = _endpos_pv_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = d;
            MenhirLib.EngineTypes.startp = _startpos_d_;
            MenhirLib.EngineTypes.endp = _endpos_d_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.semv = i;
              MenhirLib.EngineTypes.startp = _startpos_i_;
              MenhirLib.EngineTypes.endp = _endpos_i_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.semv = x0;
                MenhirLib.EngineTypes.startp = _startpos_x0_;
                MenhirLib.EngineTypes.endp = _endpos_x0_;
                MenhirLib.EngineTypes.next = _menhir_stack;
                };
              };
            };
          } = _menhir_stack in
        let pv : (
# 153 "parser_cocci_menhir.mly"
       (Data.clt)
# 8699 "parser_cocci_menhir.ml"
        ) = Obj.magic pv in
        let d : 'tv_comma_list_d_ident_ = Obj.magic d in
        let i : 'tv_pure_ident_or_symbol = Obj.magic i in
        let x0 : 'tv_const_vol = Obj.magic x0 in
        let _startpos = _startpos_x0_ in
        let _endpos = _endpos_pv_ in
        let _v : 'tv_decl_var = let cv =
          let x = x0 in
          
# 41 "standard.mly"
    ( Some x )
# 8711 "parser_cocci_menhir.ml"
          
        in
        let s =
          
# 39 "standard.mly"
    ( None )
# 8718 "parser_cocci_menhir.ml"
          
        in
        
# 1222 "parser_cocci_menhir.mly"
      ( List.map
	  (function (id,fn) ->
	    let idtype =
	      P.make_cv cv (Ast0.wrap (Ast0.TypeName(P.id2mcode i))) in
	    Ast0.wrap(Ast0.UnInit(s,fn idtype,id,P.clt2mcode ";" pv)))
	  d )
# 8729 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = pv;
          MenhirLib.EngineTypes.startp = _startpos_pv_;
          MenhirLib.EngineTypes.endp = _endpos_pv_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = d;
            MenhirLib.EngineTypes.startp = _startpos_d_;
            MenhirLib.EngineTypes.endp = _endpos_d_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.semv = i;
              MenhirLib.EngineTypes.startp = _startpos_i_;
              MenhirLib.EngineTypes.endp = _endpos_i_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.semv = x0;
                MenhirLib.EngineTypes.startp = _startpos_x0_;
                MenhirLib.EngineTypes.endp = _endpos_x0_;
                MenhirLib.EngineTypes.next = _menhir_stack;
                };
              };
            };
          } = _menhir_stack in
        let pv : (
# 153 "parser_cocci_menhir.mly"
       (Data.clt)
# 8765 "parser_cocci_menhir.ml"
        ) = Obj.magic pv in
        let d : 'tv_comma_list_d_ident_ = Obj.magic d in
        let i : 'tv_pure_ident_or_symbol = Obj.magic i in
        let x0 : 'tv_storage = Obj.magic x0 in
        let _startpos = _startpos_x0_ in
        let _endpos = _endpos_pv_ in
        let _v : 'tv_decl_var = let cv =
          
# 39 "standard.mly"
    ( None )
# 8776 "parser_cocci_menhir.ml"
          
        in
        let s =
          let x = x0 in
          
# 41 "standard.mly"
    ( Some x )
# 8784 "parser_cocci_menhir.ml"
          
        in
        
# 1222 "parser_cocci_menhir.mly"
      ( List.map
	  (function (id,fn) ->
	    let idtype =
	      P.make_cv cv (Ast0.wrap (Ast0.TypeName(P.id2mcode i))) in
	    Ast0.wrap(Ast0.UnInit(s,fn idtype,id,P.clt2mcode ";" pv)))
	  d )
# 8795 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = pv;
          MenhirLib.EngineTypes.startp = _startpos_pv_;
          MenhirLib.EngineTypes.endp = _endpos_pv_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = d;
            MenhirLib.EngineTypes.startp = _startpos_d_;
            MenhirLib.EngineTypes.endp = _endpos_d_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.semv = i;
              MenhirLib.EngineTypes.startp = _startpos_i_;
              MenhirLib.EngineTypes.endp = _endpos_i_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.semv = x1;
                MenhirLib.EngineTypes.startp = _startpos_x1_;
                MenhirLib.EngineTypes.endp = _endpos_x1_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.state = _menhir_s;
                  MenhirLib.EngineTypes.semv = x0;
                  MenhirLib.EngineTypes.startp = _startpos_x0_;
                  MenhirLib.EngineTypes.endp = _endpos_x0_;
                  MenhirLib.EngineTypes.next = _menhir_stack;
                  };
                };
              };
            };
          } = _menhir_stack in
        let pv : (
# 153 "parser_cocci_menhir.mly"
       (Data.clt)
# 8836 "parser_cocci_menhir.ml"
        ) = Obj.magic pv in
        let d : 'tv_comma_list_d_ident_ = Obj.magic d in
        let i : 'tv_pure_ident_or_symbol = Obj.magic i in
        let x1 : 'tv_const_vol = Obj.magic x1 in
        let x0 : 'tv_storage = Obj.magic x0 in
        let _startpos = _startpos_x0_ in
        let _endpos = _endpos_pv_ in
        let _v : 'tv_decl_var = let cv =
          let x = x1 in
          
# 41 "standard.mly"
    ( Some x )
# 8849 "parser_cocci_menhir.ml"
          
        in
        let s =
          let x = x0 in
          
# 41 "standard.mly"
    ( Some x )
# 8857 "parser_cocci_menhir.ml"
          
        in
        
# 1222 "parser_cocci_menhir.mly"
      ( List.map
	  (function (id,fn) ->
	    let idtype =
	      P.make_cv cv (Ast0.wrap (Ast0.TypeName(P.id2mcode i))) in
	    Ast0.wrap(Ast0.UnInit(s,fn idtype,id,P.clt2mcode ";" pv)))
	  d )
# 8868 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = pv;
          MenhirLib.EngineTypes.startp = _startpos_pv_;
          MenhirLib.EngineTypes.endp = _endpos_pv_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = e;
            MenhirLib.EngineTypes.startp = _startpos_e_;
            MenhirLib.EngineTypes.endp = _endpos_e_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.semv = q;
              MenhirLib.EngineTypes.startp = _startpos_q_;
              MenhirLib.EngineTypes.endp = _endpos_q_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.semv = d;
                MenhirLib.EngineTypes.startp = _startpos_d_;
                MenhirLib.EngineTypes.endp = _endpos_d_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.state = _menhir_s;
                  MenhirLib.EngineTypes.semv = i;
                  MenhirLib.EngineTypes.startp = _startpos_i_;
                  MenhirLib.EngineTypes.endp = _endpos_i_;
                  MenhirLib.EngineTypes.next = _menhir_stack;
                  };
                };
              };
            };
          } = _menhir_stack in
        let pv : (
# 153 "parser_cocci_menhir.mly"
       (Data.clt)
# 8909 "parser_cocci_menhir.ml"
        ) = Obj.magic pv in
        let e : 'tv_initialize = Obj.magic e in
        let q : (
# 153 "parser_cocci_menhir.mly"
       (Data.clt)
# 8915 "parser_cocci_menhir.ml"
        ) = Obj.magic q in
        let d : 'tv_d_ident = Obj.magic d in
        let i : 'tv_pure_ident_or_symbol = Obj.magic i in
        let _startpos = _startpos_i_ in
        let _endpos = _endpos_pv_ in
        let _v : 'tv_decl_var = let cv =
          
# 39 "standard.mly"
    ( None )
# 8925 "parser_cocci_menhir.ml"
          
        in
        let s =
          
# 39 "standard.mly"
    ( None )
# 8932 "parser_cocci_menhir.ml"
          
        in
        
# 1230 "parser_cocci_menhir.mly"
      ( let (id,fn) = d in
      !Data.add_type_name (P.id2name i);
      let idtype = P.make_cv cv (Ast0.wrap (Ast0.TypeName(P.id2mcode i))) in
      [Ast0.wrap(Ast0.Init(s,fn idtype,id,P.clt2mcode "=" q,e,
			   P.clt2mcode ";" pv))] )
# 8942 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = pv;
          MenhirLib.EngineTypes.startp = _startpos_pv_;
          MenhirLib.EngineTypes.endp = _endpos_pv_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = e;
            MenhirLib.EngineTypes.startp = _startpos_e_;
            MenhirLib.EngineTypes.endp = _endpos_e_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.semv = q;
              MenhirLib.EngineTypes.startp = _startpos_q_;
              MenhirLib.EngineTypes.endp = _endpos_q_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.semv = d;
                MenhirLib.EngineTypes.startp = _startpos_d_;
                MenhirLib.EngineTypes.endp = _endpos_d_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.semv = i;
                  MenhirLib.EngineTypes.startp = _startpos_i_;
                  MenhirLib.EngineTypes.endp = _endpos_i_;
                  MenhirLib.EngineTypes.next = {
                    MenhirLib.EngineTypes.state = _menhir_s;
                    MenhirLib.EngineTypes.semv = x0;
                    MenhirLib.EngineTypes.startp = _startpos_x0_;
                    MenhirLib.EngineTypes.endp = _endpos_x0_;
                    MenhirLib.EngineTypes.next = _menhir_stack;
                    };
                  };
                };
              };
            };
          } = _menhir_stack in
        let pv : (
# 153 "parser_cocci_menhir.mly"
       (Data.clt)
# 8988 "parser_cocci_menhir.ml"
        ) = Obj.magic pv in
        let e : 'tv_initialize = Obj.magic e in
        let q : (
# 153 "parser_cocci_menhir.mly"
       (Data.clt)
# 8994 "parser_cocci_menhir.ml"
        ) = Obj.magic q in
        let d : 'tv_d_ident = Obj.magic d in
        let i : 'tv_pure_ident_or_symbol = Obj.magic i in
        let x0 : 'tv_const_vol = Obj.magic x0 in
        let _startpos = _startpos_x0_ in
        let _endpos = _endpos_pv_ in
        let _v : 'tv_decl_var = let cv =
          let x = x0 in
          
# 41 "standard.mly"
    ( Some x )
# 9006 "parser_cocci_menhir.ml"
          
        in
        let s =
          
# 39 "standard.mly"
    ( None )
# 9013 "parser_cocci_menhir.ml"
          
        in
        
# 1230 "parser_cocci_menhir.mly"
      ( let (id,fn) = d in
      !Data.add_type_name (P.id2name i);
      let idtype = P.make_cv cv (Ast0.wrap (Ast0.TypeName(P.id2mcode i))) in
      [Ast0.wrap(Ast0.Init(s,fn idtype,id,P.clt2mcode "=" q,e,
			   P.clt2mcode ";" pv))] )
# 9023 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = pv;
          MenhirLib.EngineTypes.startp = _startpos_pv_;
          MenhirLib.EngineTypes.endp = _endpos_pv_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = e;
            MenhirLib.EngineTypes.startp = _startpos_e_;
            MenhirLib.EngineTypes.endp = _endpos_e_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.semv = q;
              MenhirLib.EngineTypes.startp = _startpos_q_;
              MenhirLib.EngineTypes.endp = _endpos_q_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.semv = d;
                MenhirLib.EngineTypes.startp = _startpos_d_;
                MenhirLib.EngineTypes.endp = _endpos_d_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.semv = i;
                  MenhirLib.EngineTypes.startp = _startpos_i_;
                  MenhirLib.EngineTypes.endp = _endpos_i_;
                  MenhirLib.EngineTypes.next = {
                    MenhirLib.EngineTypes.state = _menhir_s;
                    MenhirLib.EngineTypes.semv = x0;
                    MenhirLib.EngineTypes.startp = _startpos_x0_;
                    MenhirLib.EngineTypes.endp = _endpos_x0_;
                    MenhirLib.EngineTypes.next = _menhir_stack;
                    };
                  };
                };
              };
            };
          } = _menhir_stack in
        let pv : (
# 153 "parser_cocci_menhir.mly"
       (Data.clt)
# 9069 "parser_cocci_menhir.ml"
        ) = Obj.magic pv in
        let e : 'tv_initialize = Obj.magic e in
        let q : (
# 153 "parser_cocci_menhir.mly"
       (Data.clt)
# 9075 "parser_cocci_menhir.ml"
        ) = Obj.magic q in
        let d : 'tv_d_ident = Obj.magic d in
        let i : 'tv_pure_ident_or_symbol = Obj.magic i in
        let x0 : 'tv_storage = Obj.magic x0 in
        let _startpos = _startpos_x0_ in
        let _endpos = _endpos_pv_ in
        let _v : 'tv_decl_var = let cv =
          
# 39 "standard.mly"
    ( None )
# 9086 "parser_cocci_menhir.ml"
          
        in
        let s =
          let x = x0 in
          
# 41 "standard.mly"
    ( Some x )
# 9094 "parser_cocci_menhir.ml"
          
        in
        
# 1230 "parser_cocci_menhir.mly"
      ( let (id,fn) = d in
      !Data.add_type_name (P.id2name i);
      let idtype = P.make_cv cv (Ast0.wrap (Ast0.TypeName(P.id2mcode i))) in
      [Ast0.wrap(Ast0.Init(s,fn idtype,id,P.clt2mcode "=" q,e,
			   P.clt2mcode ";" pv))] )
# 9104 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = pv;
          MenhirLib.EngineTypes.startp = _startpos_pv_;
          MenhirLib.EngineTypes.endp = _endpos_pv_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = e;
            MenhirLib.EngineTypes.startp = _startpos_e_;
            MenhirLib.EngineTypes.endp = _endpos_e_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.semv = q;
              MenhirLib.EngineTypes.startp = _startpos_q_;
              MenhirLib.EngineTypes.endp = _endpos_q_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.semv = d;
                MenhirLib.EngineTypes.startp = _startpos_d_;
                MenhirLib.EngineTypes.endp = _endpos_d_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.semv = i;
                  MenhirLib.EngineTypes.startp = _startpos_i_;
                  MenhirLib.EngineTypes.endp = _endpos_i_;
                  MenhirLib.EngineTypes.next = {
                    MenhirLib.EngineTypes.semv = x1;
                    MenhirLib.EngineTypes.startp = _startpos_x1_;
                    MenhirLib.EngineTypes.endp = _endpos_x1_;
                    MenhirLib.EngineTypes.next = {
                      MenhirLib.EngineTypes.state = _menhir_s;
                      MenhirLib.EngineTypes.semv = x0;
                      MenhirLib.EngineTypes.startp = _startpos_x0_;
                      MenhirLib.EngineTypes.endp = _endpos_x0_;
                      MenhirLib.EngineTypes.next = _menhir_stack;
                      };
                    };
                  };
                };
              };
            };
          } = _menhir_stack in
        let pv : (
# 153 "parser_cocci_menhir.mly"
       (Data.clt)
# 9155 "parser_cocci_menhir.ml"
        ) = Obj.magic pv in
        let e : 'tv_initialize = Obj.magic e in
        let q : (
# 153 "parser_cocci_menhir.mly"
       (Data.clt)
# 9161 "parser_cocci_menhir.ml"
        ) = Obj.magic q in
        let d : 'tv_d_ident = Obj.magic d in
        let i : 'tv_pure_ident_or_symbol = Obj.magic i in
        let x1 : 'tv_const_vol = Obj.magic x1 in
        let x0 : 'tv_storage = Obj.magic x0 in
        let _startpos = _startpos_x0_ in
        let _endpos = _endpos_pv_ in
        let _v : 'tv_decl_var = let cv =
          let x = x1 in
          
# 41 "standard.mly"
    ( Some x )
# 9174 "parser_cocci_menhir.ml"
          
        in
        let s =
          let x = x0 in
          
# 41 "standard.mly"
    ( Some x )
# 9182 "parser_cocci_menhir.ml"
          
        in
        
# 1230 "parser_cocci_menhir.mly"
      ( let (id,fn) = d in
      !Data.add_type_name (P.id2name i);
      let idtype = P.make_cv cv (Ast0.wrap (Ast0.TypeName(P.id2mcode i))) in
      [Ast0.wrap(Ast0.Init(s,fn idtype,id,P.clt2mcode "=" q,e,
			   P.clt2mcode ";" pv))] )
# 9192 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = pv;
          MenhirLib.EngineTypes.startp = _startpos_pv_;
          MenhirLib.EngineTypes.endp = _endpos_pv_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = rp2;
            MenhirLib.EngineTypes.startp = _startpos_rp2_;
            MenhirLib.EngineTypes.endp = _endpos_rp2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.semv = p;
              MenhirLib.EngineTypes.startp = _startpos_p_;
              MenhirLib.EngineTypes.endp = _endpos_p_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.semv = lp2;
                MenhirLib.EngineTypes.startp = _startpos_lp2_;
                MenhirLib.EngineTypes.endp = _endpos_lp2_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.semv = rp1;
                  MenhirLib.EngineTypes.startp = _startpos_rp1_;
                  MenhirLib.EngineTypes.endp = _endpos_rp1_;
                  MenhirLib.EngineTypes.next = {
                    MenhirLib.EngineTypes.semv = d;
                    MenhirLib.EngineTypes.startp = _startpos_d_;
                    MenhirLib.EngineTypes.endp = _endpos_d_;
                    MenhirLib.EngineTypes.next = {
                      MenhirLib.EngineTypes.semv = st;
                      MenhirLib.EngineTypes.startp = _startpos_st_;
                      MenhirLib.EngineTypes.endp = _endpos_st_;
                      MenhirLib.EngineTypes.next = {
                        MenhirLib.EngineTypes.semv = lp1;
                        MenhirLib.EngineTypes.startp = _startpos_lp1_;
                        MenhirLib.EngineTypes.endp = _endpos_lp1_;
                        MenhirLib.EngineTypes.next = {
                          MenhirLib.EngineTypes.state = _menhir_s;
                          MenhirLib.EngineTypes.semv = t;
                          MenhirLib.EngineTypes.startp = _startpos_t_;
                          MenhirLib.EngineTypes.endp = _endpos_t_;
                          MenhirLib.EngineTypes.next = _menhir_stack;
                          };
                        };
                      };
                    };
                  };
                };
              };
            };
          } = _menhir_stack in
        let pv : (
# 153 "parser_cocci_menhir.mly"
       (Data.clt)
# 9253 "parser_cocci_menhir.ml"
        ) = Obj.magic pv in
        let rp2 : (
# 123 "parser_cocci_menhir.mly"
       (Data.clt)
# 9258 "parser_cocci_menhir.ml"
        ) = Obj.magic rp2 in
        let p : 'tv_decl_list_name_opt_decl_ = Obj.magic p in
        let lp2 : (
# 122 "parser_cocci_menhir.mly"
       (Data.clt)
# 9264 "parser_cocci_menhir.ml"
        ) = Obj.magic lp2 in
        let rp1 : (
# 123 "parser_cocci_menhir.mly"
       (Data.clt)
# 9269 "parser_cocci_menhir.ml"
        ) = Obj.magic rp1 in
        let d : 'tv_d_ident = Obj.magic d in
        let st : (
# 145 "parser_cocci_menhir.mly"
       (Data.clt)
# 9275 "parser_cocci_menhir.ml"
        ) = Obj.magic st in
        let lp1 : (
# 122 "parser_cocci_menhir.mly"
       (Data.clt)
# 9280 "parser_cocci_menhir.ml"
        ) = Obj.magic lp1 in
        let t : 'tv_ctype = Obj.magic t in
        let _startpos = _startpos_t_ in
        let _endpos = _endpos_pv_ in
        let _v : 'tv_decl_var = let s =
          
# 39 "standard.mly"
    ( None )
# 9289 "parser_cocci_menhir.ml"
          
        in
        
# 1240 "parser_cocci_menhir.mly"
      ( let (id,fn) = d in
        let t =
	  Ast0.wrap
	    (Ast0.FunctionPointer
	       (t,P.clt2mcode "(" lp1,P.clt2mcode "*" st,P.clt2mcode ")" rp1,
		P.clt2mcode "(" lp2,p,P.clt2mcode ")" rp2)) in
        [Ast0.wrap(Ast0.UnInit(s,fn t,id,P.clt2mcode ";" pv))] )
# 9301 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = pv;
          MenhirLib.EngineTypes.startp = _startpos_pv_;
          MenhirLib.EngineTypes.endp = _endpos_pv_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = rp2;
            MenhirLib.EngineTypes.startp = _startpos_rp2_;
            MenhirLib.EngineTypes.endp = _endpos_rp2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.semv = p;
              MenhirLib.EngineTypes.startp = _startpos_p_;
              MenhirLib.EngineTypes.endp = _endpos_p_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.semv = lp2;
                MenhirLib.EngineTypes.startp = _startpos_lp2_;
                MenhirLib.EngineTypes.endp = _endpos_lp2_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.semv = rp1;
                  MenhirLib.EngineTypes.startp = _startpos_rp1_;
                  MenhirLib.EngineTypes.endp = _endpos_rp1_;
                  MenhirLib.EngineTypes.next = {
                    MenhirLib.EngineTypes.semv = d;
                    MenhirLib.EngineTypes.startp = _startpos_d_;
                    MenhirLib.EngineTypes.endp = _endpos_d_;
                    MenhirLib.EngineTypes.next = {
                      MenhirLib.EngineTypes.semv = st;
                      MenhirLib.EngineTypes.startp = _startpos_st_;
                      MenhirLib.EngineTypes.endp = _endpos_st_;
                      MenhirLib.EngineTypes.next = {
                        MenhirLib.EngineTypes.semv = lp1;
                        MenhirLib.EngineTypes.startp = _startpos_lp1_;
                        MenhirLib.EngineTypes.endp = _endpos_lp1_;
                        MenhirLib.EngineTypes.next = {
                          MenhirLib.EngineTypes.semv = t;
                          MenhirLib.EngineTypes.startp = _startpos_t_;
                          MenhirLib.EngineTypes.endp = _endpos_t_;
                          MenhirLib.EngineTypes.next = {
                            MenhirLib.EngineTypes.state = _menhir_s;
                            MenhirLib.EngineTypes.semv = x0;
                            MenhirLib.EngineTypes.startp = _startpos_x0_;
                            MenhirLib.EngineTypes.endp = _endpos_x0_;
                            MenhirLib.EngineTypes.next = _menhir_stack;
                            };
                          };
                        };
                      };
                    };
                  };
                };
              };
            };
          } = _menhir_stack in
        let pv : (
# 153 "parser_cocci_menhir.mly"
       (Data.clt)
# 9367 "parser_cocci_menhir.ml"
        ) = Obj.magic pv in
        let rp2 : (
# 123 "parser_cocci_menhir.mly"
       (Data.clt)
# 9372 "parser_cocci_menhir.ml"
        ) = Obj.magic rp2 in
        let p : 'tv_decl_list_name_opt_decl_ = Obj.magic p in
        let lp2 : (
# 122 "parser_cocci_menhir.mly"
       (Data.clt)
# 9378 "parser_cocci_menhir.ml"
        ) = Obj.magic lp2 in
        let rp1 : (
# 123 "parser_cocci_menhir.mly"
       (Data.clt)
# 9383 "parser_cocci_menhir.ml"
        ) = Obj.magic rp1 in
        let d : 'tv_d_ident = Obj.magic d in
        let st : (
# 145 "parser_cocci_menhir.mly"
       (Data.clt)
# 9389 "parser_cocci_menhir.ml"
        ) = Obj.magic st in
        let lp1 : (
# 122 "parser_cocci_menhir.mly"
       (Data.clt)
# 9394 "parser_cocci_menhir.ml"
        ) = Obj.magic lp1 in
        let t : 'tv_ctype = Obj.magic t in
        let x0 : 'tv_storage = Obj.magic x0 in
        let _startpos = _startpos_x0_ in
        let _endpos = _endpos_pv_ in
        let _v : 'tv_decl_var = let s =
          let x = x0 in
          
# 41 "standard.mly"
    ( Some x )
# 9405 "parser_cocci_menhir.ml"
          
        in
        
# 1240 "parser_cocci_menhir.mly"
      ( let (id,fn) = d in
        let t =
	  Ast0.wrap
	    (Ast0.FunctionPointer
	       (t,P.clt2mcode "(" lp1,P.clt2mcode "*" st,P.clt2mcode ")" rp1,
		P.clt2mcode "(" lp2,p,P.clt2mcode ")" rp2)) in
        [Ast0.wrap(Ast0.UnInit(s,fn t,id,P.clt2mcode ";" pv))] )
# 9417 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _5;
          MenhirLib.EngineTypes.startp = _startpos__5_;
          MenhirLib.EngineTypes.endp = _endpos__5_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _4;
            MenhirLib.EngineTypes.startp = _startpos__4_;
            MenhirLib.EngineTypes.endp = _endpos__4_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.semv = _3;
              MenhirLib.EngineTypes.startp = _startpos__3_;
              MenhirLib.EngineTypes.endp = _endpos__3_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.semv = _2;
                MenhirLib.EngineTypes.startp = _startpos__2_;
                MenhirLib.EngineTypes.endp = _endpos__2_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.state = _menhir_s;
                  MenhirLib.EngineTypes.semv = _1;
                  MenhirLib.EngineTypes.startp = _startpos__1_;
                  MenhirLib.EngineTypes.endp = _endpos__1_;
                  MenhirLib.EngineTypes.next = _menhir_stack;
                  };
                };
              };
            };
          } = _menhir_stack in
        let _5 : (
# 153 "parser_cocci_menhir.mly"
       (Data.clt)
# 9458 "parser_cocci_menhir.ml"
        ) = Obj.magic _5 in
        let _4 : (
# 123 "parser_cocci_menhir.mly"
       (Data.clt)
# 9463 "parser_cocci_menhir.ml"
        ) = Obj.magic _4 in
        let _3 : 'tv_eexpr_list_option = Obj.magic _3 in
        let _2 : (
# 122 "parser_cocci_menhir.mly"
       (Data.clt)
# 9469 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_decl_ident = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__5_ in
        let _v : 'tv_decl_var = 
# 1248 "parser_cocci_menhir.mly"
      ( [Ast0.wrap(Ast0.MacroDecl(_1,P.clt2mcode "(" _2,_3,
				  P.clt2mcode ")" _4,P.clt2mcode ";" _5))] )
# 9478 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _7;
          MenhirLib.EngineTypes.startp = _startpos__7_;
          MenhirLib.EngineTypes.endp = _endpos__7_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = e;
            MenhirLib.EngineTypes.startp = _startpos_e_;
            MenhirLib.EngineTypes.endp = _endpos_e_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.semv = q;
              MenhirLib.EngineTypes.startp = _startpos_q_;
              MenhirLib.EngineTypes.endp = _endpos_q_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.semv = _4;
                MenhirLib.EngineTypes.startp = _startpos__4_;
                MenhirLib.EngineTypes.endp = _endpos__4_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.semv = _3;
                  MenhirLib.EngineTypes.startp = _startpos__3_;
                  MenhirLib.EngineTypes.endp = _endpos__3_;
                  MenhirLib.EngineTypes.next = {
                    MenhirLib.EngineTypes.semv = _2;
                    MenhirLib.EngineTypes.startp = _startpos__2_;
                    MenhirLib.EngineTypes.endp = _endpos__2_;
                    MenhirLib.EngineTypes.next = {
                      MenhirLib.EngineTypes.state = _menhir_s;
                      MenhirLib.EngineTypes.semv = _1;
                      MenhirLib.EngineTypes.startp = _startpos__1_;
                      MenhirLib.EngineTypes.endp = _endpos__1_;
                      MenhirLib.EngineTypes.next = _menhir_stack;
                      };
                    };
                  };
                };
              };
            };
          } = _menhir_stack in
        let _7 : (
# 153 "parser_cocci_menhir.mly"
       (Data.clt)
# 9529 "parser_cocci_menhir.ml"
        ) = Obj.magic _7 in
        let e : 'tv_initialize = Obj.magic e in
        let q : (
# 153 "parser_cocci_menhir.mly"
       (Data.clt)
# 9535 "parser_cocci_menhir.ml"
        ) = Obj.magic q in
        let _4 : (
# 123 "parser_cocci_menhir.mly"
       (Data.clt)
# 9540 "parser_cocci_menhir.ml"
        ) = Obj.magic _4 in
        let _3 : 'tv_eexpr_list_option = Obj.magic _3 in
        let _2 : (
# 122 "parser_cocci_menhir.mly"
       (Data.clt)
# 9546 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_decl_ident = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__7_ in
        let _v : 'tv_decl_var = 
# 1251 "parser_cocci_menhir.mly"
      ( [Ast0.wrap
	    (Ast0.MacroDeclInit
	       (_1,P.clt2mcode "(" _2,_3,
		P.clt2mcode ")" _4,P.clt2mcode "=" q,e,
		P.clt2mcode ";" _7))] )
# 9558 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = pv;
          MenhirLib.EngineTypes.startp = _startpos_pv_;
          MenhirLib.EngineTypes.endp = _endpos_pv_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = e;
            MenhirLib.EngineTypes.startp = _startpos_e_;
            MenhirLib.EngineTypes.endp = _endpos_e_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.semv = q;
              MenhirLib.EngineTypes.startp = _startpos_q_;
              MenhirLib.EngineTypes.endp = _endpos_q_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.semv = rp2;
                MenhirLib.EngineTypes.startp = _startpos_rp2_;
                MenhirLib.EngineTypes.endp = _endpos_rp2_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.semv = p;
                  MenhirLib.EngineTypes.startp = _startpos_p_;
                  MenhirLib.EngineTypes.endp = _endpos_p_;
                  MenhirLib.EngineTypes.next = {
                    MenhirLib.EngineTypes.semv = lp2;
                    MenhirLib.EngineTypes.startp = _startpos_lp2_;
                    MenhirLib.EngineTypes.endp = _endpos_lp2_;
                    MenhirLib.EngineTypes.next = {
                      MenhirLib.EngineTypes.semv = rp1;
                      MenhirLib.EngineTypes.startp = _startpos_rp1_;
                      MenhirLib.EngineTypes.endp = _endpos_rp1_;
                      MenhirLib.EngineTypes.next = {
                        MenhirLib.EngineTypes.semv = d;
                        MenhirLib.EngineTypes.startp = _startpos_d_;
                        MenhirLib.EngineTypes.endp = _endpos_d_;
                        MenhirLib.EngineTypes.next = {
                          MenhirLib.EngineTypes.semv = st;
                          MenhirLib.EngineTypes.startp = _startpos_st_;
                          MenhirLib.EngineTypes.endp = _endpos_st_;
                          MenhirLib.EngineTypes.next = {
                            MenhirLib.EngineTypes.semv = lp1;
                            MenhirLib.EngineTypes.startp = _startpos_lp1_;
                            MenhirLib.EngineTypes.endp = _endpos_lp1_;
                            MenhirLib.EngineTypes.next = {
                              MenhirLib.EngineTypes.state = _menhir_s;
                              MenhirLib.EngineTypes.semv = t;
                              MenhirLib.EngineTypes.startp = _startpos_t_;
                              MenhirLib.EngineTypes.endp = _endpos_t_;
                              MenhirLib.EngineTypes.next = _menhir_stack;
                              };
                            };
                          };
                        };
                      };
                    };
                  };
                };
              };
            };
          } = _menhir_stack in
        let pv : (
# 153 "parser_cocci_menhir.mly"
       (Data.clt)
# 9629 "parser_cocci_menhir.ml"
        ) = Obj.magic pv in
        let e : 'tv_initialize = Obj.magic e in
        let q : (
# 153 "parser_cocci_menhir.mly"
       (Data.clt)
# 9635 "parser_cocci_menhir.ml"
        ) = Obj.magic q in
        let rp2 : (
# 123 "parser_cocci_menhir.mly"
       (Data.clt)
# 9640 "parser_cocci_menhir.ml"
        ) = Obj.magic rp2 in
        let p : 'tv_decl_list_name_opt_decl_ = Obj.magic p in
        let lp2 : (
# 122 "parser_cocci_menhir.mly"
       (Data.clt)
# 9646 "parser_cocci_menhir.ml"
        ) = Obj.magic lp2 in
        let rp1 : (
# 123 "parser_cocci_menhir.mly"
       (Data.clt)
# 9651 "parser_cocci_menhir.ml"
        ) = Obj.magic rp1 in
        let d : 'tv_d_ident = Obj.magic d in
        let st : (
# 145 "parser_cocci_menhir.mly"
       (Data.clt)
# 9657 "parser_cocci_menhir.ml"
        ) = Obj.magic st in
        let lp1 : (
# 122 "parser_cocci_menhir.mly"
       (Data.clt)
# 9662 "parser_cocci_menhir.ml"
        ) = Obj.magic lp1 in
        let t : 'tv_ctype = Obj.magic t in
        let _startpos = _startpos_t_ in
        let _endpos = _endpos_pv_ in
        let _v : 'tv_decl_var = let s =
          
# 39 "standard.mly"
    ( None )
# 9671 "parser_cocci_menhir.ml"
          
        in
        
# 1260 "parser_cocci_menhir.mly"
      ( let (id,fn) = d in
        let t =
	  Ast0.wrap
	    (Ast0.FunctionPointer
	       (t,P.clt2mcode "(" lp1,P.clt2mcode "*" st,P.clt2mcode ")" rp1,
		P.clt2mcode "(" lp2,p,P.clt2mcode ")" rp2)) in
      [Ast0.wrap(Ast0.Init(s,fn t,id,P.clt2mcode "=" q,e,P.clt2mcode ";" pv))])
# 9683 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = pv;
          MenhirLib.EngineTypes.startp = _startpos_pv_;
          MenhirLib.EngineTypes.endp = _endpos_pv_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = e;
            MenhirLib.EngineTypes.startp = _startpos_e_;
            MenhirLib.EngineTypes.endp = _endpos_e_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.semv = q;
              MenhirLib.EngineTypes.startp = _startpos_q_;
              MenhirLib.EngineTypes.endp = _endpos_q_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.semv = rp2;
                MenhirLib.EngineTypes.startp = _startpos_rp2_;
                MenhirLib.EngineTypes.endp = _endpos_rp2_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.semv = p;
                  MenhirLib.EngineTypes.startp = _startpos_p_;
                  MenhirLib.EngineTypes.endp = _endpos_p_;
                  MenhirLib.EngineTypes.next = {
                    MenhirLib.EngineTypes.semv = lp2;
                    MenhirLib.EngineTypes.startp = _startpos_lp2_;
                    MenhirLib.EngineTypes.endp = _endpos_lp2_;
                    MenhirLib.EngineTypes.next = {
                      MenhirLib.EngineTypes.semv = rp1;
                      MenhirLib.EngineTypes.startp = _startpos_rp1_;
                      MenhirLib.EngineTypes.endp = _endpos_rp1_;
                      MenhirLib.EngineTypes.next = {
                        MenhirLib.EngineTypes.semv = d;
                        MenhirLib.EngineTypes.startp = _startpos_d_;
                        MenhirLib.EngineTypes.endp = _endpos_d_;
                        MenhirLib.EngineTypes.next = {
                          MenhirLib.EngineTypes.semv = st;
                          MenhirLib.EngineTypes.startp = _startpos_st_;
                          MenhirLib.EngineTypes.endp = _endpos_st_;
                          MenhirLib.EngineTypes.next = {
                            MenhirLib.EngineTypes.semv = lp1;
                            MenhirLib.EngineTypes.startp = _startpos_lp1_;
                            MenhirLib.EngineTypes.endp = _endpos_lp1_;
                            MenhirLib.EngineTypes.next = {
                              MenhirLib.EngineTypes.semv = t;
                              MenhirLib.EngineTypes.startp = _startpos_t_;
                              MenhirLib.EngineTypes.endp = _endpos_t_;
                              MenhirLib.EngineTypes.next = {
                                MenhirLib.EngineTypes.state = _menhir_s;
                                MenhirLib.EngineTypes.semv = x0;
                                MenhirLib.EngineTypes.startp = _startpos_x0_;
                                MenhirLib.EngineTypes.endp = _endpos_x0_;
                                MenhirLib.EngineTypes.next = _menhir_stack;
                                };
                              };
                            };
                          };
                        };
                      };
                    };
                  };
                };
              };
            };
          } = _menhir_stack in
        let pv : (
# 153 "parser_cocci_menhir.mly"
       (Data.clt)
# 9759 "parser_cocci_menhir.ml"
        ) = Obj.magic pv in
        let e : 'tv_initialize = Obj.magic e in
        let q : (
# 153 "parser_cocci_menhir.mly"
       (Data.clt)
# 9765 "parser_cocci_menhir.ml"
        ) = Obj.magic q in
        let rp2 : (
# 123 "parser_cocci_menhir.mly"
       (Data.clt)
# 9770 "parser_cocci_menhir.ml"
        ) = Obj.magic rp2 in
        let p : 'tv_decl_list_name_opt_decl_ = Obj.magic p in
        let lp2 : (
# 122 "parser_cocci_menhir.mly"
       (Data.clt)
# 9776 "parser_cocci_menhir.ml"
        ) = Obj.magic lp2 in
        let rp1 : (
# 123 "parser_cocci_menhir.mly"
       (Data.clt)
# 9781 "parser_cocci_menhir.ml"
        ) = Obj.magic rp1 in
        let d : 'tv_d_ident = Obj.magic d in
        let st : (
# 145 "parser_cocci_menhir.mly"
       (Data.clt)
# 9787 "parser_cocci_menhir.ml"
        ) = Obj.magic st in
        let lp1 : (
# 122 "parser_cocci_menhir.mly"
       (Data.clt)
# 9792 "parser_cocci_menhir.ml"
        ) = Obj.magic lp1 in
        let t : 'tv_ctype = Obj.magic t in
        let x0 : 'tv_storage = Obj.magic x0 in
        let _startpos = _startpos_x0_ in
        let _endpos = _endpos_pv_ in
        let _v : 'tv_decl_var = let s =
          let x = x0 in
          
# 41 "standard.mly"
    ( Some x )
# 9803 "parser_cocci_menhir.ml"
          
        in
        
# 1260 "parser_cocci_menhir.mly"
      ( let (id,fn) = d in
        let t =
	  Ast0.wrap
	    (Ast0.FunctionPointer
	       (t,P.clt2mcode "(" lp1,P.clt2mcode "*" st,P.clt2mcode ")" rp1,
		P.clt2mcode "(" lp2,p,P.clt2mcode ")" rp2)) in
      [Ast0.wrap(Ast0.Init(s,fn t,id,P.clt2mcode "=" q,e,P.clt2mcode ";" pv))])
# 9815 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = pv;
          MenhirLib.EngineTypes.startp = _startpos_pv_;
          MenhirLib.EngineTypes.endp = _endpos_pv_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = id;
            MenhirLib.EngineTypes.startp = _startpos_id_;
            MenhirLib.EngineTypes.endp = _endpos_id_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.semv = t;
              MenhirLib.EngineTypes.startp = _startpos_t_;
              MenhirLib.EngineTypes.endp = _endpos_t_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.semv = s;
                MenhirLib.EngineTypes.startp = _startpos_s_;
                MenhirLib.EngineTypes.endp = _endpos_s_;
                MenhirLib.EngineTypes.next = _menhir_stack;
                };
              };
            };
          } = _menhir_stack in
        let pv : (
# 153 "parser_cocci_menhir.mly"
       (Data.clt)
# 9851 "parser_cocci_menhir.ml"
        ) = Obj.magic pv in
        let id : 'tv_comma_list_typedef_ident_ = Obj.magic id in
        let t : 'tv_typedef_ctype = Obj.magic t in
        let s : (
# 95 "parser_cocci_menhir.mly"
      (Data.clt)
# 9858 "parser_cocci_menhir.ml"
        ) = Obj.magic s in
        let _startpos = _startpos_s_ in
        let _endpos = _endpos_pv_ in
        let _v : 'tv_decl_var = 
# 1268 "parser_cocci_menhir.mly"
      ( let s = P.clt2mcode "typedef" s in
        List.map
	  (function id ->
	    Ast0.wrap(Ast0.Typedef(s,t,id,P.clt2mcode ";" pv)))
	  id )
# 9869 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_empty_list_start_dparam_TEllipsis_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_define_param_list_option = 
# 985 "parser_cocci_menhir.mly"
      ( Ast0.wrap
	  (Ast0.DOTS
	     (_1
		(fun _ d -> Ast0.wrap(Ast0.DPdots(P.clt2mcode "," d)))
		(fun c -> Ast0.DPComma c))) )
# 9897 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : (
# 127 "parser_cocci_menhir.mly"
       (Data.clt * token)
# 9918 "parser_cocci_menhir.ml"
        ) = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_defineop = 
# 929 "parser_cocci_menhir.mly"
    ( let (clt,ident) = _1 in
      let aft = P.get_aft clt in (* move stuff after the define to the ident *)
      function body ->
	Ast0.wrap
	  (Ast0.Define
	     (P.clt2mcode "#define" (P.drop_aft clt),
	      (match ident with
		TMetaId((nm,constraints,seed,pure,clt)) ->
		  let clt = P.set_aft aft clt in
		  Ast0.wrap
		    (Ast0.MetaId(P.clt2mcode nm clt,constraints,seed,pure))
	      | TIdent((nm,clt)) ->
		  let clt = P.set_aft aft clt in
		  Ast0.wrap(Ast0.Id(P.clt2mcode nm clt))
	      | TSymId(nm,clt) ->
		  let clt = P.set_aft aft clt in
		  Ast0.wrap(Ast0.Id(P.clt2mcode nm clt))
	      | _ ->
		  raise
		    (Semantic_cocci.Semantic
		       "unexpected name for a #define")),
	      Ast0.wrap Ast0.NoParams,
	      body)) )
# 9947 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : (
# 123 "parser_cocci_menhir.mly"
       (Data.clt)
# 9978 "parser_cocci_menhir.ml"
        ) = Obj.magic _3 in
        let _2 : 'tv_define_param_list_option = Obj.magic _2 in
        let _1 : (
# 128 "parser_cocci_menhir.mly"
       (Data.clt * token * int * int)
# 9984 "parser_cocci_menhir.ml"
        ) = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_defineop = 
# 953 "parser_cocci_menhir.mly"
    ( let (clt,ident,parenoff,parencol) = _1 in
      let aft = P.get_aft clt in (* move stuff after the define to the ( *)
      (* clt is the start of the #define itself *)
      let (arity,line,lline,offset,col,strbef,straft,pos) = clt in
      let lp =
	P.clt2mcode "("
	  (arity,line,lline,parenoff,parencol,[],[],[]) in
      function body ->
	Ast0.wrap
	  (Ast0.Define
	     (P.clt2mcode "#define" (P.drop_aft clt),
	      (match ident with
		TMetaId((nm,constraints,seed,pure,clt)) ->
		  Ast0.wrap
		    (Ast0.MetaId(P.clt2mcode nm clt,constraints,seed,pure))
	      | TIdent((nm,clt)) ->
		  Ast0.wrap(Ast0.Id(P.clt2mcode nm clt))
	      | TSymId(nm,clt) ->
		  Ast0.wrap(Ast0.Id(P.clt2mcode nm clt))
	      | _ ->
		  raise
		    (Semantic_cocci.Semantic
		       "unexpected name for a #define")),
	      (let clt = P.set_aft aft _3 in
	      Ast0.wrap (Ast0.DParams (lp,_2,P.clt2mcode ")" clt))),body)) )
# 10015 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : (
# 88 "parser_cocci_menhir.mly"
      (string)
# 10036 "parser_cocci_menhir.ml"
        ) = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_dep = 
# 273 "parser_cocci_menhir.mly"
                   ( Ast0.Dep _1 )
# 10043 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _2;
          MenhirLib.EngineTypes.startp = _startpos__2_;
          MenhirLib.EngineTypes.endp = _endpos__2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let _2 : (
# 88 "parser_cocci_menhir.mly"
      (string)
# 10068 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__2_ in
        let _v : 'tv_dep = 
# 274 "parser_cocci_menhir.mly"
                   ( Ast0.AntiDep (Ast0.Dep _2) )
# 10075 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.startp = _startpos__4_;
          MenhirLib.EngineTypes.endp = _endpos__4_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _3;
            MenhirLib.EngineTypes.startp = _startpos__3_;
            MenhirLib.EngineTypes.endp = _endpos__3_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.startp = _startpos__2_;
              MenhirLib.EngineTypes.endp = _endpos__2_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.startp = _startpos__1_;
                MenhirLib.EngineTypes.endp = _endpos__1_;
                MenhirLib.EngineTypes.next = _menhir_stack;
                };
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_dep = Obj.magic _3 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__4_ in
        let _v : 'tv_dep = 
# 276 "parser_cocci_menhir.mly"
                   ( Ast0.AntiDep _3 )
# 10111 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _2;
          MenhirLib.EngineTypes.startp = _startpos__2_;
          MenhirLib.EngineTypes.endp = _endpos__2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let _2 : (
# 88 "parser_cocci_menhir.mly"
      (string)
# 10136 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__2_ in
        let _v : 'tv_dep = 
# 277 "parser_cocci_menhir.mly"
                   ( Ast0.EverDep _2 )
# 10143 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _2;
          MenhirLib.EngineTypes.startp = _startpos__2_;
          MenhirLib.EngineTypes.endp = _endpos__2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let _2 : (
# 88 "parser_cocci_menhir.mly"
      (string)
# 10168 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__2_ in
        let _v : 'tv_dep = 
# 278 "parser_cocci_menhir.mly"
                   ( Ast0.NeverDep _2 )
# 10175 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_dep = Obj.magic _3 in
        let _1 : 'tv_dep = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_dep = 
# 279 "parser_cocci_menhir.mly"
                   ( Ast0.AndDep(_1, _3) )
# 10209 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_dep = Obj.magic _3 in
        let _1 : 'tv_dep = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_dep = 
# 280 "parser_cocci_menhir.mly"
                   ( Ast0.OrDep (_1, _3) )
# 10243 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _2 : 'tv_dep = Obj.magic _2 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_dep = 
# 281 "parser_cocci_menhir.mly"
                   ( _2 )
# 10275 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let _menhir_s = _menhir_env.MenhirLib.EngineTypes.current in
        let _startpos = _menhir_env.MenhirLib.EngineTypes.lexbuf.Lexing.lex_start_p in
        let _endpos = _startpos in
        let _v : 'tv_depends = 
# 269 "parser_cocci_menhir.mly"
                           ( Ast0.NoDep )
# 10292 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = parents;
          MenhirLib.EngineTypes.startp = _startpos_parents_;
          MenhirLib.EngineTypes.endp = _endpos_parents_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let parents : 'tv_dep = Obj.magic parents in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos_parents_ in
        let _v : 'tv_depends = 
# 270 "parser_cocci_menhir.mly"
                           ( parents )
# 10324 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _2;
          MenhirLib.EngineTypes.startp = _startpos__2_;
          MenhirLib.EngineTypes.endp = _endpos__2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let _2 : 'tv_disj_ident = Obj.magic _2 in
        let _1 : (
# 153 "parser_cocci_menhir.mly"
       (Data.clt)
# 10351 "parser_cocci_menhir.ml"
        ) = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__2_ in
        let _v : 'tv_designator = 
# 1384 "parser_cocci_menhir.mly"
     ( Ast0.DesignatorField (P.clt2mcode "." _1,_2) )
# 10358 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : (
# 148 "parser_cocci_menhir.mly"
       (Data.clt)
# 10389 "parser_cocci_menhir.ml"
        ) = Obj.magic _3 in
        let _2 : 'tv_eexpr = Obj.magic _2 in
        let _1 : (
# 148 "parser_cocci_menhir.mly"
       (Data.clt)
# 10395 "parser_cocci_menhir.ml"
        ) = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_designator = 
# 1386 "parser_cocci_menhir.mly"
     ( Ast0.DesignatorIndex (P.clt2mcode "[" _1,_2,P.clt2mcode "]" _3) )
# 10402 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _5;
          MenhirLib.EngineTypes.startp = _startpos__5_;
          MenhirLib.EngineTypes.endp = _endpos__5_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _4;
            MenhirLib.EngineTypes.startp = _startpos__4_;
            MenhirLib.EngineTypes.endp = _endpos__4_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.semv = _3;
              MenhirLib.EngineTypes.startp = _startpos__3_;
              MenhirLib.EngineTypes.endp = _endpos__3_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.semv = _2;
                MenhirLib.EngineTypes.startp = _startpos__2_;
                MenhirLib.EngineTypes.endp = _endpos__2_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.state = _menhir_s;
                  MenhirLib.EngineTypes.semv = _1;
                  MenhirLib.EngineTypes.startp = _startpos__1_;
                  MenhirLib.EngineTypes.endp = _endpos__1_;
                  MenhirLib.EngineTypes.next = _menhir_stack;
                  };
                };
              };
            };
          } = _menhir_stack in
        let _5 : (
# 148 "parser_cocci_menhir.mly"
       (Data.clt)
# 10443 "parser_cocci_menhir.ml"
        ) = Obj.magic _5 in
        let _4 : 'tv_eexpr = Obj.magic _4 in
        let _3 : (
# 119 "parser_cocci_menhir.mly"
       (Data.clt)
# 10449 "parser_cocci_menhir.ml"
        ) = Obj.magic _3 in
        let _2 : 'tv_eexpr = Obj.magic _2 in
        let _1 : (
# 148 "parser_cocci_menhir.mly"
       (Data.clt)
# 10455 "parser_cocci_menhir.ml"
        ) = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__5_ in
        let _v : 'tv_designator = 
# 1388 "parser_cocci_menhir.mly"
     ( Ast0.DesignatorRange (P.clt2mcode "[" _1,_2,P.clt2mcode "..." _3,
			     _4,P.clt2mcode "]" _5) )
# 10463 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_pre_basic_expr_eexpr_nest_expressions_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_dexpr = 
# 1471 "parser_cocci_menhir.mly"
                                              ( _1 )
# 10487 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _2;
          MenhirLib.EngineTypes.startp = _startpos__2_;
          MenhirLib.EngineTypes.endp = _endpos__2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let _2 : 'tv_separated_nonempty_list_TComma_pure_ident_ = Obj.magic _2 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__2_ in
        let _v : 'tv_disable = 
# 287 "parser_cocci_menhir.mly"
                                                      ( List.map P.id2name _2 )
# 10515 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_mident = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_disj_ident = 
# 2039 "parser_cocci_menhir.mly"
              ( _1 )
# 10539 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = rp;
          MenhirLib.EngineTypes.startp = _startpos_rp_;
          MenhirLib.EngineTypes.endp = _endpos_rp_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = t;
            MenhirLib.EngineTypes.startp = _startpos_t_;
            MenhirLib.EngineTypes.endp = _endpos_t_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = lp;
              MenhirLib.EngineTypes.startp = _startpos_lp_;
              MenhirLib.EngineTypes.endp = _endpos_lp_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let rp : (
# 123 "parser_cocci_menhir.mly"
       (Data.clt)
# 10570 "parser_cocci_menhir.ml"
        ) = Obj.magic rp in
        let t : 'tv_midzero_list_disj_ident_disj_ident_ = Obj.magic t in
        let lp : (
# 122 "parser_cocci_menhir.mly"
       (Data.clt)
# 10576 "parser_cocci_menhir.ml"
        ) = Obj.magic lp in
        let _startpos = _startpos_lp_ in
        let _endpos = _endpos_rp_ in
        let _v : 'tv_disj_ident = 
# 2041 "parser_cocci_menhir.mly"
  ( let (mids,code) = t in
	 Ast0.wrap
	   (Ast0.DisjId(P.clt2mcode "(" lp,code,mids, P.clt2mcode ")" rp)) )
# 10585 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : (
# 119 "parser_cocci_menhir.mly"
       (Data.clt)
# 10606 "parser_cocci_menhir.ml"
        ) = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_dot_expressions = 
# 1481 "parser_cocci_menhir.mly"
            ( Ast0.wrap(Ast0.Edots(P.clt2mcode "..." _1,None)) )
# 10613 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_nest_expressions = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_dot_expressions = 
# 1482 "parser_cocci_menhir.mly"
                   ( _1 )
# 10637 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_mident = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_dparam = 
# 981 "parser_cocci_menhir.mly"
               ( Ast0.wrap(Ast0.DParam _1) )
# 10661 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_basic_expr_eexpr_dot_expressions_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_eargexpr = 
# 1469 "parser_cocci_menhir.mly"
                                            ( _1 )
# 10685 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = d;
          MenhirLib.EngineTypes.startp = _startpos_d_;
          MenhirLib.EngineTypes.endp = _endpos_d_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let d : (
# 119 "parser_cocci_menhir.mly"
       (Data.clt)
# 10706 "parser_cocci_menhir.ml"
        ) = Obj.magic d in
        let _startpos = _startpos_d_ in
        let _endpos = _endpos_d_ in
        let _v : 'tv_edots_when_TEllipsis_eexpr_ = 
# 2361 "parser_cocci_menhir.mly"
                                                  ( (d,None) )
# 10713 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.startp = _startpos__5_;
          MenhirLib.EngineTypes.endp = _endpos__5_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = w;
            MenhirLib.EngineTypes.startp = _startpos_w_;
            MenhirLib.EngineTypes.endp = _endpos_w_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.startp = _startpos__3_;
              MenhirLib.EngineTypes.endp = _endpos__3_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.startp = _startpos__2_;
                MenhirLib.EngineTypes.endp = _endpos__2_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.state = _menhir_s;
                  MenhirLib.EngineTypes.semv = d;
                  MenhirLib.EngineTypes.startp = _startpos_d_;
                  MenhirLib.EngineTypes.endp = _endpos_d_;
                  MenhirLib.EngineTypes.next = _menhir_stack;
                  };
                };
              };
            };
          } = _menhir_stack in
        let w : 'tv_eexpr = Obj.magic w in
        let d : (
# 119 "parser_cocci_menhir.mly"
       (Data.clt)
# 10752 "parser_cocci_menhir.ml"
        ) = Obj.magic d in
        let _startpos = _startpos_d_ in
        let _endpos = _endpos__5_ in
        let _v : 'tv_edots_when_TEllipsis_eexpr_ = 
# 2362 "parser_cocci_menhir.mly"
                                                  ( (d,Some w) )
# 10759 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = d;
          MenhirLib.EngineTypes.startp = _startpos_d_;
          MenhirLib.EngineTypes.endp = _endpos_d_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let d : (
# 119 "parser_cocci_menhir.mly"
       (Data.clt)
# 10780 "parser_cocci_menhir.ml"
        ) = Obj.magic d in
        let _startpos = _startpos_d_ in
        let _endpos = _endpos_d_ in
        let _v : 'tv_edots_when_TEllipsis_enum_decl_one_ = 
# 2361 "parser_cocci_menhir.mly"
                                                  ( (d,None) )
# 10787 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.startp = _startpos__5_;
          MenhirLib.EngineTypes.endp = _endpos__5_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = w;
            MenhirLib.EngineTypes.startp = _startpos_w_;
            MenhirLib.EngineTypes.endp = _endpos_w_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.startp = _startpos__3_;
              MenhirLib.EngineTypes.endp = _endpos__3_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.startp = _startpos__2_;
                MenhirLib.EngineTypes.endp = _endpos__2_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.state = _menhir_s;
                  MenhirLib.EngineTypes.semv = d;
                  MenhirLib.EngineTypes.startp = _startpos_d_;
                  MenhirLib.EngineTypes.endp = _endpos_d_;
                  MenhirLib.EngineTypes.next = _menhir_stack;
                  };
                };
              };
            };
          } = _menhir_stack in
        let w : 'tv_enum_decl_one = Obj.magic w in
        let d : (
# 119 "parser_cocci_menhir.mly"
       (Data.clt)
# 10826 "parser_cocci_menhir.ml"
        ) = Obj.magic d in
        let _startpos = _startpos_d_ in
        let _endpos = _endpos__5_ in
        let _v : 'tv_edots_when_TEllipsis_enum_decl_one_ = 
# 2362 "parser_cocci_menhir.mly"
                                                  ( (d,Some w) )
# 10833 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = d;
          MenhirLib.EngineTypes.startp = _startpos_d_;
          MenhirLib.EngineTypes.endp = _endpos_d_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let d : (
# 119 "parser_cocci_menhir.mly"
       (Data.clt)
# 10854 "parser_cocci_menhir.ml"
        ) = Obj.magic d in
        let _startpos = _startpos_d_ in
        let _endpos = _endpos_d_ in
        let _v : 'tv_edots_when_TEllipsis_initialize_ = 
# 2361 "parser_cocci_menhir.mly"
                                                  ( (d,None) )
# 10861 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.startp = _startpos__5_;
          MenhirLib.EngineTypes.endp = _endpos__5_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = w;
            MenhirLib.EngineTypes.startp = _startpos_w_;
            MenhirLib.EngineTypes.endp = _endpos_w_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.startp = _startpos__3_;
              MenhirLib.EngineTypes.endp = _endpos__3_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.startp = _startpos__2_;
                MenhirLib.EngineTypes.endp = _endpos__2_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.state = _menhir_s;
                  MenhirLib.EngineTypes.semv = d;
                  MenhirLib.EngineTypes.startp = _startpos_d_;
                  MenhirLib.EngineTypes.endp = _endpos_d_;
                  MenhirLib.EngineTypes.next = _menhir_stack;
                  };
                };
              };
            };
          } = _menhir_stack in
        let w : 'tv_initialize = Obj.magic w in
        let d : (
# 119 "parser_cocci_menhir.mly"
       (Data.clt)
# 10900 "parser_cocci_menhir.ml"
        ) = Obj.magic d in
        let _startpos = _startpos_d_ in
        let _endpos = _endpos__5_ in
        let _v : 'tv_edots_when_TEllipsis_initialize_ = 
# 2362 "parser_cocci_menhir.mly"
                                                  ( (d,Some w) )
# 10907 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = d;
          MenhirLib.EngineTypes.startp = _startpos_d_;
          MenhirLib.EngineTypes.endp = _endpos_d_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let d : (
# 119 "parser_cocci_menhir.mly"
       (Data.clt)
# 10928 "parser_cocci_menhir.ml"
        ) = Obj.magic d in
        let _startpos = _startpos_d_ in
        let _endpos = _endpos_d_ in
        let _v : 'tv_edots_when_TEllipsis_struct_decl_one_ = 
# 2361 "parser_cocci_menhir.mly"
                                                  ( (d,None) )
# 10935 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.startp = _startpos__5_;
          MenhirLib.EngineTypes.endp = _endpos__5_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = w;
            MenhirLib.EngineTypes.startp = _startpos_w_;
            MenhirLib.EngineTypes.endp = _endpos_w_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.startp = _startpos__3_;
              MenhirLib.EngineTypes.endp = _endpos__3_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.startp = _startpos__2_;
                MenhirLib.EngineTypes.endp = _endpos__2_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.state = _menhir_s;
                  MenhirLib.EngineTypes.semv = d;
                  MenhirLib.EngineTypes.startp = _startpos_d_;
                  MenhirLib.EngineTypes.endp = _endpos_d_;
                  MenhirLib.EngineTypes.next = _menhir_stack;
                  };
                };
              };
            };
          } = _menhir_stack in
        let w : 'tv_struct_decl_one = Obj.magic w in
        let d : (
# 119 "parser_cocci_menhir.mly"
       (Data.clt)
# 10974 "parser_cocci_menhir.ml"
        ) = Obj.magic d in
        let _startpos = _startpos_d_ in
        let _endpos = _endpos__5_ in
        let _v : 'tv_edots_when_TEllipsis_struct_decl_one_ = 
# 2362 "parser_cocci_menhir.mly"
                                                  ( (d,Some w) )
# 10981 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_pre_basic_expr_eexpr_dot_expressions_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_eexpr = 
# 1468 "parser_cocci_menhir.mly"
                                             ( _1 )
# 11005 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_empty_list_start_aexpr_TEllipsis_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_eexpr_list_option = 
# 2341 "parser_cocci_menhir.mly"
      ( Ast0.wrap
	  (Ast0.DOTS
	     (_1
		(fun _ d -> Ast0.wrap(Ast0.Edots(P.clt2mcode "..." d,None)))
		(fun c -> Ast0.EComma c))) )
# 11033 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let _menhir_s = _menhir_env.MenhirLib.EngineTypes.current in
        let _startpos = _menhir_env.MenhirLib.EngineTypes.lexbuf.Lexing.lex_start_p in
        let _endpos = _startpos in
        let _v : 'tv_empty_list_start_aexpr_TEllipsis_ = 
# 2103 "parser_cocci_menhir.mly"
              ( fun build_dots build_comma -> [] )
# 11050 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_nonempty_list_start_aexpr_TEllipsis_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_empty_list_start_aexpr_TEllipsis_ = 
# 2104 "parser_cocci_menhir.mly"
                                   ( _1 )
# 11074 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let _menhir_s = _menhir_env.MenhirLib.EngineTypes.current in
        let _startpos = _menhir_env.MenhirLib.EngineTypes.lexbuf.Lexing.lex_start_p in
        let _endpos = _startpos in
        let _v : 'tv_empty_list_start_dparam_TEllipsis_ = 
# 2103 "parser_cocci_menhir.mly"
              ( fun build_dots build_comma -> [] )
# 11091 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_nonempty_list_start_dparam_TEllipsis_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_empty_list_start_dparam_TEllipsis_ = 
# 2104 "parser_cocci_menhir.mly"
                                   ( _1 )
# 11115 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let _menhir_s = _menhir_env.MenhirLib.EngineTypes.current in
        let _startpos = _menhir_env.MenhirLib.EngineTypes.lexbuf.Lexing.lex_start_p in
        let _endpos = _startpos in
        let _v : 'tv_empty_list_start_initialize2_edots_when_TEllipsis_initialize__ = 
# 2103 "parser_cocci_menhir.mly"
              ( fun build_dots build_comma -> [] )
# 11132 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_nonempty_list_start_initialize2_edots_when_TEllipsis_initialize__ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_empty_list_start_initialize2_edots_when_TEllipsis_initialize__ = 
# 2104 "parser_cocci_menhir.mly"
                                   ( _1 )
# 11156 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let _menhir_s = _menhir_env.MenhirLib.EngineTypes.current in
        let _startpos = _menhir_env.MenhirLib.EngineTypes.lexbuf.Lexing.lex_start_p in
        let _endpos = _startpos in
        let _v : 'tv_empty_list_start_one_dec_decl__TEllipsis_ = 
# 2103 "parser_cocci_menhir.mly"
              ( fun build_dots build_comma -> [] )
# 11173 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_nonempty_list_start_one_dec_decl__TEllipsis_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_empty_list_start_one_dec_decl__TEllipsis_ = 
# 2104 "parser_cocci_menhir.mly"
                                   ( _1 )
# 11197 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let _menhir_s = _menhir_env.MenhirLib.EngineTypes.current in
        let _startpos = _menhir_env.MenhirLib.EngineTypes.lexbuf.Lexing.lex_start_p in
        let _endpos = _startpos in
        let _v : 'tv_empty_list_start_one_dec_name_opt_decl__TEllipsis_ = 
# 2103 "parser_cocci_menhir.mly"
              ( fun build_dots build_comma -> [] )
# 11214 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_nonempty_list_start_one_dec_name_opt_decl__TEllipsis_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_empty_list_start_one_dec_name_opt_decl__TEllipsis_ = 
# 2104 "parser_cocci_menhir.mly"
                                   ( _1 )
# 11238 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_nonempty_list_start_enum_decl_one_edots_when_TEllipsis_enum_decl_one__ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_enum_decl_list = 
# 827 "parser_cocci_menhir.mly"
     ( Ast0.wrap(Ast0.DOTS(_1 P.mkedots (fun c -> Ast0.EComma c))) )
# 11262 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_disj_ident = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_enum_decl_one = 
# 798 "parser_cocci_menhir.mly"
                    ( Ast0.wrap(Ast0.Ident(_1)) )
# 11286 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_enum_val = Obj.magic _3 in
        let _2 : (
# 153 "parser_cocci_menhir.mly"
       (Data.clt)
# 11318 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_disj_ident = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_enum_decl_one = 
# 800 "parser_cocci_menhir.mly"
 ( let id = Ast0.wrap(Ast0.Ident(_1)) in
	Ast0.wrap
	  (Ast0.Assignment
	     (id,P.clt2mcode Ast.SimpleAssign _2,Ast0.set_arg_exp _3,
	      false)) )
# 11330 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_ident = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_enum_val = 
# 807 "parser_cocci_menhir.mly"
            ( Ast0.wrap(Ast0.Ident(_1)) )
# 11354 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : (
# 133 "parser_cocci_menhir.mly"
       (string * Data.clt)
# 11375 "parser_cocci_menhir.ml"
        ) = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_enum_val = 
# 809 "parser_cocci_menhir.mly"
     ( let (x,clt) = _1 in
     Ast0.wrap(Ast0.Constant (P.clt2mcode (Ast.Int x) clt)) )
# 11383 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : (
# 109 "parser_cocci_menhir.mly"
       (Parse_aux.info)
# 11404 "parser_cocci_menhir.ml"
        ) = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_enum_val = 
# 811 "parser_cocci_menhir.mly"
         ( tmeta_to_exp _1 )
# 11411 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : (
# 112 "parser_cocci_menhir.mly"
       (Parse_aux.typed_expinfo)
# 11432 "parser_cocci_menhir.ml"
        ) = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_enum_val = 
# 813 "parser_cocci_menhir.mly"
     ( let (nm,constraints,pure,ty,clt) = _1 in
     Ast0.wrap
       (Ast0.MetaExpr(P.clt2mcode nm clt,constraints,ty,Ast.CONST,pure)) )
# 11441 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : (
# 112 "parser_cocci_menhir.mly"
       (Parse_aux.typed_expinfo)
# 11462 "parser_cocci_menhir.ml"
        ) = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_enum_val = 
# 817 "parser_cocci_menhir.mly"
     ( let (nm,constraints,pure,ty,clt) = _1 in
     Ast0.wrap
       (Ast0.MetaExpr(P.clt2mcode nm clt,constraints,ty,Ast.ANY,pure)) )
# 11471 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : (
# 112 "parser_cocci_menhir.mly"
       (Parse_aux.typed_expinfo)
# 11492 "parser_cocci_menhir.ml"
        ) = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_enum_val = 
# 821 "parser_cocci_menhir.mly"
     ( let (nm,constraints,pure,ty,clt) = _1 in
     Ast0.wrap
       (Ast0.MetaExpr(P.clt2mcode nm clt,constraints,ty,Ast.ID,pure)) )
# 11501 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_exists = 
# 290 "parser_cocci_menhir.mly"
          ( Ast.Exists )
# 11523 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_exists = 
# 291 "parser_cocci_menhir.mly"
          ( Ast.Forall )
# 11545 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let _menhir_s = _menhir_env.MenhirLib.EngineTypes.current in
        let _startpos = _menhir_env.MenhirLib.EngineTypes.lexbuf.Lexing.lex_start_p in
        let _endpos = _startpos in
        let _v : 'tv_exists = 
# 292 "parser_cocci_menhir.mly"
          ( Ast.Undetermined )
# 11562 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_basic_expr_expr_invalid_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_expr = 
# 1466 "parser_cocci_menhir.mly"
                                ( _1 )
# 11586 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = r;
          MenhirLib.EngineTypes.startp = _startpos_r_;
          MenhirLib.EngineTypes.endp = _endpos_r_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let r : 'tv_no_dot_start_end_dexpr_edots_when_TEllipsis_eexpr__ = Obj.magic r in
        let _startpos = _startpos_r_ in
        let _endpos = _endpos_r_ in
        let _v : 'tv_expr_dots_TEllipsis_ = 
# 1739 "parser_cocci_menhir.mly"
                                                       ( r )
# 11610 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = m;
          MenhirLib.EngineTypes.startp = _startpos_m_;
          MenhirLib.EngineTypes.endp = _endpos_m_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let m : 'tv_nonempty_list_TMul_ = Obj.magic m in
        let _startpos = _startpos_m_ in
        let _endpos = _endpos_m_ in
        let _v : 'tv_expression_type = 
# 565 "parser_cocci_menhir.mly"
                        ( P.ty_pointerify Type_cocci.Unknown m )
# 11634 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = m;
          MenhirLib.EngineTypes.startp = _startpos_m_;
          MenhirLib.EngineTypes.endp = _endpos_m_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let m : 'tv_list_TMul_ = Obj.magic m in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos_m_ in
        let _v : 'tv_expression_type = 
# 567 "parser_cocci_menhir.mly"
    ( P.ty_pointerify (Type_cocci.EnumName Type_cocci.NoName) m )
# 11662 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = m;
          MenhirLib.EngineTypes.startp = _startpos_m_;
          MenhirLib.EngineTypes.endp = _endpos_m_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let m : 'tv_list_TMul_ = Obj.magic m in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos_m_ in
        let _v : 'tv_expression_type = 
# 569 "parser_cocci_menhir.mly"
    ( P.ty_pointerify
	(Type_cocci.StructUnionName (Type_cocci.Struct,Type_cocci.NoName)) m )
# 11691 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = m;
          MenhirLib.EngineTypes.startp = _startpos_m_;
          MenhirLib.EngineTypes.endp = _endpos_m_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let m : 'tv_list_TMul_ = Obj.magic m in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos_m_ in
        let _v : 'tv_expression_type = 
# 572 "parser_cocci_menhir.mly"
    ( P.ty_pointerify
	(Type_cocci.StructUnionName (Type_cocci.Union,Type_cocci.NoName)) m )
# 11720 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let _menhir_s = _menhir_env.MenhirLib.EngineTypes.current in
        let _startpos = _menhir_env.MenhirLib.EngineTypes.lexbuf.Lexing.lex_start_p in
        let _endpos = _startpos in
        let _v : 'tv_extends = 
# 264 "parser_cocci_menhir.mly"
                                                  ( () )
# 11737 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = parent;
          MenhirLib.EngineTypes.startp = _startpos_parent_;
          MenhirLib.EngineTypes.endp = _endpos_parent_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let parent : (
# 88 "parser_cocci_menhir.mly"
      (string)
# 11762 "parser_cocci_menhir.ml"
        ) = Obj.magic parent in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos_parent_ in
        let _v : 'tv_extends = 
# 266 "parser_cocci_menhir.mly"
    ( !Data.install_bindings (parent) )
# 11769 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _2;
          MenhirLib.EngineTypes.startp = _startpos__2_;
          MenhirLib.EngineTypes.endp = _endpos__2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let _2 : (
# 129 "parser_cocci_menhir.mly"
       (string * Data.clt)
# 11795 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : (
# 129 "parser_cocci_menhir.mly"
       (string * Data.clt)
# 11800 "parser_cocci_menhir.ml"
        ) = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__2_ in
        let _v : 'tv_filespec = 
# 864 "parser_cocci_menhir.mly"
    ( [Ast0.wrap
	  (Ast0.FILEINFO(P.id2mcode _1,
			 P.id2mcode _2))] )
# 11809 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_disj_ident = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_fn_ident = 
# 2014 "parser_cocci_menhir.mly"
                     ( _1 )
# 11833 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : (
# 105 "parser_cocci_menhir.mly"
       (Parse_aux.idinfo)
# 11854 "parser_cocci_menhir.ml"
        ) = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_fn_ident = 
# 2016 "parser_cocci_menhir.mly"
         ( let (nm,constraints,pure,clt) = _1 in
	 Ast0.wrap(Ast0.MetaFunc(P.clt2mcode nm clt,constraints,pure)) )
# 11862 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : (
# 105 "parser_cocci_menhir.mly"
       (Parse_aux.idinfo)
# 11883 "parser_cocci_menhir.ml"
        ) = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_fn_ident = 
# 2019 "parser_cocci_menhir.mly"
  ( let (nm,constraints,pure,clt) = _1 in
	 Ast0.wrap
	   (Ast0.MetaLocalFunc(P.clt2mcode nm clt,constraints,pure)) )
# 11892 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let _menhir_s = _menhir_env.MenhirLib.EngineTypes.current in
        let _startpos = _menhir_env.MenhirLib.EngineTypes.lexbuf.Lexing.lex_start_p in
        let _endpos = _startpos in
        let _v : 'tv_fninfo = 
# 1017 "parser_cocci_menhir.mly"
                ( [] )
# 11909 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _2;
          MenhirLib.EngineTypes.startp = _startpos__2_;
          MenhirLib.EngineTypes.endp = _endpos__2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let _2 : 'tv_fninfo = Obj.magic _2 in
        let _1 : 'tv_storage = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__2_ in
        let _v : 'tv_fninfo = 
# 1019 "parser_cocci_menhir.mly"
      ( try
	let _ =
	  List.find (function Ast0.FStorage(_) -> true | _ -> false) _2 in
	raise (Semantic_cocci.Semantic "duplicate storage")
      with Not_found -> (Ast0.FStorage(_1))::_2 )
# 11943 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = r;
          MenhirLib.EngineTypes.startp = _startpos_r_;
          MenhirLib.EngineTypes.endp = _endpos_r_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = t;
            MenhirLib.EngineTypes.startp = _startpos_t_;
            MenhirLib.EngineTypes.endp = _endpos_t_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let r : 'tv_fninfo_nt = Obj.magic r in
        let t : 'tv_ctype = Obj.magic t in
        let _startpos = _startpos_t_ in
        let _endpos = _endpos_r_ in
        let _v : 'tv_fninfo = 
# 1024 "parser_cocci_menhir.mly"
                        ( (Ast0.FType(t))::r )
# 11973 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _2;
          MenhirLib.EngineTypes.startp = _startpos__2_;
          MenhirLib.EngineTypes.endp = _endpos__2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let _2 : 'tv_fninfo = Obj.magic _2 in
        let _1 : (
# 95 "parser_cocci_menhir.mly"
      (Data.clt)
# 12000 "parser_cocci_menhir.ml"
        ) = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__2_ in
        let _v : 'tv_fninfo = 
# 1026 "parser_cocci_menhir.mly"
      ( try
	let _ = List.find (function Ast0.FInline(_) -> true | _ -> false) _2 in
	raise (Semantic_cocci.Semantic "duplicate inline")
      with Not_found -> (Ast0.FInline(P.clt2mcode "inline" _1))::_2 )
# 12010 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _2;
          MenhirLib.EngineTypes.startp = _startpos__2_;
          MenhirLib.EngineTypes.endp = _endpos__2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let _2 : 'tv_fninfo = Obj.magic _2 in
        let _1 : (
# 97 "parser_cocci_menhir.mly"
      (string * Data.clt)
# 12037 "parser_cocci_menhir.ml"
        ) = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__2_ in
        let _v : 'tv_fninfo = 
# 1031 "parser_cocci_menhir.mly"
      ( try
	let _ = List.find (function Ast0.FAttr(_) -> true | _ -> false) _2 in
	raise (Semantic_cocci.Semantic "multiple attributes")
      with Not_found -> (Ast0.FAttr(P.id2mcode _1))::_2 )
# 12047 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let _menhir_s = _menhir_env.MenhirLib.EngineTypes.current in
        let _startpos = _menhir_env.MenhirLib.EngineTypes.lexbuf.Lexing.lex_start_p in
        let _endpos = _startpos in
        let _v : 'tv_fninfo_nt = 
# 1037 "parser_cocci_menhir.mly"
                ( [] )
# 12064 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _2;
          MenhirLib.EngineTypes.startp = _startpos__2_;
          MenhirLib.EngineTypes.endp = _endpos__2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let _2 : 'tv_fninfo_nt = Obj.magic _2 in
        let _1 : 'tv_storage = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__2_ in
        let _v : 'tv_fninfo_nt = 
# 1039 "parser_cocci_menhir.mly"
      ( try
	let _ =
	  List.find (function Ast0.FStorage(_) -> true | _ -> false) _2 in
	raise (Semantic_cocci.Semantic "duplicate storage")
      with Not_found -> (Ast0.FStorage(_1))::_2 )
# 12098 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _2;
          MenhirLib.EngineTypes.startp = _startpos__2_;
          MenhirLib.EngineTypes.endp = _endpos__2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let _2 : 'tv_fninfo_nt = Obj.magic _2 in
        let _1 : (
# 95 "parser_cocci_menhir.mly"
      (Data.clt)
# 12125 "parser_cocci_menhir.ml"
        ) = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__2_ in
        let _v : 'tv_fninfo_nt = 
# 1045 "parser_cocci_menhir.mly"
      ( try
	let _ = List.find (function Ast0.FInline(_) -> true | _ -> false) _2 in
	raise (Semantic_cocci.Semantic "duplicate inline")
      with Not_found -> (Ast0.FInline(P.clt2mcode "inline" _1))::_2 )
# 12135 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _2;
          MenhirLib.EngineTypes.startp = _startpos__2_;
          MenhirLib.EngineTypes.endp = _endpos__2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let _2 : 'tv_fninfo_nt = Obj.magic _2 in
        let _1 : (
# 97 "parser_cocci_menhir.mly"
      (string * Data.clt)
# 12162 "parser_cocci_menhir.ml"
        ) = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__2_ in
        let _v : 'tv_fninfo_nt = 
# 1050 "parser_cocci_menhir.mly"
      ( try
	let _ = List.find (function Ast0.FAttr(_) -> true | _ -> false) _2 in
	raise (Semantic_cocci.Semantic "duplicate init")
      with Not_found -> (Ast0.FAttr(P.id2mcode _1))::_2 )
# 12172 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let _menhir_s = _menhir_env.MenhirLib.EngineTypes.current in
        let _startpos = _menhir_env.MenhirLib.EngineTypes.lexbuf.Lexing.lex_start_p in
        let _endpos = _startpos in
        let _v : 'tv_fun_after_dots = 
# 2274 "parser_cocci_menhir.mly"
                               ([])
# 12189 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _2;
          MenhirLib.EngineTypes.startp = _startpos__2_;
          MenhirLib.EngineTypes.endp = _endpos__2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let _2 : 'tv_fun_after_exp = Obj.magic _2 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__2_ in
        let _v : 'tv_fun_after_dots = 
# 2275 "parser_cocci_menhir.mly"
                               (_2)
# 12217 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _2;
          MenhirLib.EngineTypes.startp = _startpos__2_;
          MenhirLib.EngineTypes.endp = _endpos__2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let _2 : 'tv_fun_after_exp = Obj.magic _2 in
        let _1 : 'tv_expr = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__2_ in
        let _v : 'tv_fun_after_dots = 
# 2276 "parser_cocci_menhir.mly"
                               (Ast0.wrap(Ast0.Exp(_1))::_2)
# 12247 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _2;
          MenhirLib.EngineTypes.startp = _startpos__2_;
          MenhirLib.EngineTypes.endp = _endpos__2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let _2 : 'tv_fun_after_stm = Obj.magic _2 in
        let _1 : 'tv_decl_statement_expr = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__2_ in
        let _v : 'tv_fun_after_dots = 
# 2277 "parser_cocci_menhir.mly"
                                    (_1@_2)
# 12277 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let _menhir_s = _menhir_env.MenhirLib.EngineTypes.current in
        let _startpos = _menhir_env.MenhirLib.EngineTypes.lexbuf.Lexing.lex_start_p in
        let _endpos = _startpos in
        let _v : 'tv_fun_after_dots_or = 
# 2284 "parser_cocci_menhir.mly"
                               ([])
# 12294 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _2;
          MenhirLib.EngineTypes.startp = _startpos__2_;
          MenhirLib.EngineTypes.endp = _endpos__2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let _2 : 'tv_fun_after_exp_or = Obj.magic _2 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__2_ in
        let _v : 'tv_fun_after_dots_or = 
# 2285 "parser_cocci_menhir.mly"
                               (_2)
# 12322 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _2;
          MenhirLib.EngineTypes.startp = _startpos__2_;
          MenhirLib.EngineTypes.endp = _endpos__2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let _2 : 'tv_fun_after_exp_or = Obj.magic _2 in
        let _1 : 'tv_expr = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__2_ in
        let _v : 'tv_fun_after_dots_or = 
# 2286 "parser_cocci_menhir.mly"
                               (Ast0.wrap(Ast0.Exp(_1))::_2)
# 12352 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _2;
          MenhirLib.EngineTypes.startp = _startpos__2_;
          MenhirLib.EngineTypes.endp = _endpos__2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let _2 : 'tv_fun_after_stm = Obj.magic _2 in
        let _1 : 'tv_decl_statement_expr = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__2_ in
        let _v : 'tv_fun_after_dots_or = 
# 2287 "parser_cocci_menhir.mly"
                                    (_1@_2)
# 12382 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _2;
          MenhirLib.EngineTypes.startp = _startpos__2_;
          MenhirLib.EngineTypes.endp = _endpos__2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let _2 : 'tv_fun_after_dots = Obj.magic _2 in
        let _1 : 'tv_stm_dots = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__2_ in
        let _v : 'tv_fun_after_exp = 
# 2280 "parser_cocci_menhir.mly"
                               (_1::_2)
# 12412 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let _menhir_s = _menhir_env.MenhirLib.EngineTypes.current in
        let _startpos = _menhir_env.MenhirLib.EngineTypes.lexbuf.Lexing.lex_start_p in
        let _endpos = _startpos in
        let _v : 'tv_fun_after_exp_or = 
# 2290 "parser_cocci_menhir.mly"
                               ([])
# 12429 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _2;
          MenhirLib.EngineTypes.startp = _startpos__2_;
          MenhirLib.EngineTypes.endp = _endpos__2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let _2 : 'tv_fun_after_dots = Obj.magic _2 in
        let _1 : 'tv_stm_dots = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__2_ in
        let _v : 'tv_fun_after_exp_or = 
# 2291 "parser_cocci_menhir.mly"
                               (_1::_2)
# 12459 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let _menhir_s = _menhir_env.MenhirLib.EngineTypes.current in
        let _startpos = _menhir_env.MenhirLib.EngineTypes.lexbuf.Lexing.lex_start_p in
        let _endpos = _startpos in
        let _v : 'tv_fun_after_stm = 
# 2269 "parser_cocci_menhir.mly"
                               ([])
# 12476 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _2;
          MenhirLib.EngineTypes.startp = _startpos__2_;
          MenhirLib.EngineTypes.endp = _endpos__2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let _2 : 'tv_fun_after_dots = Obj.magic _2 in
        let _1 : 'tv_stm_dots = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__2_ in
        let _v : 'tv_fun_after_stm = 
# 2270 "parser_cocci_menhir.mly"
                               (_1::_2)
# 12506 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _2;
          MenhirLib.EngineTypes.startp = _startpos__2_;
          MenhirLib.EngineTypes.endp = _endpos__2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let _2 : 'tv_fun_after_stm = Obj.magic _2 in
        let _1 : 'tv_decl_statement = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__2_ in
        let _v : 'tv_fun_after_stm = 
# 2271 "parser_cocci_menhir.mly"
                               (_1@_2)
# 12536 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_fun_after_stm = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_fun_start = 
# 2266 "parser_cocci_menhir.mly"
                 ( Ast0.wrap(Ast0.DOTS(_1)) )
# 12560 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_ident = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_func_ident = 
# 2005 "parser_cocci_menhir.mly"
             ( _1 )
# 12584 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : (
# 105 "parser_cocci_menhir.mly"
       (Parse_aux.idinfo)
# 12605 "parser_cocci_menhir.ml"
        ) = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_func_ident = 
# 2007 "parser_cocci_menhir.mly"
         ( let (nm,constraints,pure,clt) = _1 in
	 Ast0.wrap(Ast0.MetaFunc(P.clt2mcode nm clt,constraints,pure)) )
# 12613 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : (
# 105 "parser_cocci_menhir.mly"
       (Parse_aux.idinfo)
# 12634 "parser_cocci_menhir.ml"
        ) = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_func_ident = 
# 2010 "parser_cocci_menhir.mly"
  ( let (nm,constraints,pure,clt) = _1 in
	 Ast0.wrap
	   (Ast0.MetaLocalFunc(P.clt2mcode nm clt,constraints,pure)) )
# 12643 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = rb;
          MenhirLib.EngineTypes.startp = _startpos_rb_;
          MenhirLib.EngineTypes.endp = _endpos_rb_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = b;
            MenhirLib.EngineTypes.startp = _startpos_b_;
            MenhirLib.EngineTypes.endp = _endpos_b_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.semv = lb;
              MenhirLib.EngineTypes.startp = _startpos_lb_;
              MenhirLib.EngineTypes.endp = _endpos_lb_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.semv = rp;
                MenhirLib.EngineTypes.startp = _startpos_rp_;
                MenhirLib.EngineTypes.endp = _endpos_rp_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.semv = d;
                  MenhirLib.EngineTypes.startp = _startpos_d_;
                  MenhirLib.EngineTypes.endp = _endpos_d_;
                  MenhirLib.EngineTypes.next = {
                    MenhirLib.EngineTypes.semv = lp;
                    MenhirLib.EngineTypes.startp = _startpos_lp_;
                    MenhirLib.EngineTypes.endp = _endpos_lp_;
                    MenhirLib.EngineTypes.next = {
                      MenhirLib.EngineTypes.semv = i;
                      MenhirLib.EngineTypes.startp = _startpos_i_;
                      MenhirLib.EngineTypes.endp = _endpos_i_;
                      MenhirLib.EngineTypes.next = {
                        MenhirLib.EngineTypes.startp = _startpos__2_;
                        MenhirLib.EngineTypes.endp = _endpos__2_;
                        MenhirLib.EngineTypes.next = {
                          MenhirLib.EngineTypes.state = _menhir_s;
                          MenhirLib.EngineTypes.semv = f;
                          MenhirLib.EngineTypes.startp = _startpos_f_;
                          MenhirLib.EngineTypes.endp = _endpos_f_;
                          MenhirLib.EngineTypes.next = _menhir_stack;
                          };
                        };
                      };
                    };
                  };
                };
              };
            };
          } = _menhir_stack in
        let rb : (
# 147 "parser_cocci_menhir.mly"
       (Data.clt)
# 12703 "parser_cocci_menhir.ml"
        ) = Obj.magic rb in
        let b : 'tv_fun_start = Obj.magic b in
        let lb : (
# 147 "parser_cocci_menhir.mly"
       (Data.clt)
# 12709 "parser_cocci_menhir.ml"
        ) = Obj.magic lb in
        let rp : (
# 123 "parser_cocci_menhir.mly"
       (Data.clt)
# 12714 "parser_cocci_menhir.ml"
        ) = Obj.magic rp in
        let d : 'tv_decl_list_decl_ = Obj.magic d in
        let lp : (
# 122 "parser_cocci_menhir.mly"
       (Data.clt)
# 12720 "parser_cocci_menhir.ml"
        ) = Obj.magic lp in
        let i : 'tv_fn_ident = Obj.magic i in
        let f : 'tv_fninfo = Obj.magic f in
        let _startpos = _startpos_f_ in
        let _endpos = _endpos_rb_ in
        let _v : 'tv_fundecl = 
# 1008 "parser_cocci_menhir.mly"
      ( P.verify_parameter_declarations (Ast0.undots d);
	Ast0.wrap(Ast0.FunDecl((Ast0.default_info(),Ast0.context_befaft()),
			       f, i,
			       P.clt2mcode "(" lp, d,
			       P.clt2mcode ")" rp,
			       P.clt2mcode "{" lb, b,
			       P.clt2mcode "}" rb)) )
# 12735 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = pt;
          MenhirLib.EngineTypes.startp = _startpos_pt_;
          MenhirLib.EngineTypes.endp = _endpos_pt_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = rp;
            MenhirLib.EngineTypes.startp = _startpos_rp_;
            MenhirLib.EngineTypes.endp = _endpos_rp_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.semv = d;
              MenhirLib.EngineTypes.startp = _startpos_d_;
              MenhirLib.EngineTypes.endp = _endpos_d_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.semv = lp;
                MenhirLib.EngineTypes.startp = _startpos_lp_;
                MenhirLib.EngineTypes.endp = _endpos_lp_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.semv = id;
                  MenhirLib.EngineTypes.startp = _startpos_id_;
                  MenhirLib.EngineTypes.endp = _endpos_id_;
                  MenhirLib.EngineTypes.next = {
                    MenhirLib.EngineTypes.state = _menhir_s;
                    MenhirLib.EngineTypes.semv = t;
                    MenhirLib.EngineTypes.startp = _startpos_t_;
                    MenhirLib.EngineTypes.endp = _endpos_t_;
                    MenhirLib.EngineTypes.next = _menhir_stack;
                    };
                  };
                };
              };
            };
          } = _menhir_stack in
        let pt : (
# 153 "parser_cocci_menhir.mly"
       (Data.clt)
# 12781 "parser_cocci_menhir.ml"
        ) = Obj.magic pt in
        let rp : (
# 123 "parser_cocci_menhir.mly"
       (Data.clt)
# 12786 "parser_cocci_menhir.ml"
        ) = Obj.magic rp in
        let d : 'tv_decl_list_name_opt_decl_ = Obj.magic d in
        let lp : (
# 122 "parser_cocci_menhir.mly"
       (Data.clt)
# 12792 "parser_cocci_menhir.ml"
        ) = Obj.magic lp in
        let id : 'tv_fn_ident = Obj.magic id in
        let t : 'tv_ctype = Obj.magic t in
        let _startpos = _startpos_t_ in
        let _endpos = _endpos_pt_ in
        let _v : 'tv_funproto = let s =
          
# 39 "standard.mly"
    ( None )
# 12802 "parser_cocci_menhir.ml"
          
        in
        
# 996 "parser_cocci_menhir.mly"
      ( Ast0.wrap
	  (Ast0.UnInit
	     (s,
	      Ast0.wrap
		(Ast0.FunctionType(Some t,
				   P.clt2mcode "(" lp, d, P.clt2mcode ")" rp)),
	      id, P.clt2mcode ";" pt)) )
# 12814 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = pt;
          MenhirLib.EngineTypes.startp = _startpos_pt_;
          MenhirLib.EngineTypes.endp = _endpos_pt_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = rp;
            MenhirLib.EngineTypes.startp = _startpos_rp_;
            MenhirLib.EngineTypes.endp = _endpos_rp_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.semv = d;
              MenhirLib.EngineTypes.startp = _startpos_d_;
              MenhirLib.EngineTypes.endp = _endpos_d_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.semv = lp;
                MenhirLib.EngineTypes.startp = _startpos_lp_;
                MenhirLib.EngineTypes.endp = _endpos_lp_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.semv = id;
                  MenhirLib.EngineTypes.startp = _startpos_id_;
                  MenhirLib.EngineTypes.endp = _endpos_id_;
                  MenhirLib.EngineTypes.next = {
                    MenhirLib.EngineTypes.semv = t;
                    MenhirLib.EngineTypes.startp = _startpos_t_;
                    MenhirLib.EngineTypes.endp = _endpos_t_;
                    MenhirLib.EngineTypes.next = {
                      MenhirLib.EngineTypes.state = _menhir_s;
                      MenhirLib.EngineTypes.semv = x0;
                      MenhirLib.EngineTypes.startp = _startpos_x0_;
                      MenhirLib.EngineTypes.endp = _endpos_x0_;
                      MenhirLib.EngineTypes.next = _menhir_stack;
                      };
                    };
                  };
                };
              };
            };
          } = _menhir_stack in
        let pt : (
# 153 "parser_cocci_menhir.mly"
       (Data.clt)
# 12865 "parser_cocci_menhir.ml"
        ) = Obj.magic pt in
        let rp : (
# 123 "parser_cocci_menhir.mly"
       (Data.clt)
# 12870 "parser_cocci_menhir.ml"
        ) = Obj.magic rp in
        let d : 'tv_decl_list_name_opt_decl_ = Obj.magic d in
        let lp : (
# 122 "parser_cocci_menhir.mly"
       (Data.clt)
# 12876 "parser_cocci_menhir.ml"
        ) = Obj.magic lp in
        let id : 'tv_fn_ident = Obj.magic id in
        let t : 'tv_ctype = Obj.magic t in
        let x0 : 'tv_storage = Obj.magic x0 in
        let _startpos = _startpos_x0_ in
        let _endpos = _endpos_pt_ in
        let _v : 'tv_funproto = let s =
          let x = x0 in
          
# 41 "standard.mly"
    ( Some x )
# 12888 "parser_cocci_menhir.ml"
          
        in
        
# 996 "parser_cocci_menhir.mly"
      ( Ast0.wrap
	  (Ast0.UnInit
	     (s,
	      Ast0.wrap
		(Ast0.FunctionType(Some t,
				   P.clt2mcode "(" lp, d, P.clt2mcode ")" rp)),
	      id, P.clt2mcode ";" pt)) )
# 12900 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_pure_ident = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_ident = 
# 2024 "parser_cocci_menhir.mly"
         ( Ast0.wrap(Ast0.Id(P.id2mcode _1)) )
# 12924 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_wrapped_sym_ident = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_ident = 
# 2025 "parser_cocci_menhir.mly"
                         ( _1 )
# 12948 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : (
# 104 "parser_cocci_menhir.mly"
       (Parse_aux.midinfo)
# 12969 "parser_cocci_menhir.ml"
        ) = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_ident = 
# 2027 "parser_cocci_menhir.mly"
         ( let (nm,constraints,seed,pure,clt) = _1 in
         Ast0.wrap(Ast0.MetaId(P.clt2mcode nm clt,constraints,seed,pure)) )
# 12977 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = i;
          MenhirLib.EngineTypes.startp = _startpos_i_;
          MenhirLib.EngineTypes.endp = _endpos_i_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let i : 'tv_pure_ident = Obj.magic i in
        let _startpos = _startpos_i_ in
        let _endpos = _endpos_i_ in
        let _v : 'tv_ident_or_const = 
# 1977 "parser_cocci_menhir.mly"
                    ( Ast0.wrap(Ast0.Ident(Ast0.wrap(Ast0.Id(P.id2mcode i)))) )
# 13001 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_wrapped_sym_ident = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_ident_or_const = 
# 1978 "parser_cocci_menhir.mly"
                         ( Ast0.wrap(Ast0.Ident(_1)) )
# 13025 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : (
# 133 "parser_cocci_menhir.mly"
       (string * Data.clt)
# 13046 "parser_cocci_menhir.ml"
        ) = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_ident_or_const = 
# 1980 "parser_cocci_menhir.mly"
  ( let (x,clt) = _1 in
	 Ast0.wrap(Ast0.Constant (P.clt2mcode (Ast.Int x) clt)) )
# 13054 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : (
# 126 "parser_cocci_menhir.mly"
       (string * Data.clt)
# 13075 "parser_cocci_menhir.ml"
        ) = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_incl = 
# 303 "parser_cocci_menhir.mly"
                      ( let (x,_) = _1 in Data.Include(x) )
# 13082 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _2;
          MenhirLib.EngineTypes.startp = _startpos__2_;
          MenhirLib.EngineTypes.endp = _endpos__2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let _2 : (
# 133 "parser_cocci_menhir.mly"
       (string * Data.clt)
# 13107 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__2_ in
        let _v : 'tv_incl = 
# 304 "parser_cocci_menhir.mly"
                      ( Data.Iso(Common.Left(P.id2name _2)) )
# 13114 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _2;
          MenhirLib.EngineTypes.startp = _startpos__2_;
          MenhirLib.EngineTypes.endp = _endpos__2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let _2 : (
# 125 "parser_cocci_menhir.mly"
       (string)
# 13139 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__2_ in
        let _v : 'tv_incl = 
# 305 "parser_cocci_menhir.mly"
                      ( Data.Iso(Common.Right _2) )
# 13146 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _2;
          MenhirLib.EngineTypes.startp = _startpos__2_;
          MenhirLib.EngineTypes.endp = _endpos__2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let _2 : 'tv_comma_list_pure_ident_ = Obj.magic _2 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__2_ in
        let _v : 'tv_incl = 
# 307 "parser_cocci_menhir.mly"
    ( let names = List.map P.id2name _2 in
      Iteration.parsed_virtual_rules :=
	Common.union_set names !Iteration.parsed_virtual_rules;
      (* ensure that the names of virtual and real rules don't overlap *)
      List.iter
      (function name -> Hashtbl.add Data.all_metadecls name [])
      names;
      Data.Virt(names) )
# 13181 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.startp = _startpos__2_;
          MenhirLib.EngineTypes.endp = _endpos__2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let _1 : 'tv_list_incl_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__2_ in
        let _v : (
# 194 "parser_cocci_menhir.mly"
      (Data.incl_iso list)
# 13209 "parser_cocci_menhir.ml"
        ) = 
# 299 "parser_cocci_menhir.mly"
                       ( _1 )
# 13213 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.startp = _startpos__2_;
          MenhirLib.EngineTypes.endp = _endpos__2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let _1 : 'tv_list_incl_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__2_ in
        let _v : (
# 194 "parser_cocci_menhir.mly"
      (Data.incl_iso list)
# 13241 "parser_cocci_menhir.ml"
        ) = 
# 300 "parser_cocci_menhir.mly"
                       ( _1 )
# 13245 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : (
# 126 "parser_cocci_menhir.mly"
       (string * Data.clt)
# 13266 "parser_cocci_menhir.ml"
        ) = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_includes = 
# 870 "parser_cocci_menhir.mly"
    ( Ast0.wrap
	      (Ast0.Include(P.clt2mcode "#include"
			      (P.drop_pos (P.drop_aft (P.id2clt _1))),
			    let (arity,ln,lln,offset,col,strbef,straft,pos) =
			      P.id2clt _1 in
			    let clt =
			      (arity,ln,lln,offset,0,strbef,straft,pos) in
			    P.clt2mcode
			      (Ast.Local (Parse_aux.str2inc (P.id2name _1)))
			      (P.drop_bef clt))) )
# 13282 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : (
# 126 "parser_cocci_menhir.mly"
       (string * Data.clt)
# 13303 "parser_cocci_menhir.ml"
        ) = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_includes = 
# 881 "parser_cocci_menhir.mly"
    ( Ast0.wrap
	      (Ast0.Include(P.clt2mcode "#include"
			      (P.drop_pos (P.drop_aft (P.id2clt _1))),
			    let (arity,ln,lln,offset,col,strbef,straft,pos) =
			      P.id2clt _1 in
			    let clt =
			      (arity,ln,lln,offset,0,strbef,straft,pos) in
			    P.clt2mcode
			      (Ast.NonLocal (Parse_aux.str2inc (P.id2name _1)))
			      (P.drop_bef clt))) )
# 13319 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.startp = _startpos__2_;
          MenhirLib.EngineTypes.endp = _endpos__2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let _1 : (
# 127 "parser_cocci_menhir.mly"
       (Data.clt * token)
# 13344 "parser_cocci_menhir.ml"
        ) = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__2_ in
        let _v : 'tv_includes = 
# 892 "parser_cocci_menhir.mly"
    ( let (clt,ident) = _1 in
      let aft = P.get_aft clt in (* move stuff after the define to the ident *)
      Ast0.wrap
      (Ast0.Undef
	 (P.clt2mcode "#undef" (P.drop_aft clt),
	  (match ident with
	    TMetaId((nm,constraints,seed,pure,clt)) ->
	      let clt = P.set_aft aft clt in
	      Ast0.wrap(Ast0.MetaId(P.clt2mcode nm clt,constraints,seed,pure))
	  | TIdent((nm,clt)) ->
	      let clt = P.set_aft aft clt in
	      Ast0.wrap(Ast0.Id(P.clt2mcode nm clt))
	  | TSymId(nm,clt) ->
	      let clt = P.set_aft aft clt in
	      Ast0.wrap(Ast0.Id(P.clt2mcode nm clt))
	  | _ ->
	      raise
		(Semantic_cocci.Semantic
		   "unexpected name for a #define")))) )
# 13369 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.startp = _startpos__2_;
          MenhirLib.EngineTypes.endp = _endpos__2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = d;
            MenhirLib.EngineTypes.startp = _startpos_d_;
            MenhirLib.EngineTypes.endp = _endpos_d_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let d : 'tv_defineop = Obj.magic d in
        let _startpos = _startpos_d_ in
        let _endpos = _endpos__2_ in
        let _v : 'tv_includes = 
# 912 "parser_cocci_menhir.mly"
    ( d (Ast0.wrap(Ast0.DOTS([]))) )
# 13397 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = t;
            MenhirLib.EngineTypes.startp = _startpos_t_;
            MenhirLib.EngineTypes.endp = _endpos_t_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = d;
              MenhirLib.EngineTypes.startp = _startpos_d_;
              MenhirLib.EngineTypes.endp = _endpos_d_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let t : 'tv_ctype = Obj.magic t in
        let d : 'tv_defineop = Obj.magic d in
        let _startpos = _startpos_d_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_includes = 
# 914 "parser_cocci_menhir.mly"
    ( let ty = Ast0.wrap(Ast0.TopExp(Ast0.wrap(Ast0.TypeExp(t)))) in
      d (Ast0.wrap(Ast0.DOTS([ty]))) )
# 13432 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = b;
            MenhirLib.EngineTypes.startp = _startpos_b_;
            MenhirLib.EngineTypes.endp = _endpos_b_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let b : 'tv_toplevel_seq_start_toplevel_after_dots_ = Obj.magic b in
        let _1 : 'tv_defineop = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_includes = 
# 917 "parser_cocci_menhir.mly"
    ( let body =
	match b with
	  [e] ->
	    (match Ast0.unwrap e with
	      Ast0.Exp(e1) ->
		[Ast0.rewrap e (Ast0.TopExp(Ast0.set_arg_exp (e1)))]
	    | _ -> b)
	| _ -> b in
      _1 (Ast0.wrap(Ast0.DOTS(body))) )
# 13474 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_eexpr = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_initialize = 
# 1340 "parser_cocci_menhir.mly"
      ( Ast0.wrap(Ast0.InitExpr(_1)) )
# 13498 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : (
# 147 "parser_cocci_menhir.mly"
       (Data.clt)
# 13529 "parser_cocci_menhir.ml"
        ) = Obj.magic _3 in
        let _2 : 'tv_initialize_list = Obj.magic _2 in
        let _1 : (
# 147 "parser_cocci_menhir.mly"
       (Data.clt)
# 13535 "parser_cocci_menhir.ml"
        ) = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_initialize = 
# 1342 "parser_cocci_menhir.mly"
    ( if P.struct_initializer _2
    then
      let il = P.drop_dot_commas _2 in
      Ast0.wrap(Ast0.InitList(P.clt2mcode "{" _1,il,P.clt2mcode "}" _3,false))
    else
      Ast0.wrap(Ast0.InitList(P.clt2mcode "{" _1,_2,P.clt2mcode "}" _3,true)) )
# 13547 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : (
# 109 "parser_cocci_menhir.mly"
       (Parse_aux.info)
# 13568 "parser_cocci_menhir.ml"
        ) = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_initialize = 
# 1349 "parser_cocci_menhir.mly"
      (let (nm,pure,clt) = _1 in
      Ast0.wrap(Ast0.MetaInit(P.clt2mcode nm clt,pure)) )
# 13576 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_arith_expr_eexpr_invalid_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_initialize2 = 
# 1355 "parser_cocci_menhir.mly"
                            ( Ast0.wrap(Ast0.InitExpr(_1)) )
# 13600 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_nest_expressions_only = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_initialize2 = 
# 1356 "parser_cocci_menhir.mly"
                            ( Ast0.wrap(Ast0.InitExpr(_1)) )
# 13624 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : (
# 147 "parser_cocci_menhir.mly"
       (Data.clt)
# 13655 "parser_cocci_menhir.ml"
        ) = Obj.magic _3 in
        let _2 : 'tv_initialize_list = Obj.magic _2 in
        let _1 : (
# 147 "parser_cocci_menhir.mly"
       (Data.clt)
# 13661 "parser_cocci_menhir.ml"
        ) = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_initialize2 = 
# 1358 "parser_cocci_menhir.mly"
    ( if P.struct_initializer _2
    then
      let il = P.drop_dot_commas _2 in
      Ast0.wrap(Ast0.InitList(P.clt2mcode "{" _1,il,P.clt2mcode "}" _3,false))
    else
      Ast0.wrap(Ast0.InitList(P.clt2mcode "{" _1,_2,P.clt2mcode "}" _3,true)) )
# 13673 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_initialize2 = Obj.magic _3 in
        let _2 : (
# 153 "parser_cocci_menhir.mly"
       (Data.clt)
# 13705 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_list_designator_ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_initialize2 = 
# 1366 "parser_cocci_menhir.mly"
    ( Ast0.wrap(Ast0.InitGccExt(_1,P.clt2mcode "=" _2,_3)) )
# 13713 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          } = _menhir_stack in
        let _3 : 'tv_initialize2 = Obj.magic _3 in
        let _2 : (
# 122 "parser_cocci_menhir.mly"
       (Data.clt)
# 13745 "parser_cocci_menhir.ml"
        ) = Obj.magic _2 in
        let _1 : 'tv_mident = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : 'tv_initialize2 = 
# 1368 "parser_cocci_menhir.mly"
    ( Ast0.wrap(Ast0.InitGccName(_1,P.clt2mcode ":" _2,_3)) )
# 13753 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : (
# 109 "parser_cocci_menhir.mly"
       (Parse_aux.info)
# 13774 "parser_cocci_menhir.ml"
        ) = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_initialize2 = 
# 1370 "parser_cocci_menhir.mly"
      (let (nm,pure,clt) = _1 in
      Ast0.wrap(Ast0.MetaInit(P.clt2mcode nm clt,pure)) )
# 13782 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : (
# 110 "parser_cocci_menhir.mly"
       (Parse_aux.list_info)
# 13803 "parser_cocci_menhir.ml"
        ) = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_initialize2 = 
# 1373 "parser_cocci_menhir.mly"
      (let (nm,lenname,pure,clt) = _1 in
      let nm = P.clt2mcode nm clt in
      let lenname =
	match lenname with
	  Ast.AnyLen -> Ast0.AnyListLen
	| Ast.MetaLen nm -> Ast0.MetaListLen(P.clt2mcode nm clt)
	| Ast.CstLen n -> Ast0.CstListLen n in
      Ast0.wrap(Ast0.MetaInitList(nm,lenname,pure)) )
# 13817 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_empty_list_start_initialize2_edots_when_TEllipsis_initialize__ = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_initialize_list = 
# 1393 "parser_cocci_menhir.mly"
     ( Ast0.wrap(Ast0.DOTS(_1 P.mkidots (fun c -> Ast0.IComma c))) )
# 13841 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_invalid = 
# 1478 "parser_cocci_menhir.mly"
           ( raise (Semantic_cocci.Semantic "not matchable") )
# 13863 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let _menhir_s = _menhir_env.MenhirLib.EngineTypes.current in
        let _startpos = _menhir_env.MenhirLib.EngineTypes.lexbuf.Lexing.lex_start_p in
        let _endpos = _startpos in
        let _v : 'tv_is_expression = 
# 295 "parser_cocci_menhir.mly"
              ( false )
# 13880 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_is_expression = 
# 296 "parser_cocci_menhir.mly"
              ( true )
# 13902 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = t;
          MenhirLib.EngineTypes.startp = _startpos_t_;
          MenhirLib.EngineTypes.endp = _endpos_t_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let t : 'tv_ctype = Obj.magic t in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos_t_ in
        let _v : 'tv_iso_ctype_ = 
# 2417 "parser_cocci_menhir.mly"
                ( Common.Left t )
# 13930 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = t;
          MenhirLib.EngineTypes.startp = _startpos_t_;
          MenhirLib.EngineTypes.endp = _endpos_t_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let t : 'tv_ctype = Obj.magic t in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos_t_ in
        let _v : 'tv_iso_ctype_ = 
# 2418 "parser_cocci_menhir.mly"
                     ( Common.Right t )
# 13958 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = t;
          MenhirLib.EngineTypes.startp = _startpos_t_;
          MenhirLib.EngineTypes.endp = _endpos_t_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let t : 'tv_decl_var = Obj.magic t in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos_t_ in
        let _v : 'tv_iso_decl_var_ = 
# 2417 "parser_cocci_menhir.mly"
                ( Common.Left t )
# 13986 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = t;
          MenhirLib.EngineTypes.startp = _startpos_t_;
          MenhirLib.EngineTypes.endp = _endpos_t_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let t : 'tv_decl_var = Obj.magic t in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos_t_ in
        let _v : 'tv_iso_decl_var_ = 
# 2418 "parser_cocci_menhir.mly"
                     ( Common.Right t )
# 14014 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = t;
          MenhirLib.EngineTypes.startp = _startpos_t_;
          MenhirLib.EngineTypes.endp = _endpos_t_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let t : 'tv_eexpr = Obj.magic t in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos_t_ in
        let _v : 'tv_iso_eexpr_ = 
# 2417 "parser_cocci_menhir.mly"
                ( Common.Left t )
# 14042 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = t;
          MenhirLib.EngineTypes.startp = _startpos_t_;
          MenhirLib.EngineTypes.endp = _endpos_t_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let t : 'tv_eexpr = Obj.magic t in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos_t_ in
        let _v : 'tv_iso_eexpr_ = 
# 2418 "parser_cocci_menhir.mly"
                     ( Common.Right t )
# 14070 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = t;
          MenhirLib.EngineTypes.startp = _startpos_t_;
          MenhirLib.EngineTypes.endp = _endpos_t_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let t : 'tv_iso_statement = Obj.magic t in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos_t_ in
        let _v : 'tv_iso_iso_statement_ = 
# 2417 "parser_cocci_menhir.mly"
                ( Common.Left t )
# 14098 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = t;
          MenhirLib.EngineTypes.startp = _startpos_t_;
          MenhirLib.EngineTypes.endp = _endpos_t_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let t : 'tv_iso_statement = Obj.magic t in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos_t_ in
        let _v : 'tv_iso_iso_statement_ = 
# 2418 "parser_cocci_menhir.mly"
                     ( Common.Right t )
# 14126 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = t;
          MenhirLib.EngineTypes.startp = _startpos_t_;
          MenhirLib.EngineTypes.endp = _endpos_t_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let t : 'tv_nest_start = Obj.magic t in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos_t_ in
        let _v : 'tv_iso_nest_start_ = 
# 2417 "parser_cocci_menhir.mly"
                ( Common.Left t )
# 14154 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = t;
          MenhirLib.EngineTypes.startp = _startpos_t_;
          MenhirLib.EngineTypes.endp = _endpos_t_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let t : 'tv_nest_start = Obj.magic t in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos_t_ in
        let _v : 'tv_iso_nest_start_ = 
# 2418 "parser_cocci_menhir.mly"
                     ( Common.Right t )
# 14182 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.startp = _startpos__4_;
          MenhirLib.EngineTypes.endp = _endpos__4_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = el;
            MenhirLib.EngineTypes.startp = _startpos_el_;
            MenhirLib.EngineTypes.endp = _endpos_el_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.semv = e1;
              MenhirLib.EngineTypes.startp = _startpos_e1_;
              MenhirLib.EngineTypes.endp = _endpos_e1_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.startp = _startpos__1_;
                MenhirLib.EngineTypes.endp = _endpos__1_;
                MenhirLib.EngineTypes.next = _menhir_stack;
                };
              };
            };
          } = _menhir_stack in
        let el : 'tv_list_iso_eexpr__ = Obj.magic el in
        let e1 : 'tv_eexpr = Obj.magic e1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__4_ in
        let _v : (
# 210 "parser_cocci_menhir.mly"
      (Ast0_cocci.anything list list)
# 14220 "parser_cocci_menhir.ml"
        ) = 
# 2385 "parser_cocci_menhir.mly"
    ( let fn x = Ast0.ExprTag x in P.iso_adjust fn fn e1 el )
# 14224 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.startp = _startpos__4_;
          MenhirLib.EngineTypes.endp = _endpos__4_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = el;
            MenhirLib.EngineTypes.startp = _startpos_el_;
            MenhirLib.EngineTypes.endp = _endpos_el_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.semv = e1;
              MenhirLib.EngineTypes.startp = _startpos_e1_;
              MenhirLib.EngineTypes.endp = _endpos_e1_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.startp = _startpos__1_;
                MenhirLib.EngineTypes.endp = _endpos__1_;
                MenhirLib.EngineTypes.next = _menhir_stack;
                };
              };
            };
          } = _menhir_stack in
        let el : 'tv_list_iso_eexpr__ = Obj.magic el in
        let e1 : 'tv_eexpr = Obj.magic e1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__4_ in
        let _v : (
# 210 "parser_cocci_menhir.mly"
      (Ast0_cocci.anything list list)
# 14262 "parser_cocci_menhir.ml"
        ) = 
# 2387 "parser_cocci_menhir.mly"
    ( let fn x = Ast0.ArgExprTag x in P.iso_adjust fn fn e1 el )
# 14266 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.startp = _startpos__4_;
          MenhirLib.EngineTypes.endp = _endpos__4_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = el;
            MenhirLib.EngineTypes.startp = _startpos_el_;
            MenhirLib.EngineTypes.endp = _endpos_el_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.semv = e1;
              MenhirLib.EngineTypes.startp = _startpos_e1_;
              MenhirLib.EngineTypes.endp = _endpos_e1_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.startp = _startpos__1_;
                MenhirLib.EngineTypes.endp = _endpos__1_;
                MenhirLib.EngineTypes.next = _menhir_stack;
                };
              };
            };
          } = _menhir_stack in
        let el : 'tv_list_iso_eexpr__ = Obj.magic el in
        let e1 : 'tv_eexpr = Obj.magic e1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__4_ in
        let _v : (
# 210 "parser_cocci_menhir.mly"
      (Ast0_cocci.anything list list)
# 14304 "parser_cocci_menhir.ml"
        ) = 
# 2389 "parser_cocci_menhir.mly"
    ( let fn x = Ast0.TestExprTag x in P.iso_adjust fn fn e1 el )
# 14308 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.startp = _startpos__4_;
          MenhirLib.EngineTypes.endp = _endpos__4_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = el;
            MenhirLib.EngineTypes.startp = _startpos_el_;
            MenhirLib.EngineTypes.endp = _endpos_el_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.semv = e1;
              MenhirLib.EngineTypes.startp = _startpos_e1_;
              MenhirLib.EngineTypes.endp = _endpos_e1_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.startp = _startpos__1_;
                MenhirLib.EngineTypes.endp = _endpos__1_;
                MenhirLib.EngineTypes.next = _menhir_stack;
                };
              };
            };
          } = _menhir_stack in
        let el : 'tv_list_iso_eexpr__ = Obj.magic el in
        let e1 : 'tv_eexpr = Obj.magic e1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__4_ in
        let _v : (
# 210 "parser_cocci_menhir.mly"
      (Ast0_cocci.anything list list)
# 14346 "parser_cocci_menhir.ml"
        ) = 
# 2391 "parser_cocci_menhir.mly"
    ( let ffn x = Ast0.ExprTag x in
      let fn x =  Ast0.TestExprTag x in
      P.iso_adjust ffn fn e1 el )
# 14352 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.startp = _startpos__4_;
          MenhirLib.EngineTypes.endp = _endpos__4_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = sl;
            MenhirLib.EngineTypes.startp = _startpos_sl_;
            MenhirLib.EngineTypes.endp = _endpos_sl_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.semv = s1;
              MenhirLib.EngineTypes.startp = _startpos_s1_;
              MenhirLib.EngineTypes.endp = _endpos_s1_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.startp = _startpos__1_;
                MenhirLib.EngineTypes.endp = _endpos__1_;
                MenhirLib.EngineTypes.next = _menhir_stack;
                };
              };
            };
          } = _menhir_stack in
        let sl : 'tv_list_iso_iso_statement__ = Obj.magic sl in
        let s1 : 'tv_iso_statement = Obj.magic s1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__4_ in
        let _v : (
# 210 "parser_cocci_menhir.mly"
      (Ast0_cocci.anything list list)
# 14390 "parser_cocci_menhir.ml"
        ) = 
# 2395 "parser_cocci_menhir.mly"
    ( let fn x = Ast0.StmtTag x in P.iso_adjust fn fn s1 sl )
# 14394 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.startp = _startpos__4_;
          MenhirLib.EngineTypes.endp = _endpos__4_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = tl;
            MenhirLib.EngineTypes.startp = _startpos_tl_;
            MenhirLib.EngineTypes.endp = _endpos_tl_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.semv = t1;
              MenhirLib.EngineTypes.startp = _startpos_t1_;
              MenhirLib.EngineTypes.endp = _endpos_t1_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.startp = _startpos__1_;
                MenhirLib.EngineTypes.endp = _endpos__1_;
                MenhirLib.EngineTypes.next = _menhir_stack;
                };
              };
            };
          } = _menhir_stack in
        let tl : 'tv_list_iso_ctype__ = Obj.magic tl in
        let t1 : 'tv_ctype = Obj.magic t1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__4_ in
        let _v : (
# 210 "parser_cocci_menhir.mly"
      (Ast0_cocci.anything list list)
# 14432 "parser_cocci_menhir.ml"
        ) = 
# 2397 "parser_cocci_menhir.mly"
    ( let fn x = Ast0.TypeCTag x in P.iso_adjust fn fn t1 tl )
# 14436 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.startp = _startpos__4_;
          MenhirLib.EngineTypes.endp = _endpos__4_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = el;
            MenhirLib.EngineTypes.startp = _startpos_el_;
            MenhirLib.EngineTypes.endp = _endpos_el_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.semv = e1;
              MenhirLib.EngineTypes.startp = _startpos_e1_;
              MenhirLib.EngineTypes.endp = _endpos_e1_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.startp = _startpos__1_;
                MenhirLib.EngineTypes.endp = _endpos__1_;
                MenhirLib.EngineTypes.next = _menhir_stack;
                };
              };
            };
          } = _menhir_stack in
        let el : 'tv_list_iso_nest_start__ = Obj.magic el in
        let e1 : 'tv_nest_start = Obj.magic e1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__4_ in
        let _v : (
# 210 "parser_cocci_menhir.mly"
      (Ast0_cocci.anything list list)
# 14474 "parser_cocci_menhir.ml"
        ) = 
# 2399 "parser_cocci_menhir.mly"
    ( let fn x = Ast0.DotsStmtTag x in P.iso_adjust fn fn e1 el )
# 14478 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.startp = _startpos__4_;
          MenhirLib.EngineTypes.endp = _endpos__4_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.semv = dl;
            MenhirLib.EngineTypes.startp = _startpos_dl_;
            MenhirLib.EngineTypes.endp = _endpos_dl_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.semv = d1;
              MenhirLib.EngineTypes.startp = _startpos_d1_;
              MenhirLib.EngineTypes.endp = _endpos_d1_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.startp = _startpos__1_;
                MenhirLib.EngineTypes.endp = _endpos__1_;
                MenhirLib.EngineTypes.next = _menhir_stack;
                };
              };
            };
          } = _menhir_stack in
        let dl : 'tv_list_iso_decl_var__ = Obj.magic dl in
        let d1 : 'tv_decl_var = Obj.magic d1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__4_ in
        let _v : (
# 210 "parser_cocci_menhir.mly"
      (Ast0_cocci.anything list list)
# 14516 "parser_cocci_menhir.ml"
        ) = 
# 2401 "parser_cocci_menhir.mly"
    ( let check_one = function
	[x] -> x
      | _ ->
	  raise
	    (Semantic_cocci.Semantic
	       "only one variable per declaration in an isomorphism rule") in
    let d1 = check_one d1 in
    let dl =
      List.map
	(function
	    Common.Left x -> Common.Left(check_one x)
	  | Common.Right x -> Common.Right(check_one x))
	dl in
    let fn x = Ast0.DeclTag x in P.iso_adjust fn fn d1 dl )
# 14533 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = m;
          MenhirLib.EngineTypes.startp = _startpos_m_;
          MenhirLib.EngineTypes.endp = _endpos_m_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let m : 'tv_metadec = Obj.magic m in
        let _startpos = _startpos_m_ in
        let _endpos = _endpos_m_ in
        let _v : (
# 213 "parser_cocci_menhir.mly"
      ((Ast_cocci.metavar,Ast_cocci.metavar) Common.either list)
# 14557 "parser_cocci_menhir.ml"
        ) = 
# 230 "parser_cocci_menhir.mly"
                         ( m "" )
# 14561 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.startp = _startpos__2_;
          MenhirLib.EngineTypes.endp = _endpos__2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = nm;
            MenhirLib.EngineTypes.startp = _startpos_nm_;
            MenhirLib.EngineTypes.endp = _endpos_nm_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let nm : 'tv_pure_ident = Obj.magic nm in
        let _startpos = _startpos_nm_ in
        let _endpos = _endpos__2_ in
        let _v : (
# 197 "parser_cocci_menhir.mly"
      (Ast_cocci.rulename)
# 14589 "parser_cocci_menhir.ml"
        ) = 
# 245 "parser_cocci_menhir.mly"
                      ( P.make_iso_rule_name_result (P.id2name nm) )
# 14593 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_statement = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_iso_statement = 
# 1183 "parser_cocci_menhir.mly"
                                      ( _1 )
# 14617 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : 'tv_decl_var = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_iso_statement = 
# 1185 "parser_cocci_menhir.mly"
      ( match _1 with
	[decl] ->
	  Ast0.wrap
	    (Ast0.Decl((Ast0.default_info(),Ast0.context_befaft()),decl))
      |	_ -> failwith "exactly one decl allowed in statement iso" )
# 14645 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : (
# 101 "parser_cocci_menhir.mly"
       (string * Data.clt)
# 14666 "parser_cocci_menhir.ml"
        ) = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_iter_ident = 
# 2058 "parser_cocci_menhir.mly"
         ( Ast0.wrap(Ast0.Id(P.id2mcode _1)) )
# 14673 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
          } = _menhir_stack in
        let _1 : (
# 106 "parser_cocci_menhir.mly"
       (Parse_aux.idinfo)
# 14694 "parser_cocci_menhir.ml"
        ) = Obj.magic _1 in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : 'tv_iter_ident = 
# 2060 "parser_cocci_menhir.mly"
         ( let (nm,constraints,pure,clt) = _1 in
         Ast0.wrap(Ast0.MetaId(P.clt2mcode nm clt,constraints,Ast.NoVal,pure)) )
# 14702 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let _menhir_s = _menhir_env.MenhirLib.EngineTypes.current in
        let _startpos = _menhir_env.MenhirLib.EngineTypes.lexbuf.Lexing.lex_start_p in
        let _endpos = _startpos in
        let _v : 'tv_list_TMul_ = 
# 114 "standard.mly"
    ( [] )
# 14719 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = xs;
          MenhirLib.EngineTypes.startp = _startpos_xs_;
          MenhirLib.EngineTypes.endp = _endpos_xs_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = x;
            MenhirLib.EngineTypes.startp = _startpos_x_;
            MenhirLib.EngineTypes.endp = _endpos_x_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let xs : 'tv_list_TMul_ = Obj.magic xs in
        let x : (
# 145 "parser_cocci_menhir.mly"
       (Data.clt)
# 14746 "parser_cocci_menhir.ml"
        ) = Obj.magic x in
        let _startpos = _startpos_x_ in
        let _endpos = _endpos_xs_ in
        let _v : 'tv_list_TMul_ = 
# 116 "standard.mly"
    ( x :: xs )
# 14753 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let _menhir_s = _menhir_env.MenhirLib.EngineTypes.current in
        let _startpos = _menhir_env.MenhirLib.EngineTypes.lexbuf.Lexing.lex_start_p in
        let _endpos = _startpos in
        let _v : 'tv_list_array_dec_ = 
# 114 "standard.mly"
    ( [] )
# 14770 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = xs;
          MenhirLib.EngineTypes.startp = _startpos_xs_;
          MenhirLib.EngineTypes.endp = _endpos_xs_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = x;
            MenhirLib.EngineTypes.startp = _startpos_x_;
            MenhirLib.EngineTypes.endp = _endpos_x_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let xs : 'tv_list_array_dec_ = Obj.magic xs in
        let x : 'tv_array_dec = Obj.magic x in
        let _startpos = _startpos_x_ in
        let _endpos = _endpos_xs_ in
        let _v : 'tv_list_array_dec_ = 
# 116 "standard.mly"
    ( x :: xs )
# 14800 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let _menhir_s = _menhir_env.MenhirLib.EngineTypes.current in
        let _startpos = _menhir_env.MenhirLib.EngineTypes.lexbuf.Lexing.lex_start_p in
        let _endpos = _startpos in
        let _v : 'tv_list_case_line_ = 
# 114 "standard.mly"
    ( [] )
# 14817 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
          });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.semv = xs;
          MenhirLib.EngineTypes.startp = _startpos_xs_;
          MenhirLib.EngineTypes.endp = _endpos_xs_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = x;
            MenhirLib.EngineTypes.startp = _startpos_x_;
            MenhirLib.EngineTypes.endp = _endpos_x_;
            MenhirLib.EngineTypes.next = _menhir_stack;
            };
          } = _menhir_stack in
        let xs : 'tv_list_case_line_ = Obj.magic xs in
        let x : 'tv_case_line = Obj.magic x in
        let _startpos = _startpos_x_ in
        let _endpos = _endpos_xs_ in
        let _v : 'tv_list_case_line_ = 
# 116 "standard.mly"
    ( x :: xs )
# 14847 "parser_cocci_menhir.ml"
         in
        _menhir_env.MenhirLib.EngineTypes.stack <- {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          Menh