static char version[] = "cn2jp 1.3 (Mar 1, 1996)";

/*
  Copyright (C) 1996      Seke Wei      (seke@sys.es.osaka-u.ac.jp)

  mktable: condense <.tbl> table to  ".t" table


  This program is free for general distribution.

  This program runs on UNIX. You are welcome to port it to other operating
  systems.
*/

#include <stdio.h>
#include <string.h>


int	debug=0;
FILE	*inp;

int
main(argc,argv)
int	argc;
char	*argv[];
{
	unsigned i,j,m,r,index,row,char_per_row,tbl_size;
	int	k,l;
	unsigned char *p,*tbl,c;
	char	str[256],buffer[256],w[17][256],tbl_name[256],comment[256];
	FILE	*ptable;


	if(argc!=2) {
		puts("------------  Translate .tbl table to .t table -------");
	       	puts("Usage: mktable table.tbl");
		puts("          requires 'table.tbl'");
		puts("          Version 0.4 by Seke Wei on 1996/03/01");
		return -1;
	}

	inp = fopen(argv[1],"rt");

	/* locate to NAME.tbl */
	i=0; tbl_name[0]=0;
	while(tbl_name[0]==0) {
		k=fscanf(inp,"%s",str);
		if((p=strstr(str,".tbl"))!=NULL) {
			*p=0;
			strcpy(tbl_name,str);
		}
		i++;

		if((k==EOF) || (i>10)) {
			fprintf(stderr,"\nmktable: No NAME.tbl found...");
			return -1;
		}
	}
	fprintf(stderr,"\nmktable: %s.tbl found", tbl_name);


	/* locate to (row x char_per_row) */
	row=0; i=0;
	while(row==0) {
		k=fscanf(inp," ( %d x %d )", &row, &char_per_row);
		i++;

		if((k==EOF) || (i>10)) {
			fprintf(stderr,"\nmktable: No (row x char_per_row) found...");
			return -1;
		}
	}
	fprintf(stderr,"\nmktable: (row=%d, char_per_row=%d) found", row, char_per_row);


	/* store the comment */
	i=0;
	while ((c=fgetc(inp)) != '\n') {
		comment[i++]=c;
		if(i>250) break;
	}
	comment[i]=0;
	fprintf(stderr,"\nmktable: comment (%s) retrieved",comment);


	/* allocate the size of table */
	tbl_size = row * char_per_row * 2;
	tbl = (unsigned char*) calloc(tbl_size,sizeof(unsigned char));
	if(tbl==NULL) {
		fprintf(stderr,"\nmktable: can't allocate %d bytes for table",tbl_size);
		return -1;
	}
	else
		fprintf(stderr,"\nmktable: %d bytes allocated for table",tbl_size);


	/* start to build the table */
	index=0;  str[0]=0;
	for(i=1; i<row+1; i++) {
		/* locate to Row */
		l=0;
		while(1) {
			k=fscanf(inp,"%s",str);
			if(debug>0)
				fprintf(stderr,"\nmktable: (%d) <%s>",l,str);

			if(strcmp(str,"Row")==0) break;
			l++;

			if((k==EOF) || (l>100)) {
				fprintf(stderr,"\nmktable: No Row found.  Abort after token (%s)...",str);
				return -1;
			}
		}


		/* locate to (num) & check num==row */
		r=0;
		k=fscanf(inp," ( %d )", &r);
		if((k==EOF) || (k!=1)) {
			fprintf(stderr,"\nmktable: no row (num) found...");
			return -1;
		}
		if(i==r)
			fprintf(stderr,"\nmktable: scan row (%d)", r);
		else
			fprintf(stderr,"\nmktable: row (%d) seen when row (%d) is expected",r,i);



		to_next_line();
		/* get char_per_row two-chars */
		for(j=1; j<char_per_row+1; j+= l-1) {

next_line:
			k=get_next_line(buffer);
			if(debug>0)
				fprintf(stderr,"\nmktable: (%d) <%s>", j, buffer);

			if(k==EOF) {
				fprintf(stderr,"\nmktable: Unexpected EOF in char_per_row loop");
				return -1;
			}

			for(r=0; r<17; r++) w[r][0]=0;
			l=sscanf(buffer,"%s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s",
				&w[0],&w[1],&w[2],&w[3],&w[4],&w[5],
				&w[6],&w[7],&w[8],&w[9],&w[10],
				&w[11],&w[12],&w[13],&w[14],&w[15],&w[16]);

			/* skip comment and blank lines */
			if((l<=0) || (strncmp(w[0],"//",2)==0))
				goto next_line;

			if(debug>0)
				fprintf(stderr,"\nmktable: to read %d items", l);
			/* read a full line into buffer */
			for(r=1; r<l; r++) {
				m = strlen(w[r]);
				if(m==0)	/* null translated */
					break;
				else if(m==2) {	/* 2 bytes translated */
					tbl[index++] = w[r][0];
					tbl[index++] = w[r][1];
				}
				else if(m==1) { /* 1 byte translated */
					tbl[index++] = w[r][0];
					tbl[index++] = 0;
				}
				else {		/* over 3 byte translated */
	/* store w[r] in supp table */
	/* store the index[0..256*128] to supp table in tbl[index++] */
					int l3,hi,lo;

					if((l3 = add_entry(w[r]))>=0) {

						hi = l3/256 + 0x80;
						lo = l3%256;

						tbl[index++] = hi;
						tbl[index++] = lo;
					}
					else {
						tbl[index++] = w[r][0];
						tbl[index++] = w[r][1];
					}

/*
					fprintf(stderr,"\nmktable: supp (over 3 chars translation)  entry found. ");
*/
				}
			}
		}
	}

	fclose(inp);
	if(index != tbl_size)
		fprintf(stderr,"\nmktable: index != %d error",tbl_size,index);

	strcat(tbl_name,".t");
	ptable=fopen(tbl_name,"wb");
	fprintf(ptable,"%s (%d x %d) // %s\n", tbl_name, row, char_per_row, comment);
	fwrite(tbl,row,char_per_row*2,ptable);

	/* append the supp table here */
	write_supp_tbl(ptable);

	fclose(ptable);

	puts("\nThe end...");

	return 0;
}

to_next_line()
{
	while((fgetc(inp)) != '\n');

	return 0;
}

get_next_line(buffer)
char	*buffer;
{
	int	index;
	char	c;

	index=0;
	while(((c=fgetc(inp)) != '\n') && (c!=EOF)) {
		buffer[index++] = c;
	}
	buffer[index]=0;

	if(c=='\n') return index;
	else return EOF;
}


int	supp_tbl_size=0;
int	supp_tbl_max_index=0;

struct	entry {
	int	offset;
	char	*str;
	struct entry	*next;
} *p,*q,*n,head = {-1, "", NULL };

/*
	p	n
		current
*/
add_entry(str)
char	str[];
{
	int	index;

	p=&head; index=-1;
	while (p->next != NULL) {

		p = p->next;
		index++;

		if(strcmp(str,p->str)==0)
			return index;

	}

	p->next = n = (struct entry *) calloc(1,sizeof(struct entry));
	if(n==NULL) {
		fprintf(stderr,"\nadd_entry: can't allocate entry for table for <%s>",str);
		return -1;
	}
	n->next = NULL;

	n->str = (unsigned char*) calloc(strlen(str)+1,sizeof(unsigned char));
	if(n->str==NULL) {
		fprintf(stderr,"\nadd_entry: can't allocate %d bytes for string",strlen(str)+1);
		return -1;
	}
	strcpy(n->str,str);

	n->offset = p->offset + strlen(p->str) + 1;
	supp_tbl_size += strlen(str) + 1;

	supp_tbl_max_index++;

	return index+1;
}

write_supp_tbl(fp)
FILE *fp;
{
	int	length,offset_1st_string;
	unsigned char	hi,lo;

	/* write binary tbl size, tbl max index */
	supp_tbl_size += supp_tbl_max_index * 2;  /* each offset occupies 2 bytes */
	lo = supp_tbl_size & 0xff;
	hi = (supp_tbl_size >> 8) & 0xff;
	fwrite(&lo, sizeof(lo), 1, fp);
	fwrite(&hi, sizeof(hi), 1, fp);
	fprintf(stderr,"\nwrite_supp_tbl: supp_tbl_size (hi:%x, lo:%x)",hi,lo);

	lo = supp_tbl_max_index & 0xff;
	hi = (supp_tbl_max_index >> 8) & 0xff;
	fwrite(&lo, sizeof(lo), 1, fp);
	fwrite(&hi, sizeof(hi), 1, fp);
	fprintf(stderr,"\nwrite_supp_tbl: supp_tbl_max_index (hi:%x, lo:%x)",hi,lo);

	/* write offset out */
	offset_1st_string = supp_tbl_max_index * 2;
	p=&head;  length = 0;
	while(p->next != NULL) {
		p = p->next;
		p->offset += offset_1st_string;

		lo = p->offset & 0xff;
		hi = (p->offset >> 8) & 0xff;

		fwrite(&lo, sizeof(lo), 1, fp);
		fwrite(&hi, sizeof(hi), 1, fp);
		length += 2;
	}

	/* write strings out */
	p=&head;
	while(p->next != NULL) {
		p = p->next;
		fwrite(&p->str[0], sizeof(char), strlen(p->str)+1, fp);
		length += strlen(p->str) + 1;
	}

	/* check if written length equals expected length */
	if(length != supp_tbl_size)
		fprintf(stderr,"\nwrite_supp_tbl: supp_tbl_size (%d) != written length (%d)",
			supp_tbl_size, length);

	/* summary */
	fprintf(stderr,"\nwrite_supp_tbl: supp_tbl_size=%d",supp_tbl_size);
	fprintf(stderr,"\nwrite_supp_tbl: supp_tbl_max_index=%d",supp_tbl_max_index);

	return 0;
}
