#include <stdio.h>

/*
	To compile jis.c, use 'cc -o jis jis.c'

        To produce table, use 'jis > jis.tbl'

        To print table, use 'a2ps jis.tbl | lpr'


	Info about JIS Code: JISX0208.1983
	-------------------
	2121 - 747e (94 x 84 = 7,896 char)

	[notation]
1	2121 - 217e (94)	Subtotal:  94 char
2	2221 - 227e (94)		   53 char

	[number and english letter]
3	2321 - 237e (94)		   62 char

	[hiragana]
4	2421 - 2473 (83)		   83 char

	[katakana]
5	2521 - 2576 (88)		   88 char

	[greek letter]
6	2621 - 267e (94)		   48 char

	[russian letter]
7	2721 - 277e (94)		   66 char

	[table graphics]
8	2821 - 287e (94)		   32 char
9-15
	[1st level, by ondoku]
16	3021 - 307e (94)	Subtotal:  94 char
17-46	...........			   94 x 30
47	4f21 - 4f53 (51)		   51

	[2nd level, by bushyu]
48	5021 - 507e (94)	Subtotal:  94 char
49-82	...........			   94 x 34
83	7321 - 737e (94)		   94

	[others]
84	7421 - 7424 (4)		   	    4
85-94
				====================
				Used:   6,879 (87%)
				Unused:	1,017 ( 7%)
*/

main()
{
	int i, j;

puts("//	Info about JIS Code: JISX0208.1983");
puts("//	---------------------------------");
puts("//	2121 - 747e (94 char/row x 84 row = 7,896 char)");

	for (i = 0x21; i <= 0x74; ++i) {
		for (j = 0x20; j <= 0x7e; ++j) {
			if (j == 0x20) printf("\n\n//	Row (%2d)",i-0x20);
			if (j % 16 == 0) printf("\n%2x%2x  ", i, j);

			if (j == 0x20) printf("    ");
			else {
				printf("  ");
				putchar(i+0x80);
				putchar(j+0x80);
			};
		};
	};
	putchar('\n');

	exit(0);
}
