/*
	jp-util.c
					Modified by Seke Wei
					on Feb 16 1996
unsigned char * SJIS_TO_JIS1(HI,LO,JCODE)
unsigned char * JIS_TO_SJIS1(HI,LO,SJCODE)
unsigned char * SJIS_TO_EUC1(HI,LO,EUC)
unsigned char * SJIS_TO_EUC(src,dst)
unsigned char * EUC_TO_SJIS(src,dst)
unsigned char * EUC_TO_JIS(src,dst,toK,toA)
static unsigned char *recoverJIS(src,dstp)
unsigned char * TO_EUC(jis,euc,ctype)
static 		is_EUC_JP(euc)
		TO_SJIS(any,sjis,ctype)
		TO_JIS(any,jis,ctype)
		EUC_TO_KUTEN(istr,ostr)
int		seq_ejis(c1,c2)

////////////////////////////////////////////////////////////////////////
Copyright (c) 1993 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material
for any purpose and without fee is hereby granted, provided
that the above copyright notice and this permission notice
appear in all copies, and that the name of ETL not be
used in advertising or publicity pertaining to this
material without the specific, prior written permission
of an authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY 
OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", 
WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	SJIS.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	930923	extracted from codeconv.c of cosmos
///////////////////////////////////////////////////////////////////////*/
#include <stdio.h>
#include <string.h>
#include "jp-util.h"

char *malloc();

int TREAT_SJIS = 1;

unsigned char *
SJIS_TO_JIS1(HI,LO,JCODE)
	register unsigned char HI,LO,*JCODE;
{
	HI -= (HI <= 0x9F) ? 0x71 : 0xB1;
	HI = (HI << 1) + 1;
	if( 0x7F < LO )
		LO--;
	if( 0x9E <= LO ){
		LO -= 0x7D;
		HI++;
	}else	LO -= 0x1F;
	JCODE[0] = HI;
	JCODE[1] = LO;
	return JCODE;
}
unsigned char *
JIS_TO_SJIS1(HI,LO,SJCODE)
	register unsigned char HI,LO,*SJCODE;
{
	if( HI & 1 )
		LO += 0x1F;
	else	LO += 0x7D;
	if( 0x7F <= LO )
		LO++;

	HI = (((int)HI - 0x21) >> 1) + 0x81;
	if( 0x9F < HI )
		HI += 0x40;
	SJCODE[0] = HI;
	SJCODE[1] = LO;
	return SJCODE;
}

unsigned char *
SJIS_TO_EUC1(HI,LO,EUC)
	unsigned char HI,LO,*EUC;
{
	SJIS_TO_JIS1(HI,LO,EUC);
	EUC[0] |= 0x80;
	EUC[1] |= 0x80;
	return EUC;
}

unsigned char *
SJIS_TO_EUC(src,dst)
	unsigned char *src,*dst;
{	register unsigned char hi,lo,*sp,*dp;
	register int in_sjis = 0;

	for(sp=src, dp=dst; (hi = sp[0])!=0; ){
		lo = sp[1];
		if( TREAT_SJIS && IS_SJIS(hi,lo,in_sjis) ){
			SJIS_TO_JIS1(hi,lo,dp);
			dp[0] |= 0x80;
			dp[1] |= 0x80;
			dp += 2;
			sp += 2;
		}else	*dp++ = *sp++;
	}
	*dp = 0;
	return dst;
}

unsigned char *
EUC_TO_SJIS(src,dst)
	unsigned char *src,*dst;
{	register unsigned char *sp,*dp;

	for(sp=src, dp=dst; *sp; ){
		if( *sp & 0x80 ){
			if( sp[1] && (sp[1] & 0x80) ){
				JIS_TO_SJIS1(sp[0]&0x7F,sp[1]&0x7F,dp);
				dp += 2; sp += 2;
			}else	sp++;
		}else	*dp++ = *sp++;
	}
	*dp = 0;
	return dst;
}

#define Strcpy(a,b)	(strcpy((char*)a,(char*)b),&a[strlen((char*)a)])

unsigned char *
EUC_TO_JIS(src,dst,toK,toA)
	unsigned char *src,*dst;
	char *toK,*toA;
{	register unsigned char kana_mode = 0;
	register unsigned char cch;
	register unsigned char *sp = src;
	register unsigned char *dp = dst;

	while( (cch = *sp++)!=0 ){
		if(cch & 0x80){
			if(!kana_mode){
				kana_mode = ~kana_mode;
				dp = Strcpy(dp,toK);
			}
			if( *sp & 0x80 ){
				*dp++ = cch & ~0x80;
				*dp++ = *sp++ & ~0x80;
			}
		}else{
			if(kana_mode){
				kana_mode = ~kana_mode;
				dp = Strcpy(dp,toA);
			}
			*dp++ = cch;
		}
	}
	if(kana_mode)
		dp = Strcpy(dp,toA);

	if(dp)	*dp = 0;
	return dst;
}

#define	IS_JIS7(c1,c2)	(0x20<(c1)&&(c1)<0x7F && 0x20<(c2)&&(c2)<0x7F)
#define SO		('N'-0x40)
#define SI		('O'-0x40)

int recover_JIS = 0;
static unsigned char *recoverJIS(src,dstp)
	unsigned char *src,**dstp;
{	unsigned char *s,*d,ch1,ch2;

	d = *dstp;
	s = src;
	while( ((ch1 = s[0]) != 0)  && ((ch2 = s[1]) != 0) ){
		s += 2;
		if( ch1 == '(' )
		if( ch2 == 'B' || ch2 == 'J' ){
			*dstp = d;
			return s;
		}
		if( !IS_JIS7(ch1,ch2) )
			return 0;

		*d++ = 0x80 | ch1;
		*d++ = 0x80 | ch2;
	}
	return 0;
}

unsigned char*
TO_EUC(jis,euc)
	unsigned char *jis,*euc;
{	register unsigned char *s,c,jis_stat;
	register to1B,to2B;
	register int in_sjis = 0;
	unsigned char *d;
	static int nje;
	int n8bits;

	nje++;
	n8bits = 0;
	s = jis;
	d = euc;
	jis_stat = 0;
	to2B = TO_2BCODE;
	to1B = TO_1BCODE;

	while( (c = *s++) != 0 ){
		if( c == to2B && jis_stat == 0 && recover_JIS ){
			if(*s == 'B' || *s == '@'){
				unsigned char *ts;
				if( (ts = recoverJIS(s+1,&d)) != 0 ){
					s = ts;
					continue;
				}
			}
		}
		if( c == ESC ){
			if(*s == to2B){
				if((s[1] == 'B') || (s[1] == '@')){
					jis_stat = 0x80; s += 2;
					continue;
				}
				jis_stat = 0;
			}else
			if(*s == to1B){
				jis_stat = 0;
				if((s[1]=='B') || (s[1]=='J') || (s[1]=='H')){
					s += 2;
					continue;
				}
			}else
			if(*s == ',') /* MULE */ {
				jis_stat = 0;
			}
		}
		if( c & 0x80 )
			n8bits++;

		if( IS_SJIS(c,*s,in_sjis) ){
			SJIS_TO_EUC1(c,*s,d);
			d += 2;
			s++;
		}else
		if( jis_stat ){
			if( c <= 0x20 || 0x7F <= c ){
				*d++ = c;
				if( c == '\n' )
					jis_stat = 0;
			}else{
				if( IS_JIS7(c,*s)){
					*d++ = jis_stat | c;
					*d++ = jis_stat | *s;
				}
				s++;
			}
		}else{
			if( n8bits == 0 && (c == SI || c == SO) ){
			}else{
				*d++ = c;
			}
		}
	}
	*d = 0;
	return euc;
}

#define non94(ch) ((ch) <= 0x20 || (ch) == 0x7F)
static is_EUC_JP(euc)
	char *euc;
{	char *cp;
	int ch1,ch2;

	for( cp = euc; (ch1 = *cp & 0xFF) != 0; cp++ ){
		if( ch1 & 0x80 ){
			ch2 = cp[1] & 0xFF;
			if( (ch2 & 0x80) == 0 ){
				fprintf(stderr,"is_EUC_JP: NOT_EUC1[%x][%x]\n",ch1,ch2);
				return 0;
			}
			if( non94(ch1&0x7F) || non94(ch2&0x7F) ){
				fprintf(stderr,"is-EUC_JP: NOT_EUC2[%x][%x]\n",ch1,ch2);
				return 0;
			}
			cp++;
		}
	}
	return 1;
}

TO_SJIS(any,sjis)
	char *any,*sjis;
{	char *euc;

	euc = malloc(strlen(any)+1);
	TO_EUC(any,euc);
	if( is_EUC_JP(euc) )
		EUC_TO_SJIS(euc,sjis);
	else	strcpy(sjis,any);
	free(euc);

	return 0;
}

TO_JIS(any,jis)
	char *any;
	unsigned char *jis;
{	char *euc;

	euc = malloc(strlen(any)+1);
	TO_EUC(any,euc);
/*
	if( is_EUC_JP(euc) )
		EUC_TO_JIS(euc,jis,TO_KANJI,TO_ASCII);
	else	strcpy(jis,any);
*/
	is_EUC_JP(euc);
	EUC_TO_JIS(euc,jis,TO_KANJI,TO_ASCII);

	free(euc);

	return 0;
}

/*---------------------------------------------------------------------
*/
/*
	appended by Seke Wei
*/
EUC_TO_KUTEN(istr,ostr)
unsigned char *istr,*ostr;
{
	int	n;
	unsigned char	*i,*o,hi,lo,ku,ten;

	for(i=istr, o=ostr; (*i!=0); ) {
		if(*i > 0x80) {
			hi=*i;
			lo=*(i+1);

			ku = (hi - 0xa0);
			ten = (lo - 0xa0);

			sprintf(o, "(%2d:%2d) ", ku, ten);

			i += 2;
			o += 8;
		}
		else	*o++ = *i++;
	}

	*o = 0;

	return 0;
}

/*
        find the sequence number of the ejis code (c1,c2)
*/
int
seq_ejis(c1,c2)
unsigned char   c1,c2;
{
        unsigned int    hi,lo,a,b,result;


        result = -1;
        if((c1>=0xa1) && (c1<=0xfe) && (c2>=0xa1) && (c2<=0xfe)) {
                hi = c1 & 0xff;  lo = c2 & 0xff;
                a=(hi-0xa1)*94;
                b=lo-0xa1;

                result = a + b + 1;
        }
/*
         else {
                result = 9;  // question mark
        }
*/
        return result;
}

