static char version[] = "cn2jp 1.3 (Mar 1, 1996)";

/*
  Copyright (C) 1996      Seke Wei      (seke@sys.es.osaka-u.ac.jp)

  cn-util.c: provides the supplementary routines for translation

        int     seq_gb(c1,c2)
                ;returns the code sequence of the GB code (c1,c2)

        int     seq_big(c1,c2)
                ;returns the code sequence of the Big5 code (c1,c2)

  This program is free for general distribution.

  This program runs on UNIX. You are welcome to port it to other operating
  systems.

*/


#include <stdio.h>
#include "lang-util.h"

/*
	Supplementary Routine for Translation
*/



/*
        find the sequence number of the gb code (c1,c2)
*/
int
seq_gb(c1,c2)
unsigned char   c1,c2;
{
        unsigned int    hi,lo,a,b,result;


        result = -1;
        if((c1>=0xa1) && (c1<=0xfe)  &&
           (c2>=0xa1) && (c2<=0xfe)) {
                hi = c1 & 0xff;  lo = c2 & 0xff;

                a=(hi-0xa1)*94;
                b=lo-0xa1;

                result = a + b + 1;
        }

        return result;
}



/*
        find the sequence number of the big5 code (c1,c2)
*/
int
seq_big(c1,c2)
unsigned char   c1,c2;
{
        unsigned int    hi,lo,a,b,result;


        result = -1;
        if((c1>=0xa1) && (c1<=0xfe)  &&
           ( ((c2>=0xa1) && (c2<=0xfe)) || ((c2>=0x40) && (c2<=0x7e)) )) {
                hi = c1 & 0xff;  lo = c2 & 0xff;

                a=(hi-0xa1)*157;
                b=(lo<0x80) ? lo - 0x40 : lo - 0xa1 + 63;

                result = a + b + 1;
        }

        return result;
}
