static char version[] = "cn2jp 1.3 (Mar 1, 1996)";

/*
  Copyright (C) 1996      Seke Wei      (seke@sys.es.osaka-u.ac.jp)

  g2j-util.c: provide related routines for GB Chinese to Japanese conversion

	char    *lang_gb_to_eucjis(istr)
		;translate GB in istr to EUC-Jis in allocated buffer
		;the allocated buffer is returned and valid until next call

  This program is free for general distribution.

  This program runs on UNIX. You are welcome to port it to other operating
  systems.

*/


#include <stdio.h>
#include "lang-util.h"

int	seq_gb();
/*
	translate gb in istr to euc-jis in allocated buffer

*/


char *
lang_gb_to_eucjis(istr)
char	*istr;
{

	if(!g2jtbl.loaded) {
		memcpy(&g2jtbl, &g2jtbl_static, sizeof(struct code_table));
		g2jtbl.src_seq = seq_gb;
		g2jtbl.src_seq_to_dest = src_seq_to_dest;
		g2jtbl.src_to_dest = src_to_dest;

		memcpy(&uzpjtbl, &uzpjtbl_static, sizeof(struct uzpj_table));
	}

	return (*g2jtbl.src_to_dest)(&g2jtbl, istr);
}
