static char version[] = "cn2jp 1.3 (Mar 1, 1996)";

/*
  Copyright (C) 1996      Seke Wei      (seke@sys.es.osaka-u.ac.jp)

  g2b-util.c: provide related routines for GB Chinese to Big5 Chinese conversion

	char    *lang_gb_to_big5(istr)
		;translate GB in istr to Big5 in allocated buffer
		;the allocated buffer is returned and valid until next call

  This program is free for general distribution.

  This program runs on UNIX. You are welcome to port it to other operating
  systems.

*/


#include <stdio.h>
#include "lang-util.h"

int	seq_gb();
/*
	translate gb in istr to big5 in allocated buffer

*/


char *
lang_gb_to_big5(istr)
char	*istr;
{
	static loaded=0;

	if(!loaded) {
		memcpy(&g2btbl, &g2btbl_static, sizeof(struct code_table));
		g2btbl.src_seq = seq_gb;
		g2btbl.src_seq_to_dest = src_seq_to_dest;
		g2btbl.src_to_dest = src_to_dest;

		memcpy(&uzpjtbl, &uzpjtbl_static, sizeof(struct uzpj_table));
		loaded=1;
	}

	return (*g2btbl.src_to_dest)(&g2btbl, istr);
}
