static char version[] = "cn2jp 1.3 (Mar 1, 1996)";

/*
  Copyright (C) 1996      Seke Wei      (seke@sys.es.osaka-u.ac.jp)

  b2j-util.c: provide related routines for Big5 Chinese to Japanese conversion

	char    *lang_big5_to_eucjis(istr)
		;translate Big5 in istr to EUC-Jis in allocated buffer
		;the allocated buffer is returned and valid until next call

  This program is free for general distribution.

  This program runs on UNIX. You are welcome to port it to other operating
  systems.

*/

#include <stdio.h>
#include "lang-util.h"

int	seq_big();

/*
	translate big5 in istr to euc-jis in allocated buffer
*/

char *
lang_big5_to_eucjis(istr)
char	*istr;
{

	if(!b2jtbl.loaded) {
		memcpy(&b2jtbl, &b2jtbl_static, sizeof(struct code_table));
		b2jtbl.src_seq = seq_big;
		b2jtbl.src_seq_to_dest = src_seq_to_dest;
		b2jtbl.src_to_dest = src_to_dest;

		memcpy(&uzpjtbl, &uzpjtbl_static, sizeof(struct uzpj_table));
	}

	return (*b2jtbl.src_to_dest)(&b2jtbl, istr);
}
