// Purpose: FindProxyForURL functions
// 
// Perforce ID: $Id: //icaclient/release/ica1000unix/unix/pacexec/pac.js#1 $
//
// Notes: See http://developer.netscape.com:80/docs/manuals/proxy/adminux/autoconf.html
// and http://wp.netscape.com/eng/mozilla/2.0/relnotes/demo/proxy-live.html
// 
// Copyright 2004 Citrix Systems, Inc.  All Rights Reserved.


// --------------------------------------------------------------------------------------------------
//
// The handling of the arguments to the dateRange function is complicated by the number of different
// call formats, and the defaults which must be supplied for missing arguments
//
//  In the following table, the following are defined as:
//
//     dd    = current day
//     mm    = current month
//     yy    = current year
//     ld(M) = last day of month M
//
//  format   call                                                  startDate           endDate
//  ------   ----                                                 /---------\      /-------------\
//  1        dateRange(D1                    )    ==    dateRange(D1, mm,  yy,     D1,     mm,  yy)
//  2        dateRange(D1, M1                )    ==    dateRange(D1, M1,  yy,     D1,     M1,  yy)
//  3        dateRange(D1, M1, Y1            )    ==    dateRange(D1, M1,  Y1,     D1,     M1,  Y1)
//  4        dateRange(D1,         D2        )    ==    dateRange(D1, mm,  yy,     D2,     mm,  yy)
//  5        dateRange(    M1                )    ==    dateRange(1,  M1,  yy,     ld(M1), M1,  yy)
//  6        dateRange(    M1,         M2    )    ==    dateRange(1,  M1,  yy,     ld(M2), M2,  yy)
//  7        dateRange(        Y1            )    ==    dateRange(1,  JAN, Y1,     31,     DEC, Y1)
//  8        dateRange(        Y1,         Y2)    ==    dateRange(1,  JAN, Y1,     31,     DEC, Y2)
//  9        dateRange(D1, M1,     D2, M2    )    ==    dateRange(D1, M1,  yy,     D2,     M2,  yy)
//  10       dateRange(    M1, Y1,     M2, Y2)    ==    dateRange(1,  M1,  Y1,     ld(M2), M2,  Y2)
//  11       dateRange(D1, M1, Y1, D2, M2, Y2)    ==    dateRange(D1, M1,  Y1,     D2,     M2,  Y2)
//
//
//  Defaults for D2:  D1, ld(M1), ld(M2), 31
//  Defaults for M2:  M1, mm, DEC
//  Defaults for Y2:  Y1, yy
//
// --------------------------------------------------------------------------------------------------
//
// Similarly, the defaults for the timeRange function are:
//
//  format   call                                                  startTime       endTime
//  ------   ----                                                  /--------\    /--------\
//  1        timeRange(H1                    )     ==    timeRange(H1, 00, 00,   H1, 59, 59)
//  2        timeRange(H1,         H2        )     ==    timeRange(H1, 00, 00,   H2, 59, 59)
//  3        timeRange(H1, M1,     H2, M2    )     ==    timeRange(H1, M1, 00,   H2, M2, 59)
//  4        timeRange(H1, M1, S1, H2, M2, S2)     ==    timeRange(H1, M1, S1,   H2, M2, S2)
//
// Note that this does not agree with the examples given in the specification (see Notes above)
//
//        Navigator Proxy Auto-Config File Format
//
// but those examples appear to be incorrect (and are inconsistent with those for dateRange).
//
// --------------------------------------------------------------------------------------------------

// wpad.dat generated by ISA Server 2004 requires these to be defined
var cCARPExceptions;
var BackupRoute;
var UseDirectForLocal;
var DirectIPs;
var cDirectIPs;
var CARPExceptions;
var DirectNames;
var cDirectNames;
var HttpPort;
var cNodes;
var Proxies;

// hostname based functions
function isPlainHostName(host)
{
	return host.search(/\./) == -1;
}

function dnsDomainIs(host, domain)
{
	return host.length >= domain.length && host.substr(host.length - domain.length) == domain;
}

function localHostOrDomainIs(host, hostdom)
{
	if (isPlainHostName(host)) {
		return hostdom.search(host) != -1;
	} else {
		return host == hostdom;
	}
}

function isResolvable(host)
{
	return dnsResolve(host) != null;
}

function isInNet(host, pattern, mask)
{
	// convert from dotted quad to binary
	function inet_addr(cp)
	{
		// convert to array of bytes
		var bytes = cp.split('.');

		// convert to binary
		return ((parseInt(bytes[0]) & 0xff) << 24) | 
		       ((parseInt(bytes[1]) & 0xff) << 16) |
		       ((parseInt(bytes[2]) & 0xff) <<  8) |
		        (parseInt(bytes[3]) & 0xff)
	}

	// host can be an IP address or a hostname
	// for speed don't do name resolution if a dotted
	// quad has been specified
	var dq = host.match(/^\d{1,4}\.\d{1,4}\.\d{1,4}\.\d{1,4}$/);
	if (dq == null) {
		// not a dotted quad - attempt to resolve the name
		host = resolve(host);
		if (host == null) {
			// could't resolve name
			return false;
		}
	} else {
		// address was in form of dotted quad. Check that
		// this is valid.
		var bytes = host.split('.'); 
		for (var i = 0; i < bytes.length; i++) {
			if (Number(bytes[i] > 255))
				return false;
		}
	}

	// convert the pattern and mask to binary then do the test
	var h = inet_addr(host);
	var p = inet_addr(pattern);
	var m = inet_addr(mask);

	return (h & m) == (p & m);
}

// related utility functions
function myIpAddress() 
{
	try {
		return resolve(hostname());
	} catch (e) {
		return '127.0.0.1';
	}
}

function dnsResolve(host)
{
	try {
		return resolve(host);
	} catch (e) {
		return null;
	}
}

function dnsDomainLevels(host)
{
	return host.split(".").length - 1;
}

// URL/hostname matching functions
function shExpMatch(str, shexp)
{
	// replace shell dot with its JS literal
	shexp = shexp.replace(/\./g, '\.');

	// replace shell '*' with JS meaning zero or more of any character
	shexp = shexp.replace(/\*/g, '.*');

	// replace shell '?' with JS meaning any single character
	shexp = shexp.replace(/\?/g, '.');

	// create a new RE which will match between the beginning and 
	// end of str
	var re = new RegExp('^' + shexp + '$');

	// now test the match
	return re.test(str);
}

// time based functions
var weekdays = new Array('SUN', 'MON', 'TUE', 'WED', 'THU', 'FRI', 'SAT');
var months   = new Array('JAN', 'FEB', 'MAR', 'APR', 'MAY', 'JUN', 
			 'JUL', 'AUG', 'SEP', 'OCT', 'NOV', 'DEC');
var days     = new Array(31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);


var DAY   = 1;
var MONTH = 2;
var YEAR  = 3;

function makeFormat()
{
	var format = 0;

	for (var i = 0; i < arguments.length; i++) {
		format = (format << 2) + arguments[i];
	}

	return format;
}

// compare with table at start of file
var callFormat1  = makeFormat(DAY                               );
var callFormat2  = makeFormat(DAY, MONTH                        );
var callFormat3  = makeFormat(DAY, MONTH, YEAR                  );
var callFormat4  = makeFormat(DAY,              DAY             );
var callFormat5  = makeFormat(     MONTH                        );
var callFormat6  = makeFormat(     MONTH,            MONTH      );
var callFormat7  = makeFormat(            YEAR                  );
var callFormat8  = makeFormat(            YEAR,             YEAR);
var callFormat9  = makeFormat(DAY, MONTH,       DAY, MONTH      );
var callFormat10 = makeFormat(     MONTH, YEAR,      MONTH, YEAR);
var callFormat11 = makeFormat(DAY, MONTH, YEAR, DAY, MONTH, YEAR);

//print("callFormat1  = " + callFormat1);
//print("callFormat2  = " + callFormat2);
//print("callFormat3  = " + callFormat3);
//print("callFormat4  = " + callFormat4);
//print("callFormat5  = " + callFormat5);
//print("callFormat6  = " + callFormat6);
//print("callFormat7  = " + callFormat7);
//print("callFormat8  = " + callFormat8);
//print("callFormat9  = " + callFormat9);
//print("callFormat10 = " + callFormat10);
//print("callFormat11 = " + callFormat11);


// signature is weekdayRange(wd1, wd2, gmt)
// only first parameter is mandatory. Second, third or both may be left out
function weekdayRange()
{
	function getDay(wd)
	{
		for (var i = 0; i < weekdays.length; i++) {
			if (wd == weekdays[i]) {
				return i;
			}
		}
		return -1;
	}

	var argc = arguments.length;

	// there must be at least one argument: wd1
	if (argc < 1) return false;

	// find out what the current date is
	var date = new Date();

	// see if the last argument is GMT. The second argument
	// may or not be present
	var wd;
	if (arguments[argc - 1] == 'GMT') {
		wd = date.getUTCDay();

		// loose the GMT argument. Now have wd1 and possibly wd2
		argc--;		
	} else {
		wd = date.getDay();
	}

	var wd1 = getDay(arguments[0]);					// always have this
	var wd2 = (argc == 2 ? getDay(arguments[1]) : wd1);		// use wd1 if wd2 not present

	// bail out if wd1 or wd2 is invalid
	if (wd1 == -1 || wd2 == -1)
		return false;

	// if wd2 < wd1 then we're testing into next week
	// otherwise test we're in [wd1,wd2]
	if (wd2 < wd1) {
		return wd >= wd1 || wd <= wd2;
	} else {
		return wd1 <= wd && wd <= wd2;
	}
}

function dateRange()
{
	function getMonth(mo)
	{
		for (var i = 0; i < months.length; i++) {
			if (mo == months[i]) {
				return i;
			}
		}
		return -1;
	}

        function daysInMonth(mo, yr)
        {
		// safety check in case the month was invalid
		if (mo == -1)
			return 0;

                if (mo == 1) {
                        // February: test if the year is a leap year by setting the
                        // date to Feb 29. If we roll over to 1st March then
                        // it's not a leap year.
                        var date = new Date(yr, 1, 1, 0, 0, 0, 0);
                        date.setDate(29);
                        return (date.getDate() == 1 ? 28 : 29);
                }

		return days[mo];
        }

	function makeActualFormat(argc, args)
	{
		var format = 0;

		for (var i = 0; i < argc; i++) {
			var arg = args[i];
			var form;

			if (typeof(arg) == "string") {
				form = MONTH;
			} else {
				form = (arg < 32) ? DAY : YEAR;
			}

			format = (format << 2) + form;
		}

		return format;
	}

	var argc = arguments.length;

	// there must be at least one argument
	if (argc < 1) return false;

	// if GMT has been specified it must be the last argument
	// we can then ditch it
	var gmt = arguments[argc - 1] == "GMT";
	if (gmt) argc--;

	// get the current date
	var date  = new Date();
	var year  = date.getFullYear();
	var month = date.getMonth();
	var day   = date.getDate();

        //print("today = " + date);

	var day1, day2, month1, month2, year1, year2;

	var callFormat = makeActualFormat(argc, arguments);

	//print("callFormat = " + callFormat);

	// see table at head of file

	if      (callFormat == callFormat1) {
		year2  = year1  = year;
		month2 = month1 = month;
		day2   = day1   = arguments[0];
	}
	else if (callFormat == callFormat2) {
		year2  = year1  = year;
		month2 = month1 = getMonth(arguments[1]);
		day2   = day1   = arguments[0];
	}
	else if (callFormat == callFormat3) {
		year2  = year1  = arguments[2];
		month2 = month1 = getMonth(arguments[1]);
		day2   = day1   = arguments[0];
	}
	else if (callFormat == callFormat4) {
		year2  = year1  = year;
		month2 = month1 = month;
		day1   = arguments[0];
		day2   = arguments[1];
	}
	else if (callFormat == callFormat5) {
		year2  = year1  = year;
		month2 = month1 = getMonth(arguments[0]);
		day1   = 1;
		day2   = daysInMonth(month2, year2);
	}
	else if (callFormat == callFormat6) {
		year2  = year1  = year;
		month1 = getMonth(arguments[0]);
		month2 = getMonth(arguments[1]);
		day1   = 1;
		day2   = daysInMonth(month2, year2);
	}
	else if (callFormat == callFormat7) {
		year2  = year1  = arguments[0];
		month1 = 0;
		month2 = 11;
		day1   = 1;
		day2   = 31;
	}
	else if (callFormat == callFormat8) {
		year1  = arguments[0];
		year2  = arguments[1];
		month1 = 0;
		month2 = 11;
		day1   = 1;
		day2   = 31;
	}
	else if (callFormat == callFormat9) {
		year2  = year1  = year;
		month1 = getMonth(arguments[1]);
		month2 = getMonth(arguments[3]);
		day1   = arguments[0];
		day2   = arguments[2];
	}
	else if (callFormat == callFormat10) {
		year1  = arguments[1];
		year2  = arguments[3];
		month1 = getMonth(arguments[0]);
		month2 = getMonth(arguments[2]);
		day1   = 1;
		day2   = daysInMonth(month2, year2);
	}
	else if (callFormat == callFormat11) {
		year1  = arguments[2];
		year2  = arguments[5];
		month1 = getMonth(arguments[1]);
		month2 = getMonth(arguments[4]);
		day1   = arguments[0];
		day2   = arguments[3];
	}
	else {
		//print("*** illegal format " + callFormat);
		return false;
	}

	//print("day1 = " + day1 + " month1 = " + month1 + " year1 = " + year1);
	//print("day2 = " + day2 + " month2 = " + month2 + " year2 = " + year2);

	if (year1 < 1970 || year2 < 1970)
		return false;

	if (month1 >= 0) {
		if (day1 > daysInMonth(month1, year1)) {
			//print("too many days!");
			return false;
		}
	}
	if (month2 >= 0) {
		if (day2 > daysInMonth(month2, year2)) {
			//print("too many days!");
			return false;
		}
	}

	var startDate, endDate;

	// if the dates were specified as being GMT, construct UTC endpoints
	if (gmt)
	{
		startDate = new Date(Date.UTC(year1, month1, day1,  0,  0,  0));
		endDate   = new Date(Date.UTC(year2, month2, day2, 23, 59, 59));
	}
	else // construct local timezone endpoints
	{
		startDate = new Date(year1, month1, day1,  0,  0,  0);
		endDate   = new Date(year2, month2, day2, 23, 59, 59);
	}

        //print("checking " + startDate + " <= " + date + " <= " + endDate);

	// now see if the current date is in range
	return (startDate <= date) && (date <= endDate);
}

function timeRange()
{
	var argc = arguments.length;

	// there must be at least one argument
	if (argc < 1) return false;

	// if GMT has been specified it must be the last argument
	// we can then ditch it
	var gmt = arguments[argc - 1] == "GMT";
	if (gmt) argc--;

	// get the current time (date)
	var date = new Date();

	// get the hour and adjust for GMT if required
	// for efficiency get the hour now for use in simple
	// comparisons where only hour1 or hour1 and hour2 are 
	// specified. Other comparisons compare Date objects.
	var hour = gmt ? date.getUTCHours() : date.getHours();

	var hour1, hour2;

	// hour1 is always in the same place
	hour1 = arguments[0];
	if (hour1 > 23) {
		return false;
	}

	if (argc == 1) {
		// only hour specified: does it match?
		return hour == hour1;
	}

	// hour2 can start at position 1, 2, or 3
	var pos = argc >> 1;
	hour2   = arguments[pos];
	if (hour2 > 23) {
		return false;
	}

	if (argc == 2) {
		// two hours specified: is it between them (inclusive)?
		return (hour1 <= hour) && (hour <= hour2);
	}

	// hour1, min1, sec1, hour2, min2, sec2 or
	// hour1, min1, hour2, min2 specified

	var minute1, minute2, second1, second2;

	// min1 is always in the same place, min2 is after hour2
	minute1 = arguments[1];
	minute2 = arguments[pos + 1];

	if (minute1 > 59 || minute2 > 59) {
		return false;
	}

	if (argc == 6) {
		// hour1, min1, sec1, hour2, min2, sec2 specified
		second1 = arguments[2];
		second2 = arguments[5];

		if (second1 > 59 || second2 > 59) {
			return false;
		}
	} else if (argc == 4) {
		// supply defaults
		second1 =  0;
		second2 = 59;
	} else {
		//print("*** illegal format");
		return false;
	}

	var year  = date.getFullYear();
	var month = date.getMonth();
	var day   = date.getDate();

	var startDate, endDate;

	// if the times were specified as being GMT, construct UTC endpoints
	if (gmt)
	{
		startDate = new Date(Date.UTC(year, month, day, hour1, minute1, second1));
		endDate   = new Date(Date.UTC(year, month, day, hour2, minute2, second2));
	}
	else // construct local timezone endpoints
	{
		startDate = new Date(year, month, day, hour1, minute1, second1);
		endDate   = new Date(year, month, day, hour2, minute2, second2);
	}

       	//print("checking " + startDate + " <= " + date + " <= " + endDate);

	// now see if the current date is in range
	return (startDate <= date) && (date <= endDate);
}
