/*

	$Id: ipstat.h,v 1.5 1999/07/11 22:28:39 tron Exp $

*/

#ifndef IPSTAT_H
#define IPSTAT_H 42

#include <sys/types.h>
#include <netinet/in.h>

#ifndef TRUE
#define TRUE  1
#endif

#ifndef FALSE
#define FALSE 0
#endif

typedef struct AccountStruct Account;
struct AccountStruct
 {
  Account *a_Next;
  u_int32_t a_Packets;
  u_int64_t a_Bytes;
  char a_Name[1];
 };

typedef struct MatchStruct Match;
struct MatchStruct
 {
  Match *m_Next;
  struct in_addr m_SrcAddr,m_SrcMask,m_DstAddr,m_DstMask;
  u_int8_t m_Proto;
  u_int16_t m_SrcPort,m_DstPort;
  Account *m_Account;
 };

typedef struct ConfigStruct Config;
struct ConfigStruct
 {
  Account *c_Accounts;
  Match *c_Matches;
 };

/* config.c */
void DeleteConfig(Config *);
Config *ReadConfig(char *);

/* main.c */
extern char *Progname;
extern int Verbose;

/* util.c */
#define Free(p) free(p)
void *MAlloc(int);
void *CAlloc(int,int);
char *StrDup(char *);

#endif
