/*
   NAME memops.c CREATED 11:28 26 Jan, 1994
   

   Perform memory operations (peek, poke, and, or, xor, etc. etc.)
 */


#include <stdio.h> 
#include <stdlib.h>

#include "config.h"

#ifdef USE_UNISTD
#include <unistd.h>
#endif

#ifdef USE_MMAP
#include <sys/types.h>
#include <sys/mman.h>
#include <fcntl.h>
#endif

#include "commands.h"
#include "chipmunk.h"



#ifdef OBSOLETED
int peek (int argc, char **argv) { 
  int a, d;

  MINARGC (2);
  a = BASE + myatoi (argv[1]);
  d = *(int *)a;
  printf ("%08x:   %08x.\n", a, d);
  return (d);
}


int peekb (int argc, char **argv) {
  int a, d;

  MINARGC (2);
  a = BASE + myatoi (argv[1]);
  d = *(unsigned char *)a;
  printf ("%08x:   %02x.\n", a, d);
  return (d);
}


int pokeb (int argc, char **argv) {
  int a;

  MINARGC (3);
  a = BASE + myatoi (argv[1]);
  *(unsigned char *)a = myatoi (argv[2]);
  return (0);
}


int peekst (int argc, char **argv) {
  int a;

  MINARGC (2);
  a = BASE + myatoi (argv[1]);
  return (*(unsigned int *)a);
}


int peekbst (int argc, char **argv) {
  int a;

  MINARGC (2);
  a = BASE + myatoi (argv[1]);
  return (*(unsigned char *)a);
}



int peeks (int argc, char **argv) {
  int a, d;

  MINARGC (2);
  a = BASE + myatoi (argv[1]);
  d = *(unsigned short *)a;
  printf ("%08x:   %04x.\n", a, d);
  return (d);
}

#endif

int poke (int argc, char **argv) {
  int a;

  MINARGC (3);
  a = BASE + myatoi (argv[1]);
  *(int *)a = myatoi (argv[2]);
  return (0);
}


int and (int argc, char **argv) {
  int a;

  MINARGC (3);
  a = BASE + myatoi (argv[1]);
  *(int *)a &= myatoi (argv[2]);
  return (0);
}


int or (int argc, char **argv) {
  int a;

  MINARGC (3);
  a = BASE + myatoi (argv[1]);
  *(int *)a |= myatoi (argv[2]);
  return (0);
}


int xor (int argc, char **argv) {
  int a;

  MINARGC (3);
  a = BASE + myatoi (argv[1]);
  *(int *)a ^= myatoi (argv[2]);
  return (0);
}



int pokes (int argc, char **argv) {
  int a;

  MINARGC (3);
  a = BASE + myatoi (argv[1]);
  *(unsigned short *)a = myatoi (argv[2]);
  return (0);
}


int ands (int argc, char **argv) {
  int a;

  MINARGC (3);
  a = BASE + myatoi (argv[1]);
  *(unsigned short *)a &= myatoi (argv[2]);
  return (0);
}


int ors (int argc, char **argv) {
  int a;

  MINARGC (3);
  a = BASE + myatoi (argv[1]);
  *(unsigned short *)a |= myatoi (argv[2]);
  return (0);
}


int xors (int argc, char **argv) {
  int a;

  MINARGC (3);
  a = BASE + myatoi (argv[1]);
  *(unsigned short *)a ^= myatoi (argv[2]);
  return (0);
}


int pokeb (int argc, char **argv) {
  int a;

  MINARGC (3);
  a = BASE + myatoi (argv[1]);
  *(unsigned char *)a = myatoi (argv[2]);
  return (0);
}


int andb (int argc, char **argv) {
  int a;

  MINARGC (3);
  a = BASE + myatoi (argv[1]);
  *(unsigned char *)a &= myatoi (argv[2]);
  return (0);
}


int orb (int argc, char **argv) {
  int a;

  MINARGC (3);
  a = BASE + myatoi (argv[1]);
  *(unsigned char *)a |= myatoi (argv[2]);
  return (0);
}


int xorb (int argc, char **argv) {
  int a;

  MINARGC (3);
  a = BASE + myatoi (argv[1]);
  *(unsigned char *)a ^= myatoi (argv[2]);
  return (0);
}



int fill (int argc, char **argv) {
  int i, j, l, v[30], n;
  int *p;

  MINARGC (3);
  p = (int *) (BASE + myatoi (argv[1]));
  l = myatoi (argv[2]);
  for (j=0;j<argc-2;j++) {
    v[j] = myatoi (argv[j+3]);
  }
  n = j-1;
  l = l / n / sizeof (int);
  for (i=0;i<l;i++) {
    for (j=0;j<n;j++)
      *p++ = v[j];
  }

  if (VERBOSE > 0) {
    for (j=0;j<n;j++)
      printf ("%d ", v[j]);
    printf ("Filled upto %08x.\n", (int)p);
  }
  return 0;
}


int do_memcpy (int argc, char **argv) {
  int l;
  int *p, *q;

  p = (int *) (BASE + myatoi (argv[1]));
  l = myatoi (argv[2]);
  q = (int *) (BASE + myatoi (argv[3]));
  memcpy (q, p, l);
  if (VERBOSE > 0) {
    printf ("copied %d bytes from %08x to %08x.\n", l, (int)p, (int)q);
  }
  return 0;
}


#ifdef USE_MMAP
int domemmap (int argc, char **argv) {
  int a, l, fd;
  void *p;

  a = myatoi (argv[2]);
  l = myatoi (argv[3]);
  fd = open (argv[1], O_RDWR);
  if (fd < 0) {
    char buf[100];
    sprintf (buf, "Opening '%s'", argv[1]);
    perror (buf);
    return 1;
  }
  p = mmap (NULL, l, PROT_READ|PROT_WRITE, MAP_SHARED, fd, a);
  return (int)p;
}
#endif


int domalloc (int argc, char **argv) {
  int l;
  void *p;

  l = myatoi (argv[1]);
  p = MY_MALLOC (l);
  return (int)p;
}


int dofree (int argc, char **argv) {
  void *p;

  p = (void *)myatoi (argv[1]);
  if ((unsigned int)p < 4096) {
    if (VERBOSE >= 2)
      printf ("ERR: %08x cannot be a pointer\n", (unsigned int) p);
    return 1;
  }
  free (p);
  return 0;
}

int dump (int argc, char **argv) {
  static unsigned char * a = NULL;
  int l, i, j, ch;
#define DEFAULT_LENGTH 0x80
#define LINE_LENGTH    0x10

  if (argc > 1)
    a = (unsigned char *) (BASE + myatoi (argv[1]));

  if (argc > 2)
    l = myatoi (argv[2]);
  else
    l = DEFAULT_LENGTH;

  for (i=0;i<l;i+=LINE_LENGTH, a+=LINE_LENGTH) {
    printf ("%08x  ", (unsigned int)a);
    for (j=0;j<MIN (LINE_LENGTH, l-i);j++) {
      printf ("%02x ", (int)*(a+j));
      if (j == 7)
        printf ("  ");
    }
    for (    ;j<LINE_LENGTH;j++) {
      printf ("   ");
      if (j == 7)
        printf ("  ");
    }
    printf ("   ");
    for (j=0;j<MIN (LINE_LENGTH,  l-i);j++) {
      ch = *(a+j);
      printf ("%c", ((ch > 0x20) && (ch < '~'))?ch:'.');
    }
    printf ("\n");
  }
  return 0;
}


