/*
   NAME tests.h CREATED 13 Sep, 1994

   */


#define noDEBUG

#define DWN(v,x,y) for((v)=(x);(v)>=(y);(v)--)
#define AN_X(x)   (x) ? "x" : " "
#define SQR(x)   ((x)*(x))
typedef unsigned char  UINT8;
typedef unsigned short UINT16;
typedef unsigned int   UINT32;

#define AT(p)    *(volatile TESTTYPE *)((p) + BASE)
#define A(p)     *(volatile UINT32   *)((p) + BASE)
#define AS(p)    *(volatile UINT16   *)((p) + BASE)
#define AB(p)    *(volatile UINT8    *)((p) + BASE)
#ifdef DEBUG
#  define WT(p,v) AT(addressfault(p)) = v
#  define RT(p)   (TESTTYPE)debugread(p)
#  define W(p,v)  A (addressfault(p)) = v
#  define R(p)    (UINT32  )debugread(p)
#  define WS(p,v) AS(addressfault(p)) = (UINT16)v
#  define RS(p)   (UINT16  )debugread(p)
#  define WB(p,v) AB(addressfault(p)) = (UINT8 )v
#  define RB(p)   (UINT8   )debugread(p)
#else
#  define WT(p,v) AT(p) = v
#  define RT(p)   AT(p)
#  define W(p,v)  A(p)  = v
#  define R(p)    A(p)
#  define WS(p,v) AS(p) = (UINT16)v
#  define RS(p)   AS(p)
#  define WB(p,v) AB(p) = (UINT8 )v
#  define RB(p)   AB(p)
#endif

UINT32 robust_read(volatile UINT32 ref, int ws, int p);
int    count_ones (UINT32 w);               /* count bits set to one in word */
UINT32 randomword (UINT32 p);     /* generate random word with probability p */
#ifdef DEBUG
UINT32 addressfault(UINT32 a);                      /* simulate addressfault */
UINT32 datalinefault(UINT32 data, UINT32 address); /* simulate datalinefault */
UINT32 debugread(UINT32 address);             /* simulate faulty read access */
void debugwrite(UINT32 address, UINT32 data);/* simulate faulty write access */
#endif
