/*
   NAME fileops.c CREATED 11:34 26 Jan, 1994
   

   perform file operations like load and save.
 */

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <fcntl.h>
#include <unistd.h>

#include "config.h"
#include "commands.h"
#include "chipmunk.h"



int load (int argc,char **argv){
  FILE *f;
  int a,n,s;
  
  MINARGC(3);
  if ((f = fopen (argv[1],"rb")) == NULL){
      printf ("Cannot open file `%s': %s.\n",argv[1], strerror(errno));
      return (-1);
  }
  a = BASE + myatoi (argv[2]);
  n = 0;
  do {
    s = fread ((void *)a,1,100000000,f);
    a += s;
    n += s;
  } while (s > 0);
  fclose (f);
  if (VERBOSE > 0)
    printf ("Read %08x bytes from '%s', into address %08x.\n",n,argv[1],a-n);
  return (n);
}


int save (int argc,char **argv){
  FILE *f;
  int a,n,s;
  
  MINARGC(4);
  a = BASE + myatoi (argv[2]);
  s = myatoi (argv[3]);
  if (!s) {
    printf ("Nothing to do.\n");
    return (1);
  }
  if ((f = fopen (argv[1],"w")) == NULL){
    printf ("Cannot open file `%s': %s.\n",argv[1], strerror(errno));
    return (1);
  }
  n = fwrite ((void *)a,1,s,f);
  fclose (f);
  printf ("Wrote %08x bytes into '%s', from address %08x.\n",n,argv[1],a);
  if (n == 0) perror("writing to file");
  return (0);
}


int do_open (int argc,char **argv)
{
  return open (argv[1],O_RDONLY);
}


int do_close (int argc,char **argv)
{
  close (myatoi (argv[1]));
  return (0);
}

