/*
   NAME dpmi_16.c CREATED 16:00 24 Mar, 1994

 */

#define DPMI_INT 0x31
#define DPMI_ALLOC_DESCRIPTORS     0x0000
#define DPMI_FREE_DESCRIPTOR       0x0001
#define DMPI_GET_INC_VALUE         0x0003
#define DMPI_GET_PHYSICAL_MAPPING  0x0800 
#define DPMI_FREE_ADDRESS_MAPPING  0x0801
#define DMPI_LOCK_REGION           0x0600
#define DMPI_UNLOCK_REGION         0x0601



UINT call_DPMI (UINT function,UNIT bx,UINT cx)
{
union _REGS Inregs;         /* register values on call           */
union _REGS Outregs;        /* register values on return         */

Inregs.x.ax = function;
Inregs.x.bx = bx;
Inregs.x.cx = cx;

_int86(DPMI_INT, &Inregs, &Outregs);
return (Outregs.x.ax);
}


void *call_DPMI_2 (UINT function, UNIT bx, UINT cx, UINT si, UINT di)
{
union _REGS Inregs;         /* register values on call           */
union _REGS Outregs;        /* register values on return         */

Inregs.x.ax = function;
Inregs.x.bx = bx;
Inregs.x.cx = cx;
Inregs.x.si = si;
Inregs.x.di = di;
_int86(DPMI_INT, &Inregs, &Outregs);
return (MAKELP (Outregs.x.bx,Outregs.x.cx));
}



UINT DPMI_alloc_descriptors (UINT n)
{
return call_DPMI (DMPI_ALLOC_DESCRIPTORS,0,n);
}

UINT DPMI_free_descriptor (UINT selector)
{
return call_DPMI (DMPI_FREE_DESCRIPTOR,selector,0);
}


UINT DPMI_get_inc_value (void)
{
return call_DPMI (DMPI_GET_INC_VALUE,0,0);
}

void *DPMI_get_physical_mapping (long base, long size)
{
return call_DPMI_2 (DMPI_GET_PHYSICAL_MAPPING,
                            HIWORD (base), LOWORD (base),
                            HIWORD (size), LOWORD (size));
}

void DPMI_free_address_mapping (long linaddress, long size)
{
call_DPMI (DPMI_FREE_ADDRESS_MAPPING, 
           HIWORD (linaddress), LOWORD (linaddress));
}

void DPMI_lock_region (long linaddress, long size)
{
call_DPMI_2 (DMPI_LOCK_REGION,
                            HIWORD (base), LOWORD (base),
                            HIWORD (size), LOWORD (size));
}


void DPMI_unlock_region (long linaddress, long size)
{
call_DPMI_2 (DMPI_UNLOCK_REGION,
                            HIWORD (base), LOWORD (base),
                            HIWORD (size), LOWORD (size));
}



//BOOL SetAddressMap(UINT *wSelBase)
BOOL SetAddressMap()
{
                   
   UINT wSelBase;                  
   int i,j,r;
       
   Base=0x0C00000;   
     
   wSelBase = DPMI_alloc_descriptors (16);
   delta =    DPMI_get_inc_value ();

   wSelector1[0] = wSelBase;
   for (i=1;i<16;i++)
     wSelector1[i] = wSelector1[i-1] + delta;

   for (i=0;i<16;i++)
   {
#if 0
/* Het lijkt mij alsof dit niet nodig is. */
      SetSelectorLimit (wSelector1[i], LIMIT);
      if (SetSelectorBase(wSelector1[i],Base+(long)i*0x10000L) == 0)
      { 
         printf(" ERROR LIMIT Address %d Value %0.4x %0.8x  \n",
                   i,wSelector1[i],r);

         for (j=0;j<=i;j++)             /* free Previous selectors    */
            FreeSelector(wSelector1[j]);
         return (FALSE);
      }
#endif
      p = DPMI_get_physical_mapping (Base + i*0x10000L, 0x10000L);
   
      if (i==0) Address = p;

      DPMI_free_address_mapping (p);  /* ????? */

      r = SetSelectorBase (wSelector1[i],Outregs.x.bx*0x10000);
      if (r == 0) 
      {
         printf(" ERROR LINEAR Address %d Value %0.4x %0.8x  \n",
                i,wSelector1[i],r);
         for (j=0;j<=i;j++)             /* Free Previous selectors    */
            FreeSelector(wSelector1[j]);
         return (FALSE);
      }
      SetSelectorLimit (wSelector1[i],LIMIT);
   }
   DPMI_lock_region (Address,0x00100000);
   return (TRUE);  
}
      
 
      
void ResetAddressMap()
{
   int j;

   DPMI_unlock_region (Address,0x00100000);

   for (j=0;j<16;j++)             
       DPMI_free_address_mapping (GetSelectorBase (wSelector1[j]));
 
   for (j=0;j<16;j++)             
     DPMI_free_selector (wSelector1[j]);
}
      
                
void __huge *get_addr (UBIT_8 bank, UBIT_16 offset)
{

   void  __huge *pPointer;
   UBIT_8 __huge *pBytePointer;
   TRACE;
   pBytePointer = ((UBIT_8 __huge *)MAKELP(wSelector1[bank],0)) + offset;
   pPointer=(void __huge **)pBytePointer;    
   return (pPointer);
}

