/*
 * CHEST, chess analyst.  For Copyright notice read file "COPYRIGHT".
 *
 * $Source: /home/heiner/ca/chest/RCS/str.c,v $
 * $Id: str.c,v 3.4 1999/09/12 21:04:15 heiner Exp $
 *
 *	String functions
 */

#include "str.h"


    Eximpl int
str_len( const char* str )
{
    register const char*	p;

    if( (p = str) ) {
	while( *p ) ++p;
	return p - str;
    }
    return 0;
}

    Eximpl int			/* -1 | position in string */
str_pos( const char* str, char chr )
{
    register const char*	p;
    register int		c;

    if( (p = str) && (c = chr) ) {
	for( ; *p != c ; ++p ) {
	    if( ! *p ) {
		return -1;
	    }
	}
	return p - str;
    }
    return -1;
}


    Eximpl int			/* whether equal contents (NIL=="") */
str_equal( register const char* s1, register const char* s2 )
{
    if( ! s1 ) s1 = "";
    if( ! s2 ) s2 = "";
    for( ; *s1 ; ++s1, ++s2 ) {
	if( *s1 != *s2 ) {
	    return 0;
	}
    }
    return !*s2;
}


    Eximpl int			/* -1|0|+1 s1<s2,=,> (NIL=="") */
str_cmp( register const char* s1, register const char* s2 )
{
    if( ! s1 ) s1 = "";
    if( ! s2 ) s2 = "";
    for( ; *s1 == *s2 ; ++s1, ++s2 ) {
	if( ! *s1 ) {
	    return 0;
	}
    }
    return (*s1 < *s2) ? -1 : 1;
}
