/*
 * CHEST, chess analyst.  For Copyright notice read file "COPYRIGHT".
 *
 * $Source: /home/heiner/ca/chest/RCS/solution.h,v $
 * $Id: solution.h,v 3.9 1999/09/26 21:02:59 heiner Exp $
 *
 *	Print solution tree, depth limited.
 */

#ifndef CHEST_solution_h_INCLUDED
#define CHEST_solution_h_INCLUDED

#include "types.h"
#include "board.h"

Extern int	f_nodualdep;		/* no duals for depth <= this */


Extern void	print_solution (
		    Board*	bp,		/* for this board */
		    int		depth,		/* sols in so many moves */
		    int		preply,		/* + this prefix ply */
		    Movelist*	solp,		/* are stored here */
		    int		limdepth,	/* max depth to print */
		    int		wantoptim
				);

Extern void	solution_stats (Bool doprint);

Extern void	sol_pv_fill(
		    Board*	bp,		/* for this board */
		    int		depth,		/* solution in so many moves */
		    int		preply,		/* + this prefix ply */
		    Move*	solp,		/* is stored here */
		    char*	buf,		/* fill in, here */
		    int		siz);		/* physical size of "buf" */

/*---------------------------------------------------------------------------*/
/* Support for sub-module "solopt":
 */

Extern char*	fill_conti (
		    int		soldep		/* of last analyse() */
			    );			/* --> static data */

/*
 * sol_analyse()
 *	Knows, how to call analyse apppropriately.
 *	Knows about "f_nodualdep": when the solution is too short
 *	it may get truncated, here.
 */
Extern int	sol_analyse (Board*, int depth, Movelist*);
						/* result from analyse */

#endif	/* ndef CHEST_solution_h_INCLUDED */
