/*
 * CHEST, chess analyst.  For Copyright notice read file "COPYRIGHT".
 *
 * $Source: /home/heiner/ca/chest/RCS/mksupp.c,v $
 * $Id: mksupp.c,v 1.3 1999/07/21 20:54:48 heiner Exp $
 *
 *	Support for programs, which produce "C sources",
 *	e.g. initialized arrays.
 *
 *	This source is expected to be "#include"-ed.
 *	There is no export interface.
 *
 *	The effective result is expected to be written to "stdout".
 *	The effective body must be implemented as "mk_doit(void)".
 */

#include <stdio.h>
#include "sysdep.h"		/* sys_xcode */

static char*	mk_progname	= "";

    static void
mk_pr_warn(void)
{
    /*
     * Print standard header, a non-source warning.
     */
    printf("%s", "/* WARNING: produced automatically");
    if( mk_progname && mk_progname[0] ) {
	printf(" (by %s)", mk_progname);
    }
    printf("%s", " ! */\n\n");
}

    static int				/* wanted (UNIX-) exit code */
mk_windup(void)
{
    /*
     * Detect output errors (which would be very dangerous).
     */
    (void) fflush(stdout);
    if( ferror(stdout) ) {
	if( mk_progname && mk_progname[0] ) {
	    fprintf(stderr, "(%s:) ", mk_progname);
	}
	perror("error writing stdout");
	return 3;	/* sorry */
    }
    return 0;		/* ok */
}


    static int				/* wanted (UNIX-) exit code */
mk_main( int argc, char** argv )	/*ARGSUSED*/
{
    int		ac = 0;
    int		xc;

    if( ac < argc ) {
	mk_progname = argv[ac++];
    }
    mk_pr_warn();
    mk_doit();
    xc = mk_windup();
    return xc;
}

#ifndef MK_NOMAIN
    int CDECL_
main( int argc, char** argv )
{
    return sys_xcode( mk_main(argc, argv) );
}
#endif	/* ndef MK_NOMAIN */
