/*
 * CHEST, chess analyst.  For Copyright notice read file "COPYRIGHT".
 *
 * $Source: /home/heiner/ca/chest/RCS/input.h,v $
 * $Id: input.h,v 3.6 1999/10/12 22:50:46 heiner Exp $
 *
 *	read a board and a job
 */

#ifndef CHEST_input_h_INCLUDED
#define CHEST_input_h_INCLUDED

#include "board.h"
#include "epdio.h"

Extern void	inp_start_input (const char* filename);

Extern void	empty_board (Board*);
Extern int	read_board  (Board*, EpdJob*, int dftdep);	/* 0 | depth */

/*
 * Support for alternate input scanning ("epdio").
 */
#define IS_SPACE(c)	(((c) == ' ') || ((c) == '\t'))
#define SKIP_SPACE(p)	while( IS_SPACE(*(p)) ) ++(p)

Extern void	inp_tell_error (const char*);

#endif	/* ndef CHEST_input_h_INCLUDED */
