/*
 * CHEST, chess analyst.  For Copyright notice read file "COPYRIGHT".
 *
 * $Source: /home/heiner/ca/chest/RCS/bsd.h,v $
 * $Id: bsd.h,v 3.5 1999/09/12 21:02:54 heiner Exp $
 *
 *	Imitate a bit of bsd stuff.
 */

#ifndef CHEST_bsd_h_INCLUDED
#define CHEST_bsd_h_INCLUDED

#if BSD

# if defined(__cplusplus)
#  include <memory.h>
# else	/* ndef __cplusplus */
 extern	int	bcmp ();
 extern		bzero ();
 extern		bcopy ();
# endif	/* ndef __cplusplus */

# define mem_eq(x,y,n)	(0 == bcmp((char*)(x),(char*)(y),n))

# define SIGHND_RET_TYPE	int	/* what signal handlers return */
# define SIGHND_RETURN(x)	return x

#else	/* ! BSD */

# if defined(__STDC__)
#  include <string.h>
# else
#  include <memory.h>		/* appears to be portable */
# endif

# define bzero(a,n)	memset((void*)(a), 0, n)
# define bcopy(s,t,n)	memcpy((void*)(t), (const void*)(s), n)
# define mem_eq(x,y,n)	(0 == memcmp((const void*)(x), (const void*)(y), n))

# define SIGHND_RET_TYPE	void	/* what signal handlers return */
# define SIGHND_RETURN(x)	/*empty*/

#endif	/* ! BSD */


#if defined(__STDC__) || USG
# include <stdlib.h>		/* qsort */
#endif
#if BSD
# define Q_sort(arr,nelem,elsiz,cmp)	\
		(void) qsort((char*)(arr), (int)(nelem), (elsiz), cmp)
#else
# define Q_sort(arr,nelem,elsiz,cmp)	\
		qsort((void*)(arr), (size_t)(nelem), (size_t)(elsiz), cmp)
#endif
#define arr_Q_sort(arr,nelem,cmp)	Q_sort(arr,nelem,sizeof(*(arr)),cmp)

#endif	/* ndef CHEST_bsd_h_INCLUDED */
