/*
 * CHEST, chess analyst.  For Copyright notice read file "COPYRIGHT".
 *
 * $Source: /home/heiner/ca/chest/RCS/bastyp.h,v $
 * $Id: bastyp.h,v 3.10 1999/08/07 17:18:28 heiner Exp $
 *
 *	Basic types, including locally configered ones.
 *	Types suitable for a register start with a lower case "r".
 *	Basic definitions ("basdef.h") are included, also.
 */

#ifndef CHEST_bastyp_h_INCLUDED
#define CHEST_bastyp_h_INCLUDED

#include "basdef.h"

/*
 * We want typedefs for signed and unsigned integral types,
 * which can hold 8, 16 and 32 Bits, respectively.
 * Normally, the program "mklcltyp.c" computes the contents of "lcltyp.h".
 * If that really does not work, define NO_LCLTYP=1 to get some guesswork.
 */

#if ! NO_LCLTYP			/* use locally computed types */
# include "lcltyp.h"
#else				/* try to guess portable types */
  typedef signed char	 int8;
  typedef short		 int16;
  typedef long		 int32;

  typedef unsigned char	 uint8;
  typedef unsigned short uint16;
  typedef unsigned long	 uint32;

  typedef int		rint8;
  typedef int		rint16;
  typedef int32		rint32;

  typedef unsigned int	ruint8;
  typedef unsigned int	ruint16;
  typedef uint32	ruint32;

# define Int8       int8
# define Int16      int16
# define Int32      int32

# define Uint8      uint8
# define Uint16     uint16
# define Uint32     uint32
#endif	/* NO_LCLTYP */

typedef int8		 Flag;		/* for memory variables */
typedef int		rFlag;
typedef int		 Bool;		/* for registers and return values */

#endif	/* ndef CHEST_bastyp_h_INCLUDED */
