/*
 * CHEST, chess analyst.  For Copyright notice read file "COPYRIGHT".
 *
 * $Source: /home/heiner/ca/chest/RCS/allchest.c,v $
 * $Id: allchest.c,v 1.3 1999/12/07 00:23:00 heiner Exp $
 *
 *	supervisor, version "all in one" by including C-files
 */

/*
 * During development chest is nomally compiled in parts (modules),
 * which then are linked together into one executable.
 *
 * This file is intended for production versions.  It includes (!)
 * all the C-files (!) and compiles them together in 1 run.
 * This has some advantages:
 * - The need for long makefiles is considerably reduced.
 * - The compiler can optimize better.
 *   We improve this by the manifests Extern & Eximpl, which
 *   cause all functions to be static (local to this big module),
 *   allowing for even more optimization (e.g. inlining).
 *
 * FFS:	Instead of listing the sources alphabetically, we can try
 *	to cluster those which call one another frequently, and thus
 *	improve the locality in the code cache.
 *	Also, inlining might be better if low level modules come first.
 */

#if ! defined(INIT_GET)
# define      INIT_GET	1		/* use "inited.h" */
#endif

#define Extern		static		/* external declaration */
#define Eximpl		static		/* external implementation */

#if HP9000		/* FFS: sometimes does convert BSS into DATA */
# define I0static	/*empty*/
#endif


#if 0			/* alphabetically */

#include "acm.c"
#include "analyse.c"
#include "answer.c"
#include "asw.c"
#include "chest.c"
#include "cnt.c"		/* FFS */
#include "debug.c"
#include "dump.c"
#include "epdio.c"
#include "extern.c"
#include "fac.c"
#include "input.c"
#include "lang.c"
#include "mate2.c"
#include "mgsubr.c"
#include "mlsubr.c"
#include "move.c"
#include "move1gen.c"
#include "move_gen.c"
#include "output.c"
#include "refu.c"
#include "solopt.c"
#include "solution.c"
#include "spana.c"
#include "stats.c"
#include "str.c"
#include "sysdep.c"
#include "timing.c"
#include "trace.c"
#include "version.c"

#else			/* cluster sorted */

#include "version.c"
#include "cnt.c"		/* FFS */
#include "str.c"
#include "stats.c"
#include "extern.c"
#include "sysdep.c"
#include "timing.c"
#include "dump.c"
#include "debug.c"

#include "acm.c"
#include "fac.c"
#include "answer.c"
#include "asw.c"
#include "trace.c"
#include "mate2.c"
#include "spana.c"
#include "mgsubr.c"
#include "mlsubr.c"
#include "move.c"
#include "move1gen.c"
#include "move_gen.c"
#include "analyse.c"

#include "lang.c"
#include "epdio.c"
#include "input.c"

#include "output.c"
#include "refu.c"
#include "solopt.c"
#include "solution.c"

#include "chest.c"

#endif
