/*
 * CHEST, chess analyst.  For Copyright notice read file "COPYRIGHT".
 *
 * $Source: /home/heiner/ca/chest/RCS/acm.h,v $
 * $Id: acm.h,v 3.14 1999/12/04 23:07:17 heiner Exp $
 *
 *	Adaptive chess memory
 */

#ifndef CHEST_acm_h_INCLUDED
#define CHEST_acm_h_INCLUDED

#include "bastyp.h"
#include "timing.h"		/* TimeSecs */
#include "cost.h"		/* AnaCost */

Extern int		f_pppsol;	/* "print" positive partial sols */

/*
 * We use a very simple hashing method, based on a really good 32-Bit
 * hash value computed from the 32+2 Bytes packed board and extra status.
 *
 * All nodes (their # is prime) are allocated statically and directly.
 * Each hash code maps directly to one slot, which is the start of the search.
 */
#ifndef  ACM_DYN
# define ACM_DYN	0	/* CF: whether allocate dynamically */
#endif

#if ACM_DYN
  Extern long		f_megs_want;	/* -1 == default */
#endif

typedef uint32		AcmHash;
typedef struct AcmNode	AcmNode;

struct AcmNode
{
    AcmHash	  mn_hash;	/* hash code over mn_board [+ mn_xboard] */
    uint32	  mn_board[64/8];
    uint16	  mn_xboard;	/* castling + ep [ + colour to move ] */
    uint8	  mn_info;	/* known predicate of board */
    uint8	  mn_refcnt;	/* dangling pointers to this */
};

#define ACM_INFO(dep,res)	((uint8)(((dep)<<1) + (res)))
#define ACM_IDEP(inf)		USHR(inf, 1)
#define ACM_IRES(inf)		((inf) & 01)

/*
 * Exported functions:
 */

Extern void	acm_init (void);	/* initialize module, clear stats */
Extern Bool	acm_start (int tomove, int jobtype);	/* succ; cond. clear */
Extern void	acm_stats (TimeSecs secs);
Extern void	acm_1show (const AcmNode* np, Bool all);

/*
 * Both, "acm_search" and "acm_snoop" must not be invoked,
 * when "acm_start" did fail.
 */
Extern AcmNode*	acm_search (const Board*);
Extern AcmNode*	acm_snoop  (const Board*, const Move*);

#define		acm_attach(acmp)	((acmp)->mn_refcnt += 1)
Extern void	acm_release (AcmNode*);
Extern void	acm_note    (AcmNode*, uint8 info, AnaCost cost);
Extern void	acm_used    (const AcmNode*, uint8 info);

Extern double	acm_speed   (void);
#if ! PROD_LEV
# include "stats.h"
Extern Counter	acm_cnt_in  (void);
Extern Counter	acm_cnt_out (void);
#endif

#endif	/* ndef CHEST_acm_h_INCLUDED */
