
#ifndef _nov5xxreg_h_
#define _nov5xxreg_h_

/* System Control */
#define OV511_SYS_RST		0x50	/* reset */
	#define RST_FLUSH	0x01
	#define RST_SCCB	0x02
	#define RST_FIFO	0x04
	#define RST_OMNICE	0x08
	#define RST_DRAM	0x10
	#define RST_CAM		0x20
	#define RST_OV511P	0x40
	#define RST_ALL		RST_FLUSH | RST_SCCB | RST_FIFO | \
						RST_OMNICE | RST_DRAM | RST_CAM | RST_OV511P

#define OV511_SYS_CLKDIV	0x51	/* clock divisor */
#define OV511_SYS_SNAP		0x52	/* hardware snapshot */
#define OV511_SYS_EN_SYS	0x53	/* software system initialization */
#define OV511_SYS_PWCK		0x54	/* switching power clock output */
#define OV511_SYS_LEDCTL	0x55	/* LED control */
#define OV511_SYS_USR		0x5E	/* user defined read/write register */
#define OV511_SYS_CID		0x5F	/* custom id */

/* camera interface */
#define OV511_CAM_DLYM		0x10	/* delay modes of video input signals */
#define OV511_CAM_PEM		0x11	/* edge modes of PCLK */
#define OV511_CAM_PXCNT		0x12	/* clamped pixel number */
#define OV511_CAM_LNCNT		0x13	/* clamped line number */
#define OV511_CAM_PXDV		0x14	/* pixel divisor */
#define OV511_CAM_LNDV		0x15	/* line divisor */
#define OV511_CAM_M400		0x16	/* 8 or 16 bit data input */
#define OV511_CAM_LSTR		0x17	/* reserved lines for down sampling */
#define OV511_CAM_M420		0x18	/* YUV format/Y channel low pass filter */
	#define M420_YFIR	0x1	/* Y channel low pass filter */
	#define M420_YUV	0x2	/* YUV format clear:YUV 4:2:2 set:YUV 4:2:0*/
/* camera/snapshot */
#define OV511_CAM_SPDLY		0x19	/* captured frame */
#define OV511_CAM_SNPX		0x1A	/* clamped pixel number */
#define OV511_CAM_SNLN		0x1B	/* clamped line number */
#define OV511_CAM_SNPD		0x1C	/* pixel divisor */
#define OV511_CAM_SNLD		0x1D	/* line divisor */
#define OV511_CAM_SN400		0x1E	/* 8 or 16 bit data input */
#define OV511_CAM_SN420		0x1F	/* */
	#define SN420_YFIR	  0x1	/* Y channel low pass filter */
	#define SN420_YUV	  0x2	/* YUV format clear:YUV 4:2:2 set:YUV 4:2:0 */
	#define SN420_SNALSTR 0x4	/* reserved lines for down sampling */

/* DRAM interface */
#define OV511_DRAM_ENFC		0x20	/* image flow control */
#define OV511_DRAM_ARCP		0x21	/* auto read cycle predictor */
#define OV511_DRAM_MRC		0x22	/* manual read cycle insertion */
#define OV511_DRAM_RFC		0x23	/* refresh counter */

/* ISO FIFO */
#define OV511_FIFO_PKSZ		0x30	/* FIFO packet size */
#define OV511_FIFO_PKFMT	0x31	/* FIFO packet format */
	#define FMT_ENCE	0x1			/* compressed data non-zero insertion */
	#define FMT_ENPKNO	0x2			/* packet number insertion */
	#define FMT_NZPK	0x8			/* zero packet inserted after EOF */

/* SCCB */
#define OV511_SCCB_CTRL		0x40	/* status(r) and control(w) of SCCB bus */
	#define SCCBR_IDLE	0x1			/* SCCB bus idle flag */
	#define SCCBR_NOACK	0x2			/* no acknowledge on SCCB bus */
	#define SCCBR_TMOUT	0x4			/* time out flag for SCCB bus */
	#define SCCBW_START	0x1			/* launches a new SCCB bus cycle */
	#define SCCBW_TYPEW	0x2			/* 2 or 3 byte write cycle, */
	#define SCCBW_TYPER	0x4			/* 2 byte read cycle */
	#define SCCBW_ABORT	0x10		/* abort SCCB bus cycle */
#define OV511_SCCB_SID		0x41	/* SCCB slave ID for 3 or 2 byte writes */
#define OV511_SCCB_SWA		0x42	/* sub address for 3 byte write cycle */
#define OV511_SCCB_SMA		0x43	/* sub address for 2 byte write cycle */
#define OV511_SCCB_SRA		0x44	/* slave ID for 2 byte read cycles */
#define OV511_SCCB_SIO0		0x45	/* SCCB read/write data port */
#define OV511_SCCB_PSC		0x46	/* SCCB clock prescaler */
#define OV511_SCCB_TMO		0x47	/* time out counter */
#define OV511_SCCB_SPA		0x48	/* sub address for snapshot */
#define OV511_SCCB_SPD		0x49	/* data port for snapshot */

/* OmniCE */
#define OV511_OMNI_PRH_Y	0x70	/* prediction range horizontal, Y channel */
#define OV511_OMNI_PRH_UV	0x71	/* prediction range horizontal, UV channel */
#define OV511_OMNI_PRV_Y	0x72	/* prediction range vertical, Y channel */
#define OV511_OMNI_PRV_UV	0x73	/* prediction range vertical, UV channel */
#define OV511_OMNI_QTH_Y	0x74	/* quantization threshold horizontal, Y channel */
#define OV511_OMNI_QTH_UV	0x75	/* quantization threshold horizontal, UV channel */
#define OV511_OMNI_QTV_Y	0x76	/* quantization threshold vertical, Y channel */
#define OV511_OMNI_QTV_UV	0x77	/* quantization threshold vertical, UV channel */
#define OV511_OMNI_CTRL		0x78	/* dis-/enable OmniCE, Y/UV channel */
#define OV511_OMNI_LTEN		0x79	/* dis-/enable lookup table for Y/UV channel */
#define OV511_OMNI_LT_Y		0x80	/* start of lookup table for Y channel */
#define OV511_OMNI_LT_UV	0xA0	/* start of lookup table for UV channel */


#endif /* _nov5xxreg_h_ */
