/* All Rights reserved */

#include <AppKit/AppKit.h>

#include "ToolSelector.h"

#include "AppController.h"
#include "Constants.h"
#include "Functions.h"

#define VMARGIN 6

@implementation ToolSelector

- (id) initWithFrame: (NSRect) frameRect
{
	int numberTools = 3;	/* The default tools (cdrecord, cdparanoia, mkisofs) */
	NSTextField *text;
	NSPopUpButton *popUp;

	self = [super initWithFrame: frameRect];
	if (self) {
		int i;
		int height;
		NSRect frame;

		additionalPopUps = [NSMutableArray new];
		fileTypes = RETAIN([[AppController appController] registeredFileTypes]);
		numberTools += [fileTypes count];
		
		height = numberTools * (TextFieldHeight + VMARGIN);
		frame = NSMakeRect(0, 0, frameRect.size.width, height);

		toolView = [[NSView alloc] initWithFrame: frame];

		MAKE_LABEL(text, NSMakeRect(10, height - (TextFieldHeight+VMARGIN)+VMARGIN/2, 130, TextFieldHeight),
					_(@"Common.Burn"), 'l', YES, toolView);
		burnToolPopUp = [[NSPopUpButton alloc] initWithFrame: NSZeroRect pullsDown: NO];
		[burnToolPopUp setFrame: NSMakeRect(150, height - (TextFieldHeight+VMARGIN)+VMARGIN/2, 150, 20)];
		[toolView addSubview: burnToolPopUp];

		MAKE_LABEL(text, NSMakeRect(10, height - 2*(TextFieldHeight+VMARGIN)+VMARGIN/2, 130, TextFieldHeight),
					_(@"ToolSelector.createISO"), 'l', YES, toolView);
		isoToolPopUp = [[NSPopUpButton alloc] initWithFrame: NSZeroRect pullsDown: NO];
		[isoToolPopUp setFrame: NSMakeRect(150, height - 2*(TextFieldHeight+VMARGIN)+VMARGIN/2, 150, 20)];
		[toolView addSubview: isoToolPopUp];

		MAKE_LABEL(text, NSMakeRect(10, height - 3*(TextFieldHeight+VMARGIN)+VMARGIN/2, 130, TextFieldHeight),
					_(@"ToolSelector.grabAudio"), 'l', YES, toolView);
		ripToolPopUp = [[NSPopUpButton alloc] initWithFrame: NSZeroRect pullsDown: NO];
		[ripToolPopUp setFrame: NSMakeRect(150, height - 3*(TextFieldHeight+VMARGIN)+VMARGIN/2, 150, 20)];
		[toolView addSubview: ripToolPopUp];

		for (i = 0; i < numberTools - 3; i++) {
			NSString *lblText = [NSString stringWithFormat: _(@"ToolSelector.convertAudio"), [fileTypes objectAtIndex: i]];
			MAKE_LABEL(text, NSMakeRect(10, height - (i+4)*(TextFieldHeight+VMARGIN)+VMARGIN/2, 130, TextFieldHeight),
					lblText, 'l', YES, toolView);
			popUp = [[NSPopUpButton alloc] initWithFrame: NSZeroRect pullsDown: NO];
			[popUp setFrame: NSMakeRect(150, height - (i+4)*(TextFieldHeight+VMARGIN)+VMARGIN/2, 150, 20)];
			[toolView addSubview: popUp];
			[additionalPopUps addObject: popUp];
			[popUp release];
		}

		frame = NSMakeRect(0,0,frameRect.size.width,frameRect.size.height);
		scrollView = [[NSScrollView alloc] initWithFrame: frame];
		[scrollView setHasHorizontalScroller: NO];
		[scrollView setHasVerticalScroller: YES];
		[scrollView setDocumentView: toolView];
		[scrollView setBorderType: NSGrooveBorder];
		[scrollView setAutoresizingMask: NSViewWidthSizable | NSViewHeightSizable];

		[self addSubview: scrollView];
	}
	return self;
}

- (void) dealloc
{
	[fileTypes release];
	[additionalPopUps release];
	[burnToolPopUp release];
	[isoToolPopUp release];
	[ripToolPopUp release];
	[toolView release];
	[scrollView release];
	[super dealloc];
}

- (NSPopUpButton *) burnToolPopUp
{
	return burnToolPopUp;
}

- (NSPopUpButton *) isoToolPopUp
{
	return isoToolPopUp;
}

- (NSPopUpButton *) ripToolPopUp
{
	return ripToolPopUp;
}

- (void) getAvailableTools
{
	int i, j;
	for (i = 0; i < [fileTypes count]; i++) {
		NSString *temp;
		NSString *fileType = [fileTypes objectAtIndex: i];
		NSPopUpButton *popUp = [additionalPopUps objectAtIndex: i];
		NSArray *bundles = [[AppController appController] bundlesForFileType: fileType];

		for (j = 0; j < [bundles count]; j++) {
			id tool = [bundles objectAtIndex: j];
			[popUp addItemWithTitle: [(id<BurnTool>)tool name]];
		}

		if ([popUp numberOfItems] == 0) {
			[popUp addItemWithTitle: _(@"Common.empty")];
		}

		temp = [[[NSUserDefaults standardUserDefaults] objectForKey: @"SelectedTools"] objectForKey: fileType];
		if (temp && [temp length]) {
			[popUp selectItemWithTitle: temp];
		} else {
			[popUp selectItemAtIndex: 0];
		}
	}
}

- (void) saveChanges
{
	int i;
	NSMutableDictionary *selectedTools = [[NSUserDefaults standardUserDefaults]
													objectForKey: @"SelectedTools"];
	for (i = 0; i < [fileTypes count]; i++) {
		NSString *fileType = [fileTypes objectAtIndex: i];
		NSPopUpButton *popUp = [additionalPopUps objectAtIndex: i];
		[selectedTools setObject: [popUp titleOfSelectedItem] forKey: fileType];
	}
}

- (void) setTarget: (id)target action: (SEL)action
{
	int i;
	for (i = 0; i < [additionalPopUps count]; i++) {
		NSPopUpButton *popUp = [additionalPopUps objectAtIndex: i];
		[popUp setTarget: target];
		[popUp setAction: action];
	}
}


@end
