/* vim: set ft=objc ts=4 et sw=4 nowrap: */
/*
 *	ParametersWindow.m
 *
 *	Copyright (c) 2002
 *
 *	Author: Andreas Heppel <aheppel@web.de>
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "ParametersWindow.h"

#include "Constants.h"

@implementation ParametersWindow

//
//
//
- (void) layoutWindow
{
	NSScrollView *scrollView;
	NSButtonCell *cell;
	NSButton *button;

	box = [[NSBox alloc] initWithFrame: NSMakeRect(8,60,355,250)];
	[box setTitlePosition: NSAtTop];
	[box setBorderType: NSGrooveBorder];

	[[self contentView] addSubview: box];	

	cell = [[NSButtonCell alloc] init];
	AUTORELEASE(cell);
	[cell setButtonType: NSPushOnPushOffButton];
	[cell setImagePosition: NSImageAbove];

	matrix = [[NSMatrix alloc] initWithFrame: NSMakeRect(8,315,355,86)
				 mode: NSRadioModeMatrix
				 prototype: cell
				 numberOfRows: 1
				 numberOfColumns: 0];
	[matrix setTarget: [self windowController]];
	[matrix setCellSize: NSMakeSize(64,64)];
	[matrix setAction: @selector(handleCellAction:)];

	scrollView = [[NSScrollView alloc] initWithFrame:NSMakeRect(8,315,355,86)];

	[scrollView setHasHorizontalScroller: YES];
	[scrollView setHasVerticalScroller: NO];
	[scrollView setDocumentView: matrix];	
	[scrollView setBorderType: NSBezelBorder];
	[[self contentView] addSubview: scrollView];
	RELEASE(scrollView);

	button = [[NSButton alloc] initWithFrame: NSMakeRect(152,10,80,ButtonHeight)];
	[button setAutoresizingMask: NSViewMinXMargin | NSViewMaxYMargin];
	[button setButtonType: NSMomentaryPushButton];
	[button setTitle: _(@"Common.cancel")];
	[button setTarget: [self windowController]];
	[button setAction: @selector(cancelClicked:)];
	[button setFont: [NSFont systemFontOfSize: 0]];
	[[self contentView] addSubview: button];
    [button release];

	button = [[NSButton alloc] initWithFrame: NSMakeRect(242,10,120,ButtonHeight)];
	[button setAutoresizingMask: NSViewMinXMargin | NSViewMaxYMargin];
	[button setButtonType: NSMomentaryPushButton];
	[button setTitle: _(@"Common.execute")];
	[button setTarget: [self windowController]];
	[button setAction: @selector(okClicked:)];
	[button setFont: [NSFont systemFontOfSize: 0]];
    [button setImagePosition: NSImageRight]; 
    [button setImage: [NSImage imageNamed: @"common_ret"]];
    [button setAlternateImage: [NSImage imageNamed: @"common_retH"]];
	[[self contentView] addSubview: button];
    [self setDefaultButtonCell: [button cell]];
    [button release];
}


//
//
//
- (void) dealloc
{
	RELEASE(box);
	RELEASE(matrix);

	[super dealloc];
}


//
// access/mutation methods
//

- (NSMatrix *) matrix
{
	return matrix;
}

- (NSBox *) box
{
	return box;
}

@end
