/* vim: set ft=objc ts=4 nowrap: */
/*
 *  MediaInspector.m
 *
 *  Copyright (c) 2002
 *  
 *  Author: Andreas Heppel <aheppel@web.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <Foundation/Foundation.h>
#include <AppKit/AppKit.h>

#include "AppController.h"
#include "MediaInspector.h"
#include "Functions.h"
#include "Constants.h"

#include <Burn/ExternalTools.h>


@implementation MediaInspector


- (id)init
{	
	self = [super init];
  
	if(self) {
		// load the gui...
		if (![NSBundle loadNibNamed: @"MediaInspector" owner: self]) {
			logToConsole(MessageStatusError, [NSString stringWithFormat:
								_(@"Common.loadNibFail"), @"MediaInspector"]);
			[self dealloc];
			return nil;
		} else {
			// initialize all member variables...
    		fileIcon = [NSImage imageNamed: @"iconDelete.tiff"];
			[typeIcon setImage: fileIcon];
		}
	}
	return self;
}

- (void)loadMedia: (id)sender
{
	NSString *burnerName;
	id<Burner> burner = nil;
	NSDictionary *params = nil;
	NSDictionary *info = nil;

	fileIcon = [NSImage imageNamed: @"iconDelete.tiff"];
	[typeField setStringValue: _(@"Common.pleaseWait")];
	[vendorField setStringValue: @"n/a"];
	[capField setStringValue: @"n/a"];
	[speedField setStringValue: @"n/a"];
	[emptyField setStringValue: @"n/a"];
	[remcapField setStringValue: @"n/a"];
	[sessionsField setStringValue: @"n/a"];
	[appField setStringValue: @"n/a"];

	burnerName = [[[NSUserDefaults standardUserDefaults] objectForKey: @"SelectedTools"]
							 objectForKey: @"BurnSW"];
	burner = [[AppController appController] bundleForKey: burnerName];
	if (burner) {
		params = [[NSUserDefaults standardUserDefaults] dictionaryRepresentation];
		RETAIN(params);
		info = [burner mediaInformation: params];
		RELEASE(params);
	}

	if (info) {
		[typeField setStringValue: [info objectForKey: @"type"]];
		if ([[info objectForKey: @"type"] isEqual: @"CD-R"])
			fileIcon = [NSImage imageNamed: @"iconCDR.tiff"];
		else if ([[info objectForKey: @"type"] isEqual: @"CD-RW"])
			fileIcon = [NSImage imageNamed: @"iconCDRW.tiff"];
		else
			fileIcon = [NSImage imageNamed: @"iconCD.tiff"];

		[vendorField setStringValue: [info objectForKey: @"vendor"]];
		[capField setStringValue: [info objectForKey: @"capacity"]];
		[speedField setStringValue: [info objectForKey: @"speed"]];
		[emptyField setStringValue: [info objectForKey: @"empty"]];
		[remcapField setStringValue: [info objectForKey: @"remCapacity"]];
		[sessionsField setStringValue: [info objectForKey: @"sessions"]];
		[appField setStringValue: [info objectForKey: @"appendable"]];
	} else {
		[typeField setStringValue: _(@"Common.unknown")];
	}

	[typeIcon setImage: fileIcon];
}

- (void)deactivate: (NSView *)view
{
	/* This gives the view back to its original parent */
	[(NSWindow*)window setContentView: view];
}

- (id) window
{
	return window;
}

- (NSString *)inspectorName
{
	return _(@"Common.media");
}

- (NSString *)winname
{
	return [window title];
}

@end
