/* vim: set ft=objc ts=4 nowrap: */
/*
 *  AudioCDInspector.m
 *
 *  Copyright (c) 2003
 *
 *  Author: Andreas Heppel <aheppel@web.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <AppKit/AppKit.h>
#include "AudioCDInspector.h"
#include "Functions.h"
#include "Constants.h"

@implementation AudioCDInspector


- (id)init
{
	self = [super init];
	
	if(self) {
		// load the gui...
		if (![NSBundle loadNibNamed: @"AudioCDInspector" owner: self]) {
			logToConsole(MessageStatusError, [NSString stringWithFormat:
								_(@"Common.loadNibFail"), @"AudioCDInspector"]);
			[self dealloc];
			return nil;
		} else {
			// initialize all member variables...
    		fileIcon = [NSImage imageNamed: @"iconDelete.tiff"];
			[cdIcon setImage: fileIcon];

			[[NSNotificationCenter defaultCenter] addObserver: self
			   selector: @selector(audioCDChanged:)
			   name: AudioCDMessage
			   object: nil];
		}
	}		
	return self;
}

- (void)dealloc
{

	[[NSNotificationCenter defaultCenter] removeObserver: self
							name: AudioCDMessage
							object: nil];

	[allCDs release];
	[super dealloc];
}


- (void)deactivate: (NSView *)view
{
	/* This gives the view back to its original parent */
	[(NSWindow*)window setContentView: view];
}

- (NSString *)inspectorName
{
	return _(@"AudioCDInspector.name");
}

- (NSString *)winname
{
	return [window title];
}

- (id) window
{
	return window;
}

- (void) audioCDChanged: (id)notification
{
	[allCDs release];

	if ([notification userInfo])
		allCDs = [[[notification userInfo] objectForKey: @"cds"] retain];
	else
		allCDs = nil;

	if ([allCDs count]) {
		fileIcon = [NSImage imageNamed: @"iconAudioCD.tiff"];
		[descField setStringValue: [NSString stringWithFormat: _(@"AudioCDInspector.numCDs"), [allCDs count]]];
	} else {
		fileIcon = [NSImage imageNamed: @"iconDelete.tiff"];
		[descField setStringValue: _(@"AudioCDInspector.noCD")];
	}
	[cdIcon setImage: fileIcon];
	[cdTable reloadData];
}

//
// Data Source methods
//
- (int) numberOfRowsInTableView: (NSTableView *)tableView
{
	if (allCDs)
		return [allCDs count];

	return 0;
}


//
//
//
- (id) tableView: (NSTableView *) tableView
 objectValueForTableColumn: (NSTableColumn *) tableColumn 
		       row: (int) rowIndex
{
	NSDictionary *aCD;

	aCD = [allCDs objectAtIndex: rowIndex];

	if ([[tableColumn identifier] isEqual: @"colArtist"]) {
		return [aCD objectForKey: @"artist"];
	} else if ([[tableColumn identifier] isEqual: @"colTitle"]) {
		return [aCD objectForKey: @"title"];
	} else {
		return [aCD objectForKey: @"cddbId"];
	}
}

@end
