/* vim: set ft=objc ts=4 nowrap: */
/*
 *  ExtendedOutlineCell.h
 *
 *  Copyright (c) 2002
 *
 *  Author: Andreas Heppel <aheppel@web.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "ExtendedOutlineCell.h"
#include "Track.h"



@implementation ExtendedOutlineCell


- (void) dealloc
{
	RELEASE(collapsedImage);
	RELEASE(expandedImage);

	[super dealloc];
}


- (NSImage *) collapsedImage
{
	return collapsedImage;
}

- (NSImage *) expandedImage
{
	if (!expandedImage)
		return collapsedImage;

	return expandedImage;
}

- (void) setCollapsedImage: (NSImage *)theImage
{
	if (theImage) {
		ASSIGN(collapsedImage, theImage);
    } else {
		RELEASE(collapsedImage);
		collapsedImage = nil;
    }
}

- (void) setExpandedImage: (NSImage *)theImage
{
	if (theImage) {
		ASSIGN(expandedImage, theImage);
    } else {
		RELEASE(expandedImage);
		expandedImage = nil;
    }
}

@end
