/* vim: set ft=objc ts=4 nowrap: */
/* All Rights reserved */

#ifndef DRIVERSPREFS_H_INC
#define DRIVERSPREFS_H_INC

#include <AppKit/AppKit.h>

#include <Burn/PreferencesModule.h>
#include <Burn/ExternalTools.h>




@interface DriversPrefs : NSObject <PreferencesModule>

{
	id driversPopUp;
	id driversTable;
	id window;
	id view;

	NSMutableDictionary *availableDrives;
	NSMutableDictionary *availablePrograms;

	/* User defaults */
	NSMutableDictionary *assignedDrivers;
}

- (id) init;

- (void) burnSWChanged: (id)sender;
- (void) driverChanged: (id)sender;

@end


#endif
