/* vim: set ft=objc ts=4 nowrap: */
/*
**  ConsoleWindow.m
**
**  Copyright (c) 2003
**
**  Author: Andreas Heppel <aheppel@web.de>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "ConsoleWindow.h"

#include "Constants.h"

@implementation ConsoleWindow

//
//
//
- (void) dealloc
{
	RELEASE(outputWindow);
  RELEASE(scrollView);
  
  [super dealloc];
}


//
//
//
- (void) layoutWindow
{
	NSSize contentSize;

  scrollView = [[NSScrollView alloc] initWithFrame: NSMakeRect(0,0,500,250)];
  
  [scrollView setHasHorizontalScroller: NO];
  [scrollView setHasVerticalScroller: YES];
  [scrollView setBorderType: NSBezelBorder];
  [scrollView setAutoresizingMask: (NSViewWidthSizable|NSViewHeightSizable)];
	contentSize = [scrollView contentSize];

	outputWindow = [[NSTextView alloc] initWithFrame: NSMakeRect(0, 0,
    										contentSize.width, contentSize.height)];
	[outputWindow setEditable: YES];
	[outputWindow setSelectable: YES];
	[outputWindow setRichText: YES];
	[outputWindow setFont: [NSFont systemFontOfSize: 12]];
	[outputWindow setMinSize: NSMakeSize(0.0, contentSize.height)];
	[outputWindow setMaxSize: NSMakeSize(1e7, 1e7)];
	[outputWindow setVerticallyResizable: YES];
	[outputWindow setHorizontallyResizable: NO];
	[outputWindow setAutoresizingMask: NSViewWidthSizable | NSViewHeightSizable];

	[[outputWindow textContainer] setContainerSize: NSMakeSize(contentSize.width, 1e7)];
	[[outputWindow textContainer] setWidthTracksTextView: YES];

	[scrollView setDocumentView: outputWindow];

  [self setContentView: scrollView];
}


//
// access/mutation methods
//
- (NSTextView *)outputWindow
{
	return outputWindow;
}


@end
