/* vim: set ft=objc ts=4 nowrap: */
/*
 *  BurnProgress.h
 *
 *  Copyright (c) 2002
 *
 *  Author: Andreas Heppel <aheppel@web.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef BURNPROGRESS_H_INC
#define BURNPROGRESS_H_INC

#include <AppKit/AppKit.h>

/**
 * Indices for the labels and progress indicators in Progress.
 */
typedef enum {
	progressEntire,
	progressTrack,
	progressBuffer
} EnumProgressBars;


@interface BurnProgress : NSWindow
{
	NSButton *abort;
	NSButton *details;
	NSBox *box;
	NSTextField *entireLabel;
	NSTextField *trackLabel;
	NSTextField *bufferLabel;

	NSProgressIndicator *entireProgress;
	NSProgressIndicator *trackProgress;
	NSProgressIndicator *bufferIndicator;

	id parent;
}

- (void) layoutWindow;

- (IBAction) showConsole: (id)sender;

//
// access methods
//
//- (NSBox *) box;
- (NSProgressIndicator *)entireProgress;
- (NSProgressIndicator *)trackProgress;
- (NSProgressIndicator *)bufferIndicator;

- (void) enableAbort: (BOOL) enable;
- (void) setAbortText: (NSString *)newText;
- (void) setBufferLabel: (NSString *)newText;
- (void) setEntireLabel: (NSString *)newText;
- (void) setTrackLabel: (NSString *)newText;
- (void) initProgressBar: (EnumProgressBars)which From: (double)from To: (double)to;
- (void) setProgressBar: (EnumProgressBars)which toValue: (double)value;
- (void) resetProgressBar: (EnumProgressBars)which;
- (void) setProgressBarToMax: (EnumProgressBars)which;

@end


#endif
