/* vim: set ft=objc ts=4 et sw=4 nowrap: */
/* All Rights reserved */

#include <AppKit/AppKit.h>
#include "MkIsoFsParametersView.h"
#include "Functions.h"
#include "Constants.h"

#ifdef _
#undef _
#endif

#define _(X) \
	[[NSBundle bundleForClass: [self class]] localizedStringForKey:(X) value:@"" table:nil]

static MkIsoFsParametersView *singleInstance = nil;


@implementation MkIsoFsParametersView

- (id) init
{
	return [self initWithNibName: @"Parameters"];
}

- (id) initWithNibName: (NSString *) nibName
{
	if (singleInstance) {
		[self dealloc];
	} else {
		self = [super init];

		if (![NSBundle loadNibNamed: nibName owner: self]) {
			NSLog (@"MkIsoFs: Could not load nib \"%@\".", nibName);
			[self dealloc];
		} else {
			view = [window contentView];
			[view retain];

			// We get our defaults for this panel
			[self initializeFromDefaults];

			singleInstance = self;
		}
	}

	return singleInstance;
}


- (void) dealloc
{
	singleInstance = nil;
	RELEASE(view);

	[super dealloc];
}



//
// access methods
//

- (NSImage *) image
{
	NSBundle *aBundle;
	
	aBundle = [NSBundle bundleForClass: [self class]];
	
	return AUTORELEASE([[NSImage alloc] initWithContentsOfFile:
					[aBundle pathForResource: @"iconMkIsoFs" ofType: @"tiff"]]);
}

- (NSString *) title
{
	return @"mkisofs";
}

- (NSView *) view
{
	return view;
}

- (BOOL) hasChangesPending
{
	return YES;
}


//
//
//
- (void) initializeFromDefaults
{
	NSMutableDictionary *parameters =
			[[NSUserDefaults standardUserDefaults] objectForKey: @"MkIsofsParameters"];

	if ([parameters objectForKey: @"RRExtensions"]) {
		[rockrCheckBox setState: [[parameters objectForKey: @"RRExtensions"] intValue]];
    } else {
		[rockrCheckBox setState: 1];
	}

	if ([parameters objectForKey: @"JolietExtensions"]) {
		[jolietCheckBox setState: [[parameters objectForKey: @"JolietExtensions"] intValue]];
    }

	if ([parameters objectForKey: @"FollowSymlinks"]) {
		[symlinkCheckBox setState: [[parameters objectForKey: @"FollowSymlinks"] intValue]];
    }

	if ([parameters objectForKey: @"NoBackupFiles"]) {
		[nobakCheckBox setState: [[parameters objectForKey: @"NoBackupFiles"] intValue]];
    }

	if ([parameters objectForKey: @"FullISOFilenames"]) {
		[longNameCheckBox setState: [[parameters objectForKey: @"FullISOFilenames"] intValue]];
    }

	if ([parameters objectForKey: @"DotStartAllowed"]) {
		[dotStartCheckBox setState: [[parameters objectForKey: @"DotStartAllowed"] intValue]];
    }

	if ([parameters objectForKey: @"IsoLevel"]) {
		[isoLevelPopUp selectItemWithTitle: [parameters objectForKey: @"IsoLevel"]];
	}
}


/*
 * saveChanges checks the values for the programs and displays an alert panel
 * if the program is not defined or not executable.
 */
- (void) saveChanges
{
	NSMutableDictionary *parameters =
			[[NSUserDefaults standardUserDefaults] objectForKey: @"MkIsofsParameters"];

	[parameters setObject: [NSNumber numberWithInt: [rockrCheckBox state]]
					forKey: @"RRExtensions"];

	[parameters setObject: [NSNumber numberWithInt: [jolietCheckBox state]]
					forKey: @"JolietExtensions"];

	[parameters setObject: [NSNumber numberWithInt: [symlinkCheckBox state]]
					forKey: @"FollowSymlinks"];

	[parameters setObject: [NSNumber numberWithInt: [nobakCheckBox state]]
					forKey: @"NoBackupFiles"];

	[parameters setObject: [NSNumber numberWithInt: [longNameCheckBox state]]
					forKey: @"FullISOFilenames"];

	[parameters setObject: [NSNumber numberWithInt: [dotStartCheckBox state]]
					forKey: @"DotStartAllowed"];

	[parameters setObject: [isoLevelPopUp titleOfSelectedItem] forKey: @"IsoLevel"];
	[[NSUserDefaults standardUserDefaults] synchronize];
}


//
// class methods
//
+ (id) singleInstance
{
	if (!singleInstance) {
		singleInstance = [[MkIsoFsParametersView alloc] initWithNibName: @"Parameters"];
	}

	return singleInstance;
}


@end
