/* vim: set ft=objc ts=4 et sw=4 nowrap: */
/* All Rights reserved */

#include <AppKit/AppKit.h>
#include "CDparanoiaParametersView.h"
#include "Functions.h"
#include "Constants.h"

#ifdef _
#undef _
#endif

#define _(X) \
	[[NSBundle bundleForClass: [self class]] localizedStringForKey:(X) value:@"" table:nil]

static CDparanoiaParametersView *singleInstance = nil;


@implementation CDparanoiaParametersView

- (id) init
{
	return [self initWithNibName: @"Parameters"];
}

- (id) initWithNibName: (NSString *) nibName
{
	if (singleInstance) {
		[self dealloc];
	} else {
		self = [super init];

		if (![NSBundle loadNibNamed: nibName owner: self]) {
			NSLog (@"Could not load nib \"%@\".", nibName);
			[self dealloc];
		} else {
			view = [window contentView];
			[view retain];

			// We get our defaults for this panel
			[self initializeFromDefaults];

			singleInstance = self;
		}
	}

	return singleInstance;
}


- (void) dealloc
{
	singleInstance = nil;
	RELEASE(view);

	[super dealloc];
}


//
// access methods
//

- (NSImage *) image
{
	NSBundle *aBundle;
	
	aBundle = [NSBundle bundleForClass: [self class]];
	
	return AUTORELEASE([[NSImage alloc] initWithContentsOfFile:
					[aBundle pathForResource: @"iconCDparanoia" ofType: @"tiff"]]);
}

- (NSString *) title
{
	return _(@"cdparanoia");
}

- (NSView *) view
{
	return view;
}

- (BOOL) hasChangesPending
{
	return YES;
}


//
//
//
- (void) initializeFromDefaults
{
	NSMutableDictionary *parameters =
			[[NSUserDefaults standardUserDefaults] objectForKey: @"CDparanoiaParameters"];

	if ([parameters objectForKey: @"DisableParanoia"] )
    {
		[disParanoiaCheckBox setState: [[parameters objectForKey: @"DisableParanoia"] intValue] ];
    }

	if ([parameters objectForKey: @"DisableExtraParanoia"] )
    {
		[disXParanoiaCheckBox setState: [[parameters objectForKey: @"DisableExtraParanoia"] intValue] ];
    }

	if ([parameters objectForKey: @"DisableScratchRepair"] )
    {
		[disRepairCheckBox setState: [[parameters objectForKey: @"DisableScratchRepair"] intValue] ];
    }
}


/**
 * <p>Checks the values for the programs and displays an alert panel if the
 * backend program is not defined or not executable.</p>
 */
- (void) saveChanges
{
	NSMutableDictionary *parameters =
			[[NSUserDefaults standardUserDefaults] objectForKey: @"CDparanoiaParameters"];

	[parameters setObject: [NSNumber numberWithInt: [disParanoiaCheckBox state]]
					forKey: @"DisableParanoia"];

	[parameters setObject: [NSNumber numberWithInt: [disXParanoiaCheckBox state]]
					forKey: @"DisableExtraParanoia"];

	[parameters setObject: [NSNumber numberWithInt: [disRepairCheckBox state]]
					forKey: @"DisableScratchRepair"];
	[[NSUserDefaults standardUserDefaults] synchronize];
}


//
// class methods
//
+ (id) singleInstance
{
	if (!singleInstance) {
		singleInstance = [[CDparanoiaParametersView alloc] initWithNibName: @"Parameters"];
	}

	return singleInstance;
}


@end
