/* vim: set ft=objc ts=4 nowrap: */
/* 
 * AppController.h created by phr on 2000-08-27 11:38:59 +0000
 *
 * GNUstep Application Controller
 *
 * Created with ProjectCenter - http://www.gnustep.org
 *
 * $Id: AppController.h,v 1.33 2005/03/25 16:37:27 aheppel Exp $
 */

#ifndef APPCONTROLLER_H_INC
#define APPCONTROLLER_H_INC

#include <AppKit/AppKit.h>

#include <Burn/ExternalTools.h>

@class InspectorsWin;

@interface AppController : NSObject
{
	NSMutableDictionary *externalTools;
	NSMutableDictionary *audioConverters;

	NSString *currentWorkingPath;
	NSMutableArray *allProjectWindows;
	id lastProjectWindowOnTop;

	BOOL burnerInUse;
	NSLock *burnerLock;
}

+ (AppController *)appController;

- (id)init;
- (void)dealloc;

//
// delegate methods
//
- (void)applicationWillFinishLaunching: (NSNotification *)not;
- (void)applicationDidFinishLaunching: (NSNotification *)not;
- (BOOL)applicationShouldTerminate: (id)sender;

//
// action methods
//
- (void)showPrefPanel: (id)sender;
- (void)showConsole: (id)sender;
- (void)showInspector: (id)sender;
- (void)newProject: (id)sender;
- (void)openProject: (id)sender;
- (void)openRecentDoc: (id)sender;
- (void)closeProject: (id)sender;
- (void)selectIsoImage: (id)sender;
- (void)blankCDRW: (id)sender;
- (void)showBurnHelp: (id)sender;
- (void) displayWorkInProgress: (id)not;

//
// access methods
//
- (NSArray *) allBundles;
- (id) bundleForKey: (id)key;

- (NSArray *) registeredFileTypes;
- (NSArray *) bundlesForFileType: (NSString *)fileType;

- (NSArray *) allProjectWindows;
- (void) addProjectWindow: (id)theProjectWindow;
- (void) removeProjectWindow: (id)theProjectWindow;

- (id) lastProjectWindowOnTop;
- (void) setLastProjectWindowOnTop: (id) aWindow;

- (NSString *) currentWorkingPath;
- (void) setCurrentWorkingPath: (NSString *)thePath;

- (BOOL) lockBurner;
- (void) unlockBurner;
- (BOOL) burnerInUse;

//
// services methods
//

- (void) newProject: (NSPasteboard *) pboard
			userData: (NSString *) userData
				error: (NSString **) error;

- (void) addToProject: (NSPasteboard *) pboard
			userData: (NSString *) userData
				error: (NSString **) error;

//
// other methods
//

- (void) createMenu;
- (void) loadDefaultTools;
- (void) loadOptionalTools;

- (BOOL) burnIsoImage: (NSString *)imageFile openParameters: (BOOL)openParams;

@end

#endif
