/*
 * autoop.c: Routines dealing with the Auto-Op system.
 *
 * Written By Timothy Jensen
 *
 * Copyright(c) 1999 
 *
 * See the COPYRIGHT file, or do a HELP IRCII COPYRIGHT 
 */

#ifndef lint
static	char	rcsid[] = "@(#)$Id: autoop.c,v 1.4 1999/07/27 17:37:25 toast Exp $";
#endif

#include "irc.h"

#include <time.h>
#include "autoop.h"
#include "ircaux.h"
#include "server.h"
#include "output.h"
#include "whois.h"
#include "comstud.h"
#include "names.h"
#include "vars.h"

typedef struct ao_UserItemStru {
	char *userhost;
	struct ao_UserItemStru *next;
} ao_UserItem;

typedef struct ao_ChanItemStru {
	char *name;
	ao_UserItem *ao_userlist;
	struct ao_ChanItemStru *next;
} ao_ChanItem;

ao_ChanItem *ao_chanlist = 0;

static void
AddTimer(nick, channel, when)
	char	*nick,
		*channel;
	time_t	when;
{
	AutoOp_Timer	*curr;

	curr = (AutoOp_Timer *) new_malloc(sizeof(AutoOp_Timer));
	curr->nick = curr->channel = (char *) 0;
	malloc_strcpy(&curr->nick, nick);
	malloc_strcpy(&curr->channel, channel);
	curr->when = time(NULL) + when;
	curr->next = server_list[from_server].OpTimers;
	server_list[from_server].OpTimers = curr;
}

void
handle_autoop(nick, channel, userhost)
	char	*nick,
		*channel,
		*userhost;
{
	ao_ChanItem	*chanitem;
	ao_UserItem	*useritem;
	int		delay;

	if (!nick || !channel || !userhost)
		return;

	chanitem = ao_chanlist;
	while (chanitem) {
		if (!my_stricmp(channel, chanitem->name) || !strcmp("*", chanitem->name)) {
			useritem = chanitem->ao_userlist;
			while (useritem) {
				if (wild_match(useritem->userhost, userhost)) {
					if ((delay = get_int_var(AUTOOP_DELAY_VAR)) > 0)
						AddTimer(nick, channel,
							delay + (random() %
							(delay+1)));
						
					else if (get_channel_oper(channel,
							from_server))
						send_to_server("MODE %s +o %s",
							channel, nick);
					return;
				}
				useritem = useritem->next;
			}
		}
		chanitem = chanitem->next;
	}
}

void
userhost_add_autoop(stuff, nick, args)
	WhoisStuff	*stuff;
	char		*nick,
			*args;
{
        char		*userhost,*usercluster = 0;
        char		*temp, *channel;
	ao_ChanItem	*chanitem,*lastchan;
	ao_UserItem	*useritem,*tempuser;

        if (!stuff || !stuff->nick || !nick || my_stricmp(stuff->nick, nick))
                return;
	if (stuff->not_on) {
		say("%s is not on IRC!", nick);
		return;
	}
	userhost = new_malloc(strlen(stuff->user) + strlen(stuff->host) + 2);
	sprintf(userhost, "%s@%s", stuff->user, stuff->host);
	channel = args;

	chanitem = ao_chanlist;
	while (chanitem) {
		if (!my_stricmp(channel,chanitem->name)) {
			useritem = (ao_UserItem *) new_malloc(sizeof(ao_UserItem));
			malloc_strcpy(&usercluster, cluster(userhost));
			useritem->userhost = new_malloc(strlen(usercluster) + 2);
			sprintf(useritem->userhost, "*%s", usercluster);
			new_free(&usercluster);
			useritem->next = 0;
			if (!chanitem->ao_userlist)
				chanitem->ao_userlist = useritem;
			else {
				tempuser = chanitem->ao_userlist;
				while (tempuser->next)
					tempuser = tempuser->next;
				tempuser->next = useritem;
			}
			say("%s added to channel %s auto-op list.",
				useritem->userhost, channel);
			new_free(&userhost);
			return;
		}
		lastchan = chanitem;
		chanitem = chanitem->next;
	}
	chanitem = (ao_ChanItem *) new_malloc(sizeof(ao_ChanItem));
	useritem = (ao_UserItem *) new_malloc(sizeof(ao_UserItem));
	chanitem->name = 0;
	malloc_strcpy(&chanitem->name, channel);
	chanitem->next = 0;
	chanitem->ao_userlist = useritem;
	useritem->next = 0;
	malloc_strcpy(&usercluster, cluster(userhost));
	useritem->userhost = new_malloc(strlen(usercluster) + 2);
	sprintf(useritem->userhost, "*%s", usercluster);
	new_free(&usercluster);
	if (!ao_chanlist)
		ao_chanlist = chanitem;
	else {
		lastchan->next = chanitem;
	}
	say("%s added to channel %s auto-op list.",
		useritem->userhost, channel);
	new_free(&userhost);
}

void
userhost_remove_autoop(stuff, nick, args)
	WhoisStuff	*stuff;
	char		*nick,
			*args;
{
        char		*userhost;
        char		*temp, *channel;
	ao_ChanItem	*chanitem,*lastchan;
	ao_UserItem	*useritem,*tempuser,*tempuser2;

        if (!stuff || !stuff->nick || !nick || my_stricmp(stuff->nick, nick))
                return;
	if (stuff->not_on) {
		say("%s is not on IRC!", nick);
		return;
	}
	userhost = new_malloc(strlen(stuff->user) + strlen(stuff->host) + 2);
	sprintf(userhost, "%s@%s", stuff->user, stuff->host);
	channel = args;

	chanitem = ao_chanlist;
	while (chanitem) {
		if (!my_stricmp(channel,chanitem->name)) {
			if (chanitem->ao_userlist && chanitem->ao_userlist->userhost &&
				wild_match(chanitem->ao_userlist->userhost, userhost)) {
			    say("%s removed from %s auto-op list.",
			      chanitem->ao_userlist->userhost, channel);
			    new_free(&(chanitem->ao_userlist->userhost));
	 		    tempuser = chanitem->ao_userlist;
			    chanitem->ao_userlist = chanitem->ao_userlist->next;
			    new_free(&tempuser);
			    new_free(&userhost);
			    return;
			}
			tempuser2 = chanitem->ao_userlist;
			while (tempuser2) {
			    if (tempuser2->next && tempuser2->next->userhost &&
			      wild_match(tempuser2->next->userhost, userhost)) {
				say("%s removed from %s auto-op list.",
				  tempuser2->next->userhost, channel);
				new_free(&(tempuser2->next->userhost));
				tempuser = tempuser2->next;
				tempuser2->next = tempuser2->next->next;
				new_free(&tempuser);
				new_free(&userhost);
				return;
			    }
			    tempuser2 = tempuser2->next;
			}
		}
		lastchan = chanitem;
		chanitem = chanitem->next;
	}
	say("%s not found in %s auto-op list.", userhost, channel);
	new_free(&userhost);
}

void
autoop(command, args)
	char	*command,
		*args;
{
	char		*channel, *userhost;
	ao_ChanItem	*chanitem, *lastchan, *tempchan;
	ao_UserItem	*useritem, *tempuser, *tempuser2;
	int		len;
	int		remove = 0;

	chanitem = ao_chanlist;
	lastchan = 0;

	channel = my_next_arg(&args);
	if (channel && (*channel == '-')) {
		channel++;
		len = strlen(channel);
		if (!my_strnicmp(channel, "REMOVE", (len>1)?len:1))
			remove = 1;
		else {
			say("Unknown or missing flag");
			return;
		}
		channel = my_next_arg(&args);
	}
	userhost = my_next_arg(&args);
	if (!channel) {			/*  /autoop (-remove)				*/
		if (!remove)
		  while (chanitem) {
			say("Auto-Op list for channel %s:", chanitem->name);
			useritem = chanitem->ao_userlist;
			while (useritem) {
				say("%s %s", chanitem->name, 
					useritem->userhost);
				useritem = useritem->next;
			}
			chanitem = chanitem->next;
		  }
		else {
		  while (ao_chanlist) {
		    while (ao_chanlist->ao_userlist) {
		      new_free(&(ao_chanlist->ao_userlist->userhost));
		      tempuser = ao_chanlist->ao_userlist;
		      ao_chanlist->ao_userlist = ao_chanlist->ao_userlist->next;
		      new_free(&tempuser);
		    }
		    new_free(&(ao_chanlist->name));
		    tempchan = ao_chanlist;
		    ao_chanlist = ao_chanlist->next;
		    new_free(&tempchan);
		  }
		  say("Auto-Op list cleared.");
		}
	} else if (!userhost) {		/*  /autoop (-remove) #channel			*/
		while (chanitem) {
			if (!my_stricmp(channel,chanitem->name)) {
				if (!remove) {
				  say("Auto-Op list for channel %s:",
					channel);
				  useritem = chanitem->ao_userlist;
				  while (useritem) {
					say("%s %s", chanitem->name, 
						useritem->userhost);
					useritem = useritem->next;
				  }
				} else {
				  while (chanitem->ao_userlist) {
		      		    new_free(&(chanitem->ao_userlist->userhost));
		      		    tempuser = chanitem->ao_userlist;
		      		    chanitem->ao_userlist = chanitem->ao_userlist->next;
		      		    new_free(&tempuser);
				  }
				  say("Auto-Op list for channel %s cleared.", channel);
				}
			}
			chanitem = chanitem->next;
		}
	} else {			/*  /autoop (-remove) #channel user@host	*/
	    if (!index(userhost, '@')) {
		/* User specified nick rather than user@host */
		if (!remove)
			typed_add_to_whois_queue(WHOIS_USERHOST, userhost, userhost_add_autoop, "%s", channel);
		else
			typed_add_to_whois_queue(WHOIS_USERHOST, userhost, userhost_remove_autoop, "%s", channel);
	    } else {
		while (chanitem) {
			if (!my_stricmp(channel,chanitem->name)) {
			  if (!remove) {
				useritem = (ao_UserItem *) new_malloc(sizeof(ao_UserItem));
				useritem->userhost = 0;
				malloc_strcpy(&useritem->userhost, userhost);
				useritem->next = 0;
				if (!chanitem->ao_userlist)
					chanitem->ao_userlist = useritem;
				else {
					tempuser = chanitem->ao_userlist;
					while (tempuser->next)
						tempuser = tempuser->next;
					tempuser->next = useritem;
				}
				say("%s added to channel %s auto-op list.",
					userhost, channel);
				return;
			  } else {
			    if (chanitem->ao_userlist && chanitem->ao_userlist->userhost && !my_stricmp(userhost,
				chanitem->ao_userlist->userhost)) {
			      new_free(&(chanitem->ao_userlist->userhost));
			      tempuser = chanitem->ao_userlist;
			      chanitem->ao_userlist = chanitem->ao_userlist->next;
			      new_free(&tempuser);
			      say("%s removed from %s auto-op list.", userhost, channel);
			      return;
			    }
			    tempuser2 = chanitem->ao_userlist;
			    while (tempuser2) {
			      if (tempuser2->next && tempuser2->next->userhost && !my_stricmp(userhost,
				   tempuser2->next->userhost)) {
				 new_free(&(tempuser2->next->userhost));
				 tempuser = tempuser2->next;
				 tempuser2->next = tempuser2->next->next;
				 new_free(&tempuser);
				 say("%s removed from %s auto-op list.", userhost, channel);
				 return;
			      }
			      tempuser2 = tempuser2->next;
			    }
			    say("%s not found in %s auto-op list.", userhost, channel);
			    return;
			  }
			}
			lastchan = chanitem;
			chanitem = chanitem->next;
		}
		if (remove) {
		   say("%s not found in %s auto-op list.", userhost, channel);
		   return;
		}
		chanitem = (ao_ChanItem *) new_malloc(sizeof(ao_ChanItem));
		useritem = (ao_UserItem *) new_malloc(sizeof(ao_UserItem));
		chanitem->name = 0;
		malloc_strcpy(&chanitem->name, channel);
		chanitem->next = 0;
		chanitem->ao_userlist = useritem;
		useritem->next = 0;
		useritem->userhost = 0;
		malloc_strcpy(&useritem->userhost, userhost);
		if (!ao_chanlist)
			ao_chanlist = chanitem;
		else {
			lastchan->next = chanitem;
		}
		say("%s added to channel %s auto-op list.",
			userhost, channel);
	    }
	}
}

void
save_autoops(fp)
	FILE	*fp;
{
	ao_ChanItem *chanitem;
	ao_UserItem *useritem;

	chanitem = ao_chanlist;
	while (chanitem) {
		useritem = chanitem->ao_userlist;
		while (useritem) {
			fprintf(fp, "AUTOOP %s %s\n", chanitem->name,
				useritem->userhost);
			useritem = useritem->next;
		}
		chanitem = chanitem->next;
	}
}

void
OpTimer()
{
	AutoOp_Timer	*curr, *last, *next;
	time_t	now;
	int	i, save_server;

	now = time(NULL);

	for (i = 0; i < number_of_servers; i++) {
		curr = server_list[i].OpTimers;
		last = (AutoOp_Timer *) 0;
		while (curr) {
			next = curr->next;
			if (now > curr->when) {
				if (get_channel_oper(curr->channel, i) &&
						!is_chanop(curr->channel, curr->nick)) {
					save_server = from_server;
					from_server = i;
					send_to_server("MODE %s +o %s", curr->channel,
						curr->nick);
					from_server = save_server;
				}
				if (last)
					last->next = curr->next;
				else
					server_list[i].OpTimers = curr->next;
				new_free(&curr->nick);
				new_free(&curr->channel);
				new_free(&curr);
			} else
				last = curr;
			curr = next;
		}
	}
}

void
remove_autoop_chan(nick, channel)
	char	*nick,
		*channel;
{
	AutoOp_Timer	*curr, *last, *next;

	last = (AutoOp_Timer *) 0;
	curr = server_list[from_server].OpTimers;

	while (curr) {
		next = curr->next;
		if (!my_stricmp(curr->nick, nick) &&
				!my_stricmp(curr->channel, channel)) {
			if (last)
				last->next = curr->next;
			else
				server_list[from_server].OpTimers = curr->next;
			new_free(&curr->nick);
			new_free(&curr->channel);
			new_free(&curr);
		} else
			last = curr;
		curr = next;
	}
}

void
remove_autoop_all(nick)
	char	*nick;
{
	AutoOp_Timer	*curr, *last, *next;

	last = (AutoOp_Timer *) 0;
	curr = server_list[from_server].OpTimers;

	while (curr) {
		next = curr->next;
		if (!my_stricmp(curr->nick, nick)) {
			if (last)
				last->next = curr->next;
			else
				server_list[from_server].OpTimers = curr->next;
			new_free(&curr->nick);
			new_free(&curr->channel);
			new_free(&curr);
		} else
			last = curr;
		curr = next;
	}
}

void
rename_autoop(nick, newnick)
	char	*nick,
		*newnick;
{
	AutoOp_Timer	*curr = server_list[from_server].OpTimers;

	while (curr) {
		if (!my_stricmp(curr->nick, nick))
			malloc_strcpy(&curr->nick, newnick);
		curr = curr->next;
	}
}
