/*
 * Copyright (c) 2001 Tommy Bohlin <tommy@gatespace.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/* lapmux.h
 */

/**********************************************************************
 * Data structures
 **********************************************************************/

typedef struct LSAPPrivate {
  LSAP lsap;
  struct LSAPPrivate* next;
  struct LAPPrivate* lap;
  u_char lsapSel;
  int flags;
} LSAPPrivate;

typedef struct SendBuf {
  struct SendBuf* next;
  int length;
  u_char buf[1];
} SendBuf;

typedef struct ConnectionPrivate {
  Connection con;
  struct ConnectionPrivate* next;
  struct LAPPrivate* lap;
  u_char localSel;
  u_char remoteSel;

  int flags;
/*#define LM_TINY_TP*/
#define CST_USER_FLAGS           0x0ff
#define CST_OPENING              0x100
#define CST_OPEN                 0x200
#define CST_NOTIFIED             0x400
  int sendDataSize;
  int recvDataSize;
  int sendSduSize;
  int recvSduSize;
  int sendCredits;
  int recvCredits;
  int wantedRecvCredits;
  int sarLength;
  u_char* sarBuffer;

  SendBuf* sendHead;
  SendBuf* sendTail;
} ConnectionPrivate;

typedef struct Params {
  int maxTurnaround;
  int dataSize;
  int windowSize;
  int extraBOFs;
  int minTurnaround;
  int speed;
  int disconnect;
  int speedMask;
  int disconnectMask;
} Params;

typedef struct LAPPrivate {
  LAP lap;
  FrameDevice* fdev;

  /* Identity */
  struct {
    int charSet;
    int length;
    u_char bytes[20];
  } info;

  /* LAP connection state */
  int state;
#define STATE_NDM                0
#define STATE_QUERY              (1|STATE_DISCOVERING)
#define STATE_REPLY              (2|STATE_DISCOVERING)
#define STATE_SETUP              (3|STATE_CONNECTED)
#define STATE_PRIMARY            (4|STATE_CONNECTED)
#define STATE_SECONDARY          (5|STATE_CONNECTED)
#define STATE_DISCOVERING        0x100
#define STATE_CONNECTED          0x200
  int mod;
#define MOD_NEED_S               0x001
#define MOD_CONTROL              0x002
#define MOD_CHANGE_SPEED         0x004
#define MOD_DISCONNECT           0x010
#define MOD_BUSY_LOCAL           0x020
#define MOD_BUSY_REMOTE          0x040
#define MOD_SEL_REJECT           0x080
  int address;
  u_char handle;

  /* Control frame buffer */
  int ctrlLen;
  u_char ctrlBuf[384+2];

  /* Setup stage */
  int setupTries;
  int setupAddress;

  /* Discovery state */
  int xidSlot;
  int xidFlags;

  /* Communication parameters */
  Params sendParams;
  int recvDataSize;

  /* Communication state */
  int nTimeouts;
  SendBuf* sendHead;
  SendBuf* sendTail;
  int sendCount;
  int nextVs;
  int nextVr;
  ConnectionPrivate* connections;
  ConnectionPrivate* nextConn;

  /* Registered LSAPs */
  LSAPPrivate* lsaps;
} LAPPrivate;

/**********************************************************************
 * Used by mux.c
 **********************************************************************/

void lapAppendSendBuffer(LAPPrivate* lapp, SendBuf* s);

/**********************************************************************
 * Used by lap.c
 **********************************************************************/

void lmMoveConnectionBuffers(LAPPrivate* lapp, int wanted);
void lmData(LAPPrivate* lapp, u_char* buf, int len, int expedited);
void lmUnitData(LAPPrivate* lapp, u_char* buf, int len);
void lmDisableConnections(LAPPrivate* lapp);
void lmFreeConnections(LAPPrivate* lapp);
