%module "Net::Multicast::Beacon"

/* $Id: */

%{
#include "beacon.h"
%}


%ignore rtp_send_ctrl;
%ignore rtp_send_data;

%rename(rtp_send_ctrl) send_ctrl;
%rename(rtp_send_data) send_data;


/*
 * XXX -- these should be obtained from the system, but there isn't a real
 *        easy way to do this without using -include all and getting a
 *        whole lot of cruft.
 */

typedef char                int8_t;
typedef char                uint8_t;
typedef short               int16_t;
typedef unsigned short      uint16_t; 
typedef int                 int32_t;
typedef unsigned int        uint32_t;
typedef long long           int64_t;
typedef unsigned long long  uint64_t;

struct rtp;
typedef struct rtp *rtp_t;


typedef struct bevent {
    rtp_event_type type;
    uint32_t       ssrc; /* Sender SSRC */
    double         time; /* in seconds as a float */
    rtcp_rr        *rr; /* if this event is an rr, this will non NULL */
    struct bevent  *next; /* next event in queue */
} beacon_event;

rtp_t beacon_init(const char *addr, uint16_t rx_port, uint16_t tx_port,
                  int ttl, double rtcp_bw, uint8_t *userdata);
rtp_t beacon_init_if(const char *addr, char *iface, uint16_t rx_port,
                     uint16_t tx_port, int ttl, double rtcp_bw,
                     uint8_t *userdata);
beacon_event *beacon_get_next_event();
void beacon_free_event(beacon_event *event);
int beacon_queue_len();

void xmemdmp();

/* no need to expose all the stuff in librtp, so only selected bits are below */

#if 0
typedef struct {
    unnt32_t ssrc;       /* Receiver SSRC */
    uint32_t fract_lost; /* already divided by 2.56 */
    uint32_t total_lost;
    uint32_t lsr;
    uint32_t dlsr;
    uint32_t last_seq;
    uint32_t jitter;
} recv_rept;
#endif

typedef struct {
        uint32_t        ssrc;           /* The ssrc to which this RR pertains */
#ifdef WORDS_BIGENDIAN
        uint32_t        fract_lost:8;
        uint32_t        total_lost:24;
#else
        uint32_t        total_lost:24;
        uint32_t        fract_lost:8;
#endif    
        uint32_t        last_seq;
        uint32_t        jitter;
        uint32_t        lsr;
        uint32_t        dlsr;
} rtcp_rr;

uint32_t   rtp_my_ssrc(struct rtp *session);
void       rtp_send_ctrl(struct rtp *session, uint32_t rtp_ts,
                         rtcp_app_callback appcallback);
void       rtp_update(struct rtp *session);
int        rtp_recv(struct rtp *session,
                    struct timeval *timeout, uint32_t curr_rtp_ts);
void       rtp_send_bye(struct rtp *session);
void       rtp_done(struct rtp *session);
int        rtp_set_sdes(struct rtp *session, uint32_t ssrc,
                        rtcp_sdes_type type,
                        const char *value, int length);
int        rtp_set_option(struct rtp *session, rtp_option optname, int
optval);
const char      *rtp_get_sdes(struct rtp *session, uint32_t ssrc,
rtcp_sdes_type type);




/* rtp_event type values. */
typedef enum {
        RX_RTP,
        RX_SR,
        RX_RR,
        RX_SDES,
        RX_BYE,         /* Source is leaving the session, database entry is still valid                           */
        SOURCE_CREATED,
        SOURCE_DELETED, /* Source has been removed from the database                                              */
        RX_RR_EMPTY,    /* We've received an empty reception report block                                         */
        RX_RTCP_START,  /* Processing a compound RTCP packet about to start. The SSRC is not valid in this event. */
        RX_RTCP_FINISH,	/* Processing a compound RTCP packet finished. The SSRC is not valid in this event.       */
        RR_TIMEOUT,
        RX_APP
} rtp_event_type;

typedef enum  {
        RTCP_SDES_END   = 0,
        RTCP_SDES_CNAME = 1,
        RTCP_SDES_NAME  = 2,
        RTCP_SDES_EMAIL = 3,
        RTCP_SDES_PHONE = 4,
        RTCP_SDES_LOC   = 5,
        RTCP_SDES_TOOL  = 6,
        RTCP_SDES_NOTE  = 7,
        RTCP_SDES_PRIV  = 8
} rtcp_sdes_type;

%inline %{
/*
 * convenience functions to create, populate and free a pointer to a struct
 * timeval
 */

struct timeval *rtp_make_timeval(int sec, int usec)
{
  struct timeval *tv;
  tv = (struct timeval *) xmalloc(sizeof(struct timeval));
  tv->tv_sec = sec;
  tv->tv_usec = usec;

  return(tv);
}

struct timeval *rtp_gettimeofday()
{
  struct timeval *tv;
  tv = (struct timeval *) xmalloc(sizeof(struct timeval));

  gettimeofday(tv,NULL);

  return(tv);
}

void rtp_free_timeval(struct timeval *tv)
{
  xfree(tv);
}

void send_ctrl(struct rtp *session, uint32_t rtp_ts)
{
  rtp_send_ctrl(session,rtp_ts,NULL);
}
/* XXX -- don't feel like dealing with csrc[] arg  and don't need it */
int send_data(struct rtp *session, uint32_t rtp_ts, char pt, int m,
              char *data, int data_len, char *extn, uint16_t extn_len,
              uint16_t extn_type)
{
  return rtp_send_data(session,rtp_ts,pt,m,0,0,data,data_len,extn,extn_len,extn_type);
}

%}
