// Copyright (c) 1999 Philip A. Hardin (pahardin@cs.utexas.edu)
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License v2 or later.


#include "gfxtarget.h"

bool gfxTarget::OpenDisplay(char *dispName) {
  disp= XOpenDisplay(dispName);
  if (disp==NULL) {
    cerr << "cannot connect to X server " << XDisplayName(dispName) << endl;
    return false;
  }
  screenNo= DefaultScreen(disp);
  rootWin= RootWindow(disp, screenNo);
  return true;
}

void gfxTarget::ConnectToWM(char *argv[], int argc, char *progName,
                short x, short y, short width, short height) {
  XSizeHints    size_hints;
  XWMHints      wm_hints;
  XClassHint    class_hints;
  XTextProperty winNameProp,iconNameProp;
  char          *winName=  progName;
  char          *iconName= progName;
    
  size_hints.flags= PPosition|PSize|PMinSize;
  size_hints.min_width= width;
  size_hints.min_height= height;
    
  if (XStringListToTextProperty(&winName,1,&winNameProp)==0) {
    cerr << progName << ": structure allocation for windowName failed\n";
    exit(-1);
  }
  if (XStringListToTextProperty(&iconName,1,&iconNameProp)==0) {
    cerr << progName << ": structure allocation for iconName failed\n";
    exit(-1);
  }
  wm_hints.initial_state= NormalState;
  wm_hints.input= True;
  // wm_hints.icon_pixmap= icon_pixmap;
  wm_hints.flags= StateHint | InputHint; // |IconPixmapHint
  class_hints.res_name= progName;
  class_hints.res_class= progName;
  XSetWMProperties(disp,win,&winNameProp,&iconNameProp,argv,argc,
                  &size_hints,&wm_hints,&class_hints);
}

void gfxTarget::HandleResize() {
  XFreePixmap(disp,pm);
  XWindowAttributes attr;
  XGetWindowAttributes(disp,win,&attr);
  pm= XCreatePixmap(disp,win,attr.width,attr.height,attr.depth);
#ifndef NO_OPENGL
  if (useGL)
    glViewport(0,0,attr.width,attr.height);
#endif
}

void gfxTarget::DoubleBufferBegin() {
  savedWin= win;
  savedGc= gc;
  win= pm;
  gc= pmgc;
}

void gfxTarget::DoubleBufferEnd() {
  win= savedWin;
  gc= savedGc;
  if (useGL) {
#ifndef NO_OPENGL
    glXSwapBuffers(disp,win);
#endif
  } else {
    XWindowAttributes attr;
    XGetWindowAttributes(disp,win,&attr);
    XCopyArea(disp,pm,win,gc,0,0,attr.width,attr.height,0,0);
    /* using XGetImage/XPutImage takes longer than XCopyArea
       XImage *ximg= XGetImage(disp,pm,0,0,gfxSize.x,gfxSize.y,
       0x000000ff,ZPixmap);
       XPutImage(disp,win,gc,ximg,0,0,0,0,gfxSize.x,gfxSize.y);
       XDestroyImage(ximg);
    */
  }
}

