#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <time.h>
#include <gtk/gtk.h>
#include "main.h"

typedef struct {
	GtkWidget *okno ;
	int answer ; } dane_s ;

void destroy_dialog(GtkWidget *okno, gpointer dane) {
	gtk_grab_remove(GTK_WIDGET(dane)) ;
}


void close_dialog(GtkWidget *kontrolka, gpointer dane) {
	gtk_widget_destroy(GTK_WIDGET(dane)) ;
}


/* prints a communique using standard printf format */
void komunikat(char *tekst, ...) {
	va_list vl ;
	char message[400] ;
	GtkWidget *etykieta, *okno, *przycisk ;

	va_start(vl, tekst) ;
	vsprintf(message, tekst, vl) ;

	okno = gtk_dialog_new() ;
	gtk_container_border_width(GTK_CONTAINER(okno), 5) ;
	gtk_signal_connect(GTK_OBJECT(okno), 
		"destroy", 
		GTK_SIGNAL_FUNC(destroy_dialog),
		okno) ;

	etykieta = gtk_label_new(message) ;
	gtk_misc_set_padding(GTK_MISC(etykieta), 10, 10) ;
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(okno)->vbox), etykieta, TRUE, TRUE, 0) ;
	gtk_widget_show(etykieta) ;

	przycisk = gtk_button_new_with_label("OK") ;
	gtk_signal_connect(GTK_OBJECT(przycisk), "clicked", 
		GTK_SIGNAL_FUNC(close_dialog), okno) ;
	GTK_WIDGET_SET_FLAGS(przycisk, GTK_CAN_DEFAULT) ;
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(okno)->action_area), 
		przycisk, TRUE, TRUE, 0) ;
	gtk_widget_grab_default(przycisk) ;

	gtk_widget_show(przycisk) ;

	gtk_widget_show(okno) ;
	gtk_grab_add(okno) ;

}


void destroy_demand(GtkWidget *okno, gpointer dane) {
	gtk_grab_remove(GTK_WIDGET(dane)) ;
	gtk_main_quit() ;
}

void close_demand_yes(GtkWidget *okno, gpointer dane) {
	dane_s *d ;

	d = (dane_s *) dane ;
	d->answer = TRUE ;
	gtk_grab_remove(GTK_WIDGET(d->okno)) ;
	gtk_widget_destroy(GTK_WIDGET(d->okno)) ;
	gtk_main_quit() ;
}

void close_demand_no(GtkWidget *okno, gpointer dane) {
	dane_s *d ;

	d = (dane_s *) dane ;
	d->answer = FALSE ;
	gtk_grab_remove(GTK_WIDGET(d->okno)) ;
	gtk_widget_destroy(GTK_WIDGET(d->okno)) ;
	gtk_main_quit() ;
}


/* asks a question and returns TRUE / FALSE */
int demand(char *tekst, ...) {
	dane_s *dane ;
	GtkWidget *etykieta, *okno, *yesb, *nob ;
	va_list vl ;
	char message[400] ;
	int reply ;

	va_start(vl, tekst) ;
	vsprintf(message, tekst, vl) ;

	okno = gtk_dialog_new() ;

	gtk_container_border_width(GTK_CONTAINER(okno), 5) ;
	gtk_signal_connect(GTK_OBJECT(okno), 
		"destroy", 
		GTK_SIGNAL_FUNC(destroy_demand),
		okno) ;

	dane = malloc(sizeof(*dane)) ;
	dane->okno = okno ;	
	dane->answer = FALSE ;

	etykieta = gtk_label_new(message) ;
	gtk_misc_set_padding(GTK_MISC(etykieta), 10, 10) ;
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(okno)->vbox), etykieta, TRUE, TRUE, 0) ;

	yesb = gtk_button_new_with_label("Yes") ;
	gtk_signal_connect(GTK_OBJECT(yesb), "clicked", 
		GTK_SIGNAL_FUNC(close_demand_yes), dane) ;

	GTK_WIDGET_SET_FLAGS(yesb, GTK_CAN_DEFAULT) ;
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(okno)->action_area), 
		yesb, TRUE, TRUE, 0) ;
	gtk_widget_grab_default(yesb) ;

	nob = gtk_button_new_with_label("No") ;
	gtk_signal_connect(GTK_OBJECT(nob), "clicked",
		GTK_SIGNAL_FUNC(close_demand_no), dane) ;
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(okno)->action_area),
		nob, TRUE, TRUE, 0) ;

	gtk_widget_show_all(okno) ;
	gtk_grab_add(okno) ;
	gtk_main() ;

	reply = dane->answer ;
	free(dane) ;
	return (reply) ;
}


/* somewhat more complex version. caller provides (1) a widget to show (2) a
 * callback function (3) data to pass to the callback function when OK is
 * pressed. This way, virtually any data can be get from the user. */
int demand_complex(GtkWidget *widget, gpointer func, data_s *data, char *tekst, ...) {
	GtkWidget *hbox, *ybox, *button, *okno ;
	va_list vl ;
	char message[400] ;
	int answer = FALSE ;

	say(0, "demand_complex: warming up") ;
	va_start(vl, tekst) ;
	vsprintf(message, tekst, vl) ;

	/* simple dialog window */
	okno = gtk_window_new(GTK_WINDOW_DIALOG) ;
	data->window = okno ;	
  gtk_window_set_title(GTK_WINDOW(okno), "") ;
  gtk_signal_connect(GTK_OBJECT(okno), "destroy", GTK_SIGNAL_FUNC(gtk_main_quit), okno) ;

  ybox = gtk_vbox_new(FALSE, 5) ;
	gtk_container_add(GTK_CONTAINER(okno), ybox) ;

	create_label(ybox, message) ;
	create_separator(ybox) ;
	gtk_box_pack_start(GTK_BOX(ybox), widget, TRUE, TRUE, 5) ;
	create_separator(ybox) ;

	hbox = create_hbox(ybox) ;
	/* we connect "OK" to the custom function and pass to it users data */
	button = create_button(hbox, func, "    OK    ", data) ;
	create_button(hbox, zakoncz_dialog, "  Cancel  ", okno) ;

	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT) ;
	gtk_widget_grab_default(button) ;

	gtk_widget_show_all(okno) ;
	gtk_main() ;

	return answer ;
}
