# -*- perl -*-

# Copyright (c) 2005 by Jeff Weisberg
# Author: Jeff Weisberg <argus @ tcp4me.com>
# Created: 2005-Dec-10 12:46 (EST)
# Function: cgi notify related functions
#
# $Id: web_notify.pl,v 1.6 2008/02/03 05:23:34 jaw Exp $

package Argus::Web;
use strict;
use vars qw($argusd);

my %NOTECOLOR = (
		 clear		=> '88FF88',
		 critical	=> 'FF8888',
		 major		=> 'FFAA66',
		 minor		=> 'FFFF88',
		 warning	=> '8888FF',
);


sub web_ntfylist {
    my $me = shift;
    $me->notify_list( 'Notifications', 0 );
}

sub web_ntfylsua {
    my $me = shift;
    $me->notify_list( 'Unacked Notifications', 1 );
}

sub notify_list {
    my $me = shift;
    my $title = shift;
    my $ackp  = shift;
    my( $q, $r, $n );

    $q = $me->{q};
    my $fmt = $q->param('fmt');
    
    return web_notify_json($me) if $fmt eq 'json';
    return web_notify_rss($me)  if $fmt eq 'rss';
    
    return unless $me->check_acl_func('Top', 'ntfylist', 1);
    # QQQ - check ACL for every object listed???
    my $url = $q->url();

    my $res = notify_list_data($me, $ackp);

    return $me->error( "unable to connect to server" ) unless $res;
    return $me->error( "Unable to access <I>notify list</I><BR>$res->{error}" ) if $res->{error};

    $me->startpage( title   => l10n($title),
		    refresh => 60,
		    rss     => "$url?func=rss");

    print "<H2>$title</H2>\n";
    print $q->startform(-method=>'get'), "\n" if $ackp;
    print "<TABLE WIDTH=\"95%\" BORDER=1 CELLSPACING=0 CELLPADDING=2>\n";

    foreach my $nd (@{$res->{data}}){
	$n++;
	my $dt = strftime "%d/%b %R", localtime($nd->{create});
	$dt =~ s/\s+/&nbsp\;/g;
	my $id = $nd->{id};
	my $obj = decode($nd->{obj});
	my $msg = decode($nd->{msg});
	$msg =~ s/\n/<br>\n/gs;
	my $durl = "<A HREF=\"" . $q->url() . "?func=ntfydetail;idno=$id\">$id</A>";
	my $aurl = "<A HREF=\"" . $q->url() . "?func=ntfyack;idno=$id\">Ack</A>";
	my $objl = "<A HREF=\"" . $q->url() . "?object=$obj;func=page\">Object</A>";
	# QQQ - or base color on whether it is acked or not?
	my $clr  = $NOTECOLOR{ $nd->{seve} };
	
	if( $ackp ){
	    print "<TR BGCOLOR=\"#$clr\"><TD>$aurl</TD><TD><INPUT TYPE=checkbox NAME=idno VALUE=$id></TD>",
	    "<TD>$durl</TD><TD>$objl</TD><TD>$dt</TD><TD>$msg</TD></TR>\n";
	}else{
	    print "<TR BGCOLOR=\"#$clr\"><TD>$durl</TD><TD>$objl</TD><TD>$dt</TD><TD>$msg</TD></TR>\n";
	}
    }

    print "</TABLE>\n";
    if( $ackp && $n ){
	print "<INPUT TYPE=HIDDEN NAME=func VALUE=ntfyack>\n";
	print $q->submit(l10n("Ack Checked")), "\n";
	print $q->submit(l10n("Ack All")), "\n";
	print $q->endform(), "\n";
    }

    unless( $n ){
	if( $ackp ){
	    print l10n("There are no un-acked notifications"), "\n";
	}else{
	    print l10n("There are no notifications"), "\n";
	}
    }
    
    $me->endpage();
}

sub web_ntfyack {
    my $me = shift;
    my( $q, @id, $res );

    $q = $me->{q};

    if( $q->param('Ack All') ){
	@id = ('all');
    }else{
	@id = $q->param('idno');
    }

    foreach my $id (@id){
	return $me->error( 'Invalid Notification ID' ) unless $id =~ /^(\d+|all)$/;

	return unless $me->check_acl_ack($id, 1);
	
	$res = $argusd->command( func  => 'notify_ack',
				 user  => $me->{auth}{user},
				 idno  => $id );
	return $me->error( "unable to connect to server" ) unless $res;
	return $me->error( "Unable to access <I>$id</I><BR>$res->{resultcode} $res->{resultmsg}" )
	    unless $res->{resultcode} == 200;
    }

    if( $q->request_method() eq 'POST'){
	$me->heavy_redirect( $q->url() . "?func=ntfylsua" );
    }else{
	$me->light_redirect( $q->url() . "?func=ntfylsua" );
    }
}

sub web_ntfydetail {
    my $me = shift;
    my( $res, $n, $esc );

    my $q   = $me->{q};
    my $id  = $q->param('idno');
    
    return $me->error( 'invalid notification' ) unless $id =~ /^\d+$/;
    $res = $argusd->command( func => 'notify_detail',
			     idno => $id );

    return $me->error( "unable to connect to server" ) unless $res;
    return $me->error( "Unable to access <I>$id</I><BR>$res->{resultcode} $res->{resultmsg}" )
	unless $res->{resultcode} == 200;

    # check ACL
    unless( $me->check_acl( decode($res->{acl_ntfydetail})) ){
	return $me->web_acl_error( 'ntfydetail' );
    }

    my $icon = ($res->{objstate} eq 'up') ? 'web icon_up' : 'web icon_down';
    
    $me->startpage( title      => "Details for $id",
		    refresh    => 60,
		    style      => decode($res->{'web style_sheet'}),
		    javascript => decode($res->{'web javascript'}),
		    bkgimg     => decode($res->{'web bkgimage'}),
		    icon       => decode($res->{$icon} || $res->{'web icon'}),
		    );
    
    print "<H2>Details for $id</H2>\n";
    
    print "<TABLE class=notifydetail cellspacing=0 cellpadding=2>\n";
    print "<TR><TD><B>ID</B></TD><TD>$id",
        ($res->{state} eq 'active' ? "&nbsp;&nbsp;&nbsp;<A HREF=\"". $q->url().
	 "?func=ntfyack;idno=$id\"><B>[ Ack ]</B></A>" : ''),
	"</TD></TR>\n";
    print "<TR><TD><B>Object</B></TD><TD><A HREF=\"", $q->url(), "?object=$res->{object};func=page\">",
        decode($res->{object}), "</A></TD></TR>\n";

    my $msg = decode($res->{msg});
    $msg =~ s/\n/<br>\n/gs;
    my $clr  = $NOTECOLOR{ $res->{severity} };

    print "<TR><TD><B>Message</B></TD><TD BGCOLOR=\"#$clr\">", $msg, "</TD></TR>\n";
    print "<TR><TD><B>Reason</B></TD><TD>", decode($res->{reason}), "</TD></TR>\n" if $res->{reason};
    print "<TR><TD><B>Created</B></TD><TD>", l10n_localtime($res->{created}), "</TD></TR>\n";
    $esc = " / <B>Escalated</B>" if $res->{escalated};
    print "<TR><TD><B>Status</B></TD><TD>$res->{state}$esc</TD></TR>\n";
    print "<TR><TD><B>Severity</B></TD><TD>$res->{severity}</TD></TR>\n" if $res->{severity};
    print "<TR><TD><B>Priority</B></TD><TD>$res->{priority}</TD></TR>\n" if $res->{priority};
    print "<TR><TD><B>Audit Detail</B></TD><TD>$res->{detail}</TD></TR>\n" if $res->{detail};

    if( $res->{ackedby} ){
	print "<TR><TD><B>Acked By</B></TD><TD>$res->{ackedby}</TD></TR>\n";
	print "<TR><TD><B>Acked At</B></TD><TD>", l10n_localtime($res->{ackedat}), "</TD></TR>\n";
    }
    print "</TABLE>\n<HR>\n";

    print "<B>Per User Status</B><BR>\n";
    print "<TABLE BORDER=1>\n<TR>\n";
    foreach my $dst (split /\s+/, $res->{statuswho}){
	my $w = decode($dst);
	my $s = $res->{"status $dst"};
	print "<TD><B>$w</B><BR>$s</TD>\n";
    }
    print "</TR>\n</TABLE>\n<HR>\n";

    print "<B>Audit Trail</B><BR>\n";
    print "<TABLE>\n";
    $n = $res->{loglines} - 1;
    foreach my $i (0..$n){
	my($t, $w, $m) = split /\s+/, $res->{"log $i"};

	$w = ($w eq '_') ? '' : decode($w);
	$m = decode($m);
	print "<TR><TD>", l10n_localtime($t), "</TD><TD>$w</TD><TD>$m</TD></TR>\n";
    }
    print "</TABLE>\n";
    $me->endpage();
    
}

sub notify_list_data {
    my $me   = shift;
    my $ackp = shift;
    

    my $res = $argusd->command_raw( func  => 'notify_list',
				    which => $ackp ? 'unacked' : ''
				    );
    
    return unless $res;
    return { error => $res } unless $res =~ /200/;

    my @d;
    while( $_ = $argusd->nextline() ){
	chop;
	last if /^$/;
	my( $id, $stt, $stat, $creat, $obj, $msg,
	    $prio, $seve ) = split;

	$prio = undef if $prio eq '_';
	$seve = undef if $seve eq '_';
	
	push @d, { id     => $id,
		   state  => $stt,
		   status => $stat,
		   create => $creat,
		   obj    => $obj,
		   msg    => $msg,
		   prio   => $prio,
		   seve   => $seve,
	       };
	
    }

    return { data => \@d };
}


1;
