# Polski plik jzykowy/Polish language file.
# Tumaczenie/Translation: 	
#		Mateusz Szczyrzyca <annihilator@ircnet.pl>, 
# 		Bartosz Mierzwiak <bartosz@mierzwiak.com>
# 		Admins of PolNet: http://www.ircnet.pl
# 		and Eskela: <eskela@royy.net>
#	
# Aktualizacja/Updated: 16/7/2004
# Wersja serwisw/Anope version: 1.7.4
#
# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #
# (C) 2003-2007 Anope Team
# Contact us at info@anope.org
#   
# Please read COPYING and README for furhter details.
#     
# Based on the original code of Epona by Lara.
# Based on the original code of Services by Andy Church. 
#
# When translating this file to another language, keep in mind that the
# order of parameters for sprintf() is fixed in the source code, so your
# messages need to take the same parameters in the same order as the
# English messages do.  (Obviously, this doesn't hold for the strftime()
# format lines immediately below.)  If you can't get a natural translation
# of a message without changing the order of the parameters, let us know
# (dev@anope.org) which message is causing a problem and I'll see
# what I can do.
#
# In help messages, "%S" (capital S, not lowercase) refers to the name of
# the service sending the message; for example, in NickServ help messages,
# "%S" is replaced by "NickServ" (or whatever it is renamed to in
# services.conf).  The %S's do not count as sprintf() parameters, so they can be
# rearranged, removed, or added as necessary.
#
# Also in help messages, please try to limit line lengths to 60 characters
# of text (not including the leading tab).  This length was chosen because
# it does not cause line wrap under default settings on most current IRC
# clients.  Remember that format characters (control-B, control-_) are not
# included in that 60-character limit (since they don't show on the user's
# screen).  Also remember that format specifiers (%S, etc.) will expand
# when displayed, so remember to take this into account; you can assume
# that the length of a pseudoclient name (%S replacement) will be eight
# characters, so reduce the maximum line length by 6 for every %S on a
# line.
#
# Finally, remember to put a tab at the beginning of every line of text
# (including empty lines).  This has to be a tab, not spaces.

###########################################################################
#
# Nazwa tego jzyka
#
###########################################################################

# For languages other than English, this string should have the following
# format:
#     language-name-in-language (language-name-in-English)
# For example, "Espaol (Spanish)" or "Franais (French)".

LANG_NAME
	Polski (Polish)

###########################################################################
#
# Podstawowe komunikaty
#
###########################################################################

# strftime() format strings.  man 3 strftime for information on the
# meanings of the format specifiers.  Short version:
#	%a = weekday name (short)	%H = hour
#	%b = month name (short)		%M = minute
#	%d = day of month		%S = second
#	%Y = year			%Z = time zone

# This is used as the format string for strftime() for a date and time
# together.
STRFTIME_DATE_TIME_FORMAT
	%b %d %H:%M:%S %Y %Z
# This is used as the format string for strftime() for a date alone in long
# format (English: including weekday).
STRFTIME_LONG_DATE_FORMAT
	%a %b %d %Y
# This is used as the format string for strftime() for a date alone in
# short format (English: without weekday).
STRFTIME_SHORT_DATE_FORMAT
	%b %d %Y

# These tell our strftime() what the names of months and days are.  If you
# don't use %a, %A, %b, or %B in your strftime() strings above, you can
# leave these empty.  However, if you enter names, they MUST stay in order,
# one per line, and the list MUST be complete!

# %a
STRFTIME_DAYS_SHORT
	Nie
	Pon
	Wto
	ro
	Czw
	Pia
	Sob
# %A
STRFTIME_DAYS_LONG
	Niedziela
	Poniedziaek
	Wtorek
	roda
	Czwartek
	Pitek
	Sobota
# %b
STRFTIME_MONTHS_SHORT
	Sty
	Lut
	Mar
	Kwi
	Maj
	Cze
	Lip
	Sie
	Wrz
	Pa
	Lis
	Gru
# %B
STRFTIME_MONTHS_LONG
	Stycze
	Luty
	Marzec
	Kwiecie
	Maj
	Czerwiec
	Lipiec
	Sierpie
	Wrzesie
	Padziernik
	Listopad
	Grudzie


# This is used in ChanServ/NickServ INFO displays.
COMMA_SPACE
	, 


# Various error messages.
USER_RECORD_NOT_FOUND
	Bd wewntrzny - nie moge wysa dania do procesu.
UNKNOWN_COMMAND
	Nieznana komenda %s.
UNKNOWN_COMMAND_HELP
	Nieznana komenda %s. Napisz "%R%s HELP" aby 
	uzyska pomoc.
SYNTAX_ERROR
	Skadnia: %s
MORE_INFO
	Napisz %R%s HELP %s aby uzyska wicej 
	informacji.
NO_HELP_AVAILABLE
	Brak dostpnej pomocy dla %s.
OBSOLETE_COMMAND
	Ta komenda jest ju przestarzaa. 
	Uyj %s.

BAD_USERHOST_MASK
	Maska musi miec format ident@host.
BAD_EXPIRY_TIME
	Nieprawidowy czas wygasania.
USERHOST_MASK_TOO_WIDE
	%s jest nazbyt szczegowa i duga. 
	Prosz uy innej maski.

SERVICE_OFFLINE
	%s jest w tej chwili offline.
READ_ONLY_MODE
	Informacja: Services s w trybie tylko do 
	odczytu - zmiany nie bd zapisywane!
PASSWORD_INCORRECT
	Nieprawidowe haso.
INVALID_TARGET
	"/msg %s" is no longer supported.  Use "/msg %s@%s" or "/%s" instead.

# What's the difference between "Access denied" and "Permission denied"?
# Very little; you can safely make them the same message with no real loss
# of meaning.  If you want to make a distinction, "Access denied" is
# usually used more generally; for example, a non-oper trying to access
# OperServ gets "Access denied", while a non-Services admin trying to use
# NickServ SET NOEXPIRE gets "Permission denied".
ACCESS_DENIED
	Odmowa dostpu.
PERMISSION_DENIED
	Brak uprawnie.
RAW_DISABLED
	Opcja RAW zostaa wyaczona. Jesli chcesz jej uy, 
	dodaj DisableRaw w konfiguracji rde.

MORE_OBSCURE_PASSWORD
	Prosz sprbowa ponownie z trudniejszym hasem. 
	Haso powinno mie minimum 5 znakw oraz powinno 
	zawiera cyfry i litery.
PASSWORD_TRUNCATED
	Informacja: Twoje haso zostao skrcone 
	do %d znakw.

NICK_NOT_REGISTERED
	Twj nick jest niezarejestrowany.
NICK_NOT_REGISTERED_HELP
	Twj nick jest niezarejestrowany. 
	Napisz %R%s HELP aby uzyska pomoc na
	temat rejestracji Twojego nicka.
NICK_X_IS_SERVICES
	Nick %s jest czci serwisw sieci.
NICK_X_NOT_REGISTERED
	Nick %s jest niezarejestrowany.
NICK_X_IN_USE
	Nick %s jest aktualnie uywany.
NICK_X_NOT_IN_USE
	Nick %s nie jest aktualnie uywany.
NICK_X_NOT_ON_CHAN
	%s nie jest aktualnie na kanale %s.
NICK_X_FORBIDDEN
	Nick %s nie moe by rejestrowany lub uywany.
NICK_X_FORBIDDEN_OPER
	Nick %s zosta porzucony przez %s:
	%s
NICK_X_ILLEGAL
	Nick %s jest nieprawidowy i nie 
	moe by uyty.
NICK_X_TRUNCATED
	Nick %s zosta skrcony do %d znakw.
NICK_X_SUSPENDED
	Nick %s is currently suspended.
CHAN_X_NOT_REGISTERED
	Kana %s jest niezarejestrowany.
CHAN_X_NOT_IN_USE
	Kana %s nie istnieje.
CHAN_X_FORBIDDEN
	Kana %s nie moe by rejestrowany 
	lub uywany.
CHAN_X_FORBIDDEN_OPER
	Kana %s zosta porzucony przez %s:
	%s
CHAN_X_SUSPENDED
	      Zawieszony: [%s] %s
NICK_IDENTIFY_REQUIRED
	Musisz si zidentyfikowa, aby uy tej komendy.
	Napisz %R%s IDENTIFY haso,
	a pniej ponw prb.
CHAN_IDENTIFY_REQUIRED
	Do uycia tej komendy wymagana jest identyfikacja.
	Napisz %R%s IDENTIFY %s haso, 
	a pniej ponw prb.
	
MAIL_DISABLED
	Services s skonfigurowane bez supportu dla 
	wysyania e-maili.
MAIL_INVALID
	E-mail dla %s jest nieprawidowy.
MAIL_X_INVALID
	%s jest nieprawidowym adresem e-mail.
MAIL_LATER
	Nie mog wysa teraz maila. Prosz sprbowa za 
	chwile.
MAIL_DELAYED
	Prosz odczeka %d sekund(y) i ponowi prb.
	
NO_REASON
	Brak powodu.
UNKNOWN
	<nieznane>

# Duration system
DURATION_DAY
	1 dzie
DURATION_DAYS
	%d dni
DURATION_HOUR
	1 godzin(y)
DURATION_HOURS
	%d godzin
DURATION_MINUTE
	1 minuta
DURATION_MINUTES
	%d minut(y)
DURATION_SECOND
	1 sekunda
DURATION_SECONDS
	%d sekund(y)

# Human readable expiration
NO_EXPIRE
	nie wygasa
EXPIRES_SOON
	wygasa przy nastpnej aktualizacji baz
EXPIRES_M
	wygasa za %d minut(y)
EXPIRES_1M
	wygasa za %d minut(y)
EXPIRES_HM
	wygasa za %d godzin(y) i %d minut(y)
EXPIRES_H1M
	wygasa za %d godzin(y) i %d minuty
EXPIRES_1HM
	wygasa za %d godzin(y) i %d minut(y)
EXPIRES_1H1M
	wygasa za %d godzin i %d minut(y)
EXPIRES_D
	wygasa za %d dni
EXPIRES_1D
	wygasa za %d dzie

# Generic Footer message
END_OF_ANY_LIST
	Koniec listy %s.

###########################################################################
#
# Komunikaty NickServ
#
###########################################################################

# Automatic messages
LIST_INCORRECT_RANGE
	Incorrect range specified. The correct syntax is #from-to.
CS_LIST_INCORRECT_RANGE
	To search for channels starting with #, search for the channel
	name without the #-sign prepended (anope instead of #anope).

###########################################################################
#
# NickServ messages
#
###########################################################################

# Automatic messages
HELP_LIMIT_SERV_OPER
	Limited to Services Operators.
HELP_LIMIT_SERV_ADMIN
	Limited to Services Administrators.
HELP_LIMIT_SERV_ROOT
	Limited to Services Roots.
HELP_LIMIT_IRC_OPER
	Limited to IRC Operators.
HELP_LIMIT_HOST_SETTER
	Limited to Host Setters.
HELP_LIMIT_HOST_REMOVER
	Limited to Host Removers.


###########################################################################
#
# NickServ messages
#
###########################################################################

# Automatic messages
NICK_IS_REGISTERED
	Ten nick jest zarejestrowany. Jeli to Twj nick, 
	wpisz: %R%s IDENTIFY haso
NICK_IS_SECURE
	Ten nick jest zarejestrowany i pod ochron.
	Jeli jest to Twj nick zidentyfikuj si 
	piszc: %R%s IDENTIFY haso. 
	Jeli ten nick nie naley do Ciebie, zmie go.
NICK_MAY_NOT_BE_USED
	Ten nick nie moe by uywany. Wybierz inny nick. 
FORCENICKCHANGE_IN_1_MINUTE
	Ostrzegam, e jeli nie zmienisz nicka w cigu 1 
	minuty, zostanie Ci on zmieniony si. 
FORCENICKCHANGE_IN_20_SECONDS
	Ostrzegam, e jeli nie zmienisz nicka w cigu 20 
	sekund, zostanie Ci on zmieniony si.
FORCENICKCHANGE_NOW
	Ten nick zosta zarejestrowany i nie moesz go uy.
FORCENICKCHANGE_CHANGING
	Twj nick zosta zmieniony na %s.

# REGISTER responses
NICK_REGISTER_SYNTAX
	REGISTER haso [email]
NICK_REGISTER_SYNTAX_EMAIL
	REGISTER haso email
NICK_REGISTRATION_DISABLED
	Bd, rejestracja tymczasowo niedostpna.
NICK_REGISTRATION_FAILED
	Bd, rejestracja nieudana.
NICK_REG_PLEASE_WAIT
	Prosz odczeka %d sekund przed ponownym uyciem 
	komendy REGISTER.
NICK_CANNOT_BE_REGISTERED
	Nick %s nie moe by rejestrowany.
NICK_ALREADY_REGISTERED
	Nick %s jest ju zarejestrowany!
NICK_REGISTERED
	Nick %s zosta teraz zarejestrowany dla 
	Ciebie z mask: %s.
NICK_REGISTERED_NO_MASK
	Nickname %s registered.
NICK_PASSWORD_IS
	Twoje haso nicka to %s
	Zapamitaj je do przyszego uytku.
NICK_REG_DELAY
	Musisz by poczony(a) duej ni %d sekund(y), 
	aby mc zarejestrowa nick.

# GROUP responses
NICK_GROUP_SYNTAX
	GROUP nazwa haso 
NICK_GROUP_DISABLED
	Bd, grupowanie nickw jest tymczasowo niedostpne.
NICK_GROUP_FAILED
	Bd, groupowanie nieudane.
NICK_GROUP_PLEASE_WAIT
	Prosz odczeka %d sekund przed ponownym uyciem 
	komendy GROUP.
NICK_GROUP_CHANGE_DISABLED
	Twj nick jest ju zarejestrowany. 
	Napisz wpierw: %R%s DROP 
NICK_GROUP_SAME
	Naleysz ju do grupy %s.
NICK_GROUP_TOO_MANY
	Jest zbyt duo nickw w Twojej grupie: %s. 
	Prosz sprawdzi i usun cz z nich.
	Napisz %R%s HELP GLIST oraz 
	%R%s HELP DROP,
	aby uzyska wicej informacji.
NICK_GROUP_JOINED
	Naleysz od teraz do grupy %s.

# IDENTIFY responses
NICK_IDENTIFY_SYNTAX
	IDENTIFY haso
NICK_IDENTIFY_FAILED
	Bd, identyfikacja nieudana.
NICK_IDENTIFY_SUCCEEDED
	Haso przyjte. 
	Od teraz jeste zidentyfikowany(a).
NICK_IDENTIFY_EMAIL_REQUIRED
	Musisz teraz ustawi adres e-mail przy Twoim nicku.
	Gdy zapomnisz hasa, zostanie ono wysane na e-mail.
NICK_IDENTIFY_EMAIL_HOWTO
	Napisz %R%S SET EMAIL e-mail, 
	aby ustawi adres e-mail. Twj e-mail jest pod 
	ochron - nie bdzie wyjawiany osobom trzecim,
	ani nie bdzie uywany do celw innych ni na 
	potrzeby Twojego nicka.
NICK_ALREADY_IDENTIFIED
	Jeste ju zidentyfikowany(a).

# UPDATE responses
NICK_UPDATE_SUCCESS
	Zaktualizowano (memosy, vhosty, chanmody, flagi).
	
# LOGOUT responses
NICK_LOGOUT_SYNTAX
	LOGOUT
NICK_LOGOUT_SUCCEEDED
	Twj nick zosta pomylnie wylogowany.
NICK_LOGOUT_X_SUCCEEDED
	Nick %s zosta wylogowany.
NICK_LOGOUT_SERVICESADMIN
	Nie mog wylogowa %s poniewa jest 
	Administratorem Serwisw.

# DROP responses
NICK_DROP_DISABLED
	Bd, odrejestrowywanie nickw jest tymczasowo 
	niedostpne.
NICK_DROPPED
	Twj nick zosta odrejestrowany.
NICK_X_DROPPED
	Nick %s zosta odrejestrowany.

# SET responses
NICK_SET_SYNTAX
	SET opcja parametr
NICK_SET_SERVADMIN_SYNTAX
	SET [nick] opcja parametr
NICK_SET_DISABLED
	Bd, modyfikowanie ustawie nicka jest tymczasowo 
	niedostpne.
NICK_SET_UNKNOWN_OPTION
	Nieznana opcja komendy SET %s.
NICK_SET_UNKNOWN_OPTION_OR_BAD_NICK
	Nieznana opcja komendy SET %s, 
	lub ten nick jest niezarejestrowany.
NICK_SET_OPTION_DISABLED
	Opcja %s jest niedostpna na tej sieci.

# SET DISPLAY responses
NICK_SET_DISPLAY_INVALID
	Nowa nazwa MUSI by nickiem z Twojej grupy nickw!
NICK_SET_DISPLAY_CHANGED
	Nowa nazwa to teraz %s.

# SET PASSWORD responses
NICK_SET_PASSWORD_FAILED
	Nie mona zmieni hasa.
NICK_SET_PASSWORD_CHANGED
	Haso zostao zmienione.
NICK_SET_PASSWORD_CHANGED_TO
	Haso zostao zmienione na %s.

# SET LANGUAGE responses
NICK_SET_LANGUAGE_SYNTAX
	SET LANGUAGE numer
NICK_SET_LANGUAGE_UNKNOWN
	Nieznany numer jzyka %d. 
	Napisz %R%s HELP SET LANGUAGE, 
	aby uzyska liste dostpnych jzykw.
NICK_SET_LANGUAGE_CHANGED
	Jzyk zosta zmieniony na Polski.

# SET URL responses
NICK_SET_URL_CHANGED
	Adres WWW zosta zmieniony na %s.
NICK_SET_URL_UNSET
	Adres WWW zosta usunity.

# SET EMAIL responses
NICK_SET_EMAIL_CHANGED
	Adres email zosta zmieniony na %s.
NICK_SET_EMAIL_UNSET
	Adres email usunito.
NICK_SET_EMAIL_UNSET_IMPOSSIBLE
	Nie moesz usuwa adresu email na tej sieci.
	
# SET ICQ responses
NICK_SET_ICQ_CHANGED
	Numer ICQ zosta ustawiony na %s.
NICK_SET_ICQ_UNSET
	Numer ICQ zosta usunity.
NICK_SET_ICQ_INVALID
	%s jest nieprawidowym numerem.
	
# SET GREET responses
NICK_SET_GREET_CHANGED
	Wiadomo powitalna zostaa zmieniona na: 
	%s.
NICK_SET_GREET_UNSET
	Wiadomo powitalna zostaa usunita.

# SET PROTECT responses
NICK_SET_KILL_SYNTAX
	SET KILL {ON | QUICK | OFF}
NICK_SET_KILL_IMMED_SYNTAX
	SET KILL {ON | QUICK | IMMED | OFF}
NICK_SET_KILL_ON
	Ochrona jest od teraz aktywna.
NICK_SET_KILL_QUICK
	Ochrona jest od teraz aktywna.
	Dodatkowo posiada opniony czas dziaania.
NICK_SET_KILL_IMMED
	Ochrona jest od teraz aktywna. 
	Dziaa natychmiastowo po prbie uycia tego nicka.
NICK_SET_KILL_IMMED_DISABLED
	Opcja IMMED jest niedostpna dla tej sieci.
NICK_SET_KILL_OFF
	Ochrona jest teraz nieaktywna.

# SET SECURE responses
NICK_SET_SECURE_SYNTAX
	SET SECURE {ON | OFF}
NICK_SET_SECURE_ON
	Opcja bezpieczestwa jest od teraz aktywna.
NICK_SET_SECURE_OFF
	Opcja bezpieczestwa jest od teraz nieaktywna.

# SET PRIVATE responses
NICK_SET_PRIVATE_SYNTAX
	SET PRIVATE {ON | OFF}
NICK_SET_PRIVATE_ON
	Opcja prywatnoci jest od teraz aktywna.
NICK_SET_PRIVATE_OFF
	Opcja prywatnoci jest od teraz nieaktywna.

# SET HIDE responses
NICK_SET_HIDE_SYNTAX
	SET HIDE {EMAIL | USERMASK | QUIT} {ON | OFF}
NICK_SET_HIDE_EMAIL_ON
	Twj adres e-mail bdzie od teraz ukrywany dla listy 
	INFO w %s.
NICK_SET_HIDE_EMAIL_OFF
	Twj adres e-mail bdzie od teraz pokazywany w 
	licie INFO w %s.
NICK_SET_HIDE_MASK_ON
	Twj ostatnio widziany ident@host bdzie od teraz 
	ukrywany dla listy INFO w %s.
NICK_SET_HIDE_MASK_OFF
	Twj ostatnio widziany ident@host bdzie od teraz 
	pokazywany w licie INFO w %s.
NICK_SET_HIDE_QUIT_ON
	Twoja ostatnia wiadomo QUIT bdzie od teraz 
	ukrywana dla listy INFO w %s.
NICK_SET_HIDE_QUIT_OFF
	Twoja ostatnia wiadomo QUIT bdzie od teraz 
	pokazywana w licie INFO w %s.
NICK_SET_HIDE_STATUS_ON
	Twj status dostpu do serwisw bdzie od teraz 
	ukrywany dla listy INFO w %s.
NICK_SET_HIDE_STATUS_OFF
	Twj status dostpu do serwisw bdzie od teraz 
	pokazywany w licie INFO w %s.

# SET MSG responses
NICK_SET_MSG_SYNTAX
	SET PRIVATE {ON | OFF}
NICK_SET_MSG_ON
	Od teraz serwisy bd si z Tob komunikowa przez 
	wiadomoci na priv (query).
NICK_SET_MSG_OFF
	Od teraz serwisy bd si z Tob komunikowa przez 
	wiadomoci notice.

# SET AUTOOP responses
NICK_SET_AUTOOP_SYNTAX
	SET AUTOOP {ON | OFF}
NICK_SET_AUTOOP_ON
	Services will now autoop you in channels.
NICK_SET_AUTOOP_OFF
	Services will no longer autoop you in channels.


# SET NOEXPIRE responses
NICK_SASET_SYNTAX
	SASET nickname option parameters
NICK_SASET_DISABLED
	Sorry, nickname option setting is temporarily disabled.
NICK_SASET_UNKNOWN_OPTION
	Unknown SASET option %s.
NICK_SASET_BAD_NICK
	Nickname %s not registered.
NICK_SASET_OPTION_DISABLED
	Option %s cannot be set on this network.

# SASET DISPLAY responses
NICK_SASET_DISPLAY_INVALID
	The new display for %s MUST be a nickname of the nickname group!
NICK_SASET_DISPLAY_CHANGED
	The new display is now %s.

# SASET PASSWORD responses
NICK_SASET_PASSWORD_FAILED
	Sorry, couldn't change password for %s.
NICK_SASET_PASSWORD_CHANGED
	Password for %s changed.
NICK_SASET_PASSWORD_CHANGED_TO
	Password for %s changed to %s.

# SASET LANGUAGE responses
NICK_SASET_URL_CHANGED
	URL for %s changed to %s.
NICK_SASET_URL_UNSET
	URL %s unset.

# SASET EMAIL responses
NICK_SASET_EMAIL_CHANGED
	E-mail address for %s changed to %s.
NICK_SASET_EMAIL_UNSET
	E-mail address for %s unset.
NICK_SASET_EMAIL_UNSET_IMPOSSIBLE
	You cannot unset the e-mail on this network.
	
# SASET ICQ responses
NICK_SASET_ICQ_CHANGED
	ICQ number for %s set to %s.
NICK_SASET_ICQ_UNSET
	ICQ number for %s unset.
NICK_SASET_ICQ_INVALID
	%s is not a valid number.
	
# SASET GREET responses
NICK_SASET_GREET_CHANGED
	Greet message for %s changed to %s.
NICK_SASET_GREET_UNSET
	Greet message for %s unset.

# SASET PROTECT responses
NICK_SASET_KILL_SYNTAX
	SASET nickname KILL {ON | QUICK | OFF}
NICK_SASET_KILL_IMMED_SYNTAX
	SASET nickname KILL {ON | QUICK | IMMED | OFF}
NICK_SASET_KILL_ON
	Protection is now ON for %s.
NICK_SASET_KILL_QUICK
	Protection is now ON for %s, with a reduced delay.
NICK_SASET_KILL_IMMED
	Protection is now ON for %s, with no delay.
NICK_SASET_KILL_IMMED_DISABLED
	The IMMED option is not available on this network.
NICK_SASET_KILL_OFF
	Protection is now OFF for %s.

# SASET SECURE responses
NICK_SASET_SECURE_SYNTAX
	SASET nickname SECURE {ON | OFF}
NICK_SASET_SECURE_ON
	Secure option is now ON for %s.
NICK_SASET_SECURE_OFF
	Secure option is now OFF for %s.

# SASET PRIVATE responses
NICK_SASET_PRIVATE_SYNTAX
	SASET nickname PRIVATE {ON | OFF}
NICK_SASET_PRIVATE_ON
	Private option is now ON for %s.
NICK_SASET_PRIVATE_OFF
	Private option is now OFF for %s.

# SASET HIDE responses
NICK_SASET_HIDE_SYNTAX
	SET nickname HIDE {EMAIL | USERMASK | QUIT} {ON | OFF}
NICK_SASET_HIDE_EMAIL_ON
	The E-mail address of %s will now be hidden from %s INFO displays.
NICK_SASET_HIDE_EMAIL_OFF
	The E-mail address of %s will now be shown in %s INFO displays.
NICK_SASET_HIDE_MASK_ON
	The last seen user@host mask of %s will now be hidden from %s INFO displays.
NICK_SASET_HIDE_MASK_OFF
	The last seen user@host mask of %s will now be shown in %s INFO displays.
NICK_SASET_HIDE_QUIT_ON
	The last quit message of %s will now be hidden from %s INFO displays.
NICK_SASET_HIDE_QUIT_OFF
	The last quit message of %s will now be shown in %s INFO displays.
NICK_SASET_HIDE_STATUS_ON
	The services access status of %s will now be hidden from %s INFO displays.
NICK_SASET_HIDE_STATUS_OFF
	The services access status of %s will now be shown in %s INFO displays.
	
# SASET MSG responses
NICK_SASET_MSG_SYNTAX
	SSAET nickname PRIVATE {ON | OFF}
NICK_SASET_MSG_ON
	Services will now reply to %s with messages.
NICK_SASET_MSG_OFF
	Services will now reply to %s with notices.

# SET NOEXPIRE responses
NICK_SASET_NOEXPIRE_SYNTAX
	SASET nickname NOEXPIRE {ON | OFF}
NICK_SASET_NOEXPIRE_ON
	Nick %s will not expire.
NICK_SASET_NOEXPIRE_OFF
	Nick %s will expire.

# ACCESS responses
NICK_SASET_AUTOOP_SYNTAX
	SASET nickname AUTOOP {ON | OFF}
NICK_SASET_AUTOOP_ON
	Services will now autoop %s in channels.
NICK_SASET_AUTOOP_OFF
	Services will no longer autoop %s in channels.


# ACCESS responses
NICK_ACCESS_SYNTAX
	ACCESS {ADD | DEL | LIST} [maska]
NICK_ACCESS_ALREADY_PRESENT
	Maska %s jest ju w Twojej licie dostpu.
NICK_ACCESS_REACHED_LIMIT
	Bd, moesz mie tylko %d wpisy(w) listy dostpu 
	dla nicka.
NICK_ACCESS_ADDED
	%s dodano do Twojej listy dostpu.
NICK_ACCESS_NOT_FOUND
	%s nie znaleziono na Twojej licie dostpu.
NICK_ACCESS_DELETED
	%s usunito z Twojej listy dostpu.
NICK_ACCESS_LIST
	Lista dostpu:
NICK_ACCESS_LIST_X
	Lista dostpu dla %s:
NICK_ACCESS_LIST_EMPTY
	Your access list is empty.
NICK_ACCESS_LIST_X_EMPTY
	Access list for %s is empty.

# Status messages
NICK_STATUS_0
	STATUS %s 0
NICK_STATUS_1
	STATUS %s 1
NICK_STATUS_2
	STATUS %s 2
NICK_STATUS_3
	STATUS %s 3

# INFO responses
NICK_INFO_SYNTAX
	INFO nick [ALL]
NICK_INFO_REALNAME
	%s to %s
NICK_INFO_SERVICES_OPER
	%s to operator serwisw.
NICK_INFO_SERVICES_ADMIN
	%s to administrator serwisw.
NICK_INFO_SERVICES_ROOT
	%s to gwny admin serwisw.
NICK_INFO_ADDRESS
	Ostatni host: %s
NICK_INFO_ADDRESS_ONLINE
	Jest online z: %s
NICK_INFO_ADDRESS_ONLINE_NOHOST
	%s jest w tej chwili online.
NICK_INFO_TIME_REGGED
	Data rejestracji: %s
NICK_INFO_LAST_SEEN
	Ostatnio widziano: %s
NICK_INFO_LAST_QUIT
	Ostatni QUIT: %s
NICK_INFO_URL
	URL: %s
NICK_INFO_EMAIL
	Adres e-mail: %s
NICK_INFO_VHOST
	vhost: %s
NICK_INFO_VHOST2
	vhost: %s@%s
NICK_INFO_ICQ
	Numer ICQ: %d
NICK_INFO_GREET
	Wiadomo powitalna: %s
NICK_INFO_OPTIONS
	Opcje: %s
NICK_INFO_EXPIRE
	Expires in: %s
# These strings MUST NOT be empty
NICK_INFO_OPT_KILL
	Chroniony
NICK_INFO_OPT_SECURE
	Zabezpieczony
NICK_INFO_OPT_PRIVATE
	Prywatny
NICK_INFO_OPT_MSG
	Komunikacja na priv
NICK_INFO_OPT_AUTOOP
	Auto-op
NICK_INFO_OPT_NONE
	Brak
NICK_INFO_NO_EXPIRE
	Ten nick nie podlega prawu wygasania.
NICK_INFO_FOR_MORE
	Aby uzyska jeszcze wicej informacji, 
	napisz %R%s INFO %s ALL.

# LIST responses
NICK_INFO_SUSPENDED
	This nickname is currently suspended, reason: %s
NICK_INFO_SUSPENDED_NO_REASON
	This nickname is currently suspended

# LIST responses
NICK_LIST_SYNTAX
	LIST wzr
NICK_LIST_SERVADMIN_SYNTAX
	LIST wzr [FORBIDDEN] [NOEXPIRE] [UNCONFIRMED]
NICK_LIST_HEADER
	Lista pasujcych wpisw %s:
NICK_LIST_RESULTS
	Koniec listy - %d/%d wpisw wywietlono.

# ALIST responses
NICK_ALIST_SYNTAX
	ALIST nick
NICK_ALIST_HEADER
	Kanay, na ktrych jeste na licie dostpu:
	  Nr   Kana              Poziom    Opis 
NICK_ALIST_HEADER_X
	Kanay, na ktrych %s jest na licie dostpu:
	  Nr   Kana              Poziom    Opis
NICK_ALIST_XOP_FORMAT
	  %3d %c%-20s %-8s %s
NICK_ALIST_ACCESS_FORMAT
	  %3d %c%-20s %-8d %s
NICK_ALIST_FOOTER
	Koniec listy - %d/%d kanaw pokazano.

# GLIST responses
NICK_GLIST_HEADER
	Lista czonkw w Twojej grupie:
NICK_GLIST_HEADER_X
	Lista czonkw grupy %s:
NICK_GLIST_FOOTER
	%d czonkw w grupie.
NICK_GLIST_REPLY
	   %c%s
NICK_GLIST_REPLY_ADMIN
	   %c%s (expires in %s)

# RECOVER responses
NICK_RECOVER_SYNTAX
	RECOVER nick [haso]
NICK_NO_RECOVER_SELF
	Nie moesz sobie samemu odzyska nicka :P
NICK_RECOVERED
	Twj nick zosta wanie przejty przez serwisy.
	Napisz %R%s RELEASE %s 
	jeli chcesz, by zosta on zwolniony teraz.

# RELEASE responses
NICK_RELEASE_SYNTAX
	RELEASE nick [haso]
NICK_RELEASE_NOT_HELD
	Nie trzymam nicka %s
NICK_RELEASED
	Serwisy wanie zwolniy nicka na Twoje danie.

# GHOST responses
NICK_GHOST_SYNTAX
	GHOST nick [haso]
NICK_NO_GHOST_SELF
	Nie moesz takich rzeczy robi.
NICK_GHOST_KILLED
	Nick zosta usunity z sieci.

# GETPASS responses
NICK_GETPASS_SYNTAX
	GETPASS nick
NICK_GETPASS_UNAVAILABLE
	Komenda GETPASS jest niedostpna poniewa hasa s 
	szyfrowane.
NICK_GETPASS_PASSWORD_IS
	Haso dla %s to %s.

# GETEMAIL responses
NICK_GETEMAIL_SYNTAX
	GETEMAIL user@email-host 
NICK_GETEMAIL_EMAILS_ARE
	Adresy e-mail %s pasujce do %s.
NICK_GETEMAIL_NOT_USED
	Brak listy e-mail dla %s.
	
# SENDPASS responses
NICK_SENDPASS_SYNTAX
	SENDPASS nick
NICK_SENDPASS_UNAVAILABLE
	Komenda SENDPASS jest niedostpna poniewa hasa s 
	szyfrowane.
NICK_SENDPASS_SUBJECT
	Haso nicka (%s)
NICK_SENDPASS_HEAD
	Witaj,
NICK_SENDPASS_LINE_1
	Zarzdae(a) przypomnenia hasa do Twojego nicka %s 
	na e-mail.
NICK_SENDPASS_LINE_2
	Twoje haso to: %s 
	Ze wzgldw bezpieczestwa zalecana jest natychmiastowa 
	zmiana  tego hasa na inne zaraz po identyfikacji.
NICK_SENDPASS_LINE_3
	Jeli nie wiesz dlaczego ta wiadomo dotara do Ciebie
	to zignoruj j. Jeli ta sytuacja bdzie si powtarza, 
	skontaktuj si z ircoperatorem sieci.
NICK_SENDPASS_LINE_4
	Prosz nie odpowiada na t wiadomo.
NICK_SENDPASS_LINE_5
	Z wyrazami szacunku, 
	Administratorzy %s.
NICK_SENDPASS_OK
	Haso do %s zostao wysane.

# FORBID responses
NICK_SUSPEND_SYNTAX
	SUSPEND nickname reason
NICK_SUSPEND_SUCCEEDED
	Nick %s is now suspended.
NICK_SUSPEND_FAILED
	Couldn't suspend nick %s!

# UNSUSPEND responses
NICK_UNSUSPEND_SYNTAX
	UNSUSPEND nickname
NICK_UNSUSPEND_SUCCEEDED
	Nick %s is now released.
NICK_UNSUSPEND_FAILED
	Couldn't release nick %s!

# FORBID responses
NICK_FORBID_SYNTAX
	FORBID nick [powd]
NICK_FORBID_SYNTAX_REASON
	FORBID nick powd
NICK_FORBID_SUCCEEDED
	Nick %s zosta porzucony.
NICK_FORBID_FAILED
	Nie mog porzuci nicka %s!

# Nick Registraion responses
NICK_REQUESTED
	Ten nick zosta ju zarejestrowany. Sprawd swoj 
	poczte.
NICK_REG_RESENT
	Twj kod rejestracyjny zosta ponownie wysany 
	na %s.
NICK_REG_UNABLE
	Nick niezarejestrowany. Prosz sprbowa pniej.
NICK_IS_PREREG
	Ten nick czeka na email z kodem weryfikacyjnym 
	przed zakoczeniem rejestracji.
NICK_ENTER_REG_CODE
	Kod zosta wysany na %s. 
	Napisz %R%s confirm <kod>, 
	aby dokoczy procedure rejestracji.
NICK_CONFIRM_NOT_FOUND
	Termin wanoci kodu rejestrcyjnego upyn. 
	Napisz: "%R%s REGISTER <password> <email>",
	aby znowu zacz rejestracje.
NICK_CONFIRM_INVALID
	Podano nieprawidowy kod. Prosz sprawdzi e-mail 
	i sprbowa ponownie.
NICK_REG_MAIL_SUBJECT
	Rejestracja nicka (%s)
NICK_REG_MAIL_HEAD
	Witaj,
NICK_REG_MAIL_LINE_1
	Chcesz zarejestrowa sobie nastpujcy nick: %s.
NICK_REG_MAIL_LINE_2
	Prosz napisa na IRC " %R%s confirm %s " aby dokoczy 
	rejestracje.
NICK_REG_MAIL_LINE_3
	Jeli nie wiesz dlaczego ta wiadomo dotara do Ciebie to 
	zignoruj j. Jeli ta sytuacja bdzie si powtarza, skontaktuj 
	si z ircoperatorem sieci.		
NICK_REG_MAIL_LINE_4
	Prosz nie odpowiada na t wiadomo.
NICK_REG_MAIL_LINE_5
	Z wyrazami szacunku,
	Administratorzy %s.
NICK_GETPASS_PASSCODE_IS
	Kod rejestracyjny dla %s to %s.
NICK_FORCE_REG
	Nick %s potwierdzony.



###########################################################################
#
# Komunikaty ChanServ.
#
###########################################################################

# Access level descriptions
CHAN_LEVEL_AUTOOP
	Automatyczny op (@).
CHAN_LEVEL_AUTOVOICE
	Automatyczny voice (+v).
CHAN_LEVEL_AUTOHALFOP
	Automatyczny halfop (+h).
CHAN_LEVEL_AUTOPROTECT
	Automatyczny protect (+a).
CHAN_LEVEL_AUTODEOP
	Automatyczne deopowanie.
CHAN_LEVEL_NOJOIN
	Nie pozwala wej na kana w trybie RESTRICTED.
CHAN_LEVEL_INVITE
	Pozwala uywac komendy INVITE.
CHAN_LEVEL_AKICK
	Pozwala uywa komendy AKICK.
CHAN_LEVEL_SET
	Pozwala modyfikowa ustawienia kanau.
CHAN_LEVEL_CLEAR
	Pozwala uywa komendy CLEAR.
CHAN_LEVEL_UNBAN
	Pozwala uywa komendy UNBAN.
CHAN_LEVEL_OPDEOP
	Pozwala uywa komend OP i DEOP. 
CHAN_LEVEL_ACCESS_LIST
	Pozwala zaglda do kanaowej listy dostpu.
CHAN_LEVEL_ACCESS_CHANGE
	Pozwala zmienia kanaow list dostpu.
CHAN_LEVEL_MEMO
	Pozwala listowa i czyta kanaowe wiadomoci.
CHAN_LEVEL_ASSIGN
	Pozwala stawia i zdejmowa bota.
CHAN_LEVEL_BADWORDS
	Pozwala uywa komendy BADWORDS.
CHAN_LEVEL_NOKICK
	Ochrona przed kopanem za pomoc komendy KICK.
CHAN_LEVEL_FANTASIA
	Pozwala uywa komend FANTASTIC.
CHAN_LEVEL_SAY
	Pozwala uywa komendy SAY i ACT. 
CHAN_LEVEL_GREET
	Wywietla wiadomo powitaln (greeta).
CHAN_LEVEL_VOICEME
	Pozwala zabiera voice(+v) sobie samemu.
CHAN_LEVEL_VOICE
	Pozwala uywa komendy VOICE i DEVOICE.
CHAN_LEVEL_GETKEY
	Pozwala uywa komendy GETKEY.
CHAN_LEVEL_OPDEOPME
	Pozwala zabiera opa(@) sobie samemu/samej.
CHAN_LEVEL_HALFOPME
	Pozwala zabiera halfopa(%) sobie samemu/samej.
CHAN_LEVEL_HALFOP
	Pozwala uywa komendy HALFOP i DEHALFOP.
CHAN_LEVEL_PROTECTME
	Pozwala wcza/wycza ochrone samego siebie.
CHAN_LEVEL_PROTECT
	Pozwala uywa komendy PROTECT i DEPROTECT.
CHAN_LEVEL_KICKME
	Pozwala kopa siebie samego.
CHAN_LEVEL_KICK
	Pozwala uywa komendy KICK.
CHAN_LEVEL_SIGNKICK
	Nie podpisze kicka, gdy SIGNKICK LEVEL jest uywany.
CHAN_LEVEL_BANME
	Pozwala banowa siebie samego.
CHAN_LEVEL_BAN
	Pozwala uywa komendy BAN.
CHAN_LEVEL_TOPIC
	Pozwala uywa komendy TOPIC.
CHAN_LEVEL_INFO
	Pozwala uywa opcji ALL w komendzie INFO.

# Automatic responses
CHAN_IS_REGISTERED
	Tem kana zosta zarejestrowany z %s.
CHAN_NOT_ALLOWED_OP
	Nie masz uprawnie do posiadania statusu operatora 
	na %s.
CHAN_MAY_NOT_BE_USED
	Ten kana nie moe by uywany.
CHAN_NOT_ALLOWED_TO_JOIN
	Nie masz pozwolenia, aby przebywa na tym kanale.

# REGISTER responses
CHAN_X_INVALID
	Channel %s is not a valid channel.

# REGISTER responses
CHAN_REGISTER_SYNTAX
	REGISTER kana haso opis
CHAN_REGISTER_DISABLED
	Bd, rejestracja kanau jest tymczasowo 
	niedostpna.
CHAN_REGISTER_NOT_LOCAL
	Kanay lokalne nie mog by rejestrowane.
CHAN_MUST_REGISTER_NICK
	Musisz mie wpierw zarejestrowany nick. 
	Napisz %R%s HELP, aby uzyska 
	wicej informacji odnonie rejestracji nicka.
CHAN_MUST_IDENTIFY_NICK
	Prosz zidentyfikowa najpierw nicka w %s 
	komend: %R%s IDENTIFY haso
CHAN_MAY_NOT_BE_REGISTERED
	Kana %s nie moe by zarejestrowany.
CHAN_ALREADY_REGISTERED
	Kana %s jest ju zarejestrowany!
CHAN_MUST_BE_CHANOP
	Aby zarejestrowa kana, musisz by jego 
	operatorem (posiada status @).
CHAN_REACHED_CHANNEL_LIMIT
	Bd, ju masz osignity limit %d kanaw.
CHAN_EXCEEDED_CHANNEL_LIMIT
	Bd, ju masz przekroczony limit %d kanaw.
CHAN_REGISTRATION_FAILED
	Bd, rejestracja nieudana.
CHAN_REGISTERED
	Kana %s zosta teraz zarejestrowany. 
	Jako %s jeste od teraz jego wacicielem.
CHAN_PASSWORD_IS
	Haso Twojego kanau to %s 
	Zapamitaj do przyszego uytku.
CHAN_REGISTER_NONE_CHANNEL
	You have attempted to register a nonexistent channel %s
CHAN_SYMBOL_REQUIRED
	Please use the symbol of # when attempting to register


# IDENTIFY responses
CHAN_IDENTIFY_SYNTAX
	IDENTIFY kana haso
CHAN_IDENTIFY_FAILED
	Bd, identyfikacja nieudana.
CHAN_IDENTIFY_SUCCEEDED
	Haso przyjte. 
	Jeste teraz wacicielem(k) kanau %s.

# LOGOUT responses
CHAN_LOGOUT_SYNTAX
	LOGOUT kana nick
CHAN_LOGOUT_SERVADMIN_SYNTAX
	LOGOUT kana [nick]
CHAN_LOGOUT_SUCCEEDED
	Uytkownik %s zosta wylogowany z kanau %s.
CHAN_LOGOUT_ALL_SUCCEEDED
	Wszyscy zidentyfikowani uytkownicy zostali 
	wylogowani z kanau %s.

# DROP responses
CHAN_DROP_SYNTAX
	DROP kana
CHAN_DROP_DISABLED
	Bd, odrejestrowywanie kanaw jest tymczasowo 
	niedostpne.
CHAN_DROPPED
	Kana %s zosta odrejestrowany.

# SET responses
CHAN_SET_SYNTAX
	SET kana opcja parametry
CHAN_SET_DISABLED
	Bd, modyfikowanie ustawie kanau jest tymczasowo
	niedostpne.
CHAN_SET_UNKNOWN_OPTION
	Nieznana opcja komendy SET: %s.

# SET FOUNDER responses
CHAN_SET_FOUNDER_TOO_MANY_CHANS
	%s posiada za duo zarejestrowanych kanaw.
CHAN_FOUNDER_CHANGED
	Zaoycielem %s jest teraz %s.

# SET SUCCESSOR responses
CHAN_SUCCESSOR_CHANGED
	Zastpc dla %s zmieniono na %s.
CHAN_SUCCESSOR_UNSET
	Zastpc dla %s usunito.
CHAN_SUCCESSOR_IS_FOUNDER
	%s nie moe by zastpc na kanale %s 
	poniewa jest ju jego zaoycielem.

# SET PASSWORD responses
CHAN_SET_PASSWORD_FAILED
	Bd, nie mog zmieni hasa.
CHAN_PASSWORD_CHANGED
	Haso %s zostao zmienione.
CHAN_PASSWORD_CHANGED_TO
	Haso %s zostao zmienione na %s.

# SET DESC responses
CHAN_DESC_CHANGED
	Opis kanau %s zosta zmieniony na %s.

# SET URL responses
CHAN_URL_CHANGED
	Adres WWW dla %s zosta zmieniony na %s.
CHAN_URL_UNSET
	Adres WWW dla %s zosta usunity.

# SET EMAIL responses
CHAN_EMAIL_CHANGED
	Adres e-mail dla %s zosta zmieniony na %s.
CHAN_EMAIL_UNSET
	Adres e-mail dla %s zosta usunity.

# SET ENTRYMSG responses
CHAN_ENTRY_MSG_CHANGED
	Wiadomo powitalna %s zostaa zmieniona.
CHAN_ENTRY_MSG_UNSET
	Wiadomo powitalna %s zostaa usunita.
	
# SET BANTYPE responses
CHAN_SET_BANTYPE_INVALID
	%s jest nieprawidowym rodzajem bana.
CHAN_SET_BANTYPE_CHANGED
	Rodzaj bana dla kanau %s to teraz #%d.

# SET MLOCK responses
CHAN_SET_MLOCK_UNKNOWN_CHAR
	Nieznany znak trybu %c.
CHAN_SET_MLOCK_IMPOSSIBLE_CHAR
	Chanmod %c zosta zignorowany poniewa nie 
	moesz go zablokowa.
CHAN_SET_MLOCK_L_REQUIRED
	Musisz zaoy +l zanim zaoysz +L.
CHAN_SET_MLOCK_K_REQUIRED
	Musisz zaoy +i rwnie, aby mc zaoy +K.
CHAN_MLOCK_CHANGED
	Blokada chanmodw kanau %s zostaa zmieniona 
	na tak: %s.

# SET KEEPTOPIC responses
CHAN_SET_KEEPTOPIC_SYNTAX
	SET kana KEEPTOPIC {ON | OFF}
CHAN_SET_KEEPTOPIC_ON
	Topic retention option for %s is now ON.
CHAN_SET_KEEPTOPIC_OFF
	Topic retention option for %s is now OFF.

# SET TOPICLOCK responses
CHAN_SET_TOPICLOCK_SYNTAX
	SET kana TOPICLOCK {ON | OFF}
CHAN_SET_TOPICLOCK_ON
	Topic lock option for %s is now ON.
CHAN_SET_TOPICLOCK_OFF
	Topic lock option for %s is now OFF.

# SET PEACE responses
CHAN_SET_PEACE_SYNTAX
	SET kana PEACE {ON | OFF}
CHAN_SET_PEACE_ON
	Peace option for %s is now ON.
CHAN_SET_PEACE_OFF
	Peace option for %s is now OFF.

# SET PRIVATE responses
CHAN_SET_PRIVATE_SYNTAX
	SET kana PRIVATE {ON | OFF}
CHAN_SET_PRIVATE_ON
	Private option for %s is now ON.
CHAN_SET_PRIVATE_OFF
	Private option for %s is now OFF.

# SET SECUREOPS responses
CHAN_SET_SECUREOPS_SYNTAX
	SET kana SECUREOPS {ON | OFF}
CHAN_SET_SECUREOPS_ON
	Secure ops option for %s is now ON.
CHAN_SET_SECUREOPS_OFF
	Secure ops option for %s is now OFF.

# SET SECUREFOUNDER responses
CHAN_SET_SECUREFOUNDER_SYNTAX
	SET kana SECUREFOUNDER {ON | OFF}
CHAN_SET_SECUREFOUNDER_ON
	Secure founder option for %s is now ON.
CHAN_SET_SECUREFOUNDER_OFF
	Secure founder option for %s is now OFF.

# SET RESTRICTED responses
CHAN_SET_RESTRICTED_SYNTAX
	SET kana RESTRICTED {ON | OFF}
CHAN_SET_RESTRICTED_ON
	Restricted access option for %s is now ON.
CHAN_SET_RESTRICTED_OFF
	Restricted access option for %s is now OFF.

# SET SECURE responses
CHAN_SET_SECURE_SYNTAX
	SET kana SECURE {ON | OFF}
CHAN_SET_SECURE_ON
	Secure option for %s is now ON.
CHAN_SET_SECURE_OFF
	Secure option for %s is now OFF.

# SET SIGNKICK responses
CHAN_SET_SIGNKICK_SYNTAX
	SET kana SIGNKICK {ON | LEVEL | OFF}
CHAN_SET_SIGNKICK_ON
	Signed kick option for %s is now ON.
CHAN_SET_SIGNKICK_LEVEL
	Signed kick option for %s is now ON, but depends of the
	level of the user that is using the command.
CHAN_SET_SIGNKICK_OFF
	Signed kick option for %s is now OFF.

# SET OPNOTICE responses
CHAN_SET_OPNOTICE_SYNTAX
	SET kana OPNOTICE {ON | OFF}
CHAN_SET_OPNOTICE_ON
	Op-notice option for %s is now ON.
CHAN_SET_OPNOTICE_OFF
	Op-notice option for %s is now OFF.

# SET XOP responses
CHAN_SET_XOP_SYNTAX
	SET kana XOP {ON | OFF}
CHAN_SET_XOP_ON
	xOP lists system for %s is now ON.
CHAN_SET_XOP_OFF
	xOP lists system for %s is now OFF.

# SET NOEXPIRE responses
CHAN_SET_NOEXPIRE_SYNTAX
	SET kana NOEXPIRE {ON | OFF}
CHAN_SET_NOEXPIRE_ON
	Kana %s od teraz nie podlega prawu wygasania.
CHAN_SET_NOEXPIRE_OFF
	Kana %s od teraz podlega prawu wygasania.

# xOP messages
CHAN_XOP_REACHED_LIMIT
	Bd, moe by %d AOP/SOP/VOP wpisw na kanale.
CHAN_XOP_LIST_FORMAT
	  %3d  %s
CHAN_XOP_ACCESS
	Nie moesz uy tej komendy. Uyj komendy ACCESS.
	Napisz %R%s HELP ACCESS, 
	aby uzyska wicej informacji.
CHAN_XOP_NOT_AVAILABLE
	xOP system is not available.

# AOP messages
CHAN_AOP_SYNTAX
	AOP kana {ADD|DEL|LIST|CLEAR} [nick | pozycja]
CHAN_AOP_DISABLED
	Bd, modyfikowanie kanaowej listy AOP jest 
	tymczasowo niedostpne.
CHAN_AOP_NICKS_ONLY
	Kanaowa lista AOP moe posiada jedynie 
	zarejestrowane nicki.
CHAN_AOP_ADDED
	%s dodano do listy AOP %s.
CHAN_AOP_MOVED
	%s przeniesiono do listy AOP %s.
CHAN_AOP_NO_SUCH_ENTRY
	Brak wpisu (#%d) na AOP licie %s.
CHAN_AOP_NOT_FOUND
	%s nie znaleziono na AOP licie %s.
CHAN_AOP_NO_MATCH
	Nie znaleziono wpisw w licie AOP %s.
CHAN_AOP_DELETED
	%s usunito z listy AOP %s.
CHAN_AOP_DELETED_ONE
	Usunito 1 wpis z listy AOP %s.
CHAN_AOP_DELETED_SEVERAL
	Usunito %d wpisw(y) z listy AOP %s.
CHAN_AOP_LIST_EMPTY
	Lista AOP %s jest pusta.
CHAN_AOP_LIST_HEADER
	Lista AOP dla %s:
	  Nr   Nick
CHAN_AOP_CLEAR
	Kanaowa %s lista AOP zostaa wyczyszczona.

# HOP messages
CHAN_HOP_SYNTAX
	HOP kana {ADD|DEL|LIST|CLEAR} [nick | pozycja]
CHAN_HOP_DISABLED
	Bd, modyfikowanie kanaowej listy HOP jest 
	tymczasowo niedostpne.
CHAN_HOP_NICKS_ONLY
	Kanaowa lista HOP moe posiada jedynie 
	zarejestrowane nicki.
CHAN_HOP_ADDED
	%s dodano do listy HOP %s.
CHAN_HOP_MOVED
	%s przeniesiono do listy HOP %s.
CHAN_HOP_NO_SUCH_ENTRY
	Brak wpisu (#%d) na licie HOP %s.
CHAN_HOP_NOT_FOUND
	%s nie znaleziono na licie HOP %s.
CHAN_HOP_NO_MATCH
	Nie znaleziono wpisw na licie HOP %s.
CHAN_HOP_DELETED
	%s usunito z listy HOP %s.
CHAN_HOP_DELETED_ONE
	Usunito 1 wpis z listy HOP %s.
CHAN_HOP_DELETED_SEVERAL
	Usunito %d wpisw(y) z listy HOP %s.
CHAN_HOP_LIST_EMPTY
	Lista HOP %s jest pusta.
CHAN_HOP_LIST_HEADER
	Lista HOP dla %s:
	  Nr   Nick
CHAN_HOP_CLEAR
	Kanaowa %s lista HOP zostaa wyczyszczona.

# SOP messages
CHAN_SOP_SYNTAX
	SOP kana {ADD|DEL|LIST|CLEAR} [nick | pozycja]
CHAN_SOP_DISABLED
	Bd, modyfikowanie kanaowej listy SOP jest 
	tymczasowo niedostpne
CHAN_SOP_NICKS_ONLY
	Kanaowa lista SOP moe posiada jedynie 
	zarejestrowane nicki.
CHAN_SOP_ADDED
	%s dodano do listy SOP %s.
CHAN_SOP_MOVED
	%s przeniesiono do listy SOP %s.
CHAN_SOP_NO_SUCH_ENTRY
	Brak wpisu (#%d) na licie SOP %s.
CHAN_SOP_NOT_FOUND
	%s nie znaleziono na licie SOP %s.
CHAN_SOP_NO_MATCH
	Nie znaleziono wpisw na licie SOP %s.
CHAN_SOP_DELETED
	%s usunito z listy SOP %s.
CHAN_SOP_DELETED_ONE
	Usunito 1 wpis z listy SOP %s.
CHAN_SOP_DELETED_SEVERAL
	Usunito %d wpisw(y) z listy SOP %s.
CHAN_SOP_LIST_EMPTY
	Lista SOP %s jest pusta.
CHAN_SOP_LIST_HEADER
	Lista SOP dla %s:
	  Nr   Nick
CHAN_SOP_CLEAR
	Kanaowa %s lista SOP zostaa wyczyszczona.

# VOP messages
CHAN_VOP_SYNTAX
	VOP #kana {ADD|DEL|LIST|CLEAR} [nick | pozycja]
CHAN_VOP_DISABLED
	Bd, modyfikowanie kanaowej listy VOP jest 
	tymczasowo niedostpne.
CHAN_VOP_NICKS_ONLY
	Kanaowa lista VOP moe posiada jedynie 
	zarejestrowane nicki.
CHAN_VOP_ADDED
	%s dodano do listy VOP %s.
CHAN_VOP_MOVED
	%s przeniesiono do listy VOP %s.
CHAN_VOP_NO_SUCH_ENTRY
	Brak wpisu (#%d) na licie VOP %s.
CHAN_VOP_NOT_FOUND
	%s nie znaleziono na licie VOP %s.
CHAN_VOP_NO_MATCH
	Nie znaleziono wpisw na licie VOP %s.
CHAN_VOP_DELETED
	%s usunito z listy VOP %s.
CHAN_VOP_DELETED_ONE
	Usunito 1 wpis z listy VOP %s.
CHAN_VOP_DELETED_SEVERAL
	Usunito %d wpisw(y) z listy VOP %s.
CHAN_VOP_LIST_EMPTY
	Lista VOP %s jest pusta.
CHAN_VOP_LIST_HEADER
	Lista VOP dla %s:
	  Nr   Nick
CHAN_VOP_CLEAR
	Kanaowa %s lista VOP zostaa wyczyszczona.

# ACCESS messages
CHAN_ACCESS_SYNTAX
	ACCESS kana {ADD|DEL|LIST|CLEAR} [nick [poziom] | pozycja]
CHAN_ACCESS_XOP
	Nie moesz uy tej komendy. 
	Musisz uy VOP, HOP, AOP lub SOP.
	Napisz %R%s HELP komenda,
	aby uzyska wicej informacji.
CHAN_ACCESS_XOP_HOP
	You can't use this command. 
	Use the AOP, SOP, HOP and VOP commands instead.
	Type %R%s HELP command for more information.
CHAN_ACCESS_DISABLED
	Bd, modyfikacje kanaowej listy dostpu s 
	tymczasowo niedostpne.
CHAN_ACCESS_LEVEL_NONZERO
	Poziom dostpu nie moe by zerem.
CHAN_ACCESS_LEVEL_RANGE
	Poziom dostpu musi si zawiera pomidzy %d a %d.
CHAN_ACCESS_NICKS_ONLY
	Kanaowa lista dostpu moe zawiera tylko 
	zarejestrowane nicki.
CHAN_ACCESS_REACHED_LIMIT
	Bd, moesz mie tylko %d wpisw na licie dostpu 
	kanau.
CHAN_ACCESS_LEVEL_UNCHANGED
	Poziom dostpu dla %s na %s jest 
	nadany od %d.
CHAN_ACCESS_LEVEL_CHANGED
	Poziom dostpu dla %s na %s zmieniono 
	teraz na %d.
CHAN_ACCESS_ADDED
	%s dodano do listy dostpu %s z 
	poziomem %d.
CHAN_ACCESS_NO_SUCH_ENTRY
	Brak wpisu (#%d) na licie dostpu %s.
CHAN_ACCESS_NOT_FOUND
	%s nie znaleziono na licie dostpu %s.
CHAN_ACCESS_NO_MATCH
	Nie znaleziono wpisw na licie dostpu %s.
CHAN_ACCESS_DELETED
	%s usunito z listy dostpu %s.
CHAN_ACCESS_DELETED_ONE
	Usunito 1 wpis z listy dostpu %s.
CHAN_ACCESS_DELETED_SEVERAL
	Usunito %d wpisw(y) z listy dostpu %s.
CHAN_ACCESS_LIST_EMPTY
	Kanaowa lista dostpu dla %s jest pusta.
CHAN_ACCESS_LIST_HEADER
	Kanaowa lista dostpu dla %s:
	  Nr   Poz  Nick
CHAN_ACCESS_LIST_FOOTER
	Koniec listy dostpu.
CHAN_ACCESS_LIST_XOP_FORMAT
	  %3d   %s  %s
CHAN_ACCESS_LIST_AXS_FORMAT
	  %3d  %4d  %s
CHAN_ACCESS_CLEAR
	Lista dostpu kanau %s zostaa wyczyszczona.

# AKICK responses
CHAN_AKICK_SYNTAX
	AKICK kana {ADD | STICK | UNSTICK | DEL | LIST | VIEW | ENFORCE | CLEAR} [nick-lub-maska] [powd]
CHAN_AKICK_DISABLED
	Bd, modyfikacje kanaowej listy AKICK s 
	tymczasowo niedostpne.
CHAN_AKICK_ALREADY_EXISTS
	%s ju istnije w licie AKICK %s.
CHAN_AKICK_REACHED_LIMIT
	Bd, moesz mie jedynie %d wpisw w licie AKICK 
	kanau.
CHAN_AKICK_ADDED
	%s dodano do listy AKICK kanau %s.
CHAN_AKICK_NO_SUCH_ENTRY
	Brak wpisu (#%d) na licie AKICK %s.
CHAN_AKICK_NOT_FOUND
	%s nie znaleziono na licie AKICK %s.
CHAN_AKICK_NO_MATCH
	Nie znaleziono wpisw na licie AKICK %s.
CHAN_AKICK_STUCK
	%s jest od teraz cay czas aktywny na %s.
CHAN_AKICK_UNSTUCK
	%s jest od teraz nie zawsze aktywny na %s.
CHAN_AKICK_DELETED
	%s usunito z listy AKICK %s.
CHAN_AKICK_DELETED_ONE
	Usunito 1 wpis z listy AKICK %s.
CHAN_AKICK_DELETED_SEVERAL
	Usunito %d wpisw z listy AKICK %s.
CHAN_AKICK_LIST_EMPTY
	Lista AKICK kanau %s jest pusta.
CHAN_AKICK_LIST_HEADER
	Lista AKICK dla kanau %s:
CHAN_AKICK_LIST_FORMAT
	  %3d %s (%s)
CHAN_AKICK_VIEW_FORMAT
	%3d %s (przez %s na %s)
	    %s
CHAN_AKICK_VIEW_FORMAT_STUCK
	%3d %s (zablokowany) (przez %s na %s)
	    %s
CHAN_AKICK_ENFORCE_DONE
	Egzekucja listy AKICK %s zakoczona. 
	Wyegzekwowano %d uytkownikw.
CHAN_AKICK_CLEAR
	Lista AKICK kana %s zostaa wyczyszczona.

# LEVELS responses
CHAN_LEVELS_SYNTAX
	LEVELS kana {SET | DIS[ABLE] | LIST | RESET} [rzecz [poziom]]
CHAN_LEVELS_XOP
	Ta komenda jest nieuyteczna w tym trybie.
CHAN_LEVELS_RANGE
	Poziom musi si zawiera pomidzy %d a %d.
CHAN_LEVELS_CHANGED
	Wymagany poziom dla %s 
	na kanale %s zmieniono teraz na %d.
CHAN_LEVELS_UNKNOWN
	Ustawienie %s jest nieznane. 
	Napisz %R%s HELP LEVELS DESC, 
	aby uzyska liste dostpnych moliwoci.
CHAN_LEVELS_DISABLED
	%s wyczono na kanale %s.
CHAN_LEVELS_LIST_HEADER
	Ustawienia poziomw dostpu na %s:
CHAN_LEVELS_LIST_DISABLED
	    %-*s  (wyczony)
CHAN_LEVELS_LIST_FOUNDER
	    %-*s  (tylko waciciel)
CHAN_LEVELS_LIST_NORMAL
	    %-*s  %d
CHAN_LEVELS_RESET
	Poziomy dostpu na %s zostay zresetowane do 
	domylnych.

# Status Messages
CHAN_STATUS_SYNTAX
	STATUS ERROR Syntax error
CHAN_STATUS_NOT_REGGED
	STATUS ERROR Channel %s not registered
CHAN_STATUS_FORBIDDEN
	STATUS ERROR Channel %s forbidden
CHAN_STATUS_NOTONLINE
	STATUS ERROR Nick %s not online
CHAN_STATUS_INFO
	STATUS %s %s %d

# INFO responses
CHAN_INFO_SYNTAX
	INFO kana [ALL]
CHAN_INFO_HEADER
	Informacje o kanale %s:
CHAN_INFO_FOUNDER
	Waciciel: %s (%s)
CHAN_INFO_NO_FOUNDER
	Waciciel: %s
CHAN_INFO_SUCCESSOR
	Zastpca: %s (%s)
CHAN_INFO_NO_SUCCESSOR
	Zastpca: %s
CHAN_INFO_DESCRIPTION
	Opis: %s
CHAN_INFO_ENTRYMSG
	Wiadomo powitalna: %s
CHAN_INFO_TIME_REGGED
	Zarejestrowano: %s
CHAN_INFO_LAST_USED
	Ostatnio uywany: %s
CHAN_INFO_LAST_TOPIC
	Ostatni topic: %s
CHAN_INFO_TOPIC_SET_BY
	Topic ustawiony przez: %s
CHAN_INFO_URL
	Adres WWW: %s
CHAN_INFO_EMAIL
	Adres e-mail: %s
CHAN_INFO_BANTYPE
	Typ bana: %d
CHAN_INFO_OPTIONS
	Opcje: %s
CHAN_INFO_OPT_KEEPTOPIC
	Podtrzymywanie topicu
CHAN_INFO_OPT_OPNOTICE
	OP-Komunikaty
CHAN_INFO_OPT_PEACE
	Opcja PEACE
CHAN_INFO_OPT_PRIVATE
	Prywatny
CHAN_INFO_OPT_RESTRICTED
	Dostp restrykcyjny
CHAN_INFO_OPT_SECURE
	Opcja SECURE
CHAN_INFO_OPT_SECUREOPS
	Opcja SECUREOPS
CHAN_INFO_OPT_SECUREFOUNDER
	Opcja SECUREFOUNDER
CHAN_INFO_OPT_SIGNKICK
	Opcja SIGNKICK
CHAN_INFO_OPT_TOPICLOCK
	Opcja TOPICLOCK
CHAN_INFO_OPT_XOP
	System listy dostpu xOP
CHAN_INFO_OPT_NONE
	Brak
CHAN_INFO_MODE_LOCK
	Zablokowane tryby: %s
CHAN_INFO_EXPIRE
	      Expires in: %s
CHAN_INFO_NO_EXPIRE
	Ten kana nie podlega prawu wygasania.

# LIST responses
CHAN_LIST_SYNTAX
	LIST wzr
CHAN_LIST_SERVADMIN_SYNTAX
	LIST wzr [FORBIDDEN] [SUSPENDED] [NOEXPIRE]
CHAN_LIST_HEADER
	Lista pasujcyh wpisw %s:
CHAN_LIST_FORMAT
	    %-20s  %s
CHAN_LIST_END
	Koniec listy - %d/%d wpisw znalezionych.
	
# INVITE responses
CHAN_INVITE_SYNTAX
	INVITE kana

# UNBAN responses
CHAN_UNBAN_SYNTAX
	UNBAN kana
CHAN_UNBANNED
	Odbanowaem Cie na %s.

# TOPIC responses
CHAN_TOPIC_SYNTAX
	TOPIC kana [temat]

# CLEAR responses
CHAN_CLEAR_SYNTAX
	CLEAR kana co
CHAN_CLEARED_BANS
	Wszystkie bany na %s zostay wyczyszczone.
CHAN_CLEARED_EXCEPTS
	Wszystkie wyjtki na %s zostay wyczyszczone.
CHAN_CLEARED_MODES
	Wszystkie tryby na %s zostay zresetowane.
CHAN_CLEARED_OPS
	Tryby +o zostay wyczyszczone na %s.
CHAN_CLEARED_HOPS
	Tryby +h zostay wyczyszczone na %s.
CHAN_CLEARED_VOICES
	Tryby +v zostay wyczyszczone na %s.
CHAN_CLEARED_USERS
	Wszyscy uytkownicy zostali wykopani z %s.
CHAN_CLEARED_INVITES
	All invites on channel %s have been removed.

# GETPASS responses
CHAN_GETPASS_SYNTAX
	GETPASS kana
CHAN_GETPASS_UNAVAILABLE
	Komenda GETPASS jest niedostpna poniewa hasa s 
	szyfrowane.
CHAN_GETPASS_PASSWORD_IS
	Haso kanau %s to %s.
	
# SENDPASS responses
CHAN_GETKEY_SYNTAX
	GETKEY channel
CHAN_GETKEY_NOKEY
	The channel %s has no key.
CHAN_GETKEY_KEY
	Key for channel %s is %s.

# SENDPASS responses
CHAN_SENDPASS_SYNTAX
	SENDPASS kana
CHAN_SENDPASS_UNAVAILABLE
	Komenda SENDPASS jest niedostpna poniewa hasa s 
	szyfrowane.
CHAN_SENDPASS_SUBJECT
	Haso kanau (%s)
CHAN_SENDPASS_HEAD
	Witaj,
CHAN_SENDPASS_LINE_1
	Zarzdae(a) wysania hasa kanau %s na e-mail.
CHAN_SENDPASS_LINE_2
	Twoje haso to: %s. 
	Dla wasnego bezpieczestwa naley to haso natychmiast 
	zmieni na inne.
CHAN_SENDPASS_LINE_3
	Jeli nie wiesz dlaczego ta wiadomo dotara do Ciebie 
	to zignoruj j. Jeli ta sytuacja bdzie si powtarza, 
	skontaktuj si z ircoperatorem sieci.
CHAN_SENDPASS_LINE_4
	Prosz nie odpowiada na t wiadomo.
CHAN_SENDPASS_LINE_5
	Z wyrazami szacunku,
	Administratorzy %s.
CHAN_SENDPASS_OK
	Haso do %s zostao wysane.

# FORBID responses
CHAN_FORBID_SYNTAX
	FORBID kana [powd]
CHAN_FORBID_SYNTAX_REASON
	FORBID kana powd
CHAN_FORBID_SUCCEEDED
	Kana %s zosta teraz porzucony.
CHAN_FORBID_FAILED
	Nie mog porzuci kanau %s!
CHAN_FORBID_REASON
	Ten kana zosta porzucony.

# SUSPEND responses
CHAN_SUSPEND_SYNTAX
	SUSPEND kana [powd]
CHAN_SUSPEND_SYNTAX_REASON
	SUSPEND kana powd
CHAN_SUSPEND_SUCCEEDED
	Kana %s zosta teraz zawieszony.
CHAN_SUSPEND_FAILED
	Nie moge zawiesi kanau %s!
CHAN_SUSPEND_REASON
	Ten kana zosta zawieszony.

# UNSUSPEND responses
CHAN_UNSUSPEND_SYNTAX
	UNSUSPEND kana
CHAN_UNSUSPEND_ERROR
	Nie znaleziono znaku # na pocztku nazwy kanau.
CHAN_UNSUSPEND_SUCCEEDED
	Kana %s jest od teraz ju wolny.
CHAN_UNSUSPEND_FAILED
	Nie moge zwolni kanau %s!

# Misc responses
CHAN_EXCEPTED
	%s posiada wyjtek na %s i nie moe by 
	zbanowany pki nie zostanie usunity.

###########################################################################
#
# Komunikaty MemoServ.
#
###########################################################################

# Automatic messages
MEMO_HAVE_NEW_MEMO
	Masz 1 now wiadomo.
MEMO_HAVE_NEW_MEMOS
	Masz %d nowe(ych) wiadomoci.
MEMO_TYPE_READ_LAST
	Napisz %R%s READ LAST aby przeczyta.
MEMO_TYPE_READ_NUM
	Napisz %R%s READ %d aby przeczyta.
MEMO_TYPE_LIST_NEW
	Napisz %R%s LIST NEW,
	aby zobaczy liste nowych wiadomoci.
MEMO_AT_LIMIT
	Uwaga: Osignito ju limit wiadomoci (%d). 
	Nie bdziesz mg(moga) odebra adnej nowej dopki 
	nie usuniesz czci starych.
MEMO_OVER_LIMIT
	Uwaga: Ju masz skoczony limit maksymalny 
	iloci wiadomoci (%d). 
	Nie bdziesz mg(moga) odebra adnej nowej dopki 
	nie usuniesz czci starych.
MEMO_X_MANY_NOTICE
	Jest %d wiadomoci dla kanau %s.
MEMO_X_ONE_NOTICE
	Jest %d wiadomo dla kanu %s.
MEMO_NEW_X_MEMO_ARRIVED
	Jest nowa wiadomo dla kanau %s.
	Napisz %R%s READ %s %d aby j przeczyta.
MEMO_NEW_MEMO_ARRIVED
	Nasz now wiadomo od %s.
	Napisz %R%s READ %d aby j przeczyta.

# Multi-use responses
MEMO_HAVE_NO_MEMOS
	Nie masz wiadomoci.
MEMO_X_HAS_NO_MEMOS
	%s nie ma wiadomoci.
MEMO_DOES_NOT_EXIST
	Wiadomo %d nie istnieje!
MEMO_LIST_NOT_FOUND
	Nie znaleziono pasujcych wiadomoci.

# SEND responses
MEMO_SEND_SYNTAX
	SEND {nick | kana} tre
MEMO_SEND_DISABLED
	Bd, wysyanie wiadomoci jest tymczasowo niedostpne.
MEMO_SEND_PLEASE_WAIT
	Prosze odczeka %d sekund(y) przed ponownym uyciem
	komendy SEND.
MEMO_X_GETS_NO_MEMOS
	%s nie moe odbiera wiadomoci.
MEMO_X_HAS_TOO_MANY_MEMOS
	%s ma w tej chwili zbyt duo wiadomoci i nie moe
	odbiera nowych.
MEMO_SENT
	Wiadomo do %s zostaa wysana.
MEMO_MASS_SENT
	Wiadomo globalna zostaa wysana do wszystkich 
	zarejestrowanych uytkownikw.
	
# CANCEL responses
MEMO_CANCEL_SYNTAX
	CANCEL {nick | kana}
MEMO_CANCEL_DISABLED
	Bd, odwoywanie wiadomoci jest tymczasowo 
	niedostpne.
MEMO_CANCEL_NONE
	Nie ma wiadomoci odwoanej.
MEMO_CANCELLED
	Ostatnia wiadomo do %s zostaa odwoana.

# LIST responses
MEMO_LIST_SYNTAX
	LIST [kana] [list | NEW]
MEMO_HAVE_NO_NEW_MEMOS
	Nie masz nowych wiadomoci.
MEMO_X_HAS_NO_NEW_MEMOS
	%s nie ma nowych wiadomoci.
MEMO_LIST_MEMOS
	Wiadomoci dla %s. Aby przeczyta, 
	napisz: %R%s READ numer
MEMO_LIST_NEW_MEMOS
	Nowe wiadomoci dla %s. Aby przeczyta, 
	napisz: %R%s READ numer
MEMO_LIST_CHAN_MEMOS
	Wiadomoci dla %s. Aby przeczyta, 
	napisz: %R%s READ %s numer
MEMO_LIST_CHAN_NEW_MEMOS
	Nowe wiadomoci dla %s. Aby przeczyta, 
	napisz: %R%s READ %s numer
MEMO_LIST_HEADER
	 Nr   Nadawca            Data/Czas
MEMO_LIST_FORMAT
	%c%3d  %-16s  %s

# READ responses
MEMO_READ_SYNTAX
	READ [kana] {list | LAST | NEW}
MEMO_HEADER
	Wiadomo %d od %s (%s). Aby usun, 
	napisz: %R%s DEL %d
MEMO_CHAN_HEADER
	Wiadomo %d od %s (%s). Aby usun, 
	napisz: %R%s DEL %s %d
MEMO_TEXT
	%s

# DEL responses
MEMO_DEL_SYNTAX
	DEL [kana] {numer | list | ALL}
MEMO_DELETED_NONE
	Nie usunito adnych wiadomoci.
MEMO_DELETED_ONE
	Wiadomo %d zostaa usunita.
MEMO_DELETED_SEVERAL
	Wiadomoci %s zostay usunite.
MEMO_DELETED_ALL
	Wszystkie Twoje wiadomoci zostay usunite.
MEMO_CHAN_DELETED_ALL
	Wszystkie wiadomoci dla kanau %s zostay usunite.

# SET responses
MEMO_SET_SYNTAX
	SET opcja parametry
MEMO_SET_DISABLED
	Bd, ustawianie opcji wiadomoci jest tymczasowo 
	niedostpne.
MEMO_SET_UNKNOWN_OPTION
	Nieznana opcja komendy SET %s.

# SET NOTIFY responses
MEMO_SET_NOTIFY_SYNTAX
	SET NOTIFY {ON | LOGON | NEW | MAIL | OFF }
MEMO_SET_NOTIFY_ON
	%s powiadomi Ci o wiadomociach, gdy si zalogujesz
	i gdy zostan one wysane.
MEMO_SET_NOTIFY_LOGON
	%s powiadomi Cie o wiadomociach, gdy si zalogujesz 
	lub bdziesz away.
MEMO_SET_NOTIFY_NEW
	%s bdzie powiadamia Ci o nowych wiadomociach, 
	gdy zostan wysane.
MEMO_SET_NOTIFY_OFF
	%s nie bedzie Ci powiadamia o wiadomociach.
MEMO_SET_NOTIFY_MAIL
	Powiadomienie o nowych wiadomociach bd Ci 
	przesyane na adres e-mail.
MEMO_SET_NOTIFY_NOMAIL
	Nie bdziesz duej informowany(a) o nowych 
	wiadomociach na adres e-mail.
MEMO_SET_NOTIFY_INVALIDMAIL
	Nie ma adresu e-mail ustawionego dla Twojego nicka.

# SET LIMIT responses
MEMO_SET_LIMIT_SYNTAX
	SET LIMIT [kana] limit
MEMO_SET_LIMIT_SERVADMIN_SYNTAX
	SET LIMIT [user | kana] {limit | NONE} [HARD]
MEMO_SET_YOUR_LIMIT_FORBIDDEN
	Nie masz uprawnie, aby zmienia swj limit 
	wiadomoci.
MEMO_SET_LIMIT_FORBIDDEN
	Limit wiadomoci dla %s nie moe by zmieniany.
MEMO_SET_YOUR_LIMIT_TOO_HIGH
	Nie moesz ustawi swojego limitu wiadomoci 
	wikszego ni %d.
MEMO_SET_LIMIT_TOO_HIGH
	Nie moesz ustawi limitu wiadomoci dla %s 
	wikszego ni %d.
MEMO_SET_LIMIT_OVERFLOW
	Limit wiadomoci jest za duy. Limituj do %d.
MEMO_SET_YOUR_LIMIT
	Twj limit wiadomoci zosta ustawiony na %d.
MEMO_SET_YOUR_LIMIT_ZERO
	Nie moesz ju duej odbiera wiadomoci.
MEMO_UNSET_YOUR_LIMIT
	Twj limit wiadomoci zosta wyczony.
MEMO_SET_LIMIT
	Limit wiadomoci dla %s ustawiono na %d.
MEMO_SET_LIMIT_ZERO
	Limit wiadomoci dla for %s ustawiono na 0.
MEMO_UNSET_LIMIT
	Limit wiadomoci dla %s jest wyczony.

# INFO responses
MEMO_INFO_SYNTAX
	INFO [kana]
MEMO_INFO_SERVADMIN_SYNTAX
	INFO [nick | kana]
MEMO_INFO_NO_MEMOS
	Aktualnie nie masz wiadomoci.
MEMO_INFO_MEMO
	Aktualnie masz 1 wiadomo.
MEMO_INFO_MEMO_UNREAD
	Aktualnie masz 1 wiadomo i nie jest ona 
	jeszcze przeczytana.
MEMO_INFO_MEMOS
	Aktualnie masz %d wiadomoci.
MEMO_INFO_MEMOS_ONE_UNREAD
	Aktualnie masz %d wiadomoci, 
	z czego 1 jest nieprzeczytana.
MEMO_INFO_MEMOS_SOME_UNREAD
	Aktualnie masz %d wiadomoci, 
	z czego %d nieprzeczytanych.
MEMO_INFO_MEMOS_ALL_UNREAD
	Aktualnie masz %d wiadomoci, 
	z czego wszystkie s nieprzeczytane.
MEMO_INFO_LIMIT
	Twj limit wiadomoci wynosi %d.
MEMO_INFO_HARD_LIMIT
	Twj limit wiadomoci wynosi %d 
	i nie moe by zmieniony.
MEMO_INFO_LIMIT_ZERO
	Twj limit wiadomoci wynosi 0 
	i nie moesz odbiera adnych nowych.
MEMO_INFO_HARD_LIMIT_ZERO
	Twj limit wiadomoci wynosi 0 i nie moesz 
	odbiera adnych nowych, ale moesz zmienia limit.
MEMO_INFO_NO_LIMIT
	Nie masz limitu wiadomoci, ktre moesz trzyma.
MEMO_INFO_NOTIFY_OFF
	Nie bdziesz informowany(a) o nowych wiadomociach.
MEMO_INFO_NOTIFY_ON
	Bdziesz informowany(a) o nowych wiadomociach po 
	zalogowaniu i gdy zostan do Ciebie wysane.
MEMO_INFO_NOTIFY_RECEIVE
	Bdziesz informowany(a) o nowych wiadomociach kiedy 
	zostan do Ciebie wysane.
MEMO_INFO_NOTIFY_SIGNON
	Bdziesz informowany(a) o nowych wiadomociach po 
	zalogowaniu.
MEMO_INFO_X_NO_MEMOS
	%s aktualnie nie ma wiadomoci.
MEMO_INFO_X_MEMO
	%s aktualnie ma 1 wiadomo.
MEMO_INFO_X_MEMO_UNREAD
	%s aktualnie ma 1 wiadomo, ktra jest jeszcze 
	nieprzeczytana.
MEMO_INFO_X_MEMOS
	%s aktualnie ma %d wiadomoci.
MEMO_INFO_X_MEMOS_ONE_UNREAD
	%s aktualnie ma %d wiadomoci, 
	z czego 1 nieprzeczytana.
MEMO_INFO_X_MEMOS_SOME_UNREAD
	%s aktualnie ma %d wiadomoci, 
	z czego %d nieprzeczytanych.
MEMO_INFO_X_MEMOS_ALL_UNREAD
	%s aktualnie ma %d wiadomoci, 
	z czego wszystkie s nieprzeczytane.
MEMO_INFO_X_LIMIT
	%s ma limit wiadomoci na %d.
MEMO_INFO_X_HARD_LIMIT
	%s ma limit wiadomoci na %d i nie moe by 
	zmieniony.
MEMO_INFO_X_NO_LIMIT
	%s nie ma limitu wiadomoci.
MEMO_INFO_X_NOTIFY_OFF
	%s nie jest informowany(a) o nowych 
	wiadomociach.
MEMO_INFO_X_NOTIFY_ON
	%s jest informowany(a) o nowych wiadomociach 
	po zalogowaniu i po wysaniu.
MEMO_INFO_X_NOTIFY_RECEIVE
	%s jest informowany(a) o nowych wiadomociach 
	po wysaniu.
MEMO_INFO_X_NOTIFY_SIGNON
	%s jest informowany(a) o nowych wiadomociach 
	po zalogowaniu.

# Memo2Mail responses
MEMO_MAIL_SUBJECT
	Nowa wiadomo
MEMO_MAIL_TEXT1
	Witaj %s
MEMO_MAIL_TEXT2
	Wanie otrzymae(a now wiadomo od %s. 
	Jest to Twoja %d wiadomo.
MEMO_MAIL_TEXT3
	Tre wiadomoci:

# RSEND responses
MEMO_RSEND_PLEASE_WAIT
	Prosz odczeka %d sekund przed ponownym uyciem 
	komendy.
MEMO_RSEND_DISABLED
	Bd, komenda RSEND jest niedostpna na tej sieci.
MEMO_RSEND_SYNTAX
	RSEND {nick | kana} tre
MEMO_RSEND_NICK_MEMO_TEXT
	[auto-memo] Wysana przez Ciebie wiadomo 
	zostaa zauwaona.
MEMO_RSEND_CHAN_MEMO_TEXT
	[auto-memo] Wysana przez Ciebie wiadomo 
	do %s zostaa zauwaona.
MEMO_RSEND_USER_NOTIFICATION
	Informacja o tym, e przeczytae(a) t wiadomo 
	zostaa wysana do %s.

# CHECK responses
MEMO_CHECK_SYNTAX
	CHECK nick
MEMO_CHECK_NOT_READ
	Ostatnia wysana przez Ciebie wiadomo 
	do %s (w %s) wci jest nieprzeczytana.
MEMO_CHECK_READ
	Ostatnia wysana przez Ciebie wiadomo 
	do %s (w %s) zostaa przeczytana.
MEMO_CHECK_NO_MEMO
	%s nie posiada wiadomoci od Ciebie.

###########################################################################
#
# Komunikaty BotServ 
#
###########################################################################
	
# Standard responses
MEMO_NO_RSEND_SELF
	You can not request a receipt when sending a memo to yourself.

###########################################################################
#
# BotServ messages
#
###########################################################################
	
# Standard responses
BOT_DOES_NOT_EXIST
	Bot %s nie istnieje.
BOT_NOT_ASSIGNED
	Musisz przydzieli najpierw bota na kana.
	Napisz %R%S HELP ASSIGN, 
	aby uzyska wicej informacji.
BOT_NOT_ON_CHANNEL
	Nie ma bota na kanale %s.
	
# Kick reasons (must be a single line)
BOT_REASON_BADWORD
	Uprasza si o nie uywanie sowa %s na tym kanale!
BOT_REASON_BADWORD_GENTLE
	Patrz co piszesz, trbo!
BOT_REASON_BOLD
	Nie pogrubiaj mi tekstu na tym kanale!
BOT_REASON_CAPS
	Wycz tego CAPS LOCKa! 
BOT_REASON_COLOR
	Nie uywaj kolorw na tym kanale! Kolory masz na 
	tczy.
BOT_REASON_FLOOD
	Przesta floodzi! Kumasz? Nie? To nie!
BOT_REASON_REPEAT
	Przesta si powtarza, bo w kocu si sklonujesz!
BOT_REASON_REVERSE
	Nie uywaj mi tu te, bo Cie walne!
BOT_REASON_UNDERLINE
	Przesta uywa podkrele na tym kanale!
	
# !seen replies
BOT_SEEN_BOT
	Znalaze(a) mnie, %s!
BOT_SEEN_YOU
	%s? Szukasz siebie? Szukajcie, a znajdziecie! 
BOT_SEEN_ON_CHANNEL
	%s jest teraz na kanale!
BOT_SEEN_ON_CHANNEL_AS
	%s jest teraz na kanale (jako %s)! 
BOT_SEEN_ON
	Widziaem %s tutaj %s temu.
BOT_SEEN_NEVER
	Nigdy nie widziaem %s na tym kanale.
BOT_SEEN_UNKNOWN
	Nie wiem kim %s jest.

# BOT responses
BOT_BOT_SYNTAX
	BOT ADD nick user host real
	BOT CHANGE starynick nowynick [user [host [real]]]
	BOT DEL nick
BOT_BOT_ALREADY_EXISTS
	Bot %s ju istnieje.
BOT_BOT_CREATION_FAILED
	Bd, utworzenie nieudane.
BOT_BOT_READONLY
	Bd, modyfikowanie botw jest tymczasowo 
	niedostpne.
BOT_BOT_ADDED
	%s!%s@%s (%s) dodano do listy bocikw.
BOT_BOT_ANY_CHANGES
	Nowe informacje s takie same jak stare.
BOT_BOT_CHANGED
	Bot %s zosta zmieniony na %s!%s@%s (%s)
BOT_BOT_DELETED
	Bot %s zosta usunity.
	
# BOTLIST responses
BOT_BOTLIST_HEADER
	Lista botw:
BOT_BOTLIST_PRIVATE_HEADER
	Boty zarezerwowane dla IRC Operatorw:
BOT_BOTLIST_FOOTER
	%d boty(w) dostpnych.
BOT_BOTLIST_EMPTY
	Obecnie nie ma adnych botw dostpnych.
	Popro IRC Operatora o dodanie.
	
# ASSIGN responses
BOT_ASSIGN_SYNTAX
	ASSIGN kana nick
BOT_ASSIGN_READONLY
	Bd, przydzielanie botw jest tymczasowo 
	niedostpne.
BOT_ASSIGN_ALREADY
	Bot %s jest ju postawiony na %s.
BOT_ASSIGN_ASSIGNED
	Bot %s zosta postawiony na %s.
	
# UNASSIGN responses
BOT_UNASSIGN_SYNTAX
	UNASSIGN kana
BOT_UNASSIGN_UNASSIGNED
	Nie ma adnych botw przydzielonych na %s.
	
# INFO responses
BOT_INFO_SYNTAX
	INFO {kana | nick}
BOT_INFO_NOT_FOUND
	%s to nieprawidowy bot lub kana.
BOT_INFO_BOT_HEADER
	Informacje o bocie %s:
BOT_INFO_BOT_MASK
		Maska: %s@%s
BOT_INFO_BOT_REALNAME
		Nazwa: %s
BOT_INFO_BOT_CREATED
	    Utworzony: %s
BOT_INFO_BOT_USAGE
	    Obecny na: %d kanale(kanaach)
BOT_INFO_BOT_OPTIONS
		Opcje: %s
BOT_INFO_OPT_PRIVATE
	Prywatny.
BOT_INFO_CHAN_HEADER
	Innformacje o kanale %s:
BOT_INFO_CHAN_BOT
	       Przydzielony bot: %s
BOT_INFO_CHAN_BOT_NONE
	       Przydzielony bot: nie przydzielono jeszcze.
BOT_INFO_CHAN_KICK_BADWORDS
	       Kopanie za sowa: %s
BOT_INFO_CHAN_KICK_BADWORDS_BAN
	       Kopanie za sowa: %s (%d kop(y) do bana)
BOT_INFO_CHAN_KICK_BOLDS
	 Kopanie za pogrubienia: %s
BOT_INFO_CHAN_KICK_BOLDS_BAN
	 Kopanie za pogrubienia: %s (%d kop(y) do bana)
BOT_INFO_CHAN_KICK_CAPS_ON
	       Kopanie za capsa: %s (minimum %d/%d%%)
BOT_INFO_CHAN_KICK_CAPS_BAN
	       Kopanie za capsa: %s (%d kop(y) do bana; minimum %d/%d%%)
BOT_INFO_CHAN_KICK_CAPS_OFF
	       Kopanie za capsa: %s
BOT_INFO_CHAN_KICK_COLORS
	      Kopanie za kolory: %s
BOT_INFO_CHAN_KICK_COLORS_BAN
	      Kopanie za kolory: %s (%d kop(y) do bana)
BOT_INFO_CHAN_KICK_FLOOD_ON
	       Kopanie za flood: %s (%d linii w %ds)
BOT_INFO_CHAN_KICK_FLOOD_BAN
	       Kopanie za flood: %s (%d kop(y) do bana; %d linii w %ds)
BOT_INFO_CHAN_KICK_FLOOD_OFF
	       Kopanie za flood: %s
BOT_INFO_CHAN_KICK_REPEAT_ON
	 Kopanie za powtarzanie: %s (%d czasu)
BOT_INFO_CHAN_KICK_REPEAT_BAN
	 Kopanie za powtarzanie: %s (%d kop(y) do bana; %d czasu)
BOT_INFO_CHAN_KICK_REPEAT_OFF
	 Kopanie za powtarzanie: %s
BOT_INFO_CHAN_KICK_REVERSES
	 Kopanie za odw kolorw: %s
BOT_INFO_CHAN_KICK_REVERSES_BAN
	 Kopanie za odw kolorw: %s (%d kop(y) do bana)
BOT_INFO_CHAN_KICK_UNDERLINES
	Kopanie za podkrelenia: %s
BOT_INFO_CHAN_KICK_UNDERLINES_BAN
	Kopanie za podkrelenia: %s (%d kop(y) do bana)
BOT_INFO_ACTIVE
	wczone
BOT_INFO_INACTIVE
	wyczone
BOT_INFO_CHAN_OPTIONS
	             Inne Opcje: %s
BOT_INFO_OPT_DONTKICKOPS
	Ochrona opw
BOT_INFO_OPT_DONTKICKVOICES
	Ochrona voicw
BOT_INFO_OPT_FANTASY
	Komendy publiczne (fantasy)
BOT_INFO_OPT_GREET
	Powitanie
BOT_INFO_OPT_NOBOT
	Opcja NoBot
BOT_INFO_OPT_SYMBIOSIS
	Opcja SYMBIOSIS
BOT_INFO_OPT_NONE
	Brak
	
# SET responses
BOT_SET_SYNTAX
	SET kana opcja ustawienie
BOT_SET_DISABLED
	Bd, ustawianie opcji bota jest tymczasowo 
	niedostpne.
BOT_SET_UNKNOWN
	Nieznana opcja %s.
	Napisz %R%S HELP SET,
	aby uzyska wicej informacji.
	
# SET DONTKICKOPS messages
BOT_SET_DONTKICKOPS_SYNTAX
	SET kana DONTKICKOPS {ON|OFF}
BOT_SET_DONTKICKOPS_ON
	Bot nie bdzie od teraz kopa operatorw 
	na kanale %s.
BOT_SET_DONTKICKOPS_OFF
	Bot bdzie od teraz kopa operatorw 
	na kanale %s.
	
# SET DONTKICKVOICES messages
BOT_SET_DONTKICKVOICES_SYNTAX
	SET kana DONTKICKVOICES {ON|OFF}
BOT_SET_DONTKICKVOICES_ON
	Bot nie bdzie kopa voicw na kanale %s.
BOT_SET_DONTKICKVOICES_OFF
	Bot bdzie kopa voicw na kanale %s.

# SET FANTASY messages
BOT_SET_FANTASY_SYNTAX
	SET kana FANTASY {ON|OFF}
BOT_SET_FANTASY_ON
	Komendy fantasy s od teraz aktywne 
	na kanale %s.
BOT_SET_FANTASY_OFF
	Komendy fantasy s od teraz nieaktywne 
	na kanale %s.
	
# SET GREET messages
BOT_SET_GREET_SYNTAX
	SET kana GREET {ON|OFF}
BOT_SET_GREET_ON
	Opcja powitania jest od teraz aktywna 
	na kanale %s.
BOT_SET_GREET_OFF
	Opcja powitania jest od teraz nieaktywna 
	na kanale %s.
	
# SET NOBOT
BOT_SET_NOBOT_SYNTAX
	SET nickbota NOBOT {ON|OFF}
BOT_SET_NOBOT_ON
	Opcja NoBot jest od teraz aktywna 
	na kanale %s.
BOT_SET_NOBOT_OFF
	Opcja NoBot jest od teraz nieaktywna 
	na kanale %s.

# SET PRIVATE
BOT_SET_PRIVATE_SYNTAX
	SET nickbota PRIVATE {ON|OFF}
BOT_SET_PRIVATE_ON
	Opcja prywatnoci bota %s jest 
	od teraz aktywna.
BOT_SET_PRIVATE_OFF
	Opcja prywatnoci bota %s jest 
	od teraz nieaktywna.

# SET SYMBIOSIS
BOT_SET_SYMBIOSIS_SYNTAX
	SET kana SYMBIOSIS {ON|OFF}
BOT_SET_SYMBIOSIS_ON
	Opcja symbiozy jest od teraz aktywna 
	na kanale %s.
BOT_SET_SYMBIOSIS_OFF
	Opcja symbiozy jest od teraz nieaktywna 
	na kanale %s.
	
# KICK responses
BOT_KICK_SYNTAX
	KICK kana opcja {ON|OFF} [settings]
BOT_KICK_DISABLED
	Bd, konfiguracja kopw jest tymczasowo 
	niedostpna.
BOT_KICK_UNKNOWN
	Nieznana opcja %s.
	Napisz %R%S HELP KICK, 
	aby uzyska wicej informacji.
BOT_KICK_BAD_TTB
	%s nie moe by wzity jako czas bana.

BOT_KICK_BADWORDS_ON
	Bot bdzie od teraz kopa za zakazane sowa. 
	Uyj komendy BADWORDS, aby doda bd usun 
	poszczeglne sowa.
BOT_KICK_BADWORDS_ON_BAN
	Bot bdzie od teraz kopa za zakazane sowa, 
	oraz stawia bana po %d kopach dla tego samego 
	uytkownika. Uyj komendy BADWORDS, aby doda bd 
	usuna poszczeglne sowa.
BOT_KICK_BADWORDS_OFF
	Bot nie bdzie wicej kopa za zakazane sowa.
BOT_KICK_BOLDS_ON
	Bot bdzie od teraz kopa za pogrubienia.
BOT_KICK_BOLDS_ON_BAN
	Bot bdzie od teraz kopa za pogrubienia, oraz 
	stawia bana po %d kopach dla tego samego 
	uytkownika.
BOT_KICK_BOLDS_OFF
	Bot nie bdzie wicej kopa za pogrubienia.
BOT_KICK_CAPS_ON
	Bot bdzie teraz kopa za CAPSa (due litery 
	musz stanowi %d znakw %d%% caej wiadomoci).
BOT_KICK_CAPS_ON_BAN
	Bot bdzie teraz kopa za CAPSa (due litery 
	musz stanowi %d znakw i %d%% caej wiadomoci), 
	oraz stawia bana po %d kopach dla tego samego 
	uytkownika.
BOT_KICK_CAPS_OFF
	Bot nie bdzie wicej kopa za CAPSa.
BOT_KICK_COLORS_ON
	Bot bdzie od teraz kopa za kolory.
BOT_KICK_COLORS_ON_BAN
	Bot bdzie od teraz kopa za kolory, oraz 
	stawia bana po %d kopach dla tego samego 
	uytkownika.
BOT_KICK_COLORS_OFF
	Bot nie bdzie wicej kopa za kolory.
BOT_KICK_FLOOD_ON
	Bot bdzie od teraz kopa za flood 
	(%d linii w %d sekund).
BOT_KICK_FLOOD_ON_BAN
	Bot bdzie od teraz kopa za flood 
	(%d linii w %d sekund), oraz stawia bana po %d 
	kopach dla tego samego uytkownika.
BOT_KICK_FLOOD_OFF
	Bot nie bdzie wicej kopa za flood.
BOT_KICK_REPEAT_ON
	Bot bdzie od teraz kopa za powtrzenia 
	(uytkownikw, ktrzy napisz %d razy taki sam 
	wyraz).
BOT_KICK_REPEAT_ON_BAN
	Bot bdzie od teraz kopa za powtrzenia 
	(uytkownikw, ktrzy napisz %d razy taki sam 
	wyraz), oraz stawia bana po %d kopach dla tego 
	samego uytkownika.
BOT_KICK_REPEAT_OFF
	Bot nie bdzie wicej kopa za powtrzenia.
BOT_KICK_REVERSES_ON
	Bot bdzie od teraz kopa za 
	zamiane koloru ta z tekstem.
BOT_KICK_REVERSES_ON_BAN
	Bot bdzie od teraz kopa za 
	zamiane koloru ta z tekstem, oraz stawia bana
	po %d kopach dla tego samego uytkownika.
BOT_KICK_REVERSES_OFF
	Bot nie bdzie wicej kopa za 
	zamiane koloru ta z tekstem.
BOT_KICK_UNDERLINES_ON
	Bot bdzie od teraz kopa za podkrelenia.
BOT_KICK_UNDERLINES_ON_BAN
	Bot bdzie od teraz kopa za podkrelenia, 
	oraz stawia bana po %d kopach dla tego samego 
	uytkownika.
BOT_KICK_UNDERLINES_OFF
	Bot nie bdzie wicej kopa za podkrelenia.
	
# BADWORDS messages
BOT_BADWORDS_SYNTAX
	BADWORDS kana {ADD|DEL|LIST|CLEAR} [sowo | pozycja] [SINGLE|START|END]
BOT_BADWORDS_DISABLED
	Bd, modyfikacje listy zakazanych sw kanau s 
	tymczasowo niedostpne.
BOT_BADWORDS_REACHED_LIMIT
	Bd, moesz mie tylko %d wpisw na licie 
	zakazanych sw.
BOT_BADWORDS_ALREADY_EXISTS
	%s ju istnieje w licie zakazanych sw 
	kanau %s.
BOT_BADWORDS_ADDED
	%s dodano do listy zakazanych sw kanau %s.
BOT_BADWORDS_NO_SUCH_ENTRY
	Brak wpisw (#%d) na licie zakazanych sw 
	kanau %s.
BOT_BADWORDS_NOT_FOUND
	%s nie znaleziono na licie zakazanych sw 
	kanau %s.
BOT_BADWORDS_NO_MATCH
	Nie znaleziono wpisw na licie zakazanych sw 
	kanau %s.
BOT_BADWORDS_DELETED
	%s usunito z listy zakazanych sw 
	kanau %s.
BOT_BADWORDS_DELETED_ONE
	Usunito 1 wpis z listy zakazanych sw 
	kanau %s.
BOT_BADWORDS_DELETED_SEVERAL
	Usunito %d wpisw z listy zakazanych sw 
	kanau %s.
BOT_BADWORDS_LIST_EMPTY
	Lista zakazanych sw dla kanau %s jest pusta.
BOT_BADWORDS_LIST_HEADER
	Lista zakazanych sw dla %s:
	  Nr    Sowo                          Typ
BOT_BADWORDS_LIST_FORMAT
	  %3d   %-30s %s
BOT_BADWORDS_CLEAR
	Lista zakazanych sw jest od teraz pusta.

# SAY responses
BOT_SAY_SYNTAX
	SAY kana tekst

# ACT responses
BOT_ACT_SYNTAX
	ACT kana tekst

# Errors
BOT_EXCEPT
	Uytkownik posiada wyjtek na kanale.
BOT_BAD_NICK
	Nick bota moe zawiera tylko prawidowe znaki.
BOT_BAD_HOST
	Host bota moe zawiera tylko prawidowe znaki.
BOT_BAD_IDENT
	Ident bota moe zawiera tylko prawidowe znaki.
BOT_LONG_IDENT
	Bot Idents may only contain 9 characters.
###########################################################################
#
# Komunikaty OperServ 
#
###########################################################################

# General messages
OPER_BOUNCY_MODES
	Serwisy nie mog zmieni trybu. 
	Czy aby na pewno s dobrze skonfigurowane?
OPER_BOUNCY_MODES_U_LINE
	Serwisy nie mog zmieni trybu. 
	Czy na pewno U:linie s skonfigurowane poprawnie?

# GLOBAL responses
OPER_GLOBAL_SYNTAX
	GLOBAL tre wiadomoci

# STATS responses
OPER_STATS_UNKNOWN_OPTION
	Nieznana opcja STATS %s.
OPER_STATS_CURRENT_USERS
	Ilo uytkownikw: %d (IRC Opw: %d)
OPER_STATS_MAX_USERS
	Rekord: %d (%s)
# This is ugly, but at least it's language-portable...
# Note that you can include seconds in any of these--my personal preference
# is to only give resolution to the nearest minute when uptime is one hour
# or more, but just add a %d to get seconds as well.
OPER_STATS_UPTIME_DHMS
	Serwisy dziaaj %d dni, %02d:%02d
OPER_STATS_UPTIME_1DHMS
	Serwisy dziaaj %d dnia, %02d:%02d
OPER_STATS_UPTIME_HMS
	Serwisy dziaaj %d godzin i %d minut(y).
OPER_STATS_UPTIME_HM1S
	Serwisy dziaaj %d godzin(y) i %d minut(y).
OPER_STATS_UPTIME_H1MS
	Serwisy dziaaj %d godzin(y) i %d minut(y).
OPER_STATS_UPTIME_H1M1S
	Serwisy dziaaj %d godzin(y) i %d minut(y).
OPER_STATS_UPTIME_1HMS
	Serwisy dziaaj %d godzine i %d minut(y).
OPER_STATS_UPTIME_1HM1S
	Serwisy dziaaj %d godzine i %d minut(y).
OPER_STATS_UPTIME_1H1MS
	Serwisy dziaaj %d godzine i %d minut(y).
OPER_STATS_UPTIME_1H1M1S
	Serwisy dziaaj %d godzine i %d minut(y).
OPER_STATS_UPTIME_MS
	Serwisy dziaaj %d minut(y) i %d sekund(y).
OPER_STATS_UPTIME_M1S
	Serwisy dziaaj %d minut(y) i %d sekund(y).
OPER_STATS_UPTIME_1MS
	Serwisy dziaaj %d minut(y) i %d sekund(y).
OPER_STATS_UPTIME_1M1S
	Serwisy dziaaj %d minute i %d sekund(y).
OPER_STATS_BYTES_READ
	Bajtw czytanych: %5d kB
OPER_STATS_BYTES_WRITTEN
	Bajtw zapisanych: %5d kB
OPER_STATS_USER_MEM
	Uytkownik    : %6d rekordw, %5d kB
OPER_STATS_CHANNEL_MEM
	Kana         : %6d rekordw, %5d kB
OPER_STATS_GROUPS_MEM
	Grupy NS      : %6d rekordw, %5d kB
OPER_STATS_ALIASES_MEM
	Aliasy NS     : %6d rekordw, %5d kB
OPER_STATS_CHANSERV_MEM
	ChanServ      : %6d rekordw, %5d kB
OPER_STATS_BOTSERV_MEM
	BotServ       : %6d rekordw, %5d kB
OPER_STATS_OPERSERV_MEM
	OperServ      : %6d rekordw, %5d kB
OPER_STATS_SESSIONS_MEM
	Sesji         : %6d rekordw, %5d kB
OPER_STATS_AKILL_COUNT
	Aktualna ilo AKILLw: %d
OPER_STATS_AKILL_EXPIRE_DAYS
	Domylny czas wygasania AKILL: %d dni
OPER_STATS_AKILL_EXPIRE_DAY
	Domylny czas wygasania AKILL: 1 dzie
OPER_STATS_AKILL_EXPIRE_HOURS
	Domylny czas wygasania AKILL: %d godzin(y)
OPER_STATS_AKILL_EXPIRE_HOUR
	Domylny czas wygasania AKILL: 1 godzina
OPER_STATS_AKILL_EXPIRE_MINS
	Domylny czas wygasania AKILL: %d minut(y)
OPER_STATS_AKILL_EXPIRE_MIN
	Domylny czas wygasania AKILL: 1 minuta
OPER_STATS_AKILL_EXPIRE_NONE
	Domylny czas wygasania AKILL: Nie wygasaj
OPER_STATS_SGLINE_COUNT
	Aktualna liczba SGLINI: %d
OPER_STATS_SGLINE_EXPIRE_DAYS
	Domylny czas wygasania SGLINI: %d dni
OPER_STATS_SGLINE_EXPIRE_DAY
	Domylny czas wygasania SGLINI: 1 dzie
OPER_STATS_SGLINE_EXPIRE_HOURS
	Domylny czas wygasania SGLINI: %d godzin(y)
OPER_STATS_SGLINE_EXPIRE_HOUR
	Domylny czas wygasania SGLINI: 1 godzina
OPER_STATS_SGLINE_EXPIRE_MINS
	Domylny czas wygasania SGLINI: %d minut(y)
OPER_STATS_SGLINE_EXPIRE_MIN
	Domylny czas wygasania SGLINI: 1 minuta
OPER_STATS_SGLINE_EXPIRE_NONE
	Domylny czas wygasania SGLINI: Nie wygasaj
OPER_STATS_SQLINE_COUNT
	Aktualna liczba SQLINI: %d
OPER_STATS_SQLINE_EXPIRE_DAYS
	Domylny czas wygasania SQLINI: %d dni
OPER_STATS_SQLINE_EXPIRE_DAY
	Domylny czas wygasania SQLINI: 1 dzie
OPER_STATS_SQLINE_EXPIRE_HOURS
	Domylny czas wygasania SQLINI: %d godzin(y)
OPER_STATS_SQLINE_EXPIRE_HOUR
	Domylny czas wygasania SQLINI: 1 godzina
OPER_STATS_SQLINE_EXPIRE_MINS
	Domylny czas wygasania SQLINI: %d minut(y)
OPER_STATS_SQLINE_EXPIRE_MIN
	Domylny czas wygasania SQLINI: 1 minute
OPER_STATS_SQLINE_EXPIRE_NONE
	Domylny czas wygasania SQLINI: Nie wygasaj
OPER_STATS_SZLINE_COUNT
	Aktualna liczba SZLINI: %d
OPER_STATS_SZLINE_EXPIRE_DAYS
	Domylny czas wygasania SZLINI: %d dni
OPER_STATS_SZLINE_EXPIRE_DAY
	Domylny czas wygasania SZLINI: 1 dzie
OPER_STATS_SZLINE_EXPIRE_HOURS
	Domylny czas wygasania SZLINI: %d godzin(y)
OPER_STATS_SZLINE_EXPIRE_HOUR
	Domylny czas wygasania SZLINI: 1 godzina
OPER_STATS_SZLINE_EXPIRE_MINS
	Domylny czas wygasania SZLINI: %d minut(y)
OPER_STATS_SZLINE_EXPIRE_MIN
	Domylny czas wygasania SZLINI: 1 minuta
OPER_STATS_SZLINE_EXPIRE_NONE
	Domylny czas wygasania SZLINI: Nie wygasaj
OPER_STATS_RESET
	Statystyki zresetowano.

# MODE responses
OPER_STATS_UPLINK_SERVER
	Uplink server: %s
OPER_STATS_UPLINK_CAPAB
	Uplink capab: %s
OPER_STATS_UPLINK_SERVER_COUNT
	Servers found: %d

# MODE responses
OPER_MODE_SYNTAX
	MODE kana mody

# UMODE respondes
OPER_UMODE_SYNTAX
	UMODE nick mody
OPER_UMODE_SUCCESS
	Zmieniono usermody dla %s.
OPER_UMODE_CHANGED
	%s zmieni(a) Tobie usermody.

# OLINE responses
OPER_OLINE_SYNTAX
	OLINE nick flagi
OPER_OLINE_SUCCESS
	Flagi opera %s zostay przyznane dla %s.
OPER_OLINE_IRCOP
	Jeste teraz IRC Operatorem.

# CLEARMODES responses
OPER_CLEARMODES_SYNTAX
	CLEARMODES kana [ALL]
OPER_CLEARMODES_DONE
	Tryby i bany zostay wyczyszczone na 
	kanale %s.
OPER_CLEARMODES_ALL_DONE
	Wszystkie tryby zostay wyczyszczone na 
	kanale %s.


# KICK responses
OPER_KICK_SYNTAX
	KICK kana nick powd

# SVSNICK responses
OPER_SVSNICK_SYNTAX
	SVSNICK nick nowynick 
OPER_SVSNICK_NEWNICK
	Uytkownik %s ma teraz nicka %s.
	
# ADMIN responses
OPER_ADMIN_SYNTAX
	ADMIN {ADD|DEL|LIST|CLEAR} [nick | pozycja]
OPER_ADMIN_SKELETON
	Serwisy s w trybie szkieletowym i komenda ADMIN 
	jest niedostpna.
OPER_ADMIN_EXISTS
	%s ju istnieje na licie administratorw 
	serwisw.
OPER_ADMIN_REACHED_LIMIT
	Bd, moesz mie tylko %d administratorw 
	serwisw.
OPER_ADMIN_ADDED
	%s dodano do listy administratorw serwisw.
OPER_ADMIN_NOT_FOUND
	%s nie znaleziono na licie administratorw 
	serwisw.
OPER_ADMIN_NO_MATCH
	Nie znaleziono wpisw na licie administratorw 
	serwisw.
OPER_ADMIN_DELETED
	%s usunito z listy administratorw serwisw.
OPER_ADMIN_DELETED_ONE
	Usunito 1 wpis z listy administratorw serwisw.
OPER_ADMIN_DELETED_SEVERAL
	Usunito %d wpisy(w) z listy administratorw 
	serwisw.
OPER_ADMIN_LIST_EMPTY
	Lista administratorw serwisw jest pusta.
OPER_ADMIN_LIST_HEADER
	Lista administratorw serwisw:
	  Nr    Nick
OPER_ADMIN_LIST_FORMAT
	  %3d   %s
OPER_ADMIN_CLEAR
	Lista administratorw serwisw zostaa 
	wyczyszczona.
OPER_ADMIN_MOVED
	%s has been moved to Services Administrators list.

# OPER responses
OPER_OPER_SYNTAX
	OPER {ADD|DEL|LIST|CLEAR} [nick | pozycja]
OPER_OPER_SKELETON
	Serwisy s w trybie szkieletowym i komenda OPER 
	jest niedostpna.
OPER_OPER_EXISTS
	%s ju istnieje na licie operatorw serwisw.
OPER_OPER_REACHED_LIMIT
	Bd, moesz mie tylko %d operatorw serwisw.
OPER_OPER_ADDED
	%s dodano do listy operatorw serwisw.
OPER_OPER_NOT_FOUND
	%s nie znaleziono na licie operatorw serwisw.
OPER_OPER_NO_MATCH
	Nie znaleziono wpisw na licie operatorw serwisw.
OPER_OPER_DELETED
	%s usunito z listy operatorw serwisw.
OPER_OPER_DELETED_ONE
	Usunito 1 wpis z listy operatorw serwisw.
OPER_OPER_DELETED_SEVERAL
	Usunito %d wpisy(w) z listy operatorw serwisw.
OPER_OPER_LIST_EMPTY
	Lista operatorw serwisw jest pusta.
OPER_OPER_LIST_HEADER
	Lista operatorw serwisw:
	  Nr    Nick
OPER_OPER_LIST_FORMAT
	  %3d   %s
OPER_OPER_CLEAR
	Lista operatorw serwisw zostaa wyczyszczona.
OPER_OPER_MOVED
	%s has been moved to Services Operators list.

# AKILL responses
OPER_AKILL_SYNTAX
	AKILL {ADD | DEL | LIST | VIEW | CLEAR} [[+czaswygasania] {maska | pozycja} [powd]]
OPER_AKILL_EXISTS
	%s ju istnieje na licie AKILL.
OPER_AKILL_ALREADY_COVERED
	%s ju jest postawione przez %s.
OPER_AKILL_REACHED_LIMIT
	Bd, moesz mie tylko %d AKILLw.
OPER_AKILL_NO_NICK
	Uwaga: maska AKILL nie moe zawiera nickw. 
	Upewnij si, e nie dodae(a) czci nicka.
OPER_AKILL_ADDED
	%s dodano do listy AKILL.
OPER_AKILL_CHANGED
	Zmieniono czas wygasania %s.
OPER_AKILL_NOT_FOUND
	%s nie znaleziono na licie AKILL.
OPER_AKILL_NO_MATCH
	Nie znaleziono wpisw na licie AKILL.
OPER_AKILL_DELETED
	%s usunito z listy AKILL.
OPER_AKILL_DELETED_ONE
	Usunito 1 wpis z listy AKILL.
OPER_AKILL_DELETED_SEVERAL
	Usunito %d wpisy(w) z listy AKILL.
OPER_AKILL_LIST_EMPTY
	Lista AKILL jest pusta.
OPER_AKILL_LIST_HEADER
	Aktualna lista AKILL:
	  Nr    Maska                             Powd
OPER_AKILL_LIST_FORMAT
	  %3d   %-32s  %s
OPER_AKILL_VIEW_HEADER
	Aktualna lista AKILL:
# number, mask, set-by, set-time, expires, reason
OPER_AKILL_VIEW_FORMAT
	%3d  %s (przez %s na %s; %s)
	      %s
OPER_AKILL_CLEAR
	Lista AKILL zostaa wyczyszczona.
OPER_CHANKILL_SYNTAX
	CHANKILL [+czastrwania] {#kana} [powd]
# SGLINE responses
OPER_SGLINE_SYNTAX
	SGLINE {ADD | DEL | LIST | VIEW | CLEAR} [[+czaswygasania] {maska | pozycja}[:powd]]
OPER_SGLINE_UNSUPPORTED
	Bd, SGLINIE nie s dostpne na tej sieci.
OPER_SGLINE_EXISTS
	%s ju istnieje w licie SGLINII.
OPER_SGLINE_ALREADY_COVERED
	%s ju jest postawione przez %s.
OPER_SGLINE_REACHED_LIMIT
	Bd, moesz mie tylko %d SGLINII.
OPER_SGLINE_ADDED
	%s dodano do listy SGLINII.
OPER_SGLINE_CHANGED
	Zmieniono czas wygasania %s.
OPER_SGLINE_NOT_FOUND
	%s nie znaleziono na licie SGLINII.
OPER_SGLINE_NO_MATCH
	Nie znaleziono wpisy(w) na licie SGLINII.
OPER_SGLINE_DELETED
	%s usunito z listy SGLINII.
OPER_SGLINE_DELETED_ONE
	Usunito 1 wpis z listy SGLINII.
OPER_SGLINE_DELETED_SEVERAL
	Usunito %d wpisy(w) z listy SGLINII.
OPER_SGLINE_LIST_EMPTY
	Lista SGLINII jest pusta.
OPER_SGLINE_LIST_HEADER
	Aktualna lista SGLINII:
	  Nr    Maska                              Powd
OPER_SGLINE_LIST_FORMAT
	  %3d   %-32s  %s
OPER_SGLINE_VIEW_HEADER
	Aktualna lista SGLINII:
# number, mask, set-by, set-time, expires, reason
OPER_SGLINE_VIEW_FORMAT
	%3d  %s (przez %s na %s; %s)
	      %s
OPER_SGLINE_CLEAR
	Lista SGLINII zostaa wyczyszczona.

# SQLINE responses
OPER_SQLINE_SYNTAX
	SQLINE {ADD | DEL | LIST | VIEW | CLEAR} [[+czastrwania] {maska | pozycja} [powd]]
OPER_SQLINE_CHANNELS_UNSUPPORTED
	SQLINIE kanaowe nie s obsugiwane przez Twoje 
	ircd wic nie moesz ich uy.
OPER_SQLINE_EXISTS
	%s ju istnieje na licie SQLINII.
OPER_SQLINE_ALREADY_COVERED
	%s jest ju postawione przez %s.
OPER_SQLINE_REACHED_LIMIT
	Bd, moesz mie jedynie %d SQLINII.
OPER_SQLINE_ADDED
	%s dodano do listy SQLINII.
OPER_SQLINE_CHANGED
	Zmieniono czas wygasania %s.
OPER_SQLINE_NOT_FOUND
	%s nie znaleziono na licie SQLINII.
OPER_SQLINE_NO_MATCH
	Nie znaleziono wpisy(w) na licie SQLINII.
OPER_SQLINE_DELETED
	%s usunito z listy SQLINII.
OPER_SQLINE_DELETED_ONE
	Usunito 1 wpis z listy SQLINII.
OPER_SQLINE_DELETED_SEVERAL
	Usunito %d wpisy(w) z listy SQLINII.
OPER_SQLINE_LIST_EMPTY
	Lista SQLINII jest pusta.
OPER_SQLINE_LIST_HEADER
	Aktualna lista SQLINII:
	  Nr    Maska                             Powd
OPER_SQLINE_LIST_FORMAT
	  %3d   %-32s  %s
OPER_SQLINE_VIEW_HEADER
	Aktualna lista SQLINII:
# number, mask, set-by, set-time, expires, reason
OPER_SQLINE_VIEW_FORMAT
	%3d  %s (przez %s na %s; %s)
	      %s
OPER_SQLINE_CLEAR
	Lista SQLINII zostaa wyczyszczona.

# SZLINE responses
OPER_SZLINE_SYNTAX
	SZLINE {ADD | DEL | LIST | VIEW | CLEAR} [[+czastrwania] {maska | pozycja} [powd]]
OPER_SZLINE_UNSUPPORTED
	Bd, SZLINIE nie s dostpne na tej sieci.
OPER_SZLINE_EXISTS
	%s ju istnieje na licie SZLINII.
OPER_SZLINE_ALREADY_COVERED
	%s jest ju postawione przez %s.
OPER_SZLINE_REACHED_LIMIT
	Bd, moesz mie tylko %d SZLINII.
OPER_SZLINE_ONLY_IPS
	Uwaga: moesz doda jedynie maski IP do listy 
	SZLINII.
OPER_SZLINE_ADDED
	%s dodano do listy SZLINII.
OPER_SZLINE_CHANGED
	Zmieniono czas wygasania %s.
OPER_SZLINE_NOT_FOUND
	%s nie znaleziono na licie SZLINII.
OPER_SZLINE_NO_MATCH
	Nie znaleziono wpisw na licie SZLINII.
OPER_SZLINE_DELETED
	%s usunito z listy SZLINII.
OPER_SZLINE_DELETED_ONE
	Usunito 1 wpis z listy SZLINII.
OPER_SZLINE_DELETED_SEVERAL
	Usunito %d wpisy(w) z listy SZLINII.
OPER_SZLINE_LIST_EMPTY
	Lista SZLINII jest pusta.
OPER_SZLINE_LIST_HEADER
	Aktualna lista SZLINII:
	  Nr    Maska                             Powd
OPER_SZLINE_LIST_FORMAT
	  %3d   %-32s  %s
OPER_SZLINE_VIEW_HEADER
	Aktualna lista SZLINII:
# number, mask, set-by, set-time, expires, reason
OPER_SZLINE_VIEW_FORMAT
	%3d  %s (przez %s na %s; %s)
	      %s
OPER_SZLINE_CLEAR
	Lista SZLINII zostaa wyczyszczona.

# SET responses
OPER_SET_SYNTAX
	SET opcja ustawienie
OPER_SET_IGNORE_ON
	Kod ignorowania bdzie uywany.
OPER_SET_IGNORE_OFF
	Kod ignorowania nie bdzie uywany.
OPER_SET_IGNORE_ERROR
	Ustawieniem dla opcji IGNORE musi by 
	ON lub OFF.
OPER_SET_READONLY_ON
	Serwisy s teraz w trybie tylko do odczytu.
OPER_SET_READONLY_OFF
	Serwisy s teraz w trybie odczytu i zapisu.
OPER_SET_READONLY_ERROR
	Ustawieniem dla opcji READONLY musi by 
	ON lub OFF.
OPER_SET_LOGCHAN_ON
	Serwisy teraz bd wypisywa komunikaty 
	na kana %s.
OPER_SET_LOGCHAN_OFF
	Serwisy nie bd ju duej wypisywa komunikatw 
	na kana.
OPER_SET_LOGCHAN_ERROR
	Ustawieniem dla opcji LOGCHAN musi by 
	ON lub OFF i kana logowania musi by 
	zdefiniowany.
OPER_SET_DEBUG_ON
	Serwisy s teraz w trybie debugowania.
OPER_SET_DEBUG_OFF
	Serwisy nie s od teraz w trybue debugowania.
OPER_SET_DEBUG_LEVEL
	Serwisy s teraz w trybie debugowania (poziom %d).
OPER_SET_DEBUG_ERROR
	Ustawieniem dla opcji DEBUG musi by 
	ON, OFF, lub liczba dodatnia.
OPER_SET_NOEXPIRE_ON
	Serwisy s teraz w trybie nie wygasania.
OPER_SET_NOEXPIRE_OFF
	Serwisy s teraz w trybie wygasania.
OPER_SET_NOEXPIRE_ERROR
	Ustawieniem dla opcji NOEXPIRE musi by 
	ON lub OFF.
OPER_SET_UNKNOWN_OPTION
	Nieznana opcja %s.
OPER_SET_SQL_ON
	SQL code will be used.
OPER_SET_SQL_OFF
	SQL code will not be used.
OPER_SET_SQL_ERROR
	Setting for SQL must be ON or OFF.
OPER_SET_SQL_ERROR_INIT
	Error during init of SQL, check your logs to correct.
OPER_SET_SQL_ERROR_DISABLED
	SQL is not configured for this network. Please edit the
	configuration file (services.conf).
OPER_SET_LIST_OPTION_ON
	%s is enable
OPER_SET_LIST_OPTION_OFF
	%s is disabled

# NOOP responses
OPER_NOOP_SYNTAX
	NOOP {SET|REVOKE} serwer
OPER_NOOP_SET
	Wszystkie O:linie %s zostay usunite.
OPER_NOOP_REVOKE
	Wszystkie O:linie %s zostay zresetowane.

# JUPE responses
OPER_JUPE_SYNTAX
	JUPE serwer [powd]
OPER_JUPE_HOST_ERROR
	Prosz uy prawidowej nazwy serwera.
	
# RAW responses
OPER_RAW_SYNTAX
	RAW tekst

# UPDATE responses
OPER_UPDATING
	Zaktualizowano bazy.
	
# RELOAD responses
OPER_RELOAD
	Plik konfiguracyjny serwisw zosta przeadowany.

# RESTART responses
OPER_CANNOT_RESTART
	SERVICES_BIN nie zdefiniowano, nie mog restartowa. 
	Uruchom ponownie skrypt configure i przekompiluj 
	serwisy wczajc opcje RESTART.

# IGNORE respondes
OPER_IGNORE_SYNTAX
	Skadnia: IGNORE {ADD|DEL|LIST|CLEAR} [czas] [nick]
OPER_IGNORE_VALID_TIME
	Musisz poda prawidow liczb dla czasu.
OPER_IGNORE_TIME_DONE
	Nick %s bdzie od teraz igorowany na %s.
OPER_IGNORE_PERM_DONE
	Nick %s bdzie od teraz igorowany cay czas.
OPER_IGNORE_DEL_DONE
	Nick %s nie bdzie ju duej ignorowany.
OPER_IGNORE_LIST
	Lista ignore serwisw:
OPER_IGNORE_LIST_NOMATCH
	%s nie znaleziono na licie ignorw.
OPER_IGNORE_LIST_EMPTY
	Lista ignorw jest pusta.
OPER_IGNORE_LIST_CLEARED
	Lista ignorw zostaa wyczyszczona.

# KILLCLONES responses
OPER_KILLCLONES_SYNTAX
	KILLCLONES nick
OPER_KILLCLONES_UNKNOWN_NICK
	Nie mog znale uytkownika %s.
	
# CHANLIST responses
OPER_CHANLIST_HEADER
	Lista kanaw:
	Nazwa                Tryby uyt.   Temat
OPER_CHANLIST_HEADER_USER
	Lista kanaw %s:
	Nazwa                Tryby uyt.   Temat
OPER_CHANLIST_RECORD
	%-20s  %4d +%-6s %s
OPER_CHANLIST_END
	Koniec listy kanaw.
	
# USERLIST responses
OPER_USERLIST_HEADER
	Lista uytkownikw:
	Nick                 Maska
OPER_USERLIST_HEADER_CHAN
	Lista uytkownikw %s:
	Nick                 Maska
OPER_USERLIST_RECORD
	%-20s %s@%s
OPER_USERLIST_END
	Koniec listy uytkownikw.

# CACHE responses
OPER_SUPER_ADMIN_ON
	Jeste teraz SuperAdminem.
OPER_SUPER_ADMIN_OFF
	Nie jeste duej SuperAdminem.
OPER_SUPER_ADMIN_SYNTAX
	Ustawieniem dla opcji SuperAdmin musi by 
	ON lub OFF (musi by wczone w 
	services.conf)
OPER_SUPER_ADMIN_WALL_ON
	%s jest teraz SuperAdminem
OPER_SUPER_ADMIN_WALL_OFF
	%s nie jest ju duej SuperAdminem
OPER_SUPER_ADMIN_ONLY
	Tylko SuperAdmini mog uywa tej komendy.
OPER_STAFF_LIST_HEADER
	 Na Poziom Nick
OPER_STAFF_FORMAT
	 %c %s  %s
OPER_STAFF_AFORMAT
	 %c %s  %s [%s]

# DefCon Messages

OPER_DEFCON_SYNTAX
	Skadnia: DEFCON [1|2|3|4|5]
OPER_DEFCON_DENIED
	Serwisy s w trybie Defcon, prosz sprbowa 
	ponownie.
OPER_DEFCON_NO_CONF
	System Defcon musi by wczony w pliku 
	services.conf
OPER_DEFCON_CHANGED
	Serwisy s teraz w systemie DEFCON %d
OPER_DEFCON_WALL
	%s zmieniono poziom DEFCON na %d
DEFCON_GLOBAL
	Defcon jest teraz na poziomie: %d

# Module strings

OPER_MODULE_LOADED
	Modu %s zosta zaadowany.
OPER_MODULE_UNLOADED
	Modu %s zosta wyadowany.
OPER_MODULE_LOAD_FAIL
	Nie moge zaadowa moduu %s
OPER_MODULE_REMOVE_FAIL
	Nie moge wyadowa moduu %s
OPER_MODULE_NO_UNLOAD
	This module can not be unloaded.
OPER_MODULE_LOAD_SYNTAX
	MODLOAD NazwaPliku
OPER_MODULE_UNLOAD_SYNTAX
	MODUNLOAD NazwaPliku
OPER_MODULE_LIST_HEADER
	Aktualna lista moduu:
OPER_MODULE_LIST
	Modu: %s [%s] [%s]
OPER_MODULE_LIST_FOOTER
	Ilo moduw zaadowanych: %d.
OPER_MODULE_INFO_LIST
	Modu: %s 
	Wersja: %s 
	Autor: %s 
	zaadowano: %s
OPER_MODULE_CMD_LIST
	Dodane komendy: %R%s %s
OPER_MODULE_MSG_LIST
	Dostarczone opcja IRCD dla(?): %s
OPER_MODULE_NO_LIST
	Aktualnie nie ma zaadowanych moduw.
OPER_MODULE_NO_INFO
	Nie ma informacji na temat moduu %s.
OPER_MODULE_INFO_SYNTAX
	MODINFO NazwaPliku
MODULE_HELP_HEADER
	Nastpujce komendy zostay dodane przez modu:

###########################################################################
#
# Session Limiting and Exception messages
#
###########################################################################

# EXCEPTION responses
OPER_EXCEPTION_SYNTAX
	EXCEPTION {ADD | DEL | MOVE | LIST | VIEW} [params]
OPER_EXCEPTION_ADD_SYNTAX
	EXCEPTION ADD [+czastrwania] maska limit powd
OPER_EXCEPTION_DEL_SYNTAX
	EXCEPTION DEL {maska | lista}
OPER_EXCEPTION_MOVE_SYNTAX
	EXCEPTION MOVE nr pozycja
OPER_EXCEPTION_DISABLED
	Limitowanie sesji jest wyczone.
OPER_EXCEPTION_ALREADY_PRESENT
	Maska %s ju istnieje w licie wyjtkw.
OPER_EXCEPTION_TOO_MANY
	Lista wyjtkw limitw sesji jest pena!
OPER_EXCEPTION_ADDED
	Limit sesji dla %s zmieniono na %d.
OPER_EXCEPTION_MOVED
	Wyjtek dla %s (#%d) przeniesiono 
	na pozycje %d.
OPER_EXCEPTION_NO_SUCH_ENTRY
	No such entry (#%d) session-limit exception list.
OPER_EXCEPTION_NOT_FOUND
	%s nie znaleziono na licie wyjtkw limitw 
	sesji.
OPER_EXCEPTION_NO_MATCH
	Nie znaleziono wpisw na licie wyjtkw limitw 
	sesji.
OPER_EXCEPTION_DELETED
	%s usunito z listy wyjtkw limitw sesji.
OPER_EXCEPTION_DELETED_ONE
	Usunito 1 wpis z listy wyjtkw limitw sesji.
OPER_EXCEPTION_DELETED_SEVERAL
	Usunito %d wpisy(w) z listy wyjtkw limitw 
	sesji.
OPER_EXCEPTION_LIST_HEADER
	Aktualna lista wyjtkw limitw sesji:
# mask, limit
OPER_EXCEPTION_LIST_FORMAT
	%3d  %4d   %s
OPER_EXCEPTION_LIST_COLHEAD
	Nr   Limit  Host
# mask, set-by, set-time, expires, limit, reason
OPER_EXCEPTION_VIEW_FORMAT
	%3d.  %s  (przez %s na %s; %s)
	    Limit: %-4d  - %s
OPER_EXCEPTION_INVALID_LIMIT
	Nieprawidowy limit sesji. Musi by liczb dodatni, 
	wiksz lub rwn zero i mniejsz ni %d.
OPER_EXCEPTION_INVALID_HOSTMASK
	Nieprawidowa maska. Tylko rzeczywiste maski s 
	prawidowe jako wyjtki.
OPER_EXCEPTION_EXISTS
	%s already exists on the EXCEPTION list.
OPER_EXCEPTION_CHANGED
	Exception for %s has been updated to %d.

# SESSION responses
OPER_SESSION_SYNTAX
	SESSION {LIST limit | VIEW host}
OPER_SESSION_LIST_SYNTAX
	SESSION LIST limit
OPER_SESSION_VIEW_SYNTAX
	SESSION VIEW host
OPER_SESSION_DISABLED
	Limitowanie sesji jest wyczone.
OPER_SESSION_INVALID_THRESHOLD
	Nieprawidowa warto progu. Musi by prawidow 
	liczb cakowit wiksz ni 1.
OPER_SESSION_NOT_FOUND
	%s nie znaleziono na licie sesji.
OPER_SESSION_LIST_HEADER
	Hosty z najmniejsz %d iloci sesji:
OPER_SESSION_LIST_COLHEAD
	Sesje   Host
# limit, host
OPER_SESSION_LIST_FORMAT
	%6d    %s
# host, sessions, limit
OPER_SESSION_VIEW_FORMAT
	Host %s aktualnie posiada %d sesji 
	z limitem %d.

# EXCEPTION help

OPER_HELP_EXCEPTION
	Skadnia: EXCEPTION ADD [+czastrwania] maska limit powd
	          EXCEPTION DEL {maska | lista}
	          EXCEPTION MOVE nr pozycja
	          EXCEPTION LIST [maska | lista]
	          EXCEPTION VIEW [maska | lista]
	
	Allows Services admins to manipulate the list of 
	hosts that have specific session limits - allowing 
	certain machines, such as shell servers, to carry 
	more than the default number of clients at a time. 
	Once a host reaches it's session limit, all clients 
	attempting to connect from that host will be
	killed. Before the user is killed, they are notified, via a
	/NOTICE from %S, of a source of help regarding session
	limiting. The content of this notice is a config setting.
	
	EXCEPTION ADD adds the given host mask to the exception list.
	Note that nick!user@host and user@host masks are invalid!
	Only real host masks, such as box.host.dom and *.host.dom,
	are allowed because sessions limiting does not take nick or
	user names into account. limit must be a number greater than
	or equal to zero. This determines how many sessions this host
	may carry at a time. A value of zero means the host has an
	unlimited session limit. See the AKILL help for details about
	the format of the optional expiry parameter.
	EXCEPTION DEL removes the given mask from the exception list.
	EXCEPTION MOVE moves exception num to position. The
	exceptions inbetween will be shifted up or down to fill the gap.
	EXCEPTION LIST and EXCEPTION VIEW show all current
	exceptions; if the optional mask is given, the list is limited
	to those exceptions matching the mask. The difference is that
	EXCEPTION VIEW is more verbose, displaying the name of the
	person who added the exception, it's session limit, reason, 
	host mask and the expiry date and time.
	
	Note that a connecting client will "use" the first exception
	their host matches. Large exception lists and widely matching
	exception masks are likely to degrade services' performance.
	
	Dostpne dla Adminw serwisw.

OPER_HELP_SESSION
	Syntax: SESSION LIST threshold
	        SESSION VIEW host
	
	Allows Services admins to view the session list.

	SESSION LIST lists hosts with atleast threshold sessions.
	The threshold must be a number greater than 1. This is to 
	prevent accidental listing of the large number of single 
	session hosts.
	SESSION VIEW displays detailed information about a specific
	host - including the current session count and session limit.
	The host value may not include wildcards.

	See the EXCEPTION help for more information about session
	limiting and how to set session limits specific to certain
	hosts and groups thereof.
	
	Dostpne dla administratorw serwisw.

OPER_HELP_STAFF
	Skadnia: STAFF

	Displays all Services Staff nicks along with level
	and on-line status.

OPER_HELP_DEFCON
	Skadnia: DEFCON [1|2|3|4|5]

	The defcon system can be used to implement a pre-defined
	set of restrictions to services useful during an attemtped
	attack on the network.

OPER_HELP_DEFCON_NO_NEW_CHANNELS
	* No new channel registrations
OPER_HELP_DEFCON_NO_NEW_NICKS
	* No new nick registrations
OPER_HELP_DEFCON_NO_MLOCK_CHANGE
	* No MLOCK changes
OPER_HELP_DEFCON_FORCE_CHAN_MODES
	* Force Chan Modes (%s) to be set on all channels
OPER_HELP_DEFCON_REDUCE_SESSION
	* Use the reduced session limit of %d
OPER_HELP_DEFCON_NO_NEW_CLIENTS
	* Kill any NEW clients connecting
OPER_HELP_DEFCON_OPER_ONLY
	* Ignore any non-opers with message
OPER_HELP_DEFCON_SILENT_OPER_ONLY
	* Silently ignore non-opers
OPER_HELP_DEFCON_AKILL_NEW_CLIENTS
	* AKILL any new clients connecting
OPER_HELP_DEFCON_NO_NEW_MEMOS
	* No new memos sent
OPER_HELP_CHANKILL
	Syntax: CHANKILL [+expiry] channel reason

	Puts an AKILL for every nick on the specified channel. It
	uses the entire and complete real ident@host for every nick,
	then enforces the AKILL. 

###########################################################################
#
# News system messages
#
###########################################################################

NEWS_LOGON_TEXT
	[Wiadomo powitalna - %s] %s
NEWS_OPER_TEXT
	[Wiadomoi powitalna dla i@ - %s] %s
NEWS_RANDOM_TEXT
	[Losowa wiadomo powitalna - %s] %s

NEWS_LOGON_SYNTAX
	Skadnia: LOGONNEWS {ADD|DEL|LIST} [tekst|numer]
NEWS_LOGON_LIST_HEADER
	Logon news items:
NEWS_LOGON_LIST_ENTRY
	%5d (%s by %s)
	    %s
NEWS_LOGON_LIST_NONE
	Nie ma niusw powitalnych.
NEWS_LOGON_ADD_SYNTAX
	Skadnia: LOGONNEWS ADD tekst
NEWS_LOGON_ADD_FULL
	Lista niusw jest pena!
NEWS_LOGON_ADDED
	Dodano powitalnego niusa (#%d).
NEWS_LOGON_DEL_SYNTAX
	Skadnia: LOGONNEWS DEL {numer | ALL}
NEWS_LOGON_DEL_NOT_FOUND
	Wiadomo powitalna #%d nie znaleziona!
NEWS_LOGON_DELETED
	Wiadomo powitalna #%d zostaa skasowana.
NEWS_LOGON_DEL_NONE
	Nie ma wiadomoci powitalnych do skasowania!
NEWS_LOGON_DELETED_ALL
	Wszystkie wiadomoci powitalne zosta skasowane :(.

NEWS_OPER_SYNTAX
	Skadnia: OPERNEWS {ADD|DEL|LIST} [text|num]
NEWS_OPER_LIST_HEADER
	Oper-nius lista:
NEWS_OPER_LIST_ENTRY
	%5d (%s by %s)
	    %s
NEWS_OPER_LIST_NONE
	Nie ma oper-niusw.
NEWS_OPER_ADD_SYNTAX
	Skadnia: OPERNEWS ADD text
NEWS_OPER_ADD_FULL
	Lista wiadomoci jest pena!
NEWS_OPER_ADDED
	Dodano oper-niusa (#%d).
NEWS_OPER_DEL_SYNTAX
	Syntax: OPERNEWS DEL {num | ALL}
NEWS_OPER_DEL_NOT_FOUND
	Oper-nius #%d nie zosta znaleziony!
NEWS_OPER_DELETED
	Oper-nius #%d zosta skasowany.
NEWS_OPER_DEL_NONE
	Nie ma oper-niusw do skasowania!
NEWS_OPER_DELETED_ALL
	Wszystkie oper-niusy zostay skasowane :(.

NEWS_RANDOM_SYNTAX
	Syntax: RANDOMNEWS {ADD|DEL|LIST} [text|num]
NEWS_RANDOM_LIST_HEADER
	Losowe niusy:
NEWS_RANDOM_LIST_ENTRY
	%5d (%s by %s)
	    %s
NEWS_RANDOM_LIST_NONE
	Nie ma adnych losowych niusw.
NEWS_RANDOM_ADD_SYNTAX
	Syntax: RANDOMNEWS ADD text
NEWS_RANDOM_ADD_FULL
	Lista niusw jest pena!
NEWS_RANDOM_ADDED
	Nowy nius losowy zosta dodany (#%d).
NEWS_RANDOM_DEL_SYNTAX
	Syntax: RANDOMNEWS DEL {num | ALL}
NEWS_RANDOM_DEL_NOT_FOUND
	Losowy nius #%d nie zosta znaleziony!
NEWS_RANDOM_DELETED
	Nius losowy #%d zosta skasowany.
NEWS_RANDOM_DEL_NONE
	Nie ma losowych niusw do skasowania!
NEWS_RANDOM_DELETED_ALL
	Wszystkie losowe niusy zostay skasowane :(.

NEWS_HELP_LOGON
	Skadnia: LOGONNEWS ADD text
	          LOGONNEWS DEL {num | ALL}
	        LOGONNEWS LIST
	
	Edits or displays the list of logon news messages.  When a
	user connects to the network, these messages will be sent
	to them.  (However, no more than three messages will be
	sent in order to avoid flooding the user.  If there are
	more than three news messages, only the three most recent
	will be sent.)
	
	LOGONNEWS LIST may be used by any IRC operator to list the
	current news messages.  ADD and DEL may only be used by
	Services admins.

NEWS_HELP_OPER
	Syntax: OPERNEWS ADD text
	        OPERNEWS DEL {num | ALL}
	        OPERNEWS LIST
	
	Edits or displays the list of oper news messages.  When a
	user opers up (with the /OPER command), these messages will
	be sent to them.  (However, no more than three messages will
	be sent in order to avoid flooding the user.  If there are
	more than three news messages, only the three most recent
	will be sent.)
	
	OPERNEWS LIST may be used by any IRC operator to list the
	current oper news messages.  ADD and DEL may only be used by
	Services admins.

NEWS_HELP_RANDOM
	Syntax: RANDOMNEWS ADD text
	        RANDOMNEWS DEL {num | ALL}
	        RANDOMNEWS LIST
	
	Edits or displays the list of random news messages.  When a
	user connects to the network, one (and only one) of the
	random news will be randomly chosen and sent to them.
	
	RANDOMNEWS LIST may be used by any IRC operator to list the
	current news messages.  ADD and DEL may only be used by
	Services admins.

###########################################################################
#
# HelpServ help message
#
###########################################################################

HELP_HELP
	%S jest serwisem udzielajcym pomocnych
	informacji na temat innych serwisw. 
	Dostpne tematy pomocy: 

	%R%s HELP
	     Informacje na temat rejestrowania i kontroli 
	     nickw.

	%R%s HELP
	     Informacje na temat rejestrowania i kontroli 
	     kanaw.

	%R%s HELP
	     Informacje na temat zostawiania wiadomoci dla 
	     uytkownikw offline.

HELP_HELP_BOT

	%R%s HELP
	     Informacje na temat stawiania bota na swoim 
	     kanale.

HELP_HELP_HOST

	%R%s HELP
	     informacja na temat ustawiania vhostw.

###########################################################################
#
# HELP NickServ 
#
###########################################################################
NICK_HELP_CMD_CONFIRM
	    CONFIRM    Confirm a nickserv auth code
NICK_HELP_CMD_RESEND
	    RESEND     Resend a nickserv auth code

NICK_HELP_CMD_REGISTER
	   REGISTER   Rejestracja nicka.
NICK_HELP_CMD_GROUP
	   GROUP      Stworzenie grupy wasnych nickw.      
NICK_HELP_CMD_IDENTIFY
	   IDENTIFY   Identyfikacja nicka za pomoc hasa.
NICK_HELP_CMD_ACCESS
	   ACCESS     Modyfikacje listy dostpu.
NICK_HELP_CMD_SET
	   SET        Ustawienia rnych opcji nicka.
NICK_HELP_CMD_SASET
	    SASET      Set SET-options on another nickname
NICK_HELP_CMD_DROP
	   DROP       Odrejestruj nicka.
NICK_HELP_CMD_RECOVER
	   RECOVER    Odzyskuje Twojego nicka.
NICK_HELP_CMD_RELEASE
	   RELEASE    Zwalnia nick po opcji RECOVER.
NICK_HELP_CMD_SENDPASS
	   SENDPASS   Zapomniane haso? Sprbuj tego.
NICK_HELP_CMD_GHOST
	    GHOST      Disconnects a "ghost" IRC session using your nick
NICK_HELP_CMD_ALIST
	    ALIST      List channels you have access on
NICK_HELP_CMD_GLIST
	    GLIST      Lists all nicknames in your group
NICK_HELP_CMD_INFO
	    INFO       Displays information about a given nickname
NICK_HELP_CMD_LIST
	    LIST       List all registered nicknames that match a given pattern
NICK_HELP_CMD_LOGOUT
	    LOGOUT     Reverses the effect of the IDENTIFY command
NICK_HELP_CMD_STATUS
	    STATUS     Returns the owner status of the given nickname
NICK_HELP_CMD_UPDATE
	    UPDATE     Updates your current status, i.e. it checks for new memos
NICK_HELP_CMD_GETPASS
	    GETPASS    Odzyskanie hasa dla nicka (tylko przy wyczonym szyfrowaniu)
NICK_HELP_CMD_GETEMAIL
	    GETEMAIL   Wywietla pasujcych uytkownikw zarejestrowanych z podanym 
	               e-mailem
NICK_HELP_CMD_FORBID
	    FORBID     Zabrania rejestracji podanego nicka.
NICK_HELP_CMD_SUSPEND
	    SUSPEND    Suspend a given nick
NICK_HELP_CMD_UNSUSPEND
	    UNSUSPEND  Unsuspend a given nick

NICK_HELP
	%S umoliwia Tobie zarejestrowanie wasnego 
	nicka. Dzieki rejestracji tylko Ty bedziesz go mg 
	uywa oraz uzyskasz dostp do dodatkowych opcji. 
	Aby ich uy wpisz %R%S komenda.
	Wicej informacji na temat konkretnej komendy mona 
	uzyska piszc:
	%R%S HELP komenda.
	
NICK_HELP_FOOTER
	INFO: Ten serwis ma na celu identyfikacj 
	uytkownikw bez wzgldu na host czy zmienne IP.
	To NIE jest po to, aby zajmowa komu nicka, 
	ale obowizuje zasada: kto pierwszy ten lepszy.
	Jeli chciae mie nicka takiego jak imi, jest 
	ju zajty - wymyl co nowego. Kradziee nicka czy 
	naduycia %S bd owocoway, w najlejszym 
	przypadku, utrat zarejestrowanego nicka.
	
	
NICK_HELP_EXPIRES
	
	Nick nieuywany przed duszy czas podlega prawu 
	wygasania. Zostanie on automatycznie odrejestrowany 
	jeli, nie bdzie uywany przez %d dni. Wraz 
	z wyganiciem nicka utracisz wszystkie opcje, 
	poziomy dostpu na kanaach, a take kana, ktry 
	jest zarejestrowany na ten nick.

NICK_HELP_REGISTER
	Skadnia: REGISTER haso [email]
	
	Rejestruje Twj nick w bazie %S. Po rejstracji 
	moesz uy komend SET i ACCESS aby 
	skonfigurowa niektre opcje nicka wedle upodoba.  
	Upewnij si, e pamitasz haso rejestracyjne, bo 
	bdzie Ci ono potrzebne w przyszoci dla zmian 
	ustawie i identyfikacji. Wielko liter w hale 
	ma znaczenie!!!.
	
	Jak wybra haso?
	
	Haso musi by trudne do odgadnicia. Przykadowo,
	uycie Twojego imienia jako hasa jest niewskazane.
	Uy Twojego nicka jako hasa rwnie nie moesz, 
	%S nie pozwoli na co takiego. 
	Bardzo krtkie haso jest do odgadnicia metod prb 
	i bdw. Twoje haso musi mie dugo conajmniej 
	5 znakw. Znak spacji nie moe by uyty w hale.
	
	Parametr email jest opcjonalny i od razu przy 
	rejestracji ustawia adres e-mail dla Twojego nicka. 
	Moe si zdarzy, e adres e-mail moe by wymagany 
	na niektrych sieciach. Twoja prywatno jest pod 
	ochron - e-mail nie bdzie znany osobom trzecim. 
	
	Wraz z rejestracj zostaje utworzona grupa dla 
	Twojego nicka. Nicki z tej samej grupy maj t sam 
	konfiguracj, te same prawa na kanale oraz 
	ustawienia memo. Jeli chcesz uzyska wicej 
	informacji na ten temat, napisz: 
	%R%S HELP GROUP.
	
NICK_HELP_GROUP
	Skadnia: GROUP nazwa haso
	
	Ta komenda dodaje Twj nick do grupy nickw o 
	nazwie nazwa.
	Haso jest hasem Twojego nicka.
	
	Uczestnictwo w grupie pozwala na udostpnienie 
	Twojej konfiguracji, wiadomoci, praw kanaowych i 
	nie tylko tego dla wszystkich nickw nalecych do 
	tej samej groupy. Jeli uywasz kilku nickw to 
	ta opcja powinna Ci si przyda.
	 
	Grupa przechowuje wszystkie waciwoci nicka. Wic 
	jeli jeden nick zostanie odrejestrowany, nic si 
	nie stanie. Grupa przestaje istnie dopiero wtedy, 
	kiedy nie bdzie w niej adnego nicka.
	
	Moesz uy tej komendy nawet jeli jeszcze nie masz 
	zarejestrowanego nicka. Jeli Twj nick jest ju 
	zarejestrowany to przed uyciem tej komendy musisz 
	si zidentyfikowa. 
	Napisz %R%S HELP IDENTIFY aby uzyska 
	wicej informacji o identyfikacji. 
	
	Uycie tej komendy dla niezarejestrowanego 
	nicka jest polecane, poniewa zostanie on 
	automatycznie zarejestrowany po uyciu tej komendy. 
	Moesz jej te uy przy zarejestrowanym nicku (aby 
	zmieni swoj grup), ale tylko wtedy, jeli 
	administratorzy sieci tak moliwo udostpnili.
	
	Moesz nalee jednoczenie tylko do jednej grupy. 
	czenie grup jest niemoliwe.
	
	Informacja: wszystkie nicki z tej samej grupy 
	maj takie samo haso. Pamitaj o tym.

NICK_HELP_IDENTIFY
	Skadnia: IDENTIFY haso
	
	Informuje %S, e nick ktry wanie uywasz 
	naley do Ciebie. Wiele komend wymaga identyfikacji 
	przed ich uyciem. Haso to jest to samo haso 
	jakiego uyto przy komendzie REGISTER.

NICK_HELP_UPDATE
	Skadnia: UPDATE

	Aktualizuje Twj aktualny status, czyli sprawdza 
	czy nie masz, nowych wiadomoci, ustawia wymagane 
	mody na kanale, aktualizuje Twj host oraz Twoje 
	flagi uytkownika.
	
NICK_HELP_LOGOUT
	Skadnia: LOGOUT
	
	Komenda ta ma dziaanie odwrotne do komendy 
	IDENTIFY. Jednym sowem zapomina identyfikacje 
	Twojego nicka i odbiera Ci prawa zidentyfikowanego 
	uytkownika. Po tej komendzie nie zostanie Ci zadane 
	pytanie czy chcesz si ponownie zidentyfikowa. 

NICK_HELP_DROP
	Skadnia: DROP [nick]
	
	Usuwa rejestracj Twojego nicka z bazy %S. 
	Nick, ktry jest odrejestrowany staje si wolnym 
	nickiem i moe by potem zarejestrowany na nowo 
	przez kogo innego. 
	UWAGA: po odrejestrowaniu oczywicie stracisz
	wpisy na kanaowych listach dostpu. 
	
	Przed uyciem tej komendy naley si wpierw
	zidentyfikowa za pomoc hasa nicka 
	(%R%S HELP IDENTIFY aby uzyska
	wicej informacji).

NICK_HELP_ACCESS
	Skadnia: ACCESS ADD maska
		  ACCESS DEL maska
	          ACCESS LIST
	
	Modyfikuje lub wywietla list dostpu dla Twojego 
	nicka. To jest lista hostw, ktre zostan 
	automatycznie rozpoznane przez %S jako hosty, z 
	ktrych Twj nick si moe czy. Jeli chcesz 
	uywa nicka z innego hosta musisz wpierw uy 
	komendy IDENTIFY aby %S mg Ciebie rozpozna.
	
	Przykady:
	
	    ACCESS ADD userek@ircnet.pl
	        Zezwala na dostp do nicka kademu 
		czcemu si z domeny ircnet.pl.
	
	    ACCESS DEL userek@ircnet.pl
	        Odwraca efekt poprzedniej komendy.
	
	    ACCESS LIST
	        Wywietla aktualn liste dostpu.

NICK_HELP_SET
	Skadnia: SET opcja parametry
	
	Ustawienia zmiennych opcji nicka. 
	Moliwe opcje to:
	
	    DISPLAY    Ustawienia wywietlania Twojej grupy 
	               nickw.
	    PASSWORD   Ustawienia hasa Twojego nicka.
	    LANGUAGE   Ustawienia jzyka w jakim serwisy 
	               bd do Ciebie wysya odpowiedzi.
	    URL        Przypisz adres WWW do Twojego nicka.
	    EMAIL      Przypisz adres e-mail do Twojego 
	               nicka.
	    ICQ        Przypisz numer ICQ do Twojego nicka.
	    GREET      Przypisz wiadomo powitaln do 
	               Twojego nicka.
	    KILL       Wcz/Wycz ochrone nicka.
	    SECURE     Wcz/Wycz bezpieczestwo nicka.
	    PRIVATE    Ukryj dane nicka przy komendzie LIST
	             %R%S LIST
	    HIDE       Ukryj pewne informacje o nicku.
	    MSG        Zmie sposb komunikacji z serwisami.
	    AUTOOP     Should services op you automatically.    
	
	Przed uyciem tej komendy trzeba si wpierw 
	zidentyfikowa za pomoc hasa nicka 
	(%R%S HELP IDENTIFY aby uzyska
	wicej informacji).
	
	Napisz %R%S HELP SET opcja aby 
	uzyska pomoc na temat wybranej opcji.

NICK_HELP_SET_DISPLAY
	Skadnia: SET DISPLAY nowa-nazwa
	
	Zmienia nazwe reprezentujc Twoj grupe nickw w 
	serwisach. Now nazw MUSI by nick z Twojej grupy 
	nickw.

NICK_HELP_SET_PASSWORD
	Skadnia: SET PASSWORD nowe-haso
	
	Zmienia Twoje haso do nicka.

NICK_HELP_SET_LANGUAGE
	Skadnia: SET LANGUAGE numer
	
	Zmienia jzyk jakiego uywaj serwisy odpowiadajc 
	Tobie (czyli przykadowo kiedy odpowiadaj na 
	wysan przez Ciebie komend). Numer moe by 
	wybrany z nastpujcej listy obsugiwanych jzykw:
	

NICK_HELP_SET_URL
	Skadnia: SET URL adres
	
	Przypisuje adres WWW Twojemu nickowi, ktry bdzie 
	wywietlany przy opisie Twojego nicka, dostpnym
	przy uyciu komendy INFO.

NICK_HELP_SET_EMAIL
	Skadnia: SET EMAIL adres
	
	Przypisuje adres e-mail Twojemu nickowi, ktry 
	bdzie wywietlany przy opisie Twojego nicka, 
	dostpnym przy uyciu komendy INFO.
			
NICK_HELP_SET_ICQ
	Skadnia: SET ICQ numer
	
	Przypisuje numer ICQ Twojemu nickowi, ktry to 
	bdzie wywietlany przy opisie Twojego nicka, 
	dostpnym przy uyciu komendy INFO.			

NICK_HELP_SET_GREET
	Skadnia: SET GREET wiadomo
	
	Tworzy wiadomo powitaln dla Twojego nicka, ktra 
	bdzie wywietlana podczas wchodzenia na kana, w 
	ktrym opcja GREET jest wczona, ale tylko pod 
	warunkiem posiadania przez Ciebie wymaganego poziomu 
	dostpu na tym kanale.

NICK_HELP_SET_KILL
	Skadnia: SET KILL {ON | QUICK | IMMED | OFF}
	
	Wcza/Wycza automatyczn ochron dla Twojego 
	nicka. Kiedy ochrona jest aktywna i inny uytkownik 
	sprbuje uy Twojego nicka, wtedy bdzie mia 
	minut na jego zwolnienie pod grob auto-zmiany 
	przez %S jego nicka na inny lub usunicia
	tego uytkownika z sieci.
	
	Jeli wybierzesz opcj QUICK, to uytkownik 
	bdzie mia tylko 20 sekund na zmian nicka zamiast 
	standardowych 60. Jeli natomiast wybierzesz opcje 
	IMMED, to uytkownik natychmiastowo bez 
	jakiegokolwiek ostrzeenia poniesie konsekwencje 
	opisane akapit wyej. Prosz nie uywa tej opcji 
	bez wyranej koniecznoci. Administratorzy sieci 
	mog t opcje wyczy.

NICK_HELP_SET_SECURE
	Skadnia: SET SECURE {ON | OFF}
	
	Wcza/Wycza %S opcje bezpieczestwa dla Twojego 
	nicka. Gdy opcja SECURE jest wczona, musisz 
	podawa swoje haso (identyfikowa si) zanim 
	zostaniesz rozpoznany(a) jako waciciel(ka) nicka, 
	bez wzgldu na to czy Twj host jest na licie 
	dostpu czy nie. Jednake jeli ju bdziesz na 
	licie dostpu, %S nie skilluje Ci bez 
	wzgldu na  ustawienie opcji KILL.

NICK_HELP_SET_PRIVATE
	Skadnia: SET PRIVATE {ON | OFF}
	
	Wcza/Wycza %S opcj prywatnoci dla Twojego nicka.
	Gdy opcja PRIVATE jest wczona Twj nick nie 
	bdzie widnia na licie pokazywanej po uyciu 
	komendy LIST w %S. (Jednake, 
	ktokolwiek bdzie zna Twj nick wci
	bdzie mg uzyska informacje przy pomocy komendy 
	INFO)

NICK_HELP_SET_HIDE
	Skadnia: SET HIDE {EMAIL | STATUS | USERMASK | QUIT} {ON | OFF}
	
	Pozwala Tobie ukry pewne informacje, ktre s 
	wywietlane po uyciu komendy INFO w %S na Twj 
	nick. Moesz ukry adres e-mail (EMAIL), 
	ostatnio widzian maske ident@host (USERMASK), 
	Twoj rang w serwisach (STATUS), a take 
	ostatni wiadomo przy wychodzeniu (QUIT). 
	Drugi parametr okrela czy informacje maj by 
	wywietlane (OFF) czy ukrywane (ON).
	
NICK_HELP_SET_MSG
	Skadnia: SET MSG {ON | OFF}
	
	Pozwala Ci wybra sposb w jaki serwisy bd Ci 
	odpowiada. Gdy opcja MSG jest wczona, 
	serwisy bd uywa wiadomoci na privie(query), 
	gdy jest wyczona, wtedy bd uywa komunikatw
	notice.

NICK_HELP_SET_AUTOOP
	Syntax: SET AUTOOP {ON | OFF}
	
	Sets whether you will be opped automatically. Set to ON to 
	allow ChanServ to op you automatically when entering channels.

NICK_HELP_SASET
	Syntax: SASET nickname option parameters.
	
	Sets various nickname options.  option can be one of:
	
	    DISPLAY    Set the display of the group in Services
	    PASSWORD   Set the nickname password
	    URL        Associate a URL with the nickname
	    EMAIL      Associate an E-mail address with the nickname
	    ICQ        Associate an ICQ number with the nickname
	    GREET      Associate a greet message with the nickname
	    KILL       Turn protection on or off
	    SECURE     Turn nickname security on or off
	    PRIVATE    Prevent the nickname from appearing in a
	                   %R%S LIST
	    HIDE       Hide certain pieces of nickname information
	    MSG        Change the communication method of Services
	    NOEXPIRE   Prevent the nickname from expiring
	
	Type %R%S HELP SASET option for more information
	on a specific option. The options will be set on the given
	nickname. 
	
	Limited to Services admins.

NICK_HELP_SASET_DISPLAY
	Syntax: SASET nickname DISPLAY new-display
	
	Changes the display used to refer to the nickname group in 
	Services. The new display MUST be a nick of the group.
	
	Limited to Services admins.

NICK_HELP_SASET_PASSWORD
	Syntax: SET nickname PASSWORD new-password
	
	Changes the password used to identify as the nick's	owner.
	
	Limited to Services admins.

NICK_HELP_SASET_URL
	Syntax: SASET nickname URL url
	
	Associates the given URL with the nickname.  This URL
	will be displayed whenever someone requests information
	on the nick with the INFO command.
	
	Limited to Services admins.

NICK_HELP_SASET_EMAIL
	Syntax: SASET nickname EMAIL address
	
	Associates the given E-mail address with the nickname.
	
	Limited to Services admins.
	
NICK_HELP_SASET_ICQ
	Syntax: SASET nickname ICQ number
	
	Associates the given ICQ number with the nickname.  This 
	number will be displayed whenever someone requests 
	information on the nick with the INFO command.
	
	Limited to Services admins.
	
NICK_HELP_SASET_GREET
	Syntax: SASET nickname GREET message
	
	Makes the given message the greet of the nickname, that
	will be displayed when joining a channel that has GREET
	option enabled, provided that the user has the necessary 
	access on it.
	
	Limited to Services admins.

NICK_HELP_SASET_KILL
	Syntax: SASET nickname KILL {ON | QUICK | IMMED | OFF}
	
	Turns the automatic protection option for the nick
	on or off.  With protection on, if another user
	tries to take the nick, they will be given one minute to
	change to another nick, after which %S will forcibly change
	their nick.
	
	If you select QUICK, the user will be given only 20 seconds
	to change nicks instead of the usual 60.  If you select
	IMMED, user's nick will be changed immediately without being
	warned first or given a chance to change their nick; please
	do not use this option unless necessary.  Also, your
	network's administrators may have disabled this option.
	
	Limited to Services admins.

NICK_HELP_SASET_SECURE
	Syntax: SASET nickname SECURE {ON | OFF}
	
	Turns %S's security features on or off for your
	nick.  With SECURE set, you must enter your password
	before you will be recognized as the owner of the nick,
	regardless of whether your address is on the access
	list.  However, if you are on the access list, %S
	will not auto-kill you regardless of the setting of the
	KILL option.
	
	Limited to Services admins.

NICK_HELP_SASET_PRIVATE
	Syntax: SASET nickname PRIVATE {ON | OFF}
	
	Turns %S's privacy option on or off for the nick.
	With PRIVATE set, the nickname will not appear in
	nickname lists generated with %S's LIST command.
	(However, anyone who knows the nickname can still get
	information on it using the INFO command.)
	
	Limited to Services admins.

NICK_HELP_SASET_HIDE
	Syntax: SASET nickname HIDE {EMAIL | STATUS | USERMASK | QUIT} {ON | OFF}
	
	Allows you to prevent certain pieces of information from
	being displayed when someone does a %S INFO on the
	nick.  You can hide the E-mail address (EMAIL), last seen
	user@host mask (USERMASK), the services access status
	(STATUS) and  last quit message (QUIT).
	The second parameter specifies whether the information should
	be displayed (OFF) or hidden (ON).
	
	Limited to Services admins.
	
NICK_HELP_SASET_MSG
	Syntax: SASET nickname MSG {ON | OFF}
	
	Allows you to choose the way Services are communicating with 
	the given user. With MSG set, Services will use messages,
	else they'll use notices.
	
	Limited to Services admins.

NICK_HELP_SASET_NOEXPIRE
	Syntax: SASET nickname NOEXPIRE {ON | OFF}
	
	Sets whether the given nickname will expire.  Setting this
	to ON prevents the nickname from expiring.
	
	Limited to Services admins.

NICK_HELP_SASET_AUTOOP
	Syntax: SASET nickname AUTOOP {ON | OFF}
	
	Sets whether the given nickname will be opped automatically.
	Set to ON to allow ChanServ to op you automatically when joining
	channels.
	
	Limited to Services admins.

NICK_HELP_RECOVER
	Skadnia: RECOVER nick [haso]
	
	Umoliwia odzyskanie Twojego nicka w wypadku gdy 
	kto go aktualnie uywa. Tej opcji uywa %S 
	automatycznie, gdy kto prbuje uy nicka 
	chronionego opcj KILL.
	
	Gdy uyjesz tej komendy, %S wprowadzi na sie 
	serwis bota z identycznym nickiem jak nick tego 
	uytkownika, ktry uywa Twojego nicka. To 
	spowoduje, e serwer IRC odczy od sieci 
	uytkownika uywajcego Twojego nicka. Ten serwis 
	bot bdzie obecny minut na sieci zabezpieczajc,
	aby uytkownik po ponownym poczeniu nie zaj 
	ponownie Twojego nicka. Po upywie minuty moesz 
	wej na swj nick. Jeli nie masz zamiaru tyle 
	czeka musis uy komendy 
	RELEASE (%R%S HELP RELEASE) aby 
	zarzda natychmiastowego zwrotu nicka od serwisw.
	
	Aby mc uy komendy RECOVER, musisz spenia, 
	ktry z warunkw: 
	1. Twj obecny adres (ten z /whois) musi by na 
	licie dostpu, 
	2. musisz by zidentyfikowany i by w grupie tego 
	nicka albo 
	3. musisz poda haso do nicka.
					
NICK_HELP_RELEASE
	Skadnia: RELEASE nick [haso]
	
	Informuje %S aby przesta trzyma Twojego nicka po
	opcji RECOVER lub skutkach dziaania opcji 
	KILL. Domylnie nic jest trzymany przez jedn 
	minut, ta komenda ma za zadanie zwolni nicka 
	wczeniej.
	
	Aby mc uy komendy RELEASE, musisz spenia, 
	ktry z warunkw: 
	1. Twj obecny adres (ten z /whois) musi by na 
	licie dostpu, 
	2. musisz by zidentyfikowany i by w grupie tego 
	nicka albo 
	3. musisz poda haso do nicka.
				
			
NICK_HELP_GHOST
	Skadnia: GHOST nick [haso]
	
	Opcja likwiduje sesj-ducha Twojego nicka. Taka 
	sesja istnieje wtedy, gdy uytkownik nie jest 
	poczony, ale serwer IRC wci go widzi (i jego 
	nicka) - taki nick pozostaje na IRC przez pewien 
	czas do momentu, a serwer IRC go nie odczy. To 
	si moe zdarzy gdy Twj komputer si zawiesi, bd 
	padnie Twoje poczenie internetowe wtedy gdy 
	bdziesz siedzie na IRCu. Mimo i opcja ta suy 
	gwnie do usuwania martwych sesji, rwnie dobrze 
	mona jej uy zamiast skomplikowanej RECOVER, 
	aby odzyska swj nick.
	
	Aby mc uy komendy GHOST, musisz spenia, 
	ktry z warunkw: 
	1. Twj obecny adres (ten z /whois) musi by na 
	licie dostpu, 
	2. musisz by zidentyfikowany i by w grupie tego 
	nicka albo 
	3. musisz poda haso do nicka.			
	
NICK_HELP_INFO
	Skadnia: INFO nick [ALL]
	
	Wywietla informacje na temat wybranego nicka takie
	jak waciciel, kiedy ostatnio widziano, z jakiego 
	hosta oraz opcje nicka. Jeli jeste 
	zidentyfikowany(a) moesz uzyska wicej informacji 
	dopisujc na kocu komendy sowo ALL. Wtedy
	zostan Ci wywietlone wszystkie moliwe informacje 
	bez wzgldu na to czy jest nick ma opcj PRIVATE 
	czy nie.

NICK_HELP_LIST
	Skadnia: LIST wzr
	
	Wywietla wszystkie zarejestrowane nicki zgodnie z 
	podanym wzorem w postaci nick!ident@host. Nicki, 
	ktre maj wczon opcje PRIVATE nie zostan 
	wywietlone na licie.
	
	Przykady:
	
	    LIST *!adirm@mafia.ru
	        Lista wszystkich nickw z mask 
		*!adirm@mafia.ru.
	
	    LIST *Bot*!*@*
	        Lista wszystkich nickw z Bot w nazwie 
		(wielko liter nie ma znaczenia).
	
	    LIST *!*@*.ircnet.pl
	        Lista wszystkich nickw z mask domeny 
		ircnet.pl

NICK_HELP_ALIST
	Skadnia: ALIST [poziom]
	
	Lista wszystkich kanaw na ktrych jeste w licie 
	dostpu. Opcjonalnie moesz poda poziom XOP lub 
	zwyky numer poziomu. Wyniki wywietl kanay, gdzie 
	masz wybrany poziom dostpu.

	Przykady:
	    ALIST Founder
	        Lista wszystkich kanaw, na ktrych jeste 
	        zaoycielem(k) - czyli posiadasz status 
	        foundera.

	    ALIST AOP
	        Lista wszystkich kanaw, na ktrych masz 
	        poziom AOP w licie dostpu lub wikszy.

	    ALIST 10
	        Lista wszystkich kanaw, na ktrych masz 
	        10-ty poziom w licie dostpu lub wyszy.

	Kanay z opcj NOEXPIRE bd oznaczone znaczkiem
	wykrzyknika (!).

NICK_HELP_GLIST
	Skadnia: GLIST
	
	Lista wszystkich nickw znajdujcych si w Twojej 
	grupie.

NICK_HELP_STATUS
	Skadnia: STATUS nick...
	
	Zwraca informacj czy uytkownik uywajcy danego 
	nicka jest rozpoznany aktualnie jako jego 
	waciciel. Odpowied ma nastpujc skadni:
	
	    nick kod
	
	Gdzie nick jest tym nickiem wysanym w 
	komendzie, a kod moe oznacza:
	
	0 - nie ma uytkownika online lub nick 
	    niezarejestrowany.
	1 - uytkownik nie jest rozpoznany jako waciciel 
	    nicka.
	2 - jest rozpoznany jako waciciel na podstawie 
	    listy dostpu.
	3 - jest rozpoznany jako waciciel na podstawie 
	    identyfikacji.
	
	Maksymalnie mona poda 16 nickw za jednym razem. 
	Reszta bdzie ignorowana. If no nickname is given, your status
	will be returned.

NICK_HELP_SENDPASS
	Skadnia: SENDPASS nick
	
	Wysya haso podanego nicka na adres e-mail 
	przyporzdkowany danemu nickowi. Jest to bardzo 
	uyteczna komenda do odzyskiwania 
	straconych/zapomnianych hase.
	
	Moe by organiczona do IRC operatorw na 
	niektrych sieciach.
	
	Ta komenda jest bezuyteczna (niedostpna) wtedy 
	gdy hasa s szyfrowane.

NICK_HELP_CONFIRM
	Syntax: CONFIRM passcode
	
	This is the second step of nickname registration process.
	You must perform this command in order to get your nickname
	registered with %S. The passcode (or called auth code also)
	is sent to your e-mail address in the first step of the
	registration process. For more information about the first
	stage of the registration process, type: %R%S HELP REGISTER

NICK_SERVADMIN_HELP
	Administratorzy Serwisw mog odrejestrowa kady 
	nick bez potrzeby identyfikacji dla niego i mog 
	widzie list dostpu dla kadego nicka 
	(%R%S ACCESS LIST nick).

NICK_SERVADMIN_HELP_LOGOUT
	Skadnia: LOGOUT [nick [REVALIDATE]]
	
	Komenda ma odwrotne dziaanie do komendy IDENTIFY 
	czyli zapomina identifikacje nicka oraz odbiera Ci 
	prawa zidentyfkowanego uytkownika. Po tej komendzie 
	nie padnie pytanie o ponown identyfikacje.
	
	Bez adnego parametru komenda bdzie si odnosi do 
	Ciebie. Jeli wpiszesz nick to dziaanie bdzie 
	dotyczy tego nicka, ale w tym przypadku serwisy ju
	poprosz uytkownika o ponown identyfikacje tego 
	nicka. Ta komenda jest dostpna dla
	administratorw serwisw.

NICK_SERVADMIN_HELP_DROP
	Skadnia: DROP [nick]
	
	Bez adnego parametru, spowoduje odrejestrowanie 
	Twojego nicka z bazy %S.
	
	Natomiast z parametrem, odrejestruje wybranego nicka 
	z bazy.Moesz odrejestrowa kady nick w Twojej 
	grupie bez adnych dodatkowych uprawnie. 
	Odrejestrowywanie kadego nicka jest 
	dostpne tylko dla administratorw serwisw.

NICK_SERVADMIN_HELP_INFO
	
	Administratorzy serwisw mog uywa parametru 
	ALL dla kadego nicka.

NICK_SERVADMIN_HELP_LIST
	Skadnia: LIST wzr [FORBIDDEN] [NOEXPIRE] [UNCONFIRMED]
	
	Wywietla wszystkie zarejestrowane nicki zgodnie z 
	podanym wzorem w postaci nick!ident@host. Nicki, 
	ktre maj wczon opcje PRIVATE zostan 
	wywietlone tylko administratorom serwisw. Nicki z 
	flag NOEXPIRE zostan oznaczone znakiem ! 
	na licie dla administratorw serwisw.
	
	Jeli podane bd flagi FORBIDDEN, NOEXPIRE lub 
	UNCONFIRMED to wtedy nicki, ktre je posiadaj bd 
	wywietlone. Jeli wszystkie 3 opcje bd ustawione 
	to wszystkie 3 typy nickw bd wywietlone. Ta 
	opcja jest dostpna dla administratorw serwisw.  

	Przykady:
	
	    LIST *!adirm@mafia.ru
	        Lista wszystkich nickw z mask 
	        *!adirm@mafia.ru.
					   
	    LIST *Bot*!*@*
	        Lista wszystkich zarejestrowanych nickw z 
	      Bot w nazwie (wielko liter nie ma 
	        znaczenia).
					      
	    LIST * NOEXPIRE
	        Lista wszystkich nickw, ktre maj 
	        ustawion flage NOEXPIRE.

NICK_SERVADMIN_HELP_ALIST
	Skadnia: ALIST [nick] [poziom]
	
	Bez parametrw wywietla liste kanaw, na ktrych 
	jeste na licie dostpu. Z jednym parametrem 
	wywietli liste kanaw, na ktrych nick jest w 
	licie dostpu. Z dwoma parametrami pokazuje list 
	kanaw, na ktrych nick jest w licie dostpu z 
	poziomem dostpu conajmniej poziom.

	Dostpne tylko dla administratorw serwisw.

NICK_SERVADMIN_HELP_GLIST
	Skadnia: GLIST [nick]
	
	Bez parametrw wywietla liste wszystkich nickw w 
	Twojej grupie.
	
	Jeli jako parametr zostanie podany jaki nick to 
	zostan wywietlone wszystkie nicki bdce w grupie 
	razem z podanym nickiem.
	Dostpne tylko dla administratorw serwisw.

NICK_SERVADMIN_HELP_GETPASS
	Skadnia GETPASS nick
	
	Wywietla haso dla podanego nicka.Notka: 
	dokadna informacja o uyciu tej opcji (przez kogo, 
	dla jakiego nicka) zostanie wysana przy pomocy 
	WALLOP/GLOBOP.
	
	Dostpne tylko dla administratorw serwisw.
	
	Opcja jest niedostpna gdy szyfrowanie hase jest 
	wczone.

NICK_SERVADMIN_HELP_GETEMAIL
	Skadnia: GETEMAIL adres@email.com

	Wywietla nicki, ktre posiadaj podany adres 
	e-mail. 
	Notka nie mona uywa znakw zastpczych dla 
	uytkownika bd adresu e-mail. Kiedy ta komenda 
	jest uywana, jest logowana informacja kto jej uy 
	oraz jaki poda e-mail.

	Dostpna tylko dla administratorw serwisw.

NICK_SERVADMIN_HELP_FORBID
	Skadnia: FORBID nick [powd]
	
	Blokuje moliwo rejestracji wybranego nicka. Mona 
	j anulowa tylko przez odrejestrowanie 
	zablokowanego nicka.
	
	Dla maksymalnej pewnoci dziaania, powd jest 
	wymagany.
	
	Opcja tylko dla adminw serwisw.

###########################################################################
#
# HELP ChanServ
#
###########################################################################

NICK_SERVADMIN_HELP_SUSPEND
	Syntax: SUSPEND nickname reason / UNSUSPEND nickname

	SUSPENDs / UNSUSPENDs a nickname from being identified to
	
	Limited to Services admins.

###########################################################################
#
# ChanServ help messages
#
###########################################################################

NICK_SERVADMIN_HELP_UNSUSPEND
	Syntax: UNSUSPEND nickname

	UNSUSPENDS a nickname from being used.

	Limited to Services admins.

###########################################################################
#
# ChanServ help messages
#
###########################################################################
CHAN_HELP_CMD_GETPASS
	   GETPASS     Uzyskanie hasa waciciela dla 
	               wskazanego kanau 
CHAN_HELP_CMD_FORBID
	   FORBID      Zamknicie wskazanego kanau.
CHAN_HELP_CMD_SUSPEND
	   SUSPEND     Blokada kanau z zachowaniem 
	               wszelkich jego danych i ustawie.
CHAN_HELP_CMD_UNSUSPEND
	   UNSUSPEND   Odblokowanie kanau.
CHAN_HELP_CMD_STATUS
	   STATUS      Zwraca aktualny poziom dostpu do 
	               kanau wskazanego uytkownika.
CHAN_HELP_CMD_REGISTER
	    REGISTER   Rejestracja kanau.
CHAN_HELP_CMD_IDENTIFY
	    IDENTIFY   Identyfikacja waciciela kanau.
CHAN_HELP_CMD_SET
	    SET        Ustawienia rnych opcji kanau.
CHAN_HELP_CMD_AOP
	    AOP        Modyfikacje listy AOP kanau.
CHAN_HELP_CMD_SOP
	    SOP        Modyfikacje listy SOP kanau.
CHAN_HELP_CMD_ACCESS
	    ACCESS     Zarzdzanie kanaow list dostpu
CHAN_HELP_CMD_LEVELS
	    LEVELS     Zarzdzanie poziomami dostpu.
CHAN_HELP_CMD_AKICK
	    AKICK      Zarzdzanie kanaow list AKICK.
CHAN_HELP_CMD_DROP
	    DROP       Odrejestrowanie kanau.
CHAN_HELP_CMD_SENDPASS
	    SENDPASS   Odzyskanie utraconego hasa.
CHAN_HELP_CMD_BAN
	    BAN        Bans a selected nick on a channel
CHAN_HELP_CMD_CLEAR
	    CLEAR      Tells ChanServ to clear certain settings on a channel
CHAN_HELP_CMD_DEVOICE
	    DEVOICE    Devoices a selected nick on a channel
CHAN_HELP_CMD_GETKEY
	    GETKEY     Returns the key of the given channel
CHAN_HELP_CMD_INFO
	    INFO       Lists information about the named registered channel
CHAN_HELP_CMD_INVITE
	    INVITE     Tells ChanServ to invite you or a given nick into a channel
CHAN_HELP_CMD_KICK
	    KICK       Kicks a selected nick from a channel
CHAN_HELP_CMD_LIST
	    LIST       Lists all registered channels matching the given pattern
CHAN_HELP_CMD_LOGOUT
	    LOGOUT     This command will logout the selected nickname
CHAN_HELP_CMD_OP
	    OP         Gives Op status to a selected nick on a channel
CHAN_HELP_CMD_TOPIC
	    TOPIC      Manipulate the topic of the specified channel
CHAN_HELP_CMD_UNBAN
	    UNBAN      Remove all bans preventing you from entering a channel
CHAN_HELP_CMD_VOICE
	    VOICE      Voices a selected nick on a channel
CHAN_HELP_CMD_VOP
	    VOP        Maintains the VOP (VOicePeople) list for a channel
CHAN_HELP_CMD_DEHALFOP
	    DEHALFOP   Dehalfops a selected nick on a channel
CHAN_HELP_CMD_DEOWNER
	    DEOWNER    Removes your owner status on a channel
CHAN_HELP_CMD_DEPROTECT
	    DEPROTECT  Deprotects a selected nick on a channel
CHAN_HELP_CMD_HALFOP
	    HALFOP     Halfops a selected nick on a channel
CHAN_HELP_CMD_HOP
	    HOP        Maintains the HOP (HalfOP) list for a channel
CHAN_HELP_CMD_OWNER
	    OWNER      Gives you owner status on channel
CHAN_HELP_CMD_PROTECT
	    PROTECT    Protects a selected nick on a channel
CHAN_HELP_CMD_ADMIN
	    ADMIN      Protects a selected nick on a channel
CHAN_HELP_CMD_DEADMIN
	    DEADMIN    Deprotects a selected nick on a channel
CHAN_HELP_CMD_DEOP
	    DEOP       Deops a selected nick on a channel

CHAN_HELP
	%S pozwala na rejestracj oraz kontrol 
	poszczeglnych ustawie kanaw. %S ma na celu 
	uniemoliwi innym uytkownikom przejmowanie 
	kanaw, poprzez ograniczenie dostpu do statusu 
	operatora kanau. Dostpne komendy zostay podane 
	poniej, aby ich uy napisz:
	%R%S komenda. Aby uzyska wicej 
	informacji o poszczeglnych komendach, napisz: 
	%R%S HELP komenda.
	 
	
CHAN_HELP_EXPIRES
	
	Uwaga! Kana ktry nie by uywany od %d dni (np. 
	aden uytkownik umieszczony na access licie 
	kanau, nie odwiedzi go w tym czasie) zostanie 
	automatycznie odrejestrowany.

CHAN_HELP_REGISTER
	Skadnia: REGISTER kanal haso opis
	
	Rejestracja kanau w bazie %S. Aby mc uy tej 
	komendy, musisz posiada status operatora na kanale, 
	ktry chcesz zarejestrowa. Podane haso bdzie 
	wymagane w komendzie IDENTIFY, umoliwi dostp 
	do konfiguracji ustawie kanau. Ostatni parametr, 
	ktry musi zosta podany, jest oglnym opisem 
	kanau.
	
	W momencie zakoczenia rejestracji, jeste uznawany 
	za waciciela kanau. Waciciel(zaoyciel) moe 
	modyfikowa wszelkie ustawienia kanau, %S 
	automatycznie przyzna przysugujce uprawnienia 
	waciciela po jego wejciu na kana.
	Uywaj komendy ACCESS 
	(%R%S HELP ACCESS) aby 
	przyznawa wszelkie uprawnienia do operowania na 
	kanale innym uytkownikom.
	
	UWAGA: Aby mc zarejestrowa wasny kana, konieczna
	jest wczeniejsza rejestracja nicka. Opis tej 
	procedury otrzymasz po wydaniu polecenia: 
	%R%s HELP.

CHAN_HELP_IDENTIFY
	Skadnia: IDENTIFY kana haso
	
	Procedura identyfikacji, umoliwiajca rozpoznanie 
	przez %S jako zaoyciela kanau. Wiele komend 
	wymaga, aby dokona IDENTYFIKACJI przed ich 
	wydaniem. Haso musi by takie same, jak podane przy 
	rejestracji kanau.
	
CHAN_HELP_LOGOUT
	Skadnia: LOGOUT kana nick
	
	Komenda WYLOGOWANIA podanego nicka, sprawi e bdzie 
	on musia ponownie ZINDETYFIKOWA si aby mc 
	korzysta z nadanych uprawnie.
	
	Zaoyciel kanau moe wylogowa wszystkich 
	pozostaych uytkownikw; pozostae osoby, wylogowa 
	mog jedynie siebie.

CHAN_HELP_DROP
	Skadnia: DROP kana
	
	Odrejestrowuje podany kana. Komenda moe zosta 
	uyta jedynie przez waciciela kanau, po 
	uprzedniej IDENTIFYKACJI przy pomocy hasa
	kanau.

CHAN_HELP_SET
	Skadnia: SET kana opcja parametry
	
	Pozwala wacicielowi kanau na kontrol nad jego 
	ustawieniami, oraz informacjami.
	
	Dostpne opcje:
	
	   FOUNDER         Okrela waciciela kanau.
	   SUCCESSOR       Okrela spadkobierc kanau.
	   PASSWORD        Zmiana hasa waciciela kanau.
	   DESC            Zmiana opisu kanau.
	   URL             Ustawia adres strony kanau.
	   EMAIL           Przypisanie adresu e-mail do 
	                   kanau.
	   ENTRYMSG        Konfiguracja treci wiadomoci 
	                   powitalnej na kanale.
	   BANTYPE         Ustawienia typu banw zakadanych 
	                   przez Serwisy.
	   MLOCK           Blokada modw kanaowych, 
	                (on lub off).
	   KEEPTOPIC       Zachowanie ustawionego wczeniej 
	                   topicu kanau.
	   OPNOTICE        Informacje o egzekwowaniu komend 
		           OP/DEOP.
	   PEACE           Ograniczenia uywania krytycznych 
	                   komend.
	   PRIVATE         Nie pokazuj kanau po wydaniu 
	                   polecenia LIST.
	   RESTRICTED      Ograniczenia dostpu do kanau.
	   SECURE          Wcz zabezpieczenia %S.
	   SECUREOPS       Ograniczenie nadania uprawnie 
	                   operatora kanau.
	   SECUREFOUNDER   Ograniczenia nadania statusu 
	                   waciciela kanau.
	   SIGNKICK        Podpisywanie kickw wykonywanych 
	                   za pomoc komendy KICK.
	   TOPICLOCK       Umoliwia zmiany topica kanau 
	                   jedynie przy uyciu komendy 
			   TOPIC.
	   XOP             Wcza/Wycza system listy 
	                   uprawnie xOP 
			   (SOP, AOP, HOP, VOP).
	
	Napisz %R%S HELP SET opcja, 
	aby uzyska wicej informacji o poszczeglnych 
	komendach.

CHAN_HELP_SET_FOUNDER
	Skadnia: SET kana FOUNDER nick
	
	Zmienia waciciela kanau. Nowy nick musi by 
	oczywicie zarejestrowany.

CHAN_HELP_SET_SUCCESSOR
	Skadnia: SET kana SUCCESSOR nick
	
	Ustala spadkobierc kanau. Jeli nick zaoyciela
	kanau ulegnie przedawnieniu i zostanie 
	odrejestrowany, podczas gdy kana wci jest 
	aktywny, spadkobierca zostanie nowym aoycielem 
	kanau. Jednake, jeli spadkobierca  posiada zbyt 
	wiele (%d) zarejestrowanych kanaw, kana zostanie 
	odrejestrowany. Nick spadkobiercy musi by 
	oczywicie zarejestrowany.

CHAN_HELP_SET_PASSWORD
	Skadnia: SET kana PASSWORD haso
	
	Zmienia haso konieczne do zidentyfikowania si 
	jako zaoyciel kanau.

CHAN_HELP_SET_DESC
	Skadnia: SET kana DESC opis
	
	Ustawia opis kanau, widoczny po wydaniu polecenia 
	LIST oraz INFO.

CHAN_HELP_SET_URL
	Skadnia: SET kanal URL [url]
	
	Pozwala ustawi adres strony www kanau. Adres 
	bdzie widoczny po uyciu polecenia INFO. Jeli 
	komenda zostanie podana bez nowego adresu, wczeniej 
	podany URL ulegnie skasowaniu.

CHAN_HELP_SET_EMAIL
	Skadnia: SET kanal EMAIL [adres]
	
	Przypisuje adres e-mail do kanau. Adres bdzie 
	widoczny po uyciu polecenia INFO. Jeli komenda 
	zostanie podana bez nowego adresu, wczeniej podany 
	e-mail ulegnie skasowaniu.

CHAN_HELP_SET_ENTRYMSG
	Skadnia: SET kana ENTRYMSG [tre]
	
	Ustala tre powiadomienia wysyanego poprzez 
	/notice do uytkownikw wchodzcych na kana. Jeli 
	komenda zostanie podana bez nowej tre, wczeniej
	ustalona wiadomo zostanie skasowana.

CHAN_HELP_SET_BANTYPE
	Skadnia: SET kana BANTYPE <typ banu>
	
	Ustala typ banw zakadanych przez Serwisy.
	
	Typ banw oznaczany jest numerami od 0 do 3, 
	poszczeglne numery oznaczaj:
	
	0: ban w postaci *!ident@host
	1: ban w postaci *!*ident@host
	2: ban w postaci *!*@host
	3: ban w postaci *!*ident@*.domena

CHAN_HELP_SET_KEEPTOPIC
	Skadnia: SET kana KEEPTOPIC {ON | OFF}
	
	Wcza lub wycza opcj zapamitywania topicu 
	kanau. Kiedy zapamitywanie jest wczone, %S 
	zapamita ustawiony topic w przypadku gdy wszyscy 
	uytkownicy opuszcz kana, i przywrci go po 
	ponownej aktywacji kanau (czyli jak kto wejdzie).

CHAN_HELP_SET_TOPICLOCK
	Skadnia: SET kana TOPICLOCK {ON | OFF}
	
	Wcza lub wycza opcj blokowania topica kanau.
	Jeli opcja ta zostanie aktywowana, %S pozwoli 
	na zmiane topicu wycznie poprzez wydanie komendy 
	TOPIC.

CHAN_HELP_SET_MLOCK
	Skadnia: SET kana MLOCK mody
	
	Ustawia blokad modw kanaowych. %S pozwala na 
	definiowanie, ktre mody kanaowe maj by zawsze 
	wczone, wyczone, lub ustawiane dowolnie przez 
	operatorw kanau.
	
	Skadnia polecenia jest identyczna jak w komendzie 
	/MODE, tzn flagi poprzedzone znakiem+ 
	zostan zaoone na kana, natomiast poprzedzone 
	znakiem- bd zdejmowane z kanau. W odrnieniu 
	od komendy /MODE, kade uycie SET MLOCK, 
	usunie wszystkie wczeniej zdefiniowane mody!
	
	UWAGA: W przypadku ustawiania klucza dostpu do 
	kanau (drugi przykad poniej), powinna rownie 
	zosta aktywowana opcja RESTRICTED (zobacz 
	HELP SET RESTRICTED), w przeciwnym wypadku, 
	uytkownik wchodzcy na pusty kana, bdzie mog 
	odczyta zaoony klucz!
	
	Przykady:
	
	    SET kana MLOCK +nt-iklps
	        Wymusza zaoenie flag n oraz t, 
		oraz wycza flagi i,
		k, l, p, s. 
		Nie wyszczeglniona flaga m, moe 
		by dowolnie wczana lub wyczana przez 
		operatorw kabau.
	
	    SET kana MLOCK +knst-ilmp <mj-klucz>
	        Wymusza zaoenie flag k, n, s 
		oraz t, mody i, l, m a take 
		p zostan wyczone. Zostanie take 
		zaoony klucz o wartoci: "mj-klucz". 
		Klucz to oczywicie haso.
	
	    SET kana MLOCK +
	        Usuwa wszelkie ograniczenia zakadania flag. 
		Wszystkie mody mog by dowolnie zakadane i 
		zdejmowane z kanau.

CHAN_HELP_SET_PEACE
	Skadnia: SET kana PEACE {ON | OFF}
	
	Wcza lub wycza opcj PEACE dla kanau.
	Kiedy opcja ta jest aktywna, operatorzy kanau nie 
	bd mogli uywa polece kick lub ban, oraz 
	zmienia statusu innego uytkownika (przez %S) 
	ktrego poziom dostpu jest rwny lub wyszy ni 
	ich samych.

CHAN_HELP_SET_PRIVATE
	Skadnia: SET kana PRIVATE {ON | OFF}
	
	Wcza lub wycza opcj PRIVATE dla kanau.
	Kiedy opcja ta jest wczona, kana nie bdzie 
	widoczny po wydaniu polecenia: 
	%R%S LIST.

CHAN_HELP_SET_RESTRICTED
	Skadnia: SET kana RESTRICTED {ON | OFF}
	
	Wcza lub wycza ograniczenie dostpu do kanau.
	Kiedy opcja ta zostanie wczona, uytkownicy 
	normalnie nie uprawnieni do penienia statusu 
	operatora kanau (uytkownicy z ujemnym poziomem 
	dostpu, oraz jeli zostanie wczona funkcja 
	secure ops, uytkownicy bez zdefiniowanego 
	poziomu dostpu) bd natychmiast wyrzucani i 
	banowani na kanale.

CHAN_HELP_SET_SECURE
	Skadnia: SET kana SECURE {ON | OFF}
	
	Wcza lub wycza %S opcje ochronn kanau. Jeli
	funkcja ta zostanie aktywowana, jedynie 
	uytkownikom, ktrzy zarejestrowali swoje nicki i 
	dokonali %s identyfikacji, bdzie przyznawany dostp 
	do operowania kanaem zgodnie z wpisami w licie 
	dostpu (ACCESS LIST).

CHAN_HELP_SET_SECUREOPS
	Skadnia: SET kana SECUREOPS {ON | OFF}
	
	Kiedy funkcja ta zostanie wczona, uytkownicy 
	ktrzy nie zostali wpisani na liste dostpu kanau 
	(ACCESS LIST), nie bd	mogli korzysta ze statusu 
	operatora.
	
CHAN_HELP_SET_SECUREFOUNDER
	Skadnia: SET kana SECUREFOUNDER {ON | OFF}
	
	Kiedy funkcja ta %S zostanie aktywowana, jedynie 
	prawdziwy waciciel kanau (a nie kada osoba, 
	ktra dokona identyfikacji hasem kanau) bdzie 
	mg odrejestrowa kana, zmieni jego haso 
	dostpowe, a take zmieni zaoyciela oraz 
	spadkobierc (successor) kanau.
	
CHAN_HELP_SET_SIGNKICK
	Skadnia: SET #kana SIGNKICK {ON | LEVEL | OFF}
	
	Wcza lub wycza "podpisywanie" komend kick. 
	Kiedy opcja SIGNKICK zostanie aktywowana, 
	polecenia %S kick bd podpisywane nickiem osoby 
	wydajcej komend.
	
	Parametr LEVEL powoduje e nicki osb z rwnym 
	lub wyszym od okrelonego poziomem dostpu, nie 
	bd pokazywane przy poleceniu kick. 
	Zobacz %R%S HELP LEVELS, 
	aby uzyska wicej informacji.

CHAN_HELP_SET_XOP
	Skadnia: SET #kana XOP {ON | OFF}
	
	Wcza lub wycza system dostpu xOP dla kanau.
	Kiedy xOP zostanie wczony, konieczne jest 
	uywanie polece AOP/ SOP/ VOP w celu 
	przyznawania uprawnie na kanale innym uytkowniom.
	Wyczenie funkcji xOP wymaga uywania polecenia 
	ACCESS.
	
	Uwaga techniczna: kiedy lista dostpu (access 
	list) zostanie zmieniona na system list XOP, 
	wszelkie definicje poziomw dostepu (access level) 
	zostan zmienione. Ponowne przejcie z xOP na system 
	listy dostpu, nie spowoduje odzyskania poprzedniej 
	listy poziomw dostpu!
	
	Po zmianie systemu definiowania dostpu na xOP, 
	naley sprawdzi czy uytkownikom zosta przypisany 
	odpowiedni poziom dostpu. Automatyczne 
	przyporzdkowanie nie zawsze musi by poprawne.
	Nie zaleca si przejcia na system XOP, jeli 
	definicje poziomw dostpu dla kanau, zostay 
	wczeniej zmodyfikowane, przy pomocy polecenia 
	LEVELS.
	
CHAN_HELP_SET_OPNOTICE
	Skadnia: SET kana OPNOTICE {ON | OFF}
	
	Kiedy opcja ta zostanie wczona, %S bdzie 
	informowa uytkownikw przebywajcych na kanale, 
	za kadym razem, kiedy zostanie uyta komenda OP 
	lub DEOP.

CHAN_HELP_AOP
	Skadnia: AOP kana ADD nick
	          AOP kana DEL {nick | numer | list}
	          AOP kana LIST [maska | list]
	          AOP kana CLEAR
	
	Pozwala na zarzdzaniem dostpem do automatycznie 
	nadawanego przez statusu operatora. 
	Uytkownicy, ktrym zostanie nadane to uprawnienie, 
	bd automatycznie opowani na kanale, bd mogli si 
	odbanowa, oraz wysac zaproszenie (invite) na kana. 
	
	Komenda AOP ADD dodaje podany nick do listy AOP.
	
	Komenda AOP DEL usuwa z listy podany nick. 
	Jeli jako parametr zostanie podany zakres numerw 
	wpisw z listy AOP, dostp dla uytkownikw 
	znajdujcych si na licie pod wskazanymi pozycjami 
	zostanie usunity (zobacz poniszy przykad dla 
	polecenia LIST).
	
	Polecenie AOP LIST wywietla zawarto listy 
	AOP. Parametr maska pozwala zawzi wynik 
	polecenia do jedynie tych wpisw, ktrych host 
	pasuje do wskazanej w komendzie maski (dozwolone
	jest uywanie symbolu * - zastpuje on dowolny 
	cig	znakw).
	Jako parametr mona poda take numery wpisw na 
	licie AOP, na przykad:

	   AOP kana LIST 2-5,7-9
	      Wywietli wpisy na licie od numeru 2 do 5, 
	      oraz od 7 do 9.
	      
	Komenda AOP CLEAR usuwa wszystkie wpisy na 
	licie AOP.
	
	Polecenia AOP ADD oraz AOP DEL s 
	zastrzeone jedynie dla uytkownikw z uprawnieniami 
	SOP lub wyszymi. AOP CLEAR moe by uywany 
	tylko przez waciciela kanau. Wszyscy uytkownicy 
	wpisani na liste AOP s uprawnieni do uywania 
	komendy AOP LIST.
	
	Lista AOP moe by wyczona dla twojego kanau, w 
	takim przypadku naley uywac kanaowej listy 
	dostpu (access list). Zobacz 
	%R%S HELP ACCESS, aby uzyska 
	wicej informacji, oraz
	%R%S HELP SET XOP aby dowiedzie si jak 
	zmieni sposb zarzdzania kanaem na system xOP.

CHAN_HELP_HOP
	Skadnia: HOP kana ADD nick
	          HOP kana DEL {nick | numer | list}
	          HOP kana LIST [maska | list]
	          HOP kana CLEAR
	
	Pozwala na zarzdzanie dostpem do automatycznie 
	nadawanego przez statusu halfop. 
	Uytkownicy ktrym zostanie nadane to uprawnienie, 
	bdzie automatycznie nadawany status halfop'a na 
	kanale.

	Komenda HOP ADD dodaje podany nick do listy HOP.
	
	Komenda HOP DEL usuwa z listy podany nick. Jeli 
	jako parametr zostanie podany zakres numerw wpisw 
	z listy HOP, dostp dla uytkownikw znajdujcych 
	si na licie pod wskazanymi pozycjami zostanie 
	usunity (zobacz poniszy przykad dla polecenia 
	LIST).
	
	Polecenie HOP LIST wywietla zawarto listy 
	HOP. Parametr maska pozwala zawzi wynik 
	polecenia do jedynie tych wpisw, ktrych host 
	pasuje do wskazanej w komendzie maski (dozwolone
	jest uywanie symbolu * - zastpuje on dowolny 
	cig znakw). Jako parametr mona poda take numery 
	wpisw na licie HOP, na przykad:
	
		HOP kana LIST 2-5,7-9
		Wywietli wpisy na licie od numeru 2 do 5, 
		oraz od 7 do 9.

	Komenda HOP CLEAR usuwa wszystkie wpisy na 
	licie HOP.
	
	Polecenia HOP ADD oraz HOP DEL s 
	zastrzeone jedynie dla uytkownikw z uprawnieniami 
	AOP lub wyszymi. HOP CLEAR moe by uywany 
	jedynie przez waciciela kanau.
	
	Lista HOP moe by wyczona dla twojego kanau, w 
	takim przypadku naley uywac kanaowej listy 
	dostpu (access list). Zobacz 
	%R%S HELP ACCESS, aby uzyska 
	wicej informacji, oraz
	%R%S HELP SET XOP, aby dowiedzie si 
	jak zmieni sposb zarzdzania kanaem na system xOP.

CHAN_HELP_SOP
	Skadnia: SOP kana ADD nick
	          SOP kana DEL {nick | numer | list}
	          SOP kana LIST [maska | list]
	          SOP kana CLEAR
	
	Pozwala na zarzdzaniem dostpu do automatycznie 
	nadawanego przez statusu SOP. Uytkownicy, ktrym 
	zostanie nadane to uprawnienie, mog wykonywa takie 
	same operacje jak ci dopisani do listy AOP, a 
	dodatkowo take maj moliwo korzystania z funkcji 
	AutoKick oraz BadWords.

	Komenda SOP ADD dodaje podany nick do listy SOP.
	
	Komenda SOP DEL usuwa z listy podany nick. Jeli 
	jako parametr zostanie podany zakres numerw wpisw 
	z listy SOP, dostp dla uytkownikw znajdujcych 
	si na licie pod wskazanymi pozycjami zostanie 
	usunity (zobacz poniszy przykad dla polecenia 
	LIST).
	
	Polecenie SOP LIST wywietla zawarto listy 
	SOP. Parametr maska pozwala zawzi wynik 
	polecenia do jedynie tych wpisw, ktrych host 
	pasuje do wskazanej w komendzie maski (dozwolone
	jest uywanie symbolu * - zastpuje on dowolny 
	cig znakw). Jako parametr mona poda take numery 
	wpisw na licie SOP, na przykad:
	
		SOP kana LIST 2-5,7-9
		Wywietli wpisy na licie od numeru 2 do 5, 
		oraz od 7 do 9.

	Komenda SOP CLEAR usuwa wszystkie wpisy na 
	licie SOP.
	
	Polecenia SOP ADD, SOP DEL oraz SOP CLEAR 
	mog by wydane jedynie przez waciciela kanau. 
	SOP LIST jest dostpne take dla uytkownikw z
	listy AOP.
	
	Lista SOP moe by wyczona dla twojego kanau, w 
	takim przypadku naley uywac kanaowej listy dostpu 
	(access list). Zobacz %R%S HELP ACCESS, 
	aby uzyska wicej informacji, oraz
	%R%S HELP SET XOP aby dowiedzie si 
	jak zmieni sposb zarzdzania kanaem na system xOP.
	
CHAN_HELP_VOP
	Skadnia: VOP kana ADD nick
	          VOP kana DEL {nick | numer | list}
	          VOP kana LIST [maska | list]
	          VOP kana CLEAR
	
	Pozwala na zarzdzaniem dostpu do automatycznie lub na danie 
	nadawanego przez statusu Voice. 

	Komenda VOP ADD dodaje podany nick do listy VOP.

	Komenda VOP DEL usuwa z listy podany nick. Jeli 
	jako parametr zostanie podany zakres numerw wpisw 
	z listy VOP, dostp dla uytkownikw znajdujcych 
	si na licie pod wskazanymi pozycjami zostanie 
	usunity (zobacz poniszy przykad dla polecenia 
	LIST).

	Polecenie VOP LIST wywietla zawarto listy 
	VOP. Parametr maska pozwala zawzi wynik 
	polecenia do jedynie tych wpisw, ktrych host 
	pasuje do wskazanej w komendzie maski (dozwolone
	jest uywanie symbolu * - zastpuje on dowolny 
	cig znakw).
	Jako parametr mona poda take numery wpisw na 
	licie VOP, na przykad:
	
		VOP kana LIST 2-5,7-9
		Wywietli wpisy na licie od numeru 2 do 5, 
		oraz od 7 do 9.

	Komenda VOP CLEAR usuwa wszystkie wpisy na 
	licie VOP.
	
	Polecenia VOP ADD, VOP DEL oraz VOP LIST 
	mog by wydawane przez osoby z dostpem AOP lub 
	wyszym. Komenda VOP CLEAR moe by uywana 
	jedynie przez waciciela kanau.
	
	Lista VOP moe by wyczona dla twojego kanau, w 
	takim przypadku naley uywac kanaowej listy 
	dostpu (access list). 
	Zobacz %R%S HELP ACCESS, aby uzyska 
	wicej informacji, oraz 
	%R%S HELP SET XOP aby dowiedzie si jak 
	zmieni sposb zarzdzania kanaem na system xOP.

CHAN_HELP_ACCESS
	Skadnia: ACCESS kana ADD nick level
	          ACCESS kana DEL {nick | numer | list}
	          ACCESS kana LIST [maska | list]
	          ACCESS kana CLEAR
	
	Polecenie pozwala na zarzdzanie wpisami w kanaowej
	licie dostpu (access list). Ustalony poziom 
	dostpu okrela, ktrzy uytkownicy mog peni 
	funkcje operatorw kanau, oraz posiada dostp do 
	komend %S. Rne poziomy okrelaj inne 
	przywileje. 
	Napisz msg %S HELP ACCESS LEVELS,
	aby uzyska wicej informacji. Kady uytkownik, 
	ktry nie zosta wpisany na list dostepu, posiada 
	poziom uprawnie rwny 0.
	
	Komenda ACCESS ADD dodaje podany nick do listy z 
	okrelonym poziomem dostpu. Jeli nick jest ju 
	wpisany na licie, jego poziom dostpu zostanie 
	zmieniony zgodnie z podanym parametrem. Przyznawany 
	poziom dostpu nie moe by wyszy ni poziom osoby
	wydajcej komende ADD.
	
	Polecenie ACCESS DEL usuwa podany nick z listy. 
	Jeli jako parametr zostanie podany zakres numerw z 
	listy dostpu dla uytkownikw znajdujcych si na 
	licie pod wskazanymi pozycjami zostanie usunity 
	(zobacz poniszy przykad dla polecenia LIST).
	
	Polecenie ACCESS LIST wywietla zawarto listy. 
	Parametr maska pozwala zawzi wynik polecenia 
	do jedynie tych wpisw, ktrych host pasuje do 
	wskazanej w komendzie maski (dozwolone jest uywanie 
	znaku * - zastpuje on dowolny cig znakw).
	Jako parametr mona poda take numery wpisw na 
	licie, na przykad:

	   ACCESS kana LIST 2-5,7-9
	    Wywietli wpisy na licie od numeru 2 do 5, oraz 
	    od 7 do 9.

	Komenda ACCESS CLEAR usuwa wszystkie wpisy na 
	licie.
	
CHAN_HELP_ACCESS_LEVELS
	Poziomy dostpu uytkownikw:
	
	Standardowe poziomy dostpu zostay podane poniej:
	   Founder	 Peny dostp do polece %S,
	                 automatyczne nadawanie statusu
	                 operatora po wejciu na kana. 
	                 UWAGA: tylko jedna osoba moe by 
	                 wacicielem (Founder) kanau. Nie 
	                 mona nada tego uprawnienia za 
	                 pomoc polecenia ACCESS.
	        10   Dostp do polecenia AKICK, 
	                 automatyczne opowanie.
	         5   Automatyczne opowanie.
	         3   Automatyczne nadawanie voica.
	         0   Brak specjalnych przywilejw. Inne 
	                 osoby mog nada status operatora 
	                 na kanale temu uytkownikowi (chyba 
	                 e wczona zostaa opcja 
			 secure-ops).
	        <0   Brak moliwoci penienia funkcji 
	                 operatora.
	   
	Standardowe poziomy mog zosta zmienione, moliwe 
	jest take definiowanie wasnych poziomw dostpu. 
	Zobacz: %R%S HELP LEVELS, aby 
	uzyska wicej informacji.

CHAN_HELP_AKICK
	Skadnia: AKICK kana ADD maska [powd]
	          AKICK kana STICK maska
	          AKICK kana UNSTICK maska
	          AKICK kana DEL maska
	          AKICK kana LIST [maska]
	          AKICK kana VIEW [maska]
	          AKICK kana ENFORCE
	          AKICK kana CLEAR
	
	Polecenie zarzdza list AutoKick dla kanau. Jeli
	uytkownik znajdujcy si na licie AKICK, wejdzie 
	na kana, %S zaoy bana a nastepnie wykopie 
	uytkownika z kanau.

	Polecenie AKICK ADD dodaje podany nick lub mask 
	hosta do listy AutoKick. Jeli zostanie podany 
	powd, bdzie on uywany przy wykopywaniu 
	uytkownika dodanego do listy z kanau, jeli nie 
	zostanie podany, uywany bdzie standardowy zwrot: 
	You have been banned from channel.
	
	Komenda AKICK STICK umoliwia permanentne 
	dodanie podanej maski do banw na kanale. Za kadym 
	razem gdy kto zdejmie wskazanego bana z kanau, 
	%S automatycznie zaoy go ponownie.
	Parametrem polecenia nie moe by nick a jedynie 
	host.
	
	Komenda AKICK UNSTICK niweluje dziaanie 
	polecenia AKICK STICK - umoliwia zdjcie bana z 
	kanau.
	
	Polecenia AKICK DEL usuwa wskazany nick lub mask
	z listy AutoKick. 
	
	AKICK LIST - polecenie wywietla list wpisw 
	AutoKick. Jeli zostanie podany opcjonalny parametr 
	maski, pokazane zostan jedynie wpisy pasujce do 
	niej.
	
	AKICK VIEW jest bardziej szczegow odmian 
	polecenia AKICK LIST.
	
	Polecenie AKICK ENFORCE powoduje e %S 
	usunie z kanau wszystkich uytkownikw, ktrych 
	hosty pasuj do wskazanych masek w licie AKICK.
	
	Komenda AKICK CLEAR usuwa wszelkie wpisy z 
	listy AKICK.

CHAN_HELP_LEVELS
	Skadnia: LEVELS kana SET typ poziom
	          LEVELS kana {DIS | DISABLE} typ
	          LEVELS kana LIST
	          LEVELS kana RESET
	
	Polecenie LEVELS umoliwia przypisywanie 
	uprawnie poszczeglnym poziomom dostepu (LEVEL 
	ACCESS). Przy uyciu tej komendy, moesz definiowa 
	poziomy dostpu do wszystkich funkcji %S 
	(SET FOUNDER, SET PASSWORD podobnie jak i
	LEVELS sa zastrzeone wycznie dla waciciela 
	kanau).
	
	LEVELS SET pozwala zmieni przypisany poziom dla 
	okrelonej operacji lub ich grup. LEVELS DISABLE 
	(lub DIS w skrcie) wycza okrelon funkcj, 
	lub zastrzega dostp do niej jedynie dla waciciela 
	kanau.
	LEVELS LIST wywietla aktualnie ustalone poziomy 
	dla kadej z operacji. LEVELS RESET przywraca 
	standardowe ustawienia poziomw dostpu - identyczne 
	z tymi jakie ustawiane s dla kanau po jego 
	utworzeniu (zobacz HELP ACCESS LEVELS).
	
	Aby obejrze spis wszystkich funkcji ktre mog 
	zosta przypisane poziomom dostpu, zobacz: 
	HELP LEVELS DESC.

CHAN_HELP_LEVELS_DESC
	
	Spis wszystkich funkcji dostepnych dla poziomw 
	dostepu:

CHAN_HELP_LEVELS_DESC_FORMAT
	    %-*s  %s

CHAN_HELP_INFO
	Skadnia: INFO #kana [ALL]
	
	Komenda INFO pozwala uzyska informacje o 
	zarejestrowanym kanale: o zaoycielu, dacie 
	rejestracji, dacie ostatniej aktywnoci oraz opisie 
	i ustawionych opcjach. Jeli podany zostanie 
	parametr ALL pokazana bdzie take zdefiniowana 
	wiadomo powitalna, oraz informacje o spadkobiercy 
	kanau (successor)
	
	Standardowo uycie parametru ALL jest dozwolone
	jedynie dla zaoycieli kanau.

CHAN_HELP_LIST
	Skadnia: LIST wzorzec
	
	Listuje wszystkie kanay ktrych nazwa pasuje do 
	zdefiniowanego wzorca. (Kanay z opcj PRIVATE 
	nie bd pokazywane).

CHAN_HELP_OP
	Skadnia: OP [kana [nick]]
	
	Nadaje status operatora na wskazanym kanale. Jeli 
	nick nie zostanie podany, opowany bdzie wydajcy 
	komend. Jeli nie podany zostanie ani #kana ani 
	nick, opowany bdzie wydajcy komend, na wszystkich 
	kanaach, na ktrych przebywa, uwzgldniajc 
	przysugujce mu na nich poziomy dostpu.
	
	Standardowo polecenia tego mog uywa uytkownicy 
	wpisani na list AOP lub posiadajcy poziom dostpu 
	5-ty lub wyszy.

CHAN_HELP_DEOP
	Skadnia: DEOP [kana [nick]]
	
	Deopuje wskazanego uytkownika na kanale. Jeli nie 
	zostanie podany nick, deopowany zostanie wydajcy 
	komend. Jeli nie zostanie podany nick oraz kana, 
	deopowany bdzie wydajcy komed na wszystkich 
	kanaach na ktrych przebywa, z uwzgldnieniem 
	przysugujcych mu na nich uprawnie.
	
	Standardowo polecenia tego mog uywa uytkownicy 
	wpisani na list AOP lub posiadajcy poziom dostpu 
	5-ty lub wyszy.
	
CHAN_HELP_VOICE
	Skadnia: VOICE [kana [nick]]
	
	Nadaje voice wskazanemu uytkownikowi. Jeli nick 
	nie zostanie podany, voice nadany zostanie 
	wydajcemu polecenie. Jeli nie podany zostanie nick 
	i kana, voice przydzielony zostanie uytkownikowi 
	wydajcemu polecenie, na wszystkich kanaach na 
	ktrych przebywa, z uwzgldnieniem przysugujcych 
	mu na nich uprawnie.
	
	Standardowo polecenia tego mog uywa uytkownicy 
	wpisani na list AOP lub posiadajcy poziom dostpu 
	5-ty lub wyszy, oraz uytkownicy wpisani na list 
	VOP, lub posiadajcy poziom dostpu 3 umoliwiajcy 
	samodzielne nadanie statusu voice.

CHAN_HELP_DEVOICE
	Skadnia: DEVOICE [kana [nick]]
	
	Zabiera status voice wskazanemu uytkownikowi. Jeli 
	nick nie zostanie podany, voice zostanie zdjty 
	uytkownikowi wydajcemy polecenie. Jeli nie podany 
	zostanie nick oraz kana, voice zostanie zdjty 
	uytkownikowi wydajcemy polecenie na wszystkich 
	kanaach na ktrych przebywa, z uwzgldnieniem 
	przysugujcych mu na nich uprawnie.
	
	Standardowo polecenia tego mog uywa uytkownicy 
	wpisani na list AOP lub posiadajcy poziom dostpu 
	5 lub wyszy, oraz uytkownicy wpisani na list VOP 
	lub posiadajcy poziom dostpu 3 umoliwiajcy 
	samodzielne zdjcie statusu voice.
	

CHAN_HELP_HALFOP
	Skadnia: HALFOP [kana [nick]]
	
	Nadaje status halfop wskazanemu uytkownikowi. Jeli 
	nick nie zostanie podany, halfop zostanie nadany 
	uytkownikowi wydajcemu polecenie. Jeli nie podany 
	zostanie nick oraz kana, halfop zostanie nadany 
	uytkownikowi wydajcemu polecenie na wszystkich 
	kanaach na ktrych przebywa, z uwzgldnieniem 
	przysugujcych mu na nich uprawnie.

	Standardowo polecenia tego mog uywa uytkownicy 
	wpisani na list AOP. lub posiadajcy poziom dostpu 
	5 lub wyszy, oraz uytkownicy wpisani na list HOP, 
	lub posiadajcy poziom dostpu 4 umoliwiajcy 
	samodzielne nadanie statusu halfop.
	
CHAN_HELP_DEHALFOP
	Skadnia: DEHALFOP [kana [nick]]
	
	Zdejmuje status halfop wskazanemu uytkownikowi. 
	Jeli nick nie zostanie podany, halfop zostanie 
	zabrany uytkownikowi wydajcemu polecenie. Jeli 
	nie zostanie podany nick oraz kana, halfop zostanie 
	zabrany uytkownikowi wydajcemu polecenie na 
	wszystkich kanaach na ktrych przebywa, z 
	uwzgldnieniem przysugujcych mu na nich uprawnie.
	
	Standardowo polecenia tego mog uywa uytkownicy 
	wpisani na list AOP. lub posiadajcy poziom dostpu 
	5-ty lub wyszy, oraz uytkownicy wpisani na list 
	HOP, lub posiadajcy poziom dostpu 4 umoliwiajcy 
	samodzielne zdjcie statusu halfop.

CHAN_HELP_PROTECT
	Skadnia: PROTECT [kana [nick]]
	
	Chroni wskazanego uytkownika na kanale. Jeli nick 
	nie zostanie podany opcja zostanie wczona dla 
	wydajcego polecenie. Jeli nie zostanie podany nick 
	oraz kana polecenie bdzie odnosio si do 
	uytkownika wydajcego polecenie na wszystkich 
	kanaach na ktrych przebywa, z uwzgldnieniem 
	przysugujcych mu na nich uprawnie.
	
	Standardowo komendy tej mog uywa waciciele
	kanaw, uytkownicy wpisani na list SOP lub 
	posiadajcy poziom dostpu 10 lub wyszy 
	umoliwiajcy samodzielne wczenie opcji 
	ochronnej.

CHAN_HELP_DEPROTECT
	Skadnia: DEPROTECT [kana [nick]]
	
	Usuwa ochron wskazanego uytkownika na kanale. 
	Jeli nick nie zostanbie podany, polecenie bdzie 
	odnosi si do wydajcego komend. Jeli nie podany 
	zostanie nick oraz kana, usunita zostanie ochrona 
	uytkownika wydajcego polecenie, na wszystkich 
	kanaach na ktrych przebywa, z uwzgldnieniem 
	przysugujcych mu na nich uprawnie.

	Standardowo komendy tej mog uywa waciciele 
	kanaw, uytkownicy wpisani na list SOP lub 
	posiadajcy poziom dostpu 10 lub wyszy 
	umoliwiajcy samodzielne wyczenie opcji 
	ochronnej.

CHAN_HELP_OWNER
	Skadnia: OWNER [kana]
	
	Nadaje uprawnienia waciciela (Ownera) kanau. 
	Jeli kana nie zostanie podany, status ownera 
	zostanie nadany na wszystkich kanaach na ktrych 
	przebywasz z uwzgldnieniem przysugujcych na nich 
	uprawnie.
	
	Standardowo komendy tej mog uywa waciciele 
	kanaw.

CHAN_HELP_DEOWNER
	Skadnia: DEOWNER [kana]
	
	Usuwa uprawnienia waciciela (Ownera) kanau. 
	Jeli kana nie zostanie podany, status ownera 
	zostanie usunity na wszystkich kanaach na ktrych 
	przebywasz z uwzgldnieniem przysugujcych na nich 
	uprawnie.

	Standardowo komendy tej mog uywa zaoyciele 
	kanaw.

CHAN_HELP_INVITE
	Skadnia: INVITE kana
	
	Zaproszenie (INVITE) na kana przez %S.
	
	Standardowo komenda dostpna dla uytkownikw 
	wpisanych na liste AOP oraz posiadajcych poziom 
	dostpu 5 lub wyszy.

CHAN_HELP_UNBAN
	Skadnia: UNBAN kana
	
	Sprawia e %S zdejmie wszelkie bany 
	uniemoliwiajce wydajcemu komend wejcie na 
	wskazany kana.
	
	Standardowo komenda dostpna dla uytkownikw 
	wpisanych na liste AOP oraz posiadajcych poziom 
	dostpu 5 lub wyszy.
	
CHAN_HELP_KICK
	Skadnia: KICK [kana [nick [powd]]]
	
	Wyrzuca (kick) wskazanego uytkownika z kanau. 
	Jeli nick nie zostanie podany. wyrzucony zostanie 
	wydajcy komend. Jeli nie podany zostanie nick 
	oraz kana, wyrzucony zostanie wydajcy komend, ze 
	wszystkich kanaw na ktrych przebywa z 
	uwzgldnieniem przysugujcych mu na nich uprawnie.
	
	Standardowo komenda dostpna dla uytkownikw 
	wpisanych na liste AOP oraz posiadajcych poziom 
	dostpu 5 lub wyszy.

CHAN_HELP_BAN
	Skadnia: BAN [kana [nick [powd]]]
	
	Nakada bana na wskazanego uytkownika. Jeli nick 
	nie zostanie podany, ban zostanie zaoony na 
	wydajcego polecenie. Jeli nie zostanie podany nick 
	oraz kana ban zostanie zaoony na wydajcego 
	polecenie na wszystkich kanaach na ktrych 
	przebywa, z uwzgldnieniem przysugujcych mu na 
	nich uprawnie.
	
	Standardowo komenda dostpna dla uytkownikw 
	wpisanych na liste AOP oraz posiadajcych poziom 
	dostpu 5 lub wyszy.

CHAN_HELP_TOPIC
	Skadnia: TOPIC kana [topic]
	
	Wymusza ustawienie podanego topicu na kanale przez 
	%S. Jeli nie zostanie podana trec nowego 
	topicu, dotychczasowy zostanie usunity. Komendy 
	mona uywa wraz z opcj SET TOPICLOCK 
	(zobacz: %R%S HELP SET TOPICLOCK, aby 
	uzyska wicej informacji).
	
	Standardowo komenda ta jest dostpna dla waciciela 
	kanau.

CHAN_HELP_CLEAR
	Skadnia: CLEAR kana opcje
	
	Umoliwia kompleksowe usunicie niektrych ustawie na
	kanale poprzez %S. Dostpne opcje:
	     
	   MODES    Zdejmuje wszystkie flagi z kanau (np 
	            i, k, l, m, n, p, s, t).
	   BANS     Zdejmuje wszystkie bany na kanale.
	   EXCEPTS  Zdejmuje wyjtki od banw na kanale.
	   OPS      Zdejmuje status operatora wszystkim 
	            uytkownikom na kanale.
	   HOPS     Zdejmuje status popa wszystkim 
	            uytkownikom na kanale.	
	   VOICES   Zdejmuje voica wszystkim uytkownikom 
	            na kanale.
	   USERS    Wyrzuca (kick) wszystkich uytkownikw 
	            z kanau.
	
	Standardowo komenda ta jest dostpna dla waciciela 
	kanau.
	
CHAN_HELP_GETKEY
	Skadnia: GETKEY kana
	
	Zwraca klucz dostepu ustanowiony na wskazanym 
	kanale. Komenda gwnie przeznaczona do 
	wykorzystania dla botw lub innych automatw, wynik 
	jest podawany w formacie:

	KEY <kana> <klucz>
	
	Jeli klucz nie zosta ustanowiony, wynik <klucz> 
	bdzie przyjmowa warto "NO KEY".
	
CHAN_HELP_SENDPASS

	Skadnia: SENDPASS kana
	
	Wysya haso do kanau na adres email zaoyciela. 
	Funkcja bardzo pomocna przy odzyskiwaniu 
	zapomnianych hase.

	W niektrych sieciach, dostp do tego polecenia 
	ograniczony jest dla IRC Operatorw.

	Komenda jest niedostpna jeli zostao wczone 
	szyfrowanie hase.

CHAN_SERVADMIN_HELP
	
	Administratorzy Serwisw mog take usun kady z 
	kanaw bez potrzeby identyfikowania si z uyciem 
	hasa waciciela. Mog przejrze listy dostpw, 
	listy AKICK, i ustawienia poziomw dostpu dla 
	kanaw.
	    
CHAN_SERVADMIN_HELP_LOGOUT
	Skadnia: LOGOUT kana [nick]
	
	Polecenie wyloguje uytkownika o wskazanym nicku, 
	oznacza to, e bdzie si on musia ponownie 
	zidentyfikowa, aby odzyska wszelkie przysugujce 
	mu uprawnienia.
	
	Jeli jeste zaoycielem kanau moesz wylogowa 
	wszystkich uytkownikw, w przeciwnym wypadku 
	jedynie siebie.
	
	Administratorzy Serwisw mog wylogowa dowolnego 
	uytkownika z kadego kanau. Pominicie podania 
	nicka, spowoduje wylogowanie wszystkich uytkownikw 
	na danym kanale.

CHAN_SERVADMIN_HELP_DROP
	Skadnia: DROP kana
	
	Odrejestrowuje wskazany kana.

CHAN_SERVADMIN_HELP_SET
	
	Administratorzy Serwisw mog ustawi opcj 
	NOEXPIRE dla wskazanego kanau, ktra 
	uniemozliwi automatyczne odrejestrowanie 
	nieuywanego kanau. Oznacza to, e kana
	z t opcj nie podlega prawu wygasania.

CHAN_SERVADMIN_HELP_SET_NOEXPIRE
	Skadnia: SET kana NOEXPIRE {ON | OFF}
	
	Ustala czy wskazany kana moe ulec automatycznemu
	odrejestrowaniu jeli nie bdzie ju uywany.
	
	Komenda dostpna dla Administratorw Serwisw.

CHAN_SERVADMIN_HELP_INFO
	
	Administratorzy Servisw mog uywa parametru ALL 
	odnoszcego si do wszystkich kanaw.

CHAN_SERVADMIN_HELP_LIST
	Skadnia: LIST wzorzec [FORBIDDEN] [SUSPENDED] [NOEXPIRE]
	
	Listuje wszystkie zarejestrowane kanay ktrych 
	nazwa pasuje do podanego wzorca. Kanay z ustawion 
	opcj PRIVATE zostan pokazane jedynie 
	Admninistratorom Serwisw. Kanay z ustawion opcj 
	NOEXPIRE bd oznaczane znakiem ! dla 
	Administratorw Serwisw.
	
	Jeli zostanie podany parametr FORBIDDEN, SUSPENDED 
	lub NOEXPIRE, pokazane zostan jedynie kanay z 
	wczonymi tymi opcjami. Parametrw tych mona 
	uywa jednoczenie. Komenda dostpna jedynie dla 
	Administratorw Serwisw.

CHAN_SERVADMIN_HELP_GETPASS
	Skadnia: GETPASS kana
	
	Zwraca haso dostpu dla wskazanego kanau. 
	UWAGA: za kadym razem gdy ta komenda zostanie 
	uyta, wiadomo zawierajca dane wydajcego 
	polecenie GETPASS oraz kana dla ktrego zostao ono 
	zastosowane, bdzie logowana oraz rozsyana za 
	pomoc WALLOP/GLOBOP.
	
	Polecenie dostepne dla Administratorw Serwisw.

CHAN_SERVADMIN_HELP_FORBID
	Skadnia: FORBID kana [powd]

	Blokuje wskazany kana uniemoliwiajc jego 
	rejestracj oraz uywanie. Blokada moe zosta 
	wyczona poprzez odrejestrowanie kanau.
	
	W niektrych sieciach podanie powodu jest wymagane.
	
	Polecenie dostpne dla Administratorw Serwisw.

CHAN_SERVADMIN_HELP_SUSPEND
	Skadnia: SUSPEND kana [powd]
	
	Zawieszenie dziaania wskazanego kanau, 
	uniemoliwiajce jego rejestracj oraz uywanie. 
	Blokada moe zosta wyczona poprzez uycie 
	polecenia UNSUSPEND. Zawieszenie kanau nie powoduje 
	utraty wszystkich jego ustawie i danych.
	
	W niektrych sieciach podanie powodu jest wymagane.
	
	Polecenie dostepne dla Administratorw Serwisw.

CHAN_SERVADMIN_HELP_UNSUSPEND
	Skadnia: UNSUSPEND kana
	
	Cofa zawieszenie kanau naoone poleceniem 
	SUSPEND.
	
	Polecenie dostepne dla Administratorw Serwisw.

CHAN_SERVADMIN_HELP_STATUS
	Skadnia: STATUS kana nick
	
	Wywietla aktualny poziom dostpu (access level) 
	wskazanego nicka na kanale. Format odpowiedzi jest 
	nastpujcy:
	
	    STATUS kana nick poziom-dostpu
	
	W przypadku wystapienia bdu, format odpowiedzi 
	bdzie nastpujcy:
	
	    STATUS ERROR informacja-o-bdzie
	
	Polecenie dostepne dla Administratorw Serwisw.

###########################################################################
#
# Wiadomoci pomocy MemoServ 
#
###########################################################################
MEMO_HELP_CMD_SEND
	    SEND   Wyslij wiadomo do uytkownika/kanau.
MEMO_HELP_CMD_CANCEL
	    CANCEL Wycofaj ostatni ustawion wiadomo.
MEMO_HELP_CMD_LIST
	    LIST   Wywietl wszystkie ustawione wiadomoci.
MEMO_HELP_CMD_READ
	    READ   Przeczytaj jedn lub wicej wiadomoci.
MEMO_HELP_CMD_DEL
	    DEL    Skasuj jedn lub wicej wiadomoci.
MEMO_HELP_CMD_SET
	    SET    Ustaw opcje dla wiadomoci.
MEMO_HELP_CMD_INFO
	    INFO   Wywietl informacje o wiadomociach.
MEMO_HELP_CMD_RSEND
	    RSEND  Wysya wiadomo z daniem potwierdzenia 
	    	   odbioru.
MEMO_HELP_CMD_CHECK
	    CHECK  Checks if last memo to a nick was read
MEMO_HELP_CMD_SENDALL
	    SENDALL  Wysya wiadomo do wszystkich 
	    zarejestrowanych uytkownikw.

MEMO_HELP_CMD_STAFF
	    STAFF  Wysya wiadomo do wszystkich 
	    operatorw/administratorw Serwisw.

MEMO_HELP_HEADER
	%S jest mechanizmem umoliwiajcym przesyanie
	krtkich wiadomoci innym uzytkownikom sieci lub
	kanaom(*). Zarwno nick osoby wysyajcej jak i
	adresata wiadomoci lub adresowany kana, musz
	by zarejestrowane.

	%S lista dostpnych komend:


MEMO_HELP_ADMIN
	not used.
MEMO_HELP_OPER
	not used.
MEMO_HELP_FOOTER
	
	Napisz %R%S HELP komenda, aby 
	uzyska pomoc odnonie powyszych komend.
	
	(*) Standardowo kady uytkownik z poziomem dostepu 
	    10 do kanau moe czyta wiadomoci przesane na 
	    kana. Mona's to zmieni za pomoc komendy %s
	  LEVELS.

MEMO_HELP_SEND
	Skadnia: SEND {nick | kana} tre-wiadomoci
	
	Wysya wskazanej osobie lub na podany kana 
	wiadomo o okrelonej treci. W przypadku wysyania 
	do uytkownika otrzyma on/ona komunikat o 
	oczekujcej wiadomoci. Adresat nick/kana musi by 
	zarejestrowany.
	
MEMO_HELP_CANCEL
	Skadnia: CANCEL {nick | kana}
	
	Wycofuje ostatni wysan wiadomo, o ile nie 
	zostaa ona jeszcze dostarczona adresatowi.

MEMO_HELP_LIST
	Skadnia: LIST [kana] [list | NEW]
	
	Wywietla wszystkie posiadane wiadomoci. Parametr 
	NEW powoduje pokazanie jedynie nie przeczytanych 
	wiadomoci. Nieprzeczytane wiadomoci oznaczone s 
	poprzez "*" po lewej stronie numeru. Mona take 
	sprecyzowa liste wywietlanych wiadomoci podajc 
	ich numery, np:

		LIST 2-5,7-9
		  Wywietli wiadomoci od numeru 2 do 5 
		  oraz od 7 do 9.

MEMO_HELP_READ
	Skadnia: READ [kana] {numer | list | LAST | NEW}
	
	Wywietla wskazan wiadomo. Jeli parametr LAST 
	zostanie podany, pokazana zostanie ostatnia z 
	wiadomoci. NEW oznacza wszystkie nowe wiadomoci. 
	Podajc numer moemy okreli ktra z wiadomoci ma 
	zosta wywietlona. Mona take sprecyzowa list 
	wywietlanych wiadomoci podajc ich numery, 
	np:
		READ 2-5,7-9
		  Wywietli wiadomoci od numeru 2 do 5 
		  oraz od 7 do 9.

MEMO_HELP_DEL
	Skadnia: DEL [kana] {numer | list | LAST | ALL}
	
	Kasuje jedn lub wicej wiadomoci. Dopuszczalne 
	jest podanie numeru wiadomoci lub grupy wiadomoci, 
	przykad poniej.
	
	Parametr LAST oznacza ostatni wiadomo.
	Uycie ALL spowoduje usunicie wszystkich 
	wiadomoci.
	
	Przykady:
	
	   DEL 1
	      Kasuje pierwsz wiadomo.
	
	   DEL 2-5,7-9
	      Kasuje wiadomoci od numeru 2 do 5 oraz od 7 
	      do 9.

MEMO_HELP_SET
	Skadnia: SET opcja parametry

	Komenda umoliwia zmian nastpujcych ustawie:
	
	   NOTIFY   Ustala czy zostaniesz powiadomiony/a
	            o nowych wiadomociach (tylko dla 
	            nickw)
	   LIMIT    Ustala maksymaln ilo wiadomoci jak 
	            moesz przyj.
	
	Napisz %R%S HELP SET opcja, 
	aby uzyska wicej informacji o poszczeglnych 
	opcjach.

MEMO_HELP_SET_NOTIFY
	Skadnia: SET NOTIFY {ON | LOGON | NEW | OFF}

	Ustala kiedy zostanie wysane powiadomienie o nowych
	wiadomociach:
	
	   ON      Powiadomienie zostanie wysane po 
	           zalogowaniu si, kiedy nie bdzie 
	           ustawiony tryb /AWAY, oraz w momencie
	           otrzymania wiadomoci.
	   LOGON   Powiadomienie zostanie wysane jedynie 
	           po zalogowaniu si lub po wyczeniu 
	           trybu /AWAY.
	   NEW     Powiadomienie bdzie wysyane jedynie w 
	           momencie otrzymania wiadomoci.
	   OFF     Powiadomienia nie bd wysyane.
	
	Opcja ON jest kombinacj opcji LOGON oraz 
	NEW.

MEMO_HELP_SET_LIMIT
	Skadnia: SET LIMIT [kana] limit
	
	Ustala Twoj (lub kanau) maksymaln liczb 
	wiadomoci. Jeli ustalona zostanie ona na 0, 
	przyjmowanie wiadomoci zostanie wyczone. Limit 
	nie moe by wikszy ni %d.

MEMO_HELP_INFO
	Skadnia: INFO [kana]
	
	Wywietla ilo wiadomoci, ilo wiadomoci 
	nieprzeczytanych, oraz limit przyjmowania 
	wiadomoci. Jeli podany zostanie kana wywietlone 
	informacje bd odnosiy si do wskazanego kaau.

MEMO_SERVADMIN_HELP_SET_LIMIT
	Skadnia: SET LIMIT [uytkownik | kana] {limit | NONE} [HARD]
	
	Ustala maksymaln ilo wiadomoci jak moe 
	posiada uytkownik lub kana. Ustalenie limitu 
	na 0, wyczy przyjmowanie wiadomoci. Parametr 
	NONE pozwoli na nielimitowan ilo wiadomoci. 
	Jeli nie podany zostanie nick lub kana zmieniony 
	zostanie limit wydajcego polecenie.
	
	Dodanie paramteru HARD uniemoliwia zmiane 
	limitu przez uytkownika.

	Polecenie SET LIMIT jest dostpne dla 
	Administratorw Serwisw. Pozostali uytkownicy 
	mog jedynie modyfikowa wasny limit lub kanau na, 
	ktrym maj do tego uprawnienia. Nie mog wyczy 
	limitu, a take ustalic jego wartoci powyej %d 
	oraz uy parametru HARD.

MEMO_SERVADMIN_HELP_INFO
	Skadnia: INFO [nick | kana]

	Polecenie wydane bez parametru wywietla informacj o
	iloci wasnych wiadomoci, liczbie wiadomoci nie 
	odczytanych oraz limicie iloci wiadomoci.
	
	Jeli zostanie wskazany kana, pokazane zostan te 
	same informacje w odniesieniu do tego kanau.
	
	Administratorzy Serwisw mog obejrze informacje 
	dla poszczeglnych uytkownikw podajc parametr 
	nick.

MEMO_HELP_STAFF
	Skadnia: STAFF tre-wiadomoci

	Wysya do wszystkich operatorw/administratorw 
	Serwisw wiadomo o podanej treci.
	Uytkownicy wpisani jednoczenie na list 
	operatorw jak i administratorw otrzymaj 
	wiadomo podwjnie.

MEMO_HELP_SENDALL
	Skadnia: SENDALL tre-wiadomoci

	Wysya wiadomo o okrelonej treci do wszystkich 
	uytkownikw.
	
MEMO_HELP_RSEND
	Skadnia: RSEND {nick | kana} trec-wiadomoci
	
	Wysya wskazanemu uytkownikowi lub na okrelony 
	kana wiadomo o podanej treci. Adresat musi by 
	zarejestrowany. Kiedy wiadomo zostanie przeczytana 
	przez odbiorce, automatyczne powiadomienie o tym 
	zostanie przesane do nadawcy.

MEMO_HELP_CHECK
	Skadnia: CHECK nick
	
	Sprawdza czy _ostatnia_ wiadomo wysana do 
	wskazanej osoby zostaa przeczytana. Polecenie to 
	dziaa jedynie dla wiadomoci wysyanych innym 
	uytkownikom, a nie kanaom.

###########################################################################
#
# OperServ help messages
#
###########################################################################

OPER_HELP_CMD_GLOBAL
	   GLOBAL      Wiadomo do wszystkich uytkownikw.
OPER_HELP_CMD_STATS
	   STATS       Informacje na temat serwisw i sieci.
OPER_HELP_CMD_OPER
	   OPER        Modyfikacja listy operatorw serwisw.
OPER_HELP_CMD_ADMIN
	   ADMIN       Modyfikacja listy adminw serwisw.
OPER_HELP_CMD_STAFF
	   STAFF       Wywietla ekipe serwisw i jej stan.
OPER_HELP_CMD_MODE
	   MODE        Zmiana modw kanaowych.
OPER_HELP_CMD_KICK
	   KICK        Wykopanie uytkownika z kanau.
OPER_HELP_CMD_CLEARMODES
	   CLEARMODES  Czyszczenie modw na kanale.
OPER_HELP_CMD_KILLCLONES
	   KILLCLONES  Skilluj uytkownikw z danego hosta.
OPER_HELP_CMD_AKILL
	   AKILL       Modyfikacje listy AKILL. 
OPER_HELP_CMD_SGLINE
	    SGLINE      Modyfikacje listy SGLINII.
OPER_HELP_CMD_SQLINE
	    SQLINE      Modyfikacje listy SQLINII.
OPER_HELP_CMD_SZLINE
	    SZLINE      Modyfikacje listy SZLINII.
OPER_HELP_CMD_CHANLIST
	   CHANLIST    Lista wszystkich rekordw kanaw.
OPER_HELP_CMD_USERLIST
	   USERLIST    Lista wszystkich rekordw uytkownikw.
OPER_HELP_CMD_LOGONNEWS
	   LOGONNEWS   Modyfikacja wiadomoci wywietlanych 
	               uytkownikom po poczeniu.
OPER_HELP_CMD_RANDOMNEWS
	   RANDOMNEWS  Modyfikacja losowych wiadomoci wywietlanych 
	               uytkownikom po poczeniu.
OPER_HELP_CMD_OPERNEWS
	   OPERNEWS    Modyfikacja wiadomoci wywietlanych ircopom.
OPER_HELP_CMD_SESSION
	   SESSION     Pokazuje liste sesji.
OPER_HELP_CMD_EXCEPTION
	   EXCEPTION   Modyfikacja listy wyjtkw dla limitw sesji. 
OPER_HELP_CMD_NOOP
	   NOOP        Tymczasowe usunicie wszystkich O:linii na 
	               serwerze.
OPER_HELP_CMD_JUPE
	   JUPE        Fake serwer do blokady pocze.
OPER_HELP_CMD_IGNORE
	   IGNORE      Modyfikacja listy ignore serwisw.
OPER_HELP_CMD_SET
	   SET         Ustawienia rnych, globalnych opcji.
OPER_HELP_CMD_RELOAD
	   RELOAD      Przeadowanie pliku konfiguracyjnego.
OPER_HELP_CMD_UPDATE
	   UPDATE      Natychmiastowa i wymuszona aktualizacja baz
	               serwisw na dysku.
OPER_HELP_CMD_RESTART
	   RESTART     Zapis baz i restart serwisw.
OPER_HELP_CMD_QUIT
	   QUIT        Wyczenie serwisw bez zapisywania baz.
OPER_HELP_CMD_SHUTDOWN
	   SHUTDOWN    Wyczenie serwisw z zapisaniem baz.
OPER_HELP_CMD_DEFCON
	   DEFCON      Modyfikacje systemu DefCon.
OPER_HELP_CMD_CHANKILL
	   CHANKILL    Skilluj wszystkich uytkownikw na kanale.
OPER_HELP_CMD_OLINE
	    OLINE       Daje flagi opera wybranemu uytkownikowi 
OPER_HELP_CMD_UMODE
	    UMODE       Zmiana usermod dla uytkownika.
OPER_HELP_CMD_SVSNICK
	    SVSNICK     Wymuszona zmiana nicka danego uytkownika.
OPER_HELP_CMD_MODLOAD
	   MODLOAD     Zaaduj modu.
OPER_HELP_CMD_MODUNLOAD
	   MODUNLOAD   Wyaduj modu.
OPER_HELP_CMD_MODINFO
	   MODINFO     Informacja na temat wybranego moduu.
OPER_HELP_CMD_MODLIST
	   MODLIST     Lista zaadowanych moduw.

OPER_HELP
	komendy %S:

OPER_HELP_LOGGED
	Notka: Wszystkie komendy w %S s logowane!

OPER_HELP_GLOBAL
	Syntax: GLOBAL message
	
	Allows IRCops to send messages to all users on the network.
	The message will be sent from the nick %s.

OPER_HELP_STATS
	Syntax: STATS [AKILL | ALL | RESET]
	
	Without any option, shows the current number of users and
	IRCops online (excluding Services), the highest number of
	users online since Services was started, and the length of
	time Services has been running.
	
	With the AKILL option, displays the current size of the
	AKILL list and the current default expiry time.
	
	The ALL option is available only to Services admins, and
	displays information on Services' memory usage.  Using this
	option can freeze Services for a short period of time on
	large networks, so don't overuse it!
	
	The RESET option currently resets the maximum user count
	to the number of users currently present on the network.
	
	UPTIME may be used as a synonym for STATS.

OPER_HELP_OPER
	Syntax: OPER ADD nick
	        OPER DEL {nick | entry-num | list}
	        OPER LIST [mask | list]
	        OPER CLEAR
	
	Allows the Services admins to add or remove nicknames
	to or from the Services operator list.  A user whose nickname
	is on the Services operator list and who has identified to
	%s will be able to access Services operator commands.
	
	The OPER ADD command adds the given nickname to the
	Services operator list.
	
	The OPER DEL command removes the given nick from the
	Services operator list.  If a list of entry numbers is given, 
	those entries are deleted.  (See the example for LIST below.)
	
	The OPER LIST command displays the Services operator list.  
	If a wildcard mask is given, only those entries matching the
	mask are displayed.  If a list of entry numbers is given,
	only those entries are shown; for example:

	   OPER LIST 2-5,7-9
	      Lists Services operator entries numbered 2 through 
	      5 and 7 through 9.
	      
	The OPER CLEAR command clears all entries of the
	Services operator list.
	
	Any IRC operator may use the OPER LIST form of the command.
	All other use limited to Services admins.

OPER_HELP_ADMIN
	Syntax: ADMIN ADD nick
	        ADMIN DEL {nick | entry-num | list}
	        ADMIN LIST [mask | list]
	        ADMIN CLEAR
	
	Allows the Services root to add or remove nicknames
	to or from the Services admin list.  A user whose nickname
	is on the Services admin list and who has identified to
	%s will be able to access Services admin commands.
	
	The ADMIN ADD command adds the given nickname to the
	Services admin list.
	
	The ADMIN DEL command removes the given nick from the
	Services admin list.  If a list of entry numbers is given,
	those entries are deleted.  (See the example for LIST below.)
	
	The ADMIN LIST command displays the Services admin list.  
	If a wildcard mask is given, only those entries matching the
	mask are displayed.  If a list of entry numbers is given,
	only those entries are shown; for example:

	   ADMIN LIST 2-5,7-9
	      Lists Services admin entries numbered 2 through 
	      5 and 7 through 9.
	      
	The ADMIN CLEAR command clears all entries of the
	Services admin list.
	
	Any IRC operator may use the ADMIN LIST form of the command.
	All other use limited to Services root.

OPER_HELP_IGNORE
	Syntax: IGNORE {ADD|DEL|LIST|CLEAR} [time] [nick]

	Allows Services Admins to make Services ignore a nick for a
	certain time or until the next restart. The default time
	format is seconds. You can specify it by using units. Valid
	units are: s for seconds, m for minutes, h for hours and
	d for days. Combinations of these units are not permitted. To 
	make Services permanently ignore the user type 0 as time.

OPER_HELP_MODE
	Syntax: MODE channel modes
	
	Allows Services operators to set channel modes for any
	channel.  Parameters are the same as for the standard /MODE
	command.
	
	Limited to Services operators.

OPER_HELP_UMODE
	Syntax: UMODE user modes
	
	Allows Services admins to set user modes for any user.
	Parameters are the same as for the standard /MODE
	command.
	
	Limited to Super admins.

OPER_HELP_OLINE
	Syntax: OLINE user flags
	
	Allows Services admins to give Operflags to any user.
	Flags have to be prefixed with a "+" or a "-". To
	remove all flags simply type a "-" instead of any flags.

	Limited to Super admins.

OPER_HELP_CLEARMODES
	Syntax: CLEARMODES channel [ALL]
	
	Clears all binary modes (i,k,l,m,n,p,s,t) and bans from a
	channel.  If ALL is given, also clears all ops and
	voices (+o and +v modes) from the channel.
	
	Limited to Services operators.

OPER_HELP_KICK
	Syntax: KICK channel user reason
	
	Allows IRCops to kick a user from any channel.
	Parameters are the same as for the standard /KICK
	command.  The kick message will have the nickname of the
	IRCop sending the KICK command prepended; for example:
	
	*** SpamMan has been kicked off channel #my_channel by %S (Alcan (Flood))
	
	Limited to Services operators.

OPER_HELP_SVSNICK
	Syntax: SVSNICK nick newnick
	
	Forcefully changes a user's nickname from nick to newnick.
	
	Limited to Super admins

OPER_HELP_AKILL
	Syntax: AKILL ADD [+expiry] mask reason
	        AKILL DEL {mask | entry-num | list}
	        AKILL LIST [mask | list]
	        AKILL VIEW [mask | list]
	        AKILL CLEAR
	
	Allows Services operators to manipulate the AKILL list.  If
	a user matching an AKILL mask attempts to connect, Services
	will issue a KILL for that user and, on supported server
	types, will instruct all servers to add a ban (K-line) for
	the mask which the user matched.
	
	AKILL ADD adds the given user@host/ip mask to the AKILL
	list for the given reason (which must be given).
	expiry is specified as an integer followed by one of d 
	(days), h (hours), or m (minutes).  Combinations (such as 
	1h30m) are not permitted.  If a unit specifier is not 
	included, the default is days (so +30 by itself means 30 
	days).  To add an AKILL which does not expire, use +0.  If the
	usermask to be added starts with a +, an expiry time must
	be given, even if it is the same as the default.  The
	current AKILL default expiry time can be found with the
	STATS AKILL command.
	
	The AKILL DEL command removes the given mask from the
	AKILL list if it is present.  If a list of entry numbers is 
	given, those entries are deleted.  (See the example for LIST 
	below.)
	
	The AKILL LIST command displays the AKILL list.  
	If a wildcard mask is given, only those entries matching the
	mask are displayed.  If a list of entry numbers is given,
	only those entries are shown; for example:

	   AKILL LIST 2-5,7-9
	      Lists AKILL entries numbered 2 through 5 and 7 
	      through 9.
	      
	AKILL VIEW is a more verbose version of AKILL LIST, and 
	will show who added an AKILL, the date it was added, and when 
	it expires, as well as the user@host/ip mask and reason.
	
	AKILL CLEAR clears all entries of the AKILL list.
	
	Limited to Services operators.
	
OPER_HELP_SGLINE
	Syntax: SGLINE ADD [+expiry] mask:reason
	    SGLINE DEL {mask | entry-num | list}
	        SGLINE LIST [mask | list]
	        SGLINE VIEW [mask | list]
	        SGLINE CLEAR
	
	Allows Services operators to manipulate the SGLINE list.  If
	a user with a realname matching an SGLINE mask attempts to 
	connect, Services will not allow it to pursue his IRC
	session.
	
	SGLINE ADD adds the given realname mask to the SGLINE
	list for the given reason (which must be given).
	expiry is specified as an integer followed by one of d 
	(days), h (hours), or m (minutes).  Combinations (such as 
	1h30m) are not permitted.  If a unit specifier is not 
	included, the default is days (so +30 by itself means 30 
	days).  To add an SGLINE which does not expire, use +0.  If the
	realname mask to be added starts with a +, an expiry time must
	be given, even if it is the same as the default.  The
	current SGLINE default expiry time can be found with the
	STATS AKILL command.
	Note: because the realname mask may contain spaces, the
	separator between it and the reason is a colon.
	
	The SGLINE DEL command removes the given mask from the
	SGLINE list if it is present.  If a list of entry numbers is 
	given, those entries are deleted.  (See the example for LIST 
	below.)
	
	The SGLINE LIST command displays the SGLINE list.  
	If a wildcard mask is given, only those entries matching the
	mask are displayed.  If a list of entry numbers is given,
	only those entries are shown; for example:

	   SGLINE LIST 2-5,7-9
	      Lists SGLINE entries numbered 2 through 5 and 7 
	      through 9.
	      
	SGLINE VIEW is a more verbose version of SGLINE LIST, and 
	will show who added an SGLINE, the date it was added, and when 
	it expires, as well as the realname mask and reason.
	
	SGLINE CLEAR clears all entries of the SGLINE list.
	
	Limited to Services operators.

OPER_HELP_SQLINE
	Syntax: SQLINE ADD [+expiry] mask reason
	        SQLINE DEL {mask | entry-num | list}
	        SQLINE LIST [mask | list]
	        SQLINE VIEW [mask | list]
	        SQLINE CLEAR
	
	Allows Services operators to manipulate the SQLINE list.  If
	a user with a nick matching an SQLINE mask attempts to 
	connect, Services will not allow it to pursue his IRC
	session.

	If the first character of the mask is #, services will 
	prevent the use of matching channels (on IRCds that 
	support it).
	
	SQLINE ADD adds the given mask to the SQLINE
	list for the given reason (which must be given).
	expiry is specified as an integer followed by one of d 
	(days), h (hours), or m (minutes).  Combinations (such as 
	1h30m) are not permitted.  If a unit specifier is not 
	included, the default is days (so +30 by itself means 30 
	days).  To add an SQLINE which does not expire, use +0.  
	If the mask to be added starts with a +, an expiry time 
	must be given, even if it is the same as the default. The
	current SQLINE default expiry time can be found with the
	STATS AKILL command.
	
	The SQLINE DEL command removes the given mask from the
	SQLINE list if it is present.  If a list of entry numbers is 
	given, those entries are deleted.  (See the example for LIST 
	below.)
	
	The SQLINE LIST command displays the SQLINE list.  
	If a wildcard mask is given, only those entries matching the
	mask are displayed.  If a list of entry numbers is given,
	only those entries are shown; for example:

	   SQLINE LIST 2-5,7-9
	      Lists SQLINE entries numbered 2 through 5 and 7 
	      through 9.
	      
	SQLINE VIEW is a more verbose version of SQLINE LIST, and 
	will show who added an SQLINE, the date it was added, and when 
	it expires, as well as the mask and reason.
	
	SQLINE CLEAR clears all entries of the SQLINE list.
	
	Limited to Services operators.

OPER_HELP_SZLINE
	Syntax: SZLINE ADD [+expiry] mask reason
	        SZLINE DEL {mask | entry-num | list}
	        SZLINE LIST [mask | list]
	        SZLINE VIEW [mask | list]
	        SZLINE CLEAR
	
	Allows Services operators to manipulate the SZLINE list.  If
	a user with an IP matching an SZLINE mask attempts to 
	connect, Services will not allow it to pursue his IRC
	session (and this, whether the IP has a PTR RR or not).
	
	SZLINE ADD adds the given IP mask to the SZLINE
	list for the given reason (which must be given).
	expiry is specified as an integer followed by one of d 
	(days), h (hours), or m (minutes).  Combinations (such as 
	1h30m) are not permitted.  If a unit specifier is not 
	included, the default is days (so +30 by itself means 30 
	days).  To add an SZLINE which does not expire, use +0.  If the
	realname mask to be added starts with a +, an expiry time must
	be given, even if it is the same as the default.  The
	current SZLINE default expiry time can be found with the
	STATS AKILL command.
	
	The SZLINE DEL command removes the given mask from the
	SZLINE list if it is present.  If a list of entry numbers is 
	given, those entries are deleted.  (See the example for LIST 
	below.)
	
	The SZLINE LIST command displays the SZLINE list.  
	If a wildcard mask is given, only those entries matching the
	mask are displayed.  If a list of entry numbers is given,
	only those entries are shown; for example:

	   SZLINE LIST 2-5,7-9
	      Lists SZLINE entries numbered 2 through 5 and 7 
	      through 9.
	      
	SZLINE VIEW is a more verbose version of SZLINE LIST, and 
	will show who added an SZLINE, the date it was added, and when
	it expires, as well as the IP mask and reason.
	
	SZLINE CLEAR clears all entries of the SZLINE list.
	
	Limited to Services operators.

OPER_HELP_SET
	Syntax: SET option setting

	Sets various global Services options.  Option names
	currently defined are:
	    READONLY   Set read-only or read-write mode
	    LOGCHAN    Report log messages to a channel
	    DEBUG      Activate or deactivate debug mode
	    NOEXPIRE   Activate or deactivate no expire mode
	    SUPERADMIN Activate or deactivate super-admin mode
	    SQL   	 Activate or deactivate sql mode
	    IGNORE     Activate or deactivate ignore mode
	    LIST       List the options

	Limited to Services admins.

OPER_HELP_SET_READONLY
	Syntax: SET READONLY {ON | OFF}
	
	Sets read-only mode on or off.  In read-only mode, normal
	users will not be allowed to modify any Services data,
	including channel and nickname access lists, etc.  IRCops
	with sufficient Services privileges will be able to modify
	Services' AKILL list and drop or forbid nicknames and
	channels, but any such changes will not be saved unless
	read-only mode is deactivated before Services is terminated
	or restarted.
	
	This option is equivalent to the command-line option
	-readonly.

OPER_HELP_SET_LOGCHAN
	Syntax: SET LOGCHAN {ON | OFF}

	With this setting on, Services will send its logs to a specified
	channel as well as the log file. LogChannel must also be defined
	in the Services configuration file for this setting to be of any
	use.

	Note: This can have strong security implications if your log
	channel is not properly secured.

OPER_HELP_SET_DEBUG
	Syntax: SET DEBUG {ON | OFF | num}
	
	Sets debug mode on or off.  In debug mode, all data sent to
	and from Services as well as a number of other debugging
	messages are written to the log file.  If num is
	given, debug mode is activated, with the debugging level set
	to num.

	This option is equivalent to the command-line option
	-debug.

OPER_HELP_SET_NOEXPIRE
	Syntax: SET NOEXPIRE {ON | OFF}

	Sets no expire mode on or off.  In no expire mode, nicks,
	channels, akills and exceptions won't expire until the
	option is unset.

	This option is equivalent to the command-line option
	-noexpire.

OPER_HELP_SET_SUPERADMIN
	Syntax: SET SUPERADMIN {ON | OFF}

	Setting this will grant you extra privlages such as the
	ability to be "founder" on all channel's etc...

	This option is not persistant, and should only be used when
	needed, and set back to OFF when no longer needed.

OPER_HELP_SET_SQL
	Syntax: SET SQL {ON | OFF}

	Setting this will toggle Anope's from usage of SQL, this should
	be used to disable and enable SQL should your SQL server go down
	while services are running.

OPER_HELP_SET_IGNORE
	Syntax: SET IGNORE {ON | OFF}

	Setting this will toggle Anope's usage of the IGNORE system 
	on or off.

OPER_HELP_SET_LIST
	Syntax: SET LIST

	Display the various OperServ settings

OPER_HELP_NOOP
	Syntax: NOOP SET server
	        NOOP REVOKE server

	NOOP SET remove all O:lines of the given
	server and kill all IRCops currently on it to
	prevent them from rehashing the server (because this
	would just cancel the effect).

	NOOP REVOKE makes all removed O:lines available again
	on the given server.

	Note: The server is not checked at all by the
	Services.
	
	Limited to Services admins.

OPER_HELP_JUPE
	Syntax: JUPE server [reason]
	
	Tells Services to jupiter a server -- that is, to create
	a fake "server" connected to Services which prevents
	the real server of that name from connecting.  The jupe
	may be removed using a standard SQUIT.  If a reason is
	given, it is placed in the server information field;
	otherwise, the server information field will contain the
	text "Juped by <nick>", showing the nickname of the
	person who jupitered the server.
	
	Limited to Services admins.

OPER_HELP_RAW
	Syntax: RAW text
	
	Sends a string of text directly to the server to which
	Services is connected.  This command has a very limited
	range of uses, and can wreak havoc on a network if used
	improperly.  DO NOT USE THIS COMMAND unless you are
	absolutely certain you know what you are doing!
	
	Limited to Services admins.

OPER_HELP_UPDATE
	Syntax: UPDATE
	
	Causes Services to update all database files as soon as you
	send the command.
	
	Limited to Services admins.
	
OPER_HELP_RELOAD
	Syntax: RELOAD

	Causes Services to reload the configuration file. Note that
	some directives still need the restart of the Services to
	take effect (such as Services' nicknames, activation of the 
	session limitation, etc.)
	
	Limited to Services admins.

OPER_HELP_QUIT
	Syntax: QUIT
	
	Causes Services to do an immediate shutdown; databases are
	not saved.  This command should not be used unless
	damage to the in-memory copies of the databases is feared
	and they should not be saved.  For normal shutdowns, use the
	SHUTDOWN command.
	
	Limited to Services admins.

OPER_HELP_SHUTDOWN
	Syntax: SHUTDOWN
	
	Causes Services to save all databases and then shut down.
	
	Limited to Services admins.

OPER_HELP_RESTART
	Syntax: RESTART
	
	Causes Services to save all databases and then restart
	(i.e. exit and immediately re-run the executable).
	
	Limited to Services admins.	

OPER_HELP_KILLCLONES
	Syntax: KILLCLONES nick
	
	Kills all users who have the same hostname as nick. A
	temporary AKILL, in the form *@host, is added to 
	prevent the offending clients from immediately 
	reconnecting. A wallops is also sent indicating who 
	used the command, which host was affected and how many
	users were killed. It's usefull for removing numerous 
	clones from the network.

	Limited to Services operators.
	
OPER_HELP_CHANLIST
	Syntax: CHANLIST [{pattern | nick} [SECRET]]
	
	Lists all channels currently in use on the IRC network, whether they
	are registered or not.

	If pattern is given, lists only channels that match it. If a nickname
	is given, lists only the channels the user using it is on. If SECRET is
	specified, lists only channels matching pattern that have the +s or
	+p mode.
	
	Limited to Services admins.

OPER_HELP_USERLIST
	Syntax: USERLIST [{pattern | channel} [INVISIBLE]]
	
	Lists all users currently online on the IRC network, whether their
	nick is registered or not.
	
	If pattern is given, lists only users that match it (it must be in
	the format nick!user@host). If channel is given, lists only users
	that are on the given channel. If INVISIBLE is specified, only users
	with the +i flag will be listed.
	
	Limited to Services admins.

OPER_HELP_MODLOAD
	Syntax: MODLOAD FileName

	This command loads the module named FileName from the modules
	directory.

	Limited to Services Roots.

OPER_HELP_MODUNLOAD
	Syntax: MODUNLOAD FileName

	This command unloads the module named FileName from the modules
	directory.

	Limited to Services Roots.

OPER_HELP_MODINFO
	Syntax: MODINFO FileName

	This command lists information about the specified loaded module

	Limited to Services Roots.

OPER_HELP_MODLIST
	Syntax: MODLIST

	Lists all currently loaded modules.

	Limited to Services Roots.


###########################################################################
#
# Wiadomoci pomocy BotServ
#
###########################################################################


BOT_HELP_CMD_BOTLIST
	   BOTLIST    Lista dostpnych boty.
BOT_HELP_CMD_ASSIGN
	   ASSIGN     Przydziela bota do kanau.
BOT_HELP_CMD_SET
	   SET        Konfiguruje bota.
BOT_HELP_CMD_KICK
	   KICK       Konfiguruje kick'i.
BOT_HELP_CMD_BADWORDS
	   BADWORDS   Zarzdzanie lista zakaznych sw.
BOT_HELP_CMD_ACT
	   ACT        Makes the bot do the equivalent of a "/me" command
BOT_HELP_CMD_INFO
	   INFO       Allows you to see BotServ information about a channel or a bot
BOT_HELP_CMD_SAY
	   SAY        Makes the bot say the given text on the given channel
BOT_HELP_CMD_UNASSIGN
	   UNASSIGN   Unassigns a bot from a channel
BOT_HELP_CMD_BOT
	   BOT        Zarzdza list botw sieci.

BOT_HELP
	%S pozwala umieci bota na wasnym kanale.
	Zosta stworzony dla uytkownikw, ktrzy nie mog
	hostowa wasnego bota, oraz dla tych sieci ktre
	nie pozwalaj na ich uywanie. Dostpne komendy
	s poniej. Aby ich uy naley wpisa: 
	%R%S komenda. Aby uzyska wicej 
	informacji wpisz %R%S HELP komenda.
	
BOT_HELP_FOOTER
	Bot wejdzie na kana jeli przebywa na nim 
	przynajmniej %d uytkownik(w).
	
BOT_HELP_BOTLIST
	Skadnia: BOTLIST
	
	Listuje dostpne w sieci boty.
	
BOT_HELP_ASSIGN
	Skadnia: ASSIGN kana nick
	
	Przydziela bota o wskazanym nicku na kana.
	
BOT_HELP_UNASSIGN
	Skadnia: UNASSIGN kana
	
	Uycie tej komendy powoduje e bot zostanie usunity 
	z kanau, jednak jego konfiguracja nie zostanie 
	skasowana. Bdzie mona go ponownie przydzieli do 
	kanau w kadej chwili, bez potrzeby ponownego 
	konfigurowania.

BOT_HELP_INFO
	Skadnia: INFO {kana | nick}
	
	Wywietla %S informacje o wskazanym kanale lub bocie, w
	zalenoci od podanego parametru. Z parametrem kana 
	zostan pokazane informacje i opcje dotyczce danego 
	kanau. Jeli parametrem bdzie nick bota, podane 
	informacje bd zawiera dane jak: data stworzenia
	bota, ilo obsugiwanych kanaw itp.
	
BOT_HELP_SET
	Skadnia: SET kana opcja parametry
	
	Umoliwia konfiguracj nastpujcych opcji bota:
	
	   DONTKICKOPS      Bot nie bdzie kopa opw.
	   DONTKICKVOICES   Bot nie bdzie kopa voicew.
	   GREET            Wcza wiadomo powitaln.
	   FANTASY          Wcza publiczne komendy 
	                    kanaowe (fantasy).
	   SYMBIOSIS        Rozszerzony tryb bota. 
	
	Napisz %R%S HELP SET opcja, 
	aby uzyska wicej informacji.
	
BOT_HELP_SET_DONTKICKOPS
	Skadnia: SET kana DONTKICKOPS {ON|OFF}
	
	Wcza lub wycza opcj nie kopania uytkownikw
	posiadajcych status operatora nawet jeli nie 
	przysuguje im poziom dostpu NOKICK.
	
BOT_HELP_SET_DONTKICKVOICES
	Skadnia: SET kana DONTKICKVOICES {ON|OFF}
	
	Wcza lub wycza opcj nie kopania uytkownikw
	posiadjcych status Voice nawet jeli nie 
	przysuguje im poziom dostpu NOKICK.
	
BOT_HELP_SET_FANTASY
	Skadnia: SET kana FANTASY {ON|OFF}

	Wacza lub wycza dostp do kanaowych polece
	publicznych takich jak:	!op, !deop, !voice, 
	!devoice, !kick, !kb, !unban, !seen na kanale 
	(cze komend przyjmuje jako paremetry nicki 
	uytkownikw i powody).
	
	Uytkownicy dopuszczeni do uywania komend 
	publicznych musz mie odpowiedni poziom dostpu,
	tosamy z komendami (np. aby uywac komendy
	!deop, nadane mu uprawnienia musz zawiera
	operacj OPDEOP).

BOT_HELP_SET_GREET
	Skadnia: SET kana GREET {ON|OFF}
	
	Wcza lub wycza wiadomo powitaln dla kanau,
	wywietlan uytkownikom po wejciu na kana.
	
BOT_HELP_SET_SYMBIOSIS
	Skadnia: SET kana SYMBIOSIS {ON|OFF}
	
	Wcza lub wycza rozszerzony tryb bota dla kanau.
	Gdy ten tryb jest wczon, bot bdzie wykonywa
	wszelkie dziaania na kanale wcznie z ustawianiem
	flag, modw i kickw zamiast %s.

BOT_HELP_KICK
	Skadnia: KICK kana opcja parametry
	
	Konfiguruje opcje kopania na kanale:
	
	   BOLDS        Kopanie za uywanie pogrubienia.
	   BADWORDS     Kopanie za uywanie zakazanych sw.
	   CAPS         Kopanie za pisanie WIELKIMI LITERAMI.
	   COLORS       Kopanie za stosowanie kolorkw.
	   FLOOD        Kopanie floodujcych uytkownikw.
	   REPEAT       Kopanie za wielokrotne powtarzanie.
	   REVERSES     Kopanie za odwrcenie kolorw.
	   UNDERLINES   Kopanie za uywanie podkrele.
	
	Napisz %R%S HELP KICK opcja, 
	aby uzyska wicej informacji po poszczeglnych 
	funkcjach.
	
BOT_HELP_KICK_BOLDS
	Skadnia: KICK kana BOLDS {ON|OFF} [ttb]

	Ustawia kopanie za uywanie pogrubionego tekstu.

	ttb to numer ktry okrela ile razy uytkownik 
	stosujcy pogrubienie moe by kopnity zanim 
	ustawiony zostanie ban.

BOT_HELP_KICK_COLORS
	Skadnia: KICK kana COLORS {ON|OFF} [ttb]

	Ustawia kopanie za uywanie kolorowego tekstu.
	
	ttb to numer ktry okrela ile razy uytkownik 
	stosujcy kolorowanie tekstu moe by kopnity zanim 
	ustawiony zostanie ban. Nie podanie parametru ttb 
	wycza wczeniej ustawione banowanie.

BOT_HELP_KICK_REVERSES
	Skadnia: KICK kana REVERSES {ON|OFF} [ttb]

	Ustawia kopanie za uywanie odwrcenia kolorw 
	tekstu, komend np. ctrl + r.

	ttb (time to ban) to numer ktry okrela ile razy 
	uytkownik stosujcy odwrcenie kolorw tekstu moe 
	by kopnity zanim ustawiony zostanie ban. Nie 
	podanie parametru ttb wycza wczeniej ustawione 
	banowanie.

BOT_HELP_KICK_UNDERLINES
	Skadnia: KICK kana UNDERLINES {ON|OFF} [ttb]

	Ustawia kopanie za uywanie podkrelenia tekstu.

	ttb to numer ktry okrela ile razy uytkownik 
	stosujcy podkrelenie tekstu moe by kopnity 
	zanim ustawiony zostanie ban. Nie podanie parametru 
	ttb wycza wczeniej ustawione banowanie.

BOT_HELP_KICK_CAPS
	Skadnia: KICK kana CAPS {ON|OFF} [ttb [min [procent]]]

	Ustawia kopanie za uywanie WIELKICH LITER.

	Bot kopie jeli tekst zawiera przynajmniej min
	wielkich liter co stanowi conajmniej procent
	caego tekstu w linii (w przypadku nie podania tych
	wartoci przyjmowane s standardowe: 10 znakw 
	i 25%).
	
	ttb to numer ktry okrela ile razy uytkownik 
	stosujcy wielkie litery moe by kopnity zanim 
	ustawiony zostanie ban. Nie podanie parametru ttb 
	wycza wczeniej ustawione banowanie.

BOT_HELP_KICK_FLOOD
	Skadnia: KICK kana FLOOD {ON|OFF} [ttb [ln [sek]]]

	Ustawia kopanie za flood. Wczenie tej opcji 
	powoduje wykopywanie uytkownikw floodujcych, tj 
	wysyajcych na kana conajmniej ln linii tekstu 
	w cigu seksekund (w przypadku nie podania tych wartoci przyjmowane 
	s standardowe: 6 linii w cigu 10 sekund).
	
	ttb to numer ktry okrela ile razy uytkownik 
	floodujcy moe by kopnity zanim ustawiony 
	zostanie ban. Nie podanie parametru ttb wycza 
	wczeniej ustawione banowanie.

BOT_HELP_KICK_REPEAT
	Skadnia: KICK kana REPEAT {ON|OFF} [ttb [num]]

	Ustawia kopanie za powtarzanie tekstu. Wczenie tej 
	opcji powoduje wykopywanie uytkownikw 
	powtarzajcych tj wysyajcych na kana conajmniej 
	num razy ten sam tekst (w przypadku nie podania 
	tego parametru jego wartoc ustalana jest na 3).

	ttb to numer ktry okrela ile razy uytkownik 
	powtarzajcy tekst moe by kopnity zanim ustawiony 
	zostanie ban. Nie podanie parametru ttb wycza 
	wczeniej ustawione banowanie.

BOT_HELP_KICK_BADWORDS
	Skadnia: KICK kana BADWORDS {ON|OFF} [ttb]

	Ustawia kopanie za uywanie zakazanych sw.
	
	Moesz ustali list zakazanych sw za pomoc
	polecenia BADWORDS. Napisz 
	%R%S HELP BADWORDS,aby 
	uzyska wicej informacji.

	ttb to numer ktry okrela ile razy uytkownik 
	uywajcy zakazanych sw moe by kopnity zanim 
	ustawiony zostanie ban. Nie podanie parametru ttb 
	wycza wczeniej ustawione banowanie.
	
BOT_HELP_BADWORDS
	Skadnia: BADWORDS kana ADD sowo [SINGLE | START | END]
	          BADWORDS kana DEL {sowo | pozycja | lista}
	          BADWORDS kana LIST [maska | lista]
	          BADWORDS kana CLEAR
	
	Polecenie umoliwia zarzdzanie list niedozwolonych
	sw. Lista definiuja za uywanie ktrych sw 
	uytkownicy mog zosta wyrzuceni z kanau. Aby 
	uzyska wicej informacji napisz: 
	%R%S HELP KICK BADWORDS
	
	Komenda BADWORDS ADD umoliwia dodanie 
	wskazanego sowa do listy. Parametr SIGLE powoduje, 
	e uytkownicy bd kopani za uywanie wskazanego 
	sowa w caoci. 
	Parametr START - kopanie za uywanie wskazanego 
	sowa na pocztku innych wyrazw. END powoduje 
	kopanie za uywanie wskazanego sowa na kocu 
	wyrazw. Nie podanie parametru spowoduje kopnicie 
	uytkownika w kadym z przypadkw kiedy zostanie 
	uyte wskazane sowo.
	
	Polecenie BADWORDS DEL usuwa wskazane sowo lub
	sowa z listy (dopuszczalne jest podanie numeru 
	sowa, lub grupy sw, przykad poniej).
	
	Polecenie BADWORDS LIST wywietla list 
	zakazanych sw. Jeli zostanie podana maska, 
	wywietlone zostan jedynie wpisy pasujce do wzorca 
	(dopuszczalne jest podanie numeru sowa, lub grupy 
	sw, przykad poniej).

	Przykad:
	   BADWORDS kana LIST 2-5,7-9
	      Listuje sowa niedozwolone od numeru 2 do 5
	      oraz od 7 do 9.
	      
	Polecenie BADWORDS CLEAR usuwa wszystkie wpisy z 
	listy zakazanych sw.

BOT_HELP_SAY
	Skadnia: SAY kana tekst
	
	Wymusza wypowiedzenie podanego tekstu przez bota na 
	podanym kanale.

BOT_HELP_ACT
	Skadnia: ACT kana tekst
	
	Sprawia e Bot uyje komendy akcji (/me) przy 
	wypowiedzeniu podanego tekstu na kanale.

BOT_SERVADMIN_HELP_BOT
	Skadnia: BOT ADD nick ident host nazwa
	          BOT CHANGE starynick nowynick [ident [host [nazwa]]]
	          BOT DEL nick
	
	Polecenie pozwala Administratorom Serwisw na 
	tworzenie, modyfikowanie oraz kasowanie botw 
	uywanych przez uytkownikw sieci na kanaach.
	
	BOT ADD dodaje bota o podanym nicku, idencie, 
	hocie oraz realname. 
	BOT CHANGE pozwala na zmiane nicka, identa, 
	hosta lub realname bota bez jego kasowania. 
	BOT DEL usuwa wskazanego bota. 
	
	UWAGA: Jeli stworzony zostanie bot o nicku, 
	ktry jest ju zarejestrowany, nick zostanie 
	odrejestrowany. Podobnie jeli nick stworzonego 
	bota bdzie uywany przez innego uytkownika, 
	zostanie on wtedy skillowany.

BOT_SERVADMIN_HELP_SET
	
	Ponisze opcje s dostpne dla Administratorw 
	Serwisw:
	
	   NOBOT     Uniemoliwia botowi przypisywanie go do 
	             kanaw.
	   PRIVATE   Umoliwia przypisywanie bota jedynie przez 
	             IRC Operatorw.

BOT_SERVADMIN_HELP_SET_NOBOT
	Skadnia: SET kana NOBOT {ON|OFF}
	
	Polecenie to pozwala okreli kana do ktrego
	nie wolno przypisywa botw. Dotychczasowe 
	przypisania botw zostan cofnite dla kanau po 
	aktywacji tej opcji.
	
	Komenda dostpna dla Administratorw Serwisw.

BOT_SERVADMIN_HELP_SET_PRIVATE
	Skadnia: SET nick-bota PRIVATE {ON|OFF}

	Polecenie pozwala na uniemoliwienie przypisania
	wskazanego bota do kanaw, przez uytkownikw nie
	bdcych IRC Operatorami.
	
	Komenda dostpna dla Administratorw Serwisw.

###########################################################################
#
# Komunikaty HostServ 
#
###########################################################################
HOST_EMPTY
	Lista vhostw jest pusta.
HOST_ENTRY
	#%d Nick:%s, vhost:%s (%s - %s)
HOST_IDENT_ENTRY
	#%d Nick:%s, vhost:%s@%s (%s - %s)
HOST_SET
	vhost dla %s ustawiono na %s.
HOST_IDENT_SET
	vhost dla %s ustawiono na %s@%s.
HOST_SETALL
	vhost dla grupy %s ustawiono na %s.
HOST_DELALL
	vhosty dla grupy %s zostay usunite.
HOST_DELALL_SYNTAX
	Skadnia: DELALL <nick>.
HOST_IDENT_SETALL
	vhost dla groupy %s ustawiono na 
	%s@%s.
HOST_SET_ERROR
	A vhost must be in the format of a valid hostmask.
HOST_SET_IDENT_ERROR
	A vhost ident must be in the format of a valid ident
HOST_SET_TOOLONG
	Error! The vhost is too long, please use a host shorter than %d characters.
HOST_SET_IDENTTOOLONG
	Error! The Ident is too long, please use an ident shorter than %d characters.
HOST_NOREG
	User %s not found in the nickserv db.
HOST_SET_SYNTAX
	Syntax %R%s set <nick> <hostmask>.
HOST_SETALL_SYNTAX
	Syntax %R%s setall <nick> <hostmask>.
HOST_DENIED
	Access Denied.
HOST_NOT_ASSIGNED
	Please contact an Operator to get a vhost assigned to this nick.
HOST_ACTIVATED
	Your vhost of %s is now activated.
HOST_IDENT_ACTIVATED
	Your vhost of %s@%s is now activated.
HOST_ID
	Please identify to services first.
HOST_NOT_REGED
	You need to register before a vhost can be assigned to you.
HOST_DEL
	vhost for %s removed.
HOST_DEL_SYNTAX
	Syntax: %R%s del <nick>.
HOST_OFF_UNREAL
	Your vhost was removed. To re-enable the standard host cloaking, type /mode %s +%s
HOST_NO_VIDENT
	Your IRCD does not support vIdent's, if this is incorrect, please report this as a possible bug
HOST_GROUP
	All vhost's in the group %s have been set to %s
HOST_IDENT_GROUP
	All vhost's in the group %s have been set to %s@%s
HOST_LIST_FOOTER
	Displayed all records (Count: %d)
HOST_LIST_RANGE_FOOTER
	Displayed records from %d to %d
HOST_LIST_KEY_FOOTER
	Displayed records matching key %s (Count: %d)

###########################################################################
#
# HostServ Help messages
#
###########################################################################
HOST_HELP_CMD_ON
	    ON          Activates your assigned vhost

HOST_HELP_CMD_OFF
	    OFF         Deactivates your assigned vhost

HOST_HELP_CMD_GROUP
	    GROUP       Syncs the vhost for all nicks in a group

HOST_HELP_CMD_SET
	    SET         Set the vhost of another user

HOST_HELP_CMD_SETALL
	    SETALL      Set the vhost for all nicks in a group

HOST_HELP_CMD_DEL
	    DEL         Delete the vhost of another user

HOST_HELP_CMD_DELALL
	    DELALL      Delete the vhost for all nicks in a group

HOST_HELP_CMD_LIST
	    LIST        Displays one or more vhost entries.

HOST_OPER_HELP
	not used.

HOST_ADMIN_HELP
	not used.

HOST_HELP
	%S commands:

HOST_HELP_ON
	Syntax: ON

	Activates the vhost currently assigned to the nick in use.
	When you use this command any user who performs a /whois
	on you will see the vhost instead of your real IP address.

HOST_HELP_SET
	Syntax: SET <nick> <hostmask>.

	Sets the vhost for the given nick to that of the given
	hostmask.  If your IRCD supports vIdents, then using
	SET <nick> <ident>@<hostmask> set idents for users as 
	well as vhosts.

	Limited to Host Setters.

HOST_HELP_DELALL
	Syntax: DELALL <nick>.

	Deletes the vhost for all nick's in the same group as
	that of the given nick.

	Limited to Host Removers.


HOST_HELP_SETALL
	Syntax: SETALL <nick> <hostmask>.

	Sets the vhost for all nicks in the same group as that
	of the given nick.  If your IRCD supports vIdents, then
	using SETALL <nick> <ident>@<hostmask> will set idents
	for users as well as vhosts.

	* NOTE, this will not update the vhost for any nick's
	added to the group after this command was used.

	Limited to Host Setters.

HOST_HELP_OFF
	Syntax: OFF

	Deactivates the vhost currently assigned to the nick in use.
	When you use this command any user who performs a /whois
	on you will see your real IP address.

HOST_HELP_DEL
	Syntax: DEL <nick>

	Deletes the vhost assigned to the given nick from the
	database.

	Limited to HostRemovers.

HOST_HELP_LIST
	Syntax: LIST [<key>|<#X-Y>]

	This command lists registered vhosts to the operator
	if a Key is specified, only entries whos nick or vhost match
	the pattern given in <key> are displayed e.g. Rob* for all
	entries beginning with "Rob"

	If a #X-Y style is used, only entries between the range of X
	and Y will be displayed, e.g. #1-3 will display the first 3
	nick/vhost entries.

	The list uses the value of NSListMax as a hard limit for the
	number of items to display to a operator at any 1 time.

	Limited to Services operators.

HOST_HELP_GROUP
	Syntax: GROUP
	
	This command allows users to set the vhost of their
	CURRENT nick to be the vhost for all nicks in the same
	group.

OPER_SVSNICK_UNSUPPORTED
	Sorry, SVSNICK is not available on this network.

OPER_SQLINE_UNSUPPORTED
	Sorry, SQLINE is not available on this network.

OPER_SVSO_UNSUPPORTED
	Sorry, OLINE is not available on this network.

OPER_UMODE_UNSUPPORTED
	Sorry, UMODE is not available on this network.

OPER_SUPER_ADMIN_NOT_ENABLED
	SuperAdmin setting not enabled in services.conf

