# Hungarian (magyar) language file.
#
# (C) 2003-2007 Anope Team
# Contact us at info@anope.org
#    
# Translated by:                                      
# ==============                                      
# Janos Kapitany 'Sarkanyka' (chates@freemail.hu)
# CJB CHAT Magyarorszg, http://cjbchat.hu     
# Ez a fordts a CJB Chat megrendelsre kszlt. 
#
# Please read COPYING and README for furhter details.
#     
# Based on the original code of Epona by Lara.
# Based on the original code of Services by Andy Church. 
#
# When translating this file to another language, keep in mind that the
# order of parameters for sprintf() is fixed in the source code, so your
# messages need to take the same parameters in the same order as the
# English messages do.  (Obviously, this doesn't hold for the strftime()
# format lines immediately below.)  If you can't get a natural translation
# of a message without changing the order of the parameters, let us know
# (dev@anope.org) which message is causing a problem and I'll see
# what I can do.
#
# In help messages, "%S" (capital S, not lowercase) refers to the name of
# the service sending the message; for example, in NickServ help messages,
# "%S" is replaced by "NickServ" (or whatever it is renamed to in
# services.conf).  The %S's do not count as sprintf() parameters, so they can be
# rearranged, removed, or added as necessary.
#
# Also in help messages, please try to limit line lengths to 60 characters
# of text (not including the leading tab).  This length was chosen because
# it does not cause line wrap under default settings on most current IRC
# clients.  Remember that format characters (control-B, control-_) are not
# included in that 60-character limit (since they don't show on the user's
# screen).  Also remember that format specifiers (%S, etc.) will expand
# when displayed, so remember to take this into account; you can assume
# that the length of a pseudoclient name (%S replacement) will be eight
# characters, so reduce the maximum line length by 6 for every %S on a
# line.
#
# Finally, remember to put a tab at the beginning of every line of text
# (including empty lines).  This has to be a tab, not spaces.

###########################################################
#
# A nyelvezet neve
#
###########################################################


# Angoltl (English) eltro nyelvek esetn a stringnek a kvetkezo
# formtumban kell lennie:
#     nyelvezet-neve-a-nyelvben (nyelvezet-neve-angolul)
# Pldul, "Spanyol (Spanish)" vagy "Francia (French)".

LANG_NAME
	Magyar (Hungarian)

###########################################################
#
# ltalnos zenetek
#
###########################################################
	
# strftime() bellitsi sorai. 3 strfid informci formtumban adhat
# meg a bellitsokban.  Rvid, hossz s teljes verzi:
#	%a = Nap neve (rvid)		%H = ra
#	%b = Hnap neve (rvid)	%M = perc
#	%d = nap a hnapban		%S = msodperc
#	%Y = v			%Z = id zne

# ezt a formt hasznld az strftime() mikor a dtum s id
# egytt szksges.
STRFTIME_DATE_TIME_FORMAT
	%Z %Y %B %d %H:%M:%S
# ezt a formt hasznld az strftime() mikor a dtumnak hossz
# formtum kell (Angol: a nap neve is).
STRFTIME_LONG_DATE_FORMAT
	%Y %B %d %A
# ezt a formt hasznld az strftime() mikor a dtumnak elg
# a rvig forma (Angol:: nap neve is).
STRFTIME_SHORT_DATE_FORMAT
	%b %d %Y

# Ez megadja az strftime() ltal hasznlt hnap s nap neveket.  Ha nem
# hasznlsz %a, %A, %b, vagy %B vltozt az strftime() stringben feljebb, akkor
# nyugodtan szabadon hagyhatod. Ha bersz neveket, akkor azoknak sorban kell lennik,
# s csak egy lehet soronknt, a listnak teljesnek KELL lennie!
	
# %a
STRFTIME_DAYS_SHORT
	Vas
	Ht
	Ke
	Sze
	Cs
	Pn
	Szo
# %A
STRFTIME_DAYS_LONG
	Vasrnap
	Htf
	Kedd
	Szerda
	Cstrtk
	Pntek
	Szombat
# %b
STRFTIME_MONTHS_SHORT
	Jan
	Feb
	Mrc
	pr
	Mj
	Jn
	Jl
	Aug
	Szept
	Okt
	Nov
	Dec
# %B
STRFTIME_MONTHS_LONG
	Janur
	Februr
	Mrcius
	prilis
	Mjus
	Jnius
	Jlius
	Augusztus
	Szeptember
	Oktber
	November
	December



# Ezt a ChanServ/NickServ INFO megjelentseknl hasznlja.
COMMA_SPACE
	,


# Klnbz hiba zenetek.
USER_RECORD_NOT_FOUND
	Bels hiba - nem teljesthet krs.
UNKNOWN_COMMAND
	Ismeretlen Parancs %s.
UNKNOWN_COMMAND_HELP
	Ismeretlen parancs %s. rd be: "%R%s HELP".
SYNTAX_ERROR
	Szintaktika: %s
MORE_INFO
	%R%s HELP %s bvebb informcirt.
NO_HELP_AVAILABLE
	Nincs ezzel kapcsolatban segtsg: %s.
OBSOLETE_COMMAND
	Nem hasznlhat parancs; hasznld a %s parancsot helyette.

BAD_USERHOST_MASK
	A maszknak ilyen formtumnak kell lennie: user@host.
BAD_EXPIRY_TIME
	rvnytelen elvlsi id.
USERHOST_MASK_TOO_WIDE
	%s tl tg tartomnyra vonatkozik.

SERVICE_OFFLINE
	%s jelenleg offline.
READ_ONLY_MODE
	Megjegyzs: A Szervz csak olvass mdban fut!
PASSWORD_INCORRECT
	Hibs jelsz.
INVALID_TARGET
	"/msg %s" is no longer supported.  Use "/msg %s@%s" or "/%s" instead.

# Mi a klnbsg a "Hozzfrs megtagadva" s az "Engedly letiltva" kztt?
# Nagyon kicsi; ha ugyanazt az zenetet rod mindkettre, nem igazn veszt
# a jelentsbl. Ha klnbsget akarsz tenni, akkor a "Hozzfrs megtagadva"
# ltalnosabb rtelemben hasznlatos, pldul, ha egy nem oper prbl 
# hozzfrni az OperServhez, akkor azt kapja, hogy "Hozzfrs megtagadva",
# amikor egy nem Szervz admin prblja hasznlni a NickServ SET NOEXPIRE
# opcit, akkor  azt kapja, hogy "Endegly letiltva".
ACCESS_DENIED
	Hozzfrs megtagadva.
PERMISSION_DENIED
	Engedly megtagadva.
RAW_DISABLED
	A RAW opc nem hasznlhat. Ha  hasznlnod kell, llitsd
	akkor be a DisableRaw bellitst  a Szerviz belltsnl.
MORE_OBSCURE_PASSWORD
	Prblj nehezebb jelszt hasznlni .Jelszavad  min. t
	karakter legyen,	s nem kitallhat legyen, (ne a
	nickneved/valsneved),  ne legyen benne rsjel.
PASSWORD_TRUNCATED
	Megjegyzs:  A jelszavad %d karakter hosszsgra lett csonktva.
NICK_NOT_REGISTERED
	A neved mg nem regisztrlt.
NICK_NOT_REGISTERED_HELP
	A neved mg nem regisztrlt.  Segtsg: %R%s HELP.
NICK_X_IS_SERVICES
	A %s nick a Hlzat Szervznek egysge.
NICK_X_NOT_REGISTERED
	Ez a nick: %s nem regisztrlt.
NICK_X_IN_USE
	Ez a nick: %s jelenleg hasznlatban van.
NICK_X_NOT_IN_USE
	Ez a nick: %s nincs jelenleg hasznlatban.
NICK_X_NOT_ON_CHAN
	%s jelenleg nincs a %s szobban .
NICK_X_FORBIDDEN
	 %snicket  nem lehet regisztrlni vagy hasznlni.
NICK_X_FORBIDDEN_OPER
	Ezt a nicket: %s %s forbidolta:
	%s
NICK_X_ILLEGAL
	 %snick illeglis nicknv vagy nem hasznlhat.
NICK_X_TRUNCATED
	A nicked %s meg lett csonktva %d karakter hosszsgra.
NICK_X_SUSPENDED
	Nick %s is currently suspended.
CHAN_X_NOT_REGISTERED
	 %s szoba nem regisztrlt.
CHAN_X_NOT_IN_USE
	%scsatorna nem ltezik.
CHAN_X_FORBIDDEN
	%scsatornt nem lehet regisztrlni vagy hasznlni.
CHAN_X_FORBIDDEN_OPER
	%scsatornt %s forbidolta:
	%s
CHAN_X_SUSPENDED
	 Felfggesztve: [%s] %s
NICK_IDENTIFY_REQUIRED
	Jelszavas azonosits szksges ehhez a parancshoz.
	Prbld jra miutn bertad: %R%s IDENTIFY jelsz.
CHAN_IDENTIFY_REQUIRED
	Jelszavas azonosits szksges ehhez a parancshoz.
	Prbld jra miutn bertad: %R%s IDENTIFY %s jelsz.
	
MAIL_DISABLED
	A Szervz gy van belltva, hogy nem kld mailt.
MAIL_INVALID
	%sEmail cme nem rvnyes.
MAIL_X_INVALID
	%s nem rvnyes e-mail cm.
MAIL_LATER
	Nem lehet most levelet kldeni;  prbld jra ksbb.
MAIL_DELAYED
	Krlek vrj %d msodpercet s prbld jra.
	
NO_REASON
	Nincs indok
UNKNOWN
	<ismeretlen>

# Duration system
DURATION_DAY
	1 nap
DURATION_DAYS
	%d nap
DURATION_HOUR
	1 ra
DURATION_HOURS
	%d ra
DURATION_MINUTE
	1 perc
DURATION_MINUTES
	%d perc
DURATION_SECOND
	1 msodperc
DURATION_SECONDS
	%d msodperc

# Emberi olvashat elvlsek
NO_EXPIRE
	nem fog elvlni
EXPIRES_SOON
	elvl a kvetkez adatbzis mentsnl
EXPIRES_M
	elvl %d perc mlva
EXPIRES_1M
	elvl %d perc mlva
EXPIRES_HM
	elvl %d ra, %d perc mlva
EXPIRES_H1M
	elvl %d ra, %d perc mlva
EXPIRES_1HM
	elvl %d ra, %d perc mlva
EXPIRES_1H1M
	elvl %d ra, %d perc mlva
EXPIRES_D
	elvl %d nap mlva
EXPIRES_1D
	elvl %d nap mlva
	
# ltalnos lbjegyzet zenet
END_OF_ANY_LIST
	%s lista vge.

##########################################################
#
# NickServ zenetek
#
##########################################################
	
# Automatikus zenetek
LIST_INCORRECT_RANGE
	Incorrect range specified. The correct syntax is #from-to.
CS_LIST_INCORRECT_RANGE
	To search for channels starting with #, search for the channel
	name without the #-sign prepended (anope instead of #anope).

###########################################################################
#
# NickServ messages
#
###########################################################################

# Automatic messages
HELP_LIMIT_SERV_OPER
	Limited to Services Operators.
HELP_LIMIT_SERV_ADMIN
	Limited to Services Administrators.
HELP_LIMIT_SERV_ROOT
	Limited to Services Roots.
HELP_LIMIT_IRC_OPER
	Limited to IRC Operators.
HELP_LIMIT_HOST_SETTER
	Limited to Host Setters.
HELP_LIMIT_HOST_REMOVER
	Limited to Host Removers.


###########################################################################
#
# NickServ messages
#
###########################################################################

# Automatic messages
NICK_IS_REGISTERED
	Ez a nick mr regisztrlt.  Krlek vlassz msikat.
	Ha ez a te nicked, akkor %R%s IDENTIFY jelsz! 
NICK_IS_SECURE
	Ez a nick regisztrlt s vdett.  Ha ez a te nicked,
	akkor %R%s IDENTIFY jelsz!
	Klnben vlassz msik nicknevet!
NICK_MAY_NOT_BE_USED
	Ez a nicknv nem hasznlhat. Krlek vlassz msikat!
FORCENICKCHANGE_IN_1_MINUTE
	Ha nem vltasz nevet 1 percen bell, n megvltoztatom.
FORCENICKCHANGE_IN_20_SECONDS
	Ha nem vltasz nevet 20 sec.-en bell, n megvltoztatom.
FORCENICKCHANGE_NOW
	Ez a nicknv regisztrlt; te nem hasznlhatod.
FORCENICKCHANGE_CHANGING
	A nickneved most meg lesz vltoztatva: %s.

# REGISTER vlaszok
NICK_REGISTER_SYNTAX
	REGISTER jelsz [email]
NICK_REGISTER_SYNTAX_EMAIL
	REGISTER jelsz email
NICK_REGISTRATION_DISABLED
	Sajnlom, a nickregisztrci jelenleg nem mkdik.
NICK_REGISTRATION_FAILED
	Sajnlom, a regisztrci sikertelen.
NICK_REG_PLEASE_WAIT
	 Vrj %d msodpercet mieltt  hasznlnd ezt a parancsot!
NICK_CANNOT_BE_REGISTERED
	Ez a nicknv: %s nem regisztrlhat.
NICK_ALREADY_REGISTERED
	Ez a nicknv: %s mr regisztrlt!
NICK_REGISTERED
	Ez a nicknv: %s szmodra lett regisztrlva: %s
NICK_REGISTERED_NO_MASK
	Nickname %s registered.
NICK_PASSWORD_IS
	Jelszavad: %s - jegyezd meg a ksbbi hasznlathoz!
NICK_REG_DELAY
	A nicked regisztrlshoz %d msodpercnl rgebben kell csatlakozva lenned.
	
# GROUP vlaszok
NICK_GROUP_SYNTAX
	GROUP clnick jelsz
NICK_GROUP_DISABLED
	Sajnlom, a csoportok hasznlata ideiglenesen le van tiltva.
NICK_GROUP_FAILED
	Sajnlom, a group parancs hasznlata sikertelen.
NICK_GROUP_PLEASE_WAIT
	Krlek vrj %d msodpercet, mieltt ismt hasznlod a GROUP parancsot.
NICK_GROUP_CHANGE_DISABLED
	A nicked mr regisztrlt; rd be %R%s DROP elszr.
NICK_GROUP_SAME
	Mr tagja vagy ennek a csoportnak: %s.
NICK_GROUP_TOO_MANY
	Tl sok nick van a %s csoportban; listzd  s dropolj prat.
	rd: %R%s HELP GLIST s %R%s HELP DROP
	bvebb informcikrt.
NICK_GROUP_JOINED
	Mostantl tagja vagy a %scsoportnak.

# IDENTIFY vlaszok
NICK_IDENTIFY_SYNTAX
	IDENTIFY jelsz
NICK_IDENTIFY_FAILED
	Sajnlom, azonosts sikertelen.
NICK_IDENTIFY_SUCCEEDED
	Jelszavad elfogadva - azonosts sikeres.
NICK_IDENTIFY_EMAIL_REQUIRED
	Be kell lltanod egy E-mail cmet a nicknevedhez.
NICK_IDENTIFY_EMAIL_HOWTO
	rd be: %R%S SET EMAIL e-mail 
	Az email cmed nem lesz kiadva harmadik szemlynek.
NICK_ALREADY_IDENTIFIED
	Mr be vagy azonostva. :-)

# UPDATE vlaszok
NICK_UPDATE_SUCCESS
	Sttusz frisstve (memok, vhost, chmodok, flagek).
	
# LOGOUT vlaszok
NICK_LOGOUT_SYNTAX
	LOGOUT
NICK_LOGOUT_SUCCEEDED
	A nicked sikeresen kijelentkezett.
NICK_LOGOUT_X_SUCCEEDED
	 %s nick sikeresen kijelentkezett.
NICK_LOGOUT_SERVICESADMIN
	%s nem tud kijelentkezni, mert  egy services admin.
	
# DROP vlaszok
NICK_DROP_DISABLED
	Sajnlom,  a nicknevek regisztrcijnak trlse  sznetel.
NICK_DROPPED
	A nickneved dropolva lett,
NICK_X_DROPPED
	A %s nicknevet dropoltad.
	
# SET vlaszok
NICK_SET_SYNTAX
	SET opci paramterek
NICK_SET_SERVADMIN_SYNTAX
	SET [nick] opci paramterek
NICK_SET_DISABLED
	Sajnlom,  a nicknv opci bellts jelenleg sznetel.
NICK_SET_UNKNOWN_OPTION
	Ismeretlen SET opci: %s.
NICK_SET_UNKNOWN_OPTION_OR_BAD_NICK
	Ismeretlen SET opci: %s,  vagy a nick nem regisztrlt.
NICK_SET_OPTION_DISABLED
	Ez az opci: %snem llthat be ezen a hlzaton.

# SET DISPLAY vlaszok
NICK_SET_DISPLAY_INVALID
	Az j megjelentshez KELL az j becenv s a csoport!
NICK_SET_DISPLAY_CHANGED
	Az j megjelents: %s.
	
# SET PASSWORD vlaszok
NICK_SET_PASSWORD_FAILED
	Sajnlom, a jelszavad nem sikerlt megvltoztatni.
NICK_SET_PASSWORD_CHANGED
	Jelszavad megvltoztatva.
NICK_SET_PASSWORD_CHANGED_TO
	Jelszavad megvltoztatva a kvetkezre: %s.
	
# SET LANGUAGE vlaszok
NICK_SET_LANGUAGE_SYNTAX
	SET LANGUAGE szm
NICK_SET_LANGUAGE_UNKNOWN
	Ismeretlen nyelvi sorszm %d %R%s HELP SET LANGUAGE
NICK_SET_LANGUAGE_CHANGED
	j nyelvezet: Magyar.

# SET URL vlaszok
NICK_SET_URL_CHANGED
	URL megvltoztatva: %s.
NICK_SET_URL_UNSET
	URL trlve.

# SET EMAIL vlaszok
NICK_SET_EMAIL_CHANGED
	E-mail cm megvltoztatva: %s.
NICK_SET_EMAIL_UNSET
	E-mail cm trlve.
NICK_SET_EMAIL_UNSET_IMPOSSIBLE
	Nem trlheted ezen a hlzaton az e-mail cmed.
	
# SET ICQ vlaszok
NICK_SET_ICQ_CHANGED
	ICQ szmod megvltoztatva: %s.
NICK_SET_ICQ_UNSET
	ICQ szm trlve.
NICK_SET_ICQ_INVALID
	%s nem rvnyes szm.
	
# SET GREET vlaszok
NICK_SET_GREET_CHANGED
	Ksznt zenet megvltoztatva: %s.
NICK_SET_GREET_UNSET
	Ksznt zeneted trlve.

# SET PROTECT vlaszok
NICK_SET_KILL_SYNTAX
	SET KILL {ON | QUICK | OFF}
NICK_SET_KILL_IMMED_SYNTAX
	SET KILL {ON | QUICK | IMMED | OFF}
NICK_SET_KILL_ON
	A Kill vdelem opci most mr ON.
NICK_SET_KILL_QUICK
	A Kill vdelem opci most mr ON, cskkentet idvel.
NICK_SET_KILL_IMMED
	A Kill vdelem opci most mr ON, ksleltets nlkl.
NICK_SET_KILL_IMMED_DISABLED
	Az  IMMED opci nem elrhet ezen a hlzaton.
NICK_SET_KILL_OFF
	A Kill vdelem opci most mr OFF.

# SET SECURE vlaszok
NICK_SET_SECURE_SYNTAX
	SET SECURE {ON | OFF}
NICK_SET_SECURE_ON
	A Secure opci most mr ON.
NICK_SET_SECURE_OFF
	A Secure opci most mr OFF.

# SET PRIVATE vlaszok
NICK_SET_PRIVATE_SYNTAX
	SET PRIVATE {ON | OFF}
NICK_SET_PRIVATE_ON
	A Private opci most mr ON.
NICK_SET_PRIVATE_OFF
	A Private opci most mr OFF.

# SET HIDE vlaszok
NICK_SET_HIDE_SYNTAX
	SET HIDE {EMAIL | USERMASK | QUIT} {ON | OFF}
NICK_SET_HIDE_EMAIL_ON
	 E-mail cmed most rejtve lesz a %s INFO kirsnl.
NICK_SET_HIDE_EMAIL_OFF
	E-mail cmed most lthat lesz a %s INFO kirsnl.
NICK_SET_HIDE_MASK_ON
	Utols user@host maszkod rejtve lesz a %s INFO kirsnl.
NICK_SET_HIDE_MASK_OFF
	Utols user@host maszkod lthat lesz a %s INFO kirsnl.
NICK_SET_HIDE_QUIT_ON
	Utols kilp zeneted rejtve lesz a %s INFO kirsnl
NICK_SET_HIDE_QUIT_OFF
	Utols kilp zeneted lthat lesz a %s INFO kirsnl.
NICK_SET_HIDE_STATUS_ON
	A szervz hozzfrsi sttuszod rejtve lesz a %s INFO kirsnl.
NICK_SET_HIDE_STATUS_OFF
	A szervz hozzfrsi sttuszod lthat lesz a %s INFO kirsnl.

# SET MSG vlaszok
NICK_SET_MSG_SYNTAX
	SET MSG {ON | OFF}
NICK_SET_MSG_ON
	A szervz mostantl  privt zenetekbenvlaszol.
NICK_SET_MSG_OFF
	A szervz jra notice-t kld a vlaszoknl.

# SET AUTOOP responses
NICK_SET_AUTOOP_SYNTAX
	SET AUTOOP {ON | OFF}
NICK_SET_AUTOOP_ON
	Services will now autoop you in channels.
NICK_SET_AUTOOP_OFF
	Services will no longer autoop you in channels.

# SET NOEXPIRE vlaszok
NICK_SASET_SYNTAX
	SASET nickname option parameters
NICK_SASET_DISABLED
	Sorry, nickname option setting is temporarily disabled.
NICK_SASET_UNKNOWN_OPTION
	Unknown SASET option %s.
NICK_SASET_BAD_NICK
	Nickname %s not registered.
NICK_SASET_OPTION_DISABLED
	Option %s cannot be set on this network.

# SASET DISPLAY responses
NICK_SASET_DISPLAY_INVALID
	The new display for %s MUST be a nickname of the nickname group!
NICK_SASET_DISPLAY_CHANGED
	The new display is now %s.

# SASET PASSWORD responses
NICK_SASET_PASSWORD_FAILED
	Sorry, couldn't change password for %s.
NICK_SASET_PASSWORD_CHANGED
	Password for %s changed.
NICK_SASET_PASSWORD_CHANGED_TO
	Password for %s changed to %s.

# SASET LANGUAGE responses
NICK_SASET_URL_CHANGED
	URL for %s changed to %s.
NICK_SASET_URL_UNSET
	URL %s unset.

# SASET EMAIL responses
NICK_SASET_EMAIL_CHANGED
	E-mail address for %s changed to %s.
NICK_SASET_EMAIL_UNSET
	E-mail address for %s unset.
NICK_SASET_EMAIL_UNSET_IMPOSSIBLE
	You cannot unset the e-mail on this network.
	
# SASET ICQ responses
NICK_SASET_ICQ_CHANGED
	ICQ number for %s set to %s.
NICK_SASET_ICQ_UNSET
	ICQ number for %s unset.
NICK_SASET_ICQ_INVALID
	%s is not a valid number.
	
# SASET GREET responses
NICK_SASET_GREET_CHANGED
	Greet message for %s changed to %s.
NICK_SASET_GREET_UNSET
	Greet message for %s unset.

# SASET PROTECT responses
NICK_SASET_KILL_SYNTAX
	SASET nickname KILL {ON | QUICK | OFF}
NICK_SASET_KILL_IMMED_SYNTAX
	SASET nickname KILL {ON | QUICK | IMMED | OFF}
NICK_SASET_KILL_ON
	Protection is now ON for %s.
NICK_SASET_KILL_QUICK
	Protection is now ON for %s, with a reduced delay.
NICK_SASET_KILL_IMMED
	Protection is now ON for %s, with no delay.
NICK_SASET_KILL_IMMED_DISABLED
	The IMMED option is not available on this network.
NICK_SASET_KILL_OFF
	Protection is now OFF for %s.

# SASET SECURE responses
NICK_SASET_SECURE_SYNTAX
	SASET nickname SECURE {ON | OFF}
NICK_SASET_SECURE_ON
	Secure option is now ON for %s.
NICK_SASET_SECURE_OFF
	Secure option is now OFF for %s.

# SASET PRIVATE responses
NICK_SASET_PRIVATE_SYNTAX
	SASET nickname PRIVATE {ON | OFF}
NICK_SASET_PRIVATE_ON
	Private option is now ON for %s.
NICK_SASET_PRIVATE_OFF
	Private option is now OFF for %s.

# SASET HIDE responses
NICK_SASET_HIDE_SYNTAX
	SET nickname HIDE {EMAIL | USERMASK | QUIT} {ON | OFF}
NICK_SASET_HIDE_EMAIL_ON
	The E-mail address of %s will now be hidden from %s INFO displays.
NICK_SASET_HIDE_EMAIL_OFF
	The E-mail address of %s will now be shown in %s INFO displays.
NICK_SASET_HIDE_MASK_ON
	The last seen user@host mask of %s will now be hidden from %s INFO displays.
NICK_SASET_HIDE_MASK_OFF
	The last seen user@host mask of %s will now be shown in %s INFO displays.
NICK_SASET_HIDE_QUIT_ON
	The last quit message of %s will now be hidden from %s INFO displays.
NICK_SASET_HIDE_QUIT_OFF
	The last quit message of %s will now be shown in %s INFO displays.
NICK_SASET_HIDE_STATUS_ON
	The services access status of %s will now be hidden from %s INFO displays.
NICK_SASET_HIDE_STATUS_OFF
	The services access status of %s will now be shown in %s INFO displays.
	
# SASET MSG responses
NICK_SASET_MSG_SYNTAX
	SSAET nickname PRIVATE {ON | OFF}
NICK_SASET_MSG_ON
	Services will now reply to %s with messages.
NICK_SASET_MSG_OFF
	Services will now reply to %s with notices.

# SET NOEXPIRE responses
NICK_SASET_NOEXPIRE_SYNTAX
	SASET nickname NOEXPIRE {ON | OFF}
NICK_SASET_NOEXPIRE_ON
	Nick %s will not expire.
NICK_SASET_NOEXPIRE_OFF
	Nick %s will expire.

# ACCESS responses
NICK_SASET_AUTOOP_SYNTAX
	SASET nickname AUTOOP {ON | OFF}
NICK_SASET_AUTOOP_ON
	Services will now autoop %s in channels.
NICK_SASET_AUTOOP_OFF
	Services will no longer autoop %s in channels.


# ACCESS responses
NICK_ACCESS_SYNTAX
	ACCESS {ADD | DEL | LIST} [maszk]
NICK_ACCESS_ALREADY_PRESENT
	Ez a maszk: %s mr szerepel a hozzfrsi listdon.
NICK_ACCESS_REACHED_LIMIT
	Neked csak %d bejegyzsed lehet a hozzfrsi listn.
NICK_ACCESS_ADDED
	%s hozzadva a hozzfrsi listdhoz.
NICK_ACCESS_NOT_FOUND
	%s nem tallhat a hozzfrsi listdon.
NICK_ACCESS_DELETED
	%s trlve a hozzfrsi listdrl.
NICK_ACCESS_LIST
	Hozzfrsi lista:
NICK_ACCESS_LIST_X
	%s hozzfrsi listja:
NICK_ACCESS_LIST_EMPTY
	Your access list is empty.
NICK_ACCESS_LIST_X_EMPTY
	Access list for %s is empty.

# Status messages
NICK_STATUS_0
	STATUS %s 0
NICK_STATUS_1
	STATUS %s 1
NICK_STATUS_2
	STATUS %s 2
NICK_STATUS_3
	STATUS %s 3

# INFO Vlaszok
NICK_INFO_SYNTAX
	INFO nick [ALL]
NICK_INFO_REALNAME
	%s az %s
NICK_INFO_SERVICES_OPER
	%s egy szervz opertor.
NICK_INFO_SERVICES_ADMIN
	%s egy szervz adminisztrtor.
NICK_INFO_SERVICES_ROOT
	%s egy szervz root adminisztrtor.
NICK_INFO_ADDRESS
	Utoljra ltott cm: %s
NICK_INFO_ADDRESS_ONLINE
	Jelenleg online errl a cmrl: %s
NICK_INFO_ADDRESS_ONLINE_NOHOST
	%s jelenleg online.
NICK_INFO_TIME_REGGED
	Regisztrls ideje: %s
NICK_INFO_LAST_SEEN
	Utoljra ekkor volt: %s
NICK_INFO_LAST_QUIT
	Utols kilp zenet: %s
NICK_INFO_URL
	URL: %s
NICK_INFO_EMAIL
	E-mail cm: %s
NICK_INFO_VHOST
	vhost: %s
NICK_INFO_VHOST2
	vhost: %s@%s
NICK_INFO_ICQ
	ICQ #: %d
NICK_INFO_GREET
	Ksznt zenet: %s
NICK_INFO_OPTIONS
	Opcik: %s
NICK_INFO_EXPIRE
	Expires in: %s
# Ezek a stringek NEM LEHETNEK resek
NICK_INFO_OPT_KILL
	Kill vdelem
NICK_INFO_OPT_SECURE
	Biztonsg
NICK_INFO_OPT_PRIVATE
	Privt
NICK_INFO_OPT_MSG
	zenet md
NICK_INFO_OPT_AUTOOP
	Auto-op
NICK_INFO_OPT_NONE
	Nincs
NICK_INFO_NO_EXPIRE
	Ez a nicknv nem fog elvlni.
NICK_INFO_FOR_MORE
	Bvebb informcikrt, rd be: %R%s INFO %s ALL.

# LIST vlaszok
NICK_INFO_SUSPENDED
	This nickname is currently suspended, reason: %s
NICK_INFO_SUSPENDED_NO_REASON
	This nickname is currently suspended

# LIST responses
NICK_LIST_SYNTAX
	LIST pattern
NICK_LIST_SERVADMIN_SYNTAX
	LIST pattern [FORBIDDEN] [NOEXPIRE] [UNCONFIRMED]
NICK_LIST_HEADER
	Azon bejegyzsek listja, melyek egyeznek ezzel, %s:
NICK_LIST_RESULTS
	Lista vge - %d / %d tallat megjelentve.
	
# ALIST vlaszok
NICK_ALIST_SYNTAX
	ALIST nicknv
NICK_ALIST_HEADER
	Azon csatornk, ahol hozzfrsed van:
	  Sorszm  Csatorna           Szint    Meghatrozs 
NICK_ALIST_HEADER_X
	Azon csatornk, ahol %s nicknek hozzfrse van:
	  Sorszm  Csatorna              Szint    Meghatrozs
NICK_ALIST_XOP_FORMAT
	  %3d %c %-20s %-8s  %s
NICK_ALIST_ACCESS_FORMAT
	  %3d %c %-20s %-8d %s
NICK_ALIST_FOOTER
	Lista vge - %d / %d csatorna megjelentve.

# GLIST vlaszok
NICK_GLIST_HEADER
	A csoportodba tartoz nickek listja:
NICK_GLIST_HEADER_X
	%s csoportjba tartoz nickek listja:
NICK_GLIST_FOOTER
	%d nicknv van a csoportban.
NICK_GLIST_REPLY
	   %c%s
NICK_GLIST_REPLY_ADMIN
	   %c%s (expires in %s)

# RECOVER vlaszok
NICK_RECOVER_SYNTAX
	RECOVER nicknv [jelsz]
NICK_NO_RECOVER_SELF
	Nem hasznlhatod az aktiv nickedre!
NICK_RECOVERED
	A nevedet hasznl user killve lett.
	rd be:%R%s RELEASE %s s visszaszerzed a nicked.

# RELEASE vlaszok
NICK_RELEASE_SYNTAX
	RELEASE nicknv [jelsz]
NICK_RELEASE_NOT_HELD
	Ezt a nicket %s nem fogja a services.
NICK_RELEASED
	A Services rendelkezsedre bocsjtotta a nicket.

# GHOST vlaszok
NICK_GHOST_SYNTAX
	GHOST nicknv [jelsz]
NICK_NO_GHOST_SELF
	Nem ghostolhatod ki magad!
NICK_GHOST_KILLED
	A befagyott kliens killelve.

# GETPASS vlaszok
NICK_GETPASS_SYNTAX
	GETPASS nicknv
NICK_GETPASS_UNAVAILABLE
	GETPASS  nem elrhet, amg az encryption hasznlatban van
NICK_GETPASS_PASSWORD_IS
	%s jelszava: %s.

# GETEMAIL vlaszok
NICK_GETEMAIL_SYNTAX
	GETEMAIL user@email-host Nincs * karakter!!
NICK_GETEMAIL_EMAILS_ARE
	Egyez emailek %s ehhez: %s.
NICK_GETEMAIL_NOT_USED
	Nincs Email listzva ehhez: %s.

# SENDPASS vlaszok
NICK_SENDPASS_SYNTAX
	SENDPASS nicknv
NICK_SENDPASS_UNAVAILABLE
	SENDPASS nem elrhet, amg az encryption hasznlatban van.
NICK_SENDPASS_SUBJECT
	Nicknv jelsz (%s)
NICK_SENDPASS_HEAD
	Hi,
NICK_SENDPASS_LINE_1
	Azt krted, hogy a %s nicknv jelszavt kldjk el e-mailben.
NICK_SENDPASS_LINE_2
	A jelszavad %s Ezt a biztosng miatt meg kell vltztatni,	miutn megkaptad ezt a levelet.
NICK_SENDPASS_LINE_3
	Ha nem tudod mirt kaptad ezt a levelet, akkor krlek hagyd figyelmen kivl!
NICK_SENDPASS_LINE_4
	ERRE A LEVLRE NE VLASZOLJ!!!
NICK_SENDPASS_LINE_5
	%s adminisztrtorok.
NICK_SENDPASS_OK
	%s nick jelszava elkldve.

# FORBID vlaszok
NICK_SUSPEND_SYNTAX
	SUSPEND nickname reason
NICK_SUSPEND_SUCCEEDED
	Nick %s is now suspended.
NICK_SUSPEND_FAILED
	Couldn't suspend nick %s!

# UNSUSPEND responses
NICK_UNSUSPEND_SYNTAX
	UNSUSPEND nickname
NICK_UNSUSPEND_SUCCEEDED
	Nick %s is now released.
NICK_UNSUSPEND_FAILED
	Couldn't release nick %s!

# FORBID responses
NICK_FORBID_SYNTAX
	FORBID nicknv [indok]
NICK_FORBID_SYNTAX_REASON
	FORBID nicknv indok
NICK_FORBID_SUCCEEDED
	%s nick most mr forbidolt.
NICK_FORBID_FAILED
	Nem forbidolhat: %s!

# Nick Registraion vlaszok
NICK_REQUESTED
	Ezt a nicket mr krelmeztk, ellenrizd az e-mail cimed, egy levlben van a kdod.
NICK_REG_RESENT
	A kd jra el lett kldve erre a cmre: %s.
NICK_REG_UNABLE
	Nick NEM regisztrlt, prbld ksbb.
NICK_IS_PREREG
	A nick az emailben elkldtt kddal val aktvlsra vr a regisztrci befejezshez.
NICK_ENTER_REG_CODE
	A kd a %s cmre lett kldve, rd be %R%s confirm <kd> a regisztrci befejezshez.
NICK_CONFIRM_NOT_FOUND
	Regisztrci 1 lpse lehet, hogy elvlt, rd be: "%R%s register <jelsz> <email>".
NICK_CONFIRM_INVALID
	rvnytelen kd, ellenrizze az e-mailben, majd prblja jra.
NICK_REG_MAIL_SUBJECT
	Nicknv Regisztrci (%s)
NICK_REG_MAIL_HEAD
	Hi,
NICK_REG_MAIL_LINE_1
	Te krelmeztad a %s nick regisztrlst.
NICK_REG_MAIL_LINE_2
	rd be: " %R%s confirm %s ", hogy befejezd a regisztrcit.
NICK_REG_MAIL_LINE_3
	Ha nem tudod mirt kaptad a levelet, krlek hagyd figyelmen kvl!
NICK_REG_MAIL_LINE_4
	NE VLASZOLJ A LEVLRE!
NICK_REG_MAIL_LINE_5
	%s adminisztrtorok.
NICK_GETPASS_PASSCODE_IS
	Kd a %s nickhez:  %s.
NICK_FORCE_REG
	A %s nicknv rvnyestve. 

###########################################################
#
# ChanServ zenetek
#
###########################################################
	
# Access level lersok
CHAN_LEVEL_AUTOOP
	Automatikus opertor (+o) sttusz
CHAN_LEVEL_AUTOVOICE
	Automatikus voice (+v) sttusz (hangads)
CHAN_LEVEL_AUTOHALFOP
	Automatikus halfop (+h) sttusz (flop)
CHAN_LEVEL_AUTOPROTECT
	Automatikus protect (+a) md. 
CHAN_LEVEL_AUTODEOP
	Csatorna opertori sttusz tiltsa.
CHAN_LEVEL_NOJOIN
	Nem lphet a csatornra, ha a RESTRICTED hasznlatban.
CHAN_LEVEL_INVITE
	Hasznlhatja az INVITE parancsot.
CHAN_LEVEL_AKICK
	Hasznlhatja az AKICK parancsot.
CHAN_LEVEL_SET
	Hasznlhatja a SET parancsot (kivve FOUNDER/PASSWORD).
CHAN_LEVEL_CLEAR
	Hasznlhatja a CLEAR parancsot.
CHAN_LEVEL_UNBAN
	Hasznlhatja az UNBAN parancsot.
CHAN_LEVEL_OPDEOP
	Hasznlhatja az OP/DEOP parancsot.
CHAN_LEVEL_ACCESS_LIST
	Megtekintheti a hozzfrsi listt.
CHAN_LEVEL_ACCESS_CHANGE
	Mdosthatja a hozzfrsi listt.
CHAN_LEVEL_MEMO
	rhat/olvashat csatorna memo zeneteket
CHAN_LEVEL_ASSIGN
	Trsthat/eltvolthat services botot
CHAN_LEVEL_BADWORDS
	Hasznlhatja a BADWORDS parancsot
CHAN_LEVEL_NOKICK
	Nem lesz kirgva a bot automatikus funkciival.
CHAN_LEVEL_FANTASIA
	Hasznlhatja a fantasia parancsokat.
CHAN_LEVEL_SAY
	Hasznlhatja az ACT s SAY parancsokat.
CHAN_LEVEL_GREET
	NickServ-es ksznt zenet megjelenik.
CHAN_LEVEL_VOICEME
	Hasznlhatja a (de)voiceme parancsokat
CHAN_LEVEL_VOICE
	Hasznlhatja a VOICE/DEVOICE parancsokat.
CHAN_LEVEL_GETKEY
	Hasznlhatja a GETKEY parancsot.
CHAN_LEVEL_OPDEOPME
	Hasznlhatja a (de)opme parancsot.
CHAN_LEVEL_HALFOPME
	Hasznlhatja a (de)halfopme parancsot.
CHAN_LEVEL_HALFOP
	Hasznlhatja a HALFOP/DEHALFOP parancsokat
CHAN_LEVEL_PROTECTME
	Hasznlhatja a (de)protectme parancsot
CHAN_LEVEL_PROTECT
	Hasznlhatja a PROTECT/DEPROTECT parancsokat
CHAN_LEVEL_KICKME
	Hasznlhatja a kickme parancsot
CHAN_LEVEL_KICK
	Hasznlhatja a KICK parancsot
CHAN_LEVEL_SIGNKICK
	Nincs signkick, ha a SIGNKICK LEVEL hasznlatban van.
CHAN_LEVEL_BANME
	Hasznlhatja a banme parancsot
CHAN_LEVEL_BAN
	Hasznlhatja a BAN parancsot
CHAN_LEVEL_TOPIC
	Hasznlhatja a TOPIC parancsot
CHAN_LEVEL_INFO
	Hasznlhatja az INFO parancsot az ALL opcival

# Automatikus vlaszok
CHAN_IS_REGISTERED
	Ez a szoba a %s adatbzisban regisztrlt.
CHAN_NOT_ALLOWED_OP
	Nem lehetsz szobaop ezen a csatornn: %s.
CHAN_MAY_NOT_BE_USED
	Ez a csatorna nem hasznlhat.
CHAN_NOT_ALLOWED_TO_JOIN
	Nem tartzkodhatsz ezen a csatornn.

# REGISTER vlaszok
CHAN_X_INVALID
	Channel %s is not a valid channel.

# REGISTER responses
CHAN_REGISTER_SYNTAX
	REGISTER #szoba jelsz lers
CHAN_REGISTER_DISABLED
	Sajnlom,  a csatorna regisztrci jelenleg sznetel.
CHAN_REGISTER_NOT_LOCAL
	Helyi csatornk nem regisztrlhatk.
CHAN_MUST_REGISTER_NICK
	Elszr regisztrlnod kell a nevedet. %R%s help
CHAN_MUST_IDENTIFY_NICK
	Krlek azonosts a %s-be, hasznld ezt a parancsot:
	%R%s IDENTIFY jelsz
CHAN_MAY_NOT_BE_REGISTERED
	Ez a csatorna %s nem regisztrlhat. 
CHAN_ALREADY_REGISTERED
	A megadott csatorna %s mr regisztrlt!
CHAN_MUST_BE_CHANOP
	A csatornn opertornak kell lenned, hogy regisztrlhasd.
CHAN_REACHED_CHANNEL_LIMIT
	Mr elrted a fels korltot (%d) csatornk szmban.
CHAN_EXCEEDED_CHANNEL_LIMIT
	Mr tllpted a fels korltot (%d) a csatornn.
CHAN_REGISTRATION_FAILED
	Sajnlom,  regisztrci sikertelen.
CHAN_REGISTERED
	Regisztrltam a %s csatornt a (%s) nickre.
CHAN_PASSWORD_IS
	Csatorna jelszava: %s - Jegyezd fel a ksbbi hasznlathoz.
CHAN_REGISTER_NONE_CHANNEL
	You have attempted to register a nonexistent channel %s
CHAN_SYMBOL_REQUIRED
	Please use the symbol of # when attempting to register


# IDENTIFY vlaszok
CHAN_IDENTIFY_SYNTAX
	IDENTIFY   #szoba   jelsz
CHAN_IDENTIFY_FAILED
	Sajnlom,  azonosts sikertelen.
CHAN_IDENTIFY_SUCCEEDED
	Jelszavad elfogadva - founder szint a hozzfrsed a %s csatornn.

# LOGOUT vlaszok
CHAN_LOGOUT_SYNTAX
	LOGOUT #szoba nicknv
CHAN_LOGOUT_SERVADMIN_SYNTAX
	LOGOUT #szoba  [nicknv]
CHAN_LOGOUT_SUCCEEDED
	%s felhasznl kijelentkezett a %s csatornrl.
CHAN_LOGOUT_ALL_SUCCEEDED
	Minden felhasznl kijelentkezett a %s csatornrl.

# DROP vlaszok
CHAN_DROP_SYNTAX
	DROP #szoba
CHAN_DROP_DISABLED
	A csatornk regisztrcijnak trlse jelenleg sznetel.
CHAN_DROPPED
	%s csatorna regisztrcijnak trlse sikerlt.

# SET vlaszok
CHAN_SET_SYNTAX
	SET #szoba opci paramterek
CHAN_SET_DISABLED
	A csatornk opciinak bellitsa jelenleg sznetel.
CHAN_SET_UNKNOWN_OPTION
	Ismeretlen SET opci %s.

# SET FOUNDER vlaszok
CHAN_SET_FOUNDER_TOO_MANY_CHANS
	%s rszre tl sok csatorna van regisztrlva.
CHAN_FOUNDER_CHANGED
	A megadott csatorna (%s) j foundere: %s.

# SET SUCCESSOR vlaszok
CHAN_SUCCESSOR_CHANGED
	A megadott csatorna (%s) j successora: %s.
CHAN_SUCCESSOR_UNSET
	A megadott csatorna %s successora trlve.
CHAN_SUCCESSOR_IS_FOUNDER
	%s nem lehet a %s csatorna successora, mert  a founder is.

# SET PASSWORD vlaszok
CHAN_SET_PASSWORD_FAILED
	A jelsz belltsa sikertelen.
CHAN_PASSWORD_CHANGED
	%s csatorna jelszava megvltozott.
CHAN_PASSWORD_CHANGED_TO
	%s csatorna j jelszava: %s.

# SET DESC vlaszok
CHAN_DESC_CHANGED
	%s csatorna lers megvltoztatva: %s.

# SET URL vlaszok
CHAN_URL_CHANGED
	A megadott csatorna (%s) j URL cme: %s.
CHAN_URL_UNSET
	A megadott csatorna %s URL cme trlve.

# SET EMAIL vlaszok
CHAN_EMAIL_CHANGED
	A megadott csatorna (%s) j E-mail cme: %s.
CHAN_EMAIL_UNSET
	A megadott csatorna (%s) E-mail cme trlve.

# SET ENTRYMSG vlaszok
CHAN_ENTRY_MSG_CHANGED
	%s csatorna belp zenete megvltozott.
CHAN_ENTRY_MSG_UNSET
	%s csatorna belp zenete trlve.

# SET BANTYPE vlaszok
CHAN_SET_BANTYPE_INVALID
	%s nem rvnyes ban tpus.
CHAN_SET_BANTYPE_CHANGED
	A megadott csatorna (%s) j ban tpusa: #%d.

# SET MLOCK vlaszok
CHAN_SET_MLOCK_UNKNOWN_CHAR
	Ismeretlen md karakter: %c figyelmen kvl hagyva.
CHAN_SET_MLOCK_IMPOSSIBLE_CHAR
	%c md figyelmen kvl hagyva, mert nem rgztheted.
CHAN_SET_MLOCK_L_REQUIRED
	Rgztened kell a +l mdot is, ha a +L mdot rgzited.
CHAN_SET_MLOCK_K_REQUIRED
	Rgztened kell a +i mdot is, ha a +K mdot rgzted.
CHAN_MLOCK_CHANGED
	A megadott csatornn (%s) az j Mode lock: %s.

# SET KEEPTOPIC vlaszok
CHAN_SET_KEEPTOPIC_SYNTAX
	SET #szoba KEEPTOPIC {ON | OFF}
CHAN_SET_KEEPTOPIC_ON
	Topic retention option for %s is now ON.
CHAN_SET_KEEPTOPIC_OFF
	Topic retention option for %s is now OFF.

# SET TOPICLOCK vlaszok
CHAN_SET_TOPICLOCK_SYNTAX
	SET #szoba TOPICLOCK {ON | OFF}
CHAN_SET_TOPICLOCK_ON
	Topic lock option for %s is now ON.
CHAN_SET_TOPICLOCK_OFF
	Topic lock option for %s is now OFF.

# SET PEACE vlaszok
CHAN_SET_PEACE_SYNTAX
	SET #szoba PEACE {ON | OFF}
CHAN_SET_PEACE_ON
	Peace option for %s is now ON.
CHAN_SET_PEACE_OFF
	Peace option for %s is now OFF.

# SET PRIVATE vlaszok
CHAN_SET_PRIVATE_SYNTAX
	SET #szoba PRIVATE {ON | OFF}
CHAN_SET_PRIVATE_ON
	Private option for %s is now ON.
CHAN_SET_PRIVATE_OFF
	Private option for %s is now OFF.

# SET SECUREOPS vlaszok
CHAN_SET_SECUREOPS_SYNTAX
	SET #szoba SECUREOPS {ON | OFF}
CHAN_SET_SECUREOPS_ON
	Secure ops option for %s is now ON.
CHAN_SET_SECUREOPS_OFF
	Secure ops option for %s is now OFF.

# SET SECUREFOUNDER vlaszok
CHAN_SET_SECUREFOUNDER_SYNTAX
	SET #szoba SECUREFOUNDER {ON | OFF}
CHAN_SET_SECUREFOUNDER_ON
	Secure founder option for %s is now ON.
CHAN_SET_SECUREFOUNDER_OFF
	Secure founder option for %s is now OFF.

# SET RESTRICTED vlaszok
CHAN_SET_RESTRICTED_SYNTAX
	SET #szoba RESTRICTED {ON | OFF}
CHAN_SET_RESTRICTED_ON
	Restricted access option for %s is now ON.
CHAN_SET_RESTRICTED_OFF
	Restricted access option for %s is now OFF.

# SET SECURE vlaszok
CHAN_SET_SECURE_SYNTAX
	SET #szoba SECURE {ON | OFF}
CHAN_SET_SECURE_ON
	Secure option for %s is now ON.
CHAN_SET_SECURE_OFF
	Secure option for %s is now OFF.

# SET SIGNKICK vlaszok
CHAN_SET_SIGNKICK_SYNTAX
	SET #szoba SIGNKICK {ON | LEVEL | OFF}
CHAN_SET_SIGNKICK_ON
	Signed kick option for %s is now ON.
CHAN_SET_SIGNKICK_LEVEL
	Signed kick option for %s is now ON, but depends of the
	level of the user that is using the command.
CHAN_SET_SIGNKICK_OFF
	Signed kick option for %s is now OFF.

# SET OPNOTICE vlaszok
CHAN_SET_OPNOTICE_SYNTAX
	SET #szoba OPNOTICE {ON | OFF}
CHAN_SET_OPNOTICE_ON
	Op-notice option for %s is now ON.
CHAN_SET_OPNOTICE_OFF
	Op-notice option for %s is now OFF.

# SET XOP vlaszok
CHAN_SET_XOP_SYNTAX
	SET #szoba XOP {ON | OFF}
CHAN_SET_XOP_ON
	xOP lists system for %s is now ON.
CHAN_SET_XOP_OFF
	xOP lists system for %s is now OFF.

# SET NOEXPIRE vlaszok
CHAN_SET_NOEXPIRE_SYNTAX
	SET #szoba NOEXPIRE {ON | OFF}
CHAN_SET_NOEXPIRE_ON
	A megadott csatorna (%s) nem fog elvlni.
CHAN_SET_NOEXPIRE_OFF
	A megadott csatorna (%s) el fog vlni.

# xOP zenetek
CHAN_XOP_REACHED_LIMIT
	Csak %d szm helyed van a csatorna VOP/AOP/SOP listn.
CHAN_XOP_LIST_FORMAT
	  %3d  %s
CHAN_XOP_ACCESS
	Nem hasznlhatod a parancsot. Hasznld az ACCESS parancsot.
	Bvebb informci: %R%s HELP ACCESS
CHAN_XOP_NOT_AVAILABLE
	xOP system is not available.

# AOP zenetek
CHAN_AOP_SYNTAX
	AOP #szoba { ADD | DEL | LIST | CLEAR } [ nick | sorszm ]
CHAN_AOP_DISABLED
	Csatorna AOP lista mdosts sznetel.
CHAN_AOP_NICKS_ONLY
	Csatorna AOP listja csak regisztrlt nevet tartalmazhat.
CHAN_AOP_ADDED
	%s hozzadva %s AOP listhoz.
CHAN_AOP_MOVED
	%s  thelyezve a %s AOP listra.
CHAN_AOP_NO_SUCH_ENTRY
	Nem tallhat (#%d) a %s AOP listn.
CHAN_AOP_NOT_FOUND
	%s nem tallathat a %s AOP listn.
CHAN_AOP_NO_MATCH
	Nincs ilyen bejegyzs a %s AOP listn.
CHAN_AOP_DELETED
	%s trlve lett a %s AOP listrl.
CHAN_AOP_DELETED_ONE
	1 bejegyzs trlve a %s AOP listrl.
CHAN_AOP_DELETED_SEVERAL
	%d bejegyzs trlve a %s AOP listrl.
CHAN_AOP_LIST_EMPTY
	%s AOP listja res.
CHAN_AOP_LIST_HEADER
	%s AOP listja:
	  Sorszm  Nicknv

# HOP zenetek
CHAN_AOP_CLEAR
	Channel %s AOP list has been cleared.

# HOP messages
CHAN_HOP_SYNTAX
	HOP #szoba { ADD | DEL | LIST | CLEAR } [ nick | sorszm ]
CHAN_HOP_DISABLED
	Csatorna HOP lista mdosts sznetel.
CHAN_HOP_NICKS_ONLY
	Csatorna HOP listja csak regisztrlt nevet tartalmazhat.
CHAN_HOP_ADDED
	%s hozzadva %s HOP listhoz.
CHAN_HOP_MOVED
	%s  thelyezve a %s HOP listra.
CHAN_HOP_NO_SUCH_ENTRY
	Nem tallhat (#%d) a %s HOP listn.
CHAN_HOP_NOT_FOUND
	%s nem tallathat a %s HOP listn.
CHAN_HOP_NO_MATCH
	Nincs ilyen bejegyzs a %s HOP listn.
CHAN_HOP_DELETED
	%s trlve lett a %s HOP listrl.
CHAN_HOP_DELETED_ONE
	1 bejegyzs trlve a %s HOP listrl.
CHAN_HOP_DELETED_SEVERAL
	%d bejegyzs trlve a %s HOP listrl.
CHAN_HOP_LIST_EMPTY
	%s HOP listja res.
CHAN_HOP_LIST_HEADER
	%s HOP listja:
	  Sorszm  Nicknv

# SOP zenetek
CHAN_HOP_CLEAR
	Channel %s HOP list has been cleared.

# SOP messages
CHAN_SOP_SYNTAX
	SOP #szoba { ADD | DEL | LIST | CLEAR }[ nick | sorszm]
CHAN_SOP_DISABLED
	Csatorna SOP lista mdosts sznetel.
CHAN_SOP_NICKS_ONLY
	Csatorna SOP listja csak regisztrlt nevet tartalmazhat.
CHAN_SOP_ADDED
	%s hozzadva %s SOP listhoz.
CHAN_SOP_MOVED
	%s  thelyezve a %s SOP listra.
CHAN_SOP_NO_SUCH_ENTRY
	Nem tallhat (#%d) a %s SOP listn.
CHAN_SOP_NOT_FOUND
	%s nem tallathat a %s SOP listn.
CHAN_SOP_NO_MATCH
	Nincs ilyen bejegyzs a %s SOP listn.
CHAN_SOP_DELETED
	%s trlve lett a %s SOP listrl.
CHAN_SOP_DELETED_ONE
	1 bejegyzs trlve a %s SOP listrl.
CHAN_SOP_DELETED_SEVERAL
	%d bejegyzs trlve a %s SOP listrl.
CHAN_SOP_LIST_EMPTY
	%s SOP listja res.
CHAN_SOP_LIST_HEADER
	%s SOP listja:
	  Sorszm  Nicknv

# VOP messages
CHAN_SOP_CLEAR
	Channel %s SOP list has been cleared.

# VOP messages
CHAN_VOP_SYNTAX
	VOP #csatorna { ADD | DEL | LIST | CLEAR } [ nick | sorszm ]
CHAN_VOP_DISABLED
	Csatorna VOP lista mdosts sznetel.
CHAN_VOP_NICKS_ONLY
	Csatorna VOP listja csak regisztrlt nevet tartalmazhat.
CHAN_VOP_ADDED
	%s hozzadva %s VOP listhoz.
CHAN_VOP_MOVED
	%s  thelyezve a %s VOP listra.
CHAN_VOP_NO_SUCH_ENTRY
	Nem tallhat (#%d) a %s VOP listn.
CHAN_VOP_NOT_FOUND
	%s nem tallathat a %s VOP listn.
CHAN_VOP_NO_MATCH
	Nincs ilyen bejegyzs a %s VOP listn.
CHAN_VOP_DELETED
	%s trlve lett a %s VOP listrl.
CHAN_VOP_DELETED_ONE
	1 bejegyzs trlve a %s VOP listrl.
CHAN_VOP_DELETED_SEVERAL
	%d bejegyzs trlve a %s VOP listrl.
CHAN_VOP_LIST_EMPTY
	%s VOP listja res.
CHAN_VOP_LIST_HEADER
	%s VOP listja:
	  Sorszm  Nicknv

# ACCESS zenetek
CHAN_VOP_CLEAR
	Channel %s VOP list has been cleared.

# ACCESS messages
CHAN_ACCESS_SYNTAX
	ACCESS#szoba{ ADD | DEL | LIST | CLEAR } [ nick [ szint ] | sorszm ]
CHAN_ACCESS_XOP
	Nem hasznlhatod ezt a parancsot. 
	Hasznld az AOP, SOP s VOP parancsokat helyette.
	rd be: %R%s HELP parancs bvebb informcirt.
	Ha ki akarod kapcsolni az xOP rendszert, akkor rd be:
	%RChanServ set #szobanv xop off.
CHAN_ACCESS_XOP_HOP
	You can't use this command. 
	Use the AOP, SOP, HOP and VOP commands instead.
	Type %R%s HELP command for more information.
CHAN_ACCESS_DISABLED
	A csatorna hozzfrsi listjnak mdostsa sznetel.
CHAN_ACCESS_LEVEL_NONZERO
	A hozzfrsi szint nem lehet nulla.
CHAN_ACCESS_LEVEL_RANGE
	A hozzfrsi szintnek %d s %d kztt kell lennie.
CHAN_ACCESS_NICKS_ONLY
	Csatorna listja csak regisztrlt nickeket tartalmazhat.
CHAN_ACCESS_REACHED_LIMIT
	Neked csak %d  helyed van a csatorna listjn.
CHAN_ACCESS_LEVEL_UNCHANGED
	%s hozzfrsi szintje a (%s) csatornn : %d
CHAN_ACCESS_LEVEL_CHANGED
	%s hozzfrse a (%s) csatornn vltozott: %d.
CHAN_ACCESS_ADDED
	%s hozzadva a %s hozzfrsi listjhoz.
	A hozzfrsi szintje a ChanServ parancsokhoz:  %d.
CHAN_ACCESS_NO_SUCH_ENTRY
	A bejegyzs (#%d) nem tallhat %s hozzfrsi listjn.
CHAN_ACCESS_NOT_FOUND
	%s nem tallhat a (%s) csatorna hozzfrsi listjn.
CHAN_ACCESS_NO_MATCH
	Nincs ilyen bejegyzs a (%s) csatorna hozzfrsi listjn.
CHAN_ACCESS_DELETED
	%s trlve lett a (%s) csatorna hozzfrsi listjrl.
CHAN_ACCESS_DELETED_ONE
	1 bejegyzs trlve a (%s) csatorna hozzfrsi listjrl
CHAN_ACCESS_DELETED_SEVERAL
	%d bejegyzs trlve (%s) csatorna hozzfrsi listjrl.
CHAN_ACCESS_LIST_EMPTY
	%s hozzfrsi listja res.
CHAN_ACCESS_LIST_HEADER
	%s hozzfrsi listja:
	  Sorszm   Szint  Nick
CHAN_ACCESS_LIST_FOOTER
	Hozzfrsi lista vge.
CHAN_ACCESS_LIST_XOP_FORMAT
	  %3d   %s  %s
CHAN_ACCESS_LIST_AXS_FORMAT
	  %3d  %4d  %s
	
# AKICK vlaszok
CHAN_ACCESS_CLEAR
	Channel %s access list has been cleared.

# AKICK responses
CHAN_AKICK_SYNTAX
	AKICK #szoba {ADD | STICK | UNSTICK | DEL | LIST | VIEW | ENFORCE | CLEAR}[ nick-maszk ] [ indok ]
CHAN_AKICK_DISABLED
	Csatorna autokick listjnak mdostsa sznetel.
CHAN_AKICK_ALREADY_EXISTS
	%s mr szerepel a (%s) csatorna autokick listjn.
CHAN_AKICK_REACHED_LIMIT
	%d bejegyzsnl nem lehet tbb a listn.
CHAN_AKICK_ADDED
	%s hozzadva a (%s) csatorna autokick listjhoz
CHAN_AKICK_NO_SUCH_ENTRY
	A bejegyzs (#%d) nincs a (%s) csatorna autokick listjn.
CHAN_AKICK_NOT_FOUND
	%s nem szerepel a (%s) csatorna autokick listjn.
CHAN_AKICK_NO_MATCH
	Nincs ilyen bejegyzs a (%s) csatorna autokick listjn.
CHAN_AKICK_STUCK
	%s most mr mindig aktv a (%s) csatornn.
CHAN_AKICK_UNSTUCK
	%s tbb mr nem aktv a (%s) csatornn.
CHAN_AKICK_DELETED
	%s trlve a (%s) csatorna autokick listjrl.
CHAN_AKICK_DELETED_ONE
	1 bejegyzs trlve a (%s) csatorna autokick listjrl.
CHAN_AKICK_DELETED_SEVERAL
	%d bejegyzs trlve a (%s) csatorna autokick listjrl.
CHAN_AKICK_LIST_EMPTY
	%s autokick listja res.
CHAN_AKICK_LIST_HEADER
	%s autokick listja:
CHAN_AKICK_LIST_FORMAT
	  %3d %s (%s)
CHAN_AKICK_VIEW_FORMAT
	%3d %s (%s ltal, ekkor: %s)
	    %s
CHAN_AKICK_VIEW_FORMAT_STUCK
	%3d %s (stuck) (%s ltal, ekkor: %s)
	    %s
CHAN_AKICK_ENFORCE_DONE
	Az AKICK ENFORCE a(z) %s csatornn teljestve;
	%d user eltvoltva.

# LEVELS vlaszok
CHAN_AKICK_CLEAR
	Channel %s akick list has been cleared.

# LEVELS responses
CHAN_LEVELS_SYNTAX
	LEVELS #szoba{SET | DIS[ABLE] | LIST | RESET }[ opci [szint]]
CHAN_LEVELS_XOP
	Ez a parancs hasznlhatatlan ebben a mdban. (xOP)
CHAN_LEVELS_RANGE
	A szintnek kizrlag %d s %d kztt kell lennie.
CHAN_LEVELS_CHANGED
	%s szintjnek j rtke a (%s) csatornn: %d.
CHAN_LEVELS_UNKNOWN
	%s bellts nem ismert. rd be %R%s HELP LEVELS DESC
	az rvnyes belltsok listjnak megtekintshez.  
CHAN_LEVELS_DISABLED
	%s letiltva a (%s) csatornn.
CHAN_LEVELS_LIST_HEADER
	%s hozzfrsi szintjeinek belltsai:
CHAN_LEVELS_LIST_DISABLED
	    %-*s  (letiltva)
CHAN_LEVELS_LIST_FOUNDER
	    %-*s  (csak foundernek)
CHAN_LEVELS_LIST_NORMAL
	    %-*s  %d
CHAN_LEVELS_RESET
	%s szintjei visszalltva az alaprtkekre.

# Status Messages
CHAN_STATUS_SYNTAX
	STATUS ERROR Syntax error
CHAN_STATUS_NOT_REGGED
	STATUS ERROR Channel %s not registered
CHAN_STATUS_FORBIDDEN
	STATUS ERROR Channel %s forbidden
CHAN_STATUS_NOTONLINE
	STATUS ERROR Nick %s not online
CHAN_STATUS_INFO
	STATUS %s %s %d

# INFO vlaszok
CHAN_INFO_SYNTAX
	INFO #szoba [ALL]
CHAN_INFO_HEADER
	%s informcii:
CHAN_INFO_FOUNDER
	    Tulajdonos: %s (%s)
CHAN_INFO_NO_FOUNDER
	    Tulajdonos: %s
CHAN_INFO_SUCCESSOR
	    Jogutd: %s (%s)
CHAN_INFO_NO_SUCCESSOR
	    Jogutd: %s
CHAN_INFO_DESCRIPTION
	    Lers: %s
CHAN_INFO_ENTRYMSG
	    Ksznt zenet: %s
CHAN_INFO_TIME_REGGED
	    Regisztrls ideje: %s
CHAN_INFO_LAST_USED
	    Utoljra hasznlva: %s
CHAN_INFO_LAST_TOPIC
	    Utols topic: %s
CHAN_INFO_TOPIC_SET_BY
	    A tmt belltotta: %s
CHAN_INFO_URL
	    URL: %s
CHAN_INFO_EMAIL
	    E-mail cm: %s
CHAN_INFO_BANTYPE
	    Ban tpus: %d
CHAN_INFO_OPTIONS
	    Opcik: %s
CHAN_INFO_OPT_KEEPTOPIC
	Tmamegrzs
CHAN_INFO_OPT_OPNOTICE
	Opok rtestse
CHAN_INFO_OPT_PEACE
	Bkessg
CHAN_INFO_OPT_PRIVATE
	Privt
CHAN_INFO_OPT_RESTRICTED
	Korltozott hozzfrs
CHAN_INFO_OPT_SECURE
	Secure
CHAN_INFO_OPT_SECUREOPS
	Opjog vdelme
CHAN_INFO_OPT_SECUREFOUNDER
	Founderjog vdelme
CHAN_INFO_OPT_SIGNKICK
	Signed kicks
CHAN_INFO_OPT_TOPICLOCK
	Tmavlts lezrsa
CHAN_INFO_OPT_XOP
	xOP lista rendszer
CHAN_INFO_OPT_NONE
	Nincs
CHAN_INFO_MODE_LOCK
		Rgztett mdok: %s
CHAN_INFO_EXPIRE
	      Expires in: %s
CHAN_INFO_NO_EXPIRE
	Ez a csatorna nem fog elvlni.

# LIST vlaszok
CHAN_LIST_SYNTAX
	LIST pattern
CHAN_LIST_SERVADMIN_SYNTAX
	LIST pattern [FORBIDDEN] [SUSPENDED] [NOEXPIRE]
CHAN_LIST_HEADER
	%s listjnak egyez bejegyzsei
CHAN_LIST_FORMAT
		%-20s  %s
CHAN_LIST_END
	Lista vge - %d/%d tallat megjelentve.

# INVITE vlaszok
CHAN_INVITE_SYNTAX
	INVITE #szoba

# UNBAN vlaszok
CHAN_UNBAN_SYNTAX
	UNBAN #szoba
CHAN_UNBANNED
	%s csatornn a tiltst levetetted magadrl.

# TOPIC vlaszok
CHAN_TOPIC_SYNTAX
	TOPIC #szoba [topic]

# CLEAR vlaszok
CHAN_CLEAR_SYNTAX
	CLEAR #szoba mit?
CHAN_CLEARED_BANS
	A (%s) csatornrl minden kitilts levve.
CHAN_CLEARED_EXCEPTS
	A (%s) csatornrl minden kivtel levve.
CHAN_CLEARED_MODES
	A (%s) csatornrl minden md el levve.
CHAN_CLEARED_OPS
	A (%s) csatornn minden +o md levve.
CHAN_CLEARED_HOPS
	A (%s) csatornn minden +h md levve.
CHAN_CLEARED_VOICES
	A (%s) csatornn minden +v md levve.
CHAN_CLEARED_USERS
	A (%s) csatornrl minden felhasznl ki lett rgva.
CHAN_CLEARED_INVITES
	All invites on channel %s have been removed.

# GETPASS vlaszok
CHAN_GETPASS_SYNTAX
	GETPASS #szoba
CHAN_GETPASS_UNAVAILABLE
	GETPASS elrhetetlen, mig az encryption hasznlatban van.
CHAN_GETPASS_PASSWORD_IS
	A (%s) csatorna  jelszava: %s.

# SENDPASS vlaszok
CHAN_GETKEY_SYNTAX
	GETKEY channel
CHAN_GETKEY_NOKEY
	The channel %s has no key.
CHAN_GETKEY_KEY
	Key for channel %s is %s.

# SENDPASS responses
CHAN_SENDPASS_SYNTAX
	SENDPASS #szoba
CHAN_SENDPASS_UNAVAILABLE
	SENDPASS elrhetetlen, amg az encryption hasznlatban van
CHAN_SENDPASS_SUBJECT
	Csatorna jelszava: (%s)
CHAN_SENDPASS_HEAD
	Hi,
CHAN_SENDPASS_LINE_1
	Krted a szoba jelszavnak megkldst %s cmre.
CHAN_SENDPASS_LINE_2
	%s a szobajesz.Biztonsg kedvrt vltztasd meg olvass utn
CHAN_SENDPASS_LINE_3
	Ha nem te krted a levelet akkor trld s feljts el
CHAN_SENDPASS_LINE_4
	KRLEN NE VLASZOLJ A LEVLRE!
CHAN_SENDPASS_LINE_5
	%s administrators.
CHAN_SENDPASS_OK
	Jelsz %s elkldve.
	
# FORBID vlaszok
CHAN_FORBID_SYNTAX
	FORBID #szoba [indok]
CHAN_FORBID_SYNTAX_REASON
	FORBID #szoba indok
CHAN_FORBID_SUCCEEDED
	A (%s) szoba letiltva.
CHAN_FORBID_FAILED
	%s szobt nem sikerlt letiltani!
CHAN_FORBID_REASON
	Ez a szoba forbidolva lett.
	
# SUSPEND vlaszok
CHAN_SUSPEND_SYNTAX
	SUSPEND #szoba [indok]
CHAN_SUSPEND_SYNTAX_REASON
	SUSPEND #szoba indok
CHAN_SUSPEND_SUCCEEDED
	(%s) szoba hasznlata felfggesztve.
CHAN_SUSPEND_FAILED
	%s szobt nem sikerlt felfggeszteni!
CHAN_SUSPEND_REASON
	A szoba hasznlata felfggesztve.

# UNSUSPEND vlaszok
CHAN_UNSUSPEND_SYNTAX
	UNSUSPEND #szoba
CHAN_UNSUSPEND_ERROR
	Nincs # a szoba neve eltt.
CHAN_UNSUSPEND_SUCCEEDED
	(%s) szoba jra hasznlhat.
CHAN_UNSUSPEND_FAILED
	%s szobt nem sikerlt hasznlhatv tenni!

# Misc vlaszok
CHAN_EXCEPTED
	%s megegyezik egy kivtellel (%s) nem tilthat, amg a kivtel l.

###########################################################
#
# MemoServ zenetek
#
###########################################################
	
# Automatikus zenetek
MEMO_HAVE_NEW_MEMO
	Van egy j zeneted.
MEMO_HAVE_NEW_MEMOS
	%d darab j zeneted van.
MEMO_TYPE_READ_LAST
	Hasznld a %R%s READ LAST parancsot.
MEMO_TYPE_READ_NUM
	Hasznld a %R%s READ %d parancsot.
MEMO_TYPE_LIST_NEW
	Hasznld a: %R%s LIST NEW parancsot
MEMO_AT_LIMIT
	Figyelem: Fogadhat zenetek maximlis szma (%d).
	Nem fogadhatsz tbb zenetet, amg nem trlsz nhnyat.
MEMO_OVER_LIMIT
	Figyelem: Fogadhat zenetek maximlis szmt (%d).
	Nem fogadhatsz tbb zenetet, amg trlsz nhnyat.
MEMO_X_MANY_NOTICE
	sszesen %d zenet van a %s csatornn.
MEMO_X_ONE_NOTICE
	%d zenete van a %s szobnak.
MEMO_NEW_X_MEMO_ARRIVED
	j zenete rkezett a %s szobnak.
	Ha szeretnd elolvasni, rd be: %R%s READ %s %d.
MEMO_NEW_MEMO_ARRIVED
	%s kldtt egy j zenetet.
	Ha szeretnd elolvasni, rd be: %R%s READ %d.

# Multi-use vlaszok
MEMO_HAVE_NO_MEMOS
	Nincs zeneted.
MEMO_X_HAS_NO_MEMOS
	%s zenetlistja res.
MEMO_DOES_NOT_EXIST
	A (%d.) szm zenet nem szerepel az zenetlistn!
MEMO_LIST_NOT_FOUND
	A megadott zenetek nem szerepelnek az zenetlistn.

# SEND vlaszok
MEMO_SEND_SYNTAX
	SEND {nick | #szoba} memo-szveg
MEMO_SEND_DISABLED
	Sajnlom, az zenetklds sznetel.
MEMO_SEND_PLEASE_WAIT
	Krlek, vrj %d msodpercet mieltt SEND parancsot jra hasznlod!
MEMO_X_GETS_NO_MEMOS
	%s nem fogadhat zeneteket.
MEMO_X_HAS_TOO_MANY_MEMOS
	%s tl sok zenettel rendelkezik, s nem fogadhat tbbet.
MEMO_SENT
	zenet elkldve %s rszre.
MEMO_MASS_SENT
	Egy massmemo elkldve minden regisztrlt felhasznlnak.

# CANCEL vlaszok
MEMO_CANCEL_SYNTAX
	CANCEL {nick | #szoba}
MEMO_CANCEL_DISABLED
	Sajnlom, a memo visszavons jelenleg sznetel.
MEMO_CANCEL_NONE
	Nincs visszavont memo zenet.
MEMO_CANCELLED
	%s rszre kldtt utols memo zenet visszavonva.

# LIST vlaszok
MEMO_LIST_SYNTAX
	LIST [#szoba] [list | NEW ]
MEMO_HAVE_NO_NEW_MEMOS
	Nem kaptl j zenetet.
MEMO_X_HAS_NO_NEW_MEMOS
	%s nem kapott j zenetet.
MEMO_LIST_MEMOS
	%s zenetei. Olvasshoz rd be: %R%s READ szm
MEMO_LIST_NEW_MEMOS
	j zenet %s rszre. Olvasshoz: %R%s READ szm
MEMO_LIST_CHAN_MEMOS
	%s zenetei.  Olvasshoz : %R%s READ %s szm
MEMO_LIST_CHAN_NEW_MEMOS
	%s j zenetei.  Olvasshoz,: %R%s READ %s szm
MEMO_LIST_HEADER
	 Sorszm  Kld            Dtum/Id
MEMO_LIST_FORMAT
	%c %3d  %-16s  %s

# READ vlaszok
MEMO_READ_SYNTAX
	READ [#szoba] {list | LAST | NEW }
MEMO_HEADER
	zenet szm: %d; felad: %s (%s). Trlshez: %R%s DEL %d
MEMO_CHAN_HEADER
	zenet szm: %d; felad.: %s (%s). Trlshez: %R%s DEL %s %d
MEMO_TEXT
	%s

# DEL vlaszok
MEMO_DEL_SYNTAX
	DEL [#szoba] { szm | list | ALL}
MEMO_DELETED_NONE
	Nem trltem egy zenetet sem.
MEMO_DELETED_ONE
	A megadott zenetet (%d) trltem.
MEMO_DELETED_SEVERAL
	A megadott zeneteket %s trltem.
MEMO_DELETED_ALL
	Minden zenetet trltem.
MEMO_CHAN_DELETED_ALL
	Minden zenetet trltem a %s csatornn.

# SET vlaszok
MEMO_SET_SYNTAX
	SET opci paramterek
MEMO_SET_DISABLED
	zenet opciinak belltsa sznetel.
MEMO_SET_UNKNOWN_OPTION
	Ismeretlen SET opci: %s

# SET NOTIFY vlaszok
MEMO_SET_NOTIFY_SYNTAX
	SET NOTIFY {ON | LOGON | NEW | OFF}
MEMO_SET_NOTIFY_ON
	%s rtesteni fog az zenetekrl csatlakozskor.
MEMO_SET_NOTIFY_LOGON
	%s rtest az zenetekrl csatlakozskor/AWAY OFF-kor.
MEMO_SET_NOTIFY_NEW
	%s mostmr rtesteni fog, ha j zeneted rkezik.
MEMO_SET_NOTIFY_OFF
	%s mostmr nem fog rtestteni, ha j zeneted rkezik.
MEMO_SET_NOTIFY_MAIL
	Az j memo zeneteidrl emailben kapsz rtestst.
MEMO_SET_NOTIFY_NOMAIL
	Mr nem kapsz rtestst emailben.
MEMO_SET_NOTIFY_INVALIDMAIL
	Nincs belltva email cm a nevedhez.


# SET LIMIT vlaszok
MEMO_SET_LIMIT_SYNTAX
	SET LIMIT [#szoba] limit
MEMO_SET_LIMIT_SERVADMIN_SYNTAX
	SET LIMIT [user | #szoba] {limit | NONE} [HARD]
MEMO_SET_YOUR_LIMIT_FORBIDDEN
	Nem vltoztathatod meg a max. fogadhat zenetek szmt.
MEMO_SET_LIMIT_FORBIDDEN
	Nem vltoztathatod meg %s zeneteinek szmt.
MEMO_SET_YOUR_LIMIT_TOO_HIGH
	A max. bejv zenetek szma nem lehet tbb, mint %d.
MEMO_SET_LIMIT_TOO_HIGH
	%s max. bejv zenetek szma nem lehet tbb, mint %d.
MEMO_SET_LIMIT_OVERFLOW
	Tl nagy rtk a max.bejv zenetnek,%d az j rtke.
MEMO_SET_YOUR_LIMIT
	A max. bejv zenetek szmanak j rtke: %d.
MEMO_SET_YOUR_LIMIT_ZERO
	Ezentl nem tudsz zeneteket fogadni.
MEMO_UNSET_YOUR_LIMIT
	Ezentl korltlan szm zenetet fogadhatsz.
MEMO_SET_LIMIT
	%s maximlisan fogadhat zeneteinek szma: %d.
MEMO_SET_LIMIT_ZERO
	%s ezentl nem fogadhat zeneteket.
MEMO_UNSET_LIMIT
	%s ezentl korltlan szm zenetet fogadhat.


# INFO vlaszok
MEMO_INFO_SYNTAX
	INFO [#szoba]
MEMO_INFO_SERVADMIN_SYNTAX
	INFO [nick | #szoba]
MEMO_INFO_NO_MEMOS
	Jelenleg nincs zeneted.
MEMO_INFO_MEMO
	Van 1 zeneted.
MEMO_INFO_MEMO_UNREAD
	Van 1 olvasatlan zeneted.
MEMO_INFO_MEMOS
	Van %d zeneted.
MEMO_INFO_MEMOS_ONE_UNREAD
	Van %d zeneted, ebbl 1 olvasatlan.
MEMO_INFO_MEMOS_SOME_UNREAD
	Van %d zeneted, ebbl %d olvasatlan.
MEMO_INFO_MEMOS_ALL_UNREAD
	Van %d zeneted; s mind olvasatlan.
MEMO_INFO_LIMIT
	A maximlisan fogadhat zentek szma:  %d.
MEMO_INFO_HARD_LIMIT
	A max. bejv zentek szma: %d,ez fix rtk.
MEMO_INFO_LIMIT_ZERO
	A max. bejv zentek szma: 0; s tbb nem jhet.
MEMO_INFO_HARD_LIMIT_ZERO
	A max. bejv zentek szma: 0; s nem khet tbb. 
	Ez nem vltoztathat meg.
MEMO_INFO_NO_LIMIT
	Korltlan szm zenetet fogadhatsz.
MEMO_INFO_NOTIFY_OFF
	Nem kapsz rtestst az j zeneteidrl.
MEMO_INFO_NOTIFY_ON
	rtestst kapsz j zenetek rkezsrl csatlakozskor.
MEMO_INFO_NOTIFY_RECEIVE
	rtestst kapsz j zenetek rkezsekor.
MEMO_INFO_NOTIFY_SIGNON
	rtestst kapsz az j zeneteidrl,ha fellpsz az IRC-re.
MEMO_INFO_X_NO_MEMOS
	%s zenetlistja res.
MEMO_INFO_X_MEMO
	%s listjn van 1 zenet.
MEMO_INFO_X_MEMO_UNREAD
	%s listjn van 1 olvasatlan zenet.
MEMO_INFO_X_MEMOS
	%s szmra %d zenet rkezett.
MEMO_INFO_X_MEMOS_ONE_UNREAD
	%s szmra %d zenet rkezett, ebbl 1 olvasatlan.
MEMO_INFO_X_MEMOS_SOME_UNREAD
	%s szmra %d zenet rkezett, ebbl %d olvasatlan.
MEMO_INFO_X_MEMOS_ALL_UNREAD
	%s szmra %d zenet rkezett, s mind olvasatlan.
MEMO_INFO_X_LIMIT
	%s maximlisan fogadhat zeneteinek szma: %d.
MEMO_INFO_X_HARD_LIMIT
	%s max. fogadhat zenteinek szma: %d, s ez fix rtk.
MEMO_INFO_X_NO_LIMIT
	%s korltlan szm zenetet fogadhat.
MEMO_INFO_X_NOTIFY_OFF
	%s nem krt rtestst az zeneteirl.
MEMO_INFO_X_NOTIFY_ON
	%s rtestst krt csatlakozskor,s ha j zenete van,
MEMO_INFO_X_NOTIFY_RECEIVE
	%s rtestst krt, ha j zenete rkezik.
MEMO_INFO_X_NOTIFY_SIGNON
	%s krte, csatlakozskor rtestst kapjon,zeneteirl.

# Memo2Mail vlaszok
MEMO_MAIL_SUBJECT
	j memo
MEMO_MAIL_TEXT1
	Hi %s
MEMO_MAIL_TEXT2
	Kaptl egy j memo zenetet %s nicktl. Ez a memo a %d sorszm.
MEMO_MAIL_TEXT3
	Memo Szveg:

# RSEND vlaszok
MEMO_RSEND_PLEASE_WAIT
	Krlek vrj %d msodpercet mieltt jra hasznlod az RSEND parancsot.
MEMO_RSEND_DISABLED
	Sajnlom, az RSEND hasznlata le van tiltva ezen a hlzaton.
MEMO_RSEND_SYNTAX
	RSEND {nick | #szoba} memo-szveg
MEMO_RSEND_NICK_MEMO_TEXT
	[auto-memo] A memo, amit kldtl meg lett tekintve.
MEMO_RSEND_CHAN_MEMO_TEXT
	[auto-memo] A memo, amit %s szmra kldtl meg lett tekintve.
MEMO_RSEND_USER_NOTIFICATION
	Az rtest zenet %s rszre el lett kldve, informlva
	t arrl, hogy elolvastad a memojt.

# CHECK vlaszok
MEMO_CHECK_SYNTAX
	CHECK nicknv 
MEMO_CHECK_NOT_READ
	Az utols memo, amit %s rszre (%s idpontban) kldtl mg olvasatlan.
MEMO_CHECK_READ
	Az utols memo, amit %s rszre (%s idpontban) kldtl mr olvasott.
MEMO_CHECK_NO_MEMO
	%s nickre nem rkezett memo zenet tled.

	
###########################################################
#
# BotServ zenetek
#
###########################################################
	
# Standard vlaszok
MEMO_NO_RSEND_SELF
	You can not request a receipt when sending a memo to yourself.

###########################################################################
#
# BotServ messages
#
###########################################################################
	
# Standard responses
BOT_DOES_NOT_EXIST
	%s nev bot nem ltezik.
BOT_NOT_ASSIGNED
	Trstanod kellene egy botot a csatornra mieltt hasznlod
	ezt a parancsot, rd be %R%S HELP ASSIGN bvebb infkrt.
BOT_NOT_ON_CHANNEL
	A Bot nincs a %s csatornn.

# Kick vlaszok (kell egy sor)
BOT_REASON_BADWORD
	Nem hasznlhat ez a sz: %s!
BOT_REASON_BADWORD_GENTLE
	Figyelj a stlusra kiskomm!
BOT_REASON_BOLD
	Nem hasznlhat kiemelt bet ezen a csatornn!
BOT_REASON_CAPS
	Kapcsold ki a caps lockod!
BOT_REASON_COLOR
	Nem szinezhetsz ezen a csatornn!
BOT_REASON_FLOOD
	Ne floodolj!
BOT_REASON_REPEAT
	Ne ismteld magad!
BOT_REASON_REVERSE
	Nem rj visszafel ezen a csatornn!
BOT_REASON_UNDERLINE
	Nem hasznlj alhzsokat ezen a csatornn!

# !seen vlaszok
BOT_SEEN_BOT
	Megtalltl, %s!
BOT_SEEN_YOU
	Magadat krdezed le %s, eh?
BOT_SEEN_ON_CHANNEL
	%s a szobban van!
BOT_SEEN_ON_CHANNEL_AS
	%s a szobban van (%s nven) ! 
BOT_SEEN_ON
	%s utoljra %s ideje jrt erre.
BOT_SEEN_NEVER
	Sosem lttam %s nicket ebben a szobban.
BOT_SEEN_UNKNOWN
	n nem tudom, hogy %s kicsoda.:-(((

# BOT vlaszok
BOT_BOT_SYNTAX
	BOT ADD nick user hoszt valsnv
	BOT CHANGE rginickjnick [user [hoszt [valsnv]]]
	BOT DEL nick
BOT_BOT_ALREADY_EXISTS
	%s nev bot mr ltezik.
BOT_BOT_CREATION_FAILED
	A bot ltrehozsa sikertelen.
BOT_BOT_READONLY
	A bot mdosts ideiglenesen sznetel.
BOT_BOT_ADDED
	%s!%s@%s (%s) hozzadva a bot listhoz.
BOT_BOT_ANY_CHANGES
	A rgi info megegyezik az jjal.
BOT_BOT_CHANGED
	A %s nev bot megvltoztatva %s!%s@%s (%s)
BOT_BOT_DELETED
	A %s nev bot trlve.

# BOTLIST vlaszok
BOT_BOTLIST_HEADER
	Botok listja:
BOT_BOTLIST_PRIVATE_HEADER
	Botok melyeket csak IRC opertorok trsthatnak:
BOT_BOTLIST_FOOTER
	%d botok rendelkezsre llnak.
BOT_BOTLIST_EMPTY
	Nem ll rendelkezsre bot.
	Krj meg egy szervz admint, hogy csinljon!

# ASSIGN vlaszok
BOT_ASSIGN_SYNTAX
	ASSIGN #szoba nick
BOT_ASSIGN_READONLY
	Bot trsts ideiglenesen nem mkdik.
BOT_ASSIGN_ALREADY
	A %s nev bot mr trstva van a %s szobhoz.
BOT_ASSIGN_ASSIGNED
	A %s nev bot trstva a %s szobhoz.
	
# UNASSIGN vlaszok
BOT_UNASSIGN_SYNTAX
	UNASSIGN #szoba
BOT_UNASSIGN_UNASSIGNED
	Nincsen bot kijellve %s szobban tbbet.

# INFO vlaszok
BOT_INFO_SYNTAX
	INFO {#szoba | nick}
BOT_INFO_NOT_FOUND
	%s nem rvnyes bot vagy regisztrlt szoba.
BOT_INFO_BOT_HEADER
	Informcik a %s nev botrl:
BOT_INFO_BOT_MASK
	Maszk : %s@%s
BOT_INFO_BOT_REALNAME
	Valdi neve: %s
BOT_INFO_BOT_CREATED
	Szletett: %s
BOT_INFO_BOT_USAGE
	Hasznlva: %d szobban
BOT_INFO_BOT_OPTIONS
	Belltsai: %s
BOT_INFO_OPT_PRIVATE
	Privt
BOT_INFO_CHAN_HEADER
	Informci a %s szobrl:
BOT_INFO_CHAN_BOT
	Bot nv: %s
BOT_INFO_CHAN_BOT_NONE
	Bot nv: nincs trstva mg.
BOT_INFO_CHAN_KICK_BADWORDS
		Csnya szavakrt kirgs: %s
BOT_INFO_CHAN_KICK_BADWORDS_BAN
		Csnya szavakrt kirgs: %s (%d kirgs utn kitilts)
BOT_INFO_CHAN_KICK_BOLDS
		Flkvr betkrt kirgs: %s
BOT_INFO_CHAN_KICK_BOLDS_BAN
		Flkvr betkrt kirgs: %s (%d kirgs utn kitilts)
BOT_INFO_CHAN_KICK_CAPS_ON
		Caps Lockrt kirgs: %s (minimum %d/%d%%)
BOT_INFO_CHAN_KICK_CAPS_BAN
		Caps Lockrt kirgs: %s (%d kirgs utn kitilts; min. %d/%d%%)
BOT_INFO_CHAN_KICK_CAPS_OFF
		Caps Lockrt kirgs : %s
BOT_INFO_CHAN_KICK_COLORS
		Szinezsrt kirgs: %s
BOT_INFO_CHAN_KICK_COLORS_BAN
		Szinezsrt kirgs: %s (%d kirgs utn kitilts)
BOT_INFO_CHAN_KICK_FLOOD_ON
		Floodrt kirgs: %s (%d sor %ds mp alatt)
BOT_INFO_CHAN_KICK_FLOOD_BAN
		Floodrt kirgs: %s (%d kirgs utn kitilts; %d sor %ds mp alatt)
BOT_INFO_CHAN_KICK_FLOOD_OFF
		Floodrt kirgs: %s
BOT_INFO_CHAN_KICK_REPEAT_ON
		Ismtlsrt kirgs : %s (%d alkalommal)
BOT_INFO_CHAN_KICK_REPEAT_BAN
		Ismtlsrt kirgs: %s (%d kirgs utn kitilts; %d idre)
BOT_INFO_CHAN_KICK_REPEAT_OFF
		Ismtlsrt kirgs: %s
BOT_INFO_CHAN_KICK_REVERSES
		Visszafel rsrt kirgs: %s
BOT_INFO_CHAN_KICK_REVERSES_BAN
		Visszafel rsrt kirgs: %s (%d kirgs utn kitilts)
BOT_INFO_CHAN_KICK_UNDERLINES
		Alhzsrt kirgs: %s
BOT_INFO_CHAN_KICK_UNDERLINES_BAN
		Alhzsrt kirgs: %s (%d kirgs utn kitilts)
BOT_INFO_ACTIVE
	engedlyezve
BOT_INFO_INACTIVE
	letiltva
BOT_INFO_CHAN_OPTIONS
		Belltsok: %s
BOT_INFO_OPT_DONTKICKOPS
	Opok vdelme
BOT_INFO_OPT_DONTKICKVOICES
	Voices vdelme
BOT_INFO_OPT_FANTASY
	Fantasy
BOT_INFO_OPT_GREET
	dvzls
BOT_INFO_OPT_NOBOT
	Nincs bot
BOT_INFO_OPT_SYMBIOSIS
	Egyttls
BOT_INFO_OPT_NONE
	Nincsen

# SET vlaszok
BOT_SET_SYNTAX
	SET #szoba opci belltsok
BOT_SET_DISABLED
	Bot bellts idlegesen sznetel.
BOT_SET_UNKNOWN
	Ismeretlen opci: %s.
	Hasznld %R%S HELP SET informcirt.

# SET DONTKICKOPS zenetek
BOT_SET_DONTKICKOPS_SYNTAX
	SET #szoba DONTKICKOPS {ON|OFF}
BOT_SET_DONTKICKOPS_ON
	A Bot nem fog opot kirgni a %s szobbl.
BOT_SET_DONTKICKOPS_OFF
	A Bot most mr opot is kirg a %s szobbl.

# SET DONTKICKVOICES zenetek
BOT_SET_DONTKICKVOICES_SYNTAX
	SET #szoba DONTKICKVOICES {ON|OFF}
BOT_SET_DONTKICKVOICES_ON
	A Bot nem fogja a hangadkat kirgni a %s szobban.
BOT_SET_DONTKICKVOICES_OFF
	A Bot most mr a hangadkat is kirgja a %s szobban.

# SET FANTASY zenetek
BOT_SET_FANTASY_SYNTAX
	SET #szoba FANTASY {ON|OFF}
BOT_SET_FANTASY_ON
	Fantasy md most ON a %s csatornn.
BOT_SET_FANTASY_OFF
	Fantasy md most OFF a %s csatornn.

# SET GREET zenetek
BOT_SET_GREET_SYNTAX
	SET szoba GREET {ON|OFF}
BOT_SET_GREET_ON
	dvzl md most ON a %s szobn.
BOT_SET_GREET_OFF
	dvzl md most OFF a %s szobn.

# SET NOBOT
BOT_SET_NOBOT_SYNTAX
	SET botname NOBOT {ON|OFF}
BOT_SET_NOBOT_ON
	Nincs Bot md most ONa %s szobn.
BOT_SET_NOBOT_OFF
	Nincs Bot md most OFFa %s szobn.

# SET PRIVATE
BOT_SET_PRIVATE_SYNTAX
	SET botnv PRIVATE {ON|OFF}
BOT_SET_PRIVATE_ON
	Private md a %s botban most ON.
BOT_SET_PRIVATE_OFF
	Private md a %s botban most OFF.

# SET SYMBIOSIS
BOT_SET_SYMBIOSIS_SYNTAX
	SET szoba SYMBIOSIS {ON|OFF}
BOT_SET_SYMBIOSIS_ON
	Egyttls md most ONa %s szobn.
BOT_SET_SYMBIOSIS_OFF
	Egyttls md most OFFa %s szobn.

# KICK vlaszok
BOT_KICK_SYNTAX
	KICK #szoba opci {ON|OFF} [belltsok]
BOT_KICK_DISABLED
	Kirgs hasznlata ideiglenesen letiltva.
BOT_KICK_UNKNOWN
	Ismeretlen opci: %s.
	Tovbbi informcirt rd be: %R%S HELP KICK 
BOT_KICK_BAD_TTB
	%s nem fogadhat el banolsi idnek.

BOT_KICK_BADWORDS_ON
	Bot kirgja tiltott sz hasznlatrt. Hasznld a BADWORDS
	parancsot hogy hozzadj vagy trlj tiltott szavakat a listbl.
BOT_KICK_BADWORDS_ON_BAN
	Bot kirgja tiltott sz hasznlatrt, s kitiltja 
	%d kirgs utn a usert. Hasznld a BADWORDS parancsot
	hogy hozzadj vagy trlj tiltott szavakat a listbl.
BOT_KICK_BADWORDS_OFF
	A Bot most mr nem fog kirgni tiltott sz miatt.
BOT_KICK_BOLDS_ON
	A Bot kirgja flkvr bet hasznlat miatt a usert.
BOT_KICK_BOLDS_ON_BAN
	A Bot kirgja flkvr bet hasznlat miatt, s 
	kitiltja %d kirgs utn a usert.
BOT_KICK_BOLDS_OFF
	A Bot nem fog kirgni flkvr bet hasznlat miatt.
BOT_KICK_CAPS_ON
	Bot most mr kirgja caps lock miatt a usert (legalbb
	%d karakter s ennek %d%%-a nagybet).
BOT_KICK_CAPS_ON_BAN
	Bot most mr kirgja caps lock miatt, (legalbb
	%d karakter s ennek %d%%-a nagybet), kitiltja 
	%d kirgs utn a usert.
BOT_KICK_CAPS_OFF
	Bot nem fog kirgni caps lock miatt.
BOT_KICK_COLORS_ON
	A Bot kirgja szines rs miatt a usert.
BOT_KICK_COLORS_ON_BAN
	A Bot kirgja szines rs miatt, s kitiltja 
	%d kirgs utn a usert.
BOT_KICK_COLORS_OFF
	Bot nem fog kirgni szines rs miatt.
BOT_KICK_FLOOD_ON
	Bot kirgja flood miatt a usert. (%d sor %d mp alatt)
BOT_KICK_FLOOD_ON_BAN
	A Bot kirgja flood miatt (%d sor %d mp alatt),
	s kitiltja %d kirgs utn a usert.
BOT_KICK_FLOOD_OFF
	A Bot nem fog kirgni flood miatt.
BOT_KICK_REPEAT_ON
	A Bot kirgja ismtls miatt a usert (ha %d alkalommal
	ismtli ugyanazt a sort).
BOT_KICK_REPEAT_ON_BAN
	A Bot kirgja ismtls miatt (ha %d alkalommal ismtli
	ugyanazt a sort), s kitiltja %d kirgs utn a usert.
BOT_KICK_REPEAT_OFF
	A Bot nem fog kirgni ismtls miatt.
BOT_KICK_REVERSES_ON
	A Bot kirg fordtott rs miatt.
BOT_KICK_REVERSES_ON_BAN
	A Bot kirgja fordtott rs miatt, s kitiltja %d
	kirgs utn a usert.
BOT_KICK_REVERSES_OFF
	A Bot nem fog rgni fordtott rs miatt.
BOT_KICK_UNDERLINES_ON
	A Bot kirgja alhzsos rs miatt a usert.
BOT_KICK_UNDERLINES_ON_BAN
	A Bot kirgja alhzsos rs miatt, s kitiltja
	%d kirgs utn a usert.
BOT_KICK_UNDERLINES_OFF
	Bot nem fog kirgni alhzsos rs miatt.

# BADWORDS zenetek
BOT_BADWORDS_SYNTAX
	BADWORDS #szoba{ADD|DEL|LIST|CLEAR}[sz|sorszm]
	[SINGLE|START|END]
BOT_BADWORDS_DISABLED
	Csatornn tiltott szaval listjnak vltoztatsa letiltva.
BOT_BADWORDS_REACHED_LIMIT
	Csak %d tiltott sz lehet a csatornn.
BOT_BADWORDS_ALREADY_EXISTS
	A %s szt mr tartalmazza a %s tiltott szavak listja
BOT_BADWORDS_ADDED
	A %s sz hozzadva a %s tiltott szavak listjhoz.
BOT_BADWORDS_NO_SUCH_ENTRY
	Nincs (#%d) ilyen sz a %s tiltott szavak listjn.
BOT_BADWORDS_NOT_FOUND
	A %s sz nem tallhat a %s tiltott szavak listjn.
BOT_BADWORDS_NO_MATCH
	Nincs ilyen sz %s a tiltott szavak listjn.
BOT_BADWORDS_DELETED
	A %s sz trlve %s tiltott szavak listjbl.
BOT_BADWORDS_DELETED_ONE
	Trlve 1 bejegyzs %s tiltott szavak listjrl.
BOT_BADWORDS_DELETED_SEVERAL
	Trlve %d bejegyzs %s tiltott szavak listjrl.
BOT_BADWORDS_LIST_EMPTY
	%s tiltott szavak listja res.
BOT_BADWORDS_LIST_HEADER
	%s tiltott szavak listja:
	  Szm   sz                           tipus
BOT_BADWORDS_LIST_FORMAT
	  %3d   %-30s %s
BOT_BADWORDS_CLEAR
	Tiltott sz lista res.

# SAY vlaszok
BOT_SAY_SYNTAX
	SAY #szoba szveg

# ACT vlaszok
BOT_ACT_SYNTAX
	ACT #szoba szveg

# Hibk
BOT_EXCEPT
	Fehasznl trstsa szobval kivtel.
BOT_BAD_NICK
	Bot Nick csak rvnyes karaktereket tartalmazhat.
BOT_BAD_HOST
	Bot Hoszt csak rvnyes karaktereket tartalmazhat.
BOT_BAD_IDENT
	Bot Ident csak rvnyes karaktereket tartalmazhat.
BOT_LONG_IDENT
	Bot Idents may only contain 9 characters.
###########################################################
#
# OperServ zenetek
#
###########################################################
	
# ltalnos zenetek
OPER_BOUNCY_MODES
	Szervz nem tudja vltoztatni a mdokat.
	A szervereid jl vannak belltva?
OPER_BOUNCY_MODES_U_LINE
	Szervz nem tudja vltoztatni a mdokat.
	A szerverek U:lines bellitsa helyes?

# GLOBAL vlaszok
OPER_GLOBAL_SYNTAX
	GLOBAL zenet

# STATS vlaszok
OPER_STATS_UNKNOWN_OPTION
	Ismeretlen STATS opci: %s.
OPER_STATS_CURRENT_USERS
	Aktulis felhasznlk: %d (%d op)
OPER_STATS_MAX_USERS
	Legtbb felhasznl: %d (%s)
# This is ugly, but at least it's language-portable...
# Note that you can include seconds in any of these--my personal preference
# is to only give resolution to the nearest minute when uptime is one hour
# or more, but just add a %d to get seconds as well.
OPER_STATS_UPTIME_DHMS
	Szervz fent van %d nap, %02d:%02d
OPER_STATS_UPTIME_1DHMS
	Szervz fent van %d nap, %02d:%02d
OPER_STATS_UPTIME_HMS
	Szervz fent van %d ra, %d perce
OPER_STATS_UPTIME_HM1S
	Szervz fent van %d ra, %d perce
OPER_STATS_UPTIME_H1MS
	Szervz fent van %d ra, %d perce
OPER_STATS_UPTIME_H1M1S
	Szervz fent van %d ra, %d perce
OPER_STATS_UPTIME_1HMS
	Szervz fent van %d ra, %d perce
OPER_STATS_UPTIME_1HM1S
	Szervz fent van %d ra, %d perce
OPER_STATS_UPTIME_1H1MS
	Szervz fent van %d ra, %d perce
OPER_STATS_UPTIME_1H1M1S
	Szervz fent van %d ra, %d perce
OPER_STATS_UPTIME_MS
	Szervz fent van %d perc, %d msodperce.
OPER_STATS_UPTIME_M1S
	Szervz fent van %d perc, %d msodperce.
OPER_STATS_UPTIME_1MS
	Szervz fent van %d perc, %d msodperce.
OPER_STATS_UPTIME_1M1S
	Szervz fent van %d perc, %d msodperce.
OPER_STATS_BYTES_READ
	Olvasott Byteok : %5d kB
OPER_STATS_BYTES_WRITTEN
	rott Byteok : %5d kB
OPER_STATS_USER_MEM
	Felhasznl	 : %6d bejegyzs, %5d kB
OPER_STATS_CHANNEL_MEM
	Szoba	       : %6d bejegyzs, %5d kB
OPER_STATS_GROUPS_MEM
	NS Csoport	 : %6d bejegyzs, %5d kB
OPER_STATS_ALIASES_MEM
	NS Aliases	 : %6d bejegyzs, %5d kB
OPER_STATS_CHANSERV_MEM
	ChanServ	 : %6d bejegyzs, %5d kB
OPER_STATS_BOTSERV_MEM
	BotServ	 : %6d bejegyzs, %5d kB
OPER_STATS_OPERSERV_MEM
	OperServ	 : %6d bejegyzs, %5d kB
OPER_STATS_SESSIONS_MEM
	Session	 : %6d bejegyzs, %5d kB
OPER_STATS_AKILL_COUNT
	Aktulis AKILLek szma: %d
OPER_STATS_AKILL_EXPIRE_DAYS
	Alap AKILL lejrati id: %d nap
OPER_STATS_AKILL_EXPIRE_DAY
	Alap AKILL lejrati id: 1 nap
OPER_STATS_AKILL_EXPIRE_HOURS
	Alap AKILL lejrati id: %d ra
OPER_STATS_AKILL_EXPIRE_HOUR
	Alap AKILL lejrati id: 1 ra
OPER_STATS_AKILL_EXPIRE_MINS
	Alap AKILL lejrati id: %d perc
OPER_STATS_AKILL_EXPIRE_MIN
	Alap AKILL lejrati id: 1 perc
OPER_STATS_AKILL_EXPIRE_NONE
	Alap AKILL lejrati id: Nem elvl
OPER_STATS_SGLINE_COUNT
	Aktulis SGLINEok szma: %d
OPER_STATS_SGLINE_EXPIRE_DAYS
	Alap SGLINE lejrati id: %d nap
OPER_STATS_SGLINE_EXPIRE_DAY
	Alap SGLINE lejrati id: 1 nap
OPER_STATS_SGLINE_EXPIRE_HOURS
	Alap SGLINE lejrati id: %d ra
OPER_STATS_SGLINE_EXPIRE_HOUR
	Alap SGLINE lejrati id: 1 ra
OPER_STATS_SGLINE_EXPIRE_MINS
	Alap SGLINE lejrati id: %d perc
OPER_STATS_SGLINE_EXPIRE_MIN
	Alap SGLINE lejrati id: 1 perc
OPER_STATS_SGLINE_EXPIRE_NONE
	Alap SGLINE lejrati ido: Nem elvl
OPER_STATS_SQLINE_COUNT
	Aktulis SQLINEok szma : %d
OPER_STATS_SQLINE_EXPIRE_DAYS
	Alap SQLINE lejrati id: %d nap
OPER_STATS_SQLINE_EXPIRE_DAY
	Alap SQLINE lejrati id: 1 nap
OPER_STATS_SQLINE_EXPIRE_HOURS
	Alap SQLINE lejrati id: %d ra
OPER_STATS_SQLINE_EXPIRE_HOUR
	Alap SQLINE lejrati id: 1 ra
OPER_STATS_SQLINE_EXPIRE_MINS
	Alap SQLINE lejrati id: %d perc
OPER_STATS_SQLINE_EXPIRE_MIN
	Alap SQLINE lejrati id: 1 perc
OPER_STATS_SQLINE_EXPIRE_NONE
	Alap SQLINE lejrati id Nem elvl
OPER_STATS_SZLINE_COUNT
	Aktulis SZLINEok szma: %d
OPER_STATS_SZLINE_EXPIRE_DAYS
	Alap SZLINE lejrati id: %d nap
OPER_STATS_SZLINE_EXPIRE_DAY
	Alap SZLINE lejrati id: 1 nap
OPER_STATS_SZLINE_EXPIRE_HOURS
	Alap SZLINE lejrati id: %d ra
OPER_STATS_SZLINE_EXPIRE_HOUR
	Alap SZLINE lejrati id: 1 ra
OPER_STATS_SZLINE_EXPIRE_MINS
	Alap SZLINE lejrati id: %d perc
OPER_STATS_SZLINE_EXPIRE_MIN
	Alap SZLINE lejrati id: 1 perc
OPER_STATS_SZLINE_EXPIRE_NONE
	Alap SZLINE lejrati id: Nem elvl
OPER_STATS_RESET
	Statisztika nullzva.

# MODE vlaszok
OPER_STATS_UPLINK_SERVER
	Uplink server: %s
OPER_STATS_UPLINK_CAPAB
	Uplink capab: %s
OPER_STATS_UPLINK_SERVER_COUNT
	Servers found: %d

# MODE responses
OPER_MODE_SYNTAX
	MODE szoba md

# UMODE reaglsok
OPER_UMODE_SYNTAX
	UMODE nick md
OPER_UMODE_SUCCESS
	%s usermdjai megvltoztatva.
OPER_UMODE_CHANGED
	%s vltztatott a mdodon.

# OLINE vlaszok
OPER_OLINE_SYNTAX
	OLINE nick flagek
OPER_OLINE_SUCCESS
	%s operflagek megadva a %s nicknek.
OPER_OLINE_IRCOP
	Most mr IRC Opertor vagy!

# CLEARMODES vlaszok
OPER_CLEARMODES_SYNTAX
	CLEARMODES #szoba [ALL]
OPER_CLEARMODES_DONE
	Binris mdok s kitiltsok trlve a %s csatornrl.
OPER_CLEARMODES_ALL_DONE
	sszes md trlve a %s csatornrl.
	
# KICK vlaszok
OPER_KICK_SYNTAX
	KICK #szoba user indok

# SVSNICK vlaszok
OPER_SVSNICK_SYNTAX
	SVSNICK nick jnick 
OPER_SVSNICK_NEWNICK
	A nicked %s meg lett vltoztatva erre: %s.

# ADMIN vlaszok
OPER_ADMIN_SYNTAX
	ADMIN {ADD|DEL|LIST|CLEAR} [nick | bejegyzsek]
OPER_ADMIN_SKELETON
	Szervz most skeleton mdban fut, az ADMIN parancs nem elrhet
OPER_ADMIN_EXISTS
	%s mr szerepel a szervz admin litban.
OPER_ADMIN_REACHED_LIMIT
	Csak %d szervz admin lehet a listn.
OPER_ADMIN_ADDED
	%s hozzadva szervz admin listhoz.
OPER_ADMIN_NOT_FOUND
	%s nem tallhat szervz admin listn.
OPER_ADMIN_NO_MATCH
	Nincs ilyen a szervz admin listn.
OPER_ADMIN_DELETED
	%s trlve a szervz admin listrl.
OPER_ADMIN_DELETED_ONE
	Trltve 1 bejegyzs a szervz admin listrl.
OPER_ADMIN_DELETED_SEVERAL
	Trltve %d bejegyzs a szervz admin listrl.
OPER_ADMIN_LIST_EMPTY
	Szervz admin lista res.
OPER_ADMIN_LIST_HEADER
	Szerviz admin lista:
	  Szm   Nick
OPER_ADMIN_LIST_FORMAT
	  %3d   %s
OPER_ADMIN_CLEAR
	Szervz admin lista trlve.
OPER_ADMIN_MOVED
	%s has been moved to Services Administrators list.

# OPER vlaszok
OPER_OPER_SYNTAX
	OPER {ADD|DEL|LIST|CLEAR} [nick | bejegyzsek]
OPER_OPER_SKELETON
	Szervz most skeleton mdban fut, az OPER parancs nem elrhet.
OPER_OPER_EXISTS
	%s mr szerepel a szervz opertor listn.
OPER_OPER_REACHED_LIMIT
	Csak %d szervz opertor lehet a listn.
OPER_OPER_ADDED
	%s hozzadva a szervz opertor listhoz.
OPER_OPER_NOT_FOUND
	%s nem tallhat a szervz opertor listn.
OPER_OPER_NO_MATCH
	Nincs ilyen bejegyzs a szervz opertor listn.
OPER_OPER_DELETED
	%s trlve szervz opertor listrl.
OPER_OPER_DELETED_ONE
	Trlve 1 bejegyzs a szervz opertor listrl.
OPER_OPER_DELETED_SEVERAL
	Trlve %d bejegyzs a szervz opertor listtl.
OPER_OPER_LIST_EMPTY
	Szervz opertor lista res.
OPER_OPER_LIST_HEADER
	Szervz opertor lista:
	  Szm   Nick
OPER_OPER_LIST_FORMAT
	  %3d   %s
OPER_OPER_CLEAR
	Szervz opertor lista trlve.
OPER_OPER_MOVED
	%s has been moved to Services Operators list.

# AKILL vlaszok
OPER_AKILL_SYNTAX
	AKILL {ADD | DEL | LIST | VIEW | CLEAR} [[+lejrat] {maszk | sorszm} [indok]]
OPER_AKILL_EXISTS
	%s mr bekapcsolva az AKILL lista.
OPER_AKILL_ALREADY_COVERED
	%s van mr %s ilyen bejegyzs.
OPER_AKILL_REACHED_LIMIT
	Te csak %d AKILL-t jegyezhetsz.
OPER_AKILL_NO_NICK
	Emlkeztet: AKILL maszk nem tartalmazhat nicknevet;
	ellenrizd, hogy nem tartalmazhat nick rszt a maszk.
OPER_AKILL_ADDED
	%s hozzadva az AKILL listhoz.
OPER_AKILL_CHANGED
	Lejrati id megvltozott: %s.
OPER_AKILL_NOT_FOUND
	%s nem tallhat az AKILL listn.
OPER_AKILL_NO_MATCH
	Nincs ilyen bejegyzs az AKILL listn.
OPER_AKILL_DELETED
	%s trlve az AKILL listrl.
OPER_AKILL_DELETED_ONE
	Trlve 1 bejegyzs az AKILL listrl.
OPER_AKILL_DELETED_SEVERAL
	Trlve %d bejegyzs az AKILL listrl.
OPER_AKILL_LIST_EMPTY
	AKILL lista res.
OPER_AKILL_LIST_HEADER
	Aktulis AKILL lista:
	  Szm   Maszk                              Indok
OPER_AKILL_LIST_FORMAT
	  %3d   %-32s  %s
OPER_AKILL_VIEW_HEADER
	Aktulis AKILL lista:
# szm, mask, set-by, set-id, lejrat, indok
OPER_AKILL_VIEW_FORMAT
	%3d  %s (by %s on %s; %s)
	      %s
OPER_AKILL_CLEAR
	Az AKILL lista trlve.
OPER_CHANKILL_SYNTAX
	CHANKILL [+lejrat] {#szoba} [indok]

# SGLINE vlaszok
OPER_SGLINE_SYNTAX
	SGLINE {ADD | DEL | LIST | VIEW | CLEAR} [[ +lejrat] {maszk| sorszm }[:Indok]]
OPER_SGLINE_UNSUPPORTED
	SGLINE nem hasznlhat ezen a hlzaton.
OPER_SGLINE_EXISTS
	%s mr szerepel az SGLINE listn.
OPER_SGLINE_ALREADY_COVERED
	%s trstva van %s ltal.
OPER_SGLINE_REACHED_LIMIT
	Te csak %d szm SGLINE-t jegyezhetsz.
OPER_SGLINE_ADDED
	%s hozzadva a SGLINE listhoz.
OPER_SGLINE_CHANGED
	Lejrati id megvltozott: %s .
OPER_SGLINE_NOT_FOUND
	%s nincs a SGLINE listn.
OPER_SGLINE_NO_MATCH
	Nincs ilyen bejegyzs az SGLINE listn.
OPER_SGLINE_DELETED
	%s trlve az SGLINE listrl.
OPER_SGLINE_DELETED_ONE
	Trlve 1 bejegyzs a SGLINE listrl.
OPER_SGLINE_DELETED_SEVERAL
	Trlve %d bejegyzs a SGLINE listrl.
OPER_SGLINE_LIST_EMPTY
	SGLINE lista res.
OPER_SGLINE_LIST_HEADER
	Aktulis SGLINE lista:
	  Szm   Maszk                              Indok
OPER_SGLINE_LIST_FORMAT
	  %3d   %-32s  %s
OPER_SGLINE_VIEW_HEADER
	Aktulis SGLINE lista:
# szm, mask, set-by, set-id, lejrat, indok
OPER_SGLINE_VIEW_FORMAT
	%3d  %s (%s ltal, ekkor: %s; %s)
	      %s
OPER_SGLINE_CLEAR
	Az SGLINE lista trlve.

# SQLINE vlaszok
OPER_SQLINE_SYNTAX
	SQLINE {ADD|DEL|LIST|VIEW|CLEAR}[ [ +lejrat ] { maszk | sorszm }[ indok ]]
OPER_SQLINE_CHANNELS_UNSUPPORTED
	Szoba SQLINE-ok nem tmogatottak ezen az IRCd-n,ezrt
	nem tudod hasznlni.
OPER_SQLINE_EXISTS
	%s mr szerpel az SQLINE listn.
OPER_SQLINE_ALREADY_COVERED
	%s trstva van %s ltal.
OPER_SQLINE_REACHED_LIMIT
	Te csak %d SQLINE-t jegyezhetsz.
OPER_SQLINE_ADDED
	%s hozzadva az SQLINE listhoz.
OPER_SQLINE_CHANGED
	Lejrati id %s megvlzott.
OPER_SQLINE_NOT_FOUND
	%s nnem tallhat az SQLINE listn.
OPER_SQLINE_NO_MATCH
	Nincs ilyen bejegyzs az SQLINE listn.
OPER_SQLINE_DELETED
	%s trlve az SQLINE listrl.
OPER_SQLINE_DELETED_ONE
	Trlve 1 bejegyzs az SQLINE listrl.
OPER_SQLINE_DELETED_SEVERAL
	Trlve %d bejegyzs az SQLINE listrl.
OPER_SQLINE_LIST_EMPTY
	SQLINE lista res.
OPER_SQLINE_LIST_HEADER
	Aktulis SQLINE lista:
	  Szm   Mask                              Indok
OPER_SQLINE_LIST_FORMAT
	  %3d   %-32s  %s
OPER_SQLINE_VIEW_HEADER
	Aktulis SQLINE lista:
# Szm, mask, set-by, set-Id, lejrat, indok
OPER_SQLINE_VIEW_FORMAT
	%3d  %s (%s ltal, ekkor: %s; %s)
	      %s
OPER_SQLINE_CLEAR
	Az SQLINE lista trlve.

# SZLINE vlaszok
OPER_SZLINE_SYNTAX
	SZLINE {ADD | DEL | LIST | VIEW | CLEAR }[[ +lejrat ] { maszk | sorszm } [ indok ]]
OPER_SZLINE_UNSUPPORTED
	SZLINE nem hasznlhat ezen a hlzaton.
OPER_SZLINE_EXISTS
	%s mr szerepel az SZLINE listn.
OPER_SZLINE_ALREADY_COVERED
	%s trstva %s ltal.
OPER_SZLINE_REACHED_LIMIT
	Te csak %d SZLINE-t jegyezhetsz.
OPER_SZLINE_ONLY_IPS
	Emlkeztet:Te hozzadhatsz IP maszkot SZLINE listhoz.
OPER_SZLINE_ADDED
	%s hozzadva az SZLINE listhoz.
OPER_SZLINE_CHANGED
	Lejrati id megvltozott: %s.
OPER_SZLINE_NOT_FOUND
	%s nem tallhat az SZLINE listn.
OPER_SZLINE_NO_MATCH
	Nincs ilyen bejegyzs az SZLINE listn.
OPER_SZLINE_DELETED
	%s trlve az SZLINE listrl.
OPER_SZLINE_DELETED_ONE
	Trlve 1 bejegyzs az SZLINE listrl.
OPER_SZLINE_DELETED_SEVERAL
	Trlve %d bejegyzs az SZLINE listrl.
OPER_SZLINE_LIST_EMPTY
	SZLINE lista res.
OPER_SZLINE_LIST_HEADER
	Aktulis SZLINE lista:
	Szm	Mask					Indok
OPER_SZLINE_LIST_FORMAT
	  %3d   %-32s  %s
OPER_SZLINE_VIEW_HEADER
	Aktulis SZLINE lista:
# Sszm, maszk, set-by, set-id, lejrat,Indok
OPER_SZLINE_VIEW_FORMAT
	%3d  %s (%s ltal, ekkor: %s; %s)
	      %s
OPER_SZLINE_CLEAR
	Az SZLINE lista trlve

# SET vlaszok
OPER_SET_SYNTAX
	SET opci bellts
OPER_SET_IGNORE_ON
	Mellzs kd lessz hasznlva.
OPER_SET_IGNORE_OFF
	Mellzs kd nem lessz hasznlva.
OPER_SET_IGNORE_ERROR
	Mellzs bellitsnak kell lenni ON vagy OFF.
OPER_SET_READONLY_ON
	Szervz most  csak olvas mdban.
OPER_SET_READONLY_OFF
	Szervz most olvas r mdban.
OPER_SET_READONLY_ERROR
	READONLY bellitshoz kell lenni ON vagy OFF.
OPER_SET_LOGCHAN_ON
	Szervz most kiegszti log zeneteket %s -hoz.
OPER_SET_LOGCHAN_OFF
	A Szervz nem rja ki a napl zeneteket a csatornra.
OPER_SET_LOGCHAN_ERROR
	LOGCHAN belltshoz kell ONvagy OFFs 
	LogCsatornt kell belltani.
OPER_SET_DEBUG_ON
	Szervz most debug mdban fut.
OPER_SET_DEBUG_OFF
	Szervz most mr nem fut debug mdban.
OPER_SET_DEBUG_LEVEL
	Szervz most debug mdban (szint: %d).
OPER_SET_DEBUG_ERROR
	A DEBUG belltshoz kell ON,/OFF,/ pozitv szm.
OPER_SET_NOEXPIRE_ON
	Szervz nem elvl mdban van.
OPER_SET_NOEXPIRE_OFF
	Szervz elvl mdban van.
OPER_SET_NOEXPIRE_ERROR
	Az NOEXPIRE belltshoz kell ON vagy OFF.
OPER_SET_UNKNOWN_OPTION
	Ismeretlen bellts %s.
OPER_SET_SQL_ON
	SQL code will be used.
OPER_SET_SQL_OFF
	SQL code will not be used.
OPER_SET_SQL_ERROR
	Setting for SQL must be ON or OFF.
OPER_SET_SQL_ERROR_INIT
	Error during init of SQL, check your logs to correct.
OPER_SET_SQL_ERROR_DISABLED
	SQL is not configured for this network. Please edit the
	configuration file (services.conf).
OPER_SET_LIST_OPTION_ON
	%s is enable
OPER_SET_LIST_OPTION_OFF
	%s is disabled

# NOOP vlaszok
OPER_NOOP_SYNTAX
	NOOP {SET|REVOKE} szerver
OPER_NOOP_SET
	sszes O:lines %s mdostva.
OPER_NOOP_REVOKE
	sszes O:lines %s jra aktv.

# JUPE vlaszok
OPER_JUPE_SYNTAX
	JUPE szervernv [lers]
OPER_JUPE_HOST_ERROR
	Krlek hasznlj rvnyes szerver nevet amikor jupolsz!

# RAW vlaszok
OPER_RAW_SYNTAX
	RAW text

# UPDATE vlaszok
OPER_UPDATING
	Adatbzis mentve.

# RELOAD vlaszok
OPER_RELOAD
	Szervz konfigurcis fjl jratltve.

# RESTART vlaszok
OPER_CANNOT_RESTART
	SERVICES_BIN nincs meghatrozva; nem tud jraindulni.
	Trj vissza a \2configure\2 scripthez s kez jra a forgatst. 
	Szervzhez engedlyezd a RESTART parancsot.

# IGNORE vlaszok
OPER_IGNORE_SYNTAX
	Syntax: IGNORE {ADD|DEL|LIST|CLEAR} [id] [nick]
OPER_IGNORE_VALID_TIME
	Hasznlj rvnyes szmot idnek. 
	(Adj meg rvnyes szmot az idhz.)
OPER_IGNORE_TIME_DONE
	%s nick most mellzte %s nicket.
OPER_IGNORE_PERM_DONE
	%s nick most vglegesen mellzve van.
OPER_IGNORE_DEL_DONE
	%s nick most mr nics mellzve.
OPER_IGNORE_LIST
	Szervz mellzs lista:
OPER_IGNORE_LIST_NOMATCH
	%s nick nem tallhat a mellzttek listjn.
OPER_IGNORE_LIST_EMPTY
	Mellzttek lista res.
OPER_IGNORE_LIST_CLEARED
	Mellzttek lista trlve.

# KILLCLONES vlaszok
OPER_KILLCLONES_SYNTAX
	KILLCLONES nick
OPER_KILLCLONES_UNKNOWN_NICK
	Nem tallt ilyen felhasznlt %s.

# CHANLIST vlaszok
OPER_CHANLIST_HEADER
	Szoba lista:
	Nv			User Md   Topic
OPER_CHANLIST_HEADER_USER
	%s szoba listja:
	Nv 			User Md   Topic
OPER_CHANLIST_RECORD
	%-20s  %4d +%-6s %s
OPER_CHANLIST_END
	Vge a szoba listnak.

# USERLIST vlaszok
OPER_USERLIST_HEADER
	Felhasznl lista:
	Nick                 Maszk
OPER_USERLIST_HEADER_CHAN
	%s felhasznl lista:
	Nick                 Maszk
OPER_USERLIST_RECORD
	%-20s %s@%s
OPER_USERLIST_END
	Vge a felhasznl listnak.

# CACHE vlaszok
OPER_SUPER_ADMIN_ON
	Most mr Szuper-Admin vagy
OPER_SUPER_ADMIN_OFF
	Te nem vagy mr Szuper-Admin
OPER_SUPER_ADMIN_SYNTAX
	SET SuperAdmin  ON vagy OFF 
	(engedlyezni kell a services.conf-ban)
OPER_SUPER_ADMIN_WALL_ON
	%s most mr Szuper-Admin
OPER_SUPER_ADMIN_WALL_OFF
	%s mr nem Szuper-Admin
OPER_SUPER_ADMIN_ONLY
	Csak Szuper-Admin hasznlhatja a parancsot.
OPER_STAFF_LIST_HEADER
	On Szint Nick
OPER_STAFF_FORMAT
	 %c %s  %s
OPER_STAFF_AFORMAT
	 %c %s  %s [%s]

# DefCon zenet

OPER_DEFCON_SYNTAX
	Syntax: DEFCON [1|2|3|4|5]
OPER_DEFCON_DENIED
	Szervz Defcon mdban fut, prbld ksbb.
OPER_DEFCON_NO_CONF
	A Defcon rendszert engedlyezni kell a services.conf-ban
OPER_DEFCON_CHANGED
	Szervz j DEFCON szintje %d
OPER_DEFCON_WALL
	%s mdostotta DEFCON a szintet erre: %d
DEFCON_GLOBAL
	A Defcon szint most: %d

# Module szlnc
OPER_MODULE_LOADED
	%s modul betltve
OPER_MODULE_UNLOADED
	%s modul kitltve
OPER_MODULE_LOAD_FAIL
	Nem sikerlt a betlteni a %s modult
OPER_MODULE_REMOVE_FAIL
	Nem sikerlt eltvoltani a %s modult
OPER_MODULE_NO_UNLOAD
	This module can not be unloaded.
OPER_MODULE_LOAD_SYNTAX
	MODLOAD Fjlnv
OPER_MODULE_UNLOAD_SYNTAX
	MODUNLOAD Fjlnv
OPER_MODULE_LIST_HEADER
	Jelenlegi Modul lista:
OPER_MODULE_LIST
	Modul: %s [%s] [%s]
OPER_MODULE_LIST_FOOTER
	%d Modul betltve.
OPER_MODULE_INFO_LIST
	Modul: %s Verzi: %s Szerz: %s Betltve: %s
OPER_MODULE_CMD_LIST
	Modul parancsai: %R%s %s
OPER_MODULE_MSG_LIST
	IRCD kezels: %s
OPER_MODULE_NO_LIST
	Jelenleg nincs modul betltve.
OPER_MODULE_NO_INFO
	Nincs elrhet informci a  %s modulrl
OPER_MODULE_INFO_SYNTAX
	MODINFO Fjlnv
MODULE_HELP_HEADER
	A kvetkez parancsokat a modulok tartalmazzk:

###########################################################
#
# Session korltozs s kivtel zenetek
#
###########################################################
	
# EXCEPTION vlaszok
OPER_EXCEPTION_SYNTAX
	EXCEPTION {ADD | DEL | MOVE | LIST | VIEW} [paramterek]
OPER_EXCEPTION_ADD_SYNTAX
	EXCEPTION ADD [+elvls] maszk korlt indok
OPER_EXCEPTION_DEL_SYNTAX
	EXCEPTION DEL {maszk | list}
OPER_EXCEPTION_MOVE_SYNTAX
	EXCEPTION MOVE Szm helyzet
OPER_EXCEPTION_DISABLED
	Session korltozs tiltva.
OPER_EXCEPTION_ALREADY_PRESENT
	Maszk %s mr szerepel a kivtel listn.
OPER_EXCEPTION_TOO_MANY
	Session-korlt lista megtelt!
OPER_EXCEPTION_ADDED
	Session korlt %s rszre %d-re lltva.
OPER_EXCEPTION_MOVED
	%s kivtel (#%d) thelyezve a %d pozicba.
OPER_EXCEPTION_NO_SUCH_ENTRY
	Nincs bejegyezve (#%d) session-korlt a kivtel listn.
OPER_EXCEPTION_NOT_FOUND
	%s nem tallhat a session-korlt kivtel listn.
OPER_EXCEPTION_NO_MATCH
	Nincs ilyen bejegyzs a session-korlt kivtel listn.
OPER_EXCEPTION_DELETED
	%s trlve a session-korlt kivtel listrl.
OPER_EXCEPTION_DELETED_ONE
	Trlve 1 bejegyzs a session-korlt kivtel listrl.
OPER_EXCEPTION_DELETED_SEVERAL
	Trlve %d bejegyzs a session-korlt kivtel listrl.
OPER_EXCEPTION_LIST_HEADER
	Aktulis Session korlt kivtel lista:
# mask, korlt
OPER_EXCEPTION_LIST_FORMAT
	%3d  %4d   %s
OPER_EXCEPTION_LIST_COLHEAD
	Szm  Korlt  Host
# maszk, set-by, set-id,lejrat, korlt, Indok
OPER_EXCEPTION_VIEW_FORMAT
	%3d.  %s  (%s ltal, ekkor: %s; %s)
	    Korlt: %-4d  - %s
OPER_EXCEPTION_INVALID_LIMIT
	rvnytelen session korlt. rvnyes szmnak kell lennie
	s nagyobbnak vagy egyenlnek mint zr s kissebbnek 
	mint %d.
OPER_EXCEPTION_INVALID_HOSTMASK
	rvnytelen hosztmaszk. Csak rvnyes hosztmaszk lehet,
	a kivtel nem lehet nick vagy usernv.
OPER_EXCEPTION_EXISTS
	%s already exists on the EXCEPTION list.
OPER_EXCEPTION_CHANGED
	Exception for %s has been updated to %d.

# SESSION vlaszok
OPER_SESSION_SYNTAX
	SESSION {LIST korlt | VIEW hoszt}
OPER_SESSION_LIST_SYNTAX
	SESSION LIST korlt
OPER_SESSION_VIEW_SYNTAX
	SESSION VIEW hoszt
OPER_SESSION_DISABLED
	Session korltozs tiltva.
OPER_SESSION_INVALID_THRESHOLD
	rvnytelen kszb rtk. 1-nl nagyobb egsz szmnak
	kell lennie.
OPER_SESSION_NOT_FOUND
	%s nincs a session listn.
OPER_SESSION_LIST_HEADER
	Hosztok legalbb %d sessionnel:
OPER_SESSION_LIST_COLHEAD
	Sessions  Host
# korlt, hoszt
OPER_SESSION_LIST_FORMAT
	%6d    %s
# hoszt, sessions, korlt
OPER_SESSION_VIEW_FORMAT
	A %s hoszt aktulisan %d sessiont hasznl, a hatrrtke %d.

# EXCEPTION help
OPER_HELP_EXCEPTION
	Syntax: EXCEPTION ADD [+lejrat] maszkkorltindok
	        EXCEPTION DEL {maszk| list}
	        EXCEPTION MOVE szm helyzet
	        EXCEPTION LIST [maszk | lista]
	        EXCEPTION VIEW [maszk | lista]
	
	Lehetsget nyjt a szervz adminnak, hogy karbantartsk
	azon hostok listjt, amelyeknek korltozsuk van,
	engedlyezve bizonyos gpeket,gymint a shell szervereket,
	hogy egyidben felvigyenek klienseket alaprtelmezettnl
	nagyobb szmban. Amennyiben a gp elri a korltot, minden
	csatlakozni prbl kliens killelve lesz.Mieltt a kill
	megtrtnne, figyelmeztetst kapnak %S /NOTICE zeneten 
	keresztl. Az zenet tartalma a konfigurcitl fgg.
	
	EXCEPTION ADD hozzadja a hostmaszkot a kivtellisthoz.
	Vedd figyelembe, hogy a nick!user@host s user@host
	maszkok rvnytelenek! Csak vals hostmaszkok, mint pl.
	box.host.dom s *.host.dom, megengedettek, a session
	korltozsmaszkja nem vesz fel nicknevet/felhasznlnevet.
	A korltlegyen egy nullval egyenl vagy nagyobb szm.
	Ez hatrozza meg, hogy hny sessiont vihet magval a host
	egyidben. A nulla azt jelenti, hogy a hostnak korltlan
	szm sessionja lehet. Lsd az AKILL helpet a rszletek
	fell a formrl a szksges lejrati parameterrl.
	EXCEPTION DEL Trli a megadott maszkot a kivtel litrl	
	EXCEPTION MOVE mdistja a kivtel poziciszmt. A 
	kivtelek fel-le mozgatja, az res helyekre is.
	EXCEPTION LIST s EXCEPTION VIEW Mutatja az sszes
	aktulis kivtelt; ha megadsz egy tetszleges maszkot,
	korltozza azokat a kivteleket, melyekre rillik a maszk.
	A klnbsg a kt parancs kztt az, hogy az
	EXCEPTION VIEW sokkal rszletesebb, megjelenti a
	kivtelt felrak nevt a session korltot, indokot, 
	hostmaszkot s a lejrati idt,a a kivtel legutols
	"hasznlati" idejt.
	
	Vedd figyelembe, a csatlakoz kliens a rill kivtelek
	kzl mindig az elst hasznlja. Hatalmas kivtellistk
	s szleskr kivtelmaszkok cskkenthetik a Szervz 
	teljestmnyt.
	
	Korltozva Szervz adminnak.

OPER_HELP_SESSION
	Syntax: SESSION LIST threshold
	        SESSION VIEW host
	
	Megengedi a Szervz adminoknak, hogy megtekintsk a 
	session listt.

	SESSION LIST  kilistzza azokat a hostokat, amelyeknek
	legalbb hatrrtksessionjuk van. rtk legyen 1-nl
	nagyobb szm,hogy megelzze az egy sessionak kilistzst
	SESSION VIEWmegjelenti a host rszletes informciit,
	tartalmazva a jelenlegi session szmot, session korltot.
	A host rtke nem tartalmazhat maszkkaraktereket.
	
	Lsd az EXCEPTION helpjt tovbbi informcirt a 
	session-korltozssal s azzal kapcsolatban,hogyan llts
	be klnleges korltokat bizonyos hostokra s csoportokra.
	
	
	Korltozva Szervz adminoknak.

OPER_HELP_STAFF
	Syntax: STAFF

	Kijelzi az sszes szervz rsztvev nickjt, szintjt s 
	on-line helyzett.

OPER_HELP_DEFCON
	Syntax: DEFCON [1|2|3|4|5]

	A defcon rendszer kpes hasznlni elre belltott
	korltozst a szervz hasznlatban egy tmads alkalmval
	a hlzaton.

OPER_HELP_DEFCON_NO_NEW_CHANNELS
	* Nem lehet j csatornt regisztrlni.
OPER_HELP_DEFCON_NO_NEW_NICKS
	* Nem lehet j nicket regisztrlni.
OPER_HELP_DEFCON_NO_MLOCK_CHANGE
	* Nincs MLOCK mdosts
OPER_HELP_DEFCON_FORCE_CHAN_MODES
	* Belltja a kvetkez mdokat: (%s) az sszes csatornn.
OPER_HELP_DEFCON_REDUCE_SESSION
	* Hasznlva a cskkentett session korlt: %d.
OPER_HELP_DEFCON_NO_NEW_CLIENTS
	* Killelve lesz minden j felhasznl csatlakozsnl. 
OPER_HELP_DEFCON_OPER_ONLY
	* Mellzve minden nem opertortl jv zenet
OPER_HELP_DEFCON_SILENT_OPER_ONLY
	* Csendes mellzs, csak opertorok
OPER_HELP_DEFCON_AKILL_NEW_CLIENTS
	* AKILL minden j kliensre csatlakozskor.
OPER_HELP_DEFCON_NO_NEW_MEMOS
	* Nem lehet j memot kldeni
OPER_HELP_CHANKILL
	Syntax: CHANKILL [+lejrat] #szobaindok

	Akillre tesz minden nicket az adott csatornn. Ez a ltezo
	s teljesen vals ident@host maszkot hasznlja, minden 
	nick esetben vgrehajtja az AKILLt.

###########################################################################
#
# Hr rendszer zenetek
#
###########################################################################

NEWS_LOGON_TEXT
	[Fellpsi Hr] - %s %s
NEWS_OPER_TEXT
	[Oper Hr] - %s %s
NEWS_RANDOM_TEXT
	[Vletlenszer Hr] - %s %s

NEWS_LOGON_SYNTAX
	Syntax: LOGONNEWS { ADD | DEL | LIST } [szveg|szm]
NEWS_LOGON_LIST_HEADER
	Fellpsi hrek:
NEWS_LOGON_LIST_ENTRY
	%5d (%s %s ltal)
	    %s
NEWS_LOGON_LIST_NONE
	Nincs fellp zenet.
NEWS_LOGON_ADD_SYNTAX
	Syntax: LOGONNEWS ADD szveg
NEWS_LOGON_ADD_FULL
	A Hrlista tele!
NEWS_LOGON_ADDED
	Hozzadva az j fellpsi hr: (#%d).
NEWS_LOGON_DEL_SYNTAX
	Syntax: LOGONNEWS DEL {szm | ALL}
NEWS_LOGON_DEL_NOT_FOUND
	Logon news ttel #%d nem tallhat!
NEWS_LOGON_DELETED
	Logon news ttel #%d trlve.
NEWS_LOGON_DEL_NONE
	Nincs trlhet fellpsi hr!
NEWS_LOGON_DELETED_ALL
	sszes fellpsi hr ttel trlve.

NEWS_OPER_SYNTAX
	Syntax: OPERNEWS { ADD | DEL |LIST } [ szveg | szm ]
NEWS_OPER_LIST_HEADER
	Oper hrek listja:
NEWS_OPER_LIST_ENTRY
	%5d (%s %s ltal)
	    %s
NEWS_OPER_LIST_NONE
	Nincs oper news.
NEWS_OPER_ADD_SYNTAX
	Syntax: OPERNEWS ADD szveg
NEWS_OPER_ADD_FULL
	Az Oper hrek listja tele van!
NEWS_OPER_ADDED
	Hozzadva az j oper hr:(#%d).
NEWS_OPER_DEL_SYNTAX
	Syntax: OPERNEWS DEL {szm | ALL}
NEWS_OPER_DEL_NOT_FOUND
	Oper news ttel #%d nem tallhat!
NEWS_OPER_DELETED
	Oper news ttel #%d trlve.
NEWS_OPER_DEL_NONE
	Nincs trlhet opernews ttel!
NEWS_OPER_DELETED_ALL
	sszes oper hr trlve.

NEWS_RANDOM_SYNTAX
	Syntax: RANDOMNEWS { ADD | DEL | LIST } [ szveg | szm ]
NEWS_RANDOM_LIST_HEADER
	Vletlenszer hrek listja:
NEWS_RANDOM_LIST_ENTRY
	%5d (%s %s ltal)
	    %s
NEWS_RANDOM_LIST_NONE
	Nincs vletlenszer hr.
NEWS_RANDOM_ADD_SYNTAX
	Syntax: RANDOMNEWS ADD szveg
NEWS_RANDOM_ADD_FULL
	News lista tele!
NEWS_RANDOM_ADDED
	Hozzadva az j random news ttel (#%d).
NEWS_RANDOM_DEL_SYNTAX
	Syntax: RANDOMNEWS DEL {szm | ALL}
NEWS_RANDOM_DEL_NOT_FOUND
	Random news ttel #%d nem tallhat!
NEWS_RANDOM_DELETED
	Random news ttel #%d trlve.
NEWS_RANDOM_DEL_NONE
	Nincs trlhet random news ttel!
NEWS_RANDOM_DELETED_ALL
	sszes random news ttel trlve.

NEWS_HELP_LOGON
	Syntax: LOGONNEWS ADD szveg
	        LOGONNEWS DEL {sorszm  | ALL}
	        LOGONNEWS LIST
	
	Szerkeszti, vagy kiirja a logon news zeneteket.Amikor
	egy felhasznl csatlakozik a hlzathoz ezeket az
	zeneteket kldi neki. (Brmennyi is van csak hrom 
	zenetet kld, mindig a hrom legutolst kldi el.)
		
	LOGONNEWS LIST lehetsg van hasznlatra IRC opertornak,
	rszre listzza az aktulis news zeneteket. Az ADD s a 
	DEL  parancsokat csak szervz adminok hasznlhatjk.
		
NEWS_HELP_OPER
	Syntax: OPERNEWS ADD szveg
	        OPERNEWS DEL {szm | ALL}
	        OPERNEWS LIST
	
	Szerkeszti s listzza az oper news zeneteket. Amikor 
	egy oper felhasznl csatlakozik a /OPER paranccal a 
	hlzathoz ezeket az zeneteket fogaj neki kldeni.
	(Brmennyi is van csak hrom zenetet kld, hogy elkerlje
	a floodot a felhasznl.Hromnl tbb zenetbl a hrom
	legutlst kldi el)

	
	OPERNEWS LIST  IRC opertorok,hasznlhatjk a parancsot
	rszkre listzza az aktulis oper news zeneteket. Add s 
	Del -t csak szervz adminok hasznlhatjk

NEWS_HELP_RANDOM
	Syntax: RANDOMNEWS ADD szveg
	        RANDOMNEWS DEL {sorszm | ALL}
	        RANDOMNEWS LIST
	
	Szerkeszti s listzza a random news zeneteket. Amikor
	egy felhasznl csatlakozik a hlzathoz, egy (csak egy)
	random newst fog vletlenszeren elkldeni rszre.
	
	RANDOMNEWS LIST IRC opertorok,hasznlhatjk a parancsot
	rszkre listzza az aktulis oper news zeneteket. Add s 
	Del -t csak szervz adminok hasznlhatjk
	
###########################################################
#
# HelpSzerv segtsg zenetei
#
###########################################################

HELP_HELP
	%S egy szolgltats melynek a feladata, hogy eligaztst
	adjon a Szervzzel kapcsolatos informcikban.
	A kvetkez tmakrk rhetk el ms Services kliensekrl:

	%R%s HELP
	     A nicknv regisztrcival kapcsolatos informcikrl.

	%R%s HELP
	     A szoba regisztrcival s karbantartssal 
	     kapcsolatos informcikrl

	%R%s HELP
	     zenetek kldse offline (regisztrlt) usereknek.

HELP_HELP_BOT

	%R%s HELP
	     Szervz bot fellltshoz a csatorndra.

HELP_HELP_HOST

	%R%s HELP
	     Vhost ignylsrl bvebb informcikrt.
	
###########################################################
#
# NickServ segtsg zenetei
#
###########################################################
NICK_HELP_CMD_CONFIRM
	    CONFIRM    Confirm a nickserv auth code
NICK_HELP_CMD_RESEND
	    RESEND     Resend a nickserv auth code

NICK_HELP_CMD_REGISTER
	    REGISTER   Nicknv regisztrci
NICK_HELP_CMD_GROUP
	    GROUP      Csatlakozs egy csoporthoz
NICK_HELP_CMD_IDENTIFY
	    IDENTIFY   Jelszavas azonosts
NICK_HELP_CMD_ACCESS
	    ACCESS     A hozzfrsi lista mdostsa
NICK_HELP_CMD_SET
	    SET        Opcik belltsa, pldul kill vdelem
NICK_HELP_CMD_SASET
	    SASET      Set SET-options on another nickname
NICK_HELP_CMD_DROP
	    DROP       Nicknv regisztrcijnak trlse
NICK_HELP_CMD_RECOVER
	    RECOVER    Killeli a nickedet hasznl usert
NICK_HELP_CMD_RELEASE
	    RELEASE    Visszaadja a neved a RECOVER utn
NICK_HELP_CMD_SENDPASS
	    SENDPASS   Elfelejtetted a jelszavad? Prbld ezt
NICK_HELP_CMD_GHOST
	    GHOST      Disconnects a "ghost" IRC session using your nick
NICK_HELP_CMD_ALIST
	    ALIST      List channels you have access on
NICK_HELP_CMD_GLIST
	    GLIST      Lists all nicknames in your group
NICK_HELP_CMD_INFO
	    INFO       Displays information about a given nickname
NICK_HELP_CMD_LIST
	    LIST       List all registered nicknames that match a given pattern
NICK_HELP_CMD_LOGOUT
	    LOGOUT     Reverses the effect of the IDENTIFY command
NICK_HELP_CMD_STATUS
	    STATUS     Returns the owner status of the given nickname
NICK_HELP_CMD_UPDATE
	    UPDATE     Updates your current status, i.e. it checks for new memos
NICK_HELP_CMD_GETPASS
	    GETPASS    Kiirja a jeszavt a nicknvnek
	               (encryption esetn nem hasznlhat)
NICK_HELP_CMD_GETEMAIL
	    GETEMAIL   Kirja az ilyen e-mail cmmel regisztrlt
	               felhasznlkat
NICK_HELP_CMD_FORBID
	    FORBID     Megelzi, hogy a nicknv regisztrlt legyen
NICK_HELP_CMD_SUSPEND
	    SUSPEND    Suspend a given nick
NICK_HELP_CMD_UNSUSPEND
	    UNSUSPEND  Unsuspend a given nick

NICK_HELP
	%S lehetsget nyjt a "register" parancs hasznlatval
	a nickneved regisztrlsra, ezzel megelzi, hogy ms is
	hasznlhassa a nicked. A NickServ parancsokkal
	rnythat. Az adott parancs szintaktikjt megkapod, ha
	berod, hogy: %R%S parancs, lsd mg a
	%R%S HELP parancs.
	
NICK_HELP_FOOTER
	Megjegyzs: Ez a szolgltats szeretn biztostani az 
	IRC felhasznlok szmra hogy a kiltket ne lehessen 
	kompromitlni. Egyltaln NEM azt szolglja, hogy 
	lehetsget nyjtson nicknevek "lopsra" vagy ms
	erklcstelen akcikra. A %S segtsgvel elkvetett
	visszals jutalma minimum az visszal nickjnek
	elvesztse.
	
NICK_HELP_EXPIRES
	Ha egy regisztrlt nicknevet %d napig nem hasznlnak, akkor
	a regisztrcija elvl, a nicknevet brki regisztrlhatja,
	s hasznlhatja.

NICK_HELP_REGISTER
	Syntax: REGISTER jelsz [email]
	
	Regisztrlja a nickneved a %S adatbzisba. Amint a nicked
	regisztrltad, hasznlhatod a SET s ACCESS parancsokat,
	hogy konfigurljad a nicked belltsait. Olyan jelszt 
	vlassz, amire emlkezni fogsz, hogy hasznlni tudd a neved
	s a belltsokat eszkzlhesd. Ksbb szksged lehet a
	nickeddel kapcsolatos belltsok vgrehajtsra.
	(Jegyzet: PROBLMT OKOZHAT FIDO, Fido, s fido
	mind klnbz jelszavak!)

	tikalaz jelsz vlasztshoz:
	
	A jelszavad ne legyen knnyen kitallhat. Pldul az
	ltalad hasznlt valsnevet megadni jelsznak rossz tlet.
	A nickneved hasznlni jelsznak mg rosszabb tlet ;) s
	a %S nem is engedi. A rvid jelszavak is rosszak a vdelem
	szempontjbl, ezrt vlassz legalbb 5 karakter hosszt.
	Vgezetl ne hasznlhatsz szkzt a jelszban.
	
	Aze-mail paramter megads lehetsges, megadsakor
	belltja a nickedhez. Megadsa a legtbb hlzaton
	szksges. Az e-mail cmed nem kerl harmadik szemly
	tudtra, bizalmasan kezeljk.
	
	Ez a parancs ltrehoz egy j csoportot a nickeddel, ami
	lehetv teszi szmodra, hogy msik nickeket regisztrlva
	megoszthasd a hozzfrseidet s belltsaidat a nickjeid
	kztt. Bvebb informcikrt rd be: %R%S HELP GROUP

NICK_HELP_GROUP
	Syntax: GROUP clnicknv jelsz
	
	A parancs belpteti a nickneved a clnicknv csoportjba.
	A jelsz a clnicknv jelszavnak kell lennie.
	
	A csoportba val belps lehetv teszi, hogy megoszd a
	konfigurcit, memo zeneteket, szoba hozzfrseket
	a nicknevekkel a csoportban, s sok ms lehetsget nyjt!
	 
	A csoport addig ltezik, amig hasznlatban van.
	Ez azt jelenti, ha egy nicknevet dropolnak a csoportbl,
	nem fogod elveszteni a megosztott dolgokat, egszen addig,
	amig legalbb egy nick van a csoportban.
	
	Akkor is hasznlhatod a parancsot, ha mg nem regisztrlt
	a nicked. Ha a nicked regisztrlt, akkor elbb azonostani
	kell a jelszavaddal, mieltt ezt a parancsot hasznlod.
	rd be:%R%S HELP IDENTIFY bvebb informcirt.
	
	Ajnlott, hogy inkbb nem regisztrlt nvvel hasznld
	ezt a parancsot, mert ezzel automatikusan regisztrldik.
	Ha regisztlt nickrl hasznlod (hogy megvltoztasd a
	csoportod) csak akkor mkdik, ha a network adminok ezt
	engedlyezik.
	
	Egyszerre egy csoportban lehetsz. 
	
	Megjegyzs: minden nicknvnek a csoportban ugyanaz
			 a jelszava.

NICK_HELP_IDENTIFY
	Syntax: IDENTIFY jelsz
	
	Tudatja a %S-vel, hogy te vagy a tulajdonosa ennek a 
	nicknek. Jelsznak ugyanannak kell lennie amit a 
	regisztrcinl megadtl, vagy amire mdostottad.

NICK_HELP_UPDATE
	Syntax: UPDATE

	Frissti a jelenlegi sttuszod, vagyis ellenrzi, hogy 
	jtt-e j memo zenet, belltja a szksges szoba 
	mdokat, (ModeonID)s frissti a vhostod, az userflagjeid
	(utols fellps, stb.)
	
NICK_HELP_LOGOUT
	Syntax: LOGOUT
	
	Ezzel az IDENTIFY parancs hatsnak fordtottjt red el.
	Nem fog a NickServ egy adott nick tulajdonosnak tekinteni.
	
NICK_HELP_DROP
	Syntax: DROP [nicknv]
	
	Regisztrci trlse (dropolja) a nickneved a %S
	adatbzisbl. A droppols utn a nicknv mr szabadon
	hsznlhat brki ltal, jra regisztrlhat lesz.
	
	gy dropolhatsz nevet a csoportodbl, ha megadod a 
	nicknv paramtert.

	Ezen parancs kiadsa eltt, azonositanod kell magad,
	mint a nick tulajdonosa, hasznlva az IDENTIFY parancsot,
	rd be: %R%S HELP IDENTIFY bvebb informcirt. 

NICK_HELP_ACCESS
	Syntax: ACCESS ADD maszk
	        ACCESS DEL maszk
	        ACCESS LIST
	
	Mdostja vagy kiirja a hozzfrsi listt a nickedhez.
	Ez azon cmeknek a listja, amelyek automatikusan gy 
	tekintdnek a %S-ben, hogy engedlyk van a nicket 
	hasznlni. Ha a nicked ms cmekrl akarod hasznlni,
	akkor nem kell IDENTIFY parancsot kldened, hogy gy
	legyl tekintve, a %S-ben, mint a nick tulajdonosa.
	
	Pldk:
	
	    ACCESS ADD anyone@*.bepeg.com
	          Hozzfrst engedlyez az anyone identnek brmely
	          gprl aminek a bepeg.com a domainje.
	
	    ACCESS DEL anyone@*.bepeg.com
	          Trli az elz parancsot.
	
	    ACCESS LIST
	          Megmutatja a hozzfrsi listt.

NICK_HELP_SET
	Syntax: SET opci paramterek
	
	Bellthat nicknv opcik. Az opci ezek egyike lehet:
	
	    DISPLAY    Set the display of your group in Services
	    PASSWORD   Set your nickname password
	    LANGUAGE   A szervz nyelvezetnek megvlasztsa
	    URL        Egy URL trstsa a nicknevedhez
	    EMAIL      Egy E-mail cm trstsa a nicknevedhez
	    ICQ        ICQ szm trstsa a nicknevedhez
	    GREET      Ksznt zenet trstsa a nicknevedhez
	    KILL       A kill vdelem be-,kikapcsolsa
	    SECURE     A nickneved vdelmnek be-,kikapcsolsa
	    PRIVATE    A nickneved %R%S LIST -bl val elrejtse
	    HIDE       A nicknvhez tartoz informcik elrejtse
	    MSG        Megvltoztatja a szervzzel val kommunikcit
	    AUTOOP     Should services op you automatically.    
	    
	Ezen parancs kiadsa eltt, azonositanod kell magad, mint
	a nick tulajdonosa az IDENTIFY parancsot hasznlva, rd
	be: %R%S HELP IDENTIFY bvebb informcirt. 
	
	rd be: %R%S HELP SET opci bvebb informcirt.
	
	
NICK_HELP_SET_DISPLAY
	Syntax: SET DISPLAY j-megjelents
	
	Megvltoztatja a nicknv csoportod megjelentst a 
	szervzben.	Az j megjelentsnek a csoport egyik
	nickjnek KELL lennie.

NICK_HELP_SET_PASSWORD
	Syntax: SET PASSWORD j-jelsz
	
	Megvltoztatja a nicknv tulajdonosnak jelszavt.

NICK_HELP_SET_LANGUAGE
	Syntax: SET LANGUAGE sorszm

	Megvltoztatja a SERVICES nyelvezett, amin az zenteket
	rja.(Pldul: amikor vlaszol egy parancsra, amit te 
	adtl ki). A sorszm alapjn vlaszd ki a nyelvezetet:
	
NICK_HELP_SET_URL
	Syntax: SET URL url
	
	Egy URL trstsa a nicknevedhez. Ez az URL szerepelni fog
	az INFO-idban, amit brki lekrhet az INFO paranccsal.

NICK_HELP_SET_EMAIL
	Syntax: SET EMAIL cm
	
	Egy E-mail cm trstsa a nicknevedhez.
	Ez az E-mail cm szerepelni fog az INFO-id kztt,
	amit brki lekrhet az INFO paranccsal.
	
NICK_HELP_SET_ICQ
	Syntax: SET ICQ szm
	
	Az ICQ  szmod trstsa a nicknevedhez.
	Ez a szm szerepelni fog az INFO-id kztt,
	amit brki lekrhet az INFO paranccsal.
	
NICK_HELP_SET_GREET
	Syntax: SET GREET zenet
	
	Ez az opci trst egy zenetet a nicknevedhez,
	ami akkor fog megjelenni belpskor, ha a csatornn
	a GREET opci engedlyezve van s te rendelkezel a
	megfelel szinttel, ami az zenet megjelenitshez
	szksges a csatornn.

NICK_HELP_SET_KILL
	Syntax: SET KILL {ON | QUICK | IMMED | OFF}
	
	Be/kikapcsolja az automatikus kill vdelmet a nickedhez.
	A kill vdelem bekapcsolsakor, ha ms user megprblja
	hasznlni a nicked, kap egy percet mialatt meg kell
	vltoztatnia a nickjt, ha letelt az id akkor a %S 
	megvltztatja a nickjt pl: Vendg-000001-re.
	
	Ha a QUICK -et vlasztod, a user csak 20 msodpercet kap
	a nickvltsra eltren az ltalnos 60 msodperctl.
	Ha az IMMED-et vlasztod akkor azonnal megvltztatja.
	Figyelmeztets nlkl,nem kap eslyt a nickvltsra;
	krlek ne hasznld ezt az opcit csak ha nagyon indokolt.
	A network adminisztrtorok letilthatjk ezt.
	
NICK_HELP_SET_SECURE
	Syntax: SET SECURE {ON | OFF}
	
	Be/kikapcsolja a %S a biztonsgi belltsokat a nickhez.
	A SECURE belltssal, be kell rnod a jelszavadat
	mieltt a nicknv tulajdonsaknt leszel tekintve,
	kivve, ha a hosztod szerepel az access listn.
	Habr, ha az access listn szerepel a hosztod, akkor
	nem fog automatikusan nevet vltztatni a %S, hacsak
	nincs bekapcsolva a KILL opci.

NICK_HELP_SET_PRIVATE
	Syntax: SET PRIVATE {ON | OFF}
	
	Be/kikapcsolja a %S a privt opcit a nicknevedhez.
	A PRIVATE belltssal, bellthatod azt, hogy
	a nickneved ne szerepeljen a nicknv listban ami 
	lekrhet a %S LIST paranccsal.
	(Msklnben, brki kaphat informcit a nicknevedrl
	hasznlva az INFO parancsot.)

NICK_HELP_SET_HIDE
	Syntax: SET HIDE {EMAIL | USERMASK | QUIT} {ON | OFF}
	
	Lehetsget nyjt arra, hogy megelzd nhny adatnak a
	szerepelst a %S INFO parancs hasznlatakor .
	Elrejtheted az E-mail cmed (EMAIL), az utoljra hasznlt
	user@host maszkod (USERMASK), s az utols kilp 
	zeneted(QUIT).	A msodik paramter meghatrozza, hogy 
	az opci ki legyen kapcsolva(OFF)	vagy el legyen rejtve
	az informci(ON).

NICK_HELP_SET_MSG
	Syntax: SET MSG {ON | OFF}
	
	Lehetsget nyjt arra, hogy megvlaszd azt, hogy a szervz
	hogyan kommunikljon veled.
	Az MSG belltssal, a szervz, privt zeneteket fog
	hasznlni, egybknt pedig noticeokat.

NICK_HELP_SET_AUTOOP
	Syntax: SET AUTOOP {ON | OFF}
	
	Sets whether you will be opped automatically. Set to ON to 
	allow ChanServ to op you automatically when entering channels.

NICK_HELP_SASET
	Syntax: SASET nickname option parameters.
	
	Sets various nickname options.  option can be one of:
	
	    DISPLAY    Set the display of the group in Services
	    PASSWORD   Set the nickname password
	    URL        Associate a URL with the nickname
	    EMAIL      Associate an E-mail address with the nickname
	    ICQ        Associate an ICQ number with the nickname
	    GREET      Associate a greet message with the nickname
	    KILL       Turn protection on or off
	    SECURE     Turn nickname security on or off
	    PRIVATE    Prevent the nickname from appearing in a
	                   %R%S LIST
	    HIDE       Hide certain pieces of nickname information
	    MSG        Change the communication method of Services
	    NOEXPIRE   Prevent the nickname from expiring
	
	Type %R%S HELP SASET option for more information
	on a specific option. The options will be set on the given
	nickname. 
	
	Limited to Services admins.

NICK_HELP_SASET_DISPLAY
	Syntax: SASET nickname DISPLAY new-display
	
	Changes the display used to refer to the nickname group in 
	Services. The new display MUST be a nick of the group.
	
	Limited to Services admins.

NICK_HELP_SASET_PASSWORD
	Syntax: SET nickname PASSWORD new-password
	
	Changes the password used to identify as the nick's	owner.
	
	Limited to Services admins.

NICK_HELP_SASET_URL
	Syntax: SASET nickname URL url
	
	Associates the given URL with the nickname.  This URL
	will be displayed whenever someone requests information
	on the nick with the INFO command.
	
	Limited to Services admins.

NICK_HELP_SASET_EMAIL
	Syntax: SASET nickname EMAIL address
	
	Associates the given E-mail address with the nickname.
	
	Limited to Services admins.
	
NICK_HELP_SASET_ICQ
	Syntax: SASET nickname ICQ number
	
	Associates the given ICQ number with the nickname.  This 
	number will be displayed whenever someone requests 
	information on the nick with the INFO command.
	
	Limited to Services admins.
	
NICK_HELP_SASET_GREET
	Syntax: SASET nickname GREET message
	
	Makes the given message the greet of the nickname, that
	will be displayed when joining a channel that has GREET
	option enabled, provided that the user has the necessary 
	access on it.
	
	Limited to Services admins.

NICK_HELP_SASET_KILL
	Syntax: SASET nickname KILL {ON | QUICK | IMMED | OFF}
	
	Turns the automatic protection option for the nick
	on or off.  With protection on, if another user
	tries to take the nick, they will be given one minute to
	change to another nick, after which %S will forcibly change
	their nick.
	
	If you select QUICK, the user will be given only 20 seconds
	to change nicks instead of the usual 60.  If you select
	IMMED, user's nick will be changed immediately without being
	warned first or given a chance to change their nick; please
	do not use this option unless necessary.  Also, your
	network's administrators may have disabled this option.
	
	Limited to Services admins.

NICK_HELP_SASET_SECURE
	Syntax: SASET nickname SECURE {ON | OFF}
	
	Turns %S's security features on or off for your
	nick.  With SECURE set, you must enter your password
	before you will be recognized as the owner of the nick,
	regardless of whether your address is on the access
	list.  However, if you are on the access list, %S
	will not auto-kill you regardless of the setting of the
	KILL option.
	
	Limited to Services admins.

NICK_HELP_SASET_PRIVATE
	Syntax: SASET nickname PRIVATE {ON | OFF}
	
	Turns %S's privacy option on or off for the nick.
	With PRIVATE set, the nickname will not appear in
	nickname lists generated with %S's LIST command.
	(However, anyone who knows the nickname can still get
	information on it using the INFO command.)
	
	Limited to Services admins.

NICK_HELP_SASET_HIDE
	Syntax: SASET nickname HIDE {EMAIL | STATUS | USERMASK | QUIT} {ON | OFF}
	
	Allows you to prevent certain pieces of information from
	being displayed when someone does a %S INFO on the
	nick.  You can hide the E-mail address (EMAIL), last seen
	user@host mask (USERMASK), the services access status
	(STATUS) and  last quit message (QUIT).
	The second parameter specifies whether the information should
	be displayed (OFF) or hidden (ON).
	
	Limited to Services admins.
	
NICK_HELP_SASET_MSG
	Syntax: SASET nickname MSG {ON | OFF}
	
	Allows you to choose the way Services are communicating with 
	the given user. With MSG set, Services will use messages,
	else they'll use notices.
	
	Limited to Services admins.

NICK_HELP_SASET_NOEXPIRE
	Syntax: SASET nickname NOEXPIRE {ON | OFF}
	
	Sets whether the given nickname will expire.  Setting this
	to ON prevents the nickname from expiring.
	
	Limited to Services admins.

NICK_HELP_SASET_AUTOOP
	Syntax: SASET nickname AUTOOP {ON | OFF}
	
	Sets whether the given nickname will be opped automatically.
	Set to ON to allow ChanServ to op you automatically when joining
	channels.
	
	Limited to Services admins.

NICK_HELP_RECOVER
	Syntax: RECOVER nicknv [jelsz]
	
	Amikor hasznlod ezt a parancsot, akkor a %S fel fog hozni
	egy lfelhasznlt ugyanazzal a nvvel, amit vissza
	akarsz venni a msik usertl. Ezzel egyidben az IRC 
	szerver megbontja a msik felhasznl kapcsolatt.
	A %S lfelhasznlja egy percig online marad, hogy a
	msik felhasznl ne tudjon automatikusa jracsatlakozni;
	ennek az idnek a letelte utn, felveheted a nevedet.
	Alternatv megolds, a RELEASE parancs hasznlata
	(%R%S HELP RELEASE) ezzel hamarabb is visszakaphatod
	a neved.
	
	Abban az esetben, ha hasznlod a RECOVER parancsot,akkor
	tudnod kell a pontos jelszt a nickhez.

NICK_HELP_RELEASE
	Syntax: RELEASE nicknv [jelsz]
	
	Utastja a %S -et, hogy ne tartsa tovbb az
	automatikus kill vdelem vagy a RECOVER
	parancs hasznlatbl kifolylag felvett neved.
	Alapbellts szerint csak egy percig tartja, de
	ezzel a paranccsal hamarabb tvehet jra a neved.
	
	Ha a RELEASE parancsot akarod hasznlni, tudnod kell a
	pontos jelszt a nickhez.

NICK_HELP_GHOST
	Syntax: GHOST nickv [jelsz]
	
	Ezt a parancsot akkor hasznlhatod, ha a nicked beragad, 
	befagy pldul lefagy a gped vagy a kapcsolatod.
	A beragadt nicked killelheted, ha ismered a jelszt .
	
NICK_HELP_INFO
	Syntax: INFO nicknv [ALL]
	
	Megmutatja a nicknvvel kapcsolatos informcikat, mint a
	nick tulajdonosa, utoljra ltott cme, regisztrls ideje,
	a nick opcikat. Ha beazonostasz egy nickre, akkor minden 
	informacit megkaphatsz az ALL paramter hasznlatval 
	s  gy ltni fogod a rejtett informcikat is.
	
NICK_HELP_LIST
	Syntax: LIST paramter
	
	Listzza az sszes regisztrlt nicknevet, amely
	megegyezik a mintban kiadott nick!user@host formtummal.
	Azok a nevek, amelyeken fent van PRIVATE opci bellts
	NEM fognak megjelenni a listban.
	
	Pldk:
	
	    LIST joeuser@foo.com
	          Listz minden regisztrlt nicknevet, amelyet utoljra:
	           joeuser@foo.com cmrl hasznltak.
	
	    LIST *Bot*
	          Listz minden nicket amelyben szerepelt a Bot
	
	    LIST *@*.bar.org
	          Listz minden nicket, amit utoljra olyan user hasznlt,
	          akinek a bar.org volt a domain-je.
	
NICK_HELP_ALIST
	Syntax: ALIST [szint]
	
	Listz minden csatornt, ahol hozzfrsed van. 
	Opcionlisan megadhatod a szintet XOP vagy ACCESS
	formtumban is. Az eredmny csak azon szobkat fogja 
	megjeleniteni, ahol a megadott hozzfrsi szinted van.
	
	Pldk:
	    ALIST Founder
	          Listz minden csatornt, ahol Founder hozzfrsed van.
	    ALIST AOP
	          Listz minden csatornt, ahol AOP hozzfrsed
	          vagy magasabb szinted van.
	    ALIST 10
	          Listz minden csatornt, ahol 10-es hozzfrsed
	          vagy magasabb szinted van.

	Azok a csatornk melyeken a NOEXPIREopci be van lltva,
	prefixel lesznek megjellve a listban.

NICK_HELP_GLIST
	Syntax: GLIST
	
	Listz minden nicket a csoportodbl.

NICK_HELP_STATUS
	Syntax: STATUS nicknv...
	
	A kvetkezket kapod, ha a nicknvre, amit a felhasznl 
	hasznl azonostotta magt, mint tulajdonos. 
	Az eredmny formja a kvetkez:
	
		nicknv sttusz-kd
	
	ahol a nicknvaz a nicknv amit kldtl a parancsban, s
	a sttusz-kda kvetkez lehet:
	
	    0 - Nincs ilyen user online vagy a nick nem regisztrlt
	    1 - A felhasznl nem azonostott be, mint a nick tulajdonosa
	    2 - A felhasznl beazonostott, mint tulajdonos de csak a 
	        hozzfrsi lista alapjn
	    3 - A felhasznl beazonostott tulajdonosknt a jelszavval
	        
	Tizenhat nicknv kldhet el parancsonknt; a tbbit 
	figyelmen kvl hagyja. If no nickname is given, your status
	will be returned.

NICK_HELP_SENDPASS
	Syntax: SENDPASS nicknv
	
	Kld szmodra egy E-mail zentet, ami tartalmazza a 
	megadott nicknv jelszavt, arra az E-mail cmre, amit
	a regisztrcinl vagy a set email paranccsal megadtl,
	vagy amire vltztattad. Ez igen hasznos, ha elfelejted
	a jelszavadat.
	
	Korltozni lehet IRC opertorokra egyes hlzatokon.
	
	Parancs nem elrhet, ha az encryption hasznlatban van.

NICK_HELP_CONFIRM
	Syntax: CONFIRM passcodE
	
	This is the second step of nickname registration process.
	You must perform this command in order to get your nickname
	registered with %S. The passcode (or called auth code also)
	is sent to your e-mail address in the first step of the
	registration process. For more information about the first
	stage of the registration process, type: %R%S HELP REGISTER
	
NICK_SERVADMIN_HELP
	Szervz adminok is droppolhatnak nickeket, akkor ha
	beazonosttotak a nicknevkre, s megnzhetik a nickek
	hozzfrsi listjt. (%R%S ACCESS LIST nick)

NICK_SERVADMIN_HELP_LOGOUT
	Syntax: LOGOUT [nicknv [REVALIDATE]]
	
	Kilpsi paramter, megfordtja az IDENTIFY parancs
	hatst, azaz nem leszel beazonostva a nickedre, mint a 
	valdi tulajdonosa a nickednek.
	
	A paramter ugyanezt teszi a megadott nickkel.
	Ha megadod a REVALIDATE opcit, akkor a nicktl
	a szerviz jraazonostst fog krni. 
	
	Hasznlat korltozva Szervz adminoknak.

NICK_SERVADMIN_HELP_DROP
	Syntax: DROP [nicknv]
	
	Paramter nlkl, droppolja a neved a %S adatbzisbl.
	
	Paramterrel dropolva a nicknv trldik az adatbzisbl.
	Dropolhatsz egy nicket a csoportodban, kivve, ha van 
	klnleges kivltsga.
	
	Hasznlat korltozva Szervz adminoknak.
	
NICK_SERVADMIN_HELP_INFO
	
	Szervz adminok hasznlhatjk az ALL paramtert.

NICK_SERVADMIN_HELP_LIST
	Syntax: LIST pattern [FORBIDDEN] [NOEXPIRE]
	
	Listz minden regisztrlt nicknevet, amely vagy nicknv
	vagy az utoljra ltott cm (user@hostformban), amely
	azonos a megadott sablonnal. Nickek PRIVATE opcival
	belltva csak szervz adminoknak jelennek meg. A nickek
	NOEXPIRE opcival belltva !prefixel jelennek meg
	a szervz adminoknak.
	
	Ha a FORBIDDEN vagy NOEXPIRE opci meg van adva, csak azok
	a nickek amelyek vagy forbidoltak vagy NOEXPIRE flegjk van
	fognak  megjelenik. Ha mindkt opci meg van adva mindkt
	tipus megjelenik. Az opcik korltozva Services adminoknak.
	
	Pldk:
	
		LIST *!joeuser@foo.com
	            Kirja a felhasznlkat, akiknek a hosztja joeuser@foo.com
	
		LIST *Bot*!*@*
	            Kirja az sszes regisztrlt nicket, melyek nevben 
	            szerepel a Bot (bet rzketlen).
	
	    LIST * NOEXPIRE
	            Listzza az sszes felhasznlt, akinek a belltsa
	            nem elvl.

NICK_SERVADMIN_HELP_ALIST
	Syntax: ALIST [nicknv] [szint]
	
	Paramter nlkl listzza azokat a csatornkat, ahol 
	hozzfrsed van.	Egy paramterrel azokat a szobkat 
	listzza, ahol hozzfrse van a nicknnv-nek. Kt 
	paramterrel azokat a csatornkat listzza, ahol megadott
	szint vagy magasabb a hozzfrse a nicknv-nek.  
	
	Ennek a hasznlata korltozva Szervz adminra.
	
NICK_SERVADMIN_HELP_GLIST
	Syntax: GLIST [nicknv]
	
	Paramter nlkl, listzza az sszes nicknevet 
	a csoportodban.
	Paramterrel listzza az sszes nicknevet, abbl a 
	csoportbl ahol az adott nicknv van.	
	
	Ennek a hasznlata korltozva Szervz adminra.

NICK_SERVADMIN_HELP_GETPASS
	Syntax: GETPASS nicknv
	
	Visszadja a megadott nicknv jelszavt. Jegyzet Ezt 
	a parancsot amaikor hasznlod, zenetet kld arrl 
	hogy ki hasznlta s kinek a jelszavt krte le. 
	Naplzva lesz s WALLOPS/GLOBOPS zenetben is megjelenik.
		
	Korltozva Szervz adminokra.
	
	A parancs nem elrhet, ha az encryption hasznlatban van.
	
NICK_SERVADMIN_HELP_GETEMAIL
	Syntax: GETEMAIL user@emailhoszt

	Visszaadja a megadott emaillel regisztrlt nickeket.
	Megjegyzs: hasznlhatsz * karaktert mind a user,
	mind az emailhost esetben. A parancs kiadsakor a
	lekrt email cm s az azt lekr szemly naplzva lesz.

	Korltozva Szervz adminra.

NICK_SERVADMIN_HELP_FORBID
	Syntax: FORBID nicknv [indok]
	
	Nem engedlyezi, hogy brki regisztrlja a nicknevet 
	Akkor trlhet, ha droppolod a nicket.
	
	Egyes hlzatok indokot ignyelnek.
	
	Korltozva Szervz adminra.
	
###########################################################
#
# ChanServ help zenetek
#
###########################################################
	
NICK_SERVADMIN_HELP_SUSPEND
	Syntax: SUSPEND nickname reason / UNSUSPEND nickname

	SUSPENDs / UNSUSPENDs a nickname from being identified to
	
	Limited to Services admins.

###########################################################################
#
# ChanServ help messages
#
###########################################################################

NICK_SERVADMIN_HELP_UNSUSPEND
	Syntax: UNSUSPEND nickname

	UNSUSPENDS a nickname from being used.

	Limited to Services admins.

###########################################################################
#
# ChanServ help messages
#
###########################################################################
CHAN_HELP_CMD_GETPASS
	    GETPASS    Megadja a founder jelszt a csatornn
CHAN_HELP_CMD_FORBID
	    FORBID     Megakadlyozza a szoba hasznlatt
CHAN_HELP_CMD_SUSPEND
	    SUSPEND    Felfggeszti a szoba hasznlatt de
	               megrzi az adatokat s belltsokat.
CHAN_HELP_CMD_UNSUSPEND
	    UNSUSPEND  Trli a suspendet a csatornrl.
CHAN_HELP_CMD_STATUS
	    STATUS     Kirja a felhasznl aktulis hozzfrsi
	               szintjt a megadott csatornn
CHAN_HELP_CMD_REGISTER
	    REGISTER   Szoba regisztrlsa
CHAN_HELP_CMD_IDENTIFY
	    IDENTIFY   Azonosthatod magad a jelszavaddal
CHAN_HELP_CMD_SET
	    SET        Bellthatod a csatornd opciit
CHAN_HELP_CMD_AOP
	    AOP        AutoOpertor lista belltsa
CHAN_HELP_CMD_SOP
	    SOP        SzuperOpertor lista belltsa
CHAN_HELP_CMD_ACCESS
	    ACCESS     A szoba hozzfrsi listjnak belltsa
CHAN_HELP_CMD_LEVELS
	    LEVELS     tllthatod a szoba hozzfrsi szintjeit
CHAN_HELP_CMD_AKICK
	    AKICK      AutoKirgs listra teheted a "rossz" usereket
CHAN_HELP_CMD_DROP
	    DROP       Trlheted a csatornd regisztrcijt
CHAN_HELP_CMD_SENDPASS
	    SENDPASS   Elveszett a jelszavad? Jelsz klds.
CHAN_HELP_CMD_BAN
	    BAN        Bans a selected nick on a channel
CHAN_HELP_CMD_CLEAR
	    CLEAR      Tells ChanServ to clear certain settings on a channel
CHAN_HELP_CMD_DEVOICE
	    DEVOICE    Devoices a selected nick on a channel
CHAN_HELP_CMD_GETKEY
	    GETKEY     Returns the key of the given channel
CHAN_HELP_CMD_INFO
	    INFO       Lists information about the named registered channel
CHAN_HELP_CMD_INVITE
	    INVITE     Tells ChanServ to invite you or a given nick into a channel
CHAN_HELP_CMD_KICK
	    KICK       Kicks a selected nick from a channel
CHAN_HELP_CMD_LIST
	    LIST       Lists all registered channels matching the given pattern
CHAN_HELP_CMD_LOGOUT
	    LOGOUT     This command will logout the selected nickname
CHAN_HELP_CMD_OP
	    OP         Gives Op status to a selected nick on a channel
CHAN_HELP_CMD_TOPIC
	    TOPIC      Manipulate the topic of the specified channel
CHAN_HELP_CMD_UNBAN
	    UNBAN      Remove all bans preventing you from entering a channel
CHAN_HELP_CMD_VOICE
	    VOICE      Voices a selected nick on a channel
CHAN_HELP_CMD_VOP
	    VOP        Maintains the VOP (VOicePeople) list for a channel
CHAN_HELP_CMD_DEHALFOP
	    DEHALFOP   Dehalfops a selected nick on a channel
CHAN_HELP_CMD_DEOWNER
	    DEOWNER    Removes your owner status on a channel
CHAN_HELP_CMD_DEPROTECT
	    DEPROTECT  Deprotects a selected nick on a channel
CHAN_HELP_CMD_HALFOP
	    HALFOP     Halfops a selected nick on a channel
CHAN_HELP_CMD_HOP
	    HOP        Maintains the HOP (HalfOP) list for a channel
CHAN_HELP_CMD_OWNER
	    OWNER      Gives you owner status on channel
CHAN_HELP_CMD_PROTECT
	    PROTECT    Protects a selected nick on a channel
CHAN_HELP_CMD_ADMIN
	    ADMIN      Protects a selected nick on a channel
CHAN_HELP_CMD_DEADMIN
	    DEADMIN    Deprotects a selected nick on a channel
CHAN_HELP_CMD_DEOP
	    DEOP       Deops a selected nick on a channel

CHAN_HELP
	
	%S lehetsget ad arra, hogy regisztrld a csatorndat.
	%S hasznlatval elkerlhet a "take over" jelensg,
	amit az opjoggal visszal userek okozhatnak. Mg pedig
	gy, hogy meghatrozhat az, hogy ki kapjon a csatornn
	opertori kivltsgokat. A parancsok hasznlathoz rd be:
	%R%S parancs, ha tbb informci kell a paranccsal
	kapcsolatban, akkor rd be: %R%S HELP parancs.
	 
	
CHAN_HELP_EXPIRES
	
	Megjegyzs: azok a csatornk, amelyeket nem hasznlnak %d
	napig, automatikusan elvesztik regisztrcijukat.
	Automatikusan dropolsra kerlnek.
	
CHAN_HELP_REGISTER
	Syntax: REGISTER #szoba jelsz lers
	
	A csatorndat regisztrlja a %S adatbzisba.
	Hogy kiadhasd ezt a paracsot opertornak kell lenned
	az adott csatornn.
	A jelszt hasznlhatod az IDENTIFY parancs segitsgvel
	azonostsra, mieltt belltsokat eszkzlsz a 
	ksbbiekben az adott csatonn.
	
	Az utols paramternek, tartalmaznia kell
	a szoba ltalnos lerst.
	
	Amikor regisztrlsz egy csatornt, te leszel a "founder".
	szoba founderjnek van lehetsge a szoba belltsait,
	a hozzfrsi listjt, az autkirgs listt, az infkat
	megvltoztatni; a %S automatikusan megadja belpskor a
	founder hozzfrsi jogot s szoba opertori jogokat.
	Nzd meg az ACCESS parancsot (%R%S HELP ACCESS),
	hogy infomldj a klnbz szint kivltsgok adsrl
	(a szoba tbbi felhasznlja rszre).
	
	Megjegyzs: Ha regisztrlsz egy csatornt, elszr 
	regisztrlnod kell a nickneved s azonostanod kell
	magad. (%RNickServ identify jelsz)
	Ha mg nem nzted meg, akkor lsd mg: %R%s HELP.
	
CHAN_HELP_IDENTIFY
	Syntax: IDENTIFY #szoba jelsz
	
	%S a parancs bersa utn founder szintet ad a csatornn.
	Tbb parancs kiadsa eltt szksges, hogy hasznld ezt.
	A jelsznak egyeznie kell a megadott jelszval.
	
CHAN_HELP_LOGOUT
	Syntax: LOGOUT #szoba nicknv
	
	Ez a parancs kijelentkezsre birja a nicket, vagyis jra
	kell azonostania, hogy jra megkapja a hozzfrst.
	
	Ha te vagy a szoba founderje, akkor brkit ki tudsz
	jelentkeztetni, vagy ki tudsz jelentkezni akr te is.

CHAN_HELP_DROP
	Syntax: DROP #szoba
	
	Trli a megnevezett szoba regisztrcijt.
	Csak a szoba founder hasznlhatja, akinek
	elbb hasznlnia kell az IDENTIFY parancsot.

CHAN_HELP_SET
	Syntax: SET #szoba opci paramterek
	
	Lehetsget ad a foundernek, hogy a belltsokat
	s informcikat megvltoztassa.
	
	Elrhet opcik:
	
	    FOUNDER       A founder megvltoztatsa
	    SUCCESSOR     A successor megadsa
	    PASSWORD      A founder jelsz vltoztatsa
	    DESC          A szobameghatrozs llts
	    URL           Egy URL trstsa a szobhoz
	    EMAIL         Egy E-mail cm trstsa a szobhoz
	    ENTRYMSG      A szoba belpo zenetnek 
	                  lltsa
	    BANTYPE       A banols tipusnak belltsa
	    MLOCK         Szoba mdok lezrsa (+flag -flag)
	    KEEPTOPIC     Topic megtartsa ha a szoba nincs hasznlatban
	    OPNOTICE      zenetet kld az OP/VOICE parancsok hasznltrl
	    PEACE         Szablyozza a kritikus parancsok hasznlatt
	    PRIVATE       A szoba elrejtse a listbl
	    SECURE        Aktivlja a %S biztonsgi lehetsgeit
	    SECUREOPS     A csatornn az op sttusz szigor kezelse
	    SECUREFOUNDER Csatornn a founder sttusz szigor kezelse
	    SIGNKICK      Sign kickek, melyek a KICK paranccsal trtnnek
	    TOPICLOCK     Tmavlts letiltsa 
	    XOP           Xop (Sop, Aop, Hop, Vop) lista rendszer bekapcsolsa
	
	rd be: %R%S HELP SET opci bvebb informcirt az
	adott opcirl.

CHAN_HELP_SET_FOUNDER
	Syntax: SET #szoba FOUNDER nick
	
	Megvltoztatja a szoba founderjt.
	Az j nicknv regisztrlt kell hogy legyen!

CHAN_HELP_SET_SUCCESSOR
	Syntax: SET #szoba SUCCESSOR nick
	
	Megvltoztatja a successort a csatornn. Ha a founder neve
	elvl vagy trldik, de a szoba mg regisztrlt, akkor
	a successor lesz a szoba j founderje.
	Ha, a successornak mr tl sok regisztrlt csatornja van 
	(%d), a csatornnak megsznik a regisztrcija, akkor
	is ez trtnik, ha nem volt megadva successor.
	A nicknek regisztrlnak kell lennie.

CHAN_HELP_SET_PASSWORD
	Syntax: SET #szoba PASSWORD  jelsz
	
	Belltja a founder jelszt a csatornra, amivel
	a founder azonosthatja magt.

CHAN_HELP_SET_DESC
	Syntax: SET #szoba DESC lers
	
	Bellthat a szoba ltalnos meghatrozsa, ami ltszdni
	fog a  LIST s INFO parancs hasznlata esetn.

CHAN_HELP_SET_URL
	Syntax: SET #szoba URL [url]
	
	Egy URL trstsa a szobhoz. Ha van honlapja a szobnak,
	akkor brki megtudhatja, ha lekrte a szobrl az INFO-t.
	Ha nincs megadva paramter, akkor trli a meglv URL-t.

CHAN_HELP_SET_EMAIL
	Syntax: SET #szoba EMAIL [emailcm]
	
	Egy E-mail cm trstsa a szobhoz. Ha van E-mail cme
	a szobnak; akkor azt brki megtudhatja, ha lekrte
	a szobrl az INFO-t. Ha nincs megadva paramter akkor
	trli a meglv e-mail cmet.

CHAN_HELP_SET_ENTRYMSG
	Syntax: SET #szoba ENTRYMSG [zenet]
	
	Bellt egy zenetet, amit /notice formban fognak
	a szobba belp userek megkapni. Ha nincs paramter
	megadva akkor a szoba belp zenete trldik.

CHAN_HELP_SET_BANTYPE
	Syntax: SET #szoba BANTYPE bantpus
	
	A banols tpusnak belltsa, amit a Services akkor fog
	hasznlni, ha valakit banolni kell a csatornrl.
	
	A bantpus egy szm 0 s 3 kztt a jelentse:
	
	0: *!user@host formtum tilts
	1: *!*user@host formtum tilts
	2: *!*@host formtum tilts
	3: *!*user@*.domain formtum tilts

CHAN_HELP_SET_KEEPTOPIC
	Syntax: SET #szoba KEEPTOPIC {ON | OFF}
	
	Engedlyezi vagy letiltja a topic megtartsa opcit a
	szoba rszre.  Ha a topic megtartsa be van lltva,
	a topicot a %S megjegyzi miutn az utols user elhagyja a
	szobt, s visszalltja a kvetkez megnyitskor.

CHAN_HELP_SET_TOPICLOCK
	Syntax: SET #szoba TOPICLOCK {ON | OFF}
	
	Engedlyezi vagy letiltja a topic lezrsa opcit a 
	csatornn. Ha a topic lezrsa be van kapcsolva,a %S nem
	engedlyezi a csatornn a topic vltoztatst a TOPIC
	paranccsal.
	
CHAN_HELP_SET_MLOCK
	Syntax: SET #szoba  MLOCK mdok
	
	Bellthatod a mode-lock opcit a csatornn. A  %S
	lehetsget nyjt arra, hogy meghatrozd azokat a mdokat
	amelyek mindig be (vagy ki) lesznek kapcsolva. 
		
	A mdok felrakhatak a /MODE paranccsal is; 
	azok a mdok amelyek a + jel utn vannak lockoldnak,
	s azok a mdok amelyek a - jel utn vannak nem
	rakhatak fel a szobra.
	
	Figyelmeztets:  Ha belltasz egy mode-lock alatti 
	kulcsot, mint azt a msodik pldban ltod, akkor be kell
	lltanod a RESTRICTED opcit a csatornn (lsd 
	HELP	SET RESTRICTED) vagy brki belphet a szobba,
	amikor res s lehetsge lesz megltni a kulcsot!
	
	Pldk:
	
	    SET #szoba MLOCK +nt-ikl
	         Az  "n" s a "t" llandan fent van, s az "i", "k", s
	         "l" llandan ki lesz kapcsolva. Minden ms md 
	         felraksa-levtele szabad.
	
	    SET #szoba MLOCK +knst-ilmp my-key
	         A "k", "n", "s", s "t" llandan fent van, s az "i",
	         "l", "m", s a "p" ki lesz kapcsolva. A szobba val
	         belpshez szksges jelsz:	"my-key".
	
	    SET #szoba MLOCK +
	         Eltvoltja az sszes lockolt mdot.
	         Minden md szabadon ki/bekapcsolhat.
	
CHAN_HELP_SET_PEACE
	Syntax: SET #szoba PEACE {ON | OFF}
	
	Engedlyezi vagy letiltja a peace opcit.
	Amikor a peace be van lltva, akkor a userek nem,
	rghatnak ki, tilthatnak ki olyan usert akinek az vkkel
	egyenl vagy magasabb szintje van a %S parancsokhoz.
	
CHAN_HELP_SET_PRIVATE
	Syntax: SET #szoba PRIVATE {ON | OFF}
	
	Engedlyezi vagy letiltja a private opcit a csatornn.
	Amikor a private be van kapcsolva, a %R%S LIST 
	parancs ltal kilistzott csatornk kztt nem szerepel 
	a szoba.

CHAN_HELP_SET_RESTRICTED
	Syntax: SET #szoba RESTRICTED {ON | OFF}
	
	Engedlyezi vagy letiltja a korltozott hozzfrs
	opcit a csatornn. Amikor a korltozott hozzfrs
	be van kapcsolva, a userek nem kaphatnak szoba
	opertori jogokat (userek negatv access szinttel,
	ha a secure opsopci be van kapcsolva, akkor azok a
	userek, akik nem szerepelnek az access listn) azonnal
	ki lesznek rgva s tiltva a szobbl belpskor.
	
CHAN_HELP_SET_SECURE
	Syntax: SET #szoba SECURE {ON | OFF}
	
	Engedlyezi vagy letitlja a %S biztonsgi lehetsgeit
	a szobban. Ha SECURE mkdik, csak azok a felhasznlk
	akik regisztrltak s beazonostottak a %s-be a	
	jelszavukkal (hasznlvn az IDENTIFY parancsot) kaphatnak
	a szobban jogokat, ha szerepelnek a hozzfrsi listn.
	
CHAN_HELP_SET_SECUREOPS
	Syntax: SET #szoba SECUREOPS {ON | OFF}
	
	Bekapcsolja vagy letiltja a secure ops opcit.
	Amikor a secure ops be van kapcsolva, akkor azok, akik 
	nem szerepelnek a hozzfrsi listn nem kaphatnak szoba
	opertori sttuszt.
	
CHAN_HELP_SET_SECUREFOUNDER
	Syntax: SET #szoba SECUREFOUNDER {ON | OFF}
	
	Engedlyezi vagy letiltja a secure founder opcit a 
	csatornn. Amikor a secure founder be van lltva, csak
	a valdi founder tudja dropolni a csatornt, trni a 
	szoba jelszavt, foundert, jogutdjt, de azok nem,
	akik csak az IDENTIFY parancsot hasznltk a %S-ben.
	
CHAN_HELP_SET_SIGNKICK
	Syntax: SET #szoba SIGNKICK {ON | SZINT | OFF}
	
	Engedlyezi vagy letiltja a signed kick opcit a csatornn
	Amikor a SIGNKICK be van lltva, a %S KICK parancsval
	vgrehajtott kirgsokban az indokban szerepel az op neve.
	
	Ha hasznlod a LEVEL-t, akkor azok, akiknek a szintje
	megegyezik vagy magasabb, mint a signkick szintje, azoknak
	a neve nem fog szerepelni a kick indokjban.
	Lsd mg: %R%S HELP LEVELS bvebb informcikrt. 
	
CHAN_HELP_SET_XOP
	Syntax: SET #szoba XOP {ON | OFF}
	
	Engedlyezi vagy letiltja az xOP lista rendszert.
	Ha az XOP be van kapcsolva, akkor AOP/SOP/VOP
	parancsokkal osztogathatod a csatornn a privilgiumokat
	a usereknek, msklnben az ACCESS parancsot hasznlod.
	
	Az xOP lista rendszerrl az access lista rendszerre val 
	ttrs nem okoz gondot.
	
CHAN_HELP_SET_OPNOTICE
	Syntax: SET #szoba OPNOTICE {ON | OFF}
	
	Be/kikapcsolja az opnotice opcit a csatornn.
	Amikor az op-notice be van kapcsolva, a %S megjegyzst
	fog kldeni a csatornra, amikor a felhasznlk hasznljk
	az OP, VOICE, vagy a hozzjuk kapcsold parancsokat a
	szoban.
	
CHAN_HELP_AOP
	Syntax: AOP #szoba ADD nick
	        AOP #szoba  DEL {nick  |  sorszm  |  lista }
	        AOP #szoba LIST [ maszk  |  lista ]
	        AOP #szoba CLEAR
	
	Karbantartja az AOP(AutoOP) listt a csatornn. Az AOP 
	listn szerepl userek automatikusan megkapjk belpskor 
	az opertor sttuszt, unbanhatjk magukat, meghvhatjk 
	magukat a csatornra,megjelenithetik a ksznt zenetket
	stb.
	
	Az AOP ADD paranccsal hozzadhatsz egy nickenevet a 
	csatornd AOP listjhoz.
	
	Az AOP DEL paranccsal eltvolthatsz egy megadott 
	nicknevet a csatornd AOP listjrl. Ha sorszmokat 
	intervallumban adunk meg (lsd a listzsnl), akkor a 
	megadott bejegyzsek kerlnek trlsre.
	
	Az  AOP LIST parancs megadja az AOP listt.
	Ha nem vagyunk kivncsiak a teljes listra akkor a 
	listban szerepl Aop sorszmt megadva is megtudhatjuk a
	nevt, megadhatunk intervallumot is.
	
	Pldk:
	
		AOP #szoba LIST 2-5,7-9
			Listzza az AOP-okat 2 s 5 kztt s
			7-tol  9-ig.
	      
	Az AOP CLEAR parancs kiriti a szoba AOP listjt.
	
	Az AOP ADD s AOP DEL parancsokat csak SOP vagy 
	magasabb szinttel rendelkezo userek hasznlhatjk, de az
	AOP CLEAR parancsot csak a szoba foundere adhatja ki.
	Habr, minden AOP listn szereplo user hasznlhatja az
	AOP LIST parancsot.
	
	Ezt a parancsot letilthatod a csatorndon, s helyette 
	hasznlhatod az access lista rendszert. Nzd meg: %R
	%S HELP ACCESSbvebb informcirt az access listrl, s
	rd be: %R%S HELP SET XOP hogy megnzd, hogyan tudsz 
	vltani az xOP rendszerrol az access lista rendszerre.
	
CHAN_HELP_HOP
	Syntax: HOP  #szoba ADD nick
	        HOP #szoba DEL { nick  |  sorszm  |  lista}
	        HOP #szoba LIST [ maszk | lista ]
	        HOP #szoba CLEAR
	
	Karbantartja az HOP (HALFOP) listt a csatornn. A HOP
	listn szerepl userek automatikusan megkapjk belpskor
	a flopertor sttuszt.
	
	HOP ADD paranccsal hozzadhatsz egy nickenevet csatornd
	HOP listjhoz.
	
	HOP DEL paranccsal eltvolthatsz egy megadott nicknevet
	a csatornd HOP listjrl. Ha sorszmokat intervallumban
	adunk meg (lsd a listzsnl),akkor a megadott bejegyzsek
	kerlnek trlsre.
	
	Az  HOP LIST parancs megadja az HOP listt. Ha nem vagy 
	kivncsi a teljes listra akkor a listban szerepl HOP 
	sorszmt megadva is megtudhatjuk a nevt, megadhatunk 
	intervallumot is.
	
	Pldk:
	
		HOP #szoba LIST 2-5,7-9
		Listzza az HOP-okat 2 s 5 kztt s
		7-tol  9-ig.
	      
	Az HOP CLEAR parancs kiriti a szoba HOP listjt.
	
	Az HOP ADD s HOP DEL parancsokat csak AOP / magasabb
	szinttel rendelkez userek hasznlhatjk,de az HOP CLEAR
	parancsot csak a szoba foundere adhatja ki.
	Habr, minden HOP listn szereplo user hasznlhatja az
	HOP LIST parancsot.
	
	Ezt a parancsot letilthatod a csatorndon, s helyette 
	hasznlhatod az access lista rendszert. Nzd meg: %R
	%S HELP ACCESS bvebb informcirt az access listrl,
	s rd be: %R%S HELP SET XOP hogy megnzd, hogyan 
	tudsz vltani az xOP rendszerrl access lista rendszerre.
	
CHAN_HELP_SOP
	Syntax: SOP #szoba ADD nick
	        SOP #szoba DEL { nick  |  sorszm  |  lista }
	        SOP #szoba LIST [ maszk | lista ]
	        SOP #szoba CLEAR
	
	Karbantartja az SOP(SuperOP)listt a csatornn. Az SOP
	listn szereplo userek automatikusan megkapjk ugyanazokat
	amiket az AOP listn szereplok,s emellett lehetsgk van
	AKICK listt mdostani, szoba memo zeneteket olvasni 
	s kldeni, BadWords listt szerkeszteni, stb.
	
	Az SOP ADD paranccsal hozzadhatsz egy nickenevet a 
	csatornd SOP listjhoz.
	
	Az SOP DEL paranccsal eltvolthatsz egy megadott 
	nicknevet a csatornd SOP listjrl. Ha sorszmokat 
	intervallumban adunk meg (lsd a listzsnl), akkor a
	megadott bejegyzsek kerlnek trlsre.
	
	Az  SOP LIST parancs megadja az SOP listt. Ha nem 
	vagy kivncsi a teljes listra akkor a listban szerepl
	SOP sorszmt megadva is megtudhatjuk a nevt, megadhatunk
	intervallumot is.
	
	Pldk:
	
		SOP #szoba LIST 2-5,7-9
			Listzza az SOP-okat 2 s 5 kztt s
			7-tl  9-ig.
	
	Az SOP CLEAR parancs kiriti a szoba SOP listjt.
	
	Az SOP ADD, SOP DEL s SOP CLEAR parancsokat csak a
	founder szintu userek hasznlhatjk. Habr, minden SOP 
	listn szereplo user hasznlhatja az SOP LIST parancsot.


	
	Ezt a parancsot letilthatod a csatorndon, s helyette 
	hasznlhatod az access lista rendszert. Nzd meg: %R
	%S HELP ACCESS bvebb informcirt az access listrl,
	s rd be: %R%S HELP SET XOP hogy megnzd, hogyan 
	tudsz vltani az xOP rendszerrl access lista rendszerre.
	
CHAN_HELP_VOP
	Syntax: VOP #szoba ADD nick
	        VOP #szoba DEL {nick | sorszm| lista}
	        VOP #szoba LIST [maszk | lista]
	        VOP #szoba CLEAR
	
	Karbantartja az VOP (VoiceOP) listt a csatornn. VOP 
	listn szerepl userek belpskor automatikusan hangadi 
	jogot (+v) kapnak, hasznlhatjk a voiceme parancsot. 
	
	Az VOP ADD paranccsal hozzadhatsz egy nickenevet a 
	csatornd VOP listjhoz.
	
	A VOP DEL paranccsal eltvolthatsz egy nicknevet a 
	csatornd VOP listjrl. Ha sorszmokat intervallumban
	adunk meg (lsd a listzsnl), akkor a megadott 
	bejegyzsek kerlnek trlsre.
	
	Az  VOP LIST parancs megadja az VOP listt. Ha nem 
	vagyunk kivncsiak a teljes listra akkor a listban
	szerepl VOP sorszmt megadva is megtudhatjuk a nevt,
	megadhatunk intervallumot is.
	
	Pldk:
	
		VOP #szoba LIST 2-5,7-9
			Listzza az VOP-okat 2 s 5 kztt s
			7-tl  9-ig.
	      
	Az VOP CLEAR parancs kiriti a szoba VOP listjt.
	
	Az VOP ADD, VOP DEL s VOP LIST parancsokat csak az
	AOP vagy magasabb szintu userek hasznlhatjk.
	A VOP CLEAR parancsot csak a founder hasznlhatja.
	
	Ezt a parancsot letilthatod a csatorndon, s helyette 
	hasznlhatod az access listt. Nzd meg: %R%S HELP 
	ACCESS bvebb informcirt az access listrl, s rd
	be: %R%S HELP SET XOP hogy megnzd, hogyan tudsz 
	vltani az xOP rendszerrol az access lista rendszerre.
	
CHAN_HELP_ACCESS
	Syntax:	ACCESS #szoba ADD nick szint
			ACCESS #szoba DEL {nick | sorszm | lista}
			ACCESS #szoba LIST [maszk | lista]
			ACCESS #szoba CLEAR
	
	Access lista a csatornn. A hozzfrsi lista (access)
	meghatrozza, hogy mely userek kaphatnak op sttuszt vagy
	hozzfrst a %S parancsokhoz a csatornn. Klnbz
	user szintek lehetsget adnak arra, hogy eltr jogokat 
	kaphassanak; informcirt %R%S HELP ACCESS LEVELS.
	A nick, amely nem szerepel az access listn 0-s szint.
	
	Az ACCESS ADD paranccsal hozzadhat a nicknv az
	access listhoz a megadott szinttel; ha a nick szerepel
	a listn,akkor a szintje vltozik csak meg. A szintamit
	meghatrozol, kisebb kell, hogy legyen a te szintednl s
	ha a nick mr szerepel a listn, akkor a jelenlegi 
	szintjnek a tidnl alacsonyabbnak kell lennie.
	
	Az ACCESS DEL trli a nicknevet az access listrl.
	Ha intervallumot adsz meg, akkor minden benne szerepl
	nicknevet trlsz.
	
	Az ACCESS LIST paranccsal megtekintheto az access lista.
	Ha intervallumot is megadsz, akkor abban az intervallumban
	szerepl nicknevek listzsa fog megtrtnni.
	
	ACCESS #szoba LIST 2-5,7-9
		Listzza azokat a usereket, akik 2 s 5 kztt illetve
		7-tl 9-ig szerepelnek a listn.
	
	Az ACCESS CLEAR parancs trl minden bejegyzs a szoba
	hozzfrsi listjrl.
	
CHAN_HELP_ACCESS_LEVELS
	Felhasznli hozzfrsi szintek
	
	Alapbl, a kvetkez hozzfrsi szintek rvnyesek:
	   
	   Founder   Teljes hozzfrs a %S funkcikhoz; automatikus
	                     opjog a csatornra val belpskor.
	                     Megjegyzs, csak egy embernek lehet founder sttusza
	                     (nem adhat az ACCESS paranccsal).
	        10   Hozzfrs az AKICK parancshoz; automatikus op.
	         5   Automatikus op sttusz.
	         3   Automatikus voice sttusz.
	         0   Nincs klnleges privilgiuma; opolhat ms
	                     opok ltal(ha a secure-ops ki van kapcsolva).
	        <0   Nem opolhat.
	
	Ezek a szintek vltozhatnak, vagy jakat adhatsz hozz, a
	LEVELS paranccsal; rd be: %R%S HELP LEVELS bvebb
	informcirt.
	
CHAN_HELP_AKICK
	Syntax: AKICK #szoba ADD maszk [indok]
	        AKICK #szoba STICK maszk
	        AKICK #szoba UNSTICK maszk
	        AKICK #szoba DEL maszk
	        AKICK #szoba LIST [maszk]
	        AKICK #szoba VIEW [maszk]
	        AKICK #szoba ENFORCE
	        AKICK #szoba CLEAR
	
	Karbantarthatod a csatornhoz tartoz autokirgs listt
	Ha egy olyan felhasznl, akinek a maszkja megegyezik egy 
	az akick listn szerepel maszkkal megprobl belpni a 
	csatornra,	akkor a %S kitiltja s aztn kirgja.
		
	Az AKICK ADD parancs hozzadja a megadott nicket
	vagy usermaszkot az AutoKick listhoz. Ha megadsz 
	indokot is a parancsban, akkor ezzel az indokkal
	fogja kirgni a ChanServ az illett, ha nincs 
	megadva, akkor az alapbellts szerinti indok:
	"You have been banned from the channel".
	
	Az AKICK STICK paranccsal vglegesen kitiltod az
	adott maszkot a csatornrl. Ha valaki megprblja 
	levenni a bant, a %S automatikusan visszateszi.
	Ezt nem hasznlhatod regisztrlt nevekre.
	
	Az AKICK UNSTICK parancs trli a hatst az
	AKICK STICK parancsnak, teht ismt lehetsged
	lesz levenni a tiltst a csatorndrl.
	
	Az AKICK DEL parancs eltvoltja a megadott maszkot az
	autokirgs listrl.
	Ez nem mkdik, hacsak nem tvoltunk el minden az adott
	nickre, identre, hostra szol tiltst, ami az autkirugs
	listn szerepel; mindegyiket egyenknt kell trlni.
	
	Az AKICK LIST parancs megjelenti az autkirgs listt,
	vagy optionlis esetben csak azokat jeleniti meg, amelyek
	egyeznek a megadott maszkkal.
	
	Az AKICK VIEW ugyanaz, mint a AKICK LIST, de tbb
	rszletet jelent meg.
	
	AKICK ENFORCE hatsra a %S ellenrzi az akick listt
	s eltvolt minden usert, aki szerepel a listn.
	
	AKICK CLEAR paranccsal az sszes akick lista bejegyzs 
	trlhet.
	
CHAN_HELP_LEVELS
	Syntax:	LEVELS #szoba SET tpus szint
			LEVELS #szoba {DIS | DISABLE} tpus
			LEVELS #szoba LIST
			LEVELS #szoba RESET
	
	A LEVELS segtsgvel a szmokkal definilt hozzfrsi
	szintek mdosthatk.
	Ezzel a paranccsal,  definilhatsz hozzfrsi szinteket, 
	melyek szksgesek a  %S funkciihoz.
	Ezt a parancsot csak a founder hasznlhatja.
	
	LEVELS SET biztostja, hogy megvltoztasd a hozzfrsi
	szintjt egy adott funkcinak vagy funkcik csoportjnak.
	
	A LEVELS DISABLE (vagy DIS rviden) letiltja
	az automatikus lehetsgeket, vagy megtiltja a hozzfrst
	bizonyos funkcikhoz, ezeket csak a founder vltoztathatja
	
	LEVELS LIST kirja a jelenlegi hozzfrsi szintjeit
	a klnbz funkciknak.
	
	LEVELS RESET visszalltja az alaprtelmezett rtkeket.
	Lsd mg: HELP ACCESS LEVELS.
	
	Ha szeretnd megnzni a funkcik s lehetsgek listjt.
	akkor lesd meg a HELP LEVELS DESC lerst is.
	
CHAN_HELP_LEVELS_DESC
	A kvetkez lehetsgek/funkcik elrthetek.
	Megjegyzs: az AUTODEOP s NOJOIN esetn maximum szintrl
	az sszes tbbi esetn minimum szintrl van sz.
	
CHAN_HELP_LEVELS_DESC_FORMAT
	    %-*s  %s
	
CHAN_HELP_INFO
	Syntax: INFO #szoba [ALL]
	
	Listzza az sszes informcit a megnevezett regisztrlt
	csatornrl, pl a foundert, a regisztrls idpontjt,
	az utols hasznlat idejt, a lerst, az mlock-ot.  
	Ha beazonostottad magad a szoba founderjnek, akkor
	teljes informcit az ALL paramterrel kaphatsz, az 
	entrymessage, a successor s a rejtett infk is ltszdnak
	
	Alapbl az ALL opci csak a foundernek engedlyezett.

CHAN_HELP_LIST
	Syntax: LIST pattern
	
	Listzza a regisztrlt csatornkat.
	(Ahol a PRIVATE opci be van kapcsolva nem fog
	 megjelenni a listban.)

CHAN_HELP_OP
	Syntax: OP [#szoba [nick]]
	
	Opolja a megadott nicket a megadott csatornn.
	Ha nem adsz meg nicket, magadat opolod.
	Ha nem adsz meg csatornt s nicket se, akkor minden
	csatornn (ahol bent vagy) opolod magad,
	ahol meg van hozz a jogod.
	
	Alap bellts szerint csak a minimum AOP listn
	vagy 5-s accessen szereplo userek hasznlhatjk.
	
CHAN_HELP_DEOP
	Syntax: DEOP [#szoba [nick]]
	
	Deopolja a megadott nicket a megadott csatornn.
	Ha nem adsz meg nicket, magadat deopolod.
	Ha nem adsz meg csatornt s nicket se, akkor minden
	csatornn (ahol bent vagy) deopolod magad,
	ahol meg van hozz a jogod.
	
	Alap bellts szerint csak a minimum AOP listn
	vagy 5-s access szinten szereplo userek hasznlhatjk.
	
CHAN_HELP_VOICE
	Syntax: VOICE [#szoba [nick]]
	
	Voiceolja a megadott nicket a megadott csatornn.
	Ha nem adsz meg nicket, magadat voiceolod.
	Ha nem adsz meg csatornt s nicket se, akkor minden
	csatornn (ahol bent vagy) voiceolod magad, ahol megvan
	hozz a jogod.
	
	Alap bellts szerint csak a minimum AOP listn
	vagy 5-s accessen szereplo userek hasznlhatjk vagy min.
	a VOP listn vagy 3-as access szinten szereplo userek
	hasznlhatjk sajt maguk voiceolsra.
	
CHAN_HELP_DEVOICE
	Syntax: DEVOICE [#szoba [nick]]
	
	Elveszi a voiceot a megadott nicktl a megadott csatornn.
	Ha nem adsz meg nicket, magadatl veszed el.
	Ha nem adsz meg csatornt s nicket se, akkor minden
	csatornn (ahol bent vagy) elveszed magadtl, ahol
	meg van hozz a jogod.
	
	Alap bellts szerint csak a minimum AOP listn vagy
	5-s accessen szerepl userek hasznlhatjk vagy min.
	a VOP listn vagy 3-as access szinten szereplo userek
	hasznlhatjk sajt maguktl elvenni voiceot.
	
CHAN_HELP_HALFOP
	Syntax: HALFOP [#szoba [nick]]
	
	Flopot ad a megadott nicknek a megadott csatornn.
	Ha nem adsz meg nicket, magadnak adsz.
	Ha nem adsz meg csatornt s nicket se, akkor minden
	csatornn (ahol bent vagy) magadnak adsz flopot, ahol
	meg van hozz a jogod.
	
	Alap bellts szerint csak a minimum AOP listn vagy
	5-s accessen szereplo userek hasznlhatjk vagy min.
	a HOP listn vagy 4-es access szinten szerepl userek
	hasznlhatjk sajt maguknak flop adsra.
	
CHAN_HELP_DEHALFOP
	Syntax: DEHALFOP [#szoba [nick]]
	
	Elveszi a flopot a megadott nicktl a megadott csatornn.
	Ha nem adsz meg nicket, magadatl veszed el.
	Ha nem adsz meg csatornt s nicket se, akkor minden
	csatornn (ahol bent vagy) elveszed magadtl a flopot,
	ahol meg van hozz a jogod.
	
	Alap bellts szerint csak a minimum AOP listn vagy
	5-s accessen szereplo userek hasznlhatjk vagy min.
	a HOP listn vagy 4-es access szinten szerepl userek
	hasznlhatjk, hogy sajt maguktl elvegyk a flopot
	
CHAN_HELP_PROTECT
	Syntax: PROTECT [#szoba [nick]]
	
	Protectet ad a megadott nicknek a megadott csatornn.
	Ha nem adsz meg nicket, magadat protecteled.
	Ha nem adsz meg csatornt s nicket se, akkor minden
	csatornn (ahol bent vagy) protectet adsz magadnak,
	ahol meg van hozz a jogod.
	
	Alap bellts szerint csak a founder tudja hasznlni,
	vagy minimum a SOP listn vagy 10-es access szinten
	szerepl userek hasznlhatjk sajt maguk protectolsra.

CHAN_HELP_DEPROTECT
	Syntax: DEPROTECT [#szoba [nick]]
	
	Elveszi a protectet a nicktl a megadott csatornn.
	Ha nem adsz meg nicket, magadat deprotecteled.
	Ha nem adsz meg csatornt s nicket se, akkor minden
	csatornn (ahol bent vagy) elveszed a protectet magadtl,
	ahol meg van hozz a jogod.
	
	Alap bellts szerint csak a founder tudja hasznlni,
	vagy min. az SOP listn vagy 10-es access szinten
	szerepl userek hasznlhatjk maguk deprotectolsra.
	
CHAN_HELP_OWNER
	Syntax: OWNER [#szoba]
	
	Tulajdonosi sttuszt ad a csatornn. Ha a szoba nincs
	megadva, akkor minden csatornn, ahol bent vagy ownert 
	kapsz, ahol meg van ehhez van jogod is.
	
	Csak founder szint user hasznlhatja.
	
CHAN_HELP_DEOWNER
	Syntax: DEOWNER [#szoba]
	
	Elveszi a tulajdonosi sttuszt a csatornn.Ha a szoba
	nincs megadva, akkor mindenhol, ahol bent vagy elveszed
	magadtl az ownert, ahol meg van ehhez van jogod is.
	
	Csak founder szintu user hasznlhatja.
	
CHAN_HELP_INVITE
	Syntax: INVITE #szoba
		
	Utastja a %S-et, hogy hvjon meg a megadott csatornra.
	
	Alapbellts szerint, min. AOP vagy 5-s access szinttel
	kell rendelkezned a csatornn, hogy hasznlhasd.
	
CHAN_HELP_UNBAN
	Syntax: UNBAN #szoba
	
	A %S leveszi rlad a kitiltst s szabadon
	belphetsz a csatonra.
	
	Alapbellts szerint, min. AOP vagy 5-s access szinttel
	kell rendelkezned, hogy hasznlhasd.	
	
CHAN_HELP_KICK
	Syntax: KICK [#szoba [nick [indok]]]
	
	A ChanServ kirgja a megadott nicknevet a csatornrl.
	Ha nem adsz meg nicket, akkor tged fog kirgni.
	Ha nem adsz meg szobt s nicket sem, akkor tged
	fog minden csatornrl, ahol bent vagy kirgni, ha
	meg van a parancs hasznlathoz a szksges szinted.
	
	Alapbellts szerint, min. AOP vagy 5-s access szinttel
	kell rendelkezned a csatornn, hogy hasznlhasd.
	
CHAN_HELP_BAN
	Syntax: BAN [#szoba [nick [indok]]]
	
	Kitilt egy kivlaszott nicket a csatornrl.
	Ha nem adsz meg nevet akkor tged tilt ki, ha
	nem adsz meg csatit s nicket, akkor minden csatornrl
	ahol bent vagy s van jogod r, onnan kitilt.
	
	Alapbellts szerint, minimum AOP vagy 5-s access 
	szinttel kell rendelkezned a csatornn, hogy hasznlhasd.
	
CHAN_HELP_TOPIC
	Syntax: TOPIC #szoba [tma]
	
	A %S megvltoztatja a szoba tmjt arra amit
	megadtl. Ha a tma nincs megadva, akkor egy res
	topicot llt be. Ez a parancs hasznos, akkor ha a 
	SET TOPICLOCK be van lltva. Hasznld a %R%S HELP
	SET TOPICLOCK parancsot bvebb informcirt.
	
	Alapbl a szoba founder szint userei hasznlhatjk
	csak a csatornn. 
	
CHAN_HELP_CLEAR
	Syntax: CLEAR #szoba mit?
	
	A %S eltvoltja a belltsokat a csatornn. 
	A kvetkez opcik lehetsgesek:
	
	    MODES    Trli az sszes mdot ami nem szerepel a szoba
	             mode lockjban.
	    BANS     Trli az sszes tiltst a csatornn.
	    EXCEPTS  Trli az sszes kivtelt a csatornn.
	    OPS      Elvesz minden opot a csatornn
	    HOPS     Eltvolt minden flop csatorna sttuszt (+h md)
	             az sszes csatornn lv flopertortl, ha tmogatott.
	    VOICES   Elvesz minden "voice"-t (mode +v) a csatornn.
	    USERS    Eltvolt minden usert a csatornrl (kirgs).
		
	Alapbelltsban, a founder szint userek hasznlhatjk.
	
CHAN_HELP_GETKEY
	Syntax: GETKEY #szoba 
	
	Megadja a szoba kulcsot. Ez a parancs kimondottan hasznos
	botok s/vagy scriptek szmra, teht a kimeneti rsz
	a kvetkezkppen nz ki:
	
	KEY <szoba> <kulcs>
	
	A kulcs "NO KEY", ha nincs kulcs belltva.
	
CHAN_HELP_SENDPASS
	Syntax: SENDPASS #szoba
	
	Elkldi E-mailben a csatorndra belltott jelszt. Neked
	a szoba founderjnek kell lenned, hogy hasznlhasd ezt
	a parancsot s elszr azonostanod kell magadat.
	
	Lehet korltozni IRC operatorok rszre a hlzaton.
	
	A parancs nem hasznlhat ha az encryption engedlyezett.
	
CHAN_SERVADMIN_HELP
	
	Szervz adminok tudjk droppolni a csatornkat anlkl, 
	hogy a szoba jelszt hasznlnnak, s megnzhetika az
	access, AKICK, s bellitsi szint listt a csatornn.
	
CHAN_SERVADMIN_HELP_LOGOUT
	Syntax: LOGOUT #szoba [nicknv]
	
	A parancs naplzza a kijelentekeztetst, neki jra kell
	azonostani magukat,hogy visszakapjk a hozzfrseiket.	
	
	Ha ta  vagy a csatrna alpt, kpes vagy kijelentkeztetni
	mst, te kpes vagy magad is.	
	
	Ha szervz admin vagy akkor kijelentekeztethetsz valakit a 
	csatornrl anlkl, hogy te lennel a founder.Elhagyhatod
	a nincnv paramtert, s akkor az sszes bejelentkezett 
	felhasznlt kijelentkezteted a csatornrl.	

CHAN_SERVADMIN_HELP_DROP
	Syntax: DROP #szoba
	
	Trli a regisztrcit a csatornrl.Csak Services admins
	droppolhat csatornt,gy hogy nem hasznlja a szoba
	jelszavt.
	
CHAN_SERVADMIN_HELP_SET
	
	Szervz admin bellthatja a csatornt NEMELVL -re,
	ekkor a sorban megelzi az elvlket. A szervz 
	adminisztrtor bellthatja anlkl, hogy szoba
	jelszt hasznln.	
	
CHAN_SERVADMIN_HELP_SET_NOEXPIRE
	Syntax: SET #szoba NOEXPIRE {ON | OFF}
	
	Belltja a szoba elvlst.  Bellitva az
	ON paranmtert megelzi az elvl csatornkat.
	
	Korltozva Szervz adminnak.


CHAN_SERVADMIN_HELP_INFO
	
	Szervz adminok hasznlhatjk az ALL paramtert.
	
CHAN_SERVADMIN_HELP_LIST
	Syntax: LIST pattern[FORBIDDEN] [SUSPENDED] [NOEXPIRE]
	
	Lists all registered channels matching the given pattern.
	Channels with the PRIVATE option set will only be displayed
	to Services admins. Channels with the NOEXPIRE option set 
	will have a ! prepended to the channel name for Services admins.
	
	If the FORBIDDEN, SUSPENDED or NOEXPIRE options are given, only 
	channels which, respectively, are FORBIDden, SUSPENDed or have 
	the NOEXPIRE flag set will be displayed.  If both options are 
	given, both types of channels will be displayed. These options are 
	korltozva szervz adminnak.
	
CHAN_SERVADMIN_HELP_GETPASS
	Syntax: GETPASS #szoba
	
	Kiirja a szoba jelszavt.  Jegyzet brmikor hasznljk a
	parancsot, egy zenetet kap aki kiadta a parancsot s a szoba
	is ahol volt hasznlva kld egy WALLOPS/GLOBOPS zenetet.
	
	Korltozva Szervz adminnak.
	
CHAN_SERVADMIN_HELP_FORBID
	Syntax: FORBID #szoba [indok]
	
	Letiltja a szoba hasznlatt.
	Csak droppols utn lehet a csatornt hasznlni.
	
	Indoklst szksges egyes hlzatokon.
	
	Korltozva Szervz adminnak.
	
CHAN_SERVADMIN_HELP_SUSPEND
	Syntax: SUSPEND #szoba [indok]

	Elutast minden szobahasznlatot. Lehet trlni a
	UNSUSPEND paranccsal s akkor hasznlhat az sszes 
	megrztt szoba adat/bellts.
	
	Indoklst kr nmelyik hlzat.
	
	Korltozva Szervz adminnak.
	
CHAN_SERVADMIN_HELP_UNSUSPEND
	Syntax: UNSUSPEND #szoba
	
	Trli a suspendet a csatornrl. sszes adat s bellts
	megrizve a suspend hasznlat elttrl.
	
	Korltozva Szervz adminnak.
	
CHAN_SERVADMIN_HELP_STATUS
	Syntax: STATUS  #szoba nicknv
	
	Kiirja a nicknv aktulis hozzfrsi szintjt a megadott
	csatornn. 	Vlasz a kvetkez formban::
	
	    STATUS szoba nicknv access-szint
	
	Ha hiba trtnik akkor a vlasz a kvetkez formtun:
	
	    STATUS ERROR Hiba - zenet
	
	Korltozva Szervz adminnak.
	
###########################################################
#
# MemoServ help zenetek
#
###########################################################
MEMO_HELP_CMD_SEND
	    SEND   zenetet kld egy nicknek vagy csatornra
MEMO_HELP_CMD_CANCEL
	    CANCEL Visszavonja az utoljra kldtt memot
MEMO_HELP_CMD_LIST
	    LIST   Megjelenti az zenetek listjt
MEMO_HELP_CMD_READ
	    READ   Elolvassa a megadott zenete(ke)t
MEMO_HELP_CMD_DEL
	    DEL    Trli a megadott zenete(ke)t
MEMO_HELP_CMD_SET
	    SET    zenetekkel kapcsolatos belltsokat hajt vgre
MEMO_HELP_CMD_INFO
	    INFO   Kirja az zenetekkel kapcsolatos informcikat
MEMO_HELP_CMD_RSEND
	    RSEND  Memo zenetet kld s olvassi visszaigazolst kr
MEMO_HELP_CMD_CHECK
	    CHECK  Ellenrzi, hogy a cmzett elolvasta-e mr az zit
MEMO_HELP_CMD_SENDALL
	    SENDALL Memo kldse minden regisztrlt felhasznlnak.
MEMO_HELP_CMD_STAFF
	    STAFF Memo kldse minden opernek/adminnak.

MEMO_HELP_HEADER
	%S lehetsget nyjt az IRC felhasznlkank, hogy rvid
	zeneteket kldjenek ms IRC felhasznlk rszre,
	akkor is, ha a fogad fl nem online, s csatornkra (*).
	Ahhoz, hogy zenetet lehessen kldeni, mind a kld s a
	fogad fl nicknevnek regisztrltnak kell lennie.
		
	%S parancsok a kvetkezket tartalmazzk:
	
	
MEMO_HELP_ADMIN
	not used.
MEMO_HELP_OPER
	not used.
MEMO_HELP_FOOTER
	
	A parancsokkal kapcsolatos tovbbi segtsgrt
	rd be: %R%S HELP parancs.
	
	(*) Alapbl, brmelyik user, minimum 10-es szinttel
	olvashatja a szoba memo zeneit. Ez megvltoztathat a
	%s LEVELS paranccsal.
	
MEMO_HELP_SEND
	Syntax: SEND { nick  |  #szoba } memo-szveg
	
	zenetet kld a megnevezett nicknek vagy csatornra
	a zenet-szvegt tartalmazva. Amikor nicknvnek kldesz
	a cmzett kap egy zenetet az j zenet rkezsrl
	A cmzett csatornnak vagy nicknvnek regisztrltnak kell
	lennie.
	
MEMO_HELP_CANCEL
	Syntax: CANCEL { nick  |  #szoba }
	
	Visszavonja az utols memo zenetet, amit a nicknek
	vagy csatornnak kldtl.
	
MEMO_HELP_LIST
	Syntax: LIST [#szoba] [list | NEW]
	
	Megjelent egy listt a jelenlegi zenteteidrol. A NEW
	opcival csak az j (olvasatlan) zenteket listzza.
	listzza. Az olvasatlan zeneteket jelli egy "*" jellel
	az zenetszmtl balra. Megadhatsz szmlistt is, mint
	ahogy az albbi plda mutatja:
	
		LIST 2-5,7-9
			Listzza az zeneteket 2 s 5, illetve 7 s 9 kztt.
	
MEMO_HELP_READ
	Syntax: READ [#szoba] {sorszm| list| LAST | NEW}
	
	Elkldi a megadott zenetek tartalmt. A LAST opcival
	megjelenti a legutols zenetet. A NEW opcival
	minden j zenetet. Egybknt a megadott szm zenetet.
	Megadhatsz szmlistt is, mint a LIST parancsnl.
	
	Pldk:
	
		READ 2-5,7-9
			Megjelenti 2 s 5, a 7 s 9 kztt a memo zeneteket
	
MEMO_HELP_DEL
	Syntax: DEL [#szoba] {sorszm | list | LAST | ALL}
	
	Trli a megadott memo zenete(ke)t. 
	Tbb szmot is megadhatsz, intervallumot is hasznlhatsz,
	az egyszer sorszm helyett.
	
	Ha a LAST meg van adva, az utols memo zenetet trli
	Ha az ALL van megadve, akkor minden memo zenetet trl.
	
	Pldk:
	
		DEL 1
			Trli az els memo zenetet.
	
		DEL 2-5,7-9
			Trli a memo zeneteket 2 s 5, illetve 7 s 9 kztt.
	
MEMO_HELP_SET
	Syntax: SET opci paramterek
	
	Bellt klnbzo memo opcikat. 
	Az opci lehet az albbiak egyike:
	
	    NOTIFY     Itt llthatod be, ha figyelmeztetst szeretnl
	               kapni az j zenetekrol (csak nicknevehez)
	    LIMIT      Belltja a maximlis zenetek szmt
	
	Tovbbi informcirt rd be: %R%S HELP SET opci
	
MEMO_HELP_SET_NOTIFY
	Syntax: SET NOTIFY {ON | LOGON | NEW | OFF}
	
	Itt tudod belltani, ha rtestst szeretnl kapni
	az j zenetekrl:
	
	    ON      rtestst kapsz az j zenetrl csatlakozskor,
	            amikor visszajssz /AWAY-bl, vagy ha kldenek neked.
	    LOGON   rtestst kapsz az j zenetekrl csatlakozskor
	            vagy ha visszajssz /AWAY-bl.
	    NEW     Csak akkor kapsz rtestst, ha j zenet rkezett.
	    OFF     Nem kapsz rtestst az zeneteidrl.
	
	Az ON ekvivalens a LOGON s a NEW kombinlsval.
	
MEMO_HELP_SET_LIMIT
	Syntax: SET LIMIT [#szoba] limit
	
	Belltja, hogy max. hny zenetet fogadhatsz a nickedre
	(vagy a csatornra). Ha 0-ra lltod, senki nem
	kldhet zenetet a nickedre/csatornra. Mindamellett,
	nem llthatod ezt a szmot tbbre, mint %d.
	
MEMO_HELP_INFO
	Syntax: INFO [#szoba]
	
	Informcit jelent meg arrl, hogy mennyi zeneted van,
	ebbl mennyi olvasatlan, mennyi zenetet fogadhatsz,
	s azt is megmondja, hogy kapsz-e zenetet az j zenetek
	rkezsekor. Paramter megadsa esetn az informcit
	csatornra vonatkozan jelenti meg.
	
MEMO_SERVADMIN_HELP_SET_LIMIT
	Syntax: SET LIMIT [user | #szoba]{korlt|NONE}[HARD]
	
	Belltja egy felhasznl vagy szoba max.fogadhat
	memo zenetienek szmt, ha a limitet 0-ra llitod 
	akkor a felhasznl nem fogadhat zeneteket.Ha a 
	NONE-vel lltod be akkor annyit fogadhat s tarthat
	meg amennyit akar.Ha nem adsz meg nicknevet, vagy csatornt
	akkor a sajt korltaidat llitja.
	
	HARD-al hozzadva nem llthatja a felhasznl a korlt 
	rtkt Ha nem adod hozz a HARD-ot akkor a felhasznl 
	kedve szerint vltztathatja a korlt rtkt (akkor is ha
	az elz rtket a HARD-al adtad meg)
	
	SET LIMIT parancs hasznlata korltozhat Szervz
	adminokra. Egyb felhasznlk csak sajt maguknak s a 
	csatornknak ahol megfelel hozzfrsk van llthatnak
	korltot de nem trlhetik, s nem llthatnak %d rtk 
	felett valamint HARD korltot.
	
	
MEMO_SERVADMIN_HELP_INFO
	Syntax: INFO [nick| #szoba]
	
	Paramter nlkl kiirja az informcit, hogy hny
	zeneted van, ebbl hny olvasatlan, s sszesen
	hny zenetet fogadhatsz.
	
	A szoba paramterrel, a csatornrl kapod meg  
	ezeket az informcikat	

	A nicknv paramterrel a megadott nicknvrl jelenti
	meg ezeket az informcikat.Enek hasznlat korltozva 
	Szervz adminra.
	
	
MEMO_HELP_STAFF
	Syntax: STAFF memo-zenet
	
	Memo zenet kldse az opereknek/adminoknak.
	Megjegyzs: Ha valamelyik nick szerepel az oper
	s admin listn is, akkor a memot ktszer kapja meg.
	Hasonl a helyzet a root s ms listkkal.
	
MEMO_HELP_SENDALL
	Syntax: SENDALL memo-zenet
	
	Memo zenet kldse minden regisztrlt felhasznlnak.

MEMO_HELP_RSEND
	Syntax: RSEND {nick | #szoba} memo-zenet
	
	Memot kld a megadott nvnek, szobnak a memo-zenet
	tartalmval. Ha nicknvnek kldd, akkor rtestst fog
	kapni, hogy j zenete rkezett. A cl nicknvnek vagy
	csatornnak regisztrltnak kell lennie.
	Amint a cmzett elolvasta a memot, egy automatikus rtestst
	fog kapni a felad arrl, hogy az zenett elolvastk.

MEMO_HELP_CHECK
	Syntax: CHECK nick
	
	Ellenrzi, hogy az _utols_ zenet, amit a nick szmra
	kldtl mr olvasott-e vagy mg olvasatlan.
	Megjegyzs, ez csak nickekkel mkdik szobkkal nem.

###########################################################
#
# OperServ help zenetek
#
###########################################################

OPER_HELP_CMD_GLOBAL
	    GLOBAL      zenetet kld sszes felhasznlnak
OPER_HELP_CMD_STATS
	    STATS       Mutatja a Szervt s hlzat llapott
OPER_HELP_CMD_OPER
	    OPER        Mdostja a Szervz opertorok listjt
OPER_HELP_CMD_ADMIN
	    ADMIN       Mdostja a Szervz admin listt
OPER_HELP_CMD_STAFF
	    STAFF       Kijelzi a szervzt s aktv llapott
OPER_HELP_CMD_MODE
	    MODE        Vltztatja a szoba mdot
OPER_HELP_CMD_KICK
	    KICK        Kirgja a felhasznlt csatornrl
OPER_HELP_CMD_CLEARMODES
	    CLEARMODES  Trli a szoba mdot
OPER_HELP_CMD_KILLCLONES
	    KILLCLONES  Killeli az sszes klnt a hosztrl
OPER_HELP_CMD_AKILL
	    AKILL       Szerkeszti az AKILL listt
OPER_HELP_CMD_SGLINE
	    SGLINE      Szerkeszti az SGLINE listt
OPER_HELP_CMD_SQLINE
	    SQLINE      Szerkeszti az SQLINE listt
OPER_HELP_CMD_SZLINE
	    SZLINE      Szerkeszti az SZLINE listt
OPER_HELP_CMD_CHANLIST
	    CHANLIST    Listzza az sszes csatornt 
OPER_HELP_CMD_USERLIST
	    USERLIST    Listzza az sszes felhasznlt  
OPER_HELP_CMD_LOGONNEWS
	    LOGONNEWS   Fellp zenetek belltsa
OPER_HELP_CMD_RANDOMNEWS
	    RANDOMNEWS  Vletlenszeren megjelen zenetet llt be 
	                a felhasznlk rszre
OPER_HELP_CMD_OPERNEWS
	    OPERNEWS    Operek rszre megjelen zenetet llt be
OPER_HELP_CMD_SESSION
	    SESSION     Olvassa a sessionok hoszt listjt
OPER_HELP_CMD_EXCEPTION
	    EXCEPTION   Mdostja a session-korlt/kivtel listt
OPER_HELP_CMD_NOOP
	    NOOP        Ideiglenesen trli az sszes O:line-t a szerver
	                tvolltben
OPER_HELP_CMD_JUPE
	    JUPE        Ltrehoz egy "Jupiter" lszervert.
OPER_HELP_CMD_IGNORE
	    IGNORE      Mdostja a Szervz mellzsi listjt
OPER_HELP_CMD_SET
	    SET         Belltja szervz ltalnos vltozit
OPER_HELP_CMD_RELOAD
	    RELOAD      jratlti a szervz Konfigurcis fjljt
OPER_HELP_CMD_UPDATE
	    UPDATE      A Szervz adatbzist frissti, fellrja
	                lemezre kzvetlenl
OPER_HELP_CMD_RESTART
	    RESTART     Menti az adatbzist, s jraindtja a szervzt
OPER_HELP_CMD_QUIT
	    QUIT        Lelltja a szervz programot ments nlkl
OPER_HELP_CMD_SHUTDOWN
	    SHUTDOWN    Lelltja a szervz programot mentssel
OPER_HELP_CMD_DEFCON
	    DEFCON      Manipullja a DefCon rendszert
OPER_HELP_CMD_CHANKILL
	    CHANKILL    Kirgja az sszes usert a csatornrl
OPER_HELP_CMD_OLINE
	    OLINE       Operflaget ad a biztos felhasznlnak
OPER_HELP_CMD_UMODE
	    UMODE       Felhasznl mdok lltsa
OPER_HELP_CMD_SVSNICK
	    SVSNICK     Megvltoztatja a felhasznl nicknevt
OPER_HELP_CMD_MODLOAD
	    MODLOAD     Betlti a modult
OPER_HELP_CMD_MODUNLOAD
	    MODUNLOAD   Kitlti a modult
OPER_HELP_CMD_MODINFO
	    MODINFO     Informci a betlttt modulokrl
OPER_HELP_CMD_MODLIST
	    MODLIST     Listzza a betlttt modulokat
	
OPER_HELP
	%S parancsok:
	
OPER_HELP_LOGGED
	zenet:Minden %S-nek kldtt parancs naplzva van.
	
OPER_HELP_GLOBAL
	Syntax: GLOBAL zenet
	
	Megengedi, hogy az IRCopok zenetet kldjenek az sszes 
	felhasznlnak a hlzaton. zenetet a %s nickrl kldi.
	
OPER_HELP_STATS
	Syntax: STATS [AKILL | ALL | RESET]
	
	Ha vlasztasz valamit, megmutatja az aktulis
	felhasznlk szmt, a bejelentkezett IRCopokat (szervizek
	nlkl), legmagasabb felhasznlszmot a szervz indulsa
	ta, s az idt amita fut a szerver.	

	Az  AKILL belltssal, kijelzi az aktulis maxot az
	AKILL listn s az aktulis lejrati idt.
	
	Az ALL belltst csak szervz adminok hasznlhatjk s
	kirja a szervz memria hasznlatnak informcijt. Ez a
	bellts lefagyaszthatja a szervzt egy rvid idre nagy
	hlzat esetn, gy nem lehet hasznlni azt.	
	
	A RESET bellts nullzza az aktulis felhasznlk max.
	szmt trja a jelenlegi felhasznl szmra	
	
	UPTIME, a STATS helyett hasznlhat.
	
OPER_HELP_OPER
	Syntax:	OPER ADD nick
			OPER DEL {nick | sorszm | lista}
			OPER LIST [maszk | lista]
			OPER CLEAR

	Megengedi a szervz adminnak, hogy hozzadjon/trljn
	nicknevet a szervz opertor listrl. A nick hasznlja
	aki a szervz opertor listjn van s be van jelentkezve
	%s -hoz hasznlni tudja az opertor parancsokat	

	Az  OPER ADD parancs hozzad nicknevet a szervz
	opertor listhoz.

	A OPER DEL parancs trli a nicknevet aszervz opertor
	listrl. Ha listaszmot ad meg akkor azt a szm 
	felhasznlt trli.( lsd a plda listt alul).
	
	Az  OPER LIST kiirja a szervz opertorok listjt. Ha
	egy helyettest lej van a maszkban megadva akkor csak
	az annak megfelelt rja ki. Ha listaszmot ad meg csak
	azokat fogja mutatni:pldban.	
	
		OPER LIST 2-5,7-9
			Lista a szervz opertorokrl 2 -tl 5-ig s
			7 -tl 9-ig lvk.
	      
	Az OPER CLEAR parancs trli az szzes nicket a
	Szervz opertor listrl.
	
	Valamennyi IRC opertor hasznlhat OPER LIST parancsot.
	sszes egyb felhasznls korltozva Szervz adminoknak
	
OPER_HELP_ADMIN
	Syntax:	ADMIN  ADD nick
			ADMIN  DEL { nick  |  sorszm  |  lista }
			ADMIN  LIST [ maszk  |  lista ]
			ADMIN  CLEAR
	
	Lehetsget nyjt a Services rootnak, hogy hozzadjon,
	trljn nickneveket a Services adminok listjn. Az
	a felhasznl, aki szerepel a Szervz adminok listjn,
	beazonostott a %s-be hozzfrhet az Admin parancsokhoz.
	
	ADMIN ADD parancs hozzad egy felhasznlt szervz
	admin listhoz.
	
	ADMIN DEL parancs trli a felhasznlt a szervz admin
	listrl. Ha egy sorozatot adsz meg, akkor azok a
	bejegyzsek lesznek trlve. (lsd az albbiakban)
	
	ADMIN LIST parancs kiratja a szervz adminok listjt.  
	Ha maszk van megadva, csak a megegyez maszkot hasznl
	bejegyzsek lesznek kirva. Ha a listbl bejegyzs 
	sorszmok vannak megadva csak azokat rja ki. Plda:
	
		ADMIN LIST 2-5,7-9
			Listzza a szervz adminokat 2-tl 5-ig s 7-tl 
			9-ig.
	      
	ADMIN CLEAR parancs trli az sszes bejegyzsz a szervz
	adminok listjbl.
	
	Az IRC opertorok hasznlhatjk az ADMIN LIST parancsot.
	sszes egybb parancs korltozva Szervz root rszre.
	
OPER_HELP_IGNORE
	Syntax: IGNORE {ADD|DEL|LIST|CLEAR} [id] [nick]
	
	Szervz adminoknak lehet kszteni szervz mellzst
	egy nick rszre megadott idre, vagy amg jraindtjk.
	Az id hinya formailag msodrend.Megadhatsz rszleteket
	a szoksos mell.	rvnyes egysgek s msodpercperc, 
	m perc, d nap. Az egysgek egyestse nem engedlyezett. 
	Kszthetsz tarts mellzst ha idnek 0 a paramtere.
		
OPER_HELP_MODE
	Syntax: MODE #szoba mdok
	
	Megengedi a szervz opertornak, hogy szoba mdokat 
	lltson. Parameterek ugyanazok mint a szabvny
	/MODE parancsnl
		
	Korltozva Szervz operatornak.
	
OPER_HELP_UMODE
	Syntax: UMODE user mdok
	
	Megengedi a szervz adminoknak, hogy egy user felhasznli
	mdjait megvltoztassa. Parameterek ugyanazok mint a
	szabvny /MODE parancsnl.
		
	Korltozva Szuper adminnak.
	
OPER_HELP_OLINE
	Syntax: OLINE user flagek
	
	Lehetsget ad a szervz adminnak, hogy egy usernek 
	operflaget adjon. Eljelknt "+" vagy "-" adhat meg.
	Ha csak a "-" paramter adod meg akkor mindent eltvolt.
	
	Korltozva Szuper adminnak.
	
OPER_HELP_CLEARMODES
	Syntax: CLEARMODES szoba [ALL]
	
	Trl minden mdot (i,k,l,m,n,p,s,t)s kitiltst a 
	csatornrl. Ha az ALL-t megadod akkor eltvoltja
	az op s voice jogokat (+o s +v mdot) a csatornn. 
		
	Korltozva Szervz opertornak.
	
OPER_HELP_KICK
	Syntax: KICK #szoba user indok
	
	Lehetosget nyjt az IRCopoknak, hogy brmelyik szobbl
	kirgjanak egy felhasznlt. A paramterek ugyanazok,
	mint a szabvnyos /KICK parancsnl. A kirgsi zenetben
	benne lesz a KIK parancsot kld IRCop nickneve;  pldul:
	
	***xy ki lett rgva a #csatornrl %S ltal.(op(csak))
	
	Korltozva Szervz operatornak.
	
OPER_HELP_SVSNICK
	Syntax: SVSNICK nick jnick
	
	Erszakkal mevltztatja a user nickevt jnicknvre.
	
	Korltozva Szuper adminnak
	
OPER_HELP_AKILL
	Syntax: AKILL  ADD [ +lejrat] maszk indok
	        AKILL  DEL {maszk | sor-szm | list}
	        AKILL  LIST [maszk | list]
	        AKILL  VIEW [maszk | list]
	        AKILL  CLEAR
	
	Lehetsget ad a szervz opoknak, hogy karbantartsk az
	AKILL listt.  Ha egy felhasznl az AKILL maszkkal egyez
	cimrl prbl csatlakozni , akkor szervz kiad egy KILL 
	parancsot a nickre, s a tmogatott szervertpusokon arra
	utast minden szervert, hogy adjon K-linet a maszknak.
	
	AKILL ADD hozzadja a megadott user@host/ip maszkot az
	AKILL listra a megadott indokkal (amit meg kell adnod).
	Az elvlst egsz szmmot kovet egy idparamter d (nap),
	h (ra), m (perc).Ezek kombinlsa nem lehetsges(1h30m).
	ha nem adsz meg idegysget akkor nmagban napot jelent.
	(+30 az 30 napot jelent).Ha +0-t adsz meg akkor nem 
	elvl lesz.Ha a usermaszk + -al kezddik akkor elvlst
	meg kell adni akkor is ha megegyezik az alaprtelmezssel.
	Az AKILL jelenlegi alaprtelmezett elvlsi ideje 
	megnzhet a STATS AKILL paranccsal.

	AKILL DEL trli a maszkot az AKILL listrl, ha rajta
	van. Ha bejegyzs sorszmot adsz meg akkor azok fognak
	trldni.(lsd a pldt albb)
	AKILL LIST kiirja a jelenlegi AKILL listt. Ha egy 
	"*" karakteres maszk van megadva, akkor csak azokat az
	AKILL-eket listzza, amelyek rillenek a megadott maszkra.
	Ha sorszmot adsz meg akkor azok fognak trldni. Plda:

		AKILL LIST 2-5,7-9
	      Listzza az AKILL-en lvoket 2-tl 5-ig s 7-tl 9-ig
	      az AKILL listbl

	AKILL VIEW rszletesebb verzija az AKILL LIST-nek,
	amely megmutatja, hogy ki vette fel az AKILL-t,	mikor lett
	felvve s mikor jr le, ppgy, felhasznl@gazdanv 
	maszkot s indokot.
		
	AKILL CLEAR trli az sszes AKILL bejegyzst.
	
	Korltozva Szervz operatornak.
	
OPER_HELP_SGLINE
	Syntax: SGLINE ADD [+lejrat] maszk:indok
	    SGLINE DEL {maszk | sor-szm | list}
	        SGLINE LIST [maszk | list]
	        SGLINE VIEW [maszk | list]
	        SGLINE CLEAR
	
	Lehetsget ad a szervz opoknak, hogy karbantartsk az
	SGLINE listt.  Ha egy felhasznl egy vals nvvel akar
	csatlakozni , ami szerepel az SGLINE listn akkor szervz
	nem fogja engedlyezni rszre a csatlakozst. 
	
	SGLINE ADD hozzadja a valsnvmaszkot az SGLINE listra
	a megadott indokkal (amit meg is kell adni).	
	Az elvlst egsz szmmot kovet egy idoparamter d (nap),
	h (ra), m (perc).Ezek kombinlsa nem lehetsges(1h30m).
	ha nem adsz meg idoegysget akkor nmagban napot jelent.
	(+30 az 30 napot jelent).Ha +0-t adsz meg akkor nem 
	elvlo lesz.Ha a usermaszk + -al kezdodik akkor elvlst
	meg kell adni akkor is ha megegyezik az alaprtelmezssel.
	Az SGLINE jelenlegi alaprtelmezett elvlsi ideje 
	megnzheto a STATS AKILL paranccsal.
	Jegyzet: a valsnv maszkja tartalmazhat szkzt ezrt
	kzte s az indok kztt az elvlaszt karakter a vessz.
	SGLINE DEL eltvoltja a megadott maszkot az SGLINE listrl,
	ha jelen van.Ha bejegyzs sorszmot adsz meg akkor azok fognak
	trlodni.	(Lsd a plda albb)
	SGLINE LIST kiirja az sszes SGLINE bejegyzst; ha
	egy tetszleges maszk meg van adva, a lista korltozva lesz
	azokra a bejegyzsekre, amelyekre rillik a maszk. Plda:
		
	   SGLINE LIST 2-5,7-9
	      Listzza a SGLINE-okat 2-tl 5-ig s 7-tl 9-ig az 
	      SGLINE listrl
	      
	SGLINE VIEW rszletesebb verzija a SGLINE LIST-nek,
	s megmutatja, ki ksztette a SGLINE bejegyzseket,
	s mikor jr le, mint a maszkot s az indokot.
	SGLINE CLEAR trli az SGLINE bejegyzseket.
	
	Korltozva Szervz operatornak.
	
OPER_HELP_SQLINE
	Syntax: SQLINE ADD [+lejrat] maszk indok
	        SQLINE DEL {maszk | sor-szm | list}
	        SQLINE LIST [maszk | list]
	        SQLINE VIEW [maszk | list]
	        SQLINE CLEAR
	
	Engedlyezi a opertoroknak, hogy karbantartsk az SQLINE
	listt. Ha egy felhasznl "nick-je" rillik egy SQLINe
	maszkra, megprbl csatlakozni, a szervz nem fogja engedni
	az egsz irc-n.
	
	Ha az els karakter a maszkban #, szervz meg fogja elzni 
	a hasznlatt Az ilyen csatornknak (az IRCD-k ezt 
	tmogatjk).

	SQLINE ADD hozzadja az adott maszkot az SQLINE listhoz
	a megadott indokkal (amit meg kell adni).Az elvlst is,
	egsz szmmot kvet egy idparamter d (nap),h (ra), 
	m (perc).Ezek kombinlsa nem lehetsges(1h30m).
	Ha nem adsz meg idegysget akkor nmagban napot jelent.
	(+30 az 30 napot jelent).Ha +0-t adsz meg akkor nem 
	elvlo lesz.Ha a usermaszk + -al kezdodik akkor elvlst
	meg kell adni akkor is ha megegyezik az alaprtelmezssel.
	Az SQLINE jelenlegi alaprtelmezett elvlsi ideje 
	megnzheto a STATS AKILL paranccsal.
	SQLINE DEL eltvoltja a maszkot az SQLINE listrl,
	ha jelen van.Ha bejegyzs sorszmot adsz meg akkor azok
	fognak trldni.	(Lsd a plda albb)
	SQLINE LIST kiirja az sszes SQLINE bejegyzst; ha
	egy tetszleges maszk meg van adva, a lista korltozva lesz
	azokra a bejegyzsekre, amelyekre rillik a maszk. Plda:
		
	   SQINE LIST 2-5,7-9
	      Listzza a SQLINE-okat 2-tl 5-ig s 7-tol 9-ig az 
	      SQLINE listrl
	      
	SQLINE VIEW rszletesebb verzija a SQLINE LIST-nek,
	s megmutatja, ki ksztette a SGLINE bejegyzseket,
	s mikor jr le, mint a maszkot s az indokot.
	SQLINE CLEAR trli az SQLINE bejegyzseket.
	
	Korltozva Szervz operatornak.
	
OPER_HELP_SZLINE
	Syntax: SZLINE ADD [+lejrat] maszk indok
	        SZLINE DEL {maszk | sorszm | list}
	        SZLINE LIST [maszk | list]
	        SZLINE VIEW [maszk | list]
	        SZLINE CLEAR
	
	Lehetsget nyjt az opertoroknak, hogy karbantartsk az
	SZLINE listt. Ha egy felhasznl, IP cme rillik egy 
	SZLINE maszkra, csatlakozni akar, a szervz nem fogaj azt
	megengedni( s ez lehet IP vagy PTR RR vagy not)
	SZLINE ADD hozzadja az adott maszkot az SZLINE listhoz
	a megadott indokkal (amit meg kell adni).Az elvlst is,
	egsz szmmot kvet egy idparamter d (nap),h (ra), 
	m (perc).Ezek kombinlsa nem lehetsges(1h30m).
	Ha nem adsz meg idegysget akkor nmagban napot jelent.
	(+30 az 30 napot jelent).Ha +0-t adsz meg akkor nem 
	elvlo lesz.Ha a usermaszk + -al kezdodik akkor elvlst
	meg kell adni akkor is ha megegyezik az alaprtelmezssel.
	Az SZLINE jelenlegi alaprtelmezett elvlsi ideje 
	megnzheto a STATS AKILL paranccsal.
	SZLINE DEL eltvoltja a maszkot az SZLINE listrl,
	ha jelen van.Ha bejegyzs sorszmot adsz meg akkor azok 
	fognak trlodni.	(Lsd a plda albb)
	SZLINE LIST kiirja az sszes SQLINE bejegyzst; ha
	egy tetszleges maszk meg van adva, a lista korltozva lesz
	azokra a bejegyzsekre, amelyekre rillik a maszk. Plda:
		
	   SZINE LIST 2-5,7-9
	      Listzza a SZLINE-okat 2-tl 5-ig s 7-tol 9-ig az 
	      SZLINE listrl

			
	SZLINE VIEW rszletesebb verzija a SZLINE LIST-nek,
	s megmutatja, ki ksztette a SZLINE bejegyzseket,
	s mikor jr le, mint az IP-t s az indokot.
	
	SQLINE CLEAR trli az SQLINE bejegyzseket.
	
	Korltozva Szervz operatornak.
	
OPER_HELP_SET
	Syntax: SET  opci bellts
	
	Belltja a Services ltalnos opciit.
	A lehetsges opcik:
	    READONLY   Csak-olvass vagy olvass-rs md belltsa
	    LOGCHAN    Kirja a naplzott zeneteket a csatornra
	    DEBUG      Bekapcsolja/kikapcsolja a debug mdot
	    NOEXPIRE   Bekapcsolja/kikapcsolja a nem elvl mdot
	    SUPERADMIN Bekapcsolja/kikapcsolja a super-admin mdot
	    SQL   	 Activate or deactivate sql mode
	    IGNORE     Activate or deactivate ignore mode
	    LIST       List the options
	
	Korltozva Szervz adminnak.
	
OPER_HELP_SET_READONLY
	Syntax: SET READONLY {ON | OFF}
	
	Csak-olvass md aktivlsa/kikapcsolsa. A csak-olvass
	md, a normal felhasznl rszre nem engedi, hogy brmit
	mdostson a szervzben, belertve a nicknv, a
	hozzfrs listt, stb. IRCopertorok a megfelel flaggel
	mdostani tudja a szervz akill listt s a droppolhat
	vagy forbidolhat nickneveket s szobkat, de ez nem fog
	kerl mentsre, amg a csak olvasni mdot kikapcsolja
	s restartolja a szervzt.
	
	Ez a parancs egyenrtku a parancs-sorban kiadott
	-readonly opcival.	

	
OPER_HELP_SET_LOGCHAN
	Syntax: SET LOGCHAN {ON | OFF}
	
	Belltja, hogy a szervz a naplz csatornra kldje el
	a rszletes napl adatokat s persze a naplfjlba.
	A Naplz Csatornt (LogChannel) meg kell hatrozni a
	szervz config fljban, hogy	hasznlhasd ezt az opcit.
	 	
	Jegyzet: slyos biztonsgi gondokat okozhat, ha ez a
	naplz szoba nincs kellen vdve.
	
OPER_HELP_SET_DEBUG
	Syntax: SET DEBUG {ON | OFF | szm}
	
	Be vagy kikapcsolja a debug mdot. Debug mdban, minden a
	Szervznek s a szervz ltal kldtt zenet s persze mg
	sok ms zenet rgztsere kerl a naplfjlban. Ha megadsz
	szmot is, akkor a debug md bekapcsol s a megadott szinten
	fog mukdni.
	
	Ez az opci megegyezik a parancs-sorban kiadhat opcival:
	-debug.
	
OPER_HELP_SET_NOEXPIRE
	Syntax: SET NOEXPIRE {ON | OFF}
	
	Bekapcsolja a nem elvlst. A nem elvl mdban nickek,
	csatornk, akillek s kivtelek rakhatak nem elvlre is
	amg ezt az opcit nem kapcsolod ki.
	
	Ez az opci megegyezik a parancs-sorban kiadhat opcival:
	-noexpire.
	
OPER_HELP_SET_SUPERADMIN
	Syntax: SET SUPERADMIN {ON | OFF}
	
	Ez a bellts extra jogokat biztost szmodra, pldul
	az "sszes szoba founderje" stb...
	
	Ez az opci nem ajnlott, csak akkor hasznld, ha 
	szksges s kapcsold ki, ha mr nem.

OPER_HELP_SET_SQL
	Syntax: SET SQL {ON | OFF}

	Setting this will toggle Anope's from usage of SQL, this should
	be used to disable and enable SQL should your SQL server go down
	while services are running.

OPER_HELP_SET_IGNORE
	Syntax: SET IGNORE {ON | OFF}

	Setting this will toggle Anope's usage of the IGNORE system 
	on or off.

OPER_HELP_SET_LIST
	Syntax: SET LIST

	Display the various OperServ settings
	
OPER_HELP_NOOP
	Syntax: NOOP SET szerver
	        NOOP REVOKE szerver
	
	NOOP SET levesz minden O:line-t a megadott
	szerver-en s killel minden IRCopot, aki fent van
	megelzvn a szerver rehasholst (mert ez
	trln a hatst).
	
	NOOP REVOKE minden levett O:line-t jra elrhetv tesz
	a megadott szerver-en.
	
	Jegyzet: A szerver paramtert nem ellenrzi
	a Szerviz.
	
	Korltozva Szervz adminoknak.
	
OPER_HELP_JUPE
	Syntax: JUPE server [leirs]
	
	Tells Services to jupiter a server -- that is, to create
	a fake "server" connected to Services which prevents
	the real server of that name from connecting.  The jupe
	may be removed using a standard SQUIT.  If a reason is
	given, it is placed in the server information field;
	otherwise, the server information field will contain the
	text "Juped by <nick>", showing the nickname of the
	person who jupitered the server.
	
	Korltozva Szervz adminoknak.
	
OPER_HELP_RAW
	Syntax: RAW szveg
	
	Sends a string of text directly to the server to which
	Services is connected.  This command has a very limited
	range of uses, and can wreak havoc on a network if used
	improperly.  DO NOT USE THIS COMMAND unless you are
	absolutely certain you know what you are doing!
	
	Korltozva Szervz adminoknak.
	
OPER_HELP_UPDATE
	Syntax: UPDATE
	
	Menti a Szervz adatbzist, azonnal amint kiadtad
	a parancsot.
	
	Korltozva Szervz adminoknak.
	
OPER_HELP_RELOAD
	Syntax: RELOAD
	
	jratlti a Szervz konfigurcis fjljt. Jegyzet: nhny
	direktvnak ettl fggetlenl restart kell, hogy hatsa
	letbe lpjen. (Pldul a Szervz egysgek nicknv vltsa 
	vagy session korltozs aktvlsa, stb.)
	
	Korltozva Szervz adminoknak.
	
OPER_HELP_QUIT
	Syntax: QUIT
	
	A Szervz azonnal lell; az adatbzist nem menti el.
	Ez a parancs annak elkerlsre hasznos, hogy a memriban
	lv adatok msolata bekerljn az adatbzisba.
	Norml lelltsokhoz hasznld krlek a
	SHUTDOWN parancsot!
	
	Korltozva Services adminoknak.
	
OPER_HELP_SHUTDOWN
	Syntax: SHUTDOWN
	
	Menti a Szervz adatbzist, majd lelltja a programot.
	
	Korltozva Szervz adminoknak.
	
OPER_HELP_RESTART
	Syntax: RESTART
	
	Menti a Szervz adatbzist, majd jraindtja a programot.
	(Kilp, majd jraindul.)
	
	Korltozva Szervz adminoknak.	
	
OPER_HELP_KILLCLONES
	Syntax: KILLCLONES nick 
	
	Killel minden usert, aki az adott nick hosztjrl van fent
	Egy idztett, *@host formtum AKILL hozzadsra kerl,
	hogy megelzze, hogy a kliensek azonnal visszalpjenek.
	Egy wallops zenet kerl elkldsre a parancs hasznlja,
	az rintett hoszt s a killelt userek szmval.
	Ez akkor hasznos, ha sok klnt kell eltvoltani
	a hlzatrl.
	
	Korltozva Szervz opertornak.
	
OPER_HELP_CHANLIST
	Syntax: CHANLIST [{pattern | nick} [SECRET]]
	
	Listz minden csatornt, ami most aktv az IRC hlzaton
	attl fggetlenl, hogy regisztrlt vagy sem.
	
	Ha a pattern meg van adva, akkor csak az egyezket
	listzza. Ha a nicknv van megadva, akkor listzza azokat
	a csatornkat, ahol az adott user bent van. Ha a SECRET
	van megadva, akkor listz minden pattern-nek megfelel
	csatornr, melyen +s vagy +p md van fent.
	
	Korltozva Szervz adminoknak.
	
OPER_HELP_USERLIST
	Syntax: USERLIST [{pattern | #szoba} [INVISIBLE]]
	
	Listz minden jelenleg online usert az IRC hlzaton,
	attl fggetlenl, hogy regisztrlt vagy sem.
	
	Ha a pattern meg van adva, akkor csak az egyezket 
	listzza (formtum: nick!user@host). Ha a #szoba
	meg van adva, akkor csak az adott csatornn lvket
	listzza. Ha az INVISIBLE meg van adva, akkor csak a
	+i flages usereket listzza.
	
	Korltozva Szervz adminoknak.
	
OPER_HELP_MODLOAD
	Syntax: MODLOAD Fjlnv
	
	Ez a parancs betlti azt modult, a modules knyvtrbl,
	amelyiknek a fjlnevt megadtad.
	
	Korltozva Szervz Rootnak.
	
OPER_HELP_MODUNLOAD
	Syntax: MODUNLOAD FileName
	
	Ez a parancs kitlti a megnevezett fjlnev msdult a 
	modulok listjbl.
		
	Korltozva Szervz Rootnak.
	
OPER_HELP_MODINFO
	Syntax: MODINFO Fjlnv
	
	A parancs rszletes informcit ad a betlttt modulokrl.
	
	Korltozva Szervz Rootnak.
	
OPER_HELP_MODLIST
	Syntax: MODLIST
	
	Listzza az sszes betlttt aktv modult.
	
	Korltozva Szervz Rootnak.
		
###########################################################
#
# BotServ help zenetek
#
###########################################################

BOT_HELP_CMD_BOTLIST
	BOTLIST            Listzza az elrhet botokat
BOT_HELP_CMD_ASSIGN
	ASSIGN             Trst egy botot a csatornhoz
BOT_HELP_CMD_SET
	SET                Konfigurlja a bot opciit
BOT_HELP_CMD_KICK
	KICK               Konfigurlja a kirgsokat
BOT_HELP_CMD_BADWORDS
	BADWORDS           Szerkeszti a tiltott szavak listjt
BOT_HELP_CMD_ACT
	ACT                Makes the bot do the equivalent of a "/me" command
BOT_HELP_CMD_INFO
	INFO               Allows you to see BotServ information about a channel or a bot
BOT_HELP_CMD_SAY
	SAY                Makes the bot say the given text on the given channel
BOT_HELP_CMD_UNASSIGN
	UNASSIGN           Unassigns a bot from a channel
BOT_HELP_CMD_BOT
	BOT                Karbantartja a hlzat botjainak listjt

BOT_HELP
	
	%S lehetv teszi, hogy botod legyen a csatorndon.
	Ezt olyan felhasznlk szmra ksztettk, akik
	nem tudnak sajt botot futtatni, vagy a hlzaton nem
	engedlyezik ezt. Az elrhet parancsok listja albb 
	tallhat; hasznlatukhoz rd be %R%S parancs.
	Bvebb informcit gy kaphatsz az adott parancsrl:
	%R%S HELP parancs.
	
BOT_HELP_FOOTER
	A Bot akkor fog belpni a csatornra, ha legalbb

	%d felhasznl van bent.
	
BOT_HELP_BOTLIST
	Syntax: BOTLIST
	
	Listzza az sszes rvnyes botot a hlzatrl.
	
BOT_HELP_ASSIGN
	Syntax: ASSIGN #szoba nick
	
	Trstja a megnevezett botot a szobhoz. Bellthatod a
	botodat a csatornd ignyeidnek megfelelen.
	Kellemes botozst! :-)
	
BOT_HELP_UNASSIGN
	Syntax: UNASSIGN #szoba
	
	Eltvoltja a botot a csatornrl. Ha hasznlod ezt a
	parancsot, akkor a botod nem fog tbbet belpni a
	szobba. A bot konfigurcii megmaradnak.
	Azaz nem kell jra bekonfigurlnod, ha ksbb vissza
	akarod hozni a szobdba.
	
BOT_HELP_INFO
	Syntax: INFO {#szoba  |  nick}
	
	Lehetv teszi, hogy megnzd a %S informcikat egy
	csatornval vagy bottal kapcsolatban. Ha a paramter
	szobanv, akkor megkapod a szobra vonatkoz bot
	belltsokat. Ha a paramter nick, akkor a botrl
	kapsz informcikat, pldul ltrehozs ideje, csatornk
	szma.
	
BOT_HELP_SET
	Syntax: SET #szoba opci paramterek
	
	Belltja a bot opciit. Az opci a kvetkez lehet:
	
	    DONTKICKOPS      Vdelem az opoknak bot kirgs ellen
	    DONTKICKVOICES   Vdelem a voicesokna bot kirgs ellen
	    GREET            Engedlyezi a ksznt zenetet
	    FANTASY          Engedlyezi a fantaisi parancsokat
	    SYMBIOSIS        Megengedi, hogy a bot olyan legyen mint 
	                     az igazi botok
	
	rd be %R%S HELP SET opci bvebb informcikrt
	az adott opcirl.
	
	Megjegyzs: ezekhez a parancsokhoz a hozzfrst a
	levels-ben lehet lltani.
	
BOT_HELP_SET_DONTKICKOPS
	Syntax: SET #szoba DONTKICKOPS {ON|OFF}
	
	Engedlyezi vagy tiltja opok vdelmt a csatornn.
	Ha engedlyezve van, akkor az opokat nem fogja a bot
	kirgni, akkor se, ha nem egyeznek meg a NOKICK szinttel
		
BOT_HELP_SET_DONTKICKVOICES
	Syntax: SET #szoba DONTKICKVOICES { ON|OFF }
	
	Engedlyezi vagy tiltja hangadk vdelmt a csatornn.
	Ha engedlyezve van, akkor a hangadkat nem fogja a bot
	kirgni, akkor se, ha nem egyeznek meg a NOKICK szinttel
	
BOT_HELP_SET_FANTASY
	Syntax: SET #szoba FANTASY { ON|OFF }
	
	Engedlyezi vagy tiltja fantasy mdot a csatornn.
	Ha engedlyezve van, akkor a kvetkez parancsok
	hasznlhatk a csatornn: !op, !deop, !voice, !devoice,
	!kick, !kb, !unban, !seen (talld ki hogyan kell
	hasznlni ket; prbld meg nick megadsval, a nlkl
	is)
	
	Azoknak akik ezeket a parancsokat akarjk hasznlni
	rendelkeznik KELL a szksg szinttel mind a FANTASIA
	mind pedig az egyb szintekkel, ami a parancshoz
	szksges. (pldul, az !op hasznlathoz, meg kell
	legyen a megfelel szintjk az OPDEOP parancsokhoz.).
	
BOT_HELP_SET_GREET
	Syntax: SET #szoba  GREET { ON|OFF }
	
	Engedlyezi vagy tiltja Ksznt mdot a csatornn.
	Ha engedlyezve van, akkor a bot megjelenti azoknak
	a ksznt zenett, akiknek a szintjk megfelel ehhez.
	
BOT_HELP_SET_SYMBIOSIS
	Syntax: SET #szoba SYMBIOSIS { ON|OFF }
	
	Engedlyezi vagy tiltja symbiosis mdot a csatornn.
	Ha engedlyezve van, akkor a bot fog mindent csinlni,
	amit egybknt a %s csinlna a csatornn, mint MODE,
	KICK, s a belpzenet kirsa.
	
BOT_HELP_KICK
	Syntax: KICK  #szobaopciparamterek
	
	Bot kirgsok belltsa. Az opci a kvetkez lehet:
	
	    BOLDS         A bot kirgja flkvr betkkel rkat
	    BADWORDS      A bot kirgja a csnyaszavakat hasznlkat
	    CAPS          A bot kirgja CapsLock hasznlkat
	    COLORS        A bot kirgja szinesen rkat
	    FLOOD         A bot kirgja floodolkat
	    REPEAT        A bot kirgja az nmagukat 
	                  ismtlket.
	    REVERSES      A bot kirgja visszafel rkat
	    UNDERLINES    A bot kirgja alhzssal rkat
	
	rd be %R%S HELP KICK opci az adott opcival
	kapcsolatos bvebb informcikrt.
	
	Megjegyzs: A parancshoz val hozzfrst a level SET-ben
	lehet korltozni.
	
BOT_HELP_KICK_BOLDS
	Syntax: KICK  #szoba BOLDS { ON|OFF } [ ttb ]
	
	Belltja a flkvr rsrt jr kirgst.
	Ha engedlyezve van akkor a bot kirg a flkvr betkrt.
	
	A ttb a banols elotti kickek szma.
	Ha nem adod meg, akkor csak kirgst eszkzl a bot.
	Ha megadod a ttb-t, akkor x kirgs utn banol a bot.
	
BOT_HELP_KICK_COLORS
	Syntax: KICK  #szoba COLORS { ON|OFF } [ ttb ]
	
	Belltja a szines rsrt jr kirgst.
	Ha engedlyezve van akkor a bot kirgja a sznesen rkat.
	
	A ttb a banols eltti kickek szma.
	Ha nem adod meg, akkor csak kirgst eszkzl a bot.
	Ha megadod a ttb-t, akkor x kirgs utn banol a bot.
	
BOT_HELP_KICK_REVERSES
	Syntax: KICK  #szobaREVERSES { ON|OFF } [ ttb ]
	
	Belltja a visszafel rsrt jr kirgst.
	Ha engedlyezve van akkor a bot kirgja a reverse rkat.
	
	A ttb a banols eltti kickek szma.
	Ha nem adod meg, akkor csak kirgst eszkzl a bot.
	Ha megadod a ttb-t, akkor x kirgs utn banol a bot.	

BOT_HELP_KICK_UNDERLINES
	Syntax: KICK #szobaUNDERLINES { ON|OFF } [ ttb ]
	
	Belltja az alhzott rsrt jr kirgst.
	Ha engedlyezve van akkor a bot kirgja az alhzva rkat
	
	A ttb a banols eltti kickek szma.
	Ha nem adod meg, akkor csak kirgst eszkzl a bot.
	Ha megadod a ttb-t, akkor x kirgs utn banol a bot.
	
BOT_HELP_KICK_CAPS
	Syntax: KICK #szobaCAPS { ON|OFF } [ ttb  [ min  [ szzalk ]]]
	
	Belltja a tlzott caps miatt jr kirgst.
	Ha engedlyezve van, akkor a bot kirgja a "kiablkat".
	
	A bot csak akkor rgja ki a usert, ha legalbb min szm
	bet van s ez legalbb szzalka%% az sszes szvegnek
	a sorban (ha nincs megadva, akkor 10 karakter a min s
	annak legalbb a 25%-a az alapbellts)
	
	A ttb a banols eltti kickek szma.
	Ha nem adod meg, akkor csak kirgst eszkzl a bot.
	Ha megadod a ttb-t, akkor x kirgs utn banol a bot.
	
BOT_HELP_KICK_FLOOD
	Syntax: KICK #szoba FLOOD { ON|OFF } [ ttb  [ sor  [ mp ]]]
	
	Belltja a flood miatti kirgst. Ha engedlyezve van
	akkor a bot kirgja a floodol usereket, ha legalbb
	sor szm sort rtak mp msodpercnyi id alatt.
	(ha nincs megadva, akkor 6 sor s 10 mp alatt).
	
	A ttb a banols eltti kickek szma.
	Ha nem adod meg, akkor csak kirgst eszkzl a bot.
	Ha megadod a ttb-t, akkor x kirgs utn banol a bot.
	
BOT_HELP_KICK_REPEAT
	Syntax: KICK  #szoba REPEAT { ON|OFF } [ ttb  [ szm ]]
	
	Belltja az ismtls miatti kirgst. Ha engedlyezve
	van az opci, akkor a bot kirgja az nmagukat ismtl
	usereket, ha szm alkalommal ismteltek. 
	(Ha nem adsz meg rtket, akkor az rtk 3 lesz)
	
	A ttb a banols eltti kickek szma.
	Ha nem adod meg, akkor csak kirgst eszkzl a bot.
	Ha megadod a ttb-t, akkor x kirgs utn banol a bot.
	
BOT_HELP_KICK_BADWORDS
	Syntax: KICK #szoba BADWORDS {ON|OFF} [ttb]
	
	Belltja a csnyaszavak miatti kirgst. Ha engedlyezve
	van, akkor a bot kirgja azt, aki kiejt egy olyan szt,
	ami szerepel a csnyaszavak listjn.
	
	A csnyaszavak listjt a csatorndhoz neked kell megadnod
	A BADWORDS paranccsal. rd be %R%S HELP BADWORDS 
	bvebb informcikrt.
	
	A ttb a banols elotti kickek szma.
	Ha nem adod meg, akkor csak kirgst eszkzl a bot.
	Ha megadod a ttb-t, akkor x kirgs utn banol a bot.
	
BOT_HELP_BADWORDS
	Syntax:BADWORDS #szoba ADD  sz  [SINGLE  |  START  |  END]
		 BADWORDS #szoba DEL { sz  |  sorszm  |  list}
		 BADWORDS #szoba LIST  [ maszk  |  list]
		 BADWORDS #szoba CLEAR

	Karbantartja a szoba csnyasz listjt. A tiltott
	szavak listja meghatrozza, hogy mely szavak kiejtsre
	rgja ki a bot a usert, ha a kirgs engedlyezve van,
	errl bvebb informcik: %R%S HELP KICK BADWORDS.
	
	A BADWORDS ADD parancs hozzad egy szt a listhoz.
	Ha a SINGLE van megadva, akkor lesz kirgja a user, ha
	a konkrt szt mondja ki.
	Ha a START van megadva, akkor a sz elejt figyeli a bot.
	Ha az END van megadva, akkor a sz vgt figyeli a bot.
	Ha nem adsz meg semmit, akkor	a user minden alkalommal
	kirgsra kerl, ha kiejti a szt.
	Ha nem beszl csnyn, akkor semmi baja nem lesz! :-)

	A BADWORDS DEL parancs eltvoltja a megadott szt
	a tiltott szavak listjrl. Ha egy sorozatot adsz meg
	a bejegyzsek szmval, akkor azok a bejegyzsek kerlnek
	trlsre. (Lsd lentebb a listzst.)
	
	A BADWORDS LIST parancs megjelenti a tiltott szavakat.
	Ha hasznlod a * karaktert, akkor csak az egyez
	bejegyzsek kerlnek listzsra. Ha egy sorozatot adsz meg
	akkor azok a bejegyzsek kerlnek megjelentsre; plda:

	   BADWORDS  #szoba  LIST  2-5,7-9
	      Listzza a csnyaszavakat 2-tl 5-ig s a 7-tl
	      9-ig.
	      
	BADWORDS CLEAR parancs trli az sszes bejegyzst
	a tiltott szavak listjrl
	
BOT_HELP_SAY
	Syntax: SAY #szoba szveg
	
	Elkldi a bot a megadott szveget a csatornra.
	
BOT_HELP_ACT
	Syntax: ACT #szoba szveg
	
	A bot "/me" akcival kldi el a megadott szveget
	a csatornra.
	
BOT_SERVADMIN_HELP_BOT
	Syntax:	BOT ADD  nick   user   hoszt   vals
			BOT CHANGE  rginick   jnick [user  [ hoszt  [ vals ]]]
			BOT DEL nick
	
	Lehetv teszi a Services adminoknak, hogy ltrehozzanak
	trljenek, mdostsanak botokat, amiket a userek
	hasznlhatnak a csatornikon.
	
	BOT ADD hozzad egy botot a megadott nick, usernv,
	hostnv s valsnv hasznlatval. Amita nincs ellenrzs
	krlek vatsan hasznld ezt a parancsot.
	BOT CHANGE megvltoztatja egy bot nickjt, usernevt,
	hostnevt, valsnevt, anlkl hogy trlni kellene
	(minden adat, bellts megmarad benne.)
	BOT DEL trli a megadott botot a listbl.  
	
	Megjegyzs: ha ltrehozol egy botot, egy mr regisztrlt
	nickkel, akkor a nick dropolva lesz. Akkor is, ha a user
	ppen hasznlja a nicket; killelve lesz.
	
BOT_SERVADMIN_HELP_SET
	
	Ezeket az opcikat csak Szervz adminok hasznlhatjk:
		
	    NOBOT            Megelzi, hogy egy botot trstani lehessen
	                       csatornhoz
	    PRIVATE          Megelzi, hogy egy botot nem IRCop szemly
	                       trsthasson
	
BOT_SERVADMIN_HELP_SET_NOBOT
	Syntax: SET #szoba NOBOT {ON|OFF}
	
	Ez az opci a botot szobhoz trsthatatlann teszi.
	Ha egy bot mr trstva van egy csatornhoz
	akkor trldik onnan, ha ezt az opcit bekapcsolod.
	
	Korltozva Szervz adminoknak.
	
BOT_SERVADMIN_HELP_SET_PRIVATE
	Syntax: SET bot-nick PRIVATE {ON|OFF}
	
	Ez az opci megelzi, hogy az adott botot a csatornhoz
	nem IRC opertor szemlyek trsthassk.
	
	Korltozva Szervz adminoknak.
	
###########################################################
#
# HostServ zenetek
#
###########################################################
HOST_EMPTY
	A vhost lista res.
HOST_ENTRY
	#%d Nick:%s, vhost:%s (%s - %s)
HOST_IDENT_ENTRY
	#%d Nick:%s, vhost:%s@%s (%s - %s)
HOST_SET
	%s vhostja erre vltozott: %s.
HOST_IDENT_SET
	%s vhostja erre vltozott: %s@%s.
HOST_SETALL
	A %s csoport vhostja %s lett.
HOST_DELALL
	A %s csoport vhostja trlve.
HOST_DELALL_SYNTAX
	Syntax: DELALL <nick>.
HOST_IDENT_SETALL
	A %s csoport vhostja erre vltozott: %s@%s.
HOST_SET_ERROR
	A vhost hosztmaszknak rvnyes formtumban kell lennie.
HOST_SET_IDENT_ERROR
	A vhost identnek rvnyes formtumnak kell lenni.
HOST_SET_TOOLONG
	Hiba! A vhost hoszz, rj %d karakternl rvidebbet!
HOST_SET_IDENTTOOLONG
	Hiba! Az Ident hoszz, rj %d karakternl rvidebbet!
HOST_NOREG
	%s felhasznl nincs a nickserv db fjlban.
HOST_SET_SYNTAX
	Syntax %R%s set <nick> <hosztmaszk>.
HOST_SETALL_SYNTAX
	Syntax %R%s setall <nick> <hosztmaszk>.
HOST_DENIED
	Hozzfrs megtagadva.
HOST_NOT_ASSIGNED
	Keress meg egy Opertort s krj tle vhostot.
HOST_ACTIVATED
	A %s virtulis hosztod aktivlva.
HOST_IDENT_ACTIVATED
	A  %s@%s virtulis hosztod aktivlva.
HOST_ID
	Krlek azonosts elbb a szervzben.
HOST_NOT_REGED
	Csak regisztrlt nickhez tudsz vhostot trstani.
HOST_DEL
	%s vhosztja trlve lett.
HOST_DEL_SYNTAX
	Szintaktika: %R%s del <nick>.
HOST_OFF_UNREAL
	A vhostod kikapcsolva. Hogy jra hasznld az alap
	hosztrejtst rd be /mode %s +%s
HOST_NO_VIDENT
	n ircdje nem tmogatja a videnteket, ha ez nem igaz,
	akkor krem jelentse ezt, mint lehetsges hibt.
HOST_GROUP
	Az sszes user vhosztja a(z) %s csoportba %s lett
HOST_IDENT_GROUP
	Az sszes user vhosztja a(z) %s csoportba %s@%s lett
HOST_LIST_FOOTER
	Kirja az sszes bejegyzst (Szmll: %d)
HOST_LIST_RANGE_FOOTER
	Kirja a bejegyzseket %d-tl %d-ig
HOST_LIST_KEY_FOOTER
	Kirja azokat a hosztokat melyben a %s sz szerepel.
	(szmll: %d)
	
###########################################################
#
# HostServ Help zenetek
#
###########################################################
HOST_HELP_CMD_ON
	    ON          Aktivlja a trstott vhostot
HOST_HELP_CMD_OFF
	    OFF         Kikapcsolja a trstott vhostot
HOST_HELP_CMD_GROUP
	    GROUP       A vhostot a csoport minden tagjra lltja
HOST_HELP_CMD_SET
	    SET         Bellt egy vhosztot a felhasznlnak
HOST_HELP_CMD_SETALL
	    SETALL      Belltja a vhosztot sszes nicknek a csoportban
HOST_HELP_CMD_DEL
	    DEL         Trli egy felhasznlnak a vhostjt
HOST_HELP_CMD_DELALL
	    DELALL      Trli a vhosztot a nickekrl a csoportban
HOST_HELP_CMD_LIST
	    LIST        Kir egy vagy tbb vhost bejegyzst

HOST_OPER_HELP
	not used.

HOST_ADMIN_HELP
	not used.

HOST_HELP
	%S parancsok:

HOST_HELP_ON
	Syntax: ON

	Aktivlja a vhostodat, ami a nickhez lett trstva.
	Ha valaki csinl egy /whois parancsot a nickeden,
	akkor a vhostodat fogja ltni a valdi IP cmed vagy
	hosztneved helyett.

HOST_HELP_SET
	Syntax: SET <nick> <hostmask>.
	
	Belltja vhostnak a nick rszre a hosztmaszkot.
	Ha az IRCD tmogatja a vIdentet hasznld a SET
	<nick> <ident>@<hostmask>, bellitja az identet
	 s a hosztot a nick vhosztjaknt.
	
	Korltozva Hoszt vltoztatkra.

HOST_HELP_DELALL
	Syntax: DELALL <nick>.

	Trldik a vhost az sszes nickrl a csoportban ahol az
	adott nick van s ez a vhosztot hasznlta 
	
	Korltozva Hoszt vltoztatkra.

HOST_HELP_SETALL
	Syntax: SETALL <nick> <hosztmaszk>.

	Belltja a vhosztot sszes nick rszre aki a csoportban 
	van. Ha az IRCD tmogatja a vIdent, akkor hasznlja a 
	settall <nick> <ident>@<hosztnv> parancsot, ez belltja
	az adott identet s hosztot az sszes tag rszre vhosztknt.

	*Jegyzet: ez nem fogja frissteni a vhostot azoknak, akik
	a nickeket a csoportban a parancs utn jegyeztk	

	Korltozva Hoszt vltoztatkra.

HOST_HELP_OFF
	Syntax: OFF

	Kikapcsolja a vhostodat,ez most trsitva van a nickedhez.
	Ha valaki hasznl /whois parancsot a nickeden, akkor a
	vals IP cmed vagy hosztod fogja ltni.

HOST_HELP_DEL
	Syntax: DEL <nick>

	A vhost trlve az adott nick adatbzisbl.

	Korltozva Hoszt vltoztatkra.

HOST_HELP_LIST
	Syntax: LIST [<kulcs>|<#X-Y>]
	
	Ez parancs listzza a regisztrlt vhostokat az opertornak
	Ha egy kulcs meg van hatrozva, akkor csak a felttelnek
	megfelel vhostokat adja ki melyekben vagy a nickben vagy
	a hosztban szerepel a kulcs. Pl: Rob*

	Ha az #x-y stlust hasznlod, csak a megadott sorozatba
	tartoz X s Y kztti vhostok fognak megjelenni. Pldul
	az #1-3 csak az els 3 vhostot jelenti meg.

	A lista hasznlja NSListMax rtket, mint tg hatrrtket
	amikor megjelenti a tartalmat az opertornak.

	Korltozva Szervz opertorokra.

HOST_HELP_GROUP
	Syntax: GROUP
	
	Ez a parancs lehetv teszi, hogy a JELENLEGI nick
	vhostjt belltsuk a csoport minden nickjre.

OPER_SVSNICK_UNSUPPORTED
	Sorry, SVSNICK is not available on this network.

OPER_SQLINE_UNSUPPORTED
	Sorry, SQLINE is not available on this network.

OPER_SVSO_UNSUPPORTED
	Sorry, OLINE is not available on this network.

OPER_UMODE_UNSUPPORTED
	Sorry, UMODE is not available on this network.

OPER_SUPER_ADMIN_NOT_ENABLED
	SuperAdmin setting not enabled in services.conf

